// RequisiteListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "RequisiteListView.h"

#include "PSMDoc.h"
//#include "TreeProductItem.h"
//#include "aplTreeApprovalItem.h"
//#include "aplTreeCharacteristicItem.h"
//#include "aplCharacteristicGroupTreeItem.h"
#include "aplDocTreeItem.h"
//#include "apl_lot_item.h"
//#include "apl_prd_inst_item.h"
//#include "aplBPTreeItem.h"
//#include "aplBPInstTreeItem.h"
//#include "act_res_treeitem.h"
//#include "aplProjectTreeItem.h"
//#include "aplDocCopyItem.h"
//#include "aplChangeTreeItem.h"
//#include "CaplRefusalTreeItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRequisiteListView

IMPLEMENT_DYNCREATE(CRequisiteListView, CaplListView)

CRequisiteListView::CRequisiteListView()
{
	SetUniqueName(_T("CRequisiteListView"));
}

CRequisiteListView::~CRequisiteListView()
{
}


BEGIN_MESSAGE_MAP(CRequisiteListView, CaplListView)
	//{{AFX_MSG_MAP(CRequisiteListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRequisiteListView drawing

void CRequisiteListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CRequisiteListView diagnostics

#ifdef _DEBUG
void CRequisiteListView::AssertValid() const
{
	CListView::AssertValid();
}

void CRequisiteListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CRequisiteListView message handlers

int CRequisiteListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	//  
	lpCreateStruct->style&=~(LVS_SORTASCENDING|LVS_SORTDESCENDING|LVS_AUTOARRANGE);

	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("*"),LVCFMT_CENTER,10);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,120);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,200);
	LIST.InsertColumn(3, APL_T("  "),LVCFMT_LEFT,300);
	LIST.InsertColumn(4, APL_T(""),LVCFMT_LEFT,500);
	LoadColumnWidths();

	//EnableSorting(false);

	return 0;
}

void CRequisiteListView::UpdateTreeItem(CaplTreeItem *item)
{
	//if(item==m_cur_item) return;
	CListCtrl &list=GetListCtrl();
	list.DeleteAllItems();
	m_cur_item=item;
	if(item==0) return;
	if(item->m_type!=APL_TREE_ITEM_DOCUMENT) return;	

	
	CaplAPI *m_api=&(item->m_doc->m_api);
	
	int i;
	CaplInstance *rev=0,*doc=0,*dt=0;
	CString buf;

	if(0!=((CaplDocTreeItem*)item)->m_rev)
	{
		rev=((CaplDocTreeItem*)item)->m_rev;
		m_api->m_data.GetAttr(rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, doc);
	}
	else
	{
		doc=((CaplDocTreeItem*)item)->m_inst;
		m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_apl_doc_active, rev);
	}

	if(0==rev || 0==doc)return;
	if(rev->GetType()==0 || rev->GetAccessmode()>aplRO )return;
	if(doc->GetType()==0 || doc->GetAccessmode()>aplRO)return;

	m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_doc_kind, dt);

	if(0!=dt) { if(0==dt->GetType() || dt->GetAccessmode()>aplRO) dt=0; }
	
	StartBusy();
	
	//CaplRequisiteTreeItem:: LoadAllRequisite(&(item->m_doc->m_api.m_data),);

	CString sBuf, sEntryId, sEntryName, sEntryDescr, sEntryValue;
	aplExtent aeEntriesValue;
	CaplMap map_entry_val;

	SetStatusString( APL_T("  "));

	m_api->m_doc_mgr.GetActualEntriesVal(rev, aeEntriesValue);

	SetStatusString(_T(""));
	SetRedraw(FALSE);

	for(i=0; i<aeEntriesValue.Size; ++i)
	{
		CaplInstance *entryVal=aeEntriesValue[i];
		if(0==entryVal) continue;
		if(entryVal->GetType()==0 || entryVal->GetAccessmode()>aplRO )continue;

		CaplInstance *ciEntry=0;
		m_api->m_data.GetAttr(entryVal, m_api->m_doc_mgr.a_doc_entry_val_entry, ciEntry);
		if(0==ciEntry) continue;

		map_entry_val.Add(ciEntry,entryVal);
	}

	//      
	if(0!=dt) 
	{
		aplExtent dtEntries;
		m_api->m_data.GetAttr(dt, m_api->m_doc_mgr.a_dt_entries, dtEntries);
		for(i=0; i<dtEntries.GetSize(); i++)
		{
			CaplInstance *iDtEntry=dtEntries[i];
			if(0==iDtEntry) continue;

			bool bOptional=true;
			CaplInstance *ciEntry=0;
			m_api->m_data.GetAttr(iDtEntry, m_api->m_doc_mgr.a_dt_entry_entry, ciEntry);
			m_api->m_data.GetAttr(iDtEntry, m_api->m_doc_mgr.a_dt_entry_opt, bOptional);
			if(0==ciEntry) continue;

			m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_id, sEntryId);
			m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_name, sEntryName);
			m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_descr, sEntryDescr);
			
			CaplInstance *entryVal=0;
			sEntryValue=_T("");
			int k=map_entry_val.QFindByIn(ciEntry);
			if(k>=0)
			{
				entryVal=(CaplInstance*)map_entry_val[k].out;
				if(0!=entryVal) m_api->m_data.GetAttr(entryVal, m_api->m_doc_mgr.a_doc_entry_val_val, sEntryValue);
				map_entry_val.Remove(k);
			}

			if(bOptional) sBuf=_T(""); else sBuf=_T("*");

			k=list.InsertItem(list.GetItemCount(),sBuf);
			list.SetItemData(k,(long)entryVal);
			list.SetItemText(k, 1, sEntryId);
			list.SetItemText(k, 2, sEntryName);
			list.SetItemText(k, 3, sEntryValue);
			list.SetItemText(k, 4, sEntryDescr);
		}
	}

	//       
	if(map_entry_val.GetSize()>0)
	{
		int k=LIST.InsertItem(LIST.GetItemCount(),_T(""));

		for(i=0; i<map_entry_val.GetSize(); i++)
		{
			CaplInstance *ciEntry=(CaplInstance*)map_entry_val[i].in;
			CaplInstance *entryVal=(CaplInstance*)map_entry_val[i].out;

			m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_id, sEntryId);
			m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_name, sEntryName);
			m_api->m_data.GetAttr(ciEntry, m_api->m_doc_mgr.a_entry_descr, sEntryDescr);
			m_api->m_data.GetAttr(entryVal, m_api->m_doc_mgr.a_doc_entry_val_val, sEntryValue);

			k=list.InsertItem(LIST.GetItemCount(),_T(""));
			list.SetItemData(k,(long)entryVal);
			list.SetItemText(k, 1, sEntryId);
			list.SetItemText(k, 2, sEntryName);
			list.SetItemText(k, 3, sEntryValue);
			list.SetItemText(k, 4, sEntryDescr);
		}
	}

	//SortColumn(m_aCombinedSortedColumns[0]);
	//SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CRequisiteListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	/*if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		ShowProterties(false,i);
	}*/
	CListView::OnLButtonDblClk(nFlags, point);
}

bool CRequisiteListView::ShowProterties(bool bTest, int item)
{
	if(bTest) return true;
	if(item<0) return false;

	/*CaplInstance *inst=(CaplInstance *)LIST.GetItemData(item);
	if(inst!=0)
	{
		CaplApprovalTreeItem *doc_item=new CaplApprovalTreeItem(0,m_cur_item->m_doc,inst);
		if(doc_item!=0) 
		{
			doc_item->ShowProperties();
			m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(doc_item));
		}
	}*/
	return false;
}

LRESULT CRequisiteListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
