// TabView.cpp : implementation file
//

#include "stdafx.h"
#include <apl_gui.h>
#include "psm.h"
#include "TabView.h"
#include "PSMDoc.h"
#include "TreeProductItem.h"
#include "aplListView.h"
#include "ProductStructureListView.h"
#include "CharactListView.h"
#include "EditablePropertiesView.h"
#include "ApprovalListView.h"
#include "RequisiteListView.h"
#include "DocsListView.h"
#include "AlternateListView.h"
#include "WhereUsedListView.h"
#include "PrdInstWhereUsedLV.h"
#include "PrdInstContentsLV.h"
#include "aplDocTreeItem.h"
#include "ProjectsListView.h"
#include "ClassifierListView.h"
#include "SubstListView.h"
#include "MailListView.h"
#include "MailFrame.h"
#include "MailRTFView.h"
#include "NotesView.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CString m_CurTabName= _T("");

/////////////////////////////////////////////////////////////////////////////
// CTabView
bool CTabView::show_excel_view = false;

IMPLEMENT_DYNCREATE(CTabView, CView)

CTabView::CTabView()
{
	m_tab_prop_view= 0;
	m_tab_characrerystic=-1;
	m_tab_editable_properties=-1;
	m_tab_parts=-1;
	m_tab_approvals=-1;
	m_tab_requisite=-1;
	m_tab_docs=-1;
	m_tab_prd_inst_contents=-1; 
	m_tab_prd_inst_whereused=-1;
	m_tab_projects=-1;
	m_tab_substitutes=-1;
	m_tab_mail= -1;
	m_tab_message= -1;

	m_pFindWnd = 0;

	m_item_new=0;
	m_item_old=0;
	m_cur_view=0;
	
	m_ProdStructureView=0;
	m_PrdInstContentsListView=0;
	m_PrdInstWhereUsedListView=0;
	m_CharactView=0;
	m_EditablePropertiesView=0;
	m_ApprovalView=0;
	m_RequisiteView=0;
	m_DocsView=0;
	m_AltView=0;
	m_PrjView=0;
	m_SubstView=0;
	m_ClassifierView=0;
	m_WhereUsedView=0;
	m_wndMailBodyFrame= 0;
	m_tick_prev_connect = 0;

	m_pNotesView = NULL;
	
	m_UpdateMode=true;
	m_attached=false;
}

CTabView::~CTabView()
{
}


BEGIN_MESSAGE_MAP(CTabView, CView)
	//{{AFX_MSG_MAP(CTabView)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_NOTIFY (TCN_SELCHANGE , ID_TAB_CTRL, OnTabChange)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabView drawing

void CTabView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	//if(m_cur_view!=0) m_cur_view->Invalidate();
}

/////////////////////////////////////////////////////////////////////////////
// CTabView diagnostics

#ifdef _DEBUG
void CTabView::AssertValid() const
{
	CView::AssertValid();
}

void CTabView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTabView message handlers
//***********************************************************************
int CTabView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO: Add your specialized creation code here
	RECT rect={-1,0,100,100};
	m_tab.Create(TCS_TABS|TCS_SINGLELINE|WS_VISIBLE,rect,this,ID_TAB_CTRL);


	LOGFONT m_lf;
	ZeroMemory ((PVOID) &m_lf,sizeof (LOGFONT));
	NONCLIENTMETRICS nm;
	nm.cbSize = sizeof (NONCLIENTMETRICS);
	if(SystemParametersInfo (SPI_GETNONCLIENTMETRICS,nm.cbSize,&nm,0))
	{
		DWORD err= GetLastError();
		m_lf =  nm.lfMenuFont;
		m_font.DeleteObject();
		m_font.CreateFontIndirect (&m_lf);
	}
	else 
		m_font.CreateFont(-11,0,0,0,FW_NORMAL,0,0,0,0,0,0,0,0,_T("Tahoma"));

	m_tab.SetFont(&m_font);

	if(aplGetBitPerPixel(0)>8)
	{
//		CBitmap bm;
//		bm.LoadBitmap(IDB_SHOW_CMD_TB);
//
//		imagelist.Create(20, 16, ILC_COLOR24|ILC_MASK, 0, 100);
//		imagelist.Add(&bm, RGB(192,192,192));
//		bm.DeleteObject();
		m_tab.SetImageList(aplGetTabCtrlImageList());
	}
	else
	{
		imagelist.Create(IDR_SHOW_CMD_TB,20,2,RGB(255,0,255));
		m_tab.SetImageList(&imagelist);
	}

	return 0;
}
//***********************************************************************
void CTabView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	m_tab.MoveWindow(-1,0,cx+3,cy+2);

	RECT rect,rect1;
	m_tab.GetItemRect(0, &rect1); 
	m_tab.GetClientRect(&rect);
	int top=rect1.bottom+4;
	if(m_ProdStructureView!=0) m_tab_prop_view->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_ProdStructureView!=0) m_ProdStructureView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_CharactView!=0) m_CharactView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_EditablePropertiesView!=0) m_EditablePropertiesView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_ApprovalView!=0) m_ApprovalView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_RequisiteView!=0) m_RequisiteView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_DocsView!=0) m_DocsView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_ClassifierView!=0) m_ClassifierView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_AltView!=0) m_AltView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_WhereUsedView!=0) m_WhereUsedView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_PrdInstContentsListView!=0) m_PrdInstContentsListView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_PrdInstWhereUsedListView!=0 && ::IsWindowVisible(m_PrdInstWhereUsedListView->m_hWnd)) m_PrdInstWhereUsedListView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_PrjView!=0) m_PrjView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_SubstView!=0) m_SubstView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_pNotesView!=NULL) m_pNotesView->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(m_pFindWnd!=NULL) m_pFindWnd->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
	if(::IsWindow(m_wndMailSplitter.m_hWnd))
		m_wndMailSplitter.MoveWindow(4, top, rect.right - rect.left-8, 	rect.bottom - rect.top-top-8);
	if(m_wndMailBodyFrame && ::IsWindow(m_wndMailBodyFrame->m_hWnd))
		m_wndMailBodyFrame->MoveWindow(2, top, rect.right - rect.left-5, 	rect.bottom - rect.top-top-3);
	CPSMDoc* doc = (CPSMDoc*)GetDocument();
	if(doc!=0)
		for(int i=0; i<doc->m_addin_tab_views.GetSize();i++)
			if(doc->m_addin_tab_views.GetAt(i)->viewtype==aplTab)
				doc->m_addin_tab_views.GetAt(i)->view->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);

}
//***********************************************************************
void CTabView::OnTabChange(NMHDR * hdr, LRESULT * NotUsed)
{
	CWnd *prev_view = m_cur_view;
	if(NotUsed!=0)*NotUsed=1;
	if(m_cur_view!=0)
	{
		UINT msg = ((CPSMApp*)AfxGetApp())->m_view_update;
		::SendMessage(m_cur_view->m_hWnd, msg, /*APL_POSTUPDATE_TREE_ITEM*/3, LPARAM(NULL));
		m_cur_view->ShowWindow(SW_HIDE);
	}
	TC_ITEM item;
	item.mask=TCIF_PARAM;
	int i=m_tab.GetCurSel();

	//  
	TCITEM tcItem;
	tcItem.mask= TCIF_PARAM|TCIF_TEXT;
	tcItem.pszText= m_CurTabName.GetBuffer(256);
	tcItem.cchTextMax = 256;
	m_tab.GetItem(i, &tcItem);	
	m_cur_view = (CView*)tcItem.lParam;
	m_CurTabName.ReleaseBuffer();
	
	if(m_cur_view!=0) 
	{
		UINT msg = ((CPSMApp*)AfxGetApp())->m_view_update;
		::SendMessage(m_cur_view->m_hWnd,msg,APL_UPDATE_TREE_ITEM,LPARAM(m_item_new));
		if(m_item_new!=0)
		{	
			CaplUpdateItem ii;
			ii.app = &m_item_new->m_doc->m_app;
			aplExtent ext;
			m_item_new->GetAccessedInstances(ext);
			ii.inst = ext[0];
			::SendMessage(m_cur_view->m_hWnd,msg,APL_UPDATE_INST_ITEM,LPARAM(&ii));

			RECT rect,rect1;
			m_tab.GetItemRect(0, &rect1); 
			m_tab.GetClientRect(&rect);
			int top=rect1.bottom+4;
			m_cur_view->MoveWindow(2,top,rect.right-rect.left-5,rect.bottom-rect.top-top-3);
			Invalidate();
			m_cur_view->ShowWindow(SW_SHOW);
			m_cur_view->Invalidate();
		}
	}
	if(prev_view!=0 && prev_view!=m_cur_view)
	{
		UINT msg = ((CPSMApp*)AfxGetApp())->m_view_update;
		::SendMessage(prev_view->m_hWnd,msg,APL_UPDATE_TREE_ITEM,LPARAM(0));
	
	}
}
//ActivatePlugnsTab(APL_DOC_ITEM);
void CTabView::ActivatePlugnsTab(int item_type, TCITEM &tcItem)
{
	CPSMDoc* doc = (CPSMDoc*)GetDocument();
	CaplViewInfo* vi;
	for(int i=0; i<doc->m_addin_tab_views.GetSize();i++)
	{
		vi = doc->m_addin_tab_views.GetAt(i);
		if(vi->type&item_type  && vi->viewtype==aplTab && vi->show) 
		{
			if(vi->pos<1) vi->pos = 1;
			if(vi->pos>m_tab.GetItemCount()) vi->pos = m_tab.GetItemCount();
			int ind_ = vi->pos = m_tab.InsertItem(vi->pos,vi->tab_name);
			tcItem.iImage = -1;
			CImageList *il=m_tab.GetImageList();
			if(il!=0)
			{
				HICON ico=(vi->view)->GetIcon(FALSE);
				if(0!=ico)
				{
					int index=m_map_hicon2index.GetByIn((long)ico);
					if(index<0)
					{
						HICON icon2=aplResizeIcon(ico, CaplMenu::m_icon_size.cx, CaplMenu::m_icon_size.cy);
						if(0!=icon2)
						{
							index=il->Add(icon2);
							::DestroyIcon(icon2);
						}
						else index=il->Add(ico);

						m_map_hicon2index.Add((long)ico,index);
					}
					tcItem.iImage=index;
				}

			}
			tcItem.pszText = vi->tab_name.GetBuffer(0);
			tcItem.lParam = (LPARAM)vi->view;
			m_tab.SetItem(ind_, &tcItem);
		}
	}
}

//***********************************************************************
void CTabView::Update(CaplTreeItem *item, bool bDirect)
{
	if(!m_UpdateMode) return;
	//if(item==m_item_old) return;
	m_item_new=item;
//	OnTabChange(0,0);

	//    
	static int pos_prd_tab=0,pos_pdf_tab=0,pos_doc_tab=0,pos_charact_tab=0;
	static int pos_lot_tab=0,pos_categ_tab=0, pos_bp_tab=0,pos_bp_inst_tab=0,pos_tab=0;
	static int pos_charact_group_tab=0,pos_bp_resource=0,pos_project_tab=0,pos_change_tab=0;
	static int pos_organization_tab=0, pos_person_tab=0, pos_folder_tab=0, pos_approval_tab=0;
	static int pos_mail_tab=0,pos_classifier_tab=0, pos_main_mail_tab= 0, pos_message_tab= 0,pos_doc_copy_tab=0;
	static int pos_task_tab=0,pos_process_tab=0;
	static int pos_refusal_tab=0;
	int i=m_tab.GetCurSel();
	if(m_item_old!=0)
	{
		// :     item    -       
		// :      
		if(!bDirect && m_item_old==item){
			return;
		}
		if(m_item_old->m_type==APL_TREE_ITEM_PRODUCT) 
		{
			if(((CaplProductTreeItem*)m_item_old)->m_pdf==0)pos_prd_tab=i;
			else pos_pdf_tab=i;
		}
		else if(m_item_old->m_type==APL_TREE_ITEM_DOCUMENT) pos_doc_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_CHARACTERISTIC) pos_charact_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_LOT) pos_lot_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_PRDINST) pos_lot_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_REFUSAL) pos_refusal_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_CATEGORIES) pos_categ_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_BP) pos_bp_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_BPINST) pos_bp_inst_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP) pos_charact_group_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_BPRES) pos_bp_resource=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_PROJECT) pos_project_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_ORGANIZATION) pos_organization_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_PERSON || m_item_old->m_type==APL_TREE_ITEM_OFFICIAL) pos_person_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_FOLDER) pos_folder_tab = i;
		else if(m_item_old->m_type==APL_TREE_ITEM_MESSAGEFOLDER) pos_mail_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_MESSAGE)pos_message_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM) pos_classifier_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_CLASSIFIERLEVEL) pos_classifier_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_CHANGE) pos_change_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_TASK) pos_task_tab=i;
		else if(m_item_old->m_type==APL_TREE_ITEM_PROCESS) pos_process_tab=i;
		else if(m_item_old->m_type==_T("DocHardCopy")) pos_doc_copy_tab=i;
		else if(m_item_old->m_type==_T("Approval")) pos_approval_tab=i;
		else pos_tab=i;
	}

	//  
	m_tab.DeleteAllItems( );
	m_tab_parts=-2;
	m_tab_characrerystic=-2;
	m_tab_editable_properties=-2;
	m_tab_docs=-2;
	m_tab_approvals=-2;
	m_tab_requisite=-2;
	m_tab_alternate=-2;
	m_tab_WhereUsed=-2;
	m_tab_prd_inst_contents=-2;
	m_tab_prd_inst_whereused=-2;
	m_tab_excel_view = -2;
	m_tab_projects=-2;
	m_tab_substitutes=-2;
	m_tab_mail= -2;
	m_tab_message= -2;
	
	int ind_ = -1;
	if(item!=0)
	{
		//  
		m_tab_prop=m_tab.InsertItem(0,_T(""),0);
		TCITEM tcItem;
		tcItem.mask = TCIF_IMAGE|TCIF_PARAM|TCIF_TEXT;		
		tcItem.iImage = 0;
		tcItem.pszText = _T("");
		tcItem.lParam = (LPARAM)m_tab_prop_view;
		m_tab.SetItem(m_tab_prop, &tcItem);
		m_tab_prop_view->GetListCtrl().DeleteAllItems();
		item->ShowInListCtrl(&(m_tab_prop_view->GetListCtrl()));
		CPSMDoc* doc = (CPSMDoc*)GetDocument();

		ind_ = m_tab.InsertItem(2, APL_T("  "),16);
		tcItem.iImage = 16;
		tcItem.pszText =  (LPTSTR)APL_T("  ");
		if(m_pFindWnd != 0 && m_tick_prev_connect!=doc->m_tick_connect)
		{
			m_pFindWnd->DestroyWindow();delete m_pFindWnd;m_pFindWnd=0;
		}
		if(m_pFindWnd == 0)
		{
			POSITION pos = AfxGetApp()->GetFirstDocTemplatePosition();
			CCreateContext pContext;
			pContext.m_pCurrentDoc = doc;
			pContext.m_pCurrentFrame = NULL;
			pContext.m_pNewDocTemplate = AfxGetApp()->GetNextDocTemplate(pos);

			m_pFindWnd = aplCreateQuerySplitter(&m_tab,&(GetActiveDocument()->m_api),&pContext);

		}
		tcItem.lParam = (LPARAM)m_pFindWnd;
		m_tab.SetItem(ind_, &tcItem);


		if(item->m_type==APL_TREE_ITEM_PRODUCT)
		{
			if(((CaplProductTreeItem*)item)->m_pdf!=0)
			{
				m_tab_parts=m_tab.InsertItem(1, APL_T(""),4);
				tcItem.iImage = 4;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ProdStructureView;
				m_tab.SetItem(m_tab_parts, &tcItem);
			}			
			ind_ = m_tab_characrerystic=m_tab.InsertItem(2, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(3, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(4, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_alternate=m_tab.InsertItem(5, APL_T(""),5);
				tcItem.iImage = 5;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_AltView;
				m_tab.SetItem(ind_, &tcItem);
			if(((CaplProductTreeItem*)item)->m_pdf!=0)
			{
				ind_ = m_tab_WhereUsed=m_tab.InsertItem(6, APL_T(" "),6);
					tcItem.iImage = 6;
					tcItem.pszText =  (LPTSTR)APL_T(" ");
					tcItem.lParam = (LPARAM)m_WhereUsedView;
					m_tab.SetItem(ind_, &tcItem);

				ActivatePlugnsTab(APL_PDF_ITEM,tcItem);
			}
			ind_ = m_tab_projects=m_tab.InsertItem(7, APL_T(""),7);
				tcItem.iImage = 7;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_PrjView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(8, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);

			if(((CaplProductTreeItem*)item)->m_pdf!=0 && ((CaplProductTreeItem*)item)->m_nauo!=0)
			{
				ind_ = m_tab_substitutes=m_tab.InsertItem(8, APL_T("   "),8);
					tcItem.iImage = 8;
					tcItem.pszText =  (LPTSTR)APL_T("   ");
					tcItem.lParam = (LPARAM)m_SubstView;
					m_tab.SetItem(ind_, &tcItem);
			}
			
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);

			if(((CaplProductTreeItem*)item)->m_pdf==0)
			{
				ActivatePlugnsTab(APL_PRD_ITEM,tcItem);
				m_tab.SetCurSel(pos_prd_tab);
			}
			else m_tab.SetCurSel(pos_pdf_tab);

			/*ind_ = m_tab_editable_properties=m_tab.InsertItem(12, APL_T(""),1);
			tcItem.iImage = 0;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_EditablePropertiesView;
			m_tab.SetItem(ind_, &tcItem);*/
		}
		else if(item->m_type==APL_TREE_ITEM_DOCUMENT)
		{
			ind_ = m_tab_requisite=m_tab.InsertItem(1, APL_T(""),3);
				tcItem.iImage = 14;
				tcItem.pszText = (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_RequisiteView;
				m_tab.SetItem(ind_, &tcItem);

			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText = (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);

			ind_ = m_tab_substitutes=m_tab.InsertItem(3, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ind_ = m_tab_mail = m_tab.InsertItem(4, APL_T(""),9);
				tcItem.iImage = 9;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)&m_wndMailSplitter;
				m_tab.SetItem(ind_, &tcItem);

			ind_ = m_tab_docs=m_tab.InsertItem(5, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);

			ind_ = m_tab_characrerystic=m_tab.InsertItem(6, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);

			ind_ = m_tab_WhereUsed=m_tab.InsertItem(7, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);


			if(((CaplDocTreeItem*)item)->m_rev!=0)
			{
				ActivatePlugnsTab(APL_DOC_REVISION_ITEM,tcItem);
			}
			else
			{
				ActivatePlugnsTab(APL_DOC_ITEM,tcItem);
			}
			m_tab.SetCurSel(pos_doc_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_CHARACTERISTIC)
		{
			ind_ = m_tab_approvals=m_tab.InsertItem(1, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_characrerystic=m_tab.InsertItem(2, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_CHARACT_ITEM,tcItem);

			m_tab.SetCurSel(pos_charact_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_LOT)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(4, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

				ActivatePlugnsTab(APL_LOT_ITEM,tcItem);

			m_tab.SetCurSel(pos_lot_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_PRDINST)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_prd_inst_contents=m_tab.InsertItem(4, APL_T(""),4);
				tcItem.iImage = 4;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_PrdInstContentsListView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_prd_inst_whereused=m_tab.InsertItem(5, APL_T(" "),6);
				tcItem.iImage = 6;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_PrdInstWhereUsedListView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_projects=m_tab.InsertItem(6, APL_T(""),7);
				tcItem.iImage = 7;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_PrjView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(7, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

				ActivatePlugnsTab(APL_PRD_INST_ITEM,tcItem);

			m_tab.SetCurSel(pos_lot_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_REFUSAL)
		{
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
			tcItem.iImage = 3;
			tcItem.pszText =  (LPTSTR)APL_T(" ");
			tcItem.lParam = (LPARAM)m_ApprovalView;
			m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
			tcItem.iImage = 2;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_DocsView;
			m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_REFUSAL_ITEM,tcItem);

			m_tab.SetCurSel(pos_refusal_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_BP)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(4, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_BP_ITEM,tcItem);

			m_tab.SetCurSel(pos_bp_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_BPINST)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(4, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_BP_INST_ITEM,tcItem);
			
			m_tab.SetCurSel(pos_bp_inst_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_PROJECT)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(4, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_PROJECT,tcItem);
			
			m_tab.SetCurSel(pos_project_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_BPRES)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(3, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);
			m_tab.SetCurSel(pos_bp_resource);
		}
		else if(item->m_type==APL_TREE_ITEM_CHARACTERISTICGROUP)
		{
			//m_tab_characrerystic=m_tab.InsertItem(1,APL_T(""),1);
			ind_ = m_tab_approvals=m_tab.InsertItem(1, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(2, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);
			m_tab.SetCurSel(pos_charact_group_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_CATEGORIES)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(2, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(3, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);


				ActivatePlugnsTab(APL_CATEG_ITEM,tcItem);

			m_tab.SetCurSel(pos_categ_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_ORGANIZATION)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(2, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_ORG_ITEM,tcItem);
			
			m_tab.SetCurSel(pos_organization_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_CLASSIFIERSYSTEM ||item->m_type==APL_TREE_ITEM_CLASSIFIERLEVEL )
		{
//			ind_ = m_tab_characrerystic=m_tab.InsertItem(1,APL_T(""),1);
//				tcItem.iImage = 1;
//				tcItem.pszText = APL_T("");
//				tcItem.lParam = (LPARAM)m_CharactView;
//				m_tab.SetItem(ind_, &tcItem);
//			ind_ = m_tab_docs=m_tab.InsertItem(2,APL_T(""),2);
//				tcItem.iImage = 2;
//				tcItem.pszText = APL_T("");
//				tcItem.lParam = (LPARAM)m_DocsView;
//				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_CLASSIFIER_SYS_ITEM|APL_CLASSIFIER_LEVEL_ITEM,tcItem);
	
			m_tab.SetCurSel(pos_classifier_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_PERSON || item->m_type==APL_TREE_ITEM_OFFICIAL)
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(2, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_PERSON_ITEM,tcItem);

			m_tab.SetCurSel(pos_person_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_FOLDER)
		{
			ind_ = m_tab_docs = m_tab.InsertItem(1, APL_T(""),2);
				tcItem.iImage = 2;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_DocsView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_mail = m_tab.InsertItem(2, APL_T(""),9);
				tcItem.iImage = 9;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)&m_wndMailSplitter;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(3, APL_T(""),12);
				tcItem.iImage = 12;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_ClassifierView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_FOLDER_ITEM,tcItem);

			m_tab.SetCurSel(pos_folder_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_PROCESS)
		{
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_PROCESS,tcItem);

			m_tab.SetCurSel(pos_process_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_TASK)
		{
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);
			CaplViewInfo* vi;
			for(int i=0; i<doc->m_addin_tab_views.GetSize();i++)
			{
				vi = doc->m_addin_tab_views.GetAt(i);
				if(vi->type&APL_TASK_ITEM  && vi->viewtype==aplTab && vi->show) 
				{
					if(vi->pos<1) vi->pos = 1;
					if(vi->pos>m_tab.GetItemCount()) vi->pos = m_tab.GetItemCount();
					ind_ = vi->pos = m_tab.InsertItem(vi->pos,vi->tab_name);
						tcItem.iImage = -1;
						tcItem.pszText = vi->tab_name.GetBuffer(0);
						tcItem.lParam = (LPARAM)vi->view;
						m_tab.SetItem(ind_, &tcItem);
				}
			}
			ActivatePlugnsTab(APL_TASK_ITEM,tcItem);
			m_tab.SetCurSel(pos_task_tab);
		}
		else if(item->m_type==APL_TREE_ITEM_PROCESSTMPL)
		{
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);
			CaplViewInfo* vi;
			for(int i=0; i<doc->m_addin_tab_views.GetSize();i++)
			{
				vi = doc->m_addin_tab_views.GetAt(i);
				if(vi->type&APL_PROCESS_TMPL_ITEM  && vi->viewtype==aplTab && vi->show) 
				{
					if(vi->pos<1) vi->pos = 1;
					if(vi->pos>m_tab.GetItemCount()) vi->pos = m_tab.GetItemCount();
					ind_ = vi->pos = m_tab.InsertItem(vi->pos,vi->tab_name);
						tcItem.iImage = -1;
						tcItem.pszText = vi->tab_name.GetBuffer(0);
						tcItem.lParam = (LPARAM)vi->view;
						m_tab.SetItem(ind_, &tcItem);
				}
			}
			m_tab.SetCurSel(0);
		}		
		else if(item->m_type==APL_TREE_ITEM_ACTIVITY)
		{
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);

			ActivatePlugnsTab(APL_ACTIVITY_ITEM,tcItem);
			m_tab.SetCurSel(0);
		}
		else if(item->m_type==APL_TREE_ITEM_MESSAGE)
		{
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);
			CString buf=  APL_T("");
			ind_ = m_tab_mail=m_tab.InsertItem(1, buf, 9);
				tcItem.iImage = 9;
				tcItem.pszText = buf.GetBuffer(buf.GetLength()+1);
				tcItem.lParam = (LPARAM)m_wndMailBodyFrame;
				m_tab.SetItem(ind_, &tcItem);
				buf.ReleaseBuffer();
			m_tab.SetCurSel(pos_message_tab);				
		}
		else if(item->m_type==APL_TREE_ITEM_MESSAGEFOLDER)
		{
			CString buf, name;
			item->GetName(buf);

			if(buf== APL_T(""))
			{
				buf=  APL_T("");
				ind_ = m_tab_mail=m_tab.InsertItem(1, buf, 9);
					tcItem.iImage = 9;
					tcItem.pszText = buf.GetBuffer(buf.GetLength()+1);
					tcItem.lParam = (LPARAM)&m_wndMailSplitter;
					m_tab.SetItem(ind_, &tcItem);
					buf.ReleaseBuffer();				
				buf=  APL_T("");
				ind_ = m_tab_mail=m_tab.InsertItem(2, buf, 10);
					tcItem.iImage = 10;
					tcItem.pszText = buf.GetBuffer(buf.GetLength()+1);
					tcItem.lParam = (LPARAM)&m_wndMailSplitter;
					m_tab.SetItem(ind_, &tcItem);
					buf.ReleaseBuffer();				
				buf=  APL_T("");
				ind_ = m_tab_mail=m_tab.InsertItem(3, buf, 11);
					tcItem.iImage = 11;
					tcItem.pszText = buf.GetBuffer(buf.GetLength()+1);
					tcItem.lParam = (LPARAM)&m_wndMailSplitter;
					m_tab.SetItem(ind_, &tcItem);
					buf.ReleaseBuffer();				
				m_tab.SetCurSel(pos_mail_tab);				
			}
			else
			{
				UINT ico= 9;
				if(buf== APL_T("")) ico+=1;
				else if(buf== APL_T("")) ico+=2;
				
				name.Format( APL_T(" \"%s\""), buf);

				ind_ = m_tab_mail=m_tab.InsertItem(1, buf, ico);
					tcItem.iImage = ico;
					tcItem.pszText = buf.GetBuffer(buf.GetLength()+1);
					tcItem.lParam = (LPARAM)&m_wndMailSplitter;
					m_tab.SetItem(ind_, &tcItem);
					buf.ReleaseBuffer();
				m_tab.SetCurSel(pos_mail_tab);				
			}
		}
		else if(APL_TREE_ITEM_CHANGE)
		{
//			ind_ = m_tab_chitem->m_type==aracrerystic=m_tab.InsertItem(1,APL_T(""),1);
//			tcItem.iImage = 1;
//			tcItem.pszText = APL_T("");
//			tcItem.lParam = (LPARAM)m_CharactView;
//			m_tab.SetItem(ind_, &tcItem);
//			ind_ = m_tab_approvals=m_tab.InsertItem(2,APL_T(" "),3);
//			tcItem.iImage = 3;
//			tcItem.pszText = APL_T(" ");
//			tcItem.lParam = (LPARAM)m_ApprovalView;
//			m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_docs=m_tab.InsertItem(1,APL_T(""),2);
			tcItem.iImage = 2;
			tcItem.pszText = (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_DocsView;
			m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_WhereUsed=m_tab.InsertItem(4, APL_T(""),12);
			tcItem.iImage = 12;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_ClassifierView;
			m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(3, APL_T(""),8);
			tcItem.iImage = 13;
			tcItem.pszText =  (LPTSTR)APL_T("");
			tcItem.lParam = (LPARAM)m_pNotesView;
			m_tab.SetItem(ind_, &tcItem);
			m_tab.SetCurSel(pos_change_tab);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
			tcItem.iImage = 3;
			tcItem.pszText =  (LPTSTR)APL_T(" ");
			tcItem.lParam = (LPARAM)m_ApprovalView;
			m_tab.SetItem(ind_, &tcItem);
			m_tab.SetCurSel(pos_change_tab);	
		}
		else if(item->m_type==_T("DocHardCopy"))
		{
			ind_ = m_tab_characrerystic=m_tab.InsertItem(1, APL_T(""),1);
				tcItem.iImage = 1;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_CharactView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_approvals=m_tab.InsertItem(2, APL_T(" "),3);
				tcItem.iImage = 3;
				tcItem.pszText =  (LPTSTR)APL_T(" ");
				tcItem.lParam = (LPARAM)m_ApprovalView;
				m_tab.SetItem(ind_, &tcItem);
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);
			m_tab.SetCurSel(pos_doc_copy_tab);
		}
		else if(item->m_type==_T("Approval"))
		{
			ind_ = m_tab_substitutes=m_tab.InsertItem(1, APL_T(""),8);
				tcItem.iImage = 13;
				tcItem.pszText =  (LPTSTR)APL_T("");
				tcItem.lParam = (LPARAM)m_pNotesView;
				m_tab.SetItem(ind_, &tcItem);
			m_tab.SetCurSel(pos_approval_tab);
		}
		else m_tab.SetCurSel(0);

		m_tick_prev_connect=doc->m_tick_connect;
	}
	OnTabChange(0,0);
	m_item_old=item;
}	

//**************************************************************************************

//************************************************************************************

void CTabView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	if(m_tab_prop_view!=0) m_tab_prop_view->DestroyWindow();
	if(m_ProdStructureView!=0) m_ProdStructureView->DestroyWindow();
	if(m_CharactView!=0) m_CharactView->DestroyWindow();
	if(m_EditablePropertiesView!=0) m_EditablePropertiesView->DestroyWindow();
	if(m_ApprovalView!=0) m_ApprovalView->DestroyWindow();
	if(m_RequisiteView!=0) m_RequisiteView->DestroyWindow();
	if(m_ClassifierView!=0) m_ClassifierView->DestroyWindow();
	if(m_pFindWnd!=0) {m_pFindWnd->DestroyWindow();delete m_pFindWnd;m_pFindWnd=0;}
	if(m_DocsView!=0) m_DocsView->DestroyWindow();
	if(m_AltView!=0) m_AltView->DestroyWindow();
	if(m_WhereUsedView!=0) m_WhereUsedView->DestroyWindow();
	if(m_PrdInstContentsListView!=0) m_PrdInstContentsListView->DestroyWindow();
	if(m_PrdInstWhereUsedListView!=0) m_PrdInstWhereUsedListView->DestroyWindow();
	if(m_PrjView!=0) m_PrjView->DestroyWindow();
	if(m_SubstView!=0) m_SubstView->DestroyWindow();
	if(m_pNotesView!=NULL) m_pNotesView->DestroyWindow();
}

void CTabView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
	if(m_attached) return;
	m_attached=true;
	RECT rect={-1,0,100,100};
	
	m_tab_prop_view = (CaplListView*)(RUNTIME_CLASS(CaplListView)->CreateObject());
	m_tab_prop_view->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL,
		rect,&m_tab,ID_LIST_CTRL);
	m_tab_prop_view->ShowWindow(SW_HIDE);
	m_tab_prop_view->SetUniqueName(_T("property"));
	m_tab_prop_view->GetListCtrl().InsertColumn(0, APL_T(""),LVCFMT_LEFT,150);
	m_tab_prop_view->GetListCtrl().InsertColumn(1, APL_T(""),LVCFMT_LEFT,700);
	m_tab_prop_view->EnableSorting(false);

	m_ProdStructureView = (CProductStructureListView*)(RUNTIME_CLASS(CProductStructureListView)->CreateObject());
	m_ProdStructureView->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,
		rect,&m_tab,ID_LIST_CTRL);
	m_ProdStructureView->ShowWindow(SW_HIDE);

	m_CharactView = (CCharactListView*)(RUNTIME_CLASS(CCharactListView)->CreateObject());
	m_CharactView->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,
		rect,&m_tab,ID_LIST_CTRL);
	m_CharactView->ShowWindow(SW_HIDE);

	m_EditablePropertiesView = (CEditablePropertiesView*)(RUNTIME_CLASS(CEditablePropertiesView)->CreateObject());
	m_EditablePropertiesView->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,
		rect,&m_tab,ID_LIST_CTRL);
	m_EditablePropertiesView->ShowWindow(SW_HIDE);
	
	m_ApprovalView = (CApprovalListView*)(RUNTIME_CLASS(CApprovalListView)->CreateObject());
	m_ApprovalView->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,
		rect,&m_tab,ID_LIST_CTRL);
	m_ApprovalView->ShowWindow(SW_HIDE);

	m_RequisiteView = (CRequisiteListView*)(RUNTIME_CLASS(CRequisiteListView)->CreateObject());
	m_RequisiteView->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,
		rect,&m_tab,ID_LIST_CTRL);
	m_RequisiteView->ShowWindow(SW_HIDE);

	m_ClassifierView = (CClassifierListView*)(RUNTIME_CLASS(CClassifierListView)->CreateObject());
	m_ClassifierView->Create(0,0,WS_BORDER|WS_VISIBLE|LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,
		rect,&m_tab,ID_LIST_CTRL);
	m_ClassifierView->ShowWindow(SW_HIDE);

	m_DocsView = (CDocsListView*)(RUNTIME_CLASS(CDocsListView)->CreateObject());
	m_DocsView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_DocsView->ShowWindow(SW_HIDE);

	m_AltView = (CAlternateListView*)(RUNTIME_CLASS(CAlternateListView)->CreateObject());
	m_AltView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_AltView->ShowWindow(SW_HIDE);

	m_WhereUsedView = (CWhereUsedListView*)(RUNTIME_CLASS(CWhereUsedListView)->CreateObject());
	m_WhereUsedView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_WhereUsedView->ShowWindow(SW_HIDE);
	
	m_PrdInstContentsListView  = (CPrdInstContentsListView*)(RUNTIME_CLASS(CPrdInstContentsListView)->CreateObject());
	m_PrdInstContentsListView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_PrdInstContentsListView->ShowWindow(SW_HIDE);

	m_PrdInstWhereUsedListView= (CPrdInstWhereUsedListView*)(RUNTIME_CLASS(CPrdInstWhereUsedListView)->CreateObject());
	m_PrdInstWhereUsedListView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_PrdInstWhereUsedListView->ShowWindow(SW_HIDE);

	m_PrjView = (CProjectsListView*)(RUNTIME_CLASS(CProjectsListView)->CreateObject());
	m_PrjView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_PrjView->ShowWindow(SW_HIDE);

	m_SubstView = (CSubstListView*)(RUNTIME_CLASS(CSubstListView)->CreateObject());
	m_SubstView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_SubstView->ShowWindow(SW_HIDE);

	m_pNotesView = (CNotesView*)(RUNTIME_CLASS(CNotesView)->CreateObject());
	m_pNotesView->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW|
		LVS_REPORT|LVS_SINGLESEL|LVS_SORTASCENDING,	rect,&m_tab,ID_LIST_CTRL_DOC);
	m_pNotesView->ShowWindow(SW_HIDE);

	POSITION pos = AfxGetApp()->GetFirstDocTemplatePosition();
	CCreateContext pContext;
	pContext.m_pCurrentDoc = GetDocument();
	pContext.m_pCurrentFrame = NULL;
	pContext.m_pNewDocTemplate = AfxGetApp()->GetNextDocTemplate(pos);

	m_wndMailSplitter.CreateStatic(this, 2, 1, WS_CHILD|WS_VISIBLE);
	pContext.m_pNewViewClass = RUNTIME_CLASS(CMailListView);
	m_wndMailSplitter.CreateView(0, 0, RUNTIME_CLASS(CMailFrame), CSize(100, 100), &pContext);
	pContext.m_pNewViewClass = RUNTIME_CLASS(CMailRTFView);
	m_wndMailSplitter.CreateView(1, 0, RUNTIME_CLASS(CMailBodyFrame), CSize(100, 100), &pContext);
	m_wndMailSplitter.SetRowInfo(0, 450, 0);
	m_wndMailSplitter.ShowWindow(SW_HIDE);
	
	pContext.m_pNewViewClass = RUNTIME_CLASS(CMailRTFView);
	m_wndMailBodyFrame= (CMailBodyFrame*)RUNTIME_CLASS(CMailBodyFrame)->CreateObject();
	m_wndMailBodyFrame->Create(NULL, NULL, WS_CHILD|WS_HSCROLL, CRect(0, 0, 100, 100), this, NULL, 0, &pContext);	
	
	m_tab.SetExtendedStyle(TCS_EX_FLATSEPARATORS,1);
	m_tab.SetMinTabWidth(15);
	m_tab_prop=m_tab.InsertItem(0,_T(""),0);
/*
	m_tab_parts=m_tab.InsertItem(0,APL_T(""));
	m_tab_characrerystic=m_tab.InsertItem(1,APL_T(""));
	m_tab_approvals=m_tab.InsertItem(2,APL_T(" "));
	m_tab_docs=m_tab.InsertItem(3,APL_T(""));
	m_tab_alternate=m_tab.InsertItem(4,APL_T(""));
*/
	OnTabChange(0,0);
}

void CTabView::AttachToDoc(CDocument *doc)
{
//	CDocument *doc=GetDocument();
	if(doc==0)
	{
		if(AfxGetMainWnd()!=0)
			doc= ((CFrameWnd*)AfxGetMainWnd())->GetActiveDocument( );
	}
	if(doc!=0) 
	{
		doc->AddView(this);
		doc->AddView(m_tab_prop_view);
		doc->AddView(m_ProdStructureView);
		doc->AddView(m_CharactView);
		doc->AddView(m_EditablePropertiesView);
		doc->AddView(m_ApprovalView);
		doc->AddView(m_RequisiteView);
		doc->AddView(m_DocsView);
		doc->AddView(m_AltView);
		doc->AddView(m_PrdInstContentsListView);
		doc->AddView(m_PrdInstWhereUsedListView);
		doc->AddView(m_PrjView);
		doc->AddView(m_SubstView);
		doc->AddView(((CFrameWnd*)m_wndMailSplitter.GetPane(0, 0))->GetActiveView());
		doc->AddView(((CFrameWnd*)m_wndMailSplitter.GetPane(1, 0))->GetActiveView());
		doc->AddView(m_wndMailBodyFrame->GetActiveView());
		doc->AddView(m_pNotesView);
		((CPSMDoc*)doc)->m_tab_view=this;
		((CPSMDoc*)doc)->LoadPSMAddIns();
	}
}
LRESULT CTabView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_DOC)
			((CPSMDoc*)GetDocument())->OnRefreshAllTreeItem();
		else if(wParam==APL_UPDATE_TREE_ITEM)
			m_item_new->RefreshItem();
	}

	return CView::WindowProc(message, wParam, lParam);
}

void CTabView::OnPaint()
{
	if(this==0) return;
	CView::OnPaint();
	if(m_cur_view!=0) 
		// m_cur_view->RedrawWindow();  //   
		m_cur_view->Invalidate();
}

BOOL CTabView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default
	return TRUE;
	//return CView::OnEraseBkgnd(pDC);
}
