#if !defined(AFX_TABVIEW_H__0E5D5795_D813_11D3_B869_84C0D43DE75A__INCLUDED_)
#define AFX_TABVIEW_H__0E5D5795_D813_11D3_B869_84C0D43DE75A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TabView.h : header file
//
#include "aplCharactView.h"
#include "MailSplitterWnd.h"
#include "MailFrame.h"

/////////////////////////////////////////////////////////////////////////////
// CTabView view
class CaplTreeItem;
class CaplListView;
class CProductStructureListView;
class CCharactListView;
class CEditablePropertiesView;
class CApprovalListView;
class CRequisiteListView;
class CAlternateListView;
class CWhereUsedListView;
class CPrdInstContentsListView;
class CPrdInstWhereUsedListView;
class CProjectsListView;
class CSubstListView;
class CDocsListView;
class CClassifierListView;
class CNotesView;

class CTabView : public CView
{
protected:
	CTabView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CTabView)

// Attributes
public:
	bool m_UpdateMode;
	DWORD m_tick_prev_connect;


	static bool show_excel_view;
// Operations
public:
	void Update(CaplTreeItem *item, bool bDirect= false);
	void AttachToDoc(CDocument *doc);
	void ActivatePlugnsTab(int item_type, TCITEM &tcItem);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTabView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CTabView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	CTabCtrl m_tab;
	CImageList imagelist;
	CFont m_font;
	
	bool m_attached;

	CaplMap m_map_hicon2index;
	
//	CView *m_cur_view;
	CWnd *m_cur_view;
	CaplListView *m_tab_prop_view;
	CProductStructureListView *m_ProdStructureView;
	CCharactListView *m_CharactView;
	CEditablePropertiesView *m_EditablePropertiesView;
	CApprovalListView *m_ApprovalView;
	CRequisiteListView *m_RequisiteView;
	CAlternateListView *m_AltView;
	CWhereUsedListView *m_WhereUsedView;
	CPrdInstContentsListView *m_PrdInstContentsListView;
	CPrdInstWhereUsedListView *m_PrdInstWhereUsedListView;
	CProjectsListView *m_PrjView;
	CSubstListView *m_SubstView;
	CClassifierListView *m_ClassifierView;
	CNotesView			*m_pNotesView;
	CSplitterWnd* m_pFindWnd;

	CMailSplitterWnd m_wndMailSplitter;
	CMailBodyFrame* m_wndMailBodyFrame;
	
	int m_tab_prop, m_tab_characrerystic, m_tab_parts, m_tab_approvals, m_tab_requisite;
	int m_tab_docs,m_tab_alternate,m_tab_WhereUsed;
	int m_tab_prd_inst_contents, m_tab_prd_inst_whereused, m_tab_excel_view; 
	int m_tab_projects, m_tab_editable_properties;
	int m_tab_substitutes, m_tab_mail, m_tab_message;

public:
	void OnPaint();
	CaplTreeItem *m_item_old;
	CaplTreeItem *m_item_new;
	CDocsListView *m_DocsView;

protected:
	afx_msg void OnTabChange(NMHDR *hdr, LRESULT *NotUsed);
	//{{AFX_MSG(CTabView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TABVIEW_H__0E5D5795_D813_11D3_B869_84C0D43DE75A__INCLUDED_)
