#include "aplTreeItem.h"

//class CaplProductTreeItem;
#ifndef  APL_ACTION_ITEM_DEFINITION
#define  APL_ACTION_ITEM_DEFINITION

class CaplFolderTreeItem;
class CaplInstance;

class CaplBPTreeItem : public CaplTreeItem
{
public:
	CaplInstance *m_inst;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_subitem;
	CaplInstance *m_rel;
	CaplInstance *m_project;
	CaplInstance *m_par_bp;
	
	CaplBPTreeItem *m_parent;
	CaplInstance *m_rev;
	CaplInstance *m_pLockInfo;
	CaplBPTreeItem *m_parent_bp_item;
	
	bool m_has_version;
	bool m_bWhereUsed; //   true,   Item   " ".    .

	int m_index;

	aplExtent m_all_res;
	aplExtent m_sub_bps;
	aplExtent m_parent_bps;

	CaplBPTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *inst=0);
	~CaplBPTreeItem(){RemoveFromParenContents(m_inst);}

    bool CreateTreeItem(HTREEITEM parent_item); 
	bool GetName(CString &name);
    bool RefreshItem();
	bool RefreshAllThisBPItem();
	bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	bool Expand(UINT action);
	bool ExpandTree(const aplExtent &extTree, int index);
	bool PasteItem(CaplTreeItem *item, CPoint *point);
	bool PasteFile(LPCTSTR file, CPoint *point);

	void ShowProperties();
	bool ShowInListCtrl(CListCtrl *list);
 	void GetAccessedInstances(aplExtent &ext);

	void CreateCharacteristic(CaplInstance *val=0);
	void CreateCharacteristicGroup(CaplInstance *group=0);
	void CreateBP(CaplInstance *inst_for_id);
	void CreateBPInst();
	void CreateBPResource();
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
	void ShowAllBaseObjects();
	void ShowAllResources(bool showMsg = true);
	void ShowAllVersion(bool showMsg = true);
	void ShowAllBPInst();
	CaplBPTreeItem* GetParentBPItem(CaplBPTreeItem *item); 
	//   ext    inst   
	void GetAllSubBP(CaplInstance *inst, aplExtent &ext);
	void ShowAllCharacteristic(bool showMsg = true);
	void InsertRevisionInTree(aplExtent &ext_rev,CaplBPTreeItem *parent_bp_item);
	void HideAllVersion();
	void CheckOut();
	void CheckIn();
	void UndoCheckOut();
	void RemoveRelation();
	bool ConvertToCustomizedCopy();
};

#endif