// aplProjectTreeItem.cpp: implementation of the CaplProjectTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplProjectTreeItem.h"
#include "PSMDoc.h"
#include "resource.h"
#include "TabView.h"
#include "aplTreeApprovalItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplDocTreeItem.h"
#include "TreeProductItem.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "ChooseStatusDlg.h"
#include "aplFolderTreeItem.h"
#include "aplTreeProcessItem.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplProjectTreeItem::CaplProjectTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
		CaplInstance *inst)
{
	m_type=APL_TREE_ITEM_PROJECT;
	m_tree=tree;
	m_doc=doc;
	m_inst=inst;
	m_index=-1;
	m_folder=0;
	m_classifier=0;
	m_parent=0;
	m_is_in_content=false;
	m_parent_item=0;
	m_subitem=0;
	m_rev=0;
	m_pLockInfo=0;
	m_parent_project_item=0;
	m_has_version=false;
	m_alert=0;
	m_rel=0;
	if(doc!=0) 
	{
		doc->m_items.Add(this);
	}
}

CaplProjectTreeItem::~CaplProjectTreeItem()
{
	RemoveFromParenContents(m_inst);
}

//****************************************************************
bool CaplProjectTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	CString buf=_T("");
	GetName(buf);
//	CaplInstance *parent=0;
//	m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_parent,parent);
	int ico=ICON_PROJECT;
/*	if(parent)
	{
		//ico++;
		if(!m_is_in_content) ico+=8;
	}
	if(m_subitem) ico+=5;*/
	
	InsetItem(buf,ico,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}
//****************************************************************
bool CaplProjectTreeItem::GetName(CString &name)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	CHECK_GET_NAME(m_inst);

	CString buf;
	CaplInstance *ver=0;
	if(m_rev) ver=m_rev;
	else ver=m_doc->m_project_mgr->CheckMyLock(m_inst,false);

	if(!m_rev) if(m_index>=0) name.Format(_T("%3i"),m_index); 
				
/*	if(CaplProjectManager::m_bShowId)
	{
		if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_id,buf);
		else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_id,buf);
		if(buf!=_T(""))
		{
			if(name!=_T('?')) name+=_T(" : "); else name=_T("");
			name+=buf;
		}
	}
	if(CaplProjectManager::m_bShowName)
	{
		if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_name,buf);
		else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_name,buf);
		if(buf!=_T(""))
		{
			if(name!=_T('?')) name+=_T(" : "); else name=_T("");
			name+=buf;
		}
	}*/
	CString tmp;
	CaplInstance *inst = ver==0 ? m_inst : ver;
	m_doc->m_api.GetItemName(inst,tmp);
	if(name==_T("???")) name = tmp;
	else 
	{		
		if(m_doc->m_api.m_show.m_show_project_number) name = name +_T(" : ") + tmp;	
		else name = tmp;
	}

	return true;
}

//****************************************************************
bool CaplProjectTreeItem::RefreshItem()
{
	CString buf;
	GetName(buf);
	if(m_tree!=0) m_tree->SetItemText(m_item,buf);
	
	int ico;

	m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_locker_adm_version,m_pLockInfo);
	
	if(m_rev)
	{
		ico = m_doc->m_api.GetInstIco(m_rev);
		CaplInstance *act=0;
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_act_adm_version,act);
		SetItemImage(ICO_REL_VER, IDX_IL_TREE_REL_TYPE);
		if(act==m_rev)
			SetItemImage(ICO_REL_ACTIVE_VER, IDX_IL_TREE_REL_TYPE);
	}
	else
	{
		ico = m_doc->m_api.GetInstIco(m_inst);
	/*	CaplInstance *type=0;
		buf=_T("");
		
		CaplInstance *my_lock=m_doc->m_project_mgr->CheckMyLock(m_inst,false);
		if(my_lock) m_doc_data.GetAttr(my_lock,m_doc->m_project_mgr->a_project_adm_ver_type,type);
		else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_type,type);
		if(type) m_doc_data.GetAttr(type,m_doc->m_project_mgr->a_project_type_name,buf);
		
		if(buf==APL_T("")) 
		{*/
			int ico_state=1;
			CString state=_T("");
			m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_state,state);
			if(state== APL_T(" ")) ico_state++;
			else if(state== APL_T("")) ico_state+=2;
			else if(state== APL_T("")) ico_state+=3;
			else if(state== APL_T("")) ico_state+=4;

			SetItemImage(ico_state,IDX_IL_TREE_OBJ_STATE);
	//	}
		if(m_subitem)
			SetItemImage(ICO_REL_WHERE_USED,IDX_IL_TREE_REL_TYPE);
	
		if(m_has_version)
		{ 
			HideAllVersion();	
			ShowAllVersion();
		}
	}

	SetItemImage(ico, IDX_IL_TREE_ITEM);
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}

//****************************************************************
void CaplProjectTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_inst==0) return;
	
	bool b_read_only=false;

										 // 22.02.2004 dmibor
	//if(!m_doc->m_project_mgr->IsAdmin())//  ,       
	//	b_read_only=true;				 // 

	CaplInstance *inst=m_inst;
	if(m_rev) inst=m_rev;
	if(m_doc->m_project_mgr->ShowProjectProperties(inst,b_read_only))
	{
		if(m_tree)
		{
			Expand(1); 
			Expand(2);
			RefreshItem();	
		}
	}
}
//****************************************************************
bool CaplProjectTreeItem::Expand(UINT action)
{
	if(action==TVE_EXPAND)
	{
		if(m_expanded) return true;
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		if(m_hasSubItem)Expand(1);
		if(m_ShowContentsOnExpand)
		{
			StartBusy();
			int i;

			aplExtent ext_cont;
			CaplInstance *inst=m_inst;
			if(m_rev) inst=m_rev;
			m_doc->m_project_mgr->GetAllSubProject(inst,ext_cont);

			m_doc->m_project_mgr->LoadProjectInfo(ext_cont);
			for(i=0;i<ext_cont.GetSize();i++)
			{
				CaplProjectTreeItem *sub_item=0;
				InsertInstInTree(ext_cont[i],m_item,m_doc,m_tree,m_sub_projects,0,(CaplTreeItem **)(&sub_item));
				if(sub_item!=0)
				{
					sub_item->m_index=m_sub_projects.Size;
					sub_item->m_parent=m_inst;
					sub_item->m_parent_item=this;
					sub_item->m_is_in_content=true;
					sub_item->RefreshItem();
				}
			}

			if(!m_rev && m_doc->m_project_mgr->m_show_ass_projects)
			{
				aplExtent ext_ass;
				m_doc->m_project_mgr->LoadSubProjects(m_inst,ext_ass);
				m_doc->m_project_mgr->LoadProjectInfo(ext_ass);
				for(i=0;i<ext_ass.GetSize();i++)
				{
					CaplProjectTreeItem *sub_item=0;
					InsertInstInTree(ext_ass[i],m_item,m_doc,m_tree,m_sub_projects,0,(CaplTreeItem **)(&sub_item));
					if(sub_item!=0)
					{
						sub_item->m_index=m_sub_projects.Size;
						sub_item->m_parent=m_inst;
						sub_item->m_parent_item=this;
						sub_item->RefreshItem();
					}
				}
			}			
		}
		bool old = m_bShowNoFoundMessage;
		m_bShowNoFoundMessage = old;
		m_ExecMyExpand = true;
		if(m_doc->m_auto_expand_items.m_showintree_project&APL_SHOW_DOC)
			ShowAllDocs(false,false);
		if(m_doc->m_auto_expand_items.m_showintree_project&APL_SHOW_CHARACT)
			ShowAllCharacteristic(false);
		if(m_doc->m_auto_expand_items.m_showintree_project&APL_SHOW_APPROVAL)
			ShowAllApproval(false);
		if(m_doc->m_auto_expand_items.m_showintree_project&APL_SHOW_PROJ_ASSOC)
			ShowAccociatedItems(false);
		m_bShowNoFoundMessage = old;
		m_ExecMyExpand = true;

		Sort();
		StopBusy();
	}
	else if(action==TVE_COLLAPSE)
	{
		if(m_rev) return true;
		if(m_has_version) HideAllVersion();
		CollapseItem(true);
		m_sub_projects.Clear();
		m_parent_projects.Clear();
		m_all_items.Clear();
	}
	return true;
}

//****************************************************************
bool CaplProjectTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_inst==0) return false;
	if(m_doc==0) return false;
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU1));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_PROJECT_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;
	
	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	if(m_folder==0)pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
	if(m_classifier==0){pPopup->EnableMenuItem(ID_REMOVE_FROM_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);}
	if(m_parent==0 && m_alert==0 && m_rel==0)pPopup->EnableMenuItem(ID_DELETE_REL, MF_BYCOMMAND | MF_GRAYED);
	if(m_parent==0 || m_is_in_content)pPopup->EnableMenuItem(ID_ADD_TO_CONTENT, MF_BYCOMMAND | MF_GRAYED);
	/*
	if(!m_doc->m_project_mgr->IsAdmin())
	{
		pPopup->EnableMenuItem(ID_ADD_TO_CONTENT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_REMOVE_FROM_CONTENT, MF_BYCOMMAND | MF_GRAYED);
		if(m_parent) pPopup->EnableMenuItem(ID_DELETE_REL, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
	}*/
	if(m_parent_item)
		if(m_parent_item->m_parent && !m_parent_item->m_is_in_content)pPopup->EnableMenuItem(ID_ADD_TO_CONTENT, MF_BYCOMMAND | MF_GRAYED);
	if(m_parent==0 || !m_is_in_content)pPopup->EnableMenuItem(ID_REMOVE_FROM_CONTENT, MF_BYCOMMAND | MF_GRAYED);

	if(m_rev)
	{
		pPopup->EnableMenuItem(ID_CREATE_PROJECT, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_PRJ_TREE_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_DOC, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_CHARACTERISTIC, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_CHARACTERISTIC_GROUP, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_ALL_VERSION, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_ALL_DOCS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_WORK_ITEMS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_WF_PROCESS, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_CREATE_MULT_PROCESSES, MF_BYCOMMAND | MF_GRAYED);
	}
	else
	{
		pPopup->EnableMenuItem(ID_REVISION_MAKE_ACTIVE, MF_BYCOMMAND | MF_GRAYED);		
	}
	
	/*
	if(!m_doc->m_project_mgr->IsAdmin())
	{
		pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
	}*/

	if(m_rev && !m_parent_project_item)
	{
		pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
	}
	else
	{
		if(m_rev)
		{
			pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
		}
		if (m_pLockInfo != NULL)
		{
			pPopup->RemoveMenu(ID_ITEM_CHECK_OUT, MF_BYCOMMAND);
			pPopup->EnableMenuItem(ID_REVISION_MAKE_ACTIVE, MF_BYCOMMAND | MF_GRAYED);
		}
		else
		{
			pPopup->RemoveMenu(ID_ITEM_CHECK_IN, MF_BYCOMMAND);
			pPopup->RemoveMenu(ID_ITEM_UNDO_CHECK_OUT, MF_BYCOMMAND);
		}
	}

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	switch(res)
	{
	case ID_OPEN_ITEM_IN_NEW_WINDOW:
		if(m_inst!=0) m_doc->OpenInstanceInNewWindow(m_inst);
		break;
	case ID_REMOVE_FROM_FOLDER:
		if(m_folder!=0)
		{
			if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_inst))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_REMOVE_FROM_CLASSIFIER:
		if(m_classifier!=0)
		{
			if(m_classifier->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			if(m_doc->m_api.m_classifier_mgr.DeleteClassifierAssociation(m_inst,m_classifier))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_DELETE_REL:RemoveRelation();break;
	case ID_REMOVE_FROM_CONTENT:RemoveFromParentContent();break;
	case ID_DELETE:DeleteProject();break;
	case ID_CREATE_PROJECT: CreateProject();break;
	case ID_CREATE_PRJ_TREE_COPY:
		{
			CaplInstance *newprj=m_doc->m_project_mgr->CreateProjectTreeCopy(0,m_inst);
			if(0!=newprj)
			{
				Expand(1);
				Expand(2);
				m_doc->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
				MyExpand();	
				AfxMessageBox(APL_T("!"));
			}
		}
		break;
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_inst); break;
	case ID_CREATE_CHARACTERISTIC_GROUP: CreateCharacteristicGroup(m_inst);break;
	case ID_ADD_TO_CONTENT:AddToParentContent();break;
	case ID_PRODUCT_WHERE_USED:ShowWhereUsedProject();break;
	case ID_ITEM_CHECK_IN:CheckIn();break;
	case ID_ITEM_CHECK_OUT:CheckOut();break;
	case ID_ITEM_UNDO_CHECK_OUT:UndoCheckOut();break;
	case ID_SHOW_ALL_VERSION: ShowAllVersion();break;
	case ID_REVISION_MAKE_ACTIVE:
		{
			if(m_doc->m_project_mgr->MakeProjectVersionActive(m_rev))
			{
				if(m_parent_project_item) 
				{
					CaplProjectTreeItem *parent_item=m_parent_project_item;
					bool has_version=parent_item->m_has_version;
					parent_item->m_has_version=has_version;
					//parent_item->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
					m_doc->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
					parent_item->Expand(1);
				}
			}
		}
		break;
	case ID_CREATE_WF_PROCESS:
		{
			aplExtent prots, wos;
			CaplInstance* proc_tmpl= m_doc->m_wf_mgr.CreateWfProcess(_T(""), _T(""), _T(""), 
				NULL, m_doc->m_api.m_appr_mgr.GetCurrentPerson(), 
				NULL, _T(""), _T(""), _T(""), prots, wos);

			if(proc_tmpl)
			{
				m_doc->m_wf_mgr.RunWfProcess(proc_tmpl);
				m_doc->m_project_mgr->CreateAssociation(m_inst, proc_tmpl, _T(""), _T(""));
				MyExpand();
				ShowAccociatedItems();
			}			
		}
		break;
	case ID_CREATE_MULT_PROCESSES:
		{
			aplExtent procs;
			m_doc->m_wf_mgr.StartManyProcs(NULL, NULL, &procs);
			if(procs.GetSize())
			{
				bool bAutoSave= m_doc->m_project_mgr->m_AutoSave;
				m_doc->m_project_mgr->m_AutoSave= false;

				for(int i= 0; i<procs.GetSize(); i++)
				{
					m_doc->m_project_mgr->CreateAssociation(m_inst, procs[i], _T(""), _T(""));
				}
				m_doc->m_project_mgr->m_AutoSave= bAutoSave;
				m_doc->m_api.SaveChanges();

				MyExpand();
				ShowAccociatedItems();
			}
		}
		break;
//	case ID_FREZEE_ALL_PRODUCT_CONTENTS:
//		{
//			aplExtent ext,ext0; ext.Add(m_inst);
//			m_doc->m_project_mgr->GetAllSubProject(m_inst,ext0,true,true);
//			ext.Append(ext0);
//			if(ext.Size>0)
//				m_doc_data.NET_SetInstancesAccess(&ext,(CaplInstance *)0,
//					(aplAccessModeType)-1);		
//		}
//		break;
	case ID_WORK_ITEMS:ShowAccociatedItems();break;
	case ID_SHOW_CONTAINED_CLASSIFIER:	ShowContainedClassifier(m_inst);break;
	case ID_PROJECT_SHOW_FINANSE:
		{
			CaplProjectManager::STransactionFilter Filter;
			//if(m_doc->m_project_mgr->SelectTransactionFilter(Filter))
			m_doc->m_project_mgr->ReportTransactions(m_inst, Filter);
		}
		break;
	case ID_SHOW_PRJ_MONITOR:
		{
			aplExtent ext_sub_prj;
			m_doc->m_project_mgr->GetAllSubProject(m_inst,ext_sub_prj);
			if(ext_sub_prj.GetSize()>0) m_doc->m_project_mgr->ShowProjectsMonitor(ext_sub_prj);
			else AfxMessageBox(APL_T(" !"),MB_OK); 
		}
		break;
	case ID_SHOW_GANTT:
		{
			aplExtent ext; ext.Add(m_inst);
			m_doc->m_project_mgr->ShowGanttDlg(ext);
		}
		break;
	default: PrepareContextMenu(res); 
	}
	return true;
}
//****************************************************************
void CaplProjectTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_inst!=0){if(m_inst->GetType()!=0)ext.Add(m_inst);}
	if(m_addInCall && m_folder!=0){if(m_folder->GetType()!=0) ext.Add(m_folder);}
}


//****************************************************************
bool CaplProjectTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	CHECK_SHOW_LIST_CTRL(m_inst);
	if(m_doc==0)return false;
	if(m_rev) 
	{
		CHECK_SHOW_LIST_CTRL(m_rev);
		if(m_rev->GetAccessmode()>aplRO)return false;
	}
	else if(m_inst->GetAccessmode()>aplRO)return false;

	CaplInstance *inst=0,*ver=0;
	CString buf=_T("");
	if(m_rev) ver=m_rev;
	else ver=m_doc->m_project_mgr->CheckMyLock(m_inst,false);

	int i,count=0;
	CString id=_T(""),name=_T(""),descr=_T("");
	
	CaplInstance *tmp=m_inst;
	if(ver) tmp=ver;

	i=list->InsertItem(count, APL_T(":"));count++;
	m_doc_data.GetAttrBN(tmp,S::id,buf);
	list->SetItemText(i,1,buf);
	buf=_T("");	

	i=list->InsertItem(count, APL_T(":"));count++;
	m_doc_data.GetAttrBN(tmp,S::name,buf);
	list->SetItemText(i,1,buf);
	buf=_T("");

	i=list->InsertItem(count, APL_T(" :"));count++;
	m_doc_data.GetAttrBN(tmp,S::project_number,buf);
	list->SetItemText(i,1,buf);
	buf=_T("");

	i=list->InsertItem(count, APL_T(":"));count++;
	m_doc_data.GetAttrBN(tmp,S::description,buf);
	list->SetItemText(i,1,buf);
	buf=_T("");

	CaplInstance *type=0;
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_type,type);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_type,type);
	if(type) m_doc_data.GetAttr(type,m_doc->m_project_mgr->a_project_type_name,buf);
	i=list->InsertItem(count, APL_T(":"));count++;
	list->SetItemText(i,1,buf);

	buf=_T("");
	i=list->InsertItem(count, APL_T(":"));count++;
	m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_state,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(count, APL_T(":"));count++;
	GetAccessName(m_inst,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(count,_T(""));count++;
	//
	buf=_T("");
	i=list->InsertItem(count, APL_T(":"));count++;
	CaplInstance *customer=0;
	if(ver) m_doc->m_api.m_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_customer,customer);
	else m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_customer,customer);
	if(customer) 
	{
		m_doc->m_api.GetItemName(customer,buf);
//		if(m_doc->m_api.m_data.IsKindOf(customer, m_doc->m_api.m_appr_mgr.e_person)) m_doc->m_api.m_appr_mgr.GetPersonName(customer,buf);
//		else if(m_doc->m_api.m_data.IsKindOf(customer, m_doc->m_api.m_appr_mgr.e_org)) m_doc->m_api.m_data.GetAttr(customer,m_doc->m_api.m_appr_mgr.a_org_name,buf); 

	}
	list->SetItemText(i,1,buf);

	// 
	buf=_T("");
	if(m_rev)
	{
		i=list->InsertItem(count,_T(""));count++;
	}
	else
	{
		list->InsertItem(count,_T(""));count++;
		i=list->InsertItem(count, APL_T(":"));count++;
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_owner,inst);
		//m_doc->m_api.m_appr_mgr.GetPersonName(inst,buf);
		m_doc->m_api.GetItemName(inst,buf);
		list->SetItemText(i,1,buf);
		i=list->InsertItem(count,_T(""));count++;
	}


	//.
	buf=_T("");
	i=list->InsertItem(count, APL_T(".:"));count++;
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_kurator,inst);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_kurator,inst);
	if(inst)
	{
		m_doc->m_api.GetItemName(inst,buf);
//		if(m_doc_data.IsKindOf(inst, m_doc->m_api.m_appr_mgr.e_person)) m_doc->m_api.m_appr_mgr.GetPersonName(inst,buf);
//		else if(m_doc_data.IsKindOf(inst, m_doc->m_api.m_appr_mgr.e_org)) m_doc_data.GetAttr(inst,m_doc->m_api.m_appr_mgr.a_org_name,buf); 
	}
	list->SetItemText(i,1,buf);
	//
	i=list->InsertItem(count, APL_T(":"));count++;
	CaplAggr aggr;
	CString executors=_T("");
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_executors,aggr);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_executors,aggr);
	for(int j=0;j<aggr.GetSize();j++)
	{
		buf=_T("");
		aggr.GetByIndex(j,inst);
		if(inst)
		{
			m_doc->m_api.GetItemName(inst,buf);
//			if(m_doc_data.IsKindOf(inst, m_doc->m_api.m_appr_mgr.e_person)) m_doc->m_api.m_appr_mgr.GetPersonName(inst,buf);
//			else if(m_doc_data.IsKindOf(inst, m_doc->m_api.m_appr_mgr.e_org)) m_doc_data.GetAttr(inst,m_doc->m_api.m_appr_mgr.a_org_name,buf); 
		}
		
		if(buf!=_T(""))
		{
			executors+=buf; 
			if(j!=(aggr.GetSize()-1)) executors+=_T(", "); 
		}
	}
	list->SetItemText(i,1,executors);

	i=list->InsertItem(count,_T(""));count++;
	COleDateTime dt;

	buf=_T("");
	i=list->InsertItem(count, APL_T("  :"));count++;
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_date_planned_begin,buf);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_date_planned_begin,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			buf=dt.Format(_T("%d.%m.%Y"));
		}
	}
	list->SetItemText(i,1,buf);

	buf=_T("");
	i=list->InsertItem(count, APL_T("  :"));count++;
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_date_planned_end,buf);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_date_planned_end,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			buf=dt.Format(_T("%d.%m.%Y"));
		}
	}
	list->SetItemText(i,1,buf);

	double num=0;
	if(!m_rev)
	{
		i=list->InsertItem(count,_T(""));count++;
		buf=_T("");
		i=list->InsertItem(count, APL_T("  :"));count++;
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_date_actual_begin,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			if(dt.GetStatus()==COleDateTime::valid)
			{
				buf=dt.Format(_T("%d.%m.%Y"));
			}
		}
		list->SetItemText(i,1,buf);

		buf=_T("");
		i=list->InsertItem(count, APL_T("  :"));count++;
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_date_actual_end,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			if(dt.GetStatus()==COleDateTime::valid)
			{
				buf=dt.Format(_T("%d.%m.%Y"));
			}
		}
		list->SetItemText(i,1,buf);

		i=list->InsertItem(count,_T(""));count++;
		// 
		buf=_T("");
		i=list->InsertItem(count, APL_T(" (%):"));count++;
		
		// 20.03.2023    a_project_adm_ver_persentage     
		//if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_persentage,num);
		//else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_persentage,num);

		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_persentage,num);

		if(num)	buf.Format(_T("%f"),num);
		list->SetItemText(i,1,buf);
	}

	i=list->InsertItem(count,_T(""));count++;
	//
	num=0;
	CaplInstance *labor=0;
	CString labor_str=_T("");
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_labor_useness,labor);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_labor_useness,labor);
	if(labor)
	{
		i=list->InsertItem(count, APL_T(":"));count++;
		m_doc_data.GetAttr(labor,m_doc->m_project_mgr->a_labor_value,num);
		if(num)	
			labor_str = Double2Str(num);
			//labor_str.Format(_T("%g"),num);
		m_doc_data.GetAttr(labor,m_doc->m_project_mgr->a_labor_unit,inst);
		if(inst)
		{
			if(!num) 
				labor_str+=_T("0");
			labor_str+=_T(" ");
			m_doc->m_api.m_charact_mgr.GetUnitName(inst,buf);
			labor_str+=buf;
		}
		list->SetItemText(i,1,labor_str);
	}
	
	if(!m_rev)
	{
		labor_str=_T("");
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_labor_useness_actual,labor);
		if(labor)
		{
			i=list->InsertItem(count, APL_T(" :"));count++;
			m_doc_data.GetAttr(labor,m_doc->m_project_mgr->a_labor_value,num);
			if(num)	
				labor_str = Double2Str(num);
//				labor_str.Format(_T("%g"),num);
			m_doc_data.GetAttr(labor,m_doc->m_project_mgr->a_labor_unit,inst);
			if(inst)
			{
				if(!num) 
					labor_str+=_T("0");
				labor_str+=_T(" ");
				m_doc->m_api.m_charact_mgr.GetUnitName(inst,buf);
				labor_str+=buf;
			}
			list->SetItemText(i,1,labor_str);
		}
	}
	i=list->InsertItem(count,_T(""));count++;
	// 
	buf=_T("");
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_prd_amount_planned,num);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_prd_amount_planned,num);
	i=list->InsertItem(count, APL_T(" :"));count++;
	if(num)	
		buf = Double2Str(num);
//		buf.Format(_T("%g"),num);
	list->SetItemText(i,1,buf);

	if(!m_rev)
	{
		buf=_T("");
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_prd_amount_actual,num);
		i=list->InsertItem(count, APL_T("  :"));count++;
		if(num)	
			buf = Double2Str(num);
//			buf.Format(_T("%g"),num);
		list->SetItemText(i,1,buf);
	}

	//  
	labor_str=_T("");
	if(ver) m_doc_data.GetAttr(ver,m_doc->m_project_mgr->a_project_adm_ver_labor_of_item,labor);
	else m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_labor_of_item,labor);
	if(labor)
	{
		i=list->InsertItem(count, APL_T("  :"));count++;
		m_doc_data.GetAttr(labor,m_doc->m_project_mgr->a_labor_value,num);
		if(num)	
			labor_str = Double2Str(num);
			//labor_str.Format(_T("%g"),num);
		m_doc_data.GetAttr(labor,m_doc->m_project_mgr->a_labor_unit,inst);
		if(inst)
		{
			if(!num) 
				labor_str+=_T("0");
			labor_str+=_T(" ");
			m_doc->m_api.m_charact_mgr.GetUnitName(inst,buf);
			labor_str+=buf;
		}
		list->SetItemText(i,1,labor_str);
	}
	//
	CaplInstance *parent=0;
	if(m_inst)
	{
		m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_parent,parent);
		if(parent)
		{
			list->InsertItem(count,_T(""));count++;
			i=list->InsertItem(count, APL_T("-:"));count++;
			m_doc->m_api.GetItemName(parent,buf);
			list->SetItemText(i,1,buf);
		}
	}

	if(m_rev)
	{
		i=list->InsertItem(count,_T(""));count++;

		buf=_T("");
		CaplInstance *user=0,*po=0;
		m_doc_data.GetAttr(m_rev,m_doc->m_project_mgr->a_project_adm_ver_author,user);
		if(user!=0)
		{
			i=list->InsertItem(count, APL_T(":"));count++;
			m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_po,po);
			if(po==0) m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_name,buf);
			//else m_doc->m_api.m_appr_mgr.GetPersonName(po,buf);
			else m_doc->m_api.GetItemName(po,buf);
			list->SetItemText(i,1,buf);
		}

		m_doc_data.GetAttr(m_rev,m_doc->m_project_mgr->a_project_adm_ver_start,buf);
		if(buf!=_T(""))
		{
			i=list->InsertItem(count, APL_T(" :"));count++;
			COleDateTime odt;
			aplString2Date(buf,odt);	
			buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			list->SetItemText(i,1,buf);
		}
		m_doc_data.GetAttr(m_rev,m_doc->m_project_mgr->a_project_adm_ver_end,buf);
		if(buf!=_T(""))
		{
			i=list->InsertItem(count, APL_T(" :"));count++;
			COleDateTime odt;
			aplString2Date(buf,odt);	
			buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			list->SetItemText(i,1,buf);
		}
		m_doc_data.GetAttr(m_rev,m_doc->m_project_mgr->a_project_adm_ver_basis,buf);
		if(buf!=_T(""))
		{
			i=list->InsertItem(count, APL_T(":"));count++;
			list->SetItemText(i,1,buf);
		}
	}
	else if(m_pLockInfo && m_pLockInfo->GetType())
	{
		i=list->InsertItem(count,_T(""));count++;

		buf=_T("");
		CaplInstance *user=0,*po=0;
		m_doc_data.GetAttr(m_pLockInfo,m_doc->m_project_mgr->a_project_adm_ver_author,user);
		if(user!=0)
		{
			i=list->InsertItem(count, APL_T(":"));count++;
			m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_po,po);
			if(po==0) m_doc_data.GetAttr(user,m_doc->m_api.m_appr_mgr.a_apl_user_name,buf);
			//else m_doc->m_api.m_appr_mgr.GetPersonName(po,buf);
			else m_doc->m_api.GetItemName(po,buf);
			list->SetItemText(i,1,buf);
		}
		
		m_doc_data.GetAttr(m_pLockInfo,m_doc->m_project_mgr->a_project_adm_ver_start,buf);
		if(buf!=_T(""))
		{
			i=list->InsertItem(count, APL_T(" :"));count++;
			COleDateTime odt;
			aplString2Date(buf,odt);	
			buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			list->SetItemText(i,1,buf);
		}
		m_doc_data.GetAttr(m_pLockInfo,m_doc->m_project_mgr->a_project_adm_ver_basis,buf);
		if(buf!=_T(""))
		{
			i=list->InsertItem(count, APL_T(":"));count++;
			list->SetItemText(i,1,buf);
		}
	}

	aplExtent ext;
	CStringArray  comment;

	if(m_inst!=0){
		comment.Add(_T("m_inst"));
		ext.Add(m_inst);
	}
	if(parent)
	{
		comment.Add(_T("main_parent"));
		ext.Add(parent);
	}

	if(m_folder!=0){
		comment.Add(_T("m_folder"));
		ext.Add(m_folder);
	}
	if(m_parent!=0 && m_parent!=parent){
		comment.Add(_T("m_parent"));
		ext.Add(m_parent);
	}
	if(m_subitem!=0){
		comment.Add(_T("m_subitem"));
		ext.Add(m_subitem);
	}
	if(m_rev!=0){
		comment.Add(_T("m_rev"));
		ext.Add(m_rev);
	}
	if(m_pLockInfo!=0){
		comment.Add(_T("m_pLockInfo"));
		ext.Add(m_pLockInfo);
	}

	if(m_classifier!=0){
		CaplInstance* classif_ref;
		m_doc->m_api.m_classifier_mgr.TestClassifierAssociation(m_inst,m_classifier,&classif_ref);
		if(classif_ref!=0){
			comment.Add(_T("classifier association"));
			ext.Add(classif_ref);
		}
		comment.Add(_T("m_classifier"));
		ext.Add(m_classifier);
	}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}
//****************************************************************

void CaplProjectTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
		case ID_ITEM_CHECK_IN:CheckIn();break;
		case ID_ITEM_CHECK_OUT:CheckOut();break;
		case ID_ITEM_UNDO_CHECK_OUT:UndoCheckOut();break;
		case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_inst); break;
		case ID_ITEM_VIEW: ShowProperties(); break;
		case ID_CREATE_PROJECT: CreateProject();break;
		default: PrepareContextMenu(cmd);break;
	}
}
BOOL CaplProjectTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{

	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		aplExtent instances;
		GetAccessedInstances(instances);
		if(instances.GetSize()>0)
		{
			if(instances[0]->GetAccessmode()==aplOWN) return TRUE;
		}
		return FALSE;
	}

	/*
	if(!m_doc->m_project_mgr->IsAdmin())
	{
		if(pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_IN)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT) return FALSE;
	}*/

	if(m_rev)
	{
		if(pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_IN)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT) return FALSE;
		if(pCmdUI->m_nID==ID_SHOW_ALL_VERSION) return FALSE;
		if(pCmdUI->m_nID==ID_CREATE_PROJECT) return FALSE; 
		if(pCmdUI->m_nID==ID_SHOW_ALL_DOCS) return FALSE;
		if(pCmdUI->m_nID==ID_SHOW_ALL_CHARACTERISTIC) return FALSE; 
		if(pCmdUI->m_nID==ID_CREATE_DOC) return FALSE; 
		if(pCmdUI->m_nID==ID_CREATE_CHARACTERISTIC) return FALSE; 

	}

	if (m_pLockInfo)
	{
		if(pCmdUI->m_nID==ID_ITEM_CHECK_OUT) return FALSE;
	}
	else
	{
		if(pCmdUI->m_nID==ID_ITEM_UNDO_CHECK_OUT)  return FALSE;
		if(pCmdUI->m_nID==ID_ITEM_CHECK_IN)  return FALSE;
	}

	switch(pCmdUI->m_nID)
	{
		case ID_SHOW_ALL_DOCS:
		case ID_SHOW_ALL_CHARACTERISTIC:
		case ID_SHOW_ALL_APPROVAL:
		case ID_CREATE_APPROVAL:
		case ID_CREATE_CHARACTERISTIC:
		case ID_CREATE_DOC:
		case ID_CREATE_PROJECT:
		case ID_ITEM_CHECK_OUT:
		case ID_ITEM_CHECK_IN:
		case ID_ITEM_UNDO_CHECK_OUT:
		case ID_SHOW_ALL_VERSION:
		case ID_SHOW_NOTES:
		case ID_CREATE_NOTE:
			pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplProjectTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if (item->m_type != APL_TREE_ITEM_DOCUMENT)
		if (item->m_type != APL_TREE_ITEM_CHARACTERISTIC)
			if (item->m_type != APL_TREE_ITEM_CHARACTERISTICGROUP)
				if (item->m_type != APL_TREE_ITEM_PROJECT)
					if (item->m_type != APL_TREE_ITEM_PRODUCT)
						if (item->m_type != APL_TREE_ITEM_PRDINST)
							if (item->m_type != APL_TREE_ITEM_BP)
								if (item->m_type != APL_TREE_ITEM_BPINST)
									if(item->m_type != APL_TREE_ITEM_FOLDER)
										if(item->m_type != APL_TREE_ITEM_PROCESS)
										return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return false;}

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup=0;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

	int ref_type;
	m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "),ref_type,0);
	if(item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		if(ref_type==0)
		{
			aplExtent ext;
			item->GetAccessedInstances(ext);
			CString state;
			m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
			if(state==_T("canceled")) return false;
			pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
		}
		else 
		{
			pPopup = menu.GetSubMenu(INDEX_PROJECT_PASTE_MENU);
		}
	}
	else if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	else if (item->m_type == APL_TREE_ITEM_FOLDER)
	{
		pPopup = menu.GetSubMenu(INDEX_FOLDER_MENU);
		pPopup->RemoveMenu(ID_FOLDER_INS_SHORCUT, MF_BYCOMMAND);
	}
	else if(item->m_type == APL_TREE_ITEM_PROJECT)
	{
		CaplInstance *sub_project=((CaplProjectTreeItem*)item)->m_inst;
		if(sub_project)
		{
			CaplInstance *project_parent=0;
			m_doc->m_api.m_data.GetAttr(sub_project, m_doc->m_api.m_project_mgr->a_project_parent, project_parent);
			if(project_parent && project_parent!=m_inst)
			{
				pPopup = menu.GetSubMenu(INDEX_PROJECT_MOVE_MENU);
			}
		}
	}
	else if(item->m_type == APL_TREE_ITEM_PROCESS)
	{
		pPopup = menu.GetSubMenu(INDEX_PROJECT_PASTE_MENU);
		pPopup->RemoveMenu(ID_PROJECT_INSERT_CONTROL_ITEM, MF_BYCOMMAND);		
		pPopup->ModifyMenu(ID_PROJECT_INSERT_WORK_ITEM, MF_BYCOMMAND|MF_STRING, ID_PROJECT_INSERT_WORK_ITEM,  APL_T(" "));		
	}
	else 
	{
		pPopup = menu.GetSubMenu(INDEX_PROJECT_PASTE_MENU);
	}

	BOOL res=0;
	if(pPopup!=0)
	{
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		//  
		if (res == ID_DOCUMENT_COPY)
		{
			CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;
			if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,m_inst))
				MyExpand();
		}
		//    
		else if(res == ID_DOCUMENT_BYDOT)
		{
			CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;
			
			aplExtent instances;
			GetAccessedInstances(instances);
			if(m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		//  
		else if (res == ID_CHARACTERISTIC_COPY)
		{
			if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
			{
				CaplInstance *i_val=((CaplCharacteristicTreeItem *)item)->m_val;
				CreateCharacteristic(m_inst,i_val);
			}
			else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
			{
				CreateCharacteristicGroup(m_inst,((CaplCharacteristicGroupTreeItem*)item)->m_group);
			}

		}
		else if(res == ID_FOLDER_MOVE)
		{
			CaplInstance *obj= NULL, *rel=NULL;
			CaplFolderTreeItem* fldItem= (CaplFolderTreeItem*)item;
			
			m_doc->m_api.m_data.PutAttr(fldItem->m_inst, m_doc->m_api.m_folder_mgr.a_folder_parent, m_inst);
			
			obj=((CaplFolderTreeItem*)item)->m_inst;
			if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,NULL);
			if(rel)
			{
				CaplProductTreeItem *new_item=0;
				InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
				if(new_item!=0) new_item->m_project=m_inst;
				MyExpand(false);				
			}
			
			m_doc->m_items.Remove(m_doc->m_items.Find(fldItem));
		}
		else if(res!=0 && res != ID_UNDO_MENU)
		{
			CaplInstance *control_status=0;
			if(res==ID_PROJECT_INSERT_CONTROL_ITEM)
			{
				CChooseStatusDlg dlg;
				dlg.m_api=&m_doc->m_api;
				if(dlg.DoModal()==IDOK)
				{
					control_status=dlg.m_chosen_status;
				}
			}
			CaplInstance *obj=0,*rel=0;

			if(item->m_type == APL_TREE_ITEM_PRODUCT)
			{
				CaplInstance *prd=((CaplProductTreeItem*)item)->m_prd;
				CaplInstance *pdf=((CaplProductTreeItem*)item)->m_pdf;
				obj=prd;
				if(pdf) obj=pdf;
				if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,control_status);
				if(rel)
				{
					CaplProductTreeItem *new_item=0;
					InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0) new_item->m_project=m_inst;
					MyExpand(false);
				}
			}
			else if(item->m_type == APL_TREE_ITEM_PRDINST)
			{
				obj=((CaplPrdInstTreeItem*)item)->m_inst;
				if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,control_status);
				if(rel)
				{
					CaplPrdInstTreeItem *new_item=0;
					InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0) new_item->m_project=m_inst;
					MyExpand(false);
				}
			}
			else if(item->m_type == APL_TREE_ITEM_BP)
			{
				obj=((CaplBPTreeItem*)item)->m_inst;
				if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,control_status);
				if(rel)
				{
					CaplBPTreeItem *new_item=0;
					InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0) new_item->m_project=m_inst;
					MyExpand(false);
				}
			}
			else if(item->m_type == APL_TREE_ITEM_BPINST)
			{
				obj=((CaplBPInstTreeItem*)item)->m_inst;
				if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,control_status);
				if(rel)
				{
					CaplBPInstTreeItem *new_item=0;
					InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0) new_item->m_project=m_inst;
					MyExpand(false);
				}
			}
			else if(item->m_type == APL_TREE_ITEM_DOCUMENT)
			{
				obj=((CaplDocTreeItem*)item)->m_inst;
				if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,control_status);
				if(rel)
				{
					CaplDocTreeItem *new_item=0;
					InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0) new_item->m_project=m_inst;
					MyExpand(false);
				}
			}
			else if(item->m_type == APL_TREE_ITEM_PROCESS)
			{
				obj=((CaplProcessTreeItem*)item)->m_process;
				if(obj) rel=m_doc->m_project_mgr->CreateAssociation(m_inst,obj,0,0,control_status);
				if(rel)
				{
					CaplProcessTreeItem *new_item=0;
					InsertInstInTree(obj,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
					if(new_item!=0) new_item->m_project=m_inst;
					MyExpand(false);
				}
			}
		}
	}
	if(item->m_type == APL_TREE_ITEM_PROJECT)
	{
		if(res != ID_UNDO_MENU)
		{
			bool remove_from_content=false;	
			if(res==ID_PROJECT_MOVE) remove_from_content=true;

			m_doc->m_project_mgr->LoadProjectInfo(m_inst);
			CaplInstance *project_lock=0;
			m_doc->m_project_mgr->CheckMyLockAndCheckOut(m_inst,false);
			project_lock=m_doc->m_project_mgr->CheckMyLock(m_inst,false);
			if(!project_lock) return false;
			CaplInstance *sub_project=((CaplProjectTreeItem*)item)->m_inst;
			m_doc->m_project_mgr->LoadProjectInfo(sub_project);
			CaplInstance *sub_project_old_parent=0;
			CaplInstance *sub_project_old_parent_lock=0;
			m_doc_data.GetAttr(sub_project,m_doc->m_project_mgr->a_project_parent,sub_project_old_parent);
			if(remove_from_content)
			{
				if(sub_project_old_parent)
				{
					m_doc->m_project_mgr->CheckMyLockAndCheckOut(sub_project_old_parent,false);
					sub_project_old_parent_lock=m_doc->m_project_mgr->CheckMyLock(sub_project_old_parent,false);
					if(!sub_project_old_parent_lock) return false;
				}
			}
			bool make_main_parent=false;
			if(!remove_from_content)
			{
				if(sub_project_old_parent)
				{
					if(m_doc->m_api.m_ModeInteractive)
					{
						if(AfxMessageBox( APL_T(" ''  ?\n(     )"),MB_YESNO|MB_ICONQUESTION)==IDYES)
						{
							make_main_parent=true;
						}
					}
				}
				else
				{
					make_main_parent=true;
				}
			}
			if(m_doc->m_project_mgr->InsertProjectIntoParent(sub_project,m_inst,true,remove_from_content,make_main_parent))
			{
				if(remove_from_content)
				{
					((CaplProjectTreeItem*)item)->Expand(TVE_COLLAPSE);
					m_doc->m_items.Remove(m_doc->m_items.Find(item));

					/* ayatsk    -   
					CaplProjectTreeItem *old_parent_item=((CaplProjectTreeItem*)item)->m_parent_item;
					if(old_parent_item) 
					{
						old_parent_item->Expand(TVE_COLLAPSE);
						old_parent_item->Expand(TVE_EXPAND);
					}*/
				}
				Expand(TVE_COLLAPSE);
				Expand(TVE_EXPAND);
				m_doc->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
				MyExpand();
			}
		}
	}
	
	m_tree->RedrawWindow();
	return true;
}

//****************************************************************
bool CaplProjectTreeItem::PasteFile(LPCTSTR file, CPoint *point)
{
	if(file==0) return false;
	CreateDoc(m_inst,file);
	return true;
}
//****************************************************************
void CaplProjectTreeItem::CreateProject()
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	m_doc->m_project_mgr->LoadProjectInfo(m_inst);
	
	CaplInstance *sub_project=m_doc->m_project_mgr->CreateProject(m_inst);
	
	if(sub_project!=0)
	{
		CaplProjectTreeItem *sub_item= new CaplProjectTreeItem(m_tree,m_doc,sub_project);
		sub_item->m_parent=m_inst;	
		sub_item->m_index=m_sub_projects.GetSize();
		sub_item->CreateTreeItem(m_item);
		sub_item->m_parent_item=this;
		m_sub_projects.Add(sub_project);
	}
	Expand(1);
	Expand(2);
	m_doc->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
	MyExpand();	
}

void CaplProjectTreeItem::AddToParentContent()
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	m_doc->m_project_mgr->LoadProjectInfo(m_inst);
	m_doc->m_project_mgr->LoadProjectInfo(m_parent);
	
	if(m_doc->m_project_mgr->AddToParentContent(m_inst,m_parent))
	{
		m_is_in_content=true;
		if(m_parent_item)
		{
			CaplProjectTreeItem *t_item=m_parent_item;
			t_item->Expand(1);
			t_item->Expand(2);
		}
	}
}

void CaplProjectTreeItem::RemoveFromParentContent()
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	m_doc->m_project_mgr->LoadProjectInfo(m_inst);
	m_doc->m_project_mgr->LoadProjectInfo(m_parent);

	if(m_doc->m_project_mgr->RemoveFromParentContent(m_inst,m_parent))
	{
		m_is_in_content=false;
		if(m_parent_item)
		{
			CaplProjectTreeItem *t_item=m_parent_item;
			t_item->Expand(1);
			t_item->Expand(2);
			t_item->RefreshItem();
		}
	}
}

void CaplProjectTreeItem::RemoveRelation()
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(!m_alert && !m_parent && !m_rel) return;
	if(m_inst->GetAccessmode()>aplRW){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	
	if(AfxMessageBox( APL_T("     ?"),MB_YESNO)!=IDYES) return;
	
	if(m_alert) 
	{
		if(m_doc->m_api.m_data.IsKindOf(m_alert,m_doc->m_api.m_message_mgr.e_alert))
		{
			if(m_doc->m_api.m_message_mgr.DeleteItemFromAlert(m_alert))
			{
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
			}
		}
	}
	else if(m_parent)
	{
		m_doc->m_project_mgr->LoadProjectInfo(m_inst);
		m_doc->m_project_mgr->LoadProjectInfo(m_parent);
		
		if(m_doc->m_project_mgr->RemoveProjectFromParent(m_inst,m_parent))
		{
			m_is_in_content=false;
			if(m_parent_item)
			{
				CaplProjectTreeItem *t_item=m_parent_item;
				t_item->Expand(1);
				t_item->Expand(2);
			}
		}
	}
	else if(m_rel)
	{
		if(!m_doc->m_project_mgr->DeleteAssociation(m_inst,m_rel)) return;
		if(m_doc->m_api.m_data.IsKindOf(m_rel,m_doc->m_api.m_prd_mgr.e_prd) || m_doc->m_api.m_data.IsKindOf(m_rel,m_doc->m_api.m_prd_mgr.e_pdf))
		{
			CaplProductTreeItem *prd_item=(CaplProductTreeItem*)GetParentItem(this);
			if(prd_item) prd_item->m_all_projects.Remove(prd_item->m_all_projects.Find(m_inst));
		}
		else if(m_doc->m_api.m_data.IsKindOf(m_rel,m_doc->m_api.m_prd_inst_mgr.e_prd_inst))
		{
			CaplPrdInstTreeItem *prd_inst_item=(CaplPrdInstTreeItem*)GetParentItem(this);
			if(prd_inst_item) prd_inst_item->m_all_projects.Remove(prd_inst_item->m_all_projects.Find(m_inst));
		}
		m_doc->m_items.Remove(m_doc->m_items.Find(this));
	}
}

void CaplProjectTreeItem::DeleteProject()
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(m_inst->GetAccessmode()>aplOWN){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}
	
	CString question= APL_T("     ?");
	if(m_rev) question= APL_T("      ?");
	if(AfxMessageBox(question,MB_YESNO)==IDYES)
	{
		CaplInstance *inst_to_remove=m_inst;
		if(m_rev) inst_to_remove=m_rev;
		m_doc->m_project_mgr->LoadProjectInfo(inst_to_remove);
		bool delete_sub_projects=false;
		if(!m_rev)
		{
			aplExtent ext_sub;
			m_doc->m_project_mgr->GetAllSubProject(inst_to_remove,ext_sub,false);
			if(ext_sub.GetSize())
			{
				if(AfxMessageBox( APL_T("  .   ?"),MB_YESNO)==IDYES)
				{
					delete_sub_projects=true;
				}
			}
		}
		StartBusy();
		long wdlg=aplStartWaitDlg( APL_T("  ..."));
		if(m_doc->m_project_mgr->DeleteProject(inst_to_remove,delete_sub_projects,false))
		{
			for(int i=0;i<m_doc->m_items.Size;i++)
			{
				if(m_doc->m_items[i]!=this)
				{
					if(m_doc->m_items[i]->m_type==m_type)
					{
						CaplProjectTreeItem *item1=(CaplProjectTreeItem*)m_doc->m_items[i];
						{
							if(item1->m_inst==inst_to_remove)
								{m_doc->m_items.Remove(i); i--;}
						}
					}
				}
			}
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		aplEndWaitDlg(wdlg);
		StopBusy();
	}
}

void CaplProjectTreeItem::ShowWhereUsedProject()
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	aplExtent ext;
	m_doc->m_project_mgr->WhereUsedProject(m_inst,ext);
	m_doc->m_project_mgr->LoadProjectInfo(ext);
	for(int i=0;i<ext.Size;i++)
	{
		if(m_parent_projects.Find(ext[i])>=0) continue;
		CaplProjectTreeItem *act_item= new CaplProjectTreeItem(m_tree,m_doc,ext[i]);
		act_item->m_subitem=m_inst;
		if(m_doc->m_project_mgr->IsProjectInContentOfParent(ext[i])) act_item->m_is_in_content=true;
		act_item->CreateTreeItem(m_item);
		act_item->RefreshItem();
		m_parent_projects.Add(ext[i]);
	}
	//
	ShowAccociatedItems(false);

	if(m_ExecMyExpand)
		MyExpand(false);
}

void CaplProjectTreeItem::ShowAccociatedItems(bool showMsg)
{
	if(m_tree==0) return;
	if(m_doc==0) return;
	if(m_inst==0)return;
	if(m_inst->GetType()==0)return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	aplExtent ext,ext_rel, tmp;
	m_doc->m_project_mgr->FindAssociatedItems(m_inst, ext,ext_rel);
//	m_doc->m_folder_mgr.GetAllSubFolder(m_inst, tmp);
	if(!ext.GetSize())
	{
		if(showMsg)AfxMessageBox( APL_T("  !"));
		return;
	}
	CaplTreeItem *new_item=0;
	for(int i=0;i<ext.Size;i++)
	{
		new_item=0;
		InsertInstInTree(ext[i],m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
		if(!new_item) continue;
		if(m_doc->m_api.m_data.IsKindOf(ext[i],m_doc->m_api.m_doc_mgr.e_doc))
		{
			CaplDocTreeItem *doc_item=(CaplDocTreeItem*)new_item;
			doc_item->m_project=m_inst;
		}
		if(m_doc->m_api.m_data.IsKindOf(ext[i],m_doc->m_api.m_prd_mgr.e_prd) || m_doc->m_api.m_data.IsKindOf(ext[i],m_doc->m_api.m_prd_mgr.e_pdf))
		{
			CaplProductTreeItem *prd_item=(CaplProductTreeItem*)new_item;
			prd_item->m_project=m_inst;
		}
		else if(m_doc->m_api.m_data.IsKindOf(ext[i],m_doc->m_api.m_prd_inst_mgr.e_prd_inst))
		{
			CaplPrdInstTreeItem *prd_inst_item=(CaplPrdInstTreeItem*)new_item;
			prd_inst_item->m_project=m_inst;
		}
		else if(m_doc->m_api.m_data.IsKindOf(ext[i],m_doc->m_api.m_bp_mgr.e_bp))
		{
			CaplBPTreeItem *bp_item=(CaplBPTreeItem*)new_item;
			bp_item->m_project=m_inst;
		}
		else if(m_doc->m_api.m_data.IsKindOf(ext[i],m_doc->m_api.m_bp_mgr.e_apl_bp_inst))
		{
			CaplBPInstTreeItem *bp_inst_item=(CaplBPInstTreeItem*)new_item;
			bp_inst_item->m_project=m_inst;
		}
		else if(m_doc->m_api.m_data.IsKindOf(ext[i], m_doc->m_wf_mgr.e_proc))
		{
			CaplProcessTreeItem* proc_item= (CaplProcessTreeItem*)new_item;
			proc_item->m_project= m_inst;
		}
	}
	if(m_ExecMyExpand)
		MyExpand(false);
}

void CaplProjectTreeItem::CheckOut()
{
	bool check_out_result=false;
	bool recursive=false;
	if(m_rev) check_out_result=m_doc->m_project_mgr->CheckOutWithRequest(m_rev,recursive);
	else check_out_result=m_doc->m_project_mgr->CheckOutWithRequest(m_inst,recursive);
	if(check_out_result) 
	{
		Expand(1);
		Expand(2);
		RefreshItem();
		if(m_rev)
		{
			if(m_parent_project_item)
			{
				CaplProjectTreeItem *p_item=m_parent_project_item;
				p_item->Expand(1);
				p_item->Expand(2);
				p_item->RefreshItem();
			}
		}
	}
	if(recursive) m_doc->RefreshAllItemsByType(APL_TREE_ITEM_BP);
}
void CaplProjectTreeItem::CheckIn()
{
	bool recursive=false;
	if(m_doc->m_project_mgr->CheckInWithRequest(m_inst,recursive)) 
	{ 
		Expand(1);
		Expand(2);
		m_doc->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
	}
}
void CaplProjectTreeItem::UndoCheckOut()
{
	bool recursive=false;
	if(m_doc->m_project_mgr->UndoCheckOutWithRequest(m_inst,recursive)) 
	{ 
		Expand(1);
		Expand(2);
		m_doc->RefreshAllItemsByType(APL_TREE_ITEM_PROJECT);
	}
}

//****************************************************************
void CaplProjectTreeItem::ShowAllVersion(bool showMsg)
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	if(m_inst==0) return;
	if(m_inst->GetAccessmode()>aplRO){AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return;}

	if(m_has_version) HideAllVersion();

	aplExtent ext_rev,top_rev;
	int i;

	if(m_rev) return;

	StartBusy();
	//   
	SetStatusString( APL_T("  "));
	m_doc->m_project_mgr->LoadProjectInfo(m_inst);
	m_doc->m_project_mgr->GetAllProjectVersion(m_inst,ext_rev);

	CaplInstance *lock=0;
	m_doc_data.GetAttr(m_inst,m_doc->m_project_mgr->a_project_locker_adm_version,lock);

	SetStatusString(_T(""));
	StopBusy();
	if(ext_rev.Size<=0) {if(showMsg) AfxMessageBox( APL_T("  !")); return;}
	//  

	//   
	CaplInstance *inst=0;
	
	for(i=0;i<ext_rev.Size;i++)
	{
		if(ext_rev[i]==0) continue;
		if(ext_rev[i]->GetType()==0) continue;
		m_doc_data.GetAttr(ext_rev[i],m_doc->m_project_mgr->a_project_adm_ver_parent,inst);
		if(inst==0) 
		{
			if(ext_rev[i]!=lock) top_rev.Add(ext_rev[i]);
			ext_rev.Remove(i);
			i--;
		}
		else if(inst->GetAccessmode()>aplRO) 
		{
			top_rev.Add(ext_rev[i]);
			ext_rev.Remove(i);
			i--;
		}
		if(ext_rev[i]==lock) //    
		{
			ext_rev.Remove(i);
			i--;
		}
	}
	if(ext_rev.Size<=0 && top_rev.Size<=0) {AfxMessageBox( APL_T("  !")); return;}
	
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(FALSE);
	//  
	bool oldShowContents=m_ShowContentsOnExpand;
	m_ShowContentsOnExpand=false;
	for(i=0;i<top_rev.Size;i++)
	{
		CaplProjectTreeItem *project_item=
			new CaplProjectTreeItem(m_tree,m_doc,m_inst);
		project_item->m_rev=top_rev[i];
		project_item->m_parent_project_item=this;
		project_item->CreateTreeItem(m_item);
		m_all_version.Add(top_rev[i]);
		
		project_item->RefreshItem();
		project_item->InsertRevisionInTree(ext_rev,this);
		project_item->m_ShowContentsOnExpand=false;
		if(ext_rev.GetSize()) m_tree->Expand(project_item->m_item,TVE_EXPAND);
		project_item->m_ShowContentsOnExpand=true;

	}
	m_ShowContentsOnExpand=oldShowContents;
	if(m_ExecMyExpand)
		MyExpand(false);
	Sort();
	StopBusy();
	if(m_bShowNoFoundMessage) m_tree->SetRedraw(TRUE);
	m_tree->Select(m_item,TVGN_FIRSTVISIBLE);
	m_has_version=true;
}

void CaplProjectTreeItem::InsertRevisionInTree(aplExtent &ext_rev,CaplProjectTreeItem *parent_project_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	//  
	CaplInstance *inst=0;
	//m_pDocItem=docitem;
	bool b=false;
	for(int i=0;i<ext_rev.Size;i++)
	{

		if(ext_rev[i]==0) continue;
		if(ext_rev[i]->GetType()==0) continue;

		m_doc_data.GetAttr(ext_rev[i],m_doc->m_project_mgr->a_project_adm_ver_parent,inst);
		if(inst==m_rev)
		{
			b=true;
			CaplProjectTreeItem *project_item=
				new CaplProjectTreeItem(m_tree, m_doc, m_inst);
			project_item->m_rev=ext_rev[i];
			project_item->m_parent_project_item=parent_project_item;
			project_item->CreateTreeItem(m_item);
			m_all_version.Add(ext_rev[i]);
			project_item->RefreshItem();	
			project_item->InsertRevisionInTree(ext_rev,parent_project_item);
		}
	}
	if(b)
	{
		bool oldShowContents=m_ShowContentsOnExpand;
		m_ShowContentsOnExpand=false;
		Sort();
		m_tree->Expand(m_item,TVE_EXPAND);
		m_ShowContentsOnExpand=oldShowContents;
	}
}

void CaplProjectTreeItem::HideAllVersion()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID

	int i;
	m_tree->SetRedraw(FALSE);
	for(i=0;i<m_doc->m_items.Size;i++)
	{
		if(m_doc->m_items[i]->m_type==APL_TREE_ITEM_PROJECT)
		{
			CaplProjectTreeItem *item=(CaplProjectTreeItem*)m_doc->m_items[i];
			if(item->m_parent_project_item==this) {m_doc->m_items.Remove(i); i--;}
		}
	}
	m_all_version.Clear();
	m_tree->SetRedraw(TRUE);
	m_has_version=false;
}

//****************************************************************
void CaplProjectTreeItem::CreateDoc(CaplInstance *inst_for_id, LPCTSTR file_name)
{
	int ref_type;
	m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "),ref_type,0);

	if(ref_type==0)
	{
		CaplTreeItem::CreateDoc(inst_for_id,file_name);
	}
	else 
	{
		//  
		CString str_id,str_name;
		TCHAR *id=0;
		if(inst_for_id!=0)
		{
			GetInstID(inst_for_id,str_id,&str_name);
			id=(TCHAR*)LPCTSTR(str_id);
		}
		if(str_id==_T(""))
		{
			if(file_name!=0)
			{
				id=(TCHAR*)file_name;
				int i=0;
				while(file_name[i]!=_T('\0')) 
				{
					if(file_name[i]==_T('\\'))id=(TCHAR*)file_name+i+1;
					if(file_name[i]==_T(':'))id=(TCHAR*)file_name+i+1;
					i++;
				}
			}
		}	
		CaplInstance *instd=m_doc->m_api.m_doc_mgr.CreateDocument(id,str_name,0,0,file_name,true);
		if(instd==0) return ;
		
		CaplInstance *control_status=0;
		CChooseStatusDlg dlg;
		dlg.m_api=&m_doc->m_api;
		if(dlg.DoModal()==IDOK)
		{
			control_status=dlg.m_chosen_status;
		}
		
		CaplInstance *rel=m_doc->m_project_mgr->CreateAssociation(m_inst,instd,0,0,control_status);
		if(rel)
		{
			CaplDocTreeItem *new_item=0;
			InsertInstInTree(instd,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0) new_item->m_project=m_inst;
			MyExpand(false);
		}
	}
	

}



