// aplRecAlertTreeItem.cpp: implementation of the CaplRecAlertTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplSubstTreeItem.h"
#include "PSMDoc.h"
#include "resource.h"
#include "TreeProductItem.h"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplSubstTreeItem::CaplSubstTreeItem(CTreeCtrl *tree, CPSMDoc* pDoc, LPCTSTR name)
{
	m_doc = pDoc;
	m_tree = tree;
	m_type = _T("Subst");
	m_subst_name=name;
	if(m_doc)
		m_doc->m_items.Add(this);
	m_expanded = false;
	m_pdr=0;
	m_bReloadContentOnExpand=true;
	RefreshItem();
}

CaplSubstTreeItem::~CaplSubstTreeItem()
{

}

bool CaplSubstTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
    if(m_tree==0) return false;
    if(m_doc==0) return false;
	CString name;
	GetName(name);
	InsetItem(name,ICON_PROD,parent_item);
	SetItemImage(ICO_REL_ALTERNATE,IDX_IL_TREE_REL_TYPE,false);
	m_expanded=false;
	RefreshItem();
	return true;
}

bool CaplSubstTreeItem::GetName(CString &name)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	if(!m_substitutes.GetSize()) return false;
	CHECK_GET_NAME(m_substitutes[0]);
	
	m_doc_data.GetAttr(m_substitutes[0],m_doc->m_api.m_prd_mgr.a_pdf_subst_name,m_subst_name);
	m_doc_data.GetAttr(m_substitutes[0],m_doc->m_api.m_prd_mgr.a_pdf_subst_description,m_subst_descr);
	name= APL_T(": ")+m_subst_name;
	if(m_subst_descr!=_T(""))
	{
		name+=_T(" : ");
		name+=m_subst_descr;
	}

	return true;
}

void CaplSubstTreeItem::GetAccessedinstances(aplExtent& ext)
{
	ext.Clear();
	ext.Append(m_substitutes);
}

bool CaplSubstTreeItem::Expand(UINT action)
{
	if(action == 2)
	{
		if(m_expanded) return false;
		if(m_bReloadContentOnExpand && m_pdr)
		{
			SetStatusString( APL_T("  "));
			StartBusy();
			aplExtent ext_rel,ext_pdf;	
			m_doc->m_api.m_prd_mgr.LoadAllSubstitutes(m_pdr, ext_rel, ext_pdf,true);
			m_substitutes.Clear();
			CString buf;
			for(int i=0;i<ext_rel.GetSize();i++)
			{
				if(!ext_rel[i]) continue;
				if(!ext_rel[i]->GetType()) continue;
				if(ext_rel[i]->GetAccessmode()>aplRO) continue;
				m_doc_data.GetAttr(ext_rel[i],m_doc->m_api.m_prd_mgr.a_pdf_subst_name,buf);
				if(buf==m_subst_name) m_substitutes.Add(ext_rel[i]);
			}
			StopBusy();
			SetStatusString(_T(""));
		}
		if(!m_substitutes.GetSize()) return false;
		m_tree->SetRedraw(FALSE);
		if(!m_doc->m_api.m_data.IsConnected())
		{
			m_tree->SetRedraw();
			return false;
		}
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		for(int i=0;i<m_substitutes.GetSize();i++)
		{
			if(!m_substitutes[i]) continue;
			if(!m_substitutes[i]->GetType()) continue;
			CaplInstance *inst0=0;
			m_doc_data.GetAttr(m_substitutes[i],m_doc->m_api.m_prd_mgr.a_pdf_subst_pdf,inst0);
			if(inst0==0) continue;
			if(inst0->GetAccessmode()>aplRO) continue;
			CaplProductTreeItem *new_item=0;
			InsertInstInTree(inst0,m_item,m_doc,m_tree,m_all_items,0,(CaplTreeItem **)(&new_item));
			if(new_item!=0) 
			{
				new_item->m_subst=m_substitutes[i];
				new_item->m_prd_item_type=_T("substitute");
				new_item->RefreshItem();
			}
		}
		Sort();
		m_tree->SetRedraw(TRUE);
		m_expanded = true;
	}
	else if(action == 1)
	{
		m_all_items.Clear();
		CollapseItem();
	}
	return true;
}

bool CaplSubstTreeItem::ShowInListCtrl(CListCtrl* list)
{
	list->DeleteAllItems();

	int count=0;

	list->InsertItem(count, APL_T(":"));
	list->SetItemText(count,1,m_subst_name);
	count++;

	list->InsertItem(count, APL_T(""));
	list->SetItemText(count,1,m_subst_descr);
	count++;

	aplExtent ext;
	CStringArray  comment;
	
	if(m_pdr!=0){
		comment.Add(_T("m_pdr"));
		ext.Add(m_pdr);
	}
	
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}

//****************************************************************
bool CaplSubstTreeItem::RefreshItem()
{
//	int ItemIco = m_doc->m_api.GetInstIco(m_pdf);

	SetItemImage(ICO_REL_ALTERNATE,IDX_IL_TREE_REL_TYPE,false);
	//SetItemImage(ICON_PROD,IDX_IL_TREE_ITEM,false);
	CString buf;
	GetName(buf);
	if(m_tree!=0) m_tree->SetItemText(m_item,buf);

	return true;
}
//****************************************************************
void CaplSubstTreeItem::ShowProperties()
{
	if(m_doc==0) return;
/*	if(m_inst==0) return;
	if(m_inst->GetType()==0) return;
	if(m_inst->GetAccessmode()>aplRO) return;
	
	CaplInstance *item=0;
	m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_item,item);
	if(item) m_doc->m_api.LoadItemInfo(item);
	if(m_doc->m_api.m_message_mgr.ShowAlertProperties(m_inst))
	{
		if(m_inst->GetType()==0) 
		{
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		else
		{
			RefreshItem();
			Expand(1);
			Expand(2);
			MyExpand();
		}
	}*/
}
/*
void CaplSubstTreeItem::CreateAlert()
{
	CaplInstance *cur_person = m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	if(!cur_person)
	{
		AfxMessageBox(APL_T("     !"));
		return;
	}
	CaplInstance *default_recipient=0;
	if(m_type==_T("received")) default_recipient=cur_person;
	CaplInstance *new_alert=m_doc->m_api.m_message_mgr.CreateAlert(default_recipient);
	if(new_alert)
	{
		CaplInstance *author=0,*recipient=0;
		m_doc->m_api.m_data.GetAttr(new_alert,m_doc->m_api.m_message_mgr.a_alert_author,author);
		m_doc->m_api.m_data.GetAttr(new_alert,m_doc->m_api.m_message_mgr.a_alert_person,recipient);
		if(cur_person==recipient) 
		{
			if(m_type==_T("received")) 
			{
				CaplSubstTreeItem *new_item=0;
				InsertInstInTree(new_alert,m_item,m_doc,m_tree,m_sub_alerts,0,(CaplTreeItem **)(&new_item));
				if(new_item!=0)
				{
					new_item->m_type = m_type;
					new_item->RefreshItem();
				}
			}
			else
			{
				if(m_doc->m_RecAlert) 
				{
					m_doc->m_RecAlert->Expand(1);
					m_doc->m_RecAlert->Expand(2);
				}
			}
		}
		if(cur_person==author) 
		{
			if(m_type==_T("distributed")) 
			{
				CaplSubstTreeItem *new_item=0;
				InsertInstInTree(new_alert,m_item,m_doc,m_tree,m_sub_alerts,0,(CaplTreeItem **)(&new_item));
				if(new_item!=0)
				{
					new_item->m_type = m_type;
					new_item->RefreshItem();
				}
			}
			else
			{
				if(m_doc->m_DisAlert) 
				{
					m_doc->m_DisAlert->Expand(1);
					m_doc->m_DisAlert->Expand(2);
				}
			}
		}
		MyExpand(false);


	}
}
*/
//****************************************************************
bool CaplSubstTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_doc==0) return false;
/*	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU1));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_ALERT_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);

	CaplInstance *cur_person = m_doc->m_api.m_appr_mgr.GetCurrentPerson();
	bool m_bIsAdmin=m_doc->m_api.m_appr_mgr.IsAdmin();
	CaplInstance *author=0,*recipient=0;
	CString state=_T("");
	if(m_inst) 	
	{
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_state,state);
		if(state==_T("")) state=m_doc->m_api.m_message_mgr.m_alert_state_active;
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_author,author);
		m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_api.m_message_mgr.a_alert_person,recipient);
		if(state==m_doc->m_api.m_message_mgr.m_alert_state_active) 
			pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
		else 
			pPopup->RemoveMenu(ID_MARK_COMPLETED, MF_BYCOMMAND);
		if(!m_bIsAdmin)
		{
			if(author!=cur_person)
			{
				pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
				//if(state==m_doc->m_api.m_message_mgr.m_alert_state_completed) pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
			}
		}
		pPopup->EnableMenuItem(ID_CREATE_ALERT, MF_BYCOMMAND | MF_GRAYED);
	}
	else
	{
		pPopup->RemoveMenu(ID_MARK_COMPLETED, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
	}
	
	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);

	switch(res)
	{
		case ID_SHOW_PROPERTIES:
			{
				ShowProperties();
			}
			break;
		case ID_DELETE:
			{
				if(AfxMessageBox(APL_T("     ?"),MB_YESNO)==IDYES)
				{
					if(m_doc->m_api.m_message_mgr.DeleteAlert(m_inst))
					{
						m_doc->m_items.Remove(m_doc->m_items.Find(this));
					}
				}
			}
			break;
		case ID_MARK_COMPLETED:
			{
				if(m_doc->m_api.m_message_mgr.SetAlertState(m_inst,m_doc->m_api.m_message_mgr.m_alert_state_completed))
				{
					if(m_inst->GetType()==0) 
					{
						m_doc->m_items.Remove(m_doc->m_items.Find(this));
					}
					else RefreshItem();
				}
			}
			break;
		case ID_MARK_ACTIVE:
			{
				if(m_doc->m_api.m_message_mgr.SetAlertState(m_inst,m_doc->m_api.m_message_mgr.m_alert_state_active))
				{
					RefreshItem();
				}
			}
			break;
		default: PrepareContextMenu(res); 
	}	
	*/
	return true;
}

//****************************************************************
bool CaplSubstTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(item->m_type!=APL_TREE_ITEM_PRODUCT)	return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
	CaplProductTreeItem *pasted_item=(CaplProductTreeItem*)item;
	if(!pasted_item) return false;
	if(!pasted_item->m_pdf) return false;
	
	CaplProductTreeItem *parent_item=(CaplProductTreeItem*)GetParentItem(this);
	if(!parent_item) return false;
	return parent_item->CreateSubstitute(pasted_item,m_subst_name,m_subst_descr);

}