#include "stdafx.h"
#include "dictionary.h"

#include "PSMDoc.h"

/*#include "aplTopLevelItem.h"
#include "aplFolderTreeItem.h"
#include "aplMessageTreeItem.h"*/
#include "aplMessageFolderTreeItem.h"
#include "aplTreeActivityItem.h"
#include "aplTreeProcessTmplItem.h"
#include "aplTreeTaskItem.h"
#include "TabView.h"

#include "resource.h"

//CaplActivityTreeItem
CaplActivityTreeItem::CaplActivityTreeItem(CTreeCtrl *tree, CPSMDoc *doc, CaplInstance* inst)
{
	m_type= APL_TREE_ITEM_ACTIVITY;
	m_doc= doc;
	m_tree= tree;
	m_activity= inst;
	if(doc!=0) 
		doc->m_items.Add(this);	
}

bool CaplActivityTreeItem::GetName(CString &name)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	CHECK_GET_NAME(m_activity);
	CString buf;

	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_action_id, name);
	name+=_T(" : ");
	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_action_name, buf);
	name+=buf;

	return true;
}

bool CaplActivityTreeItem::RefreshItem()
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	
/*	UINT ico= ICON_MESSAGES;
	
	if(m_tree!=0)
	{
		CString name, buf, buf1;
		GetName(name);
		
		if(name==APL_T("")) ico+=1;
		if(name==APL_T("")) ico+=2;

		m_tree->SetItemText(m_item, name);
		m_tree->SetItemImage(m_item, ico, ico);
		
		Sort();
		m_tree->RedrawWindow();
	}
	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);*/
	return true;
}

bool CaplActivityTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
  	
	CString buf;
	GetName(buf);
	UINT ico= ICON_ACTIVITY;

	InsetItem(buf,ico,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"), 0, 0, m_item);

	m_expanded=false;

	return true;
}

bool CaplActivityTreeItem::Expand(UINT action)
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	
	if(action==2)
	{
		if(m_expanded) return true;
		if(m_hasSubItem) Expand(1);
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		ShowSupProcessTmpl();
		m_tree->SetRedraw(TRUE);
		Sort();
	}
	else if(action==1)
	{
		CollapseItem();
		m_task_history_items.Clear();
		m_sub_proc_tmpl_items.Clear();
	}
	return true;
}

void CaplActivityTreeItem::ShowProperties()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	m_doc->m_wf_mgr.ShowTmplProperties(m_activity);	
}

bool CaplActivityTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	else list->DeleteAllItems();
	if(m_doc==0)return false;
	if(m_doc->m_BShowInListCtrl==false) return true;
	
	CHECK_SHOW_LIST_CTRL(m_activity);

	CString buf;
	int i= list->InsertItem(0,  APL_T(":"));
	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_action_id, buf);
	list->SetItemText(i, 1, buf);
	i= list->InsertItem(1,  APL_T(":"));
	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_action_name, buf);
	list->SetItemText(i, 1, buf);
	i= list->InsertItem(2,  APL_T(":"));
	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_action_dscr, buf);
	list->SetItemText(i, 1, buf);
	
	i= list->InsertItem(3, _T(""));
	
	i= list->InsertItem(4,  APL_T(" :"));
	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_activity_st_mode, buf);
	if(buf==_T("manual")) buf=  APL_T("");
	else if(buf==_T("auto")) buf=  APL_T("");
	list->SetItemText(i, 1, buf);
	
	i= list->InsertItem(5,  APL_T(" :"));
	m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_activity_fn_mode, buf);
	if(buf==_T("manual")) buf=  APL_T("");
	else if(buf==_T("auto")) buf=  APL_T("");
	
	i= list->InsertItem(6,  APL_T(":"));
	GetAccessName(m_activity, buf);
	list->SetItemText(i, 1, buf);


	aplExtent ext;
	CStringArray  comment;

	comment.Add(_T("m_activity"));
	ext.Add(m_activity);
	
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}

void CaplActivityTreeItem::ShowCmd(long cmd)
{
	
}

BOOL CaplActivityTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
/*	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
	case ID_SHOW_ALL_LOT:
	case ID_SHOW_ALL_PRD_INST:
	case ID_CREATE_APPROVAL:
	case ID_SHOW_ALL_VERSION:
	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}*/
	return FALSE;
}

bool CaplActivityTreeItem::TrackPopupMenu(CWnd* wnd, CPoint &point, UINT view_mode)
{
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_ACTIVITY_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	if(m_activity)
	{
		AppendAddIn((CMenu*)pPopup);
		UpdateMenu((CMenu**)&pPopup, view_mode);
	}

	BOOL res = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,
						point.x, point.y, wnd);
	switch (res)
	{
		case ID_ACTIVITY_HISTORY:
			ShowHistory();
			ShowSupProcessTmpl();
			if(!IsExpandet())
			{
				m_hasSubItem= true;
				m_expanded= true;
				MyExpand();
			}
			break;
		case ID_SHOW_WF_TEMPL_SCHEMA:
			m_doc->m_wf_mgr.ShowTemplateSchema(0,m_activity);
			break;
/*		case ID_SHOW_PROPERTIES:
			break;*/
		default: PrepareContextMenu(res);
			break;
	}
	return true;

}
 
void CaplActivityTreeItem::ShowSupProcessTmpl()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID

	if(m_activity)
	{
		CaplInstance* inst= NULL;
		CaplAggr aggr;
		m_doc_data.GetAttr(m_activity, m_doc->m_wf_mgr.a_activity_sub_proc_tmpl, aggr);
		
		for(int i= 0; i<aggr.GetSize(); i++)
		{
			aggr.GetByIndex(i, inst);
			if(inst && -1==m_sub_proc_tmpl_items.Find(inst))
			{
				CaplProcessTmplTreeItem* item= new CaplProcessTmplTreeItem(
					m_tree, m_doc, inst);
				item->CreateTreeItem(m_item);
				m_sub_proc_tmpl_items.Add(inst);
				inst= NULL;
			}
		}
	}
}

void CaplActivityTreeItem::ShowHistory()
{
	_APL_TREE_ITEM_CHEK_PARAM_VOID
	
	CaplInstance *user= m_doc->m_api.m_appr_mgr.GetCurrentPerson();

	if(m_activity)
	{
		aplExtent ext;
		m_doc->m_wf_mgr.GetActivityHistory(user, m_activity, ext);

		for(int i= 0; i<ext.GetSize(); i++)
		{
			if(-1==m_task_history_items.Find(ext[i]))
			{
				CaplTaskTreeItem* item= new CaplTaskTreeItem(m_tree, m_doc, ext[i]);
				item->CreateTreeItem(m_item);
				m_task_history_items.Add(ext[i]);
			}
		}
	}
}

void CaplActivityTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_activity){if(m_activity->GetType()!=0)ext.Add(m_activity);}
}
