#ifndef _APL_TASK_TREE_ITEM_H_
#define _APL_TASK_TREE_ITEM_H_

#include "aplTreeItem.h"

//     
#define APL_WF_SWOW_SP 2
#define APL_WF_SHOW_WO 1
  
class CaplTaskTreeItem: public CaplTreeItem
{
public:
	CaplTaskTreeItem(CTreeCtrl *tree= 0, CPSMDoc *doc= 0, CaplInstance* inst= 0, long g_mode= APL_WF_SHOW_WO );
    bool GetName(CString &name);
    bool RefreshItem();
	bool RefreshParentProcess();
    bool CreateTreeItem(HTREEITEM parent_item);
	bool Expand(UINT action);
	void ShowProperties();
	bool ShowInListCtrl(CListCtrl *list);
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	void ShowWorkObjects();
	void ShowSubProcesses();
	bool PasteItem(CaplTreeItem *item, CPoint *point= NULL);
	bool CreateProduct();
	bool CreateDocument();
	bool CreateRefusal(CaplInstance *baserefusal=0); // baserefusal -       
	bool CreateCopyRefusal();
	void GetAccessedInstances(aplExtent &ext);
	
	bool CreateSubprocess(CaplInstance* proc_or_tmpl);

	bool ShowParentProcess();
	bool ShowParentTasks();

public:
	long m_g_mode;
	bool m_bProcShow;
	bool m_bPrevShow;

	bool m_bIsParent; //   

	CaplInstance* m_task;
	aplExtent m_sub_proc_items;
	aplExtent m_work_obj_items;

	static bool m_ShowSuspended;
	static bool m_ShowCompleted;
	static bool m_ShowCanceled;

	static bool CheckNewTasks(CPSMDoc* doc);
};

#endif //_APL_TASK_TREE_ITEM_H_