// apl_lot_item.cpp

#include "stdafx.h"
#include "PSMDoc.h"
#include "resource.h"
#include "aplTreeApprovalItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "TreeProductItem.h"
#include "aplFolderTreeItem.h"
#include "aplTreeCharacteristicItem.h"
#include "aplCharacteristicGroupTreeItem.h"
#include "aplDocTreeItem.h"
#include "TabView.h"

//****************************************************************
//****************************************************************
//****************************************************************

CaplLotTreeItem::CaplLotTreeItem(CTreeCtrl *tree, CPSMDoc *doc,
		CaplInstance *lot)
{
	m_type=APL_TREE_ITEM_LOT;
	m_tree=tree;
	m_doc=doc;
	m_lot=lot;
	m_folder=0;
	m_classifier=0;
	m_prd_inst_rel=0;
	m_parent_lot=0;
	m_parent_prd_inst=0;
	if(doc!=0) doc->m_items.Add(this);
}
//****************************************************************
bool CaplLotTreeItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	int ico = ICON_LOT;
	if(m_lot)
		ico = m_doc->m_api.GetInstIco(m_lot);
	InsetItem(buf,ico,parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}
//****************************************************************
bool CaplLotTreeItem::GetName(CString &name)
{
	name=_T("?");
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	m_doc->m_api.GetItemName(m_lot,name);

//	if(m_doc!=0)
//	{
//		if(m_lot!=0)
//		{
//			CString buf,buf1;
//			m_doc_data.GetAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_id,name);
//			CaplInstance *pdf;
//			m_doc_data.GetAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_pdf,pdf);
//			if(pdf!=0)
//			{
//				m_doc->m_api.m_prd_inst_mgr.GetItemName(pdf,buf);
//				if(buf!=_T(""))	{ name+=_T(" {"); name+=buf; name+=_T("}");}
//			}
//			CaplInstance *inst0,*inst1;
//			double count;
//			m_doc_data.GetAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_size,inst0);
//			if(inst0!=0)
//			{
//				m_doc_data.GetAttr(inst0,m_doc->m_api.m_prd_inst_mgr.a_mwu_val,count);
//				m_doc_data.GetAttr(inst0,m_doc->m_api.m_prd_inst_mgr.a_mwu_unit,inst1);
//				m_doc->m_api.m_charact_mgr.GetUnitName(inst1,buf);
//				buf1.Format(_T(" [%g %s]"),count,buf);
//				name+=buf1;
//			}
//		}
//	}
	return true;
}
//****************************************************************
bool CaplLotTreeItem::RefreshItem()
{
	CString buf;
	GetName(buf);
	if(m_tree!=0) m_tree->SetItemText(m_item,buf);
	if(0!=m_parent_prd_inst) SetItemImage(ICO_REL_WHERE_USED, IDX_IL_TREE_REL_TYPE);

	if(m_doc->m_tab_view->m_item_old==this) m_doc->ChangeItem(this);
	return true;
}
//****************************************************************
void CaplLotTreeItem::ShowProperties()
{
	if(m_doc==0) return;
	if(m_lot==0) return;
	if(m_doc->m_api.m_prd_inst_mgr.ShowLotProperties(m_lot))RefreshItem();

}
//****************************************************************
void CaplLotTreeItem::ShowCmd(long cmd)
{
	switch (cmd)
	{
	case ID_SHOW_ALL_PRD_INST: ShowPrdInstances(); break;
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_lot); break;
	case ID_SHOW_ALL_BP_INST: ShowAllBPInst(m_lot,true); break;
	case ID_SHOW_ALL_BP: ShowAllBPs(m_lot,true); break;
	default: PrepareContextMenu(cmd);break;
	}
}

BOOL CaplLotTreeItem::ShowToolBarButton(CCmdUI* pCmdUI)
{
	if(pCmdUI->m_nID==ID_SET_INST_ACCSESS)
	{
		aplExtent instances;
		GetAccessedInstances(instances);
		if(instances.GetSize()>0)
		{
			if(instances[0]->GetAccessmode()==aplOWN) return TRUE;
		}
		return FALSE;
	}


	switch(pCmdUI->m_nID)
	{
	case ID_SHOW_ALL_DOCS:
	case ID_SHOW_ALL_CHARACTERISTIC:
	case ID_SHOW_ALL_APPROVAL:
//	case ID_PRODUCT_SHOW_ALL_ZAGOTOV:
//	case ID_SHOW_ALL_LOT:
	case ID_SHOW_ALL_PRD_INST:
	case ID_SHOW_ALL_BP_INST:
	case ID_SHOW_ALL_BP:
	case ID_CREATE_APPROVAL:
//	case ID_SHOW_ALL_VERSION:
//	case ID_CREATE_PRODUCT:
	case ID_CREATE_CHARACTERISTIC:
	case ID_CREATE_DOC:
	case ID_SHOW_NOTES:
	case ID_CREATE_NOTE:
		pCmdUI->Enable(TRUE); return TRUE; break;
	}
	return FALSE;
}
//****************************************************************
bool CaplLotTreeItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	if(m_lot==0) return false;
	if(m_doc==0) return false;
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_TREE_CONTEXT_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(wnd); // 	VERIFY(CaplMenu::Install(wnd, ePopupMenu ));
    CMenu* pPopup = menu.GetSubMenu(INDEX_LOT_MENU);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return false;

	AppendAddIn((CMenu*)pPopup);
	UpdateMenu((CMenu**)&pPopup, view_mode);


	if(m_folder==0)pPopup->EnableMenuItem(ID_REMOVE_FROM_FOLDER, MF_BYCOMMAND | MF_GRAYED);
	if(m_classifier==0){pPopup->EnableMenuItem(ID_REMOVE_FROM_CLASSIFIER, MF_BYCOMMAND | MF_GRAYED);}
	CaplInstance *pdf;
	m_doc_data.GetAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_pdf,pdf);
	if(pdf==0)
	{
		//pPopup->EnableMenuItem(ID_CREATE_PRD_INST, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_BASE_PDF, MF_BYCOMMAND | MF_GRAYED);
	}

	if(m_prd_inst_rel==0) pPopup->EnableMenuItem(ID_PRODUCT_REMOVE_RELATION, MF_BYCOMMAND | MF_GRAYED);
	if(m_parent_lot==0) pPopup->EnableMenuItem(ID_REMOVE_FROM_LOT, MF_BYCOMMAND | MF_GRAYED);

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,wnd);
	switch(res)
	{
	case ID_SHOW_CONTAINED_FOLDER:
		ShowContainedFolder(m_lot);
		break;
	case ID_SHOW_CONTAINED_MESSAGE: ShowContainedMessage(m_lot); break;
	case ID_SHOW_CONTAINED_TASKS: ShowContainedTasks(m_lot); break;
	case ID_SHOW_CONTAINED_ALERT: ShowContainedAlert(m_lot); break;

	case ID_SHOW_CONTAINED_CLASSIFIER:
		ShowContainedClassifier(m_lot);
		break;
		
	case ID_SHOW_ALL_INST: ShowPrdInstances();	break;
	case ID_SHOW_ALL_BP_INST: ShowAllBPInst(m_lot,true);break;
	case ID_SHOW_ALL_BP: ShowAllBPs(m_lot,true);break;
	case ID_CREATE_PRD_INST:
		{
			CaplInstance *prd_inst=m_doc->m_api.m_prd_inst_mgr.CreatePrdInst(pdf,m_lot);
			if(prd_inst!=0)
			{
				CaplPrdInstTreeItem *new_item= new CaplPrdInstTreeItem(m_tree,m_doc,prd_inst);
				new_item->CreateTreeItem(m_item);
				m_all_prd_inst.Add(prd_inst);
				MyExpand();
			}
		}
		break;
	case ID_CREATE_LOT:
		{
			CaplInstance *lot=m_doc->m_api.m_prd_inst_mgr.CreateLot(pdf,m_lot);
			if(lot!=0)
			{
				CaplLotTreeItem *lot_item= new CaplLotTreeItem(m_tree,m_doc,lot);
				lot_item->CreateTreeItem(m_item);
				lot_item->m_parent_lot=m_lot;
				m_all_lots.Add(lot);
				MyExpand();
			}
		}
		break;
	case ID_REMOVE_FROM_FOLDER:
		if(m_folder!=0)
		{
			if(m_doc->m_api.m_folder_mgr.RemoveFromFolder(m_folder,m_lot))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_REMOVE_FROM_CLASSIFIER:
		if(m_classifier!=0)
		{
			if(m_classifier->GetAccessmode()>aplRW)	{AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return true;}
			if(m_doc->m_api.m_classifier_mgr.DeleteClassifierAssociation(m_lot,m_classifier))
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
		}
		break;
	case ID_REMOVE_FROM_LOT:
		if(m_parent_lot!=0)
		{
			if(m_lot==0) return false;
			if(m_lot->GetType()==0) return false;
			if(m_lot->GetAccessmode()>=aplRO) {AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return false;}
			if(m_parent_lot->GetType()==0) return false;
			if(m_parent_lot->GetAccessmode()>=aplRO) {AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP); return false;}
			m_doc_data.PutAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_parent,(CaplInstance*)0);
			m_doc_data.NET_SaveChanges();
			m_doc->m_items.Remove(m_doc->m_items.Find(this));
			return true;
		}
		break;
	case ID_PRODUCT_REMOVE_RELATION:
		{
			if(m_prd_inst_rel!=0)
			{
				CaplInstance *parent;
				m_doc_data.GetAttr(m_prd_inst_rel,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_rel_relating,parent);
				if(parent==0) return true;
				if(parent->GetId()==0) return true;
				if(parent->GetAccessmode()>aplRW)
				{
					AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
					return true;
				}
				m_doc_data.DeleteInstance(m_prd_inst_rel);
				m_doc_data.NET_SaveChanges();
				m_doc->m_items.Remove(m_doc->m_items.Find(this));
				return true;
			}
		}
		break;
	case ID_SHOW_BASE_PDF:
		if(m_lot!=0)
		{
			CaplInstance *pdf=0;
			m_doc_data.GetAttrBN(m_lot,S::formation,pdf);
			if(pdf!=0)
			{
				m_doc->m_api.m_prd_mgr.LoadPrdInfo(pdf);
				CaplProductTreeItem *product_item=
					new CaplProductTreeItem(m_tree,m_doc,0,pdf);
				product_item->LoadProperties();
				product_item->CreateTreeItem(m_item);
				MyExpand(false);
			}
		}
		break;
	case ID_DELETE:
		{
			if(m_lot->GetAccessmode()>aplOWN)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return true;
			}
			if(AfxMessageBox( APL_T("      ?"),MB_YESNO)==IDYES)
			{
				if(m_doc->m_api.m_prd_inst_mgr.DeleteLot(m_lot))
				{
					m_doc_data.NET_SaveChanges();
					for(int i=0;i<m_doc->m_items.Size;i++)
					{
						if(m_doc->m_items[i]!=this)
						{
							if(m_doc->m_items[i]->m_type==m_type)
							{
								CaplLotTreeItem *item1=
									(CaplLotTreeItem*)m_doc->m_items[i];
								{
									if(item1->m_lot==m_lot)
									{m_doc->m_items.Remove(i); i--;}
								}
							}
						}
					}
					m_doc->m_items.Remove(m_doc->m_items.Find(this));
				}
			}
		}
		break;
	case ID_CREATE_CHARACTERISTIC: CreateCharacteristic(m_lot); break;
	case ID_CREATE_CHARACTERISTIC_GROUP: CreateCharacteristicGroup(m_lot);break;
	default: PrepareContextMenu(res); 
	}
	return true;
}
//***************************************************************
void CaplLotTreeItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
	if(m_lot!=0){if(m_lot->GetType()!=0)ext.Add(m_lot);}
}
//****************************************************************
bool CaplLotTreeItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	CHECK_SHOW_LIST_CTRL(m_lot);
	if(m_doc==0)return false;

	CString buf,buf1,buf2;
	int i=list->InsertItem(0, APL_T(":"));
	m_doc_data.GetAttrBN(m_lot,S::id,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(1, APL_T(":"));
	m_doc_data.GetAttrBN(m_lot,S::description,buf);
	list->SetItemText(i,1,buf);

	i=list->InsertItem(2, APL_T(":"));
	CaplInstance *inst1=0,*inst0=0;
	double size=0;
	m_doc_data.GetAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_size,(CaplInstance*)inst0);
	if(inst0!=0)
	{
		m_doc_data.GetAttr(inst0,m_doc->m_api.m_prd_inst_mgr.a_mwu_val,size);
		m_doc_data.GetAttr(inst0,m_doc->m_api.m_prd_inst_mgr.a_mwu_unit,inst1);

		m_doc->m_api.m_charact_mgr.GetUnitName(inst1,buf);
		buf.Format(_T("%f %s"),size,LPCTSTR(buf1));
		list->SetItemText(i,1,buf);
	}

	list->InsertItem(4,_T(""));
	i=list->InsertItem(5, APL_T(":"));
	GetAccessName(m_lot,buf);
	list->SetItemText(i,1,buf);

	aplExtent ext;
	CStringArray comment;
	if(m_lot!=0){ comment.Add( APL_T("")); ext.Add(m_lot);}
	if(m_parent_lot!=0){ comment.Add( APL_T(" ")); ext.Add(m_parent_lot);}
	if(m_prd_inst_rel!=0){ comment.Add( APL_T("")); ext.Add(m_prd_inst_rel);}
	if(m_classifier!=0){
		CaplInstance* classif_ref;
		m_doc->m_api.m_classifier_mgr.TestClassifierAssociation(m_lot,m_classifier,&classif_ref);
		if(classif_ref!=0){
			comment.Add(_T("classifier association"));
			ext.Add(classif_ref);
		}
		comment.Add(_T("m_classifier"));
		ext.Add(m_classifier);
	}
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}

//****************************************************************
bool CaplLotTreeItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	//_APL_TREE_ITEM_CHEK_PARAM

	if(action==2)
	{
		if(m_expanded) return true;
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		if(m_hasSubItem)Expand(1);
		
		//   
		if(m_ShowContentsOnExpand)
		{
			StartBusy();
			aplExtent ext;
			m_doc->m_api.m_prd_inst_mgr.LoadIncomingLots(m_lot,ext);
			for(int i=0;i<ext.Size;i++)
			{
				if(m_all_lots.Find(ext[i])>=0) continue;
				CaplLotTreeItem *lot_item= new CaplLotTreeItem(m_tree,m_doc,ext[i]);
				lot_item->CreateTreeItem(m_item);
				lot_item->m_parent_lot=m_lot;
				m_all_lots.Add(ext[i]);
			}
			StopBusy();
			ShowPrdInstances();
		}
			
			bool old = m_bShowNoFoundMessage;
			m_bShowNoFoundMessage = old;
			m_ExecMyExpand = true;
			if(m_doc->m_auto_expand_items.m_showintree_lot&APL_SHOW_DOC)
				ShowAllDocs(false,false);
			if(m_doc->m_auto_expand_items.m_showintree_lot&APL_SHOW_CHARACT)
				ShowAllCharacteristic(false);
			if(m_doc->m_auto_expand_items.m_showintree_lot&APL_SHOW_APPROVAL)
				ShowAllApproval(false);
			if(m_doc->m_auto_expand_items.m_showintree_lot&APL_SHOW_INST)
				ShowPrdInstances();
			if(m_doc->m_auto_expand_items.m_showintree_lot&APL_SHOW_BPINST)
				ShowAllBPInst(m_lot,false);
			m_bShowNoFoundMessage = old;
			m_ExecMyExpand = true;
		Sort();
	}
	else if(action==1)
	{
		CollapseItem();
		m_all_prd_inst.Clear();
		m_all_lots.Clear();
	}
	return true;
}
//****************************************************************
void CaplLotTreeItem::ShowPrdInstances()
{
	if(m_doc==0) return;
	if(m_lot==0) return;
	aplExtent ext;
	StartBusy();
	m_doc->m_api.m_prd_inst_mgr.FindAllLotProductInstance(m_lot,ext);
	for(int i=0;i<ext.Size;i++)
	{
		if(ext[i]!=0)
		{
			if(m_all_prd_inst.Find(ext[i])==-1)
			{
				CaplPrdInstTreeItem *new_item= 
					new CaplPrdInstTreeItem(m_tree,m_doc,ext[i]);
				new_item->CreateTreeItem(m_item);
				new_item->m_lot=m_lot;
				m_all_prd_inst.Add(ext[i]);
			}
		}
	}
	StopBusy();
	if(m_ExecMyExpand) MyExpand();
}/*
//****************************************************************
void CaplLotTreeItem::CreateCharacteristic(CaplInstance *val)
{
	CaplInstance *new_val=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristic(m_lot,val, &new_val,0,0,true))
	{

		if(CaplTreeItem::m_AutoUzurpireCharacteristic)
		{
			aplExtent ext; ext.Add(new_val);
			m_doc_data.NET_BecomeInstancesOwner(&ext);
		}

		CaplCharacteristicTreeItem *characteristic_item=
			new CaplCharacteristicTreeItem(m_tree,m_doc,new_val);
		characteristic_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(new_val);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}*/
//****************************************************************
bool CaplLotTreeItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if (item->m_type != APL_TREE_ITEM_DOCUMENT)
		if (item->m_type != APL_TREE_ITEM_CHARACTERISTIC)
			if (item->m_type != APL_TREE_ITEM_CHARACTERISTICGROUP)
				if (item->m_type != APL_TREE_ITEM_PRDINST)
					if (item->m_type != APL_TREE_ITEM_LOT)
						return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;

	if (item->m_type == APL_TREE_ITEM_PRDINST)
	{
		CaplPrdInstTreeItem *chitem=(CaplPrdInstTreeItem*)item;
		CaplInstance *lot1;
		m_doc_data.GetAttr(chitem->m_inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_lot,lot1);
		if(lot1==m_lot)
		{
			AfxMessageBox( APL_T("    "));
			return true;
		}
		if(AfxMessageBox( APL_T("         ?"),
			MB_YESNO|MB_ICONQUESTION)==IDYES)
		{
			if(chitem->m_inst->GetAccessmode()>aplRW)
			{
				AfxMessageBox(ID_NO_ACCESS_RIGHT,MB_OK|MB_ICONSTOP);
				return true;
			}
			CaplInstance *inst=chitem->m_inst;
			m_doc_data.PutAttr(inst,m_doc->m_api.m_prd_inst_mgr.a_prd_inst_lot,m_lot);

			//       
			for(int i=0;i<m_doc->m_items.Size;i++)
			{
				if (m_doc->m_items[i]->m_type == APL_TREE_ITEM_PRDINST)
				{
					if(((CaplPrdInstTreeItem*)(m_doc->m_items[i]))->m_inst==inst)
					{
						if(((CaplPrdInstTreeItem*)(m_doc->m_items[i]))->m_lot!=0)
							if(((CaplPrdInstTreeItem*)(m_doc->m_items[i]))->m_lot!=m_lot)
							{
								m_doc->m_items.Remove(i); i--;
							}
					}
				}
			}
			CaplPrdInstTreeItem *new_item= 
				new CaplPrdInstTreeItem(m_tree,m_doc,inst);
			new_item->CreateTreeItem(m_item);
			new_item->m_lot=m_lot;
			m_all_prd_inst.Add(inst);
			Sort();
		}
		return true;
	}
	else if (item->m_type == APL_TREE_ITEM_LOT)
	{
		CaplLotTreeItem *chitem=(CaplLotTreeItem*)item;
		CaplInstance *lot0,*lot1=chitem->m_lot;
		CaplInstance *pdf0,*pdf1;
		if(lot1==m_lot)
		{
			AfxMessageBox( APL_T("       !!!"),
				MB_OK|MB_ICONSTOP);
			return true;
		}	
		m_doc_data.GetAttr(lot1,m_doc->m_api.m_prd_inst_mgr.a_lot_parent,lot0);
		if(lot0==m_lot)
		{
			AfxMessageBox( APL_T("      !!!"),
				MB_OK|MB_ICONSTOP);
			return true;
		}
		m_doc_data.GetAttr(m_lot,m_doc->m_api.m_prd_inst_mgr.a_lot_pdf,pdf0);
		m_doc_data.GetAttr(lot1,m_doc->m_api.m_prd_inst_mgr.a_lot_pdf,pdf1);
		if(lot0!=0)
		{
			if(lot0==m_lot) 
			{
				AfxMessageBox( APL_T("    !!!"),MB_OK);
				return true;
			}
			AfxMessageBox( APL_T("       !!!"),
				MB_OK|MB_ICONSTOP);
			return true;
		}
		if(pdf0!=0)
		{
			if(pdf1!=pdf0)
			{
				AfxMessageBox( APL_T("       !!!"),
					MB_OK|MB_ICONSTOP);
				return true;
			}
		}
		//if(AfxMessageBox(APL_T("        ?"),
		//	MB_YESNO|MB_ICONQUESTION)==IDYES)
		{
			m_doc_data.PutAttr(lot1,m_doc->m_api.m_prd_inst_mgr.a_lot_parent,m_lot);
			m_doc_data.NET_SaveChanges();
			CaplLotTreeItem *lot_item= new CaplLotTreeItem(m_tree,m_doc,lot1);
			lot_item->CreateTreeItem(m_item);
			lot_item->m_parent_lot=m_lot;
			m_all_lots.Add(lot1);
			MyExpand();
			Sort();
		}
		return true;
	}

	CMenu menu;  gSetPsmResourceHandle();
	CMenu *pPopup;
	VERIFY(menu.LoadMenu(IDR_PASTE_ITEM_MENU));
// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(m_tree); // 	VERIFY(CaplMenu::Install(m_tree, ePopupMenu ));

	//if(item->m_type == APL_TREE_ITEM_PRODUCT)
	//	pPopup = menu.GetSubMenu(INDEX_PRODUCT_MENU);
	//else 
	if(item->m_type == APL_TREE_ITEM_DOCUMENT)
	{
		aplExtent ext;
		item->GetAccessedInstances(ext);
		CString state;
		m_doc_data.GetAttr(ext[0],m_doc->m_api.m_doc_mgr.a_apl_doc_wf_state,state);
		if(state==_T("canceled")) return false;
		pPopup = menu.GetSubMenu(INDEX_DOCUMENT_MENU);
	}
	else if((item->m_type == APL_TREE_ITEM_CHARACTERISTIC)||(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP))
		pPopup = menu.GetSubMenu(INDEX_CHARACTERISTIC_MENU);
	
	if(pPopup!=0)
	{
		POINT pnt;
		if(point==0)
		{
			RECT rect;
			m_tree->GetItemRect(m_item,&rect,TRUE);
			m_tree->ClientToScreen(&rect);
			pnt.x=rect.right;
			pnt.y=rect.bottom;
		}
		else
		{
			pnt.x=point->x;
			pnt.y=point->y;
		}

		HTREEITEM parent = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
		CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
		if(parent_item && parent_item->m_type==APL_TREE_ITEM_QUERY)
		{
			pPopup->EnableMenuItem(ID_DOCUMENT_MOVE, MF_BYCOMMAND|MF_GRAYED);
		}
		BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
			TPM_RIGHTBUTTON|TPM_RETURNCMD,pnt.x,pnt.y,m_tree);

		//  
		if (res == ID_DOCUMENT_COPY)
		{
			CaplInstance *i_doc=((CaplDocTreeItem *)item)->m_inst;

			HTREEITEM ht = m_tree->GetNextItem(item->m_item,TVGN_PARENT);
			CaplTreeItem *Item = (CaplTreeItem*)m_tree->GetItemData(ht);
			aplAccessModeType access =aplOWN;
			if(Item)
			{
				aplExtent instances;
				Item->GetAccessedInstances(instances);
				access = instances.GetAt(0)->GetAccessmode();
			}
			
			if(m_lot->GetAccessmode()>aplRW || access>aplRO)
			{
				AfxMessageBox( APL_T("   "));
				return false;
			}
			if(CaplDocTreeItem::InsertDoc(m_doc,this,&m_all_documents,i_doc,m_lot, false))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		else if(res == ID_DOCUMENT_BYDOT)
		{
			CaplInstance *inst = m_lot;
			CaplInstance *i_doc = ((CaplDocTreeItem *)item)->m_inst;

			aplExtent instances;
			GetAccessedInstances(instances);
			if(m_doc->m_api.m_doc_mgr.CreateDocumentByDot(i_doc,instances[0]))
				ShowCmd(ID_SHOW_ALL_DOCS);
		}
		// 
		else if(res == ID_DOCUMENT_MOVE)
		{
			CaplDocTreeItem *d_item = (CaplDocTreeItem*)item;
			HTREEITEM parent = m_tree->GetNextItem(d_item->m_item,TVGN_PARENT);
			CaplTreeItem *parent_item = (CaplTreeItem*)m_tree->GetItemData(parent);
			
			CaplDocTreeItem::MoveDocument(m_doc, d_item, parent_item, this);
		}
		//  
		else if (res == ID_CHARACTERISTIC_COPY)
		{
			if(item->m_type == APL_TREE_ITEM_CHARACTERISTIC)
			{
				CaplInstance *i_val=((CaplCharacteristicTreeItem *)item)->m_val;
				CreateCharacteristic(i_val);
			}
			else if(item->m_type == APL_TREE_ITEM_CHARACTERISTICGROUP)
			{
				CreateCharacteristicGroup(((CaplCharacteristicGroupTreeItem*)item)->m_group);
			}
		}
	}
	m_tree->RedrawWindow();
	return true;
}
//****************************************************************
bool CaplLotTreeItem::PasteFile(LPCTSTR file, CPoint *point)
{
	if(file==0) return false;
	CreateDoc(m_lot,file);
	return true;
}/*
//****************************************************************
void CaplLotTreeItem::CreateCharacteristicGroup(CaplInstance *group)
{
	CaplInstance *group_new=0;
	if(m_doc->m_api.m_charact_mgr.CreateCharacteristicGroup(m_lot,&group_new,group))
	{
		if(group!=0)
		{
			if(CaplTreeItem::m_AutoUzurpireCharacteristic)
			{
				aplExtent ext; ext.Add(group);
				m_doc_data.NET_BecomeInstancesOwner(&ext);
			}

		}
		CaplCharacteristicGroupTreeItem *characteristic_group_item=
			new CaplCharacteristicGroupTreeItem(m_tree,m_doc,group_new);
		characteristic_group_item->CreateTreeItem(m_item);
		m_all_caracteristic.Add(group_new);
		MyExpand();
		m_doc->ChangeItem(0);m_doc->ChangeItem(this);
	}
}*/
