#pragma once
#include <string>
#include <memory>

#ifdef aplAPI
#define aplAPI_DLL __declspec(dllexport)
#else
#define aplAPI_DLL __declspec(dllimport)
#endif

class QPdfWriter;
class QColor;
class QPen;
class QPainter;
class QFont;
class QString;
class QPageSize;
class QRect;

struct FontDescr
{
	bool italic;
	bool bold;

	FontDescr():italic(false), bold(false){}
	FontDescr(bool i, bool b):italic(i), bold(b){}
};

enum pdfAlignment
{
	aplAlignLeft,
	aplAlignCenter,
	aplAlignRight
};

namespace pageSize
{
	enum ps
	{
		A1,
		A2,
		A3,
		A4,
		A5
	};
}


#ifdef __cplusplus
extern "C" {
#endif
	extern aplAPI_DLL QPageSize* crtPageSizeDef();//A4
	extern aplAPI_DLL QPageSize* crtPageSize(const pageSize::ps& ps);
	extern aplAPI_DLL QPageSize* crtPageSizeMM(const int& w, const int& h);
	extern aplAPI_DLL void getPageSizePoint(const QPageSize* ps, int& w, int& h);
	extern aplAPI_DLL void getPageSizeMM(const QPageSize* ps, double& w, double& h);
	//
	extern aplAPI_DLL QPdfWriter* crtPdfWriterDef(const char* fileNamePdf);
	extern aplAPI_DLL QPdfWriter* crtPdfWriter(const char* fileNamePdf, QPageSize* ps);
	extern aplAPI_DLL void getCurrPageSizeMM(QPdfWriter* writer, double& w, double& h);
	//
	extern aplAPI_DLL bool addPageDef(QPdfWriter* w);
	extern aplAPI_DLL bool addPage(QPdfWriter* w, QPageSize* ps);//?? doesnt work properly
	//
	extern aplAPI_DLL QRect* crtRect(const int& x, const int& y, const int& w, const int& h);
	extern aplAPI_DLL QRect* crtRectDef(const int& w, const int& h);
	//
	extern aplAPI_DLL QPainter* crtPainter(QPdfWriter* writer, QRect* rect);
	extern aplAPI_DLL void endDraw(QPainter* dc);
	//extern aplAPI_DLL QPainter* startDraw(QPdfWriter * writer);

	extern aplAPI_DLL void testPdf1(const std::string& fileNamePdf);

	extern aplAPI_DLL QColor* getCurrColor();
	
	extern aplAPI_DLL char* getColorDescr(const QColor* clr);
	//
	extern aplAPI_DLL QColor* crtColor(int r, int g, int b);
	extern aplAPI_DLL QColor* crtColorByName(const char* nameColor);
	extern aplAPI_DLL void  setCurrColor(QColor *clr);
	//
	extern aplAPI_DLL QPen* crtPen(QColor *clr);
	extern aplAPI_DLL QPen* crtPenDef();
	extern aplAPI_DLL void setPenColor(QColor *clr, QPen * pen);
	extern aplAPI_DLL void setPen(QPen *pen, QPainter* dc);
	extern aplAPI_DLL void setPenWidthF(const double& w, QPen *pen);
	extern aplAPI_DLL void setPenWidth(const int& w, QPen *pen);
	extern aplAPI_DLL QFont* crtFont(const char* family, const FontDescr& fd);
	extern aplAPI_DLL void setFont(QFont *font, QPainter* dc);
	extern aplAPI_DLL QFont* crtFontByName(const char* family);
	extern aplAPI_DLL void setFontSizeF(const double&s, QFont *font);
	extern aplAPI_DLL void setFontPixelSize(const int&s, QFont *font);
	//
	extern aplAPI_DLL void addTextF(const double& x, const double& y, const char* text, QPainter* dc);
	extern aplAPI_DLL void addText(const int& x, const int& y, const char* text, QPainter* dc);
	//
	extern aplAPI_DLL void DrawLine(const double& x1, const double& y1, const double& x2, const double& y2,QPainter* dc);
	extern aplAPI_DLL void addRotateText(const double&degrees, const double& x, const double& y, const char* text, QPainter* dc);
	extern aplAPI_DLL void DrawRect(const double& x, const double& y, const double& w, const double& h,QPainter* dc);
	extern aplAPI_DLL void DrawRectText(const double& x, const double& y, const double& w, const double& h, const char* text, const pdfAlignment& align, QPainter* dc);
	extern aplAPI_DLL void DrawRectTextRotate(const double& degree, const double& x, const double& y, const double& w, const double& h, const char* text, const pdfAlignment& align, QPainter* dc);
	extern aplAPI_DLL void DrawImage(const double& x, const double& y, const double& w, const double& h, const char *file, QPainter* dc);
	//
	extern aplAPI_DLL void deleteFont(QFont * font);
	extern aplAPI_DLL void deletePen(QPen* obj);
	extern aplAPI_DLL void deleteColor(QColor* obj);
	extern aplAPI_DLL void deletePainter(QPainter* obj);
	extern aplAPI_DLL void deletePageSize(QPageSize* obj);
	extern aplAPI_DLL void deletePdfWriter(QPdfWriter* obj);
	extern aplAPI_DLL void deleteRect(QRect* obj);

#ifdef __cplusplus
}
#endif

namespace apl
{
namespace holder
{
	struct PainterTransform
	{
		PainterTransform(QPainter& dc);
		~PainterTransform();
		const QPainter& operator()()const{return dc_;}
		QPainter& operator()(){return dc_;}

	private:
		QPainter& dc_;
	};
}
//
namespace qt
{
	void first_initQt( int argc, char **argv );
	void first_initQt_def();;
	void initCodec();
	//
	//typedef std::tr1::shared_ptr<QColor> PColor;
	template<typename T>
	void cmnDeleter(T* t)
	{
		//if (t)
		{
			delete t;
			t = NULL;
			//t->deleteLater();
		}
	}

	struct StorageCurrentThing
	{
		QColor* color_;

		StorageCurrentThing();
	};

	StorageCurrentThing& getStorageCurrThing();

	char* copyCh(const char* source);

	QString convertRawChar(const char* pch);

	int MsgBox(const QString& text, const QString& caption);
	//
	void drawRectText(const double& x, const double& y, const double& w, const double& h, const QString& qs, const pdfAlignment& align, QPainter* dc);
}
}