// GSSetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ReportDict.h"
#include "GSSetupDlg.h"
#include "GroupSetup.h"
#include "SortParamsDlg.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGSSetupDlg dialog

CGSSetupDlg::CGSSetupDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CGSSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGSSetupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_section = NULL;
}


void CGSSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGSSetupDlg)
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDC_S_DEL, m_sDel_btn);
	DDX_Control(pDX, IDC_S_ADD, m_sAdd_btn);
	DDX_Control(pDX, IDC_G_DEL, m_gDel_btn);
	DDX_Control(pDX, IDC_G_ADD, m_gAdd_btn);
	DDX_Control(pDX, IDC_S_UP, m_up_s_btn);
	DDX_Control(pDX, IDC_S_DOWN, m_down_s_btn);
	DDX_Control(pDX, IDC_G_DOWN, m_down_g_btn);
	DDX_Control(pDX, IDC_G_UP, m_up_g_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_L_SORT, m_sort_list);
	DDX_Control(pDX, IDC_L_GROUPS, m_groups_list);
	DDX_Control(pDX, IDC_COLUMNS, m_columns_ds);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGSSetupDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CGSSetupDlg)
	ON_BN_CLICKED(IDC_G_ADD, OnGAdd)
	ON_BN_CLICKED(IDC_G_DEL, OnGDel)
	ON_BN_CLICKED(IDC_G_UP, OnGUp)
	ON_BN_CLICKED(IDC_G_DOWN, OnGDown)
	ON_BN_CLICKED(IDC_S_ADD, OnSAdd)
	ON_BN_CLICKED(IDC_S_DEL, OnSDel)
	ON_BN_CLICKED(IDC_S_UP, OnSUp)
	ON_BN_CLICKED(IDC_S_DOWN, OnSDown)
	ON_LBN_DBLCLK(IDC_L_GROUPS, OnDblclkLGroups)
	ON_LBN_DBLCLK(IDC_L_SORT, OnDblclkLSort)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGSSetupDlg message handlers

BOOL CGSSetupDlg::OnInitDialog() 
{
	int i;
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	m_up_g_btn.SetWindowText(_T(""));
	m_up_g_btn.SetIcon(aplGetStdIco16(APL_STD_TOP));
	m_down_g_btn.SetWindowText(_T(""));
	m_down_g_btn.SetIcon(aplGetStdIco16(APL_STD_BOTTOM));

	m_up_s_btn.SetWindowText(_T(""));
	m_up_s_btn.SetIcon(aplGetStdIco16(APL_STD_TOP));
	m_down_s_btn.SetWindowText(_T(""));
	m_down_s_btn.SetIcon(aplGetStdIco16(APL_STD_BOTTOM));

	m_gAdd_btn.SetWindowText(_T(""));
	m_gAdd_btn.SetIcon(aplGetStdIco16(APL_STD_RIGHT));
	m_gDel_btn.SetWindowText(_T(""));
	m_gDel_btn.SetIcon(aplGetStdIco16(APL_STD_LEFT));
	m_sAdd_btn.SetWindowText(_T(""));
	m_sAdd_btn.SetIcon(aplGetStdIco16(APL_STD_RIGHT));
	m_sDel_btn.SetWindowText(_T(""));
	m_sDel_btn.SetIcon(aplGetStdIco16(APL_STD_LEFT));
	
	if(m_section==NULL) 
	{
		EndDialog(0);
		return FALSE;
	}
	//  
	CArray<CHeaderColumn*, CHeaderColumn*> skip;
	int cnt = m_section->m_groups.GetSize();
	for(i = 0; i<cnt; i++)
	{
		CGroupCol* gc = m_section->m_groups.GetAt(i);
		int ind = m_groups_list.AddString(gc->m_col->GetName());
		m_groups_list.SetItemData(ind, DWORD(gc));
		skip.Add(gc->m_col);
	}
	//  
	cnt = m_section->m_sorts.GetSize();
	for(i = 0; i<cnt; i++)
	{
		CSortColumn* sc = m_section->m_sorts.GetAt(i);
		int ind = m_sort_list.AddString(sc->m_column->GetName());
		m_sort_list.SetItemData(ind, DWORD(sc));
		skip.Add(sc->m_column);
	}
	//  
	for(i=0; i<m_section->m_ReportMgr->m_base_query->GetSize();i++)
	{
		CHeaderColumn* col = m_section->m_ReportMgr->m_base_query->GetColumn(i);
		if(col->m_type==aplINSTANCE) continue;
		int m_cnt = skip.GetSize();
		bool find = false;
		for(int j=0; j<m_cnt; j++)
			if(skip.GetAt(j)==col)
			{
				skip.RemoveAt(j);
				find = true;
				break;
			}
		if(find) continue;
		int ind = m_columns_ds.AddString(col->GetName());
		m_columns_ds.SetItemData(ind,DWORD(col));
	}
	for(i=0; i<m_section->m_ReportMgr->m_header->GetSize();i++)
	{
		CHeaderColumn* col = m_section->m_ReportMgr->m_header->GetColumn(i);
		if(col->m_type==aplINSTANCE) continue;
		int m_cnt = skip.GetSize();
		bool find = false;
		for(int j=0; j<m_cnt; j++)
			if(skip.GetAt(j)==col)
			{
				skip.RemoveAt(j);
				find = true;
				break;
			}
		if(find) continue;
		int ind = m_columns_ds.AddString(col->GetName());
		m_columns_ds.SetItemData(ind,DWORD(col));
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGSSetupDlg::OnGAdd() 
{
	int cur = m_columns_ds.GetCurSel();
	if(cur<0) return;
	DWORD data = m_columns_ds.GetItemData(cur);
	CGroupCol* col = new CGroupCol(m_section->m_ReportMgr);
	CGroupSetup dlg;
	dlg.m_GroupCol = col;
	col->m_col = (CHeaderColumn*)data;
	if(dlg.DoModal()!=IDOK) 
	{
		delete col;
		return;
	}
	m_added_group_cols.Add(col);
	col->m_lf = dlg.m_lf;
	CString str;
	m_columns_ds.GetText(cur, str);
	int ind = m_groups_list.AddString(str);
	m_groups_list.SetItemData(ind,DWORD(col));
	m_columns_ds.DeleteString(cur);
	m_groups_list.SetCurSel(ind);
	m_columns_ds.SetCurSel(cur);
}

void CGSSetupDlg::OnGDel() 
{
	int cur = m_groups_list.GetCurSel();
	if(cur<0) return;
	DWORD data = m_groups_list.GetItemData(cur);
	CGroupCol* col = (CGroupCol*)data;
	CString str;
	m_groups_list.GetText(cur, str);
	int ind = m_columns_ds.AddString(str);
	m_columns_ds.SetItemData(ind,DWORD(col->m_col));
	m_groups_list.DeleteString(cur);
	m_columns_ds.SetCurSel(ind);
	int cnt = m_added_group_cols.GetSize();
	for(int i=0; i<cnt;i++)
	{
		if(col==m_added_group_cols.GetAt(i))
		{
			m_added_group_cols.RemoveAt(i);
//			delete col;
			return;
		}
	}
	m_deleted_group_cols.Add(col);
}

void CGSSetupDlg::OnGUp() 
{
	int cur = m_groups_list.GetCurSel();
	if(cur<1) return;
	DWORD data = m_groups_list.GetItemData(cur);
	CString str;
	m_groups_list.GetText(cur, str);
	m_groups_list.DeleteString(cur);
	int ind = m_groups_list.InsertString(cur-1,str);
	m_groups_list.SetItemData(ind,data);
	m_groups_list.SetCurSel(ind);
}

void CGSSetupDlg::OnGDown() 
{
	int cur = m_groups_list.GetCurSel();
	if(cur<0) return;
	if(cur>=m_groups_list.GetCount()-1) return;
	DWORD data = m_groups_list.GetItemData(cur);
	CString str;
	m_groups_list.GetText(cur, str);
	m_groups_list.DeleteString(cur);
	int ind = m_groups_list.InsertString(cur+1,str);
	m_groups_list.SetItemData(ind,data);
	m_groups_list.SetCurSel(ind);
}

void CGSSetupDlg::OnSAdd() 
{
	int cur = m_columns_ds.GetCurSel();
	if(cur<0) return;
	DWORD data = m_columns_ds.GetItemData(cur);
	CSortColumn* SortCol = new CSortColumn(m_section->m_ReportMgr);
	SortCol->m_column = (CHeaderColumn*)data;
	CSortParamsDlg dlg;
	dlg.m_col = SortCol;
	if(dlg.DoModal()!=IDOK)
	{
		delete SortCol;
		return;
	}
	m_added_sort_cols.Add(SortCol);
	CString str;
	m_columns_ds.GetText(cur, str);
	int ind = m_sort_list.AddString(str);
	m_sort_list.SetItemData(ind, (DWORD)SortCol);
	m_columns_ds.DeleteString(cur);
	m_sort_list.SetCurSel(ind);
	m_columns_ds.SetCurSel(cur);
}

void CGSSetupDlg::OnSDel() 
{
	int cur = m_sort_list.GetCurSel();
	if(cur<0) return;
	CSortColumn* col = (CSortColumn*)m_sort_list.GetItemData(cur);
	CString str;
	m_sort_list.GetText(cur, str);
	int ind = m_columns_ds.AddString(str);
	m_columns_ds.SetItemData(ind, (DWORD)col->m_column);
	m_sort_list.DeleteString(cur);
	m_columns_ds.SetCurSel(ind);
	if(m_added_sort_cols.Find(col)>-1)
		m_added_sort_cols.Remove(col);
	else
		m_deleted_sort_cols.Add(col);
}

void CGSSetupDlg::OnSUp() 
{
	int cur = m_sort_list.GetCurSel();
	if(cur<1) return;
	DWORD data = m_sort_list.GetItemData(cur);
	CString str;
	m_sort_list.GetText(cur, str);
	m_sort_list.DeleteString(cur);
	int ind = m_sort_list.InsertString(cur-1,str);
	m_sort_list.SetItemData(ind,data);
	m_sort_list.SetCurSel(ind);
}

void CGSSetupDlg::OnSDown() 
{
	int cur = m_sort_list.GetCurSel();
	if(cur<0) return;
	if(cur>=m_sort_list.GetCount()-1) return;
	DWORD data = m_sort_list.GetItemData(cur);
	CString str;
	m_sort_list.GetText(cur, str);
	m_sort_list.DeleteString(cur);
	int ind = m_sort_list.InsertString(cur+1,str);
	m_sort_list.SetItemData(ind,data);
	m_sort_list.SetCurSel(ind);
}

void CGSSetupDlg::OnDblclkLGroups() 
{
	int cur = m_groups_list.GetCurSel();
	if(cur<0) return;
	CGroupCol* col = (CGroupCol*)m_groups_list.GetItemData(cur);
	CGroupSetup dlg;
	dlg.m_lf = col->m_lf;
	dlg.m_GroupCol = col;
	if(dlg.DoModal()!=IDOK) return;
	col->m_lf = dlg.m_lf;
}

void CGSSetupDlg::OnOK() 
{
	//   
	int cnt = m_sort_list.GetCount(), i, ind;
	for(i=0; i<m_deleted_sort_cols.GetSize();i++)
	{
		ind = m_section->m_sorts.Find(m_deleted_sort_cols[i]);
		if(ind<0) continue;
		m_section->m_sorts[ind]->Delete();
		m_section->m_sorts.RemoveAt(ind);
	}
	cnt = m_added_sort_cols.GetSize();
	for(i=0; i<cnt; i++)
	{
		CSortColumn* col = m_added_sort_cols[i];
		m_section->m_sorts.Add(col);
	}

	//   
	for(i=0; i<m_deleted_group_cols.GetSize();i++)
	{
		CGroupCol* col = m_deleted_group_cols[i];
		col->Delete();
		for(int j=0; j<m_section->m_groups.GetSize();j++)
		{
			if(m_section->m_groups.GetAt(j)==col)
			{
				m_section->m_groups.RemoveAt(j);
			}
		}
	}
	m_section->m_groups.Append(&m_added_group_cols);
	
	//  
	cnt = m_groups_list.GetCount();
	int g_cnt = m_section->m_groups.GetSize();
	for(i=0; i<cnt;i++)
	{
		CGroupCol* col = (CGroupCol*)m_groups_list.GetItemData(i);
		if(col==0) continue;
		ind = -1;
		for(int j=0; j<g_cnt;j++)
		{
			if(m_section->m_groups[j]==col)
				ind = j;
		}
		if(ind>-1 && i!=ind)
			m_section->m_groups.Move(ind, i);
	}

	//  
	cnt = m_sort_list.GetCount();
	for(i=0; i<cnt;i++)
	{
		CSortColumn* col = (CSortColumn*)m_sort_list.GetItemData(i);
		if(col==0) continue;
		ind = m_section->m_sorts.Find(col);
		if(ind>-1 && i!=ind)
			m_section->m_sorts.Move(ind, i);
	}

	m_added_sort_cols.Clear();

	CaplTranslateDialog::OnOK();
}



void CGSSetupDlg::OnCancel() 
{
	m_added_group_cols.RemoveAll();
	
	CaplTranslateDialog::OnCancel();
}

void CGSSetupDlg::OnDblclkLSort() 
{
	int cur = m_sort_list.GetCurSel();
	if(cur<0) return;
	CSortColumn* col = (CSortColumn*)m_sort_list.GetItemData(cur);
	CSortParamsDlg dlg;
	dlg.m_col = col;
	dlg.DoModal();
}
