#include "stdafx.h"
#include "ReportDict.h"

CGroupCol::CGroupCol(CaplReportMgr* dict):m_conditions(dict)
{
	ASSERT(dict);
	m_ReportMgr = dict;
	m_inst = NULL;
	m_col = NULL;
	memset(&m_lf,0,sizeof(LOGFONT));
	_strcpy(m_lf.lfFaceName,_T("Arial"));
	m_lf.lfHeight = 120;
	m_lf.lfCharSet = RUSSIAN_CHARSET;
	m_draw_first_row = 0;
	m_bSortAsString = false;
	m_SortDirection = aplAZ;
	
	m_Flags = 0;

	m_last_draw_row = -1;
}

CGroupCol::~CGroupCol()
{
	m_row.RemoveAll();
	m_conditions.RemoveAll();
	m_last_row.RemoveAll();
}
CGroupCol& CGroupCol::operator = (CGroupCol& GC)
{
	m_draw_first_row = GC.m_draw_first_row;
	m_lf = GC.m_lf;
	m_inst = GC.m_inst;
	m_ReportMgr = GC.m_ReportMgr;
	m_col = GC.m_col;
	m_row = GC.m_row;
	m_one_row = GC.m_one_row;
	m_last_row = GC.m_last_row;
	m_conditions = GC.m_conditions;
	m_name = GC.m_name;
	m_Flags = GC.m_Flags;

	return *this;
}

bool CGroupCol::Update(bool set /* = true */)
{
	int i;
	if(set)
	{
		ASSERT(m_col);
		if(m_inst==NULL)
			m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_apl_group_col);
		m_row.Update(set);
		m_last_row.Update(set);
		m_one_row.Update(set);
		aplExtent ext;
		ext.Clear();
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_name, m_name);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_flags, m_Flags);
		ext.Clear();
		m_row.GetExtent(ext);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_row, ext);
		ext.Clear();
		m_last_row.GetExtent(ext);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_last_row, ext);
		ext.Clear();
		m_one_row.GetExtent(ext);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_one_row, ext);
		CaplInstance* font_inst;
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_font,font_inst);
		if(font_inst==NULL)
		{
			font_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_font);
			m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_font,font_inst);
		}
		m_ReportMgr->SetFontValue(font_inst,m_lf);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_col,m_col->m_inst);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_show_fr,m_draw_first_row);
		m_conditions.Update(set);
		m_conditions.GetExtent(ext);
		m_ReportMgr->m_data->PutAttr(m_inst,m_ReportMgr->a_apl_gr_conditions,ext);

		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_gr_sortasstring, (int)m_bSortAsString);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_gr_sort_direction, m_SortDirection);
	}
	else
	{
		if(m_inst==NULL) return false;
		m_conditions.RemoveAll();
		m_row.RemoveAll();
		m_one_row.RemoveAll();
		m_last_row.RemoveAll();

		CaplInstance* inst = NULL, *font_inst = NULL;
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_font,font_inst);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_name, m_name);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_flags, m_Flags);
		m_lf = m_ReportMgr->GetFontValue(font_inst);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_col,inst);
		m_col = m_ReportMgr->FindColumnByInst(inst);
		ASSERT(m_col);
		aplExtent ext;
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_row,ext);
		for(i=0; i<ext.GetSize();i++)
		{
			CSectionLevel* level = new CSectionLevel(m_ReportMgr);
			level->m_inst = ext[i];
			m_row.Add(level);
		}
		m_row.Update(set);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_last_row,ext);
		for(i=0; i<ext.GetSize();i++)
		{
			CSectionLevel* level = new CSectionLevel(m_ReportMgr);
			level->m_inst = ext[i];
			m_last_row.Add(level);
		}
		m_last_row.Update(set);
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_one_row,ext);
		for(i=0; i<ext.GetSize();i++)
		{
			CSectionLevel* level = new CSectionLevel(m_ReportMgr);
			level->m_inst = ext[i];
			m_one_row.Add(level);
		}
		m_one_row.Update(set);

		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_show_fr,m_draw_first_row);
		ext.Clear();
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_conditions,ext);

		for(i=0; i<ext.Size;i++)
		{
			CCondition* cond = new CCondition(m_ReportMgr);
			cond->m_inst = ext[i];
			m_conditions.Add(cond);
		}
		m_conditions.Update(set);

		int tmp;
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_sortasstring, tmp);
		m_bSortAsString = tmp>0;
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_gr_sort_direction, m_SortDirection);
	}
	return true;
}

void CGroupCol::Delete()
{
	CaplInstance* font = NULL;
	if(m_inst!=0)
	{
		m_ReportMgr->m_data->GetAttr(m_inst,m_ReportMgr->a_apl_gr_font, font);
		m_ReportMgr->m_data->DeleteInstance(m_inst);
		m_ReportMgr->m_data->DeleteInstance(font);
	}
	m_conditions.Delete();
	m_row.Delete();
	m_last_row.Delete();
	m_one_row.Delete();
}

