// GroupSetup.cpp : implementation file
//

#include "stdafx.h"
#include "ReportDict.h"
#include "GroupSetup.h"
#include "ColumnSetupDlg.h"
#include "ConditionSetupDlg.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGroupSetup dialog


CGroupSetup::CGroupSetup(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CGroupSetup::IDD, pParent)
	, m_bDoNotShowForOneRow(FALSE)
{
	//{{AFX_DATA_INIT(CGroupSetup)
	m_font_name = _T("Arial");
	m_font_size = 12;
	m_draw_first_row = FALSE;
	m_ds_column_name = _T("");
	m_sGroupName = _T("");
	m_bSortAsString = FALSE;
	m_bSortDirection = FALSE;
	m_bSortByRowsCount = FALSE;
	m_bAllowBreakRows = FALSE;
	m_bShowOneRow = FALSE;
	//}}AFX_DATA_INIT
	m_GroupCol = NULL;
	memset(&m_lf,0,sizeof(LOGFONT));
	_strcpy(m_lf.lfFaceName,_T("Arial"));
	m_lf.lfHeight = 120;
	m_lf.lfCharSet = RUSSIAN_CHARSET;
}


void CGroupSetup::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGroupSetup)
	DDX_Control(pDX, IDC_SETUP_ONE_ROW_BTN, m_SetupOneRow_btn);
	DDX_Control(pDX, IDC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_SETUP_CONDITION_BTN, m_SetupConditions);
	DDX_Control(pDX, IDC_SETUP_LAST_ROW_BTN, m_SetupLastRow);
	DDX_Control(pDX, IDC_SETUP_ROW_BTN, m_SetupFirstRow);
	DDX_Text(pDX, IDC_FONT_NAME, m_font_name);
	DDX_Text(pDX, IDC_FONT_SIZE, m_font_size);
	DDX_Check(pDX, IDC__DRAW_FROW, m_draw_first_row);
	DDX_Text(pDX, IDC_DS_COLUMN, m_ds_column_name);
	DDX_Text(pDX, IDC_GROUP_NAME, m_sGroupName);
	DDX_Check(pDX, IDC_SORT_AS_STRING, m_bSortAsString);
	DDX_Check(pDX, IDC_SORT_DIRECTION, m_bSortDirection);
	DDX_Check(pDX, IDC_SORT_BY_ROWS_COUNT, m_bSortByRowsCount);
	DDX_Check(pDX, IDC_ALLOW_BREAK_ROWS, m_bAllowBreakRows);
	DDX_Check(pDX, IDC_SHOW_ONE_ROW, m_bShowOneRow);
	//}}AFX_DATA_MAP
	DDX_Check(pDX, IDC_DONOT_SHOW_ONE_ROW, m_bDoNotShowForOneRow);
}


BEGIN_MESSAGE_MAP(CGroupSetup, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CGroupSetup)
	ON_BN_CLICKED(IDC_FONT_BROWSE, OnFontBrowse)
	ON_BN_CLICKED(IDC_SETUP_ROW_BTN, OnSetupRowBtn)
	ON_BN_CLICKED(IDC_SETUP_CONDITION_BTN, OnSetupConditionBtn)
	ON_BN_CLICKED(IDC_SETUP_LAST_ROW_BTN, OnSetupLastRowBtn)
	ON_BN_CLICKED(IDC_SORT_AS_STRING, OnSortAsString)
	ON_BN_CLICKED(IDC_SORT_BY_ROWS_COUNT, OnSortByRowsCount)
	ON_BN_CLICKED(IDC_SETUP_ONE_ROW_BTN, OnSetupOneRowBtn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGroupSetup message handlers

void CGroupSetup::OnFontBrowse() 
{
	UpdateData();
	CFontDialog	dlg(&m_lf);
	int old = m_lf.lfHeight;
	CDC* pDC = GetDC();
	m_lf.lfHeight = -MulDiv(-old/10, GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 72);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	dlg.m_cf.lpLogFont = &m_lf;
	if(dlg.DoModal()==IDOK)
	{
		m_lf.lfHeight = dlg.GetSize();
		m_font_size = dlg.GetSize()/10;
		m_font_name = m_lf.lfFaceName;
		UpdateData(FALSE);
	}
	ReleaseDC(pDC);
}

BOOL CGroupSetup::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_SetupLastRow.SetIcon(aplGetStdIco16(APL_STD_SETUP));
	m_SetupLastRow.SetFlat(FALSE);

	m_SetupFirstRow.SetIcon(aplGetStdIco16(APL_STD_SETUP));
	m_SetupFirstRow.SetFlat(FALSE);
	
	m_SetupOneRow_btn.SetIcon(aplGetStdIco16(APL_STD_SETUP));
	m_SetupOneRow_btn.SetFlat(FALSE);

	m_SetupConditions.SetIcon(aplGetStdIco16(APL_STD_SETUP));
	m_SetupConditions.SetFlat(FALSE);

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	m_font_size = m_lf.lfHeight/10;
	m_font_name = m_lf.lfFaceName;
	m_draw_first_row = m_GroupCol->m_draw_first_row==1;
	if(m_GroupCol==0)
	{
		EndDialog(0);
		return FALSE;
	}
	m_ds_column_name = m_GroupCol->m_col->m_name;
	m_sGroupName = m_GroupCol->m_name;

	m_bAllowBreakRows = m_GroupCol->m_Flags&APL_GROUP_ALLOW_BREAK_ROWS?TRUE:FALSE;
	m_bSortByRowsCount = m_GroupCol->m_Flags&APL_GROUP_SORT_BY_ROWS_COUNT?TRUE:FALSE;
	m_bShowOneRow = m_GroupCol->m_Flags&APL_GROUP_SHOW_OTHER_ROW_IF_ONE_ROW_IN_GROUP? TRUE:FALSE;
	m_bSortAsString = m_GroupCol->m_bSortAsString?TRUE:FALSE;
	m_bSortDirection = m_GroupCol->m_SortDirection==aplZA ? TRUE:FALSE;
	m_bDoNotShowForOneRow = m_GroupCol->m_Flags&APL_GROUP_DONOT_SHOW_LAST_ROW_IF_ONE_ROW_IN_GROUP ? TRUE:FALSE;
		

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGroupSetup::OnSetupRowBtn() 
{
	CColumnSetupDlg dlg;
	dlg.m_GroupCol = m_GroupCol;
	dlg.m_dlg_mode=APL_DLG_MODE_CREATE_GROUP;
	dlg.DoModal();
}

void CGroupSetup::OnOK() 
{
	if(!UpdateData()) return;
	CString val;
	val.Empty();
	bool bRes = CDataSource::ParseFunction(m_sGroupName, val, NULL, m_GroupCol->m_ReportMgr->m_base_query, m_GroupCol->m_ReportMgr->m_header, &m_GroupCol->m_ReportMgr->m_data_source.m_params);
	if(!bRes)
	{
		AfxMessageBox(APL_T("  !"), MB_ICONERROR|MB_OK);
		return;
	}
	m_GroupCol->m_draw_first_row = m_draw_first_row;
	m_GroupCol->m_name = m_sGroupName;

	m_GroupCol->m_Flags = 0;
	if(m_bAllowBreakRows)
		m_GroupCol->m_Flags|=APL_GROUP_ALLOW_BREAK_ROWS;
	if(m_bSortByRowsCount)
		m_GroupCol->m_Flags|=APL_GROUP_SORT_BY_ROWS_COUNT;
	if(m_bShowOneRow)
		m_GroupCol->m_Flags|=APL_GROUP_SHOW_OTHER_ROW_IF_ONE_ROW_IN_GROUP;
	if(m_bDoNotShowForOneRow)
		m_GroupCol->m_Flags|=APL_GROUP_DONOT_SHOW_LAST_ROW_IF_ONE_ROW_IN_GROUP;

	m_GroupCol->m_bSortAsString = (m_bSortAsString==TRUE);

	if(m_bSortDirection)
		m_GroupCol->m_SortDirection=aplZA;
	else
		m_GroupCol->m_SortDirection=aplAZ;
	
	CaplTranslateDialog::OnOK();
}

void CGroupSetup::OnSetupConditionBtn() 
{
	CConditionSetupDlg dlg;
	dlg.m_ReportMgr = m_GroupCol->m_ReportMgr;
	dlg.m_conditions = &m_GroupCol->m_conditions;
	dlg.DoModal();
}

void CGroupSetup::OnSetupLastRowBtn() 
{
	CColumnSetupDlg dlg;
	dlg.m_GroupCol = m_GroupCol;
	dlg.m_dlg_mode=APL_DLG_MODE_CREATE_LR_GROUP;
	dlg.DoModal();
}

void CGroupSetup::OnSortAsString() 
{
	if(!UpdateData()) return;

	GetDlgItem(IDC_SORT_BY_ROWS_COUNT)->EnableWindow(m_bSortAsString==TRUE? FALSE:TRUE);

	UpdateData(FALSE);
}

void CGroupSetup::OnSortByRowsCount() 
{
	if(!UpdateData()) return;
	
	GetDlgItem(IDC_SORT_AS_STRING)->EnableWindow(m_bSortByRowsCount==TRUE? FALSE:TRUE);
	
	UpdateData(FALSE);
}

void CGroupSetup::OnSetupOneRowBtn() 
{
	UpdateData(TRUE);

	CColumnSetupDlg dlg;
	dlg.m_GroupCol = m_GroupCol;
	dlg.m_dlg_mode=APL_DLG_MODE_CREATE_ONE_GROUP;
	if(dlg.DoModal()==IDOK)
		m_bShowOneRow = TRUE;

	UpdateData(FALSE);
}
