// PropertyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ReportDict.h"
#include "PropertyDlg.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropertyDlg dialog


CPropertyDlg::CPropertyDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CPropertyDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPropertyDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	mode = 0;
}


void CPropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropertyDlg)
//	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_TAB, m_tab_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropertyDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CPropertyDlg)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropertyDlg message handlers
#define aplGetActiveSheet	AfxGetApp()->GetProfileInt(_T("Settings"), _T("PropertyDlgActiveSheet"), 1)

BOOL CPropertyDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_elements->GetSize()<1) 
	{
		EndDialog(0);
		return FALSE;
	}
	m_rect_prop.mode = mode;
	m_text_prop.mode = mode;
	m_table_prop.mode = mode;

	elem = m_elements->GetAt(0);
	CRect cl_rect;
	m_tab_ctrl.GetClientRect(cl_rect);
	m_tab_ctrl.InsertItem(0,APL_T(" "));
	m_rect_prop.m_elems = m_elements;
	m_rect_prop.m_line_width = float(elem->m_line_width)/10;
	m_rect_prop.Create(IDD_RECT_PROPER_DLG,(CWnd*)&m_tab_ctrl);
	cl_rect.DeflateRect(CSize(6,6));
	cl_rect.top+=20;
	m_rect_prop.MoveWindow(cl_rect);
	m_rect_prop.ShowWindow(SW_HIDE);

	m_tab_ctrl.SetFocus();

	if(elem->GetType()==E_RECT && m_elements->GetSize()==1)
	{
		HICON hIcon = aplGetStdIco16(APL_STD_PROPERTIES);
		SetIcon(hIcon, TRUE);
		::DestroyIcon(hIcon);

		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_text_prop.elem = (CRectReportElement*)elem;
		m_text_prop.Create(IDD_TEXT_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_text_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_text_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_text_prop.SetFocus();
		}
		SetWindowText(APL_T(": "));
	}
	else if(elem->GetType()==E_TABLE && m_elements->GetSize()==1)
	{
		HICON hIcon = aplGetStdIco16(APL_STD_TABLE);
		SetIcon(hIcon, TRUE);
		::DestroyIcon(hIcon);
		
		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_table_prop.m_table = (CTableElement*)elem;
		m_table_prop.Create(IDD_TABLE_PROP,(CWnd*)&m_tab_ctrl);
		m_table_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_table_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_table_prop.SetFocus();
		}
		SetWindowText(APL_T(": "));
	}
	else if(elem->GetType()==E_TABLE_MAP && m_elements->GetSize()==1)
	{
		HICON hIcon = aplGetStdIco16(APL_STD_TABLE);
		SetIcon(hIcon, TRUE);
		::DestroyIcon(hIcon);

		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_table_prop.m_table = ((CTableMapElement*)elem)->m_table;
		m_table_prop.Create(IDD_TABLE_PROP,(CWnd*)&m_tab_ctrl);
		m_table_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_table_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_table_prop.SetFocus();
		}
		SetWindowText(APL_T(":  "));
	}
	else if(elem->GetType()==E_PICTURE && m_elements->GetSize()==1)
	{
		HICON hIcon = aplGetStdIco16(APL_STD_PICTURE);
		SetIcon(hIcon, TRUE);
		::DestroyIcon(hIcon);

		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_picture_prop.m_elem = (CPictureElement*)elem;
		m_picture_prop.Create(IDD_PICTURE_SETUP_DLG,(CWnd*)&m_tab_ctrl);
		m_picture_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_picture_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_picture_prop.SetFocus();
		}
		SetWindowText(APL_T(": "));
	}
	else if(elem->GetType()==E_TABLE_CONTENT_TITLE && m_elements->GetSize()==1)
	{
		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_tct_prop.m_TCTitle = (CTableContentElement*)elem;
		m_tct_prop.Create(IDD_TABLE_CONTENT_TITLE_SETUP_DLG,(CWnd*)&m_tab_ctrl);
		m_tct_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_tct_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_tct_prop.SetFocus();
		}
		SetWindowText(APL_T(": "));
	}
	else if(elem->GetType()==E_DIAGRAM && m_elements->GetSize()==1)
	{
		HICON hIcon = aplGetStdIco16(APL_STD_PROPERTIES);
		SetIcon(hIcon, TRUE);
		::DestroyIcon(hIcon);
		
		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_diagram_prop.m_elem = (CDiagramElement*)elem;
		m_diagram_prop.Create(IDD_DIAGRAM_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_diagram_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_diagram_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_diagram_prop.SetFocus();
		}

		m_tab_ctrl.InsertItem(2,APL_T(""));
		m_legend_prop.m_pLegend = &m_diagram_prop.m_elem->m_Legend;
		m_legend_prop.Create(IDD_LEGEND_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_legend_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==2)
		{
			m_legend_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(2);
			m_legend_prop.SetFocus();
		}

		m_tab_ctrl.InsertItem(3,APL_T(" "));
		m_coordinate_prop.m_pXLine = &m_diagram_prop.m_elem->m_XLine;
		m_coordinate_prop.m_pYLine = &m_diagram_prop.m_elem->m_YLine;
		m_coordinate_prop.m_ElemType = elem->GetType();
		m_coordinate_prop.m_PropDlg = this;
		m_coordinate_prop.Create(IDD_COORDINATE_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_coordinate_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==3)
		{
			m_coordinate_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(3);
			m_coordinate_prop.SetFocus();
		}

		SetWindowText(APL_T(": "));
	}
	else if(elem->GetType()==E_GISTOGRAM && m_elements->GetSize()==1)
	{
		HICON hIcon = aplGetStdIco16(APL_STD_PROPERTIES);
		SetIcon(hIcon, TRUE);
		::DestroyIcon(hIcon);
		
		m_tab_ctrl.InsertItem(1,APL_T(""));
		m_gistogram_prop.m_pGistogram = (CGistogramElement*)elem;
		m_gistogram_prop.Create(IDD_GISTOGRAM_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_gistogram_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==1)
		{
			m_gistogram_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(1);
			m_gistogram_prop.SetFocus();
		}
		
		m_tab_ctrl.InsertItem(2,APL_T(""));
		m_legend_prop.m_pLegend = &((CGistogramElement*)elem)->m_Legend;
		m_legend_prop.Create(IDD_LEGEND_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_legend_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==2)
		{
			m_legend_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(2);
			m_legend_prop.SetFocus();
		}
		
		m_tab_ctrl.InsertItem(3,APL_T(" "));
		m_coordinate_prop.m_pXLine = &((CGistogramElement*)elem)->m_XLine;
		m_coordinate_prop.m_pYLine = &((CGistogramElement*)elem)->m_YLine;
		m_coordinate_prop.m_ElemType = elem->GetType();
		m_coordinate_prop.m_PropDlg = this;
		m_coordinate_prop.Create(IDD_COORDINATE_PROP_DLG,(CWnd*)&m_tab_ctrl);
		m_coordinate_prop.MoveWindow(cl_rect);
		if(aplGetActiveSheet==3)
		{
			m_coordinate_prop.ShowWindow(SW_SHOW);
			m_tab_ctrl.SetCurSel(3);
			m_coordinate_prop.SetFocus();
		}
		
		SetWindowText(APL_T(": "));
	}
	else if(elem->GetType()==E_LINE && m_elements->GetSize()==1)
	{
		m_rect_prop.ShowWindow(SW_SHOW);
		m_rect_prop.SetFocus();
		if(m_elements->GetSize()==1)
			SetWindowText(APL_T(": "));
	}

	if(aplGetActiveSheet==0 || m_tab_ctrl.GetCurSel()==0)
	{
		m_rect_prop.ShowWindow(SW_SHOW);
		m_rect_prop.SetFocus();
	}
	
	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropertyDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	int cur = m_tab_ctrl.GetCurSel();
	if(cur<0) return;
	else if(cur==0)
	{
		if(::IsWindow(m_coordinate_prop.m_hWnd) && m_coordinate_prop.IsWindowVisible())
			m_coordinate_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_text_prop.m_hWnd) && m_text_prop.IsWindowVisible())
			m_text_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_table_prop.m_hWnd) && m_table_prop.IsWindowVisible())
			m_table_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_picture_prop.m_hWnd) && m_picture_prop.IsWindowVisible())
			m_picture_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_tct_prop.m_hWnd) && m_tct_prop.IsWindowVisible())
			m_tct_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_diagram_prop.m_hWnd) && m_diagram_prop.IsWindowVisible())
			m_diagram_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_gistogram_prop.m_hWnd) && m_gistogram_prop.IsWindowVisible())
			m_gistogram_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_legend_prop.m_hWnd) && m_legend_prop.IsWindowVisible())
			m_legend_prop.ShowWindow(SW_HIDE);
		m_rect_prop.ShowWindow(SW_SHOW);
		m_rect_prop.SetFocus();
	}
	else if(cur==1)
	{
		if(::IsWindow(m_coordinate_prop.m_hWnd) && m_coordinate_prop.IsWindowVisible())
			m_coordinate_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_rect_prop.m_hWnd) && m_rect_prop.IsWindowVisible())
			m_rect_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_legend_prop.m_hWnd) && m_legend_prop.IsWindowVisible())
			m_legend_prop.ShowWindow(SW_HIDE);
		if(elem->GetType()==E_RECT)
		{
			m_text_prop.ShowWindow(SW_SHOW);
			m_text_prop.SetFocus();
		}
		else if(elem->GetType()==E_TABLE || elem->GetType()==E_TABLE_MAP)
		{
			m_table_prop.ShowWindow(SW_SHOW);
			m_table_prop.SetFocus();
		}
		else if(elem->GetType()==E_PICTURE)
		{
			m_picture_prop.ShowWindow(SW_SHOW);
			m_picture_prop.SetFocus();
		}
		else if(elem->GetType()==E_TABLE_CONTENT_TITLE)
		{
			m_tct_prop.ShowWindow(SW_SHOW);
			m_tct_prop.SetFocus();
		}
		else if(elem->GetType()==E_DIAGRAM)
		{
			m_diagram_prop.ShowWindow(SW_SHOW);
			m_diagram_prop.SetFocus();
		}
		else if(elem->GetType()==E_GISTOGRAM)
		{
			m_gistogram_prop.ShowWindow(SW_SHOW);
			m_gistogram_prop.SetFocus();
		}
	}
	else if(cur==2)
	{
		if(::IsWindow(m_coordinate_prop.m_hWnd) && m_coordinate_prop.IsWindowVisible())
			m_coordinate_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_rect_prop.m_hWnd) && m_rect_prop.IsWindowVisible())
			m_rect_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_diagram_prop.m_hWnd) && m_diagram_prop.IsWindowVisible())
			m_diagram_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_gistogram_prop.m_hWnd) && m_gistogram_prop.IsWindowVisible())
			m_gistogram_prop.ShowWindow(SW_HIDE);
		if(elem->GetType()==E_DIAGRAM || elem->GetType()==E_GISTOGRAM)
		{
			m_legend_prop.ShowWindow(SW_SHOW);
			m_legend_prop.SetFocus();
		}
	}
	else if(cur==3)
	{
		if(::IsWindow(m_text_prop.m_hWnd) && m_text_prop.IsWindowVisible())
			m_text_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_table_prop.m_hWnd) && m_table_prop.IsWindowVisible())
			m_table_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_picture_prop.m_hWnd) && m_picture_prop.IsWindowVisible())
			m_picture_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_tct_prop.m_hWnd) && m_tct_prop.IsWindowVisible())
			m_tct_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_diagram_prop.m_hWnd) && m_diagram_prop.IsWindowVisible())
			m_diagram_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_gistogram_prop.m_hWnd) && m_gistogram_prop.IsWindowVisible())
			m_gistogram_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_legend_prop.m_hWnd) && m_legend_prop.IsWindowVisible())
			m_legend_prop.ShowWindow(SW_HIDE);
		if(::IsWindow(m_rect_prop.m_hWnd) && m_rect_prop.IsWindowVisible())
			m_rect_prop.ShowWindow(SW_HIDE);
		if(elem->GetType()==E_DIAGRAM || elem->GetType()==E_GISTOGRAM)
		{
			m_coordinate_prop.ShowWindow(SW_SHOW);
			m_coordinate_prop.SetFocus();
		}
	}

	AfxGetApp()->WriteProfileInt(_T("Settings"), _T("PropertyDlgActiveSheet"), cur);
}

void CPropertyDlg::OnOK() 
{
	if(!m_rect_prop.TestUpdate())
	{
		m_tab_ctrl.SetCurSel(0);
		OnSelchangeTab(NULL, NULL);
		return;
	}

	if(::IsWindow(m_text_prop.m_hWnd))
		if(!m_text_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(1);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_table_prop.m_hWnd))
		if(!m_table_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(1);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_picture_prop.m_hWnd))
		if(!m_picture_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(1);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_tct_prop.m_hWnd))
		if(!m_tct_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(1);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_diagram_prop.m_hWnd))
		if(!m_diagram_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(1);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_gistogram_prop.m_hWnd))
		if(!m_gistogram_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(1);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_legend_prop.m_hWnd))
		if(!m_legend_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(2);
			OnSelchangeTab(NULL, NULL);
			return;
		}
	if(::IsWindow(m_coordinate_prop.m_hWnd))
		if(!m_coordinate_prop.TestUpdate())
		{
			m_tab_ctrl.SetCurSel(3);
			OnSelchangeTab(NULL, NULL);
			return;
		}

	m_rect_prop.UpdateDlg();
	if(::IsWindow(m_text_prop.m_hWnd))
		m_text_prop.UpdateDlg();
	if(::IsWindow(m_table_prop.m_hWnd))
		m_table_prop.UpdateDlg();
	if(::IsWindow(m_picture_prop.m_hWnd))
		m_picture_prop.UpdateDlg();
	if(::IsWindow(m_tct_prop.m_hWnd))
		m_tct_prop.UpdateDlg();
	if(::IsWindow(m_diagram_prop.m_hWnd))
		m_diagram_prop.UpdateDlg();
	if(::IsWindow(m_gistogram_prop.m_hWnd))
		m_gistogram_prop.UpdateDlg();
	if(::IsWindow(m_legend_prop.m_hWnd))
		m_legend_prop.UpdateDlg();
	if(::IsWindow(m_coordinate_prop.m_hWnd))
		m_coordinate_prop.UpdateDlg();
					
	CaplTranslateDialog::OnOK();
}


void CPropertyDlg::OnCancel() 
{
	
	CaplTranslateDialog::OnCancel();
}

BOOL CPropertyDlg::DestroyWindow() 
{
	m_rect_prop.DestroyWindow();
	if(::IsWindow(m_text_prop.m_hWnd))
		m_text_prop.DestroyWindow();
	if(::IsWindow(m_table_prop.m_hWnd))
		m_table_prop.DestroyWindow();
	if(::IsWindow(m_picture_prop.m_hWnd))
		m_picture_prop.DestroyWindow();
	if(::IsWindow(m_tct_prop.m_hWnd))
		m_tct_prop.DestroyWindow();
	if(::IsWindow(m_diagram_prop.m_hWnd))
		m_diagram_prop.DestroyWindow();
	if(::IsWindow(m_legend_prop.m_hWnd))
		m_legend_prop.DestroyWindow();
	if(::IsWindow(m_coordinate_prop.m_hWnd))
		m_coordinate_prop.DestroyWindow();
	
	return CaplTranslateDialog::DestroyWindow();
}
