// SectionPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SectionPropDlg.h"
#include "ColumnSetupDlg.h"
#include "ConditionsetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSectionPropDlg dialog


CSectionPropDlg::CSectionPropDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSectionPropDlg::IDD, pParent)
{
	m_section = NULL;
	//{{AFX_DATA_INIT(CSectionPropDlg)
	m_title_name = _T("");
	m_sec_name = _T("");
	m_column = _T("");
	//}}AFX_DATA_INIT
}


void CSectionPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSectionPropDlg)
	DDX_Control(pDX, IDC_STATIC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDC_CONDITION_SETUP, m_SetupCondition);
	DDX_Control(pDX, IDC_COLUMN_SETUP, m_column_setup_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_TITLE_NAME, m_title_name);
	DDX_Text(pDX, IDC_SEC_NAME, m_sec_name);
	DDX_Text(pDX, IDC_COLUMN, m_column);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSectionPropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSectionPropDlg)
	ON_BN_CLICKED(IDC_FONT_BROWSE, OnFontBrowse)
	ON_BN_CLICKED(IDC_COLUMN_SETUP, OnColumnSetup)
	ON_BN_CLICKED(IDC_COLUMN_BROUSE, OnColumnBrouse)
	ON_BN_CLICKED(IDC_CONDITION_SETUP, OnConditionSetup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSectionPropDlg message handlers

BOOL CSectionPropDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	HICON hIcon = aplGetStdIco16(APL_STD_NEW_SECTION);
	SetIcon(hIcon, TRUE);
	::DestroyIcon(hIcon);

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	m_column_setup_btn.SetFlat(FALSE);
	m_column_setup_btn.SetIcon(aplGetStdIco16(APL_STD_SECTION_PROP));

	m_SetupCondition.SetIcon(aplGetStdIco16(APL_STD_SETUP));
	m_SetupCondition.SetFlat(FALSE);

	if(m_section==NULL)
	{
		EndDialog(0);
		return FALSE;
	}
	sec = new CReportSection(m_section->m_ReportMgr);
	*sec = (*m_section);
	m_sec_name = m_section->m_name;
	m_title_name = m_section->m_title.GetText();
	m_lf = m_section->m_title.m_font;
	if(m_section->m_title_column)
		m_column = m_section->m_title_column->m_name;
	//      
	CButton* btn = (CButton*)GetDlgItem(IDC_CHECK_EMPTY_STRING);
	btn->SetCheck(sec->m_show_empty_string_in_title);
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSectionPropDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData();
	if(m_sec_name.IsEmpty())
	{
		AfxMessageBox(APL_T("   !"), MB_OK|MB_ICONINFORMATION);
		return;
	}
	if(m_section->m_title_column==0 && !m_title_name.IsEmpty())
	{
		if(IDYES!=AfxMessageBox(APL_T("      .  ?"), MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON1))
			return;
	}
	m_section->m_name = m_sec_name;
	m_section->m_title.SetText(m_title_name);
	m_section->m_title.m_font = m_lf;
	CButton* btn = (CButton*)GetDlgItem(IDC_CHECK_EMPTY_STRING);
	m_section->m_show_empty_string_in_title = btn->GetCheck();
	
	CaplTranslateDialog::OnOK();
}

void CSectionPropDlg::OnFontBrowse() 
{
	int h = m_lf.lfHeight;
	CDC* pDC = GetDC();
	m_lf.lfHeight = -MulDiv(-h/20, GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 36);
	ReleaseDC(pDC);
	CFontDialog dlg(&m_lf);
	dlg.m_cf.Flags |=CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	if(dlg.DoModal()==IDOK)
		m_lf.lfHeight = dlg.GetSize();
	else m_lf.lfHeight = h;
}

void CSectionPropDlg::OnColumnSetup() 
{
	UpdateData();
	CColumnSetupDlg dlg;
	dlg.m_section = m_section;
	dlg.DoModal();
	if(m_section->m_title_column==NULL)
		m_column = _T("");
	UpdateData(FALSE);
}

void CSectionPropDlg::OnColumnBrouse() 
{
	UpdateData();
	CColumnSetupDlg dlg;
	dlg.m_dlg_mode = APL_DLG_MODE_SELECT;
	dlg.m_section = m_section;
	if(dlg.DoModal()==IDOK)
	{
		m_section->m_title_column = dlg.m_select;
		if(m_section->m_title_column!=NULL)
			m_column = m_section->m_title_column->m_name;
		else
			m_column = _T("");
		UpdateData(FALSE);
	}
}

void CSectionPropDlg::OnConditionSetup() 
{
	CConditionSetupDlg dlg;
	dlg.m_ReportMgr = m_section->m_ReportMgr;
	dlg.m_conditions = &m_section->m_conditions;
	dlg.DoModal();
}

void CSectionPropDlg::OnCancel() 
{
	*m_section=(*sec);
	
	CaplTranslateDialog::OnCancel();
}

BOOL CSectionPropDlg::DestroyWindow() 
{
	delete sec;
	
	return CaplTranslateDialog::DestroyWindow();
}
