// SetupcolumnsPage.cpp : implementation file
//

#include "stdafx.h"
#include "SetupcolumnsPage.h"
#include "TemplateMasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupcolumnsPage dialog


CSetupcolumnsPage::CSetupcolumnsPage(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSetupcolumnsPage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupcolumnsPage)
	m_iOrient = 1;
	m_dHeight = 210.0;
	m_dWidth = 297.0;
	m_dTableLineWidth = ((double)AfxGetApp()->GetProfileInt(_T("DefaultSettings"),_T("LineWidth"),1))/10;
	m_dTitleLineWidth = ((double)AfxGetApp()->GetProfileInt(_T("DefaultSettings"),_T("LineWidth"),1))/10;
	m_dLeft = 5.0;
	m_dBottom = 5.0;
	m_dRight = 5.0;
	m_dTop = 5.0;
	//}}AFX_DATA_INIT
}


void CSetupcolumnsPage::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupcolumnsPage)
	DDX_Control(pDX, IDC_UP, m_up_btn);
	DDX_Control(pDX, IDC_DOWN, m_down_btn);
	DDX_Control(pDX, IDC_PAGE_SIZE_COMBO, m_PageSize_ComboCtrl);
	DDX_Control(pDX, IDC_COLUMNS_LIST, m_Columns_ListCtrl);
	DDX_Radio(pDX, IDC_PAGE_PORTAL, m_iOrient);
	DDX_Text(pDX, IDC_HEIGHT, m_dHeight);
	DDX_Text(pDX, IDC_WIDHT, m_dWidth);
	DDX_Text(pDX, IDC_TABLE_LINE_WIDTH, m_dTableLineWidth);
	DDX_Text(pDX, IDC_TITLE_LINE_WIDTH, m_dTitleLineWidth);
	DDX_Text(pDX, IDC_LEFT, m_dLeft);
	DDX_Text(pDX, IDC_BOTTOM, m_dBottom);
	DDX_Text(pDX, IDC_RIGHT, m_dRight);
	DDX_Text(pDX, IDC_TOP, m_dTop);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupcolumnsPage, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSetupcolumnsPage)
	ON_CBN_SELCHANGE(IDC_PAGE_SIZE_COMBO, OnSelchangePageSizeCombo)
	ON_BN_CLICKED(IDC_PAGE_PORTAL, OnPagePortal)
	ON_BN_CLICKED(IDC_PAGE_LANDSCAPE, OnPageLandscape)
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_BN_CLICKED(IDC_DOWN, OnDown)
	ON_AFTER_ENDEDIT(IDC_COLUMNS_LIST, OnColumnlistEndedit)
	ON_BN_CLICKED(IDC_CALC_COLUMNS_WIDTH, OnCalcColumnsWidth)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupcolumnsPage message handlers

void CSetupcolumnsPage::OnOK() 
{
	if(m_Columns_ListCtrl.EndEdit()) return;
	// TODO: Add extra validation here
	
	//CaplTranslateDialog::OnOK();
}

void CSetupcolumnsPage::OnCancel() 
{
	if(m_Columns_ListCtrl.EndEdit(false)) return;
	// TODO: Add extra cleanup here
	
	//CaplTranslateDialog::OnCancel();
}

bool CSetupcolumnsPage::UpdateList()
{
	m_Columns_ListCtrl.DeleteAllItems();

	if(m_pTemplate==NULL) return false;

	int i, ind, j;
	CString buf;
	CHeaderColumn* pHeaderCol;
	CTMColumn* pTMCol;
	bool bFind;

	int Width = 2970/m_pTemplate->m_pHeader->GetSize();

	//     
	for(i=0; i<m_pTemplate->m_ColumnsArray.GetSize(); i++)
		delete m_pTemplate->m_ColumnsArray[i];
	m_pTemplate->m_ColumnsArray.RemoveAll();

	//   
	//  
	//  
	//        .
	//     !
	// 
	for(j=0; j<m_pTemplate->m_GroupsArray.GetSize(); j++)
	{
		buf = m_pTemplate->m_GroupsArray[j]->pColumn->GetName();
		
		pTMCol = new CTMColumn;
		pTMCol->pColumn = m_pTemplate->m_GroupsArray[j]->pColumn;
		pTMCol->iWidth = Width;
		pTMCol->sTitle = buf;
		pTMCol->bGroup = true;
		
		m_pTemplate->m_ColumnsArray.Add(pTMCol);
	}
	//  
	for(i=0; i<m_pTemplate->m_pHeader->GetSize(); i++)
	{
		pHeaderCol = m_pTemplate->m_pHeader->GetColumn(i);
		//      ,    
		bFind = false;
		for(j=0; j<m_pTemplate->m_GroupsArray.GetSize(); j++)
		{
			if(m_pTemplate->m_GroupsArray[j]->pColumn==pHeaderCol)
			{
				bFind = true;
				break;
			}
		}
		if(bFind) continue;

		buf = pHeaderCol->GetName();
		
		pTMCol = new CTMColumn;
		pTMCol->pColumn = pHeaderCol;
		pTMCol->iWidth = Width;
		pTMCol->sTitle = buf;
		pTMCol->bGroup = false;
		
		m_pTemplate->m_ColumnsArray.Add(pTMCol);
	}

	for(i=0; i<m_pTemplate->m_ColumnsArray.GetSize(); i++)
	{
		pTMCol = m_pTemplate->m_ColumnsArray[i];

		ind =	m_Columns_ListCtrl.InsertItem(m_Columns_ListCtrl.GetItemCount(), pTMCol->pColumn->GetName());
		m_Columns_ListCtrl.SetItemText(ind, 1, pTMCol->sTitle);
		buf.Format(_T("%.1f"), ((double)pTMCol->iWidth/10));
		m_Columns_ListCtrl.SetItemText(ind, 2, buf);
		m_Columns_ListCtrl.SetItemData(ind, (DWORD)pTMCol);
		m_Columns_ListCtrl.SetItemEditType(ind, 1, aplTextCtrl);
		m_Columns_ListCtrl.SetItemEditType(ind, 2, aplRealCtrl);
	}

	//   
	UpdateColumnsWidth();

	if(m_Columns_ListCtrl.GetItemCount()>0)
	{
		CTemplateMasterDlg *pParent = (CTemplateMasterDlg*)GetParent();
		pParent->m_ok_btn.EnableWindow(TRUE);
	}
				
	return true;
}

BOOL CSetupcolumnsPage::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	//  
	CRect cl_rect;
	int w;
	m_Columns_ListCtrl.GetClientRect(cl_rect);
	w = cl_rect.Width() - 15;
	m_Columns_ListCtrl.InsertColumn(0, APL_T(""), LVCFMT_LEFT, (int)(w*0.3));
	m_Columns_ListCtrl.InsertColumn(1, APL_T(""), LVCFMT_LEFT, (int)(w*0.5));
	m_Columns_ListCtrl.InsertColumn(2, APL_T(""), LVCFMT_LEFT, (int)(w*0.2));

	m_Columns_ListCtrl.ModifyStyle(0, LVS_SINGLESEL|LVS_SHOWSELALWAYS);
	m_Columns_ListCtrl.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);

	//  
	m_PageSize_ComboCtrl.SetItemData(m_PageSize_ComboCtrl.AddString(_T("A5")), 0);
	m_PageSize_ComboCtrl.SetItemData(m_PageSize_ComboCtrl.AddString(_T("A4")), 1);
	m_PageSize_ComboCtrl.SetItemData(m_PageSize_ComboCtrl.AddString(_T("A3")), 2);
	m_PageSize_ComboCtrl.SetItemData(m_PageSize_ComboCtrl.AddString(_T("A2")), 3);
	m_PageSize_ComboCtrl.SetItemData(m_PageSize_ComboCtrl.AddString(_T("A1")), 4);
	m_PageSize_ComboCtrl.SetItemData(m_PageSize_ComboCtrl.AddString(APL_T(" ")), 5);

	m_PageSize_ComboCtrl.SetCurSel(1);
	
	m_up_btn.SetIcon(aplGetStdIco16(APL_STD_TOP));
	m_up_btn.SetWindowText(_T(""));
	m_down_btn.SetIcon(aplGetStdIco16(APL_STD_BOTTOM));
	m_down_btn.SetWindowText(_T(""));

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSetupcolumnsPage::OnSelchangePageSizeCombo() 
{
	UpdateData();
	int cur = m_PageSize_ComboCtrl.GetCurSel();
	if(cur<0) return;
	int ind = m_PageSize_ComboCtrl.GetItemData(cur);
	SIZE sizes[5];
//PAGE_A1 8410, 5940
//PAGE_A2 5940, 4210
//PAGE_A3 4210, 2970
//PAGE_A4 2970, 2100
//PAGE_A5 2100, 1480
	sizes[0].cx = 210; sizes[0].cy = 148;
	sizes[1].cx = 297; sizes[1].cy = 210;
	sizes[2].cx = 421; sizes[2].cy = 297;
	sizes[3].cx = 594; sizes[3].cy = 421;
	sizes[4].cx = 841; sizes[4].cy = 594;
	if(ind<5)
	{
		if(m_iOrient==0)
		{
			m_dWidth = sizes[ind].cy;
			m_dHeight = sizes[ind].cx;
		}
		else
		{
			m_dWidth = sizes[ind].cx;
			m_dHeight = sizes[ind].cy;
		}
	}
	((CEdit*)GetDlgItem(IDC_WIDHT))->SetReadOnly(ind<5?TRUE:FALSE);
	((CEdit*)GetDlgItem(IDC_HEIGHT))->SetReadOnly(ind<5?TRUE:FALSE);

	UpdateData(FALSE);
}

void CSetupcolumnsPage::OnPagePortal() 
{
	OnSelchangePageSizeCombo();
}

void CSetupcolumnsPage::OnPageLandscape() 
{
	OnSelchangePageSizeCombo();
}

bool CSetupcolumnsPage::TestUpdate()
{
	if(!UpdateData()) return false;
	// :
	//        
	//        

	//  
	double cx, cy;
	cx = m_dWidth - m_dLeft - m_dRight;
	cy = m_dHeight - m_dTop - m_dBottom;

	if(m_dHeight/2 > cy)
	{
		AfxMessageBox(APL_T("        !"), MB_ICONINFORMATION|MB_OK);
		return false;
	}
	if(m_dWidth/2 > cx)
	{
		AfxMessageBox(APL_T("        !"), MB_ICONINFORMATION|MB_OK);
		return false;
	}

	//          ,
	//     

	CString buf;
	CTMColumn* pTMCol;
	int i;
	int w=0, delta;
	for(i=0; i<m_Columns_ListCtrl.GetItemCount(); i++)
	{
		pTMCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(i);
		w+=pTMCol->iWidth;
	}
	delta = (int)(cx*10) - w;
	if(delta>0)
	{
		buf.Format(APL_T("       %.1f "), (double)(delta)/10);
		AfxMessageBox(buf, MB_ICONINFORMATION|MB_OK);
		return false;
	}
	else if(delta<0)
	{
		buf.Format(APL_T("       %.1f "), (double)(delta)/10);
		AfxMessageBox(buf, MB_ICONINFORMATION|MB_OK);
		return false;
	}

	return true;
}

void CSetupcolumnsPage::OnUp() 
{
	int ind, cur = m_Columns_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<1) return;

	CTMColumn *pCol, *pPrevCol;
	CString buf;
	pCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(cur);
	if(pCol->bGroup)
	{
		AfxMessageBox(APL_T("  ,    !"), MB_ICONINFORMATION|MB_OK);
		return;
	}
	//  .    ,   
	if(cur>0)
	{
		pPrevCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(cur-1);
		if(pPrevCol->bGroup) return;
	}

	buf = pCol->pColumn->GetName();
	m_Columns_ListCtrl.DeleteItem(cur--);
	
	ind =		m_Columns_ListCtrl.InsertItem(cur, buf);
				m_Columns_ListCtrl.SetItemText(ind, 1, pCol->sTitle);
				buf.Format(_T("%.1f"), ((double)pCol->iWidth/10));
				m_Columns_ListCtrl.SetItemText(ind, 2, buf);
				m_Columns_ListCtrl.SetItemData(ind, (DWORD)pCol);

				m_Columns_ListCtrl.SetItemEditType(ind, 1, aplTextCtrl);
				m_Columns_ListCtrl.SetItemEditType(ind, 2, aplRealCtrl);

	m_Columns_ListCtrl.SetItemState(cur, LVIS_SELECTED|LVIS_FOCUSED, LVIS_SELECTED|LVIS_FOCUSED);

}

void CSetupcolumnsPage::OnDown() 
{
	int ind, cur = m_Columns_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur>=m_Columns_ListCtrl.GetItemCount() || cur<0) return;
	
	CTMColumn *pCol;
	CString buf;
	pCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(cur);
	if(pCol->bGroup)
	{
		AfxMessageBox(APL_T("  ,    !"), MB_ICONINFORMATION|MB_OK);
		return;
	}
	//  .    ,   

	buf = pCol->pColumn->GetName();
	m_Columns_ListCtrl.DeleteItem(cur++);
	
	ind =		m_Columns_ListCtrl.InsertItem(cur, buf);
				m_Columns_ListCtrl.SetItemText(ind, 1, pCol->sTitle);
				buf.Format(_T("%.1f"), ((double)pCol->iWidth/10));
				m_Columns_ListCtrl.SetItemText(ind, 2, buf);
				m_Columns_ListCtrl.SetItemData(ind, (DWORD)pCol);
				
				m_Columns_ListCtrl.SetItemEditType(ind, 1, aplTextCtrl);
				m_Columns_ListCtrl.SetItemEditType(ind, 2, aplRealCtrl);
				
	m_Columns_ListCtrl.SetItemState(cur, LVIS_SELECTED|LVIS_FOCUSED, LVIS_SELECTED|LVIS_FOCUSED);
}

void CSetupcolumnsPage::OnColumnlistEndedit(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMLISTVIEW pListView = (LPNMLISTVIEW)pNMHDR;
	if(pListView->iItem<0) return;
	if(pListView->iSubItem==2)
	{
		//       
		CString buf;
		CTMColumn *pCol;
		buf = m_Columns_ListCtrl.GetItemText(pListView->iItem, pListView->iSubItem);
		double dVal = __atof(buf);
		pCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(pListView->iItem);
		pCol->iWidth = (int)(dVal*10);
		buf.Format(_T("%.1f"), (double)pCol->iWidth/10);
		m_Columns_ListCtrl.SetItemText(pListView->iItem, pListView->iSubItem, buf);
	}
	else if(pListView->iSubItem==1)
	{
		CString buf;
		CTMColumn *pCol;
		buf = m_Columns_ListCtrl.GetItemText(pListView->iItem, pListView->iSubItem);
		pCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(pListView->iItem);
		pCol->sTitle = buf;
	}
}

bool CSetupcolumnsPage::FillData()
{
	if(m_pTemplate==NULL) return false;

	int w, h, i;
	CTMColumn* pCol;
	w = int(m_dWidth*10);
	h = int(m_dHeight*10);
	int l, r, t, b;
	l = int(m_dLeft*10);
	t = int(m_dTop*10);
	r = int((m_dWidth-m_dRight)*10);
	b = int((m_dHeight-m_dBottom)*10);

	m_pTemplate->m_page_sizes = CSize(w, h);
	m_pTemplate->m_table_rect = CRect(l, -b, r, -t);

	m_pTemplate->m_ColumnsArray.RemoveAll();
	for(i=0; i<m_Columns_ListCtrl.GetItemCount(); i++)
	{
		pCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(i);
		m_pTemplate->m_ColumnsArray.Add(pCol);
	}

	m_pTemplate->m_table_line_width = int(m_dTableLineWidth*10);
	m_pTemplate->m_title_line_width= int(m_dTitleLineWidth*10);

	return true;
}

void CSetupcolumnsPage::UpdateColumnsWidth()
{
	int cx = int((m_dWidth - m_dLeft - m_dRight) * 10);
	int delta = 0, c_width = 0;
	int width = (int)(cx / m_pTemplate->m_ColumnsArray.GetSize());
	int i;
	CString buf;
	CTMColumn* pCol;
	c_width = width * m_pTemplate->m_ColumnsArray.GetSize();
	delta = cx - c_width;

	buf.Format(_T("%.1f"), (double)width / 10);
	for (i = 0; i < m_Columns_ListCtrl.GetItemCount(); i++)
	{
		pCol = (CTMColumn*)m_Columns_ListCtrl.GetItemData(i);
		pCol->iWidth = width;
		if (delta > 0)
		{
			buf.Format(_T("%.1f"), (double)(width + delta) / 10);
			pCol->iWidth = width + delta;
			m_Columns_ListCtrl.SetItemText(i, 2, buf);
			buf.Format(_T("%.1f"), (double)width / 10);
			delta = 0;
			continue;
		}
		m_Columns_ListCtrl.SetItemText(i, 2, buf);
	}
}

void CSetupcolumnsPage::OnCalcColumnsWidth() 
{
	if(!UpdateData()) return;

	UpdateColumnsWidth();
}
