// TablePropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "TablePropDlg.h"
#include "ReportDict.h"
#include "SectionPropDlg.h"
#include "functions.h"
#include "PropertyDlg.h"
#include "aplReportUserInterface.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTablePropDlg dialog


CTablePropDlg::CTablePropDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CTablePropDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTablePropDlg)
	m_table_name = _T("");
	m_font_size = 0;
	m_font_name = _T("");
	//}}AFX_DATA_INIT
	m_table = NULL;
}


void CTablePropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTablePropDlg)
	DDX_Control(pDX, IDC_SECTION_ADD_COPY, m_sec_add_copy);
	DDX_Control(pDX, IDC_SETION_DOWN, m_down);
	DDX_Control(pDX, IDC_SECTION_UP, m_up);
	DDX_Control(pDX, IDC_SECTIONS, m_section_list);
	DDX_Control(pDX, IDC_SETION_PROP, m_sec_prop);
	DDX_Control(pDX, IDC_SECTION_DEL, m_sec_del);
	DDX_Control(pDX, IDC_SECTION_ADD, m_sec_add);
	DDX_Text(pDX, IDC_TABLE_NAME, m_table_name);
	DDX_Text(pDX, IDC_FONT_SIZE, m_font_size);
	DDX_Text(pDX, IDC_FONT_NAME, m_font_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTablePropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CTablePropDlg)
	ON_BN_CLICKED(IDC_SECTION_ADD, OnSectionAdd)
	ON_BN_CLICKED(IDC_SECTION_DEL, OnSectionDel)
	ON_BN_CLICKED(IDC_SETION_PROP, OnSetionProp)
	ON_BN_CLICKED(IDC_FONT_BROWSE, OnFontBrowse)
	ON_BN_CLICKED(IDC_SECTION_UP, OnSectionUp)
	ON_BN_CLICKED(IDC_SETION_DOWN, OnSetionDown)
	ON_NOTIFY(HDN_ITEMDBLCLICK, IDC_SECTIONS, OnItemdblclickSections)
	ON_BN_CLICKED(IDC_SECTION_ADD_COPY, OnSectionAddCopy)
	ON_NOTIFY(NM_DBLCLK, IDC_SECTIONS, OnDblclkSections)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTablePropDlg message handlers

BOOL CTablePropDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	if(m_table==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	m_up.SetIcon(aplGetStdIco16(APL_STD_TOP));
	m_up.SetTooltipText(APL_T(" "));
	m_down.SetIcon(aplGetStdIco16(APL_STD_BOTTOM));
	m_down.SetTooltipText(APL_T(" "));

	m_section_list.InsertColumn(0,_T(""),LVCFMT_LEFT,200);
	m_section_list.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_lf = m_table->m_row_lf;
	m_sec_prop.SetIcon(aplGetStdIco16(APL_STD_PROPERTIES));
	m_sec_prop.SetTooltipText(APL_T(""));
	m_sec_add.SetIcon(aplGetStdIco16(APL_STD_NEW_SECTION));
	m_sec_add.SetTooltipText(APL_T(" "));
	m_sec_del.SetIcon(aplGetStdIco16(APL_STD_DELETE));
	m_sec_del.SetTooltipText(APL_T(" "));
	m_sec_add_copy.SetIcon(aplGetStdIco16(APL_STD_COPY_SECTION));
	m_sec_add_copy.SetTooltipText(APL_T("  "));
	m_table_name = m_table->m_name;
	m_font_name = m_table->m_row_lf.lfFaceName;
	m_font_size = m_table->m_row_lf.lfHeight/10;

	/*if(!HasLicense())   .        
	{
		m_sec_add_copy.EnableWindow(FALSE);
		m_sec_add.EnableWindow(FALSE);
	}*/


	for(int i=0; i<m_table->m_sections.GetSize();i++)
	{
		CReportSection* sec = m_table->m_sections.GetAt(i);
		int ind = m_section_list.InsertItem(i,sec->m_name);
		m_section_list.SetItemData(ind,DWORD(sec));
	}
	UpdateData(FALSE);
	if(mode>0)
	{
		CEdit* wnd = (CEdit*)GetDlgItem(IDC_TABLE_NAME);
		wnd->SetReadOnly();
		wnd = (CEdit*)GetDlgItem(IDC_ROW_HEIGHT);
		wnd->SetReadOnly();
		CWnd* pWnd = GetDlgItem(IDC_SECTION_ADD);
		pWnd->EnableWindow(FALSE);
		pWnd = GetDlgItem(IDC_SECTION_DEL);
		pWnd->EnableWindow(FALSE);
		pWnd = GetDlgItem(IDC_SETION_PROP);
		pWnd->EnableWindow(FALSE);
		pWnd = GetDlgItem(IDC_FONT_BROWSE);
		pWnd->EnableWindow(FALSE);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTablePropDlg::OnSectionAdd() 
{
	CReportSection* sec = new CReportSection(m_table->m_ReportMgr);
	CSectionPropDlg dlg;
	dlg.m_section = sec;
	if(dlg.DoModal()!=IDOK)
	{
		delete sec;
		return;
	}
	int ind = m_section_list.InsertItem(m_section_list.GetItemCount(),sec->m_name);
	m_section_list.SetItemData(ind,DWORD(sec));
	m_table->m_sections.Add(sec);
	CWnd* pWnd = GetParent();
	pWnd= pWnd->GetParent();
	CWnd* btn = pWnd->GetDlgItem(IDCANCEL);
	btn->EnableWindow(FALSE);
}

void CTablePropDlg::OnSectionDel() 
{
	int cur = m_section_list.GetNextItem(-1,LVIS_SELECTED);
	if(cur<0) return;
	if(AfxMessageBox(APL_T("     ?"),MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON2)==IDNO)
		return;
	CReportSection* sec = (CReportSection*)m_section_list.GetItemData(cur);
	int cnt = m_table->m_sections.GetSize();
	for(int i=0; i<cnt;i++)
	{
		CReportSection* s = m_table->m_sections.GetAt(i);
		if(sec==s)
		{
			s->DeleteSection();
			m_table->m_sections.RemoveAt(i);
			CWnd* pWnd = GetParent();
			pWnd= pWnd->GetParent();
			CWnd* btn = pWnd->GetDlgItem(IDCANCEL);
			btn->EnableWindow(FALSE);
			m_section_list.DeleteItem(cur);
			return;
		}
	}
}

void CTablePropDlg::OnSetionProp() 
{
	int cur = m_section_list.GetNextItem(-1,LVIS_SELECTED);
	if(cur<0) return;
	CReportSection* sec = (CReportSection*)m_section_list.GetItemData(cur);
	CSectionPropDlg dlg;
	dlg.m_section = sec;
	if(dlg.DoModal()==IDOK)
	{
		m_section_list.SetItemText(cur,0,sec->m_name);
		CWnd* pWnd = GetParent();
		pWnd= pWnd->GetParent();
		CWnd* btn = pWnd->GetDlgItem(IDCANCEL);
		btn->EnableWindow(FALSE);
	}
}

void CTablePropDlg::OnOK() 
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnOK();
}

void CTablePropDlg::OnCancel() 
{
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnCancel();
}

bool CTablePropDlg::UpdateDlg()
{
	if(!TestUpdate()) return false;
	m_table->m_name = m_table_name;
	m_table->m_row_lf = m_lf;
	return true;
}

void CTablePropDlg::OnFontBrowse() 
{
	UpdateData();
	CFontDialog	dlg(&m_lf);
	int old = m_lf.lfHeight;
	CDC* pDC = GetDC();
	m_lf.lfHeight = -MulDiv(-old/20, GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 36);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	dlg.m_cf.lpLogFont = &m_lf;
	if(dlg.DoModal()==IDOK)
	{
		m_lf.lfHeight = dlg.GetSize();
		m_font_size = dlg.GetSize()/10;
		m_font_name = m_lf.lfFaceName;
		UpdateData(FALSE);
	}
	else
		m_lf.lfHeight = old;
	
	ReleaseDC(pDC);
}

void CTablePropDlg::OnSectionUp() 
{
	int cur = m_section_list.GetNextItem(-1,LVIS_SELECTED);
	if(cur<1) return;
	CReportSection* sec = (CReportSection*)m_section_list.GetItemData(cur);
	m_table->m_sections.Replace(sec,-1);
	m_section_list.DeleteItem(cur);
	m_section_list.InsertItem(cur-1,sec->m_name);
	m_section_list.SetItemData(cur-1,(DWORD)sec);
	SelectString(&m_section_list,cur-1);

	CWnd* pWnd = GetParent();
	pWnd= pWnd->GetParent();
	CWnd* btn = pWnd->GetDlgItem(IDCANCEL);
	btn->EnableWindow(FALSE);
}

void CTablePropDlg::OnSetionDown() 
{
	int cur = m_section_list.GetNextItem(-1,LVIS_SELECTED);
	if(cur<0 || cur>m_section_list.GetItemCount()-2) return;
	CReportSection* sec = (CReportSection*)m_section_list.GetItemData(cur);
	m_table->m_sections.Replace(sec,1);
	m_section_list.DeleteItem(cur);
	m_section_list.InsertItem(cur+1,sec->m_name);
	m_section_list.SetItemData(cur+1,(DWORD)sec);
	SelectString(&m_section_list,cur+1);

	CWnd* pWnd = GetParent();
	pWnd= pWnd->GetParent();
	CWnd* btn = pWnd->GetDlgItem(IDCANCEL);
	btn->EnableWindow(FALSE);
}


void CTablePropDlg::OnItemdblclickSections(NMHDR* pNMHDR, LRESULT* pResult) 
{
	HD_NOTIFY *phdn = (HD_NOTIFY *) pNMHDR;
	// TODO: Add your control notification handler code here
	OnSetionProp();
	
	*pResult = 0;
}

void CTablePropDlg::OnSectionAddCopy() 
{
	int cur = m_section_list.GetNextItem(-1,LVIS_SELECTED);
	if(cur<0) return;
	CReportSection* sec = (CReportSection*)m_section_list.GetItemData(cur);
	CReportSection* nSec = new CReportSection(m_table->m_ReportMgr);
	*nSec = *sec;
	nSec->ZerroInsts();
	CSectionPropDlg dlg;
	dlg.m_section = nSec;
	if(dlg.DoModal()!=IDOK)
	{
		delete nSec;
		return;
	}
	int ind = m_section_list.InsertItem(m_section_list.GetItemCount(),nSec->m_name);
	m_section_list.SetItemData(ind,DWORD(nSec));
	m_table->m_sections.Add(nSec);
	CWnd* pWnd = GetParent();
	pWnd= pWnd->GetParent();
	CWnd* btn = pWnd->GetDlgItem(IDCANCEL);
	btn->EnableWindow(FALSE);
}

void CTablePropDlg::OnDblclkSections(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnSetionProp();
	
	*pResult = 0;
}

bool CTablePropDlg::TestUpdate()
{
	if(!UpdateData()) return false;
	if(m_table_name==_T(""))
	{
		AfxMessageBox(APL_T("   ."));
		return false;
	}

	return true;
}
