#include "stdafx.h"

#include "auxReportDict.h"
#include "..\aplPdfWriterLib\aplPdf_aux.h"
#include "..\aplPdfWriterLib\hlprDll.h"

void auxReportDict::hlp::Do_reportMgrToPdf( const CString &exportFileName, const CaplReportMgr& m_ReportMgr )
{
	apl::reportCtr::pdfWriterHandler *pH;
	//
	typedef void (*pf_makePdfWithMgr)( const CaplReportMgr& repMgr, apl::reportCtr::pdfWriterHandler* H, LPCTSTR fullPdfName, int debugLevel );
	typedef int (*pf_genReport)( LPCTSTR fullDotName, LPCTSTR fullSourceName, LPCTSTR fullRepName );
	typedef int (*pf_mkPdf)( LPCTSTR fullRepName, apl::reportCtr::pdfWriterHandler& H, LPCTSTR fullPdfName, int debugLevel );
	typedef bool (*pf_splitRep)( LPCTSTR rep1, LPCTSTR rep2, LPCTSTR repResult );
	typedef void (*pf_dtrWriterHandler)( apl::reportCtr::pdfWriterHandler* ptr );
	typedef bool (*pf_isReadyWriterHandler)(apl::reportCtr::pdfWriterHandler* ptr);
	//
	pf_makePdfWithMgr makePdfWithMgr = NULL;
	pf_genReport genReport = NULL;
	pf_mkPdf mkPdf = NULL;
	pf_splitRep splitRep = NULL;
	pf_dtrWriterHandler dtrWriterHandler = NULL;
	pf_isReadyWriterHandler isReadyWriterHandler = NULL;
	//
	{
		CString path;
		auxReportDict::hlp::GetExePath(path);//apl::reportCtr::aux::getExePath();
		HINSTANCE hInstAplPdfWr = LoadLibrary(path+_T("aplPdfWriter.dll"));		

		if (!hInstAplPdfWr)
		{
			AfxMessageBox(_T("WRONG! aplPdfWriter.dll is NOT loaded"));
			return;
		}
		else
		{
			using namespace apl::hlprDll;
			typedef apl::reportCtr::pdfWriterHandler* (*pf_crtWriterHandler)(const char* fullNamePath);
			typedef apl::reportCtr::pdfWriterHandler* (*pf_crtWriterHandlerDef)();
			//
			//pf_crtWriterHandler crtHandle = resolveF<pf_crtWriterHandler>(_T("crtWriterHandler"), hInstAplPdfWr);
			pf_crtWriterHandlerDef crtHandleDef = resolveF<pf_crtWriterHandlerDef>("crtWriterHandlerDef", hInstAplPdfWr);
			makePdfWithMgr = resolveF<pf_makePdfWithMgr>("makePdfWithMgr", hInstAplPdfWr);
			genReport = resolveF<pf_genReport>("genReport", hInstAplPdfWr);
			mkPdf = resolveF<pf_mkPdf>("mkPdf", hInstAplPdfWr);
			splitRep = resolveF<pf_splitRep>("splitRep", hInstAplPdfWr);
			dtrWriterHandler = resolveF<pf_dtrWriterHandler>("dtrWriterHandler", hInstAplPdfWr);
			isReadyWriterHandler = resolveF<pf_isReadyWriterHandler>("isReadyWriterHandler", hInstAplPdfWr);
			//
			if (!(crtHandleDef&&makePdfWithMgr&&genReport&&mkPdf&&splitRep&&dtrWriterHandler&&isReadyWriterHandler))
			{
				AfxMessageBox(_T("WRONG! function from aplPdfWriter.dll was NOT resolved"));
				return;
			}
			else
			{
				//pH = crtHandle(_T(path+_T("\\")+_T("PdfWriter.dll")));
				pH = crtHandleDef();
				if (!pH)
				{
					AfxMessageBox(_T("WRONG! dll handler is NULL"));
					return;
				}
			}
		} 
	}
	//
	//
	if (isReadyWriterHandler(pH))
	{
		//static const char *pdfFName = _T("d://_rep.pdf");
		static const int debugLevel=0;
		makePdfWithMgr(m_ReportMgr, pH, exportFileName, debugLevel);
	}
	//
	dtrWriterHandler(pH);
}

bool auxReportDict::hlp::GetExePath( CString &buf )
{
	buf.Empty();
	TCHAR *tBuf = new TCHAR[1024];
	GetModuleFileName(GetModuleHandle(NULL), tBuf, 1024);
	buf+=tBuf;
	delete []tBuf;
	if(buf.Find(_T("\\"))>-1)
	{
		buf = buf.Left(buf.ReverseFind(_T('\\'))+1);
	}
	else
	{
		buf.Empty();
	}
	//
	return true;
}



