// CreatePrjCopyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CreatePrjCopyDlg.h"


// CCreatePrjCopyDlg dialog

IMPLEMENT_DYNAMIC(CCreatePrjCopyDlg, CaplTranslateDialog)

CCreatePrjCopyDlg::CCreatePrjCopyDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CCreatePrjCopyDlg::IDD, pParent)
{
	m_api=0;
	m_prj_mgr=0;
	m_new_prj=0;
	m_src_prj=0;
	m_parent=0;

}

CCreatePrjCopyDlg::~CCreatePrjCopyDlg()
{
}

void CCreatePrjCopyDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SRC_PRJ_NAME, m_src_prj_name_ctrl);
	DDX_Control(pDX, IDC_SRC_PRJ_ID, m_src_prj_id_ctrl);
	DDX_Control(pDX, IDC_DST_PRJ_ID, m_dst_prj_id_ctrl);
	DDX_Control(pDX, IDC_SRC_STR, m_src_str_ctrl);
	DDX_Control(pDX, IDC_DST_STR, m_dst_str_ctrl);
	DDX_Control(pDX, IDC_SET_NEW_DATE, m_set_new_date_btn);
	DDX_Control(pDX, IDC_NEW_DATE, m_new_date_ctrl);
	DDX_Control(pDX, IDC_CREANE_NEW_DOCS, m_create_new_docs_btn);
	DDX_Control(pDX, IDC_FOLDER, m_folder_ctrl);
	DDX_Control(pDX, IDC_DATE_TYPE, m_date_type_ctrl);
	DDX_Control(pDX, IDC_SRC_PRJ_NUM, m_src_prj_num_ctrl);
	DDX_Control(pDX, IDC_DST_PRJ_NUM, m_dst_prj_num_ctrl);
	DDX_Control(pDX, IDC_SRC_NUM_SUBSTR, m_src_num_str_ctrl);
	DDX_Control(pDX, IDC_DST_NUM_SUBSTR, m_dst_num_str_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_COPY_EXECUTORS, m_copy_executors_btn);
	DDX_Control(pDX, IDC_COPY_COEXECUTORS, m_copy_coexecutors_btn);
	DDX_Control(pDX, IDC_COPY_COCUSTOMERS, m_copy_cocustomers_btn);
	DDX_Control(pDX, IDC_COPY_ACCESS, m_copy_access_btn);
	DDX_Control(pDX, IDC_SEL_FOLDER, m_sel_perent_prj_btn);
	DDX_Control(pDX, IDC_COPY_KURATOR, m_copy_kurator_btn);
	DDX_Control(pDX, IDC_COPY_CUSTOMER, m_copy_customer_btn);
}


BEGIN_MESSAGE_MAP(CCreatePrjCopyDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_SEL_SRC_PRJ, &CCreatePrjCopyDlg::OnBnClickedSelSrcPrj)
	ON_EN_CHANGE(IDC_SRC_STR, &CCreatePrjCopyDlg::OnEnChangeSrcStr)
	ON_EN_CHANGE(IDC_DST_STR, &CCreatePrjCopyDlg::OnEnChangeDstStr)
	ON_BN_CLICKED(IDOK, &CCreatePrjCopyDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_SEL_FOLDER, &CCreatePrjCopyDlg::OnBnClickedSelFolder)
	ON_EN_CHANGE(IDC_SRC_NUM_SUBSTR, &CCreatePrjCopyDlg::OnEnChangeSrcNumSubstr)
	ON_EN_CHANGE(IDC_DST_NUM_SUBSTR, &CCreatePrjCopyDlg::OnEnChangeDstNumSubstr)
	ON_BN_CLICKED(IDC_SET_NEW_DATE, &CCreatePrjCopyDlg::OnBnClickedSetNewDate)
END_MESSAGE_MAP()


// CCreatePrjCopyDlg message handlers

BOOL CCreatePrjCopyDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	if(!Init()) return FALSE;

	m_set_new_date_btn.SetCheck(1);
	m_create_new_docs_btn.SetCheck(1);

	m_date_type_ctrl.ResetContent();
	int sel=m_date_type_ctrl.AddString(APL_T(""));
	m_date_type_ctrl.SetCurSel(sel);
	m_date_type_ctrl.AddString(APL_T(""));


	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CCreatePrjCopyDlg::OnBnClickedSetNewDate()
{
	BOOL b=FALSE;
	if(m_set_new_date_btn.GetCheck()==1) b=TRUE;
	m_new_date_ctrl.EnableWindow(b);
	m_date_type_ctrl.EnableWindow(b);
}


void CCreatePrjCopyDlg::OnBnClickedSelFolder()
{
	CaplInstance *parent=m_prj_mgr->SelectInstance(APL_MODE_SELECT_FOLDER|APL_MODE_SELECT_PROJECT,APL_T("    "));
	if(0==parent) return;
	CString buf;
	m_api->GetItemName(parent,buf);
	m_folder_ctrl.SetWindowText(buf);
	m_parent=parent;
}


void CCreatePrjCopyDlg::OnBnClickedSelSrcPrj()
{
	if(m_prj_mgr==0) return;
	CaplInstance *prj_src=m_prj_mgr->SelectInstance(APL_MODE_SELECT_PROJECT,APL_T("  "));
	if(0==prj_src) return;
	m_src_prj=prj_src;
	Init();
}


bool CCreatePrjCopyDlg::Init()
{
	if(m_api==0) return false;
	if(m_prj_mgr==0) return false;

	CString id,name,buf;
	//if(m_src_prj==0){AfxMessageBox(APL_T("   !"),MB_OK|MB_ICONSTOP); 	return false; }
	if(m_src_prj!=0)
	{
		if(m_src_prj->GetType()==0){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONSTOP); 	return false; }
		if(m_src_prj->GetAccessmode()>aplRO){AfxMessageBox(APL_T("    !"),MB_OK|MB_ICONSTOP); 	return false; }
		m_api->m_data.GetAttr(m_src_prj,m_prj_mgr->a_project_id,id);
		m_src_prj_id_ctrl.SetWindowText(id);
		m_api->m_data.GetAttr(m_src_prj,m_prj_mgr->a_project_name,name);
		m_src_prj_name_ctrl.SetWindowText(name);

		m_api->m_data.GetAttr(m_src_prj,m_prj_mgr->a_project_number,buf);

		m_src_prj_num_ctrl.SetWindowText(buf);
	}

	if(m_parent!=0)
	{
		m_api->GetItemName(m_parent,buf);
		m_folder_ctrl.SetWindowText(buf);

		m_sel_perent_prj_btn.EnableWindow(FALSE);
	}

	OnEnChangeSrcStr();
	return true;
}
void CCreatePrjCopyDlg::OnEnChangeSrcStr()
{
	CString id,src,dst;
	m_src_prj_id_ctrl.GetWindowText(id);
	m_src_str_ctrl.GetWindowText(src);
	m_dst_str_ctrl.GetWindowText(dst);
	id.Replace(src,dst);
	m_dst_prj_id_ctrl.SetWindowText(id);
}

void CCreatePrjCopyDlg::OnEnChangeDstStr() {OnEnChangeSrcStr();}

void CCreatePrjCopyDlg::OnEnChangeSrcNumSubstr()
{
	CString id,src,dst;
	m_src_prj_num_ctrl.GetWindowText(id);
	m_src_num_str_ctrl.GetWindowText(src);
	m_dst_num_str_ctrl.GetWindowText(dst);
	if(src==_T(""))
	{
		if(dst!=_T("")) id=dst;
		//else id=id;
	}
	else 
	{
		if(dst==_T("")) id=_T("");
		else id.Replace(src,dst);
	}
	m_dst_prj_num_ctrl.SetWindowText(id);
}

void CCreatePrjCopyDlg::OnEnChangeDstNumSubstr(){OnEnChangeSrcNumSubstr();}


//***********************************************************************
void CCreatePrjCopyDlg::OnBnClickedOk()
{
	if(m_src_prj==0){AfxMessageBox(APL_T("   !"),MB_OK|MB_ICONSTOP); 	return; }
	if(m_src_prj->GetType()==0){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONSTOP); 	return; }
	if(m_src_prj->GetAccessmode()>aplRO){AfxMessageBox(APL_T("    !"),MB_OK|MB_ICONSTOP); 	return; }

	bool b_copy_executors=(1==m_copy_executors_btn.GetCheck());
	bool b_copy_coexecutors=(1==m_copy_coexecutors_btn.GetCheck());
	bool b_copy_cocustomers=(1==m_copy_cocustomers_btn.GetCheck());
	bool b_copy_kurator=(1==m_copy_kurator_btn.GetCheck());
	bool b_copy_customer=(1==m_copy_customer_btn.GetCheck());

	bool b_copy_access=(1==m_copy_access_btn.GetCheck());

	int i,j;
	aplExtent ext_src_prj;
	CString buf, id, src, dst,src_num,dst_num;

	m_src_str_ctrl.GetWindowText(src);
	m_dst_str_ctrl.GetWindowText(dst);

	if(src==_T("")){AfxMessageBox(APL_T("   !"),MB_OK|MB_ICONSTOP); 	return; }
	if(dst==_T("")){AfxMessageBox(APL_T("   !"),MB_OK|MB_ICONSTOP); 	return; }
	if(dst==src){AfxMessageBox(APL_T(" !"),MB_OK|MB_ICONSTOP); 	return; }

	if(m_parent==0){AfxMessageBox(APL_T("     !"),MB_OK|MB_ICONSTOP); 	return; }
	if(m_parent->GetAccessmode()>aplRW){AfxMessageBox(APL_T("    !"),MB_OK|MB_ICONSTOP); 	return; }

	m_src_num_str_ctrl.GetWindowText(src_num);
	m_dst_num_str_ctrl.GetWindowText(dst_num);

	if(src==_T("") && dst_num!=_T("")){AfxMessageBox(APL_T("      !"),MB_OK|MB_ICONSTOP); 	return; }



	//   
	m_api->m_data.GetAttr(m_src_prj,m_prj_mgr->a_project_id,buf);
	if(buf.Find(src)<0)  
	{
		AfxMessageBox(APL_T("      !\n\n !"),MB_OK|MB_ICONSTOP); 
		return;
	}
	
	m_prj_mgr->GetAllSubProject(m_src_prj,ext_src_prj,true,true,true);

	buf=_T("");

	if(b_copy_access)
	{
		int nNoAcc=0;
		for(i=0;i<ext_src_prj.GetSize();i++)
		{
			CaplInstance *i_prj=ext_src_prj[i];
			if(i_prj->GetIsUserAccess()==aplOWN) continue;

			m_api->m_data.GetAttr(i_prj,m_prj_mgr->a_project_id,id);
			if(buf!=_T("")) buf+="\n";
			buf+=id;
			nNoAcc++;
		}

		if(nNoAcc>0)
		{
			CString sMsg;
			sMsg.Format(APL_T("    %i !\n\n  !\n\n    ?"),nNoAcc);
			if(IDYES==AfxMessageBox(sMsg,MB_YESNO|MB_ICONSTOP)) aplShowBigMsg(buf,APL_T("   "));
			return;
		}
	}



	CString mindate=_T("99999999999999");
	CString maxdate=_T("00000000000000");

	aplExtent ext_tmp_projects;
	ext_tmp_projects.Unique=false;
	ext_tmp_projects.Add(m_src_prj);
	ext_tmp_projects.Append(ext_src_prj);

	for(i=0;i<ext_tmp_projects.GetSize();i++)
	{
		CaplInstance *i_prj=ext_tmp_projects[i];
		m_api->m_data.GetAttr(i_prj,m_prj_mgr->a_project_id,id);
		if(id.Find(src)<0)  
		{
			buf.Format(APL_T("   '%s'   !\n\n !"),LPCTSTR(id));
			AfxMessageBox(buf,MB_OK|MB_ICONSTOP); 
			return;
		}
		id.Replace(src,dst);
		CaplInstance *prj1=m_prj_mgr->FindProjectById(LPCTSTR(id));
		if(0!=prj1)
		{
			buf.Format(APL_T("     '%s',   !\n\n !"),LPCTSTR(id));
			AfxMessageBox(buf,MB_OK|MB_ICONSTOP); 
			return;
		}

		m_api->m_data.GetAttr(i_prj,m_prj_mgr->a_project_date_planned_begin,buf);
		if(buf!=_T(""))
		{ 
			if(buf<mindate) mindate=buf;	
			if(buf>maxdate) maxdate=buf;	
		}
		
		m_api->m_data.GetAttr(i_prj,m_prj_mgr->a_project_date_planned_end,buf);
		if(buf!=_T(""))
		{ 
			if(buf<mindate) mindate=buf;	
			if(buf>maxdate) maxdate=buf;	
		}

	}
	BOOL bCreatDocs=m_create_new_docs_btn.GetCheck();

	CaplMap m_prj_map;
	//   ;


	long wdlg0=aplStartWaitDlg( APL_T(" "));

	COleDateTime odt_base,odt_new;
	if(m_set_new_date_btn.GetCheck()==1)
	{
		m_new_date_ctrl.GetTime(odt_new);
		odt_new.SetDateTime(odt_new.GetYear(),odt_new.GetMonth(),odt_new.GetDay(),0,0,0);

		//int type=m_date_type_ctrl.GetCurSel();
		CString sType;
		m_date_type_ctrl.GetWindowText(sType);
		if(sType==_T("")) aplString2Date(mindate,odt_base); // 
		else aplString2Date(maxdate,odt_base);//

		odt_base.SetDateTime(odt_base.GetYear(),odt_base.GetMonth(),odt_base.GetDay(),0,0,0);
	}
	else odt_base.SetStatus(COleDateTime::null);

	CaplInstance *new_prj=CreatePrjCopy(m_src_prj,src,dst,src_num,dst_num,odt_base,odt_new, b_copy_executors, b_copy_coexecutors, b_copy_cocustomers, b_copy_kurator, b_copy_customer);
	m_prj_map.Add((long)m_src_prj,(long)new_prj);

	CaplAggr tmpAggr;

	for(i=0;i<ext_src_prj.GetSize();i++)
	{
		CaplInstance *inst1=CreatePrjCopy(ext_src_prj[i],src,dst,src_num,dst_num,odt_base,odt_new, b_copy_executors, b_copy_coexecutors, b_copy_cocustomers, b_copy_kurator, b_copy_customer);
		if(0!=inst1)
		{
			m_prj_map.Add((long)(ext_src_prj[i]),(long)inst1);
		}
	}

	//   
	ext_src_prj.Add(m_src_prj);

	CaplInstance *prj0,*prj1,*inst0,*inst1,*inst00,*inst01;
	aplExtent ext0,ext1;
	for(i=0;i<ext_src_prj.GetSize();i++)
	{
		prj0=ext_src_prj[i];
		prj1=(CaplInstance*)m_prj_map.GetByInP((long)prj0);
		if(0==prj1) continue;
		
		// 
		m_api->m_data.GetAttr(prj0,m_prj_mgr->a_project_parent,inst0);
		inst1=(CaplInstance*)m_prj_map.GetByInP((long)inst0);
		if(inst1!=0) m_api->m_data.PutAttr(prj1,m_prj_mgr->a_project_parent,inst1);

		ext1.Clear();
		m_api->m_data.GetAttr(prj0,m_prj_mgr->a_project_content,ext0);
		for(j=0;j<ext0.GetSize();j++)
		{
			inst1=(CaplInstance*)m_prj_map.GetByInP((long)(ext0[j]));
			if(inst1!=0) ext1.Add(inst1);
		}
		if(ext1.GetSize()>0)  m_api->m_data.PutAttr(prj1,m_prj_mgr->a_project_content,ext1);

		// 
		m_prj_mgr->GetProjectSequenceRelation(prj0,ext0,true);
		for(j=0;j<ext0.GetSize();j++)
		{
			CaplInstance *rel0=ext0[j];
			m_api->m_data.GetAttr(rel0,m_prj_mgr->a_project_seq_prev,inst00);
			inst01=(CaplInstance*)m_prj_map.GetByInP((long)inst00);

			if(0==inst01) continue;
			CaplInstance *rel1=m_api->m_data.CreateInstance(m_prj_mgr->e_project_seg);
			m_api->m_data.PutAttr(rel1,m_prj_mgr->a_project_seq_prev,inst01);
			m_api->m_data.PutAttr(rel1,m_prj_mgr->a_project_seq_next,prj1);

			m_api->m_data.PutAttr(rel1,m_prj_mgr->a_project_seq_type,buf);
			m_api->m_data.PutAttr(rel1,m_prj_mgr->a_project_seq_type,buf);
		}
	}

	if(m_api->m_data.IsKindOf(m_parent,m_prj_mgr->e_project))
	{
		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_parent,m_parent);
		m_prj_mgr->AddToParentContent(new_prj,m_parent);
	}
	else if(m_api->m_data.IsKindOf(m_parent,m_api->m_folder_mgr.e_folder))
	{
		m_api->m_folder_mgr.AddToFolder(m_parent,new_prj);
	}

	aplEndWaitDlg(wdlg0);
	m_api->SaveChanges();

	//  
	if(b_copy_access)
	{
		aplExtent extFrom, extTo;
		for(i=0;i<m_prj_map.Size;i++)
		{
			CaplInstance *ifrom=(CaplInstance*)m_prj_map.Data[i].in;
			CaplInstance *ito=(CaplInstance*)m_prj_map.Data[i].out;
			extFrom.Add(ifrom);
			extTo.Add(ito);
		}
		m_api->m_data.NET_CopyAccessFromInst2Inst(extFrom, extTo, APL_T(" "),0,0);
	}

	//  
	if(bCreatDocs)
	{
		long wdlg1=aplStartWaitDlg( APL_T(" "));
		for(i=0;i<m_prj_map.Size;i++)
		{
			buf.Format(APL_T("  %i  %i"),i,m_prj_map.Size-1);
			aplSetTextWaitDlg(wdlg1,buf);
			CreateDocCopy((CaplInstance*)(m_prj_map[i].in),(CaplInstance*)(m_prj_map[i].out),src,dst);
		}
		aplEndWaitDlg(wdlg1);
	}

	m_api->SaveChanges();


	m_new_prj=new_prj;

	OnOK();
}



//***********************************************************************
CaplInstance *CCreatePrjCopyDlg::CreatePrjCopy(CaplInstance *src_prj, LPCTSTR src_str, LPCTSTR dst_str, CString &src_num_str, CString &dst_num_str, 
											   COleDateTime &odt_base, COleDateTime &odt_new,
											   bool b_copy_executors, bool b_copy_coexecutors, bool b_copy_cocustomers, bool b_copy_kurator, bool b_copy_customer)
{
	CaplInstance *inst;
	CString buf;
	double d;
	int i;
	COleDateTime odt;
	COleDateTimeSpan delta_dates;

	if((odt_new.GetStatus()==COleDateTime::valid)&& (odt_new.GetStatus()!=COleDateTime::null) && (odt_base.GetStatus()==COleDateTime::valid) && (odt_base.GetStatus()!=COleDateTime::null) )
	{
		delta_dates = odt_new - odt_base;
	}

	CaplInstance *new_prj=m_api->m_data.CreateInstance(m_prj_mgr->e_project);

	m_api->m_data.PutAttr(new_prj, m_prj_mgr->a_project_state, APL_T(""));

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_id,buf);
	buf.Replace(src_str,dst_str);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_id,buf);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_number,buf);
	if(src_num_str==_T(""))
	{
		if(dst_num_str!=_T("")) buf=dst_num_str;
		//else id=id;
	}
	else 
	{
		if(dst_num_str==_T("")) buf=_T("");
		else buf.Replace(src_num_str,dst_num_str);
	}
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_number,buf);


	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_name,buf);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_name,buf);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_name,buf);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_name,buf);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_descr,buf);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_descr,buf);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_descr2,buf);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_descr2,buf);

	COleDateTime odt_new_start, odt_new_end;

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_date_planned_begin,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,odt);
		odt+=delta_dates;
		odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),0,0,0);
		odt_new_start=odt;
		aplDate2String(odt,buf);
		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_date_planned_begin,buf);
	}

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_date_planned_end,buf);
	if(buf!=_T("") )
	{
		aplString2Date(buf,odt);
		odt+=delta_dates;
		odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),23,59,59);
		odt_new_end=odt; 
		aplDate2String(odt,buf);
		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_date_planned_end,buf);
	}
	

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_date_planned_end2,buf);
	if(buf!=_T(""))
	{
		aplString2Date(buf,odt);
		odt+=delta_dates;
		odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),23,59,59);
		aplDate2String(odt,buf);
		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_date_planned_end2,buf);
	}

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_date_planned_duration,d);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_date_planned_duration,d);

	if( (odt_new_start.GetStatus()!=COleDateTime::null) && (odt_new_end.GetStatus()!=COleDateTime::null) )
	{
		COleDateTimeSpan sec(0,0,0,1);
		COleDateTimeSpan dtspan=sec + odt_new_end - odt_new_start;
		double duration=dtspan.GetTotalHours()/24;

		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_date_planned_duration, duration);
	}

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_date_set_mask,i);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_date_set_mask,i);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_type,inst);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_type,inst);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_control_type,buf);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_control_type,buf);


	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_prd_amount_planned,d);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_prd_amount_planned,d);


	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_prd_amount_unit,inst);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_prd_amount_unit,inst);


	bool b;

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_calc_by_amount,b);
	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_calc_by_amount,b);

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_labor_useness,inst);
	if(inst!=0)
	{
		CaplInstance *inst1=m_api->m_data.CreateInstance(m_prj_mgr->e_labor_useness_value);
		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_labor_useness,inst1);

		CaplInstance *inst2;
		m_api->m_data.GetAttr(inst,m_prj_mgr->a_labor_unit,inst2);
		m_api->m_data.PutAttr(inst1,m_prj_mgr->a_labor_unit,inst2);

		m_api->m_data.GetAttr(inst,m_prj_mgr->a_labor_value,d);
		m_api->m_data.PutAttr(inst1,m_prj_mgr->a_labor_value,d);

	}

	m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_labor_of_item,inst);
	if(inst!=0)
	{
		CaplInstance *inst1=m_api->m_data.CreateInstance(m_prj_mgr->e_labor_useness_value);
		m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_labor_of_item,inst1);

		CaplInstance *inst2;
		m_api->m_data.GetAttr(inst,m_prj_mgr->a_labor_unit,inst2);
		m_api->m_data.PutAttr(inst1,m_prj_mgr->a_labor_unit,inst2);

		m_api->m_data.GetAttr(inst,m_prj_mgr->a_labor_value,d);
		m_api->m_data.PutAttr(inst1,m_prj_mgr->a_labor_value,d);

	}

	CaplAggr tmpAggr;
	if(b_copy_executors)
	{
		m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_executors,tmpAggr);
		if(tmpAggr.GetSize()>0)	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_executors,tmpAggr);
	}

	if(b_copy_coexecutors)
	{
		m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_co_executors,tmpAggr);
		if(tmpAggr.GetSize()>0)	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_co_executors,tmpAggr);
	}

	if(b_copy_cocustomers)
	{
		m_api->m_data.GetAttr(src_prj,m_prj_mgr->a_project_co_customers,tmpAggr);
		if(tmpAggr.GetSize()>0)	m_api->m_data.PutAttr(new_prj,m_prj_mgr->a_project_co_customers,tmpAggr);
	}

	if(b_copy_kurator)
	{
		CaplInstance *kurator;
		m_api->m_data.GetAttr(src_prj, m_prj_mgr->a_project_kurator, kurator);
		if(0!=kurator)	m_api->m_data.PutAttr(new_prj, m_prj_mgr->a_project_kurator, kurator);
	}

	if(b_copy_customer)
	{
		CaplInstance *customer;
		m_api->m_data.GetAttr(src_prj, m_prj_mgr->a_project_customer, customer);
		if(0!=customer)	m_api->m_data.PutAttr(new_prj, m_prj_mgr->a_project_customer, customer);
	}

	return new_prj;
}



bool CCreatePrjCopyDlg::CreateDocCopy(CaplInstance *old_prj, CaplInstance *new_prj, LPCTSTR src_str, LPCTSTR dst_str)
{
	if(0==old_prj) return false;
	if(0==new_prj) return false;

	int i,k;
	CString prj_id,id0,id1,name,descr,fname,path,buf;
	CaplInstance *rel, *doc0, *doc1;
	aplExtent ex_rel, ext_doc;

	CString tmp_path, tmp;
	tmp_path.GetEnvironmentVariable(_T("temp"));
	if(tmp_path.GetLength()==0) tmp_path=_T("c:\\");
	else {if(tmp_path[tmp_path.GetLength()-1]!=_T('\\')) tmp_path+=_T('\\');}

	m_api->m_data.GetAttr(new_prj,m_prj_mgr->a_project_id,prj_id);

	m_api->m_doc_mgr.FindAssociatedDocuments(old_prj,ext_doc,ex_rel);
	for(i=0;i<ex_rel.GetSize(); i++)
	{
		rel=ex_rel[i];
		m_api->m_data.GetAttr(rel,m_api->m_doc_mgr.a_apl_doc_ref_doc,doc0);
		if(0==doc0) continue; 

		m_api->m_data.GetAttr(doc0,m_api->m_doc_mgr.a_doc_id,id0);
		id1=id0;
		id1.Replace(src_str,dst_str);

		doc1=m_api->m_doc_mgr.FindDocById(id1);

		k=0;
		while(doc1!=0)
		{
			id1=prj_id+_T("-")+id0;
			if(k>0)
			{
				buf.Format(_T("-%i"),k);
				id1+=buf;

			}
			k++;
			doc1=m_api->m_doc_mgr.FindDocById(id1);
		}

		m_api->m_data.GetAttr(doc0,m_api->m_doc_mgr.a_doc_name,name);
		m_api->m_data.GetAttr(doc0,m_api->m_doc_mgr.a_doc_descr,descr);
		CaplInstance *dt;
		m_api->m_data.GetAttr(doc0,m_api->m_doc_mgr.a_doc_kind,dt);

		m_api->m_doc_mgr.GetFileName(doc0, fname);
		path=tmp_path+fname;
		::SetFileAttributes(path, FILE_ATTRIBUTE_NORMAL);
		::DeleteFile(path);
		if(m_api->m_doc_mgr.LoadRevision(doc0, tmp_path,false,false))
		{
			doc1=doc1=m_api->m_doc_mgr.CreateDocument(id1,name,descr,dt,path,true,new_prj);
		}
		::SetFileAttributes(path, FILE_ATTRIBUTE_NORMAL);
		::DeleteFile(path);
	}
	return true;
}

