// FilterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FilterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilterDlg dialog


CFilterDlg::CFilterDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CFilterDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilterDlg)
	//}}AFX_DATA_INIT
	m_states_ctrl.SetUniqueName(_T("CFilter_dlg"));
	m_types_ctrl.SetUniqueName(_T("CFilter_dlg1"));
	m_filter=0;
	m_filter_type=0;
	m_api=0;
	m_project_mgr=0;
	m_kurator=0;
	m_executor=0;
	m_customer=0;
	bMonitorMode=false;
}


void CFilterDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilterDlg)
	DDX_Control(pDX, IDC_DATE_PLANNED_END, m_date_planned_end_ctrl);
	DDX_Control(pDX, IDC_DATE_PLANNED_BEGIN, m_date_planned_begin_ctrl);
	DDX_Control(pDX, IDC_DATE_ACTUAL_END, m_date_actual_end_ctrl);
	DDX_Control(pDX, IDC_DATE_ACTUAL_BEGIN, m_date_actual_begin_ctrl);
	DDX_Control(pDX, IDC_CHECK_DATE_PLANNED_END, m_check_date_planned_end_ctrl);
	DDX_Control(pDX, IDC_SHOW_OUT_OF_TIME, m_check_out_of_time_ctrl);
	DDX_Control(pDX, IDC_CHECK_DATE_PLANNED_BEGIN, m_check_date_planned_begin_ctrl);
	DDX_Control(pDX, IDC_CHECK_DATE_ACTUAL_END, m_check_date_actual_end_ctrl);
	DDX_Control(pDX, IDC_CHECK_DATE_ACTUAL_BEGIN, m_check_date_actual_begin_ctrl);
	DDX_Control(pDX, IDC_CUSTOMER_BTN, m_customer_btn);
	DDX_Control(pDX, IDC_CUSTOMER, m_customer_ctrl);
	DDX_Control(pDX, IDC_KURATOR_BTN, m_kurator_btn);
	DDX_Control(pDX, IDC_KURATOR, m_kurator_ctrl);
	DDX_Control(pDX, IDC_EXECUTOR_BTN, m_executor_btn);
	DDX_Control(pDX, IDC_EXECUTOR, m_executor_ctrl);
	DDX_Control(pDX, IDC_CHECK_CUSTOMER, m_check_customer_ctrl);
	DDX_Control(pDX, IDC_CHECK_KURATOR, m_check_kurator_ctrl);
	DDX_Control(pDX, IDC_CHECK_EXECUTOR, m_check_executor_ctrl);
	DDX_Control(pDX, IDC_ALL_TYPES, m_all_types_ctrl);
	DDX_Control(pDX, IDC_TYPE_BORDER, m_type_border_ctrl);
	DDX_Control(pDX, IDC_ALL_STATES, m_all_states_ctrl);
	DDX_Control(pDX, IDC_BORDER, m_border_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_NUMBER, m_number_ctrl);
	DDX_Control(pDX, IDC_PRJ_ID, m_prj_id_ctrl);
	DDX_Control(pDX, IDC_PRJ_NAME, m_prj_name_ctrl);
	DDX_Control(pDX, IDC_FILTER_TYPE, m_filter_type_ctrl);
}


BEGIN_MESSAGE_MAP(CFilterDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CFilterDlg)
	ON_BN_CLICKED(IDC_ALL_STATES, OnAllStates)
	ON_BN_CLICKED(IDC_ALL_TYPES, OnAllTypes)
	ON_BN_CLICKED(IDC_CUSTOMER_BTN, OnCustomerBtn)
	ON_BN_CLICKED(IDC_KURATOR_BTN, OnKuratorBtn)
	ON_BN_CLICKED(IDC_EXECUTOR_BTN, OnExecutorBtn)
	ON_BN_CLICKED(IDC_CHECK_CUSTOMER, OnCheckCustomer)
	ON_BN_CLICKED(IDC_CHECK_KURATOR, OnCheckKurator)
	ON_BN_CLICKED(IDC_CHECK_EXECUTOR, OnCheckExecutor)
	ON_BN_CLICKED(IDC_CHECK_DATE_PLANNED_BEGIN, OnCheckDatePlannedBegin)
	ON_BN_CLICKED(IDC_CHECK_DATE_PLANNED_END, OnCheckDatePlannedEnd)
	ON_BN_CLICKED(IDC_CHECK_DATE_ACTUAL_BEGIN, OnCheckDateActualBegin)
	ON_BN_CLICKED(IDC_CHECK_DATE_ACTUAL_END, OnCheckDateActualEnd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterDlg message handlers

BOOL CFilterDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	RECT rect={5,5,10,10};
	
	m_states_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDS_STATES);
	
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_states_ctrl.MoveWindow(&rect);

	ListView_SetExtendedListViewStyle(m_states_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_states_ctrl.m_hWnd)
			|LVS_EX_CHECKBOXES |LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	m_states_ctrl.InsertColumn(0,_T(""),LVCFMT_LEFT,20);	
	m_states_ctrl.InsertColumn(1,APL_T(""),LVCFMT_LEFT,80);	

	RECT rect1={100,100,200,200};
	m_types_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect1,this,IDS_TYPES);

	m_type_border_ctrl.GetWindowRect(&rect1);
	ScreenToClient(&rect1);
	m_types_ctrl.MoveWindow(&rect1);

	ListView_SetExtendedListViewStyle(m_types_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_types_ctrl.m_hWnd)
			|LVS_EX_CHECKBOXES |LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	m_types_ctrl.InsertColumn(0,_T(""),LVCFMT_LEFT,20);	
	m_types_ctrl.InsertColumn(1,APL_T(" "),LVCFMT_LEFT,80);	

	int k;
	k=m_filter_type_ctrl.AddString(APL_T("   "));
	m_filter_type_ctrl.SetItemData(k,APL_FILTER_ALL);
	k=m_filter_type_ctrl.AddString(APL_T("    "));
	m_filter_type_ctrl.SetItemData(k,APL_FILTER_ALL_EXPANDING);
	k=m_filter_type_ctrl.AddString(APL_T("  ''   "));
	m_filter_type_ctrl.SetItemData(k,APL_FILTER_ELEMENTS_EXPANDING);
	k=m_filter_type_ctrl.AddString(APL_T("    "));
	m_filter_type_ctrl.SetItemData(k,APL_FILTER_TO_ROOT);

	if(0!=m_api)
	{
		if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T(""))) 
		{
			//   -  
			k=m_filter_type_ctrl.AddString(APL_NO_T("   ()"));
			m_filter_type_ctrl.SetItemData(k,APL_RECURS_TO_ROOT_ALL);
		}
	}

	m_filter_type_ctrl.SetCurSel(0);
	m_filter_type=0;


	// TODO: Add extra initialization here
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	SetFilters();
	SetFiltersValues();


	if(bMonitorMode)
	{
		m_filter_type_ctrl.EnableWindow(FALSE);
	}


	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFilterDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData();
	CString buf;
	COleDateTime dt,d_time;
	CString date_planned_begin=_T("");
	CString date_planned_end=_T("");
	CString date_actual_begin=_T("");
	CString date_actual_end=_T("");

	bool validate=true;
	if(m_check_date_planned_begin_ctrl.GetCheck()==1)
	{
		m_date_planned_begin_ctrl.GetTime(d_time);	
		dt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
			0,0,0);
		aplDate2String(dt,date_planned_begin);
	}
	else
		validate=false;
	if(m_check_date_planned_end_ctrl.GetCheck()==1)
	{
		m_date_planned_end_ctrl.GetTime(d_time);	
		dt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
			0,0,0);
		aplDate2String(dt,date_planned_end);
	}
	else
		validate=false;
	if(validate && date_planned_end<date_planned_begin)
	{
		AfxMessageBox(APL_T("   >  !"));
		return;
	}
	validate=true;
	if(m_check_date_actual_begin_ctrl.GetCheck()==1)
	{
		m_date_actual_begin_ctrl.GetTime(d_time);	
		dt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
			0,0,0);
		aplDate2String(dt,date_actual_begin);
	}
	else
		validate=false;
	if(m_check_date_actual_end_ctrl.GetCheck()==1)
	{
		m_date_actual_end_ctrl.GetTime(d_time);	
		dt.SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),
			0,0,0);
		aplDate2String(dt,date_actual_end);
	}
	else
		validate=false;
	if(validate && date_actual_end<date_actual_begin)
	{
		AfxMessageBox(APL_T("   >  !"));
		return;
	}
	m_filter->m_date_planned_begin=date_planned_begin;
	m_filter->m_date_planned_end=date_planned_end;
	m_filter->m_date_actual_begin=date_actual_begin;
	m_filter->m_date_actual_end=date_actual_end;	

	//
	m_filter->m_states.RemoveAll();
	if(m_all_states_ctrl.GetCheck()==0)
	{
		for(int i=0;i<m_states_ctrl.GetItemCount();i++)
		{
			if(m_states_ctrl.GetCheck(i))
			{
				buf=m_states_ctrl.GetItemText(i,1);
				m_filter->m_states.Add(buf);
			}
		}
		if(!m_filter->m_states.GetSize()) AfxMessageBox(APL_T("     .    !"));
		
	}
	// 
	CaplInstance *type;
	m_filter->m_types.Clear();
	if(m_all_types_ctrl.GetCheck()==0)
	{
		for(int i=0;i<m_types_ctrl.GetItemCount();i++)
		{
			if(m_types_ctrl.GetCheck(i))
			{
				type=(CaplInstance*)m_types_ctrl.GetItemData(i);
				m_filter->m_types.Add(type);
			}
		}
		if(!m_filter->m_types.GetSize()) AfxMessageBox(APL_T("     .    !"));
		
	}

	m_number_ctrl.GetWindowText(m_filter->m_number);
	m_prj_id_ctrl.GetWindowText(m_filter->m_id);
	m_prj_name_ctrl.GetWindowText(m_filter->m_name);
	

	m_filter->m_customer=m_customer;
	m_filter->m_kurator=m_kurator;
	m_filter->m_executor=m_executor;
	if(m_check_customer_ctrl.GetCheck()==1) m_filter->m_filter_by_customer=true;
	else m_filter->m_filter_by_customer=false;
	if(m_check_kurator_ctrl.GetCheck()==1) m_filter->m_filter_by_kurator=true;
	else m_filter->m_filter_by_kurator=false;
	if(m_check_executor_ctrl.GetCheck()==1) m_filter->m_filter_by_executor=true;
	else m_filter->m_filter_by_executor=false;
	if(m_check_out_of_time_ctrl.GetCheck()==1) m_filter->m_filter_out_of_time=true;
	else m_filter->m_filter_out_of_time=false;


	int i=m_filter_type_ctrl.GetCurSel();
	if(i<0)	m_filter_type=-1;
	else m_filter_type=(long)m_filter_type_ctrl.GetItemData(i);

	m_filter->m_filter_type=m_filter_type;

	m_filter->m_bEnabled=true;

	CaplResizableDialog::OnOK();
}

void CFilterDlg::SetFilters()
{
	//
	int num;
	num=m_states_ctrl.InsertItem(0,_T(""));
	m_states_ctrl.SetItemText(num,1,APL_T(""));
	num=m_states_ctrl.InsertItem(1,_T(""));
	m_states_ctrl.SetItemText(num,1,APL_T(" "));
	num=m_states_ctrl.InsertItem(2,_T(""));
	m_states_ctrl.SetItemText(num,1,APL_T(""));
	num=m_states_ctrl.InsertItem(3,_T(""));
	m_states_ctrl.SetItemText(num,1,APL_T(""));
	num=m_states_ctrl.InsertItem(4,_T(""));
	m_states_ctrl.SetItemText(num,1,APL_T(""));

	//  
	aplExtent ext;
	CString buf=_T("");
	num=m_types_ctrl.InsertItem(0,_T(""));
	m_types_ctrl.SetItemText(num,1,APL_T(" "));
	m_types_ctrl.SetItemData(num,0);
	m_api->m_data.GetEntityExtent(m_project_mgr->e_project_type,ext);
	for(int i=0;i<ext.Size;i++)
	{
		m_api->m_data.GetAttr(ext[i],m_project_mgr->a_project_type_name,buf);
		num=m_types_ctrl.InsertItem(i+1,_T(""));
		m_types_ctrl.SetItemText(num,1,buf);
		m_types_ctrl.SetItemData(num,(long)ext[i]);
	}
}

void CFilterDlg::SetFiltersValues()
{
	CString buf;
	int i,j;
	//
	if(!m_filter->m_states.GetSize())
	{
		m_all_states_ctrl.SetCheck(1);
		m_states_ctrl.EnableWindow(FALSE);
	}
	else
	{
		for(j=0;j<m_states_ctrl.GetItemCount();j++)
		{
			buf=m_states_ctrl.GetItemText(j,1);
			for(i=0;i<m_filter->m_states.GetSize();i++)
			{
				if(buf==m_filter->m_states[i]) {m_states_ctrl.SetCheck(j,true);break;}
			}
		}
	}
	m_states_ctrl.AutoSizeColumn(1);
	//  
	CaplInstance *type;
	if(!m_filter->m_types.GetSize())
	{
		m_all_types_ctrl.SetCheck(1);
		m_types_ctrl.EnableWindow(FALSE);
	}
	else
	{
		for(j=0;j<m_types_ctrl.GetItemCount();j++)
		{
			type=(CaplInstance*)m_types_ctrl.GetItemData(j);
			for(i=0;i<m_filter->m_types.GetSize();i++)
			{
				if(type==m_filter->m_types[i]) {m_types_ctrl.SetCheck(j,true);break;}
			}
		}
	}
	m_types_ctrl.AutoSizeColumn(1);
	//
	if(m_filter->m_customer) 
	{
		m_customer=m_filter->m_customer;
		m_check_customer_ctrl.SetCheck(1);
		if(m_api->m_data.IsKindOf(m_customer, m_api->m_appr_mgr.e_person)) m_api->m_appr_mgr.GetPersonName(m_customer,buf);
		else if(m_api->m_data.IsKindOf(m_customer, m_api->m_appr_mgr.e_org)) m_api->m_data.GetAttr(m_customer,m_api->m_appr_mgr.a_org_name,buf); 
		m_customer_ctrl.SetWindowText(buf);
	}
	if(m_filter->m_filter_by_customer)
		m_check_customer_ctrl.SetCheck(1);
	else
		m_customer_btn.EnableWindow(FALSE);
	//.
	if(m_filter->m_kurator) 
	{
		m_kurator=m_filter->m_kurator;
		m_check_kurator_ctrl.SetCheck(1);
		m_api->m_appr_mgr.GetItemName(m_kurator,buf);
		m_kurator_ctrl.SetWindowText(buf);
	}
	if(m_filter->m_filter_by_kurator)
		m_check_kurator_ctrl.SetCheck(1);
	else
		m_kurator_btn.EnableWindow(FALSE);

	m_number_ctrl.SetWindowText(m_filter->m_number);
	m_prj_id_ctrl.SetWindowText(m_filter->m_id);
	m_prj_name_ctrl.SetWindowText(m_filter->m_name);
	
	//
	if(m_filter->m_executor) 
	{
		m_executor=m_filter->m_executor;
		m_check_executor_ctrl.SetCheck(1);
		m_api->m_appr_mgr.GetItemName(m_executor,buf);
		m_executor_ctrl.SetWindowText(buf);
	}
	if(m_filter->m_filter_by_executor)
		m_check_executor_ctrl.SetCheck(1);
	else
		m_executor_btn.EnableWindow(FALSE);

	//   
	if(m_filter->m_filter_out_of_time)
		m_check_out_of_time_ctrl.SetCheck(1);
	else
		m_check_out_of_time_ctrl.SetCheck(0);

	// 
	COleDateTime dt;
	
	if(m_filter->m_date_planned_begin!=_T(""))
	{
		aplString2Date(m_filter->m_date_planned_begin,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			m_check_date_planned_begin_ctrl.SetCheck(1);
			m_date_planned_begin_ctrl.SetTime(dt);
		}
	}
	else
	{
		m_date_planned_begin_ctrl.EnableWindow(FALSE);
	}
		if(m_filter->m_date_planned_end!=_T(""))
	{
		aplString2Date(m_filter->m_date_planned_end,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			m_check_date_planned_end_ctrl.SetCheck(1);
			m_date_planned_end_ctrl.SetTime(dt);
		}
	}
	else
	{
		m_date_planned_end_ctrl.EnableWindow(FALSE);
	}
	// 
	
	if(m_filter->m_date_actual_begin!=_T(""))
	{
		aplString2Date(m_filter->m_date_actual_begin,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			m_check_date_actual_begin_ctrl.SetCheck(1);
			m_date_actual_begin_ctrl.SetTime(dt);
		}
	}
	else
	{
		m_date_actual_begin_ctrl.EnableWindow(FALSE);
	}
	if(m_filter->m_date_actual_end!=_T(""))
	{
		aplString2Date(m_filter->m_date_actual_end,dt);
		if(dt.GetStatus()==COleDateTime::valid)
		{
			m_check_date_actual_end_ctrl.SetCheck(1);
			m_date_actual_end_ctrl.SetTime(dt);
		}
	}
	else
	{
		m_date_actual_end_ctrl.EnableWindow(FALSE);
	}

	
	//m_filter_type=(int)m_filter->m_filter_type;
	for(i=0; i<m_filter_type_ctrl.GetCount();i++)
	{
		if(m_filter_type_ctrl.GetItemData(i)==(DWORD)m_filter->m_filter_type)
		{
			m_filter_type_ctrl.SetCurSel(i);
			break;
		}
	}
}

void CFilterDlg::OnAllStates() 
{
	if(m_all_states_ctrl.GetCheck()==1)
	{
		for(int i=0;i<m_states_ctrl.GetItemCount();i++) m_states_ctrl.SetCheck(i,FALSE);
		m_states_ctrl.EnableWindow(FALSE);
	}
	else m_states_ctrl.EnableWindow(TRUE);	
}

void CFilterDlg::OnAllTypes() 
{
	if(m_all_types_ctrl.GetCheck()==1)
	{
		for(int i=0;i<m_types_ctrl.GetItemCount();i++) m_types_ctrl.SetCheck(i,FALSE);
		m_types_ctrl.EnableWindow(FALSE);
	}
	else m_types_ctrl.EnableWindow(TRUE);	
	
}

void CFilterDlg::OnCustomerBtn() 
{
	// TODO: Add your control notification handler code here
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_ORG|APL_MODE_SELECT_PERSON, ext, APL_T("  "), APL_T("    "));
	if(inst)
	{
		m_customer=inst;
		CString buf;
		if(m_api->m_data.IsKindOf(m_customer, m_api->m_appr_mgr.e_person)) m_api->m_appr_mgr.GetPersonName(m_customer,buf);
		else if(m_api->m_data.IsKindOf(m_customer, m_api->m_appr_mgr.e_org)) m_api->m_data.GetAttr(m_customer,m_api->m_appr_mgr.a_org_name,buf); 
		m_customer_ctrl.SetWindowText(buf);	
	}
}

void CFilterDlg::OnKuratorBtn() 
{
	// TODO: Add your control notification handler code here
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_ORG|APL_MODE_SELECT_PERSON, ext, APL_T(" . "), APL_T(" "));
	if(inst)
	{
		m_kurator=inst;
		CString buf=_T("");
		if(m_api->m_data.IsKindOf(m_kurator, m_api->m_appr_mgr.e_person)) m_api->m_appr_mgr.GetPersonName(m_kurator,buf);
		else if(m_api->m_data.IsKindOf(m_kurator, m_api->m_appr_mgr.e_org)) m_api->m_data.GetAttr(m_kurator,m_api->m_appr_mgr.a_org_name,buf); 
		m_kurator_ctrl.SetWindowText(buf);	
	}
}

void CFilterDlg::OnExecutorBtn() 
{
	// TODO: Add your control notification handler code here
	aplExtent ext;
	CaplInstance *inst=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON, ext, APL_T("  "), APL_T(" "));
	if(inst)
	{
		m_executor=inst;
		CString buf;
		m_api->m_appr_mgr.GetPersonName(m_executor,buf);
		m_executor_ctrl.SetWindowText(buf);	
	}
}

void CFilterDlg::OnCheckCustomer() 
{
	// TODO: Add your control notification handler code here
	if(m_check_customer_ctrl.GetCheck()==1)
	{
		m_customer_btn.EnableWindow(TRUE);
	}
	else
	{
		m_customer_btn.EnableWindow(FALSE);
		m_customer_ctrl.SetWindowText(_T(""));
		m_customer=0;
	}
	
}

void CFilterDlg::OnCheckKurator() 
{
	// TODO: Add your control notification handler code here
	if(m_check_kurator_ctrl.GetCheck()==1)
	{
		m_kurator_btn.EnableWindow(TRUE);
	}
	else
	{
		m_kurator_btn.EnableWindow(FALSE);
		m_kurator_ctrl.SetWindowText(_T(""));
		m_kurator=0;
	}
	
}

void CFilterDlg::OnCheckExecutor() 
{
	// TODO: Add your control notification handler code here
	if(m_check_executor_ctrl.GetCheck()==1)
	{
		m_executor_btn.EnableWindow(TRUE);
	}
	else
	{
		m_executor_btn.EnableWindow(FALSE);
		m_executor_ctrl.SetWindowText(_T(""));
		m_executor=0;
	}
}

void CFilterDlg::OnCheckDatePlannedBegin() 
{
	int check=m_check_date_planned_begin_ctrl.GetCheck();
	if(check==1)
	{
		m_date_planned_begin_ctrl.EnableWindow(true);
	}
	else if(check==0)
	{
		m_date_planned_begin_ctrl.EnableWindow(false);
	}
}

void CFilterDlg::OnCheckDatePlannedEnd() 
{
	int check=m_check_date_planned_end_ctrl.GetCheck();
	if(check==1)
	{
		m_date_planned_end_ctrl.EnableWindow(true);
	}
	else if(check==0)
	{
		m_date_planned_end_ctrl.EnableWindow(false);
	}	
}

void CFilterDlg::OnCheckDateActualBegin() 
{
	int check=m_check_date_actual_begin_ctrl.GetCheck();
	if(check==1)
	{
		m_date_actual_begin_ctrl.EnableWindow(true);
	}
	else if(check==0)
	{
		m_date_actual_begin_ctrl.EnableWindow(false);
	}	
}

void CFilterDlg::OnCheckDateActualEnd() 
{
	int check=m_check_date_actual_end_ctrl.GetCheck();
	if(check==1)
	{
		m_date_actual_end_ctrl.EnableWindow(true);
	}
	else if(check==0)
	{
		m_date_actual_end_ctrl.EnableWindow(false);
	}
}
