#if !defined(AFX_SHOWGANTTDLG_H__A9DCFD78_BECE_4E09_B1EA_2CBFB55339EF__INCLUDED_)
#define AFX_SHOWGANTTDLG_H__A9DCFD78_BECE_4E09_B1EA_2CBFB55339EF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ShowGanttDlg.h : header file
//
#include "resource.h"
#include "apl_api.h"
#include "aplProjectMgr.h"
#include <apl_gui.h>
#include "GanttView.h"
#include "GanttCtrl.h"
#include "FilterDlg.h"
#include "SetupDlg.h"
#include "SetupStruct.h"
#include "afxwin.h"
/////////////////////////////////////////////////////////////////////////////
// CShowGanttDlg dialog

class CShowGanttDlg : public CaplResizableDialog
{
// Construction
public:
	
	void Sort(int nCol);
	CShowGanttDlg(CWnd* pParent = NULL);   // standard constructor
	~CShowGanttDlg();
	CaplAPI *m_api;
	CaplProjectManager *m_project_mgr;
	aplExtent m_projects;
	//CaplInstance *m_project;
	//CaplInstance *m_folder;
	CaplInstance *m_project_folder;//,       (    )
	CaplInstance *m_cur_person;
	CaplTreeListCtrlView *m_tree_view;
	CGanttView *m_gantt_view;
	CaplSplitterBar *m_splitter;

	static CFilterStruct m_filter;
	CSetupStruct m_setup;

	bool m_bNoUpdaetGantt; //   

	bool FindItem(CaplInstance *project,HTREEITEM &hItem,HTREEITEM hParentItem=NULL);

	void ReloadItemInfo(CGanttItem *item);
	void RemoveSubItems(HTREEITEM hitem);

	bool m_bAutoExpand; //  " "   
	CaplInstance *m_prj4select; //     

	
//	CPDMProjectsDlg(CWnd* pParent = NULL);   // standard constructor
//	bool Expand(UINT action);
	bool Expand(HTREEITEM hItem,UINT action);
	void ExpandItem(HTREEITEM hItem,UINT action);
	void LbDblClick(UINT nFlags, CPoint point);//   2     
	void AddProjects(CaplInstance *parent,HTREEITEM hParent=NULL);
	void UpdateProjectsList();
	void CreateTreeItem(CaplInstance *project,HTREEITEM hParent=NULL,const char *id=0,const char *type=0);
	void RefreshAllItems();
	void RefreshItems(HTREEITEM hItem);
	bool ShowProperties(CaplInstance *project);
	/*  
	  @param   
		  APL_MODE_OPEN -   
  		  APL_MODE_EDIT -  
		  APL_MODE_PRINT -     */
	void ExportTable(long mode);
	void InsertSubProjects(aplExtent &ext_top);
	void RefreshItem(HTREEITEM hItem);
	void RefreshParentItems(HTREEITEM hItem);
	void UpdateGanttView(bool bUpdateCalendar,bool renum=false);	
	bool Expanded(HTREEITEM hItem,UINT action, HWND hWnd);
	bool PointToVal(CPoint *point, int &i,HTREEITEM &hItem,CaplInstance **inst);
	void UpdateUserData();
	void RefreshColumnsList();
	void GetAllTreeItems(HTREEITEM hItem);

	bool m_bShowFromMonitor;

	bool SaveViewOption();
	bool LoadViewOption();

	
// Dialog Data
	//{{AFX_DATA(CShowGanttDlg)
	enum { IDD = IDD_SHOWGANTTDLG_DIALOG };
	CComboBox	m_view_mode_ctrl;
	CaplButton	m_zoomout_btn;
	CaplButton	m_zoomin_btn;
	CaplButton	m_ok_btn;
	CStatic	m_gantt_border_ctrl;
	CStatic	m_tree_border_ctrl;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CShowGanttDlg)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	// Generated message map functions
	//{{AFX_MSG(CShowGanttDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnZoomin();
	afx_msg void OnZoomout();
	afx_msg void OnSplitterMoved();
	afx_msg void OnFilterBtn();
	afx_msg void OnExpandAll();
	afx_msg void OnPrint();
	afx_msg void OnExport();
	afx_msg void OnExportCSV();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSetup();
	afx_msg void OnSelChanged();
	afx_msg void OnSelchangeViewMode();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedShowColorLegend();
	CaplButton m_show_color_legend_btn;
	CaplButton m_find_btn;
	CaplButton m_print_btn;
	CaplButton m_setup_btn;
	CaplButton m_exp2html_btn;
	CaplButton m_exp2csv_btn;
protected:
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
public:
	CButton m_ShowPrognozBtn;
	afx_msg void OnBnClickedShowPrognoz();
	afx_msg void OnBnClickedFindintable();
	CaplButton m_find_in_table_btn;
	afx_msg void OnBnClickedShowRelation();
	CButton m_ShowRelationBtn;
	afx_msg void OnBnClickedShowFact();
	CButton m_ShowFactBtn;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SHOWGANTTDLG_H__A9DCFD78_BECE_4E09_B1EA_2CBFB55339EF__INCLUDED_)
