// TransactionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TransactionDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTransactionDlg dialog


CTransactionDlg::CTransactionDlg(CaplProjectManager	*pProjectMgr, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CTransactionDlg::IDD, pParent)
{
	ASSERT(pProjectMgr);
	m_pProjectMgr = pProjectMgr;
	m_api = pProjectMgr->m_api;
	
	//{{AFX_DATA_INIT(CTransactionDlg)
	m_Date = COleDateTime::GetCurrentTime();
	m_sDescr = _T("");
	m_sId = _T("");
	m_sName = _T("");
	m_dSumm = 0.0;
	m_dNDS = 0.0;
	//}}AFX_DATA_INIT

	m_inst = NULL;
	m_base_inst=0;
}


void CTransactionDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTransactionDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_TYPE, m_TypeCtrl);
	DDX_DateTimeCtrl(pDX, IDC_DATE, m_Date);
	DDX_Text(pDX, IDC_DESCR, m_sDescr);
	DDX_Text(pDX, IDC_ID, m_sId);
	DDX_Text(pDX, IDC_NAME, m_sName);
	DDX_Text(pDX, IDC_SUMM, m_dSumm);
	DDX_Text(pDX, IDC_NDS, m_dNDS);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_NDS, m_nds_ctrl);
	DDX_Control(pDX, IDC_NDS_PROC, m_nds_proc_ctrl);
	DDX_Control(pDX, IDC_SUMM, m_sum_ctrl);
}


BEGIN_MESSAGE_MAP(CTransactionDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CTransactionDlg)
	//}}AFX_MSG_MAP
	ON_EN_CHANGE(IDC_NDS, &CTransactionDlg::OnEnChangeNds)
	ON_EN_CHANGE(IDC_SUMM, &CTransactionDlg::OnEnChangeSumm)
//	ON_EN_SETFOCUS(IDC_SUMM, &CTransactionDlg::OnEnSetfocusSumm)
ON_EN_KILLFOCUS(IDC_NDS, &CTransactionDlg::OnEnKillfocusNds)
ON_EN_KILLFOCUS(IDC_SUMM, &CTransactionDlg::OnEnKillfocusSumm)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTransactionDlg message handlers

void CTransactionDlg::SetRO()
{
	((CEdit*)GetDlgItem(IDC_ID))->SetReadOnly(TRUE);
	//((CEdit*)GetDlgItem(IDC_NAME))->SetReadOnly(TRUE);
	GetDlgItem(IDC_NAME)->EnableWindow(FALSE);
	((CEdit*)GetDlgItem(IDC_NAME))->SetReadOnly(TRUE);
	((CEdit*)GetDlgItem(IDC_DESCR))->SetReadOnly(TRUE);
	((CEdit*)GetDlgItem(IDC_SUMM))->SetReadOnly(TRUE);
	((CEdit*)GetDlgItem(IDC_NDS))->SetReadOnly(TRUE);
	GetDlgItem(IDC_TYPE)->EnableWindow(FALSE);
	GetDlgItem(IDC_DATE)->EnableWindow(FALSE);
	m_ok_btn.EnableWindow(FALSE);
}

BOOL CTransactionDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if(0==m_project) return false;
	if(m_project->GetAccessmode()>aplRO) return FALSE;

	if(m_api->m_data.IsKindOf(m_project,m_pProjectMgr->e_project_adm_ver))
	{
		m_api->m_data.GetAttr(m_project, m_pProjectMgr->a_project_adm_ver_project, m_project);
		if(m_project==NULL) return FALSE;
		if(m_project->GetAccessmode()>aplRO) return FALSE;
	}

	/*
	if(m_role_to_edit_fact==_T("")  && m_project->GetAccessmode()>aplRW)
	{
	}*/
	
	int i;
	for(i=0; i<m_pProjectMgr->m_saMoneyTransactionTypes.GetSize(); i++)
		m_TypeCtrl.AddString(m_pProjectMgr->m_saMoneyTransactionTypes[i]);
	
	m_TypeCtrl.SetCurSel(0);

	CString sType;
	if(m_inst)
	{
		CString sDate;
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_id, m_sId);
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_name, m_sName);
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_descr, m_sDescr);
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_type, sType);
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_summ, m_dSumm);
		m_api->m_data.GetAttr(m_inst, m_pProjectMgr->a_money_transaction_nds, m_dNDS);
		aplString2Date(sDate, m_Date);

		m_TypeCtrl.SelectString(0,sType);

		if( m_pProjectMgr->m_role_to_edit_fact==_T(""))
		{
			if( m_project->GetAccessmode()>aplRW) SetRO();
		}
		else
		{
			if(sType==APL_T(""))
			{
				if(! m_pProjectMgr->m_has_role_edit_fact) SetRO();
			}
			else 
			{
				if( m_project->GetAccessmode()>aplRW) SetRO();
			}
		}
	}
	else if(m_base_inst)
	{
		CString sDate;
		m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_id, m_sId);
		m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_name, m_sName);
		m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_descr, m_sDescr);
		m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_type, sType);
		if(sType==APL_T("")) sType=APL_T("");
		//m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_summ, m_dSumm);
		m_api->m_data.GetAttr(m_base_inst, m_pProjectMgr->a_money_transaction_nds, m_dNDS);
		//aplString2Date(sDate, m_Date);
		m_Date=COleDateTime::GetCurrentTime();

		m_TypeCtrl.SelectString(0,sType);
	}
	else 
	{
		if(m_pProjectMgr->m_has_role_edit_fact) sType=APL_T("");
	}

	UpdateData(FALSE);

	m_TypeCtrl.SetWindowText(sType);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTransactionDlg::OnOK() 
{
	if(!UpdateData()) return;

	/*if(m_sId.IsEmpty())
	{
		AfxMessageBox(APL_T("  ID !"));
		return;
	}*/

	CString sType;
	m_TypeCtrl.GetWindowText(sType);

	if(0 == m_project)
	{
		AfxMessageBox(APL_T("     .   ."), MB_ICONSTOP);
		return;
	}


	//  
	if(m_pProjectMgr->m_role_to_edit_fact!=_T(""))
	{
		if(sType==APL_T(""))
		{
			if(!m_pProjectMgr->m_has_role_edit_fact)
			{
				AfxMessageBox(APL_T("        !"),MB_OK|MB_ICONSTOP);
				return;
			}
		}
		else
		{
			if( m_project->GetAccessmode()>aplRW)
			{
				AfxMessageBox(APL_T("      !"),MB_OK|MB_ICONSTOP);
				return;
			}
		}
	}
	else
	{
		if( m_project->GetAccessmode()>aplRW)
		{
			AfxMessageBox(APL_T("      !"),MB_OK|MB_ICONSTOP);
			return;
		}
	}
	

	if(m_inst==NULL)
	{
		m_inst = m_pProjectMgr->CreateTransaction(m_project, m_sId, m_sName, m_sDescr, m_Date, sType, m_dSumm);
		if(m_inst==NULL) return;
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_nds, m_dNDS);
	}
	else
	{
		CString sDate;
		aplDate2String(m_Date, sDate);

		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_id, m_sId);
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_name, m_sName);
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_descr, m_sDescr);
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_type, sType);
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_date, sDate);
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_summ, m_dSumm);
		m_api->m_data.PutAttr(m_inst, m_pProjectMgr->a_money_transaction_nds, m_dNDS);
	}
	
	CaplTranslateDialog::OnOK();
}


void CTransactionDlg::OnChangeSum(CEdit *ctrl)
{
	static bool bExecuting=false;
	if(bExecuting) return;
	bExecuting=true;

//	TRACE(_T("\n:OnChangeSum -1 "));
	CString buf;
	double sum,nds,proc;

	m_sum_ctrl.GetWindowText(buf);
	sum=__atof(buf);

	m_nds_ctrl.GetWindowText(buf);
	nds=__atof(buf);

	if(nds<0)
	{
		AfxMessageBox(APL_T("    >0!  !"),MB_ICONSTOP|MB_OK);
		nds*=-1;
		buf.Format(_T("%7.2f"),nds);
		m_nds_ctrl.SetWindowText(buf);
		//TRACE(_T("\n:OnChangeSum -2 "));
	}

	if(sum==nds && sum!=0)
	{
		AfxMessageBox(APL_T("     !"),MB_ICONSTOP|MB_OK);
		if(ctrl!=0) ctrl->SetWindowText(_T(""));
		m_nds_proc_ctrl.SetWindowText(_T(""));
		return;
	}
	if(sum<0)nds *=-1;

	proc=(nds/(sum-nds))*100;
	buf.Format(_T("%5.2f"),proc);
	m_nds_proc_ctrl.SetWindowText(buf);

	//TRACE(_T("\n:OnChangeSum -3 "));

	bExecuting=false;

}


void CTransactionDlg::OnEnChangeNds()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	//OnChangeSum(&m_nds_ctrl);
	
}

void CTransactionDlg::OnEnChangeSumm()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here

	//OnChangeSum(&m_sum_ctrl);
}


void CTransactionDlg::OnEnKillfocusNds()
{
	// TODO: Add your control notification handler code here
	//TRACE(_T("\n:OnEnKillfocusNds()"));
	OnChangeSum(&m_nds_ctrl);
}

void CTransactionDlg::OnEnKillfocusSumm()
{
	// TODO: Add your control notification handler code here
	//TRACE(_T("\n:OnEnKillfocusSumm()"));
	OnChangeSum(&m_sum_ctrl);
}
