// AddSerialNum.cpp : implementation file
//

#include "stdafx.h"
#include "AddSerialNum.h"
#include "StepData.h"
#include "ManagerEffectivityDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddSerialNum dialog


CAddSerialNum::CAddSerialNum(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CAddSerialNum::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddSerialNum)
	m_start_sn = _T("");
	//}}AFX_DATA_INIT
	m_eff=0;
	m_data=0;
	flag=0;
	m_PrMan=0;
	m_RO=false;
	m_rel=0;
}


void CAddSerialNum::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddSerialNum)
	DDX_Control(pDX, IDC_START_CHECK_SN, m_start_check);
	DDX_Control(pDX, IDC_END_CHECK_SN, m_end_check);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_ADDSERIALTILL, m_stop_sn_ctrl);
	DDX_Control(pDX, IDC_ADDSERIALFROM, m_start_sn_ctrl);
	DDX_Control(pDX, IDC_IDENTADDSERIAL, m_eff_id_ctrl);
	DDX_Text(pDX, IDC_ADDSERIALFROM, m_start_sn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddSerialNum, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CAddSerialNum)
	ON_BN_CLICKED(IDC_START_CHECK_SN, OnStartCheckSn)
	ON_BN_CLICKED(IDC_END_CHECK_SN, OnEndCheckSn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddSerialNum message handlers
void CAddSerialNum::OnOK() 
{
	if(m_data==0) return;
	CString buf;
	CString start_sn=_T(""),end_sn=_T("");
	if(m_start_check.GetCheck()==1) m_start_sn_ctrl.GetWindowText(start_sn);
	if(m_end_check.GetCheck()==1) m_stop_sn_ctrl.GetWindowText(end_sn);
	if((m_start_check.GetCheck()==0 && m_end_check.GetCheck()==0)||
		(start_sn==_T("") && end_sn==_T("")))
	{
		AfxMessageBox( APL_T("  ,    !")); 
		return;	
	}

	if(m_start_check.GetCheck()==1 && m_end_check.GetCheck()==1)
	{
//		if(start_sn>=end_sn)
		if(m_PrMan->funcCompareSN != NULL)
		{
			if (m_PrMan->funcCompareSN(start_sn, end_sn) == 1)
			{
	//			AfxMessageBox("    (/  <= / )!");
				AfxMessageBox( APL_T("    (/  < / )!"));
				return;
			}
		}
	}

	CString pde_id;
	m_eff_id_ctrl.GetWindowText(pde_id);

	/*
	if(pde_id=="")
	{
		AfxMessageBox("  ");
		return;
	}	
	CaplAttrValue tst_values[1];
	tst_values[0].value.Set(LPCTSTR(pde_id));
	tst_values[0].attr=m_PrMan->a_pde_id;
	if(!m_data->NET_TestUniqueAttrValues(m_PrMan->e_pd_eff,0,1,&tst_values[0], false))
	{
		AfxMessageBox("        !!!");return;
	}
	*/

	//      c/
	CString eff_s_sn,eff_e_sn;
	aplExtent ext_eff;
	m_data->GetEntityExtent(m_PrMan->e_sn_eff,ext_eff);
	for(int i=0;i<ext_eff.GetSize();i++)
	{
		if(ext_eff[i]==m_eff) continue;
		CaplInstance *pdr;
		m_data->GetAttr(ext_eff[i],m_PrMan->a_pde_usage,pdr);
		if(pdr!=m_rel) continue;
		bool b_inactive;
		m_data->GetAttr(ext_eff[i],m_PrMan->a_pde_not_active,b_inactive);
		if(b_inactive) continue;
		m_data->GetAttr(ext_eff[i],m_PrMan->a_sn_eff_start,eff_s_sn);
		m_data->GetAttr(ext_eff[i],m_PrMan->a_sn_eff_end,eff_e_sn);
		bool b_error=false;
		if(m_PrMan->funcCompareSN != NULL)
		{
			if(start_sn==_T(""))
			{
	//			if(end_sn>=eff_s_sn) b_error=true;
				if (m_PrMan->funcCompareSN(end_sn, eff_s_sn) != -1)
					b_error = true;
			}
			else if(end_sn==_T(""))
			{
	//			if(start_sn<eff_e_sn || eff_e_sn=="") b_error=true;
				if ((m_PrMan->funcCompareSN(start_sn, eff_e_sn) == -1) || eff_e_sn.IsEmpty())
					b_error = true;
			}
			else
			{
	// 			if(start_sn>eff_s_sn && (start_sn<eff_e_sn || eff_e_sn=="")) 
	// 				b_error=true;
	// 			if(end_sn>eff_s_sn && (end_sn<=eff_e_sn || eff_e_sn=="")) 
	// 				b_error=true;

				if ((m_PrMan->funcCompareSN(start_sn, eff_s_sn) != -1) &&
					((m_PrMan->funcCompareSN(start_sn, eff_e_sn) != 1) || eff_e_sn.IsEmpty()))
					b_error = true;

				if ((m_PrMan->funcCompareSN(end_sn, eff_s_sn) != -1) &&
					((m_PrMan->funcCompareSN(end_sn, eff_e_sn) != 1) || eff_e_sn.IsEmpty()))
					b_error = true;

				if ((m_PrMan->funcCompareSN(start_sn, eff_s_sn) == -1) && (m_PrMan->funcCompareSN(end_sn, eff_s_sn)==1) &&
					((m_PrMan->funcCompareSN(end_sn, eff_e_sn) == 1) || eff_e_sn.IsEmpty()))
					b_error = true;
			}
		}
		if(b_error)
		{
			m_data->GetAttr(ext_eff[i],m_PrMan->a_pde_id,buf);
			if(buf==_T("")) buf= APL_T(" < > ");
			buf= APL_T("        ( '")+buf+_T("')");
			AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
			return;
		}
	}

	if(m_eff==0)
	{//   
		m_eff=m_data->CreateInstance(m_PrMan->e_sn_eff);
		if(m_rel) m_data->PutAttr(m_eff,m_PrMan->a_pde_usage,m_rel);
	}
	m_data->GetAttr(m_eff,m_PrMan->a_pde_id,buf);
	if(buf!=pde_id) m_data->PutAttr(m_eff,m_PrMan->a_pde_id,pde_id);
	m_data->GetAttr(m_eff,m_PrMan->a_sn_eff_start,buf);
	if(buf!=start_sn) m_data->PutAttr(m_eff,m_PrMan->a_sn_eff_start,start_sn);
	m_data->GetAttr(m_eff,m_PrMan->a_sn_eff_start,buf);
	if(buf!=start_sn) m_data->PutAttr(m_eff,m_PrMan->a_sn_eff_start,start_sn);
	m_data->GetAttr(m_eff,m_PrMan->a_sn_eff_end,buf);
	if(buf!=end_sn) m_data->PutAttr(m_eff,m_PrMan->a_sn_eff_end,end_sn);

	CaplTranslateDialog::OnOK();
}

BOOL CAddSerialNum::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	if(m_data==0) return FALSE;
	if (!m_eff)
	{
		m_start_check.SetCheck(1);
		m_start_sn_ctrl.EnableWindow(true);
	}
	else 
	{//   	
		CString buf;
		m_eff_id_ctrl.EnableWindow(false);
		m_data->GetAttr(m_eff,m_PrMan->a_pde_id,buf);
		m_eff_id_ctrl.SetWindowText(buf);
		
		CaplInstance *pdf_ed=0;
		m_data->GetAttr(m_eff,m_PrMan->a_pde_usage,m_rel);
		if(m_rel)
		{
			m_data->GetAttr(m_rel,m_PrMan->a_pdr_r_ted,pdf_ed);
			if(pdf_ed && pdf_ed->GetAccessmode()>=aplRO) m_RO=true;
		}

		m_data->GetAttr(m_eff,m_PrMan->a_sn_eff_start,buf);
		if(buf!=_T(""))
		{
			m_start_check.SetCheck(1);
			m_start_sn_ctrl.EnableWindow(true);
			m_start_sn_ctrl.SetWindowText(buf);
		}

		m_data->GetAttr(m_eff,m_PrMan->a_sn_eff_end,buf);
		if(buf!=_T(""))
		{
			m_end_check.SetCheck(1);
			m_stop_sn_ctrl.EnableWindow(true);
			m_stop_sn_ctrl.SetWindowText(buf);
		}
	}
	if(m_RO)
	{
		m_ok_btn.EnableWindow(false);
		m_start_check.EnableWindow(false);
		m_end_check.EnableWindow(false);
		m_stop_sn_ctrl.SetReadOnly(TRUE);
		m_start_sn_ctrl.SetReadOnly(TRUE);
		m_eff_id_ctrl.SetReadOnly(TRUE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAddSerialNum::OnStartCheckSn() 
{
	if(m_start_check.GetCheck()) 
	{			
		m_start_sn_ctrl.EnableWindow(true);
	}
	else 
	{
		m_start_sn_ctrl.EnableWindow(false);
	}	
	
}

void CAddSerialNum::OnEndCheckSn() 
{
	if(m_end_check.GetCheck()) 
	{			
		m_stop_sn_ctrl.EnableWindow(true);
	}
	else 
	{
		m_stop_sn_ctrl.EnableWindow(false);
	}	
	
}
