// AnalizeGroupInstances.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "apl_api.h"
#include "AnalizeGroupInstances.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAnalizeGroupInstances dialog


CAnalizeGroupInstances::CAnalizeGroupInstances(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CAnalizeGroupInstances::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnalizeGroupInstances)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_combined_table=0;
	m_api = 0;
}


void CAnalizeGroupInstances::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnalizeGroupInstances)
	DDX_Control(pDX, IDC_NAME_COMBINED_TABLE, m_EdtNameCombinedTable);
	DDX_Control(pDX, IDC_BTN_SAVE2DB, m_BtnSave2Db);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_BTN_SELECT, m_BtnSelectData);
	DDX_Control(pDX, IDC_BTN_SAVE2FILE, m_BtnSaveToFile);
	DDX_Control(pDX, ID_SELECT_CHARACTERYSTIC_SET_1, m_BtnSelectChsrscteristic1);
	DDX_Control(pDX, ID_SELECT_COLUMNS_1, m_BtnSelectColumns1);
	DDX_Control(pDX, ID_SELECT_CHARACTERYSTIC_SET_2, m_BtnSelectChsrscteristic2);
	DDX_Control(pDX, ID_SELECT_COLUMNS_2, m_BtnSelectColumns2);
	DDX_Control(pDX, ID_SELECT_CHARACTERYSTIC_SET_3, m_BtnSelectChsrscteristic3);
	DDX_Control(pDX, ID_SELECT_COLUMNS_3, m_BtnSelectColumns3);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAnalizeGroupInstances, CaplResizableDialog)
	//{{AFX_MSG_MAP(CAnalizeGroupInstances)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_OBJECTS_STATIC, OnRclickListObjects)
	ON_BN_CLICKED(ID_SELECT_COLUMNS_2, OnSelectColumns2)
	ON_BN_CLICKED(IDC_BTN_SELECT, OnBtnSelect)
	ON_BN_CLICKED(ID_SELECT_CHARACTERYSTIC_SET_3, OnSelectCharacterysticSet3)
	ON_BN_CLICKED(ID_SELECT_COLUMNS_3, OnSelectColumns3)
	ON_BN_CLICKED(ID_SELECT_CHARACTERYSTIC_SET_2, OnSelectCharacterysticSet2)
	ON_BN_CLICKED(ID_SELECT_CHARACTERYSTIC_SET_1, OnSelectCharacterysticSet1)
	ON_BN_CLICKED(ID_SELECT_COLUMNS_1, OnSelectColumns1)
	ON_BN_CLICKED(IDC_BTN_SAVE2FILE, OnBtnSave2File)
	ON_BN_CLICKED(IDC_BTN_SAVE2DB, OnSave2db)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnalizeGroupInstances message handlers

BOOL CAnalizeGroupInstances::OnInitDialog() 
{
	CString str;
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	BOOL res=m_ListObjects.CreateFromStatic(IDC_LIST,this,0,true);

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	
	// TODO: Add extra initialization here
	AddAnchor(IDC_LIST,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT, BOTTOM_RIGHT);
	AddAnchor(IDC_BTN_SAVE2FILE,BOTTOM_LEFT, BOTTOM_LEFT);
	AddAnchor(IDC_NAME_COMBINED_TABLE,TOP_LEFT, TOP_LEFT);
	AddAnchor(IDC_BTN_SAVE2DB,TOP_LEFT, TOP_LEFT);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);


	m_BtnSaveToFile.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_BtnSaveToFile.SetFlat(FALSE);
	m_BtnSelectData.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_BtnSelectData.SetFlat(FALSE);
	m_BtnSelectChsrscteristic1.SetIcon(GetAplTableIco(APL_TABLE_SELECT_CHAR));
	m_BtnSelectChsrscteristic1.SetFlat(FALSE);
	m_BtnSelectChsrscteristic2.SetIcon(GetAplTableIco(APL_TABLE_SELECT_CHAR));
	m_BtnSelectChsrscteristic2.SetFlat(FALSE);
	m_BtnSelectChsrscteristic3.SetIcon(GetAplTableIco(APL_TABLE_SELECT_CHAR));
	m_BtnSelectChsrscteristic3.SetFlat(FALSE);
	m_BtnSave2Db.SetIcon(GetAplTableIco(APLSTDICO_OK));
	m_BtnSave2Db.SetFlat(FALSE);
	m_BtnSelectColumns1.SetIcon(GetAplTableIco(APL_TABLE_WIDTH));
	m_BtnSelectColumns1.SetFlat(FALSE);
	m_BtnSelectColumns2.SetIcon(GetAplTableIco(APL_TABLE_WIDTH));
	m_BtnSelectColumns2.SetFlat(FALSE);
	m_BtnSelectColumns3.SetIcon(GetAplTableIco(APL_TABLE_WIDTH));
	m_BtnSelectColumns3.SetFlat(FALSE);

	if(m_combined_table==0){
		m_BtnSave2Db.EnableWindow(FALSE);
		m_EdtNameCombinedTable.SetWindowText( APL_T("   "));
		m_EdtNameCombinedTable.EnableWindow(FALSE);
	}else{
		m_api->m_query_mgr.LoadCombinedTableInfo(m_combined_table,true);
		m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_name,str);
		m_EdtNameCombinedTable.SetWindowText(str);
		if(!m_combined_table->GetTemporary()){
			m_BtnSave2Db.SetWindowText( APL_T(" "));
		}
		if(m_combined_table->GetAccessmode()>aplRW){
			m_BtnSave2Db.EnableWindow(FALSE);
			m_EdtNameCombinedTable.EnableWindow(FALSE);
		}

	}

	FeelTableCtrl();

	m_ListObjects.SetContexMenuMode(true,true,false);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CAnalizeGroupInstances::OnBtnSelect() 
{
	// TODO: Add your control notification handler code here
	//  
	CaplInstance* query;
	m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_query,query);

	query=m_api->m_query_mgr.PrepareQuery(query,_T(""),false,false,false,true,_T("Query_niiao"));
	if(query!=0){
		m_api->m_query_mgr.ExecuteQuery(query,m_content_internal);
		m_api->m_data.PutAttr(query,m_api->m_query_mgr.a_apl_query_content,m_content_internal);
		m_content=&m_content_internal;

		m_api->m_data.PutAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_query,query);
		m_api->m_data.PutAttr(query,m_api->m_query_mgr.a_apl_query_combined_table,m_combined_table);

		FeelTableCtrl();
	}
}


bool CAnalizeGroupInstances::FeelTableCtrl()
{
	int i,j;
	//  : 0 pdf, 1 pi, 2bpi
	int first=-1;
//	CaplTAggr<S_pdf*,S_pdf*,APLAGGR_AUTOKILLREF> list_pi;
	SItemColumnData *cd_pdf=0,*cd_pi=0,*cd_bpi=0;
	aplExtent in_pdf,in_pi,in_bpi;
	aplExtent all_pdf,all_pi,all_bpi,all_bpi_ref,temp_ext,temp_2;
	aplExtent onl_pdf,onl_pi,onl_bpi;
	CaplLoadData ld(&(m_api->m_data),DEF_SOURCE);
	CaplInstance* inst,*inst_pdf,*inst_pi,*inst_bpi;
	in_pdf.Unique=false;
	in_pi.Unique=false;
	in_bpi.Unique=false;
	all_pdf.Unique=false;
	all_pi.Unique=false;
	all_bpi.Unique=false;
	temp_ext.Unique=false;
	
	int temp_indx=0,indx=-1;
	CaplDataBuf dbuf_internal;
	CaplDataBuf *dbuf=0;
	long size=0;
	BYTE *b_buf=0;

	m_Mask.Clear();
	m_Items.Clear();
	//  -      ,   
	m_ListObjects.SetColumnData(dbuf_internal);

	CaplInstance* query;
	m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_query,query);
	if(query!=0){
		m_api->m_data.GetAttr(query, m_api->m_query_mgr.a_apl_query_content,m_content_internal);
		m_content=&m_content_internal;
		
	}else if(m_content==0)return false;

	//   
	for(i=0;i<m_content->GetSize();i++){
		inst=m_content->GetAt(i);
		int temp_first=-1;
		if(m_api->m_data.IsKindOf(inst,m_api->m_prd_mgr.e_pdf)){
			in_pdf.Add(inst);
			all_pdf.Add(inst);
			temp_first=0;
		}else if(m_api->m_data.IsKindOf(inst,m_api->m_prd_inst_mgr.e_prd_inst)){
			in_pi.Add(inst);
			temp_first=1;
		}else if(m_api->m_data.IsKindOf(inst,m_api->m_bp_mgr.e_apl_bp_inst)){
			in_bpi.Add(inst);
			temp_first=2;
		}
		if(first==-1 && temp_first!=-1){
			first=temp_first;
		}
	}
	//    - pdf-pi-bpi
	first=0;

	//  
	//     
	if(all_pdf.GetSize()>0){
		for(i=0;i<all_pdf.GetSize();i++){
			ld.AddQuery(0,'a',all_pdf.GetAt(i)->GetId(),all_pdf.GetAt(i)->GetType(),0,false,false);
		}
		i=ld.AddQuery('r',0,m_api->m_prd_inst_mgr.e_prd_inst,m_api->m_prd_inst_mgr.a_prd_inst_pdf,true);
		ld.AddQuery('d',i,0,m_api->m_prd_inst_mgr.a_prd_inst_pdf,true);
		temp_ext.Clear();
		temp_2.Clear();
		ld.LoadEx(true,&temp_ext);
		for(i=0;i<temp_ext.GetSize();i++){
			inst=temp_ext.GetAt(i);
			if(m_api->m_data.IsKindOf(inst,m_api->m_prd_inst_mgr.e_prd_inst)){
				all_pi.Add(inst);
				//   pdf,    pi
				m_api->m_data.GetAttr(inst,m_api->m_prd_inst_mgr.a_prd_inst_pdf,inst_pdf);
				if(inst_pdf!=0)	temp_2.Add(inst_pdf);
			}
		}
		//  pdf   ,    pi
		onl_pdf.Clear();
		CSortClass::SortExtentById(temp_2);
		for(i=0;i<in_pdf.GetSize();i++){
			inst=in_pdf.GetAt(i);
			if(aplQFindInstIdInExtent(temp_2,inst->GetId())==-1){
				onl_pdf.Add(inst);
			}
		}
		//  pi   ,    all_pi - 
		// ..      in_pdf
		CSortClass::SortExtentById(all_pi);
		temp_ext.Clear();
		for(i=0;i<in_pi.GetSize();i++){
			inst=in_pi.GetAt(i);
			if(aplQFindInstIdInExtent(all_pi,inst->GetId())==-1){
				temp_ext.Add(inst);
			}
		}

	}else{
		//  pi        in_pdf    
		if(in_pi.GetSize()>0){
			for(i=0;i<in_pi.GetSize();i++){
				inst=in_pi.GetAt(i);
				temp_ext.Add(inst);
			}
		}
	}
	all_pi.Append(temp_ext);
	//  pdf  pi,   pdf    
	// (     pdf )
	if(temp_ext.GetSize()>0){
		for(i=0;i<temp_ext.GetSize();i++){
			ld.AddQuery(0,'a',temp_ext.GetAt(i)->GetId(),0,0,true);
		}
		i=ld.AddQuery('d',0,0,m_api->m_prd_inst_mgr.a_prd_inst_pdf,true);
		temp_ext.Clear();
		ld.LoadEx(true,&temp_ext);
		for(i=0;i<temp_ext.GetSize();i++){
			inst=temp_ext.GetAt(i);
			if(m_api->m_data.IsKindOf(inst,m_api->m_prd_mgr.e_pdf)){
				all_pdf.Add(inst);
			}
		}
	}
	//  bpi    pi ( ,      pdf)
	if(all_pi.GetSize()>0){
		for(i=0;i<all_pi.GetSize();i++){
			ld.AddQuery(0,'a',all_pi.GetAt(i)->GetId(),0,0,false);
		}
		i=ld.AddQuery('r',0,m_api->m_bp_mgr.e_bp_inst_ref,m_api->m_bp_mgr.a_bp_inst_ref_item,true);
		ld.AddQuery('d',i,0,m_api->m_bp_mgr.a_bp_inst_ref_item,true);
		ld.AddQuery('d',i,0,m_api->m_bp_mgr.a_bp_inst_ref_process,true);
		temp_ext.Clear();
		ld.LoadEx(true,&temp_ext);
		temp_2.Clear();
		for(i=0;i<temp_ext.GetSize();i++){
			inst=temp_ext.GetAt(i);
			if(m_api->m_data.IsKindOf(inst,m_api->m_bp_mgr.e_apl_bp_inst)){
				all_bpi.Add(inst);
			}else if(m_api->m_data.IsKindOf(inst,m_api->m_bp_mgr.e_bp_inst_ref)){
				all_bpi_ref.Add(inst);
				//   pi,    bpi
				m_api->m_data.GetAttr(inst,m_api->m_bp_mgr.a_bp_inst_ref_item,inst_pi);
				if(inst_pdf!=0)	temp_2.Add(inst_pi);
			}
		}
		//  pi,    bpi
		onl_pi.Clear();
		CSortClass::SortExtentById(temp_2);
		for(i=0;i<all_pi.GetSize();i++){
			inst=all_pi.GetAt(i);
			if(aplQFindInstIdInExtent(temp_2,inst->GetId())==-1){
				onl_pi.Add(inst);
			}
		}
		
		//  bpi   ,    all_bpi
		// ..       pi
		CSortClass::SortExtentById(all_bpi);
		temp_ext.Clear();
		for(i=0;i<in_bpi.GetSize();i++){
			inst=in_bpi.GetAt(i);
			if(aplQFindInstIdInExtent(all_bpi,inst->GetId())==-1){
				temp_ext.Add(inst);
			}
		}
	}else{
		//  bpi   ,    
		//    pi -  
		temp_ext.Append(in_bpi);
	}

	all_bpi.Append(temp_ext);
	if(temp_ext.GetSize()>0){
		//  bpi   pi  pdf    
		for(i=0;i<temp_ext.GetSize();i++){
			ld.AddQuery(0,'a',temp_ext.GetAt(i)->GetId(),0,0,false);
		}
		i=ld.AddQuery('r',0,m_api->m_bp_mgr.e_bp_inst_ref,m_api->m_bp_mgr.a_bp_inst_ref_process,true);
		  ld.AddQuery('d',i,0,m_api->m_bp_mgr.a_bp_inst_ref_process,true);
		j=ld.AddQuery('d',i,0,m_api->m_bp_mgr.a_bp_inst_ref_item,true);
		  ld.AddQuery('d',j,0,m_api->m_prd_inst_mgr.a_prd_inst_pdf,true);
		temp_ext.Clear();
		ld.LoadEx(true,&temp_ext);
		for(i=0;i<temp_ext.GetSize();i++){
			inst=temp_ext.GetAt(i);
			if(m_api->m_data.IsKindOf(inst,m_api->m_prd_inst_mgr.e_prd_inst)){
				all_pi.Add(inst);
			}else if(m_api->m_data.IsKindOf(inst,m_api->m_prd_mgr.e_pdf)){
				all_pdf.Add(inst);
			}else if(m_api->m_data.IsKindOf(inst,m_api->m_bp_mgr.e_bp_inst_ref)){
				all_bpi_ref.Add(inst);
			}
		}		
	}
	//       
	m_api->m_prd_mgr.LoadPrdInfo(all_pdf);
	m_api->m_prd_mgr.LoadPrdInfo(onl_pdf);
	m_api->m_prd_inst_mgr.LoadPrdInstInfo(all_pi);
	m_api->m_prd_inst_mgr.LoadPrdInstInfo(onl_pi);
	m_api->m_bp_mgr.LoadBPInstInfo(all_bpi);

	//       .
	//  
	//   
	for(i=0;i<all_bpi_ref.GetSize();i++){
		inst=all_bpi_ref.GetAt(i);
		m_api->m_data.GetAttr(inst,m_api->m_bp_mgr.a_bp_inst_ref_process,inst_bpi);
		m_api->m_data.GetAttr(inst,m_api->m_bp_mgr.a_bp_inst_ref_item,inst_pi);
		m_api->m_data.GetAttr(inst_pi,m_api->m_prd_inst_mgr.a_prd_inst_pdf,inst_pdf);
		cd_pdf=new SItemColumnData(inst_pdf);
		cd_pi=new SItemColumnData(inst_pi);
		cd_bpi=new SItemColumnData(inst_bpi);
		//   
		if(first==1){
			cd_pi->m_next=cd_pdf;
			cd_pdf->m_next=cd_bpi;
			m_Items.Add(cd_pi);
		}else if(first==2){
			cd_bpi->m_next=cd_pi;
			cd_pi->m_next=cd_pdf;
			m_Items.Add(cd_bpi);
		}else{
			cd_pdf->m_next=cd_pi;
			cd_pi->m_next=cd_bpi;
			m_Items.Add(cd_pdf);
		}

	}
	//   -    bpi
	for(i=0;i<onl_pi.GetSize();i++){
		inst_pi=onl_pi.GetAt(i);
		m_api->m_data.GetAttr(inst_pi,m_api->m_prd_inst_mgr.a_prd_inst_pdf,inst_pdf);
		cd_pdf=new SItemColumnData(inst_pdf);
		cd_pi=new SItemColumnData(inst_pi);
		if(first==1){
			cd_pi->m_next=cd_pdf;
			m_Items.Add(cd_pi);
		}else{
			cd_pdf->m_next=cd_pi;
			m_Items.Add(cd_pdf);
		}
	}
	//   -  pdf
	for(i=0;i<onl_pdf.GetSize();i++){
		inst_pdf=onl_pdf.GetAt(i);
		cd_pdf=new SItemColumnData(inst_pdf);
		m_Items.Add(cd_pdf);
	}

	//      
	if(m_combined_table->GetTemporary()){
		m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_temp_data_index,temp_indx);
		dbuf=(CaplDataBuf*)temp_indx;
		indx=m_api->m_data.m_query_temporary_data.Find(dbuf);
		if(indx==-1){
			dbuf=0;
		}
	}else{
		dbuf=&dbuf_internal;
		dbuf->Clear();
		CString str;
		m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_columns_data,str);
		if(str!=_T("")){
			if(m_api->m_data.NET_GetBlobSize(m_combined_table,
				m_api->m_query_mgr.a_apl_ct_columns_data,size)){
				b_buf=new BYTE[size];
				m_api->m_data.NET_LoadBlob2Memory(m_combined_table,
					m_api->m_query_mgr.a_apl_ct_columns_data,b_buf,size);
				dbuf->Add(b_buf,size);
				delete b_buf;b_buf=0;
			}else{
				m_api->m_data.PutAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_columns_data,_T(""));
			}
		}
	}
	if(dbuf==0){dbuf=&dbuf_internal;}
	m_ListObjects.SetColumnData(*dbuf);

	m_ListObjects.m_api=m_api;
	//    -     ,    
	//      ;        - 
	//   ,   
	m_ListObjects.SaveColumnWidths();
	m_ListObjects.SetData(m_Items,3);

	if(m_ListObjects.IsVisibleDefault())
	{
		m_ListObjects.VisibleColumnRemove(0,OBJ_COL_INSTANCE_ID);
		m_ListObjects.VisibleColumnRemove(0,OBJ_COL_COUNT);
		m_ListObjects.VisibleColumnRemove(0,OBJ_COL_UNIT);
	}

	m_ListObjects.FillTable();

	return true;
}

void CAnalizeGroupInstances::OnCancel() 
{
	SaveColumnData();
	CaplResizableDialog::OnCancel();
}

void CAnalizeGroupInstances::SaveColumnData()
{
	// TODO: Add extra cleanup here
	int temp_indx=0,indx=-1;
	CaplDataBuf dbuf;
	long code=0;
	BYTE *b_buf=0;
	CaplDataBuf* dbuf_tmp;
	CString name,str;
	bool res_b;
	
	m_ListObjects.SaveColumnWidths();
	m_ListObjects.GetColumnData(dbuf);
	
	m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_temp_data_index,temp_indx);
	if(temp_indx!=0){
		//      
		dbuf_tmp=(CaplDataBuf*)temp_indx;
		indx=m_api->m_data.m_query_temporary_data.Find(dbuf_tmp);
		if(indx!=-1){
			m_api->m_data.m_query_temporary_data.Remove(indx);
		}
		m_api->m_data.PutAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_temp_data_index,(int)0);
	}
	if(m_combined_table->GetTemporary()){
		//    
		dbuf_tmp=new CaplDataBuf();
		dbuf_tmp->Add(dbuf.GetBuffer(),dbuf.m_Size);
		m_api->m_data.m_query_temporary_data.Add(dbuf_tmp);
		m_api->m_data.PutAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_temp_data_index,(int)dbuf_tmp);
		
		m_EdtNameCombinedTable.GetWindowText(name);
		m_api->m_data.PutAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_name,name);

	}else{
		m_api->m_data.GetAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_columns_data,str);
		if(str!=_T("")){
			res_b=m_api->m_data.NET_DeleteBlob(m_combined_table,m_api->m_query_mgr.a_apl_ct_columns_data);
		}
		res_b=m_api->m_data.NET_SaveFileFromMemory(m_combined_table,m_api->m_query_mgr.a_apl_ct_columns_data,
								(BYTE*)dbuf.GetBuffer(),dbuf.m_Size,code);
		m_api->SaveChanges();
	}
}


void CAnalizeGroupInstances::OnSelectColumns1() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SelectColumnsOrder(0);	
}
void CAnalizeGroupInstances::OnSelectColumns2() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SelectColumnsOrder(1);
}
void CAnalizeGroupInstances::OnSelectColumns3() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SelectColumnsOrder(2);	
}

void CAnalizeGroupInstances::OnSelectCharacterysticSet1() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SelectCharacterysticSet(0);	
}
void CAnalizeGroupInstances::OnSelectCharacterysticSet2() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SelectCharacterysticSet(1);	
}
void CAnalizeGroupInstances::OnSelectCharacterysticSet3() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SelectCharacterysticSet(2);	
}



void CAnalizeGroupInstances::OnBtnSave2File() 
{
	// TODO: Add your control notification handler code here
	m_ListObjects.SaveToFile(false);
}

void CAnalizeGroupInstances::OnRclickListObjects(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
	return ;
	const MSG* msg;
	msg=GetCurrentMessage();
	//   CInstPropertyCtrl     ,  
	//   RClick,    OnInitDialog  CInstPropertyCtrl::SetContexMenuMode
	UINT command=m_ListObjects.ProcessContextMenu(msg->pt,true,false);
	
	


}

void CAnalizeGroupInstances::OnSave2db() 
{
	// TODO: Add your control notification handler code here
	CString name;
	if(m_combined_table==0)return;
	//   
	m_EdtNameCombinedTable.GetWindowText(name);
	if(!m_api->m_query_mgr.TestNameQuery(name,m_combined_table)){
		return;
	}
	SaveColumnData();
	if(m_combined_table->GetTemporary()){
		if(!m_api->m_query_mgr.SaveQuery(m_combined_table)){
			return ;
		}
		m_BtnSave2Db.SetWindowText( APL_T(" "));
	}
	m_api->m_data.PutAttr(m_combined_table,m_api->m_query_mgr.a_apl_ct_name,name);
	m_api->SaveChanges();
}

