#include "stdafx.h"
#include "CaplPreExploitationMgr.h"
#include <finder.h>
#include "RefusalMiniDlg.h"
#include "FindPDFDlg.h"
#include "FindPrdInstDlgEx.h"
#include "CImportStructPss2IlsDlg.h"

CaplPreExploitationMgr::CaplPreExploitationMgr(void) : m_bFullInit(true)
{
}

CaplPreExploitationMgr::~CaplPreExploitationMgr(void)
{
}

bool CaplPreExploitationMgr::Attach(CaplAPI *api)
{
	if(api==0) {Detach(); return false;}
	CaplStepManager::Attach(api);

	CHECK_ZERO_ATTR(e_apl_resource_change, api->m_data.GetEntityBN(_T("apl_resource_change")));
	CHECK_ZERO_ATTR(a_apl_rc_type, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("type")));
	CHECK_ZERO_ATTR(a_apl_rc_charact, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("charact")));
	CHECK_ZERO_ATTR(a_apl_rc_charact_type, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("charact_type")));
	CHECK_ZERO_ATTR(a_apl_rc_delta, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("delta")));
	CHECK_ZERO_ATTR(a_apl_rc_basis, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("basis")));
	CHECK_ZERO_ATTR(a_apl_rc_recursive, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("recursive")));
	CHECK_ZERO_ATTR(a_apl_rc_item, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("item")));
	CHECK_ZERO_ATTR(a_apl_rc_guid, api->m_data.GetAttrDefinition(e_apl_resource_change, _T("guid")));

	CHECK_ZERO_ATTR(e_apl_refusal, api->m_data.GetEntityBN(_T("apl_refusal")));
	CHECK_ZERO_ATTR(a_apl_refusal_planer, api->m_data.GetAttrDefinition(e_apl_refusal, _T("planer")));
	CHECK_ZERO_ATTR(a_apl_refusal_item, api->m_data.GetAttrDefinition(e_apl_refusal, _T("item")));
	CHECK_ZERO_ATTR(a_apl_refusal_system, api->m_data.GetAttrDefinition(e_apl_refusal, _T("system")));
	CHECK_ZERO_ATTR(a_apl_refusal_part, api->m_data.GetAttrDefinition(e_apl_refusal, _T("part")));
	CHECK_ZERO_ATTR(a_apl_refusal_date_detection, api->m_data.GetAttrDefinition(e_apl_refusal, _T("date_detection")));
	CHECK_ZERO_ATTR(a_apl_refusal_date_removal, api->m_data.GetAttrDefinition(e_apl_refusal, _T("date_removal")));
	CHECK_ZERO_ATTR(a_apl_refusal_type, api->m_data.GetAttrDefinition(e_apl_refusal, _T("refusal_type")));
	CHECK_ZERO_ATTR(a_apl_refusal_conditions, api->m_data.GetAttrDefinition(e_apl_refusal, _T("conditions")));
	CHECK_ZERO_ATTR(a_apl_refusal_method, api->m_data.GetAttrDefinition(e_apl_refusal, _T("method")));
	CHECK_ZERO_ATTR(a_apl_refusal_reason_of_delay, api->m_data.GetAttrDefinition(e_apl_refusal, _T("reason_of_delay")));
	CHECK_ZERO_ATTR(a_apl_refusal_time_delay, api->m_data.GetAttrDefinition(e_apl_refusal, _T("time_delay")));
	CHECK_ZERO_ATTR(a_apl_refusal_consequences, api->m_data.GetAttrDefinition(e_apl_refusal, _T("consequences")));
	CHECK_ZERO_ATTR(a_apl_refusal_culprit, api->m_data.GetAttrDefinition(e_apl_refusal, _T("culprit")));
	CHECK_ZERO_ATTR(a_apl_refusal_description, api->m_data.GetAttrDefinition(e_apl_refusal, _T("description")));
	CHECK_ZERO_ATTR(a_apl_refusal_accepted_arrangements_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("accepted_arrangements_str")));
	CHECK_ZERO_ATTR(a_apl_refusal_accepted_arrangements_obj, api->m_data.GetAttrDefinition(e_apl_refusal, _T("accepted_arrangements_obj")));
	CHECK_ZERO_ATTR(a_apl_refusal_document_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("document_str")));
	CHECK_ZERO_ATTR(a_apl_refusal_document_obj, api->m_data.GetAttrDefinition(e_apl_refusal, _T("document_obj")));
	CHECK_ZERO_ATTR(a_apl_refusal_certificate_of_compliance_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("certificate_of_compliance_str")));
	CHECK_ZERO_ATTR(a_apl_refusal_certificate_of_compliance_obj, api->m_data.GetAttrDefinition(e_apl_refusal, _T("certificate_of_compliance_obj")));
	CHECK_ZERO_ATTR(a_apl_refusal_document_date, api->m_data.GetAttrDefinition(e_apl_refusal, _T("document_date")));
	CHECK_ZERO_ATTR(a_apl_refusal_certificate_of_compliance_date, api->m_data.GetAttrDefinition(e_apl_refusal, _T("certificate_of_compliance_date")));
	CHECK_ZERO_ATTR(a_apl_refusal_faultreason, api->m_data.GetAttrDefinition(e_apl_refusal, _T("faultreason")));
	CHECK_ZERO_ATTR(a_apl_refusal_manifestation, api->m_data.GetAttrDefinition(e_apl_refusal, _T("manifestation")));
	CHECK_ZERO_ATTR(a_apl_refusal_dof, api->m_data.GetAttrDefinition(e_apl_refusal, _T("dof")));
	CHECK_ZERO_ATTR(a_apl_refusal_faultreg1, api->m_data.GetAttrDefinition(e_apl_refusal, _T("faultreq1")));
	CHECK_ZERO_ATTR(a_apl_refusal_faultreg2, api->m_data.GetAttrDefinition(e_apl_refusal, _T("faultreq2")));
	CHECK_ZERO_ATTR(a_apl_refusal_faultreg3, api->m_data.GetAttrDefinition(e_apl_refusal, _T("faultreq3")));
	CHECK_ZERO_ATTR(a_apl_refusal_faultreg4, api->m_data.GetAttrDefinition(e_apl_refusal, _T("faultreq4")));
	CHECK_ZERO_ATTR(a_apl_refusal_disclosuremethod, api->m_data.GetAttrDefinition(e_apl_refusal, _T("disclosuremethod")));
	CHECK_ZERO_ATTR(a_apl_refusal_stafferrorreasen, api->m_data.GetAttrDefinition(e_apl_refusal, _T("stafferrorreason")));
	CHECK_ZERO_ATTR(a_apl_refusal_incident, api->m_data.GetAttrDefinition(e_apl_refusal, _T("incident")));
	CHECK_ZERO_ATTR(a_apl_refusal_is_not_confirm, api->m_data.GetAttrDefinition(e_apl_refusal, _T("is_not_confirm")));
	CHECK_ZERO_ATTR(a_apl_refusal_repair_job, api->m_data.GetAttrDefinition(e_apl_refusal, _T("repair_job")));
	CHECK_ZERO_ATTR(a_apl_refusal_detect_job, api->m_data.GetAttrDefinition(e_apl_refusal, _T("detect_job")));
	CHECK_ZERO_ATTR(a_apl_refusal_guid, api->m_data.GetAttrDefinition(e_apl_refusal, _T("guid")));
	CHECK_ZERO_ATTR(a_apl_refusal_pre_condition, api->m_data.GetAttrDefinition(e_apl_refusal, _T("pre_condition")));
	CHECK_ZERO_ATTR(a_apl_refusal_state, api->m_data.GetAttrDefinition(e_apl_refusal, _T("state")));
	CHECK_ZERO_ATTR(a_apl_refusal_stage, api->m_data.GetAttrDefinition(e_apl_refusal, _T("stage")));
	CHECK_ZERO_ATTR(a_apl_refusal_doc_type, api->m_data.GetAttrDefinition(e_apl_refusal, _T("doc_type")));
	CHECK_ZERO_ATTR(a_apl_refusal_doc_num, api->m_data.GetAttrDefinition(e_apl_refusal, _T("doc_num")));
	CHECK_ZERO_ATTR(a_apl_refusal_doc_date, api->m_data.GetAttrDefinition(e_apl_refusal, _T("doc_date")));
	CHECK_ZERO_ATTR(a_apl_refusal_org, api->m_data.GetAttrDefinition(e_apl_refusal, _T("org")));
	CHECK_ZERO_ATTR(a_apl_refusal_sector, api->m_data.GetAttrDefinition(e_apl_refusal, _T("sector")));
	CHECK_ZERO_ATTR(a_apl_refusal_ext_view, api->m_data.GetAttrDefinition(e_apl_refusal, _T("ext_view")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_first, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_first")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_second, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_second")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_result, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_result")));
	CHECK_ZERO_ATTR(a_apl_refusal_test_deduction, api->m_data.GetAttrDefinition(e_apl_refusal, _T("test_deduction")));
	CHECK_ZERO_ATTR(a_apl_refusal_culprit_deduction, api->m_data.GetAttrDefinition(e_apl_refusal, _T("culprit_deduction")));
	CHECK_ZERO_ATTR(a_apl_refusal_dispose_data, api->m_data.GetAttrDefinition(e_apl_refusal, _T("dispose_data")));
	CHECK_ZERO_ATTR(a_apl_refusal_result_decision, api->m_data.GetAttrDefinition(e_apl_refusal, _T("result_decision")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_act_obj, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_act_obj")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_act_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_act_str")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_act_date, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_act_date")));
	CHECK_ZERO_ATTR(a_apl_refusal_arrangm_act_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("arrangm_act_str")));
	CHECK_ZERO_ATTR(a_apl_refusal_arrangm_act_date, api->m_data.GetAttrDefinition(e_apl_refusal, _T("arrangm_act_date")));
	CHECK_ZERO_ATTR(a_apl_refusal_arrangm_act_obj, api->m_data.GetAttrDefinition(e_apl_refusal, _T("arrangm_act_obj")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_lab, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_lab")));
	CHECK_ZERO_ATTR(a_apl_refusal_research_sector, api->m_data.GetAttrDefinition(e_apl_refusal, _T("research_sector")));
	CHECK_ZERO_ATTR(a_apl_refusal_manifestation_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("manif_str")));	
	CHECK_ZERO_ATTR(a_apl_refusal_resources_str, api->m_data.GetAttrDefinition(e_apl_refusal, _T("resources_str")));	
	CHECK_ZERO_ATTR(a_apl_refusal_item_lot, api->m_data.GetAttrDefinition(e_apl_refusal, _T("item_lot")));	
	CHECK_ZERO_ATTR(a_apl_refusal_part_lot, api->m_data.GetAttrDefinition(e_apl_refusal, _T("part_lot")));	
	CHECK_ZERO_ATTR(a_apl_refusal_parent, api->m_data.GetAttrDefinition(e_apl_refusal, _T("parent")));	
	CHECK_ZERO_ATTR(a_apl_refusal_necassary_arrangm, api->m_data.GetAttrDefinition(e_apl_refusal, _T("necassary_arrangm")));	
	CHECK_ZERO_ATTR(a_apl_refusal_files, api->m_data.GetAttrDefinition(e_apl_refusal, _T("files")));
	CHECK_ZERO_ATTR(a_apl_refusal_union_passport_num, api->m_data.GetAttrDefinition(e_apl_refusal, _T("union_passport_num")));
	CHECK_ZERO_ATTR(a_apl_refusal_fed_to_developer, api->m_data.GetAttrDefinition(e_apl_refusal, _T("fed_to_developer")));
	CHECK_ZERO_ATTR(a_apl_refusal_ignore_in_reliability, api->m_data.GetAttrDefinition(e_apl_refusal, _T("ignore_in_reliability")));
	CHECK_ZERO_ATTR(a_apl_refusal_developer_comments, api->m_data.GetAttrDefinition(e_apl_refusal, _T("developer_comments")));
	CHECK_ZERO_ATTR(a_apl_refusal_spec, api->m_data.GetAttrDefinition(e_apl_refusal, _T("spec")));
	CHECK_ZERO_ATTR(a_apl_refusal_det_method, api->m_data.GetAttrDefinition(e_apl_refusal, _T("det_method")));
	CHECK_ZERO_ATTR(a_apl_refusal_planer_garantee, api->m_data.GetAttrDefinition(e_apl_refusal, _T("planer_garantee")));
	CHECK_ZERO_ATTR(a_apl_refusal_pki_garantee, api->m_data.GetAttrDefinition(e_apl_refusal, _T("pki_garantee")));
	CHECK_ZERO_ATTR(a_apl_refusal_search_time, api->m_data.GetAttrDefinition(e_apl_refusal, _T("search_time")));
	CHECK_ZERO_ATTR(a_apl_refusal_search_labor, api->m_data.GetAttrDefinition(e_apl_refusal, _T("search_labor")));
	CHECK_ZERO_ATTR(a_apl_refusal_removal_time, api->m_data.GetAttrDefinition(e_apl_refusal, _T("removal_time")));
	CHECK_ZERO_ATTR(a_apl_refusal_removal_labor, api->m_data.GetAttrDefinition(e_apl_refusal, _T("removal_labor")));

	CHECK_ZERO_ATTR(e_lss3_reset_usage_by_change,              m_data->GetEntityBN(_T("ils_reset_usage_by_change")));
	CHECK_ZERO_ATTR(a_lss3_reset_usage_by_change_iun,          m_data->GetAttrDefinition(e_lss3_reset_usage_by_change, _T("iun")));
	CHECK_ZERO_ATTR(a_lss3_reset_usage_by_change_change,       m_data->GetAttrDefinition(e_lss3_reset_usage_by_change, _T("change")));
	CHECK_ZERO_ATTR(a_lss3_reset_usage_by_change_value,        m_data->GetAttrDefinition(e_lss3_reset_usage_by_change, _T("value")));
	CHECK_ZERO_ATTR(a_lss3_reset_usage_by_change_date,         m_data->GetAttrDefinition(e_lss3_reset_usage_by_change, _T("date")));
	CHECK_ZERO_ATTR(a_lss3_reset_usage_by_change_res_name,     m_data->GetAttrDefinition(e_lss3_reset_usage_by_change, _T("resource_name")));	

	CHECK_ZERO_ATTR(a_apl_refusal_engine_id, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_id")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_sn, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_sn")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_date_manuf, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_date_manuf")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_derived, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_derived")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_last_repair_derived, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_last_repair_derived")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_date_last_repair, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_date_last_repair")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_manufacturer, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_manufacturer")));
	CHECK_ZERO_ATTR(a_apl_refusal_engine_org_last_repair, api->m_data.GetAttrDefinition(e_apl_refusal, _T("engine_org_last_repair")));

	CHECK_ZERO_ATTR(e_apl_logbook, api->m_data.GetEntityBN(_T("apl_logbook")));;
	CHECK_ZERO_ATTR(a_apl_logbook_items, api->m_data.GetAttrDefinition(e_apl_logbook, _T("items")));
	CHECK_ZERO_ATTR(a_apl_logbook_id, api->m_data.GetAttrDefinition(e_apl_logbook, _T("id")));
	CHECK_ZERO_ATTR(a_apl_logbook_name, api->m_data.GetAttrDefinition(e_apl_logbook, _T("name")));
	CHECK_ZERO_ATTR(a_apl_logbook_descr, api->m_data.GetAttrDefinition(e_apl_logbook, _T("description")));

	CHECK_ZERO_ATTR(e_apl_export_logbook, api->m_data.GetEntityBN(_T("apl_export_logbook")));;
	CHECK_ZERO_ATTR(a_apl_export_logbook_language, api->m_data.GetAttrDefinition(e_apl_export_logbook, _T("language")));
	CHECK_ZERO_ATTR(a_apl_export_logbook_oflogbook, api->m_data.GetAttrDefinition(e_apl_export_logbook, _T("of_logbook")));

	CHECK_ZERO_ATTR(e_apl_logbook_item, api->m_data.GetEntityBN(_T("apl_logbook_item")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_id, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("id")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_name, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("name")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_template, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("template")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_parent, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("parent")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_childs, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("childs")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_logbook, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("logbook")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_use_to_export, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("use_to_export")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_descr, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("description")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_edit_type, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("edit_type")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_pages, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("pages")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_print_fact_pages, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("print_fact_pages")));

	CHECK_ZERO_ATTR(a_apl_logbook_item_language, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("language")));
	CHECK_ZERO_ATTR(a_apl_logbook_item_oflogbookitem, api->m_data.GetAttrDefinition(e_apl_logbook_item, _T("of_logbook_item")));

	CHECK_ZERO_ATTR(e_apl_logbook_dsf_item, api->m_data.GetEntityBN(_T("apl_dsf_item")));;
	CHECK_ZERO_ATTR(a_apl_logbook_dsf_item_defsource, api->m_data.GetAttrDefinition(e_apl_logbook_dsf_item, _T("default_source")));

	CHECK_ZERO_ATTR(e_apl_logbook_dll_item, api->m_data.GetEntityBN(_T("apl_dll_item")));;
	CHECK_ZERO_ATTR(a_apl_logbook_dll_item_function, api->m_data.GetAttrDefinition(e_apl_logbook_dll_item, _T("function")));
	CHECK_ZERO_ATTR(a_apl_logbook_dll_item_dllname, api->m_data.GetAttrDefinition(e_apl_logbook_dll_item, _T("dll_name")));

	CHECK_ZERO_ATTR(e_apl_logbook_dsf, api->m_data.GetEntityBN(_T("apl_dsf")));;
	CHECK_ZERO_ATTR(a_apl_logbook_dsf_dsfitem, api->m_data.GetAttrDefinition(e_apl_logbook_dsf, _T("dsf_item")));
	CHECK_ZERO_ATTR(a_apl_logbook_dsf_source, api->m_data.GetAttrDefinition(e_apl_logbook_dsf, _T("source")));
	//	CHECK_ZERO_ATTR(a_apl_logbook_dsf_export_source, api->m_data.GetAttrDefinition(e_apl_logbook_dsf, _T("export_source")));
	CHECK_ZERO_ATTR(a_apl_logbook_dsf_item, api->m_data.GetAttrDefinition(e_apl_logbook_dsf, _T("item")));

	CHECK_ZERO_ATTR(e_apl_logbook_access, api->m_data.GetEntityBN(_T("apl_logbook_access")));;
	CHECK_ZERO_ATTR(a_apl_logbook_access_person, api->m_data.GetAttrDefinition(e_apl_logbook_access, _T("person")));
	CHECK_ZERO_ATTR(a_apl_logbook_access_item, api->m_data.GetAttrDefinition(e_apl_logbook_access, _T("item")));
	CHECK_ZERO_ATTR(a_apl_logbook_access_level, api->m_data.GetAttrDefinition(e_apl_logbook_access, _T("access_level")));
	CHECK_ZERO_ATTR(a_apl_logbook_access_context, api->m_data.GetAttrDefinition(e_apl_logbook_access, _T("context")));

	CHECK_ZERO_ATTR(e_apl_flier, api->m_data.GetEntityBN(_T("apl_flier")));
	CHECK_ZERO_ATTR(a_apl_flier_flier_day, api->m_data.GetAttrDefinition(e_apl_flier, _T("flier_day")));
	CHECK_ZERO_ATTR(a_apl_flier_flier, api->m_data.GetAttrDefinition(e_apl_flier, _T("bp_flier")));
	CHECK_ZERO_ATTR(a_apl_flier_item, api->m_data.GetAttrDefinition(e_apl_flier, _T("item")));
	CHECK_ZERO_ATTR(a_apl_flier_parashut_number, api->m_data.GetAttrDefinition(e_apl_flier, _T("parashut_number")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_type, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_type")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_plotnost, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_plotnost")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_ostatok, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_ostatok")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_dozaprav, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_dozaprav")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_P, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_p")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_T, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_t")));
	CHECK_ZERO_ATTR(a_apl_flier_fuel_num_rashod_vedom, api->m_data.GetAttrDefinition(e_apl_flier, _T("fuel_num_rashod_vedom")));
	CHECK_ZERO_ATTR(a_apl_flier_maslo_left_eng, api->m_data.GetAttrDefinition(e_apl_flier, _T("maslo_left_eng")));
	CHECK_ZERO_ATTR(a_apl_flier_maslo_right_eng, api->m_data.GetAttrDefinition(e_apl_flier, _T("maslo_right_eng")));
	CHECK_ZERO_ATTR(a_apl_flier_maslo_rashod_left_eng, api->m_data.GetAttrDefinition(e_apl_flier, _T("maslo_rashod_in_hour_left_eng")));
	CHECK_ZERO_ATTR(a_apl_flier_maslo_rashod_right_eng, api->m_data.GetAttrDefinition(e_apl_flier, _T("maslo_rashod_in_hour_right_eng")));
	CHECK_ZERO_ATTR(a_apl_flier_maslo_amg10_1gs, api->m_data.GetAttrDefinition(e_apl_flier, _T("maslo_amg10_1gs")));
	CHECK_ZERO_ATTR(a_apl_flier_maslo_amg10_2gs, api->m_data.GetAttrDefinition(e_apl_flier, _T("maslo_amg10_2gs")));
	CHECK_ZERO_ATTR(a_apl_flier_azot_fonar, api->m_data.GetAttrDefinition(e_apl_flier, _T("azot_fonar")));
	CHECK_ZERO_ATTR(a_apl_flier_azot_avarijn_system, api->m_data.GetAttrDefinition(e_apl_flier, _T("azot_avarijn_system")));
	CHECK_ZERO_ATTR(a_apl_flier_oxygen_base, api->m_data.GetAttrDefinition(e_apl_flier, _T("oxygen_base")));
	CHECK_ZERO_ATTR(a_apl_flier_oxygen_additional, api->m_data.GetAttrDefinition(e_apl_flier, _T("oxygen_additional")));
	CHECK_ZERO_ATTR(a_apl_flier_anti_obled_zhidkost, api->m_data.GetAttrDefinition(e_apl_flier, _T("anti_obledenit_zhidkost")));
	CHECK_ZERO_ATTR(a_apl_flier_generator_maslo_left, api->m_data.GetAttrDefinition(e_apl_flier, _T("generator_maslo_left")));
	CHECK_ZERO_ATTR(a_apl_flier_generator_maslo_right, api->m_data.GetAttrDefinition(e_apl_flier, _T("generator_maslo_right")));
	CHECK_ZERO_ATTR(a_apl_flier_units_of_fire, api->m_data.GetAttrDefinition(e_apl_flier, _T("units_of_fire")));

	CHECK_ZERO_ATTR(e_apl_fixing, api->m_data.GetEntityBN(_T("apl_fixing_product")));
	CHECK_ZERO_ATTR(a_apl_fixing_item, api->m_data.GetAttrDefinition(e_apl_fixing, _T("item")));
	CHECK_ZERO_ATTR(a_apl_fixing_person, api->m_data.GetAttrDefinition(e_apl_fixing, _T("person")));
	CHECK_ZERO_ATTR(a_apl_fixing_fix_basis, api->m_data.GetAttrDefinition(e_apl_fixing, _T("fixing_basis")));
	CHECK_ZERO_ATTR(a_apl_fixing_ufix_basis, api->m_data.GetAttrDefinition(e_apl_fixing, _T("unfixing_basis")));

	CHECK_ZERO_ATTR(e_apl_transfer, api->m_data.GetEntityBN(_T("apl_transfer")));
	CHECK_ZERO_ATTR(a_apl_transfer_item, api->m_data.GetAttrDefinition(e_apl_transfer, _T("item")));
	CHECK_ZERO_ATTR(a_apl_transfer_date_time_recieved, api->m_data.GetAttrDefinition(e_apl_transfer, _T("date_time_recieved")));
	CHECK_ZERO_ATTR(a_apl_transfer_date_time_delivered, api->m_data.GetAttrDefinition(e_apl_transfer, _T("date_time_delivered")));
	CHECK_ZERO_ATTR(a_apl_transfer_state, api->m_data.GetAttrDefinition(e_apl_transfer, _T("state")));
	CHECK_ZERO_ATTR(a_apl_transfer_basis_obj, api->m_data.GetAttrDefinition(e_apl_transfer, _T("basis_obj")));
	CHECK_ZERO_ATTR(a_apl_transfer_basis_str, api->m_data.GetAttrDefinition(e_apl_transfer, _T("basis_str")));
	CHECK_ZERO_ATTR(a_apl_transfer_comment, api->m_data.GetAttrDefinition(e_apl_transfer, _T("comment")));
	CHECK_ZERO_ATTR(a_apl_transfer_delivered_obj, api->m_data.GetAttrDefinition(e_apl_transfer, _T("delivered_obj")));
	CHECK_ZERO_ATTR(a_apl_transfer_recieved_obj, api->m_data.GetAttrDefinition(e_apl_transfer, _T("recieved_obj")));

	CHECK_ZERO_ATTR(e_apl_item_place_group,                    m_data->GetEntityBN(_T("apl_item_place_group")));
	CHECK_ZERO_ATTR(a_apl_item_place_group_final_item,         m_data->GetAttrDefinition(e_apl_item_place_group, _T("final_item")));
	CHECK_ZERO_ATTR(a_apl_item_place_group_id,                 m_data->GetAttrDefinition(e_apl_item_place_group, _T("id")));

	CHECK_ZERO_ATTR(e_apl_item_place,                          m_data->GetEntityBN(_T("apl_item_place")));
	CHECK_ZERO_ATTR(a_apl_item_place_group,                    m_data->GetAttrDefinition(e_apl_item_place, _T("group")));
	CHECK_ZERO_ATTR(a_apl_item_place_id,                       m_data->GetAttrDefinition(e_apl_item_place, _T("id")));
	CHECK_ZERO_ATTR(a_apl_item_place_parent_item,              m_data->GetAttrDefinition(e_apl_item_place, _T("parent_item")));
	CHECK_ZERO_ATTR(a_apl_item_place_zone,                     m_data->GetAttrDefinition(e_apl_item_place, _T("zone")));
	CHECK_ZERO_ATTR(a_apl_item_place_item,                     m_data->GetAttrDefinition(e_apl_item_place, _T("item")));
	CHECK_ZERO_ATTR(a_apl_item_place_final_item,               m_data->GetAttrDefinition(e_apl_item_place, _T("final_item")));

	CHECK_ZERO_ATTR(e_apl_logbook_state_history,               m_data->GetEntityBN(_T("apl_logbook_state_history")));
	CHECK_ZERO_ATTR(a_apl_logbook_state_history_new_state,     m_data->GetAttrDefinition(e_apl_logbook_state_history, _T("new_state")));
	CHECK_ZERO_ATTR(a_apl_logbook_state_history_old_state,     m_data->GetAttrDefinition(e_apl_logbook_state_history, _T("old_state")));
	CHECK_ZERO_ATTR(a_apl_logbook_state_history_date_time,     m_data->GetAttrDefinition(e_apl_logbook_state_history, _T("date_time")));
	CHECK_ZERO_ATTR(a_apl_logbook_state_history_person,        m_data->GetAttrDefinition(e_apl_logbook_state_history, _T("person")));
	CHECK_ZERO_ATTR(a_apl_logbook_state_history_item,          m_data->GetAttrDefinition(e_apl_logbook_state_history, _T("item")));
	CHECK_ZERO_ATTR(a_apl_logbook_state_history_description,   m_data->GetAttrDefinition(e_apl_logbook_state_history, _T("description")));

	CHECK_ZERO_ATTR(e_apl_logbook_job_journal_item,				m_data->GetEntityBN(_T("apl_logbook_job_journal_item")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_id,          m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("id")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_state,       m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("state")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_executer,    m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("executer")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_date_plan,   m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("date_plan")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_date_fact,   m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("date_fact")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_remove,      m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("remove")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_install,     m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("install")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_system,      m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("system")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_zone,        m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("zone")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_position,    m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("position")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_planer,      m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("planer")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_descr,	    m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("description")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_type,		m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("type")));
	CHECK_ZERO_ATTR(a_apl_logbook_job_journal_item_org,			m_data->GetAttrDefinition(e_apl_logbook_job_journal_item, _T("organization")));


	CHECK_ZERO_ATTR(e_apl_incident, api->m_data.GetEntityBN(_T("apl_incident")));
	CHECK_ZERO_ATTR(a_apl_incident_report_incident, api->m_data.GetAttrDefinition(e_apl_incident, _T("report_incident")));
	CHECK_ZERO_ATTR(a_apl_incident_report_operative_message, api->m_data.GetAttrDefinition(e_apl_incident, _T("report_operative_message")));
	CHECK_ZERO_ATTR(a_apl_incident_id, api->m_data.GetAttrDefinition(e_apl_incident, _T("id")));
	CHECK_ZERO_ATTR(a_apl_incident_date, api->m_data.GetAttrDefinition(e_apl_incident, _T("date")));
	CHECK_ZERO_ATTR(a_apl_incident_category, api->m_data.GetAttrDefinition(e_apl_incident, _T("category")));
	CHECK_ZERO_ATTR(a_apl_incident_airport, api->m_data.GetAttrDefinition(e_apl_incident, _T("airport")));
	CHECK_ZERO_ATTR(a_apl_incident_planer, api->m_data.GetAttrDefinition(e_apl_incident, _T("planer")));
	CHECK_ZERO_ATTR(a_apl_incident_department, api->m_data.GetAttrDefinition(e_apl_incident, _T("department")));
	CHECK_ZERO_ATTR(a_apl_incident_system, api->m_data.GetAttrDefinition(e_apl_incident, _T("system")));
	CHECK_ZERO_ATTR(a_apl_incident_flight_crew, api->m_data.GetAttrDefinition(e_apl_incident, _T("flight_crew")));
	CHECK_ZERO_ATTR(a_apl_incident_engine, api->m_data.GetAttrDefinition(e_apl_incident, _T("engine")));
	CHECK_ZERO_ATTR(a_apl_incident_conditions, api->m_data.GetAttrDefinition(e_apl_incident, _T("conditions")));
	CHECK_ZERO_ATTR(a_apl_incident_reason, api->m_data.GetAttrDefinition(e_apl_incident, _T("reason")));
	CHECK_ZERO_ATTR(a_apl_incident_description, api->m_data.GetAttrDefinition(e_apl_incident, _T("description")));
	CHECK_ZERO_ATTR(a_apl_incident_group, api->m_data.GetAttrDefinition(e_apl_incident, _T("group")));
	CHECK_ZERO_ATTR(a_apl_incident_situation, api->m_data.GetAttrDefinition(e_apl_incident, _T("situation")));
	CHECK_ZERO_ATTR(a_apl_incident_revision_number, api->m_data.GetAttrDefinition(e_apl_incident, _T("revision_number")));
	CHECK_ZERO_ATTR(a_apl_incident_user, api->m_data.GetAttrDefinition(e_apl_incident, _T("user")));
	CHECK_ZERO_ATTR(a_apl_incident_revision_date, api->m_data.GetAttrDefinition(e_apl_incident, _T("revision_date")));
	CHECK_ZERO_ATTR(a_apl_incident_refusals, api->m_data.GetAttrDefinition(e_apl_incident, _T("refusals")));
	CHECK_ZERO_ATTR(a_apl_incident_next_version, api->m_data.GetAttrDefinition(e_apl_incident, _T("next_version")));
	CHECK_ZERO_ATTR(a_apl_incident_name, api->m_data.GetAttrDefinition(e_apl_incident, _T("name")));
	CHECK_ZERO_ATTR(a_apl_incident_date_gmt, api->m_data.GetAttrDefinition(e_apl_incident, _T("date_gmt")));
	CHECK_ZERO_ATTR(a_apl_incident_state, api->m_data.GetAttrDefinition(e_apl_incident, _T("state")));
	CHECK_ZERO_ATTR(a_apl_incident_location, api->m_data.GetAttrDefinition(e_apl_incident, _T("location")));
	CHECK_ZERO_ATTR(a_apl_incident_flight_phase, api->m_data.GetAttrDefinition(e_apl_incident, _T("flight_phase")));
	CHECK_ZERO_ATTR(a_apl_incident_ground, api->m_data.GetAttrDefinition(e_apl_incident, _T("ground")));
	CHECK_ZERO_ATTR(a_apl_incident_class, api->m_data.GetAttrDefinition(e_apl_incident, _T("class")));
	CHECK_ZERO_ATTR(a_apl_incident_damage_aircraft, api->m_data.GetAttrDefinition(e_apl_incident, _T("damage_aircraft")));
	CHECK_ZERO_ATTR(a_apl_incident_damage_aerodrome, api->m_data.GetAttrDefinition(e_apl_incident, _T("damage_aerodrome")));
	CHECK_ZERO_ATTR(a_apl_incident_damage_third_party, api->m_data.GetAttrDefinition(e_apl_incident, _T("damage_third_party")));
	CHECK_ZERO_ATTR(a_apl_incident_injury_level, api->m_data.GetAttrDefinition(e_apl_incident, _T("injury_level")));
	CHECK_ZERO_ATTR(a_apl_incident_flight, api->m_data.GetAttrDefinition(e_apl_incident, _T("flight")));
	CHECK_ZERO_ATTR(a_apl_incident_report_date, api->m_data.GetAttrDefinition(e_apl_incident, _T("report_date")));
	CHECK_ZERO_ATTR(a_apl_incident_report_org, api->m_data.GetAttrDefinition(e_apl_incident, _T("report_org")));
	CHECK_ZERO_ATTR(a_apl_incident_report_investigate, api->m_data.GetAttrDefinition(e_apl_incident, _T("report_investigate")));
	CHECK_ZERO_ATTR(a_apl_incident_victims_number, api->m_data.GetAttrDefinition(e_apl_incident, _T("victims_number")));
	CHECK_ZERO_ATTR(a_apl_incident_meteo, api->m_data.GetAttrDefinition(e_apl_incident, _T("meteo")));
	CHECK_ZERO_ATTR(a_apl_incident_status, api->m_data.GetAttrDefinition(e_apl_incident, _T("status")));

	CHECK_ZERO_ATTR(e_apl_incident_info, api->m_data.GetEntityBN(_T("apl_incident_info")));
	CHECK_ZERO_ATTR(a_apl_incident_info_incident, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("incident")));
	CHECK_ZERO_ATTR(a_apl_incident_info_id, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("id")));
	CHECK_ZERO_ATTR(a_apl_incident_info_kind, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("kind")));
	CHECK_ZERO_ATTR(a_apl_incident_info_date, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("date")));
	CHECK_ZERO_ATTR(a_apl_incident_info_org, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("org")));
	CHECK_ZERO_ATTR(a_apl_incident_info_description, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("description")));
	CHECK_ZERO_ATTR(a_apl_incident_info_parent, api->m_data.GetAttrDefinition(e_apl_incident_info, _T("parent")));

	CHECK_ZERO_ATTR(e_apl_incident_element, api->m_data.GetEntityBN(_T("apl_incident_element")));
	CHECK_ZERO_ATTR(a_apl_incident_element_incident, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("incident")));
	CHECK_ZERO_ATTR(a_apl_incident_element_parent, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("parent")));
	CHECK_ZERO_ATTR(a_apl_incident_element_id, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("id")));
	CHECK_ZERO_ATTR(a_apl_incident_element_type, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("type")));
	CHECK_ZERO_ATTR(a_apl_incident_element_code, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("code")));
	CHECK_ZERO_ATTR(a_apl_incident_element_modifier, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("modifier")));
	CHECK_ZERO_ATTR(a_apl_incident_element_mission_phase, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("mission_phase")));
	CHECK_ZERO_ATTR(a_apl_incident_element_description, api->m_data.GetAttrDefinition(e_apl_incident_element, _T("description")));

	CHECK_ZERO_ATTR(e_apl_crew, api->m_data.GetEntityBN(_T("apl_crew")));
	CHECK_ZERO_ATTR(a_apl_crew_id, api->m_data.GetAttrDefinition(e_apl_crew, _T("id")));
	CHECK_ZERO_ATTR(a_apl_crew_role, api->m_data.GetAttrDefinition(e_apl_crew, _T("role")));
	CHECK_ZERO_ATTR(a_apl_crew_certification, api->m_data.GetAttrDefinition(e_apl_crew, _T("certification")));
	CHECK_ZERO_ATTR(a_apl_crew_rating, api->m_data.GetAttrDefinition(e_apl_crew, _T("rating")));
	CHECK_ZERO_ATTR(a_apl_crew_qualification, api->m_data.GetAttrDefinition(e_apl_crew, _T("qualification")));
	CHECK_ZERO_ATTR(a_apl_crew_time_total, api->m_data.GetAttrDefinition(e_apl_crew, _T("time_total")));
	CHECK_ZERO_ATTR(a_apl_crew_time_fi, api->m_data.GetAttrDefinition(e_apl_crew, _T("time_fi")));
	CHECK_ZERO_ATTR(a_apl_crew_time_total_90days, api->m_data.GetAttrDefinition(e_apl_crew, _T("time_total_90days")));
	CHECK_ZERO_ATTR(a_apl_crew_time_fi_90days, api->m_data.GetAttrDefinition(e_apl_crew, _T("time_fi_90days")));
	CHECK_ZERO_ATTR(a_apl_crew_incident, api->m_data.GetAttrDefinition(e_apl_crew, _T("incident")));

	CHECK_ZERO_ATTR(e_apl_bulletin, api->m_data.GetEntityBN(_T("apl_bulletin")));
	CHECK_ZERO_ATTR(a_apl_bulletin_bp, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("of_bp")));
	CHECK_ZERO_ATTR(a_apl_bulletin_status, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("status")));
	CHECK_ZERO_ATTR(a_apl_bulletin_reason, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("reason")));
	CHECK_ZERO_ATTR(a_apl_bulletin_solution, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("solution")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_begin_date, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_begin_date")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_end_date, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_end_date")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_labor, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_labor")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_finance, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_finance")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_place, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_place")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_place_orgs, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_place_orgs")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_place_description, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_place_description")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_execute, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_execute")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_execute_orgs, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_execute_orgs")));
	CHECK_ZERO_ATTR(a_apl_bulletin_jobs_execute_description, api->m_data.GetAttrDefinition(e_apl_bulletin, _T("jobs_execute_description")));

	CHECK_ZERO_ATTR(e_apl_solution, api->m_data.GetEntityBN(_T("apl_solution")));
	CHECK_ZERO_ATTR(a_apl_solution_id, api->m_data.GetAttrDefinition(e_apl_solution, _T("id")));
	CHECK_ZERO_ATTR(a_apl_solution_date, api->m_data.GetAttrDefinition(e_apl_solution, _T("date")));
	CHECK_ZERO_ATTR(a_apl_solution_bulletin, api->m_data.GetAttrDefinition(e_apl_solution, _T("bulletin")));

	/************************************************************************/
	/*							                                   */
	/************************************************************************/

	CHECK_ZERO_ATTR(e_ils_bulletin,								m_data->GetEntityBN(_T("ils_bulletin")));
	CHECK_ZERO_ATTR(a_ils_bulletin_number,						m_data->GetAttrDefinition(e_ils_bulletin, _T("number")));
	CHECK_ZERO_ATTR(a_ils_bulletin_date,						m_data->GetAttrDefinition(e_ils_bulletin, _T("date")));
	CHECK_ZERO_ATTR(a_ils_bulletin_code,						m_data->GetAttrDefinition(e_ils_bulletin, _T("code")));
	CHECK_ZERO_ATTR(a_ils_bulletin_status,						m_data->GetAttrDefinition(e_ils_bulletin, _T("status")));
	CHECK_ZERO_ATTR(a_ils_bulletin_reason,						m_data->GetAttrDefinition(e_ils_bulletin, _T("reason")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_begin_date,				m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_begin_date")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_end_date,				m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_end_date")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_labor,					m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_labor")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_finance,				m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_finance")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_place,					m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_place")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_place_orgs,				m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_place_orgs")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_place_description,		m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_place_description")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_execute,				m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_execute")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_execute_orgs,			m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_execute_orgs")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_execute_description,	m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_execute_description")));
	CHECK_ZERO_ATTR(a_ils_bulletin_guid,						m_data->GetAttrDefinition(e_ils_bulletin, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_bulletin_max_working_hours,			m_data->GetAttrDefinition(e_ils_bulletin, _T("max_working_hours")));
	CHECK_ZERO_ATTR(a_ils_bulletin_max_exploitation_hours,		m_data->GetAttrDefinition(e_ils_bulletin, _T("max_exploitation_hours")));
	CHECK_ZERO_ATTR(a_ils_bulletin_solution_id,					m_data->GetAttrDefinition(e_ils_bulletin, _T("solution_id")));
	CHECK_ZERO_ATTR(a_ils_bulletin_solution_date,				m_data->GetAttrDefinition(e_ils_bulletin, _T("solution_date")));
	CHECK_ZERO_ATTR(a_ils_bulletin_id,							m_data->GetAttrDefinition(e_ils_bulletin, _T("id")));
	CHECK_ZERO_ATTR(a_ils_bulletin_name,						m_data->GetAttrDefinition(e_ils_bulletin, _T("name")));
	CHECK_ZERO_ATTR(a_ils_bulletin_conditions,					m_data->GetAttrDefinition(e_ils_bulletin, _T("conditions")));
	CHECK_ZERO_ATTR(a_ils_bulletin_developer,					m_data->GetAttrDefinition(e_ils_bulletin, _T("developer")));
	CHECK_ZERO_ATTR(a_ils_by_contract,							m_data->GetAttrDefinition(e_ils_bulletin, _T("by_contract")));
	CHECK_ZERO_ATTR(a_ils_by_receive,							m_data->GetAttrDefinition(e_ils_bulletin, _T("by_receive")));
	CHECK_ZERO_ATTR(a_ils_bulletin_max_working_flights,			m_data->GetAttrDefinition(e_ils_bulletin, _T("max_working_flights")));
	CHECK_ZERO_ATTR(a_ils_bulletin_kind,						m_data->GetAttrDefinition(e_ils_bulletin, _T("kind")));
	CHECK_ZERO_ATTR(a_ils_bulletin_jobs_plan,					m_data->GetAttrDefinition(e_ils_bulletin, _T("jobs_plan")));
	CHECK_ZERO_ATTR(a_ils_bulletin_urgent,						m_data->GetAttrDefinition(e_ils_bulletin, _T("urgent")));
	CHECK_ZERO_ATTR(a_ils_bulletin_apply_date,					m_data->GetAttrDefinition(e_ils_bulletin, _T("apply_date")));
	CHECK_ZERO_ATTR(a_ils_bulletin_demand_doc_change,			m_data->GetAttrDefinition(e_ils_bulletin, _T("demand_doc_change")));
	CHECK_ZERO_ATTR(a_ils_bulletin_parent,						m_data->GetAttrDefinition(e_ils_bulletin, _T("parent")));
	CHECK_ZERO_ATTR(a_ils_bulletin_part_of_doc,					m_data->GetAttrDefinition(e_ils_bulletin, _T("part_of_doc")));

	/************************************************************************/
	/*						                               */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_bulletin_ref,                        m_data->GetEntityBN(_T("ils_bulletin_reference")));
	CHECK_ZERO_ATTR(a_ils_bulletin_ref_bulletin,               m_data->GetAttrDefinition(e_ils_bulletin_ref, _T("bulletin")));
	CHECK_ZERO_ATTR(a_ils_bulletin_ref_product,                m_data->GetAttrDefinition(e_ils_bulletin_ref, _T("product")));
	CHECK_ZERO_ATTR(a_ils_bulletin_ref_guid,                   m_data->GetAttrDefinition(e_ils_bulletin_ref, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_bulletin_ref_date,                   m_data->GetAttrDefinition(e_ils_bulletin_ref, _T("date")));
	CHECK_ZERO_ATTR(a_ils_bulletin_ref_type,					m_data->GetAttrDefinition(e_ils_bulletin_ref, _T("type")));

	/************************************************************************/
	/*                         ils_base_product_instance                    */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_base_product_instance,									m_data->GetEntityBN(_T("ils_base_product_instance")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_of_ils_base_product,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("of_ils_base_product")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_serial_number,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("serial_number")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_id,									m_data->GetAttrDefinition(e_ils_base_product_instance, _T("id")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_description,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("description")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_developer,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("developer")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_manufacturer,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("manufacturer")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_provider,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("provider")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_manufacture,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_manufacture")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_state,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("state")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_guid,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_not_check_composition,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("not_check_composition")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_change_check_composition,		m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_change_check_composition")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_owner,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("owner")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_operator,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("operator")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_exploit_type,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("exploit_type")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_contract_number,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("contract_number")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_contract_date,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("contract_date")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_start_garantee,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_start_garantee")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_airport,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("airport")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_person_change_check_composition,	m_data->GetAttrDefinition(e_ils_base_product_instance, _T("person_change_check_composition")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_config,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("config")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_provide,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_provide")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_individual_resource,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("individual_resource")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_auto,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("auto")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_software_version,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("software_version")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_control_type,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("control_type")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_control_value,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("control_value")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_recalc,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_recalc")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_reg_num,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("reg_num")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_registration,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_registration")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_workability_date_begin,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("workability_date_begin")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_workability_date_end,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("workability_date_end")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_workability_date_renewal,			m_data->GetAttrDefinition(e_ils_base_product_instance, _T("workability_date_renewal")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_start_operate,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_start_operate")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_repair_org,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("repair_org")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_last_repair,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_last_repair")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_amount_repairs,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("amount_repairs")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_status,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("status")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_delivery_contract,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("delivery_contract")));	
	CHECK_ZERO_ATTR(a_ils_base_product_instance_current_status,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("current_status")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_folder_number,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("folder_num")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_pass_number,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("passport_num")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_pass_id,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("passport_id")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_topfull,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("topfull")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_of_product_revision,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("of_product_revision")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_hide_sn,							m_data->GetAttrDefinition(e_ils_base_product_instance, _T("hide_sn")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_delivery_part_number,				m_data->GetAttrDefinition(e_ils_base_product_instance, _T("delivery_part_number")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_date_garantee_void_fact,			m_data->GetAttrDefinition(e_ils_base_product_instance, _T("date_garantee_void_fact")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_fnn,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("fnn")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_pss_instance,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("pss_instance")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_expl_doc_type,						m_data->GetAttrDefinition(e_ils_base_product_instance, _T("expl_doc_type")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_amount,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("amount")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_short_description,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("short_description")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_has_composition,					m_data->GetAttrDefinition(e_ils_base_product_instance, _T("has_composition")));
	CHECK_ZERO_ATTR(a_ils_base_product_instance_id_ext,								m_data->GetAttrDefinition(e_ils_base_product_instance, _T("id_ext")));

	/************************************************************************/
	/*						 							*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_apl_recovery_point,					m_data->GetEntityBN(_T("apl_recovery_point")));
	CHECK_ZERO_ATTR(a_apl_recovery_point_id,				m_data->GetAttrDefinition(e_apl_recovery_point, _T("id")));
	CHECK_ZERO_ATTR(a_apl_recovery_point_user_session_id,	m_data->GetAttrDefinition(e_apl_recovery_point, _T("user_session_id")));

	/************************************************************************/
	/*							 LSS3			                    */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_apl_lss3_component,				   m_data->GetEntityBN(_T("apl_lss3_component")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_id,				       m_data->GetAttrDefinition(e_apl_lss3_component, _T("id")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_id_eng,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("id_eng")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_code,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("code")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_name_rus,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("name_rus")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_name_eng,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("name_eng")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_short_name,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("short_name")));	
	CHECK_ZERO_ATTR(a_apl_lss3comp_short_name_eng,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("short_name_eng")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_descr_rus,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("descr_rus")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_descr_eng,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("descr_eng")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_kafi,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("kafi")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_kafi_str,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("kafi_str"))) ;
	CHECK_ZERO_ATTR(a_apl_lss3comp_type,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_recommend_as_part,	   m_data->GetAttrDefinition(e_apl_lss3_component, _T("recommend_as_part")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_is_MSI,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("maintaneable")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_fnn,				       m_data->GetAttrDefinition(e_apl_lss3_component, _T("fnn")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_spec_maint,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("spec_maint")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_expl_doc_type,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("expl_doc_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_is_fi,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("is_fi")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_class,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("class")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_expl_method,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("expl_method")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_maint_measure_type,     m_data->GetAttrDefinition(e_apl_lss3_component, _T("maint_measure_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_ref_intense_calc,       m_data->GetAttrDefinition(e_apl_lss3_component, _T("ref_intense_calc")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_ref_intense_fact,       m_data->GetAttrDefinition(e_apl_lss3_component, _T("ref_intense_fact")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_ref_intense_required,   m_data->GetAttrDefinition(e_apl_lss3_component, _T("ref_intense_predict")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_mtbf_calc,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("mtbf_calc")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_mtbf_fact,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("mtbf_fact")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_mtbf_required,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("mtbf_predict")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_mtbur_calc,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("mtbur_calc")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_mtbur_fact,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("mtbur_fact")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_mtbur_required,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("mtbur_predict")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_time_between_rep,	   m_data->GetAttrDefinition(e_apl_lss3_component, _T("time_between_rep")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_unit_of_usage,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("unit_of_usage")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_usage_resname,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("usage_resname")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_repairability,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("repairability")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_developer,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("developer")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_kind,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("kind")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_category,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("category")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_id_ext,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("id_ext")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_hide_id,				   m_data->GetAttrDefinition(e_apl_lss3_component, _T("hide_id")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_actual_supply_option,   m_data->GetAttrDefinition(e_apl_lss3_component, _T("actual_supply_option"))) ;	
	CHECK_ZERO_ATTR(a_apl_lss3comp_essentiality_code,	   m_data->GetAttrDefinition(e_apl_lss3_component, _T("essentiality_code"))) ;	
	CHECK_ZERO_ATTR(a_apl_lss3comp_actual_depot_balance,   m_data->GetAttrDefinition(e_apl_lss3_component, _T("actual_depot_balance")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_is_standard,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("is_standard")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_make_or_buy,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("make_or_buy")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_normative_document,	   m_data->GetAttrDefinition(e_apl_lss3_component, _T("normative_document")));	
	CHECK_ZERO_ATTR(a_apl_lss3comp_weight,						 m_data->GetAttrDefinition(e_apl_lss3_component, _T("weight")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_replacement_labour,			 m_data->GetAttrDefinition(e_apl_lss3_component, _T("replacement_labour")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_replacement_service_type,	 m_data->GetAttrDefinition(e_apl_lss3_component, _T("replacement_service_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_repair_service_type,			 m_data->GetAttrDefinition(e_apl_lss3_component, _T("repair_service_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_pdf,			 m_data->GetAttrDefinition(e_apl_lss3_component, _T("pdf")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_height,		 m_data->GetAttrDefinition(e_apl_lss3_component, _T("height")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_width,		 m_data->GetAttrDefinition(e_apl_lss3_component, _T("width")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_depth,		 m_data->GetAttrDefinition(e_apl_lss3_component, _T("depth")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_shsc,				 m_data->GetAttrDefinition(e_apl_lss3_component, _T("shsc")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_importance_category,  m_data->GetAttrDefinition(e_apl_lss3_component, _T("importance_category")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_bolt_mark,			 m_data->GetAttrDefinition(e_apl_lss3_component, _T("bolt_mark")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_is_pure_functional,	 m_data->GetAttrDefinition(e_apl_lss3_component, _T("is_pure_functional")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_material,			   m_data->GetAttrDefinition(e_apl_lss3_component, _T("material")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_material_type,		   m_data->GetAttrDefinition(e_apl_lss3_component, _T("material_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_is_ssi,					m_data->GetAttrDefinition(e_apl_lss3_component, _T("is_ssi")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_ssi,						m_data->GetAttrDefinition(e_apl_lss3_component, _T("ssi")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_lcn_structure,			m_data->GetAttrDefinition(e_apl_lss3_component, _T("lcn_structure")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_unserializable,	m_data->GetAttrDefinition(e_apl_lss3_component, _T("unserializable")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_part_of_la_form,			m_data->GetAttrDefinition(e_apl_lss3_component, _T("part_of_la_form")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_requires_cataloging, m_data->GetAttrDefinition(e_apl_lss3_component, _T("requires_cataloging")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_standard, m_data->GetAttrDefinition(e_apl_lss3_component, _T("standard")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_unit, m_data->GetAttrDefinition(e_apl_lss3_component, _T("unit")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_equipment_type, m_data->GetAttrDefinition(e_apl_lss3_component, _T("equipment_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_fm_classifier_ref, m_data->GetAttrDefinition(e_apl_lss3_component, _T("fm_classifier_ref")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_date_recalc, m_data->GetAttrDefinition(e_apl_lss3_component, _T("date_recalc")));


	/************************************************************************/
	/*							    '           */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_comp_zip_relation, m_data->GetEntityBN(_T("ils_comp_zip_relation")));
	CHECK_ZERO_ATTR(a_ils_comp_zip_relation_zip, m_data->GetAttrDefinition(e_ils_comp_zip_relation, _T("zip")));
	CHECK_ZERO_ATTR(a_ils_comp_zip_relation_component, m_data->GetAttrDefinition(e_ils_comp_zip_relation, _T("component")));

	/************************************************************************/
	/*							    '             */
	/************************************************************************/

	CHECK_ZERO_ATTR(e_lss3_aggr_iun_relation,	m_data->GetEntityBN(_T("ils_aggr_iun_relation")));
	CHECK_ZERO_ATTR(a_lss3_aggr_iun_relation_aggr, m_data->GetAttrDefinition(e_lss3_aggr_iun_relation, _T("aggregate")));
	CHECK_ZERO_ATTR(a_lss3_aggr_iun_relation_iun, m_data->GetAttrDefinition(e_lss3_aggr_iun_relation, _T("iun")));		

	/************************************************************************/
	/*                          LSS3						*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_apl_lss3_component_revision,	m_data->GetEntityBN(_T("apl_lss3_component_revision")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_id, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("id")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_of_product, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("of_product")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_actual_supply_option, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("actual_supply_option")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_weight, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("weight")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_length, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("length")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_width, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("width")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_height, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("height")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_mass_unit, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("mass_unit")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_dim_unit, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("dim_unit")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_sw_ver, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("sw_ver")));
	CHECK_ZERO_ATTR(a_apl_lss3_comprev_id_ext, m_data->GetAttrDefinition(e_apl_lss3_component_revision, _T("id_ext")));

	/************************************************************************/
	/*                           LSS3                  */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_apl_usage_unit,				   m_data->GetEntityBN(_T("apl_usage_unit")));
	
	CHECK_ZERO_ATTR(a_apl_usage_unit_product,		   m_data->GetAttrDefinition(e_apl_usage_unit, _T("product")));
	CHECK_ZERO_ATTR(a_apl_usage_unit_unit,			   m_data->GetAttrDefinition(e_apl_usage_unit, _T("unit")));
	CHECK_ZERO_ATTR(a_apl_usage_unit_guid,			   m_data->GetAttrDefinition(e_apl_usage_unit, _T("guid")));

	/************************************************************************/
	/*                         LSS REFUSAL		                            */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_lss_refusal,											m_data->GetEntityBN(_T("lss_refusal")));
	CHECK_ZERO_ATTR(a_lss_refusal_id,										m_data->GetAttrDefinition(e_lss_refusal, _T("id")));
	CHECK_ZERO_ATTR(a_lss_refusal_planer,									m_data->GetAttrDefinition(e_lss_refusal, _T("planer")));
	CHECK_ZERO_ATTR(a_lss_refusal_system,									m_data->GetAttrDefinition(e_lss_refusal, _T("system")));
	CHECK_ZERO_ATTR(a_lss_refusal_system_inst,								m_data->GetAttrDefinition(e_lss_refusal, _T("system_inst")));
	CHECK_ZERO_ATTR(a_lss_refusal_system_real_component,					m_data->GetAttrDefinition(e_lss_refusal, _T("refusal_system_real_component")));
	CHECK_ZERO_ATTR(a_lss_refusal_item,										m_data->GetAttrDefinition(e_lss_refusal, _T("item")));
	CHECK_ZERO_ATTR(a_lss_refusal_date_detected,							m_data->GetAttrDefinition(e_lss_refusal, _T("date_detected")));
	CHECK_ZERO_ATTR(a_lss_refusal_date_removal,								m_data->GetAttrDefinition(e_lss_refusal, _T("date_removal")));
	CHECK_ZERO_ATTR(a_lss_refusal_kun_number,								m_data->GetAttrDefinition(e_lss_refusal, _T("kun_number")));
	CHECK_ZERO_ATTR(a_lss_refusal_kun_date,									m_data->GetAttrDefinition(e_lss_refusal, _T("kun_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_type,										m_data->GetAttrDefinition(e_lss_refusal, _T("type")));
	CHECK_ZERO_ATTR(a_lss_refusal_type_for_system,							m_data->GetAttrDefinition(e_lss_refusal, _T("type_for_system")));
	CHECK_ZERO_ATTR(a_lss_refusal_manifestation,							m_data->GetAttrDefinition(e_lss_refusal, _T("manifestation")));
	CHECK_ZERO_ATTR(a_lss_refusal_manifestation_eng,						m_data->GetAttrDefinition(e_lss_refusal, _T("manifestation_eng")));
	CHECK_ZERO_ATTR(a_lss_refusal_stage_detection,							m_data->GetAttrDefinition(e_lss_refusal, _T("stage_detection")));
	CHECK_ZERO_ATTR(a_lss_refusal_stage_detection_lvl,						m_data->GetAttrDefinition(e_lss_refusal, _T("stage_detection_lvl")));
	CHECK_ZERO_ATTR(a_lss_refusal_consequence,								m_data->GetAttrDefinition(e_lss_refusal, _T("consequence")));
	CHECK_ZERO_ATTR(a_lss_refusal_consequence_lvl,							m_data->GetAttrDefinition(e_lss_refusal, _T("consequence_lvl")));
	CHECK_ZERO_ATTR(a_lss_refusal_exception,								m_data->GetAttrDefinition(e_lss_refusal, _T("exception")));
	CHECK_ZERO_ATTR(a_lss_refusal_detection_form,							m_data->GetAttrDefinition(e_lss_refusal, _T("detection_form")));
	CHECK_ZERO_ATTR(a_lss_refusal_detection_confirm,						m_data->GetAttrDefinition(e_lss_refusal, _T("detection_confirm")));
	CHECK_ZERO_ATTR(a_lss_refusal_incident_type,							m_data->GetAttrDefinition(e_lss_refusal, _T("incident_type")));
	CHECK_ZERO_ATTR(a_lss_refusal_delay,									m_data->GetAttrDefinition(e_lss_refusal, _T("delay")));
	CHECK_ZERO_ATTR(a_lss_refusal_delay_reason,								m_data->GetAttrDefinition(e_lss_refusal, _T("delay_reason")));
	CHECK_ZERO_ATTR(a_lss_refusal_form_removal,								m_data->GetAttrDefinition(e_lss_refusal, _T("form_removal")));
	CHECK_ZERO_ATTR(a_lss_refusal_search_job_duration,						m_data->GetAttrDefinition(e_lss_refusal, _T("search_job_duration")));
	CHECK_ZERO_ATTR(a_lss_refusal_search_job_idle,							m_data->GetAttrDefinition(e_lss_refusal, _T("search_job_idle")));
	CHECK_ZERO_ATTR(a_lss_refusal_search_job_labor,							m_data->GetAttrDefinition(e_lss_refusal, _T("search_job_labor")));
	CHECK_ZERO_ATTR(a_lss_refusal_search_job_cost,							m_data->GetAttrDefinition(e_lss_refusal, _T("search_job_cost")));
	//CHECK_ZERO_ATTR(a_lss_refusal_repair_job_labor,							m_data->GetAttrDefinition(e_lss_refusal, _T("repair_job_labor")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_duration,						m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_duration")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_spare_parts_idle,				m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_spare_parts_idle")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_other_idle,					m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_other_idle")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_labor,						m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_labor")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_staff_cost,					m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_staff_cost")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_spare_parts_cost,				m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_spare_parts_cost")));
	CHECK_ZERO_ATTR(a_lss_refusal_removal_job_total_cost,					m_data->GetAttrDefinition(e_lss_refusal, _T("removal_job_total_cost")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_manifestation,						m_data->GetAttrDefinition(e_lss_refusal, _T("item_manifestation")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_reason,								m_data->GetAttrDefinition(e_lss_refusal, _T("item_reason")));
	CHECK_ZERO_ATTR(a_lss_refusal_accepted_arrangements,					m_data->GetAttrDefinition(e_lss_refusal, _T("accepted_arrangements")));
	CHECK_ZERO_ATTR(a_lss_refusal_method,									m_data->GetAttrDefinition(e_lss_refusal, _T("method")));
	CHECK_ZERO_ATTR(a_lss_refusal_description,								m_data->GetAttrDefinition(e_lss_refusal, _T("description")));
	CHECK_ZERO_ATTR(a_lss_refusal_temperature,								m_data->GetAttrDefinition(e_lss_refusal, _T("temperature")));
	CHECK_ZERO_ATTR(a_lss_refusal_humidity,								m_data->GetAttrDefinition(e_lss_refusal, _T("humidity")));
	CHECK_ZERO_ATTR(a_lss_refusal_recovery_time,								m_data->GetAttrDefinition(e_lss_refusal, _T("recovery_time")));
	CHECK_ZERO_ATTR(a_lss_refusal_pressure,								m_data->GetAttrDefinition(e_lss_refusal, _T("pressure")));
	CHECK_ZERO_ATTR(a_lss_refusal_element_block,							m_data->GetAttrDefinition(e_lss_refusal, _T("element_block")));
	CHECK_ZERO_ATTR(a_lss_refusal_element_node,								m_data->GetAttrDefinition(e_lss_refusal, _T("element_node")));
	CHECK_ZERO_ATTR(a_lss_refusal_element_subblock,							m_data->GetAttrDefinition(e_lss_refusal, _T("element_subblock")));
	CHECK_ZERO_ATTR(a_lss_refusal_element_group,							m_data->GetAttrDefinition(e_lss_refusal, _T("element_group")));
	CHECK_ZERO_ATTR(a_lss_refusal_element_scheme_number,					m_data->GetAttrDefinition(e_lss_refusal, _T("element_scheme_number")));
	CHECK_ZERO_ATTR(a_lss_refusal_defective_items,							m_data->GetAttrDefinition(e_lss_refusal, _T("defective_items")));
	CHECK_ZERO_ATTR(a_lss_refusal_planer_serial_number,						m_data->GetAttrDefinition(e_lss_refusal, _T("planer_serial_number")));
	CHECK_ZERO_ATTR(a_lss_refusal_planer_repair_count,						m_data->GetAttrDefinition(e_lss_refusal, _T("planer_repair_count")));
	CHECK_ZERO_ATTR(a_lss_refusal_planer_last_repair_date,					m_data->GetAttrDefinition(e_lss_refusal, _T("planer_last_repair_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_planer_last_repair_executer,				m_data->GetAttrDefinition(e_lss_refusal, _T("planer_last_repair_executer")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_serial_number,						m_data->GetAttrDefinition(e_lss_refusal, _T("item_serial_number")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_manufacturer,						m_data->GetAttrDefinition(e_lss_refusal, _T("item_manufacturer")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_date_manufactured,					m_data->GetAttrDefinition(e_lss_refusal, _T("item_date_manufactured")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_repair_count,						m_data->GetAttrDefinition(e_lss_refusal, _T("item_repair_count")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_last_repair_date,					m_data->GetAttrDefinition(e_lss_refusal, _T("item_last_repair_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_last_repair_executer,				m_data->GetAttrDefinition(e_lss_refusal, _T("item_last_repair_executer")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_last_install_date,					m_data->GetAttrDefinition(e_lss_refusal, _T("item_last_install_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_reason_determined,					m_data->GetAttrDefinition(e_lss_refusal, _T("item_reason_determined")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_type,								m_data->GetAttrDefinition(e_lss_refusal, _T("item_type")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_of_manufacturer,						m_data->GetAttrDefinition(e_lss_refusal, _T("item_of_manufacturer")));
	CHECK_ZERO_ATTR(a_lss_refusal_mission,									m_data->GetAttrDefinition(e_lss_refusal, _T("mission")));
	CHECK_ZERO_ATTR(a_lss_refusal_mission_failure,							m_data->GetAttrDefinition(e_lss_refusal, _T("mission_failure")));
	CHECK_ZERO_ATTR(a_lss_refusal_confirmed,								m_data->GetAttrDefinition(e_lss_refusal, _T("confirmed")));
	CHECK_ZERO_ATTR(a_lss_refusal_consider_in_analyse,						m_data->GetAttrDefinition(e_lss_refusal, _T("consider_in_analyse")));	
	CHECK_ZERO_ATTR(a_lss_refusal_refused_instance,							m_data->GetAttrDefinition(e_lss_refusal, _T("refused_instance")));
	CHECK_ZERO_ATTR(a_lss_refusal_reason_lvl,								m_data->GetAttrDefinition(e_lss_refusal, _T("reason")));
	CHECK_ZERO_ATTR(a_lss_refusal_reason_description,						m_data->GetAttrDefinition(e_lss_refusal, _T("reason_descr")));
	CHECK_ZERO_ATTR(a_lss_refusal_reason_description_eng,					m_data->GetAttrDefinition(e_lss_refusal, _T("reason_descr_eng")));
	CHECK_ZERO_ATTR(a_lss_refusal_preliminary_cause_lvl,					m_data->GetAttrDefinition(e_lss_refusal, _T("preliminary_cause")));
	CHECK_ZERO_ATTR(a_lss_refusal_preliminary_cause_description,			m_data->GetAttrDefinition(e_lss_refusal, _T("preliminary_cause_descr")));
	CHECK_ZERO_ATTR(a_lss_refusal_preliminary_cause_description_eng,		m_data->GetAttrDefinition(e_lss_refusal, _T("preliminary_cause_descr_eng")));
	CHECK_ZERO_ATTR(a_lss_refusal_ext_manifistation_lvl,					m_data->GetAttrDefinition(e_lss_refusal, _T("ext_manifistation")));
	CHECK_ZERO_ATTR(a_lss_refusal_conditions_lvl,							m_data->GetAttrDefinition(e_lss_refusal, _T("conditions")));
	CHECK_ZERO_ATTR(a_lss_refusal_remedy_lvl,								m_data->GetAttrDefinition(e_lss_refusal, _T("remedy")));
	CHECK_ZERO_ATTR(a_lss_refusal_remedy_description,						m_data->GetAttrDefinition(e_lss_refusal, _T("remedy_descr")));
	CHECK_ZERO_ATTR(a_lss_refusal_led_to_incident,							m_data->GetAttrDefinition(e_lss_refusal, _T("led_to_incident")));
	CHECK_ZERO_ATTR(a_lss_refusal_nature_lvl,								m_data->GetAttrDefinition(e_lss_refusal, _T("nature")));
	CHECK_ZERO_ATTR(a_lss_refusal_precipitation_lvl,						m_data->GetAttrDefinition(e_lss_refusal, _T("precipitation")));
	CHECK_ZERO_ATTR(a_lss_refusal_lifecycle_stage_lvl,						m_data->GetAttrDefinition(e_lss_refusal, _T("lifecycle_stage")));	 
	CHECK_ZERO_ATTR(a_lss_refusal_hash,										m_data->GetAttrDefinition(e_lss_refusal, _T("hash")));	 	
	CHECK_ZERO_ATTR(a_lss_refusal_comment,									m_data->GetAttrDefinition(e_lss_refusal, _T("comment")));	 
	CHECK_ZERO_ATTR(a_lss_refusal_comment_eng,								m_data->GetAttrDefinition(e_lss_refusal, _T("comment_eng")));
	CHECK_ZERO_ATTR(a_lss_refusal_act_number,								m_data->GetAttrDefinition(e_lss_refusal, _T("act_number")));	 
	CHECK_ZERO_ATTR(a_lss_refusal_reclamation_date,							m_data->GetAttrDefinition(e_lss_refusal, _T("reclamation_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_satisfaction_date,						m_data->GetAttrDefinition(e_lss_refusal, _T("satisfaction_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_plan_satisfaction_date,					m_data->GetAttrDefinition(e_lss_refusal, _T("plan_satisfaction_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_testing_date,								m_data->GetAttrDefinition(e_lss_refusal, _T("testing_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_reclamation_id,							m_data->GetAttrDefinition(e_lss_refusal, _T("reclamation_id")));
	CHECK_ZERO_ATTR(a_lss_refusal_satisfaction_id,							m_data->GetAttrDefinition(e_lss_refusal, _T("satisfation_id")));
	CHECK_ZERO_ATTR(a_lss_refusal_testing_id,								m_data->GetAttrDefinition(e_lss_refusal, _T("testing_id")));
	CHECK_ZERO_ATTR(a_lss_refusal_incorrect_data,							m_data->GetAttrDefinition(e_lss_refusal, _T("incorrect_data")));	
	CHECK_ZERO_ATTR(a_lss_refusal_speciality,								m_data->GetAttrDefinition(e_lss_refusal, _T("speciality")));
	CHECK_ZERO_ATTR(a_lss_refusal_detection_type,							m_data->GetAttrDefinition(e_lss_refusal, _T("detection_type")));
	CHECK_ZERO_ATTR(a_lss_refusal_staff_reason,								m_data->GetAttrDefinition(e_lss_refusal, _T("staff_reason")));
	CHECK_ZERO_ATTR(a_lss_refusal_essence,									m_data->GetAttrDefinition(e_lss_refusal, _T("essence")));
	CHECK_ZERO_ATTR(a_lss_refusal_essence_descr,							m_data->GetAttrDefinition(e_lss_refusal, _T("essence_descr")));
	CHECK_ZERO_ATTR(a_lss_refusal_scenario,									m_data->GetAttrDefinition(e_lss_refusal, _T("scenario")));
	CHECK_ZERO_ATTR(a_lss_refusal_item_derived,								m_data->GetAttrDefinition(e_lss_refusal, _T("item_derived")));
	CHECK_ZERO_ATTR(a_lss_refusal_notice_id,								m_data->GetAttrDefinition(e_lss_refusal, _T("notice_id")));
	CHECK_ZERO_ATTR(a_lss_refusal_notice_date,								m_data->GetAttrDefinition(e_lss_refusal, _T("notice_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_replenish_id,								m_data->GetAttrDefinition(e_lss_refusal, _T("replenish_id")));
	CHECK_ZERO_ATTR(a_lss_refusal_replenish_date,							m_data->GetAttrDefinition(e_lss_refusal, _T("replenish_date")));
	CHECK_ZERO_ATTR(a_lss_refusal_reclamation_state,						m_data->GetAttrDefinition(e_lss_refusal, _T("reclamation_state")));
	CHECK_ZERO_ATTR(a_lss_refusal_mode,										m_data->GetAttrDefinition(e_lss_refusal, _T("mode")));

	CHECK_ZERO_ATTR(e_ils_classifier_reference,                m_data->GetEntityBN(_T("apl_ils_classifier_reference")));
	CHECK_ZERO_ATTR(a_ils_clssf_ref_classifier,                m_data->GetAttrDefinition(e_ils_classifier_reference, _T("classifier")));
	CHECK_ZERO_ATTR(a_ils_clssf_ref_refusal,                   m_data->GetAttrDefinition(e_ils_classifier_reference, _T("refusal")));
	CHECK_ZERO_ATTR(a_ils_clssf_ref_type,                      m_data->GetAttrDefinition(e_ils_classifier_reference, _T("type")));

		
	/************************************************************************/
	/*					  LSS3			                */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_apl_lss3_logistic_element,					m_data->GetEntityBN(_T("apl_lss3_logistic_element")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_lcn,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("lcn")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_count_in_node,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("count_in_node")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_parent_element,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("parent_element")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_parent_component,				m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("parent_component")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_child_component,				m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("child_component")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_name_rus,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("name_rus")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_name_eng,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("name_eng")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_cfi,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("cfi")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_element_type,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("element_type")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_descr_rus,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("descr_rus")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_descr_eng,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("descr_eng")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_logistic_type,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("logistic_type")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_usage_resname,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("usage_resname")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_guid,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("guid")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_child_comp_revision,			m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("child_comp_revision")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_expluatation_main_system,		m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("reliability_analysis_system")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_reliability_system,				m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("reliability_system")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_position,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("position")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_sns,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("sns")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_scheme_id,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("scheme_id")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_group,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("group")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_is_MSI,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("maintainable")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_is_lhirf,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("is_lhirf")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_lhirf_analysis,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("lhirf_analysis")));

	CHECK_ZERO_ATTR(a_apl_lss3logel_mtbf_required,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("mtbf_predict")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_mtbf_calc,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("mtbf_calc")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_ref_intense_required,			m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("ref_intens_predict")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_ref_intense_calc,				m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("ref_intense_calc")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_mtbur_required,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("mtbur_predict")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_mtbur_calc,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("mtbur_calc")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_shsc,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("shsc")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_importance_category,			m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("importance_category")));	
	CHECK_ZERO_ATTR(a_apl_lss3logel_mtbf_source,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("mtbf_source")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_not_check_composition,			m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("not_check_composition")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_context,						m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("context")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_exclude_from_composition,		m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("exclude_from_composition")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_expl_method,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("expl_method")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_amount,							m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("amount")));
	CHECK_ZERO_ATTR(a_apl_lss3logel_amount_unit,					m_data->GetAttrDefinition(e_apl_lss3_logistic_element, _T("amount_unit")));

	/************************************************************************/
	/*					    LSS3			                */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_apl_lss3_zone_access,						   m_data->GetEntityBN(_T("apl_lss3_zone")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_code,				           m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("code")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_name_rus,				       m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("name_rus")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_descr_rus,				       m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("descr_rus")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_parent,				           m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("parent")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_type,				           m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("type")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_parent_fi,					   m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("parent_fi")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_fistr,							m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("fi")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_analysis,						m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("zone_analysis")));
	CHECK_ZERO_ATTR(a_apl_lss3_zone_is_need_rcm_analysis,			m_data->GetAttrDefinition(e_apl_lss3_zone_access, _T("is_need_rcm_analysis")));

	/************************************************************************/
	/*					 				                */
	/************************************************************************/

	CHECK_ZERO_ATTR(e_ils_resource_name,				m_data->GetEntityBN(_T("ils_resource_name")));
	CHECK_ZERO_ATTR(a_ils_resource_name_id,				m_data->GetAttrDefinition(e_ils_resource_name, _T("id")));
	CHECK_ZERO_ATTR(a_ils_resource_name_name,			m_data->GetAttrDefinition(e_ils_resource_name, _T("name")));
	CHECK_ZERO_ATTR(a_ils_resource_name_name_eng,		m_data->GetAttrDefinition(e_ils_resource_name, _T("name_eng")));
	CHECK_ZERO_ATTR(a_ils_resource_name_unit,			m_data->GetAttrDefinition(e_ils_resource_name, _T("unit")));
	CHECK_ZERO_ATTR(a_ils_resource_name_elements,		m_data->GetAttrDefinition(e_ils_resource_name, _T("elements")));
	CHECK_ZERO_ATTR(a_ils_resource_name_calculated,		m_data->GetAttrDefinition(e_ils_resource_name, _T("calculated")));
	CHECK_ZERO_ATTR(a_ils_resource_name_working_hours,	m_data->GetAttrDefinition(e_ils_resource_name, _T("working_hours")));
	CHECK_ZERO_ATTR(a_ils_resource_name_shown_id,		m_data->GetAttrDefinition(e_ils_resource_name, _T("shown_id")));

	CHECK_ZERO_ATTR(e_ils_resource_name_element,			m_data->GetEntityBN(_T("ils_resource_name_element")));
	CHECK_ZERO_ATTR(a_ils_resource_name_element_factor,		m_data->GetAttrDefinition(e_ils_resource_name_element, _T("factor")));
	CHECK_ZERO_ATTR(a_ils_resource_name_element_element,	m_data->GetAttrDefinition(e_ils_resource_name_element, _T("element")));
	
	/************************************************************************/
	/*													                */
	/************************************************************************/
	
	CHECK_ZERO_ATTR(e_ils_resource,						m_data->GetEntityBN(_T("ils_resource")));
	CHECK_ZERO_ATTR(a_ils_resource_item,				m_data->GetAttrDefinition(e_ils_resource, _T("item")));
	CHECK_ZERO_ATTR(a_ils_resource_name,				m_data->GetAttrDefinition(e_ils_resource, _T("name")));
	CHECK_ZERO_ATTR(a_ils_resource_guid,				m_data->GetAttrDefinition(e_ils_resource, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_resource_set,					m_data->GetAttrDefinition(e_ils_resource, _T("set")));
	CHECK_ZERO_ATTR(a_ils_resource_garantee,			m_data->GetAttrDefinition(e_ils_resource, _T("garantee")));
	CHECK_ZERO_ATTR(a_ils_resource_first_repair,		m_data->GetAttrDefinition(e_ils_resource, _T("first_repair")));
	CHECK_ZERO_ATTR(a_ils_resource_between_repair,		m_data->GetAttrDefinition(e_ils_resource, _T("between_repair")));
	CHECK_ZERO_ATTR(a_ils_resource_befor_set,			m_data->GetAttrDefinition(e_ils_resource, _T("befor_set")));
	CHECK_ZERO_ATTR(a_ils_resource_derived,				m_data->GetAttrDefinition(e_ils_resource, _T("derived")));
	CHECK_ZERO_ATTR(a_ils_resource_last_repair_derived,	m_data->GetAttrDefinition(e_ils_resource, _T("last_repair_derived")));
	CHECK_ZERO_ATTR(a_ils_resource_ultimate_life,		m_data->GetAttrDefinition(e_ils_resource, _T("ultimate_life")));
	CHECK_ZERO_ATTR(a_ils_resource_individual,			m_data->GetAttrDefinition(e_ils_resource, _T("individual")));
	CHECK_ZERO_ATTR(a_ils_resource_element,				m_data->GetAttrDefinition(e_ils_resource, _T("element")));
	CHECK_ZERO_ATTR(a_ils_resource_average,				m_data->GetAttrDefinition(e_ils_resource, _T("average")));
	CHECK_ZERO_ATTR(a_ils_resource_limit,				m_data->GetAttrDefinition(e_ils_resource, _T("limit")));
	CHECK_ZERO_ATTR(a_ils_resource_calculated,			m_data->GetAttrDefinition(e_ils_resource, _T("calculated")));
	CHECK_ZERO_ATTR(a_ils_resource_set_as_parent,		m_data->GetAttrDefinition(e_ils_resource, _T("set_as_parent")));
	CHECK_ZERO_ATTR(a_ils_resource_parent,				m_data->GetAttrDefinition(e_ils_resource, _T("parent")));

	/************************************************************************/
	/*                         e_ils_flight                                 */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_flight,                              m_data->GetEntityBN(_T("ils_flight")));
	CHECK_ZERO_ATTR(a_ils_flight_base_product,                 m_data->GetAttrDefinition(e_ils_flight, _T("base_product")));
	CHECK_ZERO_ATTR(a_ils_flight_date_time,                    m_data->GetAttrDefinition(e_ils_flight, _T("date_time")));
	CHECK_ZERO_ATTR(a_ils_flight_date_time_end,                m_data->GetAttrDefinition(e_ils_flight, _T("date_time_end")));
	CHECK_ZERO_ATTR(a_ils_flight_start_fuel_mass,              m_data->GetAttrDefinition(e_ils_flight, _T("start_fuel_mass")));
	CHECK_ZERO_ATTR(a_ils_flight_end_fuel_mass,                m_data->GetAttrDefinition(e_ils_flight, _T("end_fuel_mass")));
	CHECK_ZERO_ATTR(a_ils_flight_payload_mass,                 m_data->GetAttrDefinition(e_ils_flight, _T("payload_mass")));
	CHECK_ZERO_ATTR(a_ils_flight_takeoff_mass,                 m_data->GetAttrDefinition(e_ils_flight, _T("takeoff_mass")));
	CHECK_ZERO_ATTR(a_ils_flight_passengers_count,             m_data->GetAttrDefinition(e_ils_flight, _T("passengers_count")));
	CHECK_ZERO_ATTR(a_ils_flight_max_flight_overload,          m_data->GetAttrDefinition(e_ils_flight, _T("max_flight_overload")));
	CHECK_ZERO_ATTR(a_ils_flight_max_landing_overload,         m_data->GetAttrDefinition(e_ils_flight, _T("max_landing_overload")));
	CHECK_ZERO_ATTR(a_ils_flight_additional_events,            m_data->GetAttrDefinition(e_ils_flight, _T("additional_events")));
	CHECK_ZERO_ATTR(a_ils_flight_comments,                     m_data->GetAttrDefinition(e_ils_flight, _T("comments")));
	CHECK_ZERO_ATTR(a_ils_flight_pilot,                        m_data->GetAttrDefinition(e_ils_flight, _T("pilot")));
	CHECK_ZERO_ATTR(a_ils_flight_airport_departure,            m_data->GetAttrDefinition(e_ils_flight, _T("airport_departure")));
	CHECK_ZERO_ATTR(a_ils_flight_airport_arrival,              m_data->GetAttrDefinition(e_ils_flight, _T("airport_arrival")));
	CHECK_ZERO_ATTR(a_ils_flight_type,						   m_data->GetAttrDefinition(e_ils_flight, _T("flight_type")));
	CHECK_ZERO_ATTR(a_ils_flight_guid,						   m_data->GetAttrDefinition(e_ils_flight, _T("guid")));

	/************************************************************************/
	/*                      e_ils_query                                     */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_query,								m_data->GetEntityBN(_T("ils_query")));
	CHECK_ZERO_ATTR(a_ils_query_parent,							m_data->GetAttrDefinition(e_ils_query, _T("parent")));
	CHECK_ZERO_ATTR(a_ils_query_id,								m_data->GetAttrDefinition(e_ils_query, _T("id")));
	CHECK_ZERO_ATTR(a_ils_query_section,						m_data->GetAttrDefinition(e_ils_query, _T("section")));
	CHECK_ZERO_ATTR(a_ils_query_name,							m_data->GetAttrDefinition(e_ils_query, _T("name")));
	CHECK_ZERO_ATTR(a_ils_query_author,							m_data->GetAttrDefinition(e_ils_query, _T("author")));
	CHECK_ZERO_ATTR(a_ils_query_date,							m_data->GetAttrDefinition(e_ils_query, _T("date")));
	CHECK_ZERO_ATTR(a_ils_query_op,								m_data->GetAttrDefinition(e_ils_query, _T("op")));
	CHECK_ZERO_ATTR(a_ils_query_read_only,						m_data->GetAttrDefinition(e_ils_query, _T("read_only")));
	CHECK_ZERO_ATTR(a_ils_query_report,							m_data->GetAttrDefinition(e_ils_query, _T("report")));
	CHECK_ZERO_ATTR(a_ils_query_description,					m_data->GetAttrDefinition(e_ils_query, _T("description")));
	CHECK_ZERO_ATTR(a_ils_query_copy_from,						m_data->GetAttrDefinition(e_ils_query, _T("copy_from")));
	CHECK_ZERO_ATTR(a_ils_query_is_filter,						m_data->GetAttrDefinition(e_ils_query, _T("is_filter")));
	
	

	/************************************************************************/
	/*                      e_ils_query_par_type                            */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_query_par_type,						m_data->GetEntityBN(_T("ils_query_par_type")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_parent,				m_data->GetAttrDefinition(e_ils_query_par_type, _T("parent")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_id,					m_data->GetAttrDefinition(e_ils_query_par_type, _T("id")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_name,					m_data->GetAttrDefinition(e_ils_query_par_type, _T("name")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_type,					m_data->GetAttrDefinition(e_ils_query_par_type, _T("type")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_attr,					m_data->GetAttrDefinition(e_ils_query_par_type, _T("attr")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_entity,				m_data->GetAttrDefinition(e_ils_query_par_type, _T("entity")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_query,					m_data->GetAttrDefinition(e_ils_query_par_type, _T("query")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_first_level,			m_data->GetAttrDefinition(e_ils_query_par_type, _T("first_level")));
	CHECK_ZERO_ATTR(a_ils_query_par_type_version,				m_data->GetAttrDefinition(e_ils_query_par_type, _T("version")));

	/************************************************************************/
	/*                      e_ils_query_parameter                           */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_query_parameter,						m_data->GetEntityBN(_T("ils_query_parameter")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_query,				m_data->GetAttrDefinition(e_ils_query_parameter, _T("query")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_type,					m_data->GetAttrDefinition(e_ils_query_parameter, _T("type")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_op,					m_data->GetAttrDefinition(e_ils_query_parameter, _T("op")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_relation,				m_data->GetAttrDefinition(e_ils_query_parameter, _T("relation")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_value,				m_data->GetAttrDefinition(e_ils_query_parameter, _T("value")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_number,				m_data->GetAttrDefinition(e_ils_query_parameter, _T("number")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_object,				m_data->GetAttrDefinition(e_ils_query_parameter, _T("object")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_flag,					m_data->GetAttrDefinition(e_ils_query_parameter, _T("flag")));
	CHECK_ZERO_ATTR(a_ils_query_parameter_of_type,				m_data->GetAttrDefinition(e_ils_query_parameter, _T("of_type")));

	/************************************************************************/
	/*                     					                        */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_report,						m_data->GetEntityBN(_T("ils_report")));
	CHECK_ZERO_ATTR(a_ils_report_name,					m_data->GetAttrDefinition(e_ils_report, _T("name")));
	CHECK_ZERO_ATTR(a_ils_report_section,				m_data->GetAttrDefinition(e_ils_report, _T("section")));
	CHECK_ZERO_ATTR(a_ils_report_description,			m_data->GetAttrDefinition(e_ils_report, _T("description")));
	CHECK_ZERO_ATTR(a_ils_report_template,				m_data->GetAttrDefinition(e_ils_report, _T("template")));
	CHECK_ZERO_ATTR(a_ils_report_module,				m_data->GetAttrDefinition(e_ils_report, _T("module")));
	CHECK_ZERO_ATTR(a_ils_report_function,				m_data->GetAttrDefinition(e_ils_report, _T("function")));
	CHECK_ZERO_ATTR(a_ils_report_user,					m_data->GetAttrDefinition(e_ils_report, _T("user")));
	CHECK_ZERO_ATTR(a_ils_report_version,				m_data->GetAttrDefinition(e_ils_report, _T("version")));
	CHECK_ZERO_ATTR(a_ils_report_type,					m_data->GetAttrDefinition(e_ils_report, _T("type")));
	CHECK_ZERO_ATTR(a_ils_report_icon_large,			m_data->GetAttrDefinition(e_ils_report, _T("icon_large")));
	CHECK_ZERO_ATTR(a_ils_report_icon_small,			m_data->GetAttrDefinition(e_ils_report, _T("icon_small")));
	CHECK_ZERO_ATTR(a_ils_report_data_class,			m_data->GetAttrDefinition(e_ils_report, _T("data_class")));

	CHECK_ZERO_ATTR(e_ils_base_product,									m_data->GetEntityBN(_T("ils_base_product")));
	CHECK_ZERO_ATTR(a_ils_base_product_id,								m_data->GetAttrDefinition(e_ils_base_product, _T("id")));
	CHECK_ZERO_ATTR(a_ils_base_product_name,							m_data->GetAttrDefinition(e_ils_base_product, _T("name")));
	CHECK_ZERO_ATTR(a_ils_base_product_modify,							m_data->GetAttrDefinition(e_ils_base_product, _T("modify")));
	CHECK_ZERO_ATTR(a_ils_base_product_descr,							m_data->GetAttrDefinition(e_ils_base_product, _T("description")));
	CHECK_ZERO_ATTR(a_ils_base_product_type,							m_data->GetAttrDefinition(e_ils_base_product, _T("type")));
	CHECK_ZERO_ATTR(a_ils_base_product_developer,						m_data->GetAttrDefinition(e_ils_base_product, _T("developer")));
	CHECK_ZERO_ATTR(a_ils_base_product_manufacturer,					m_data->GetAttrDefinition(e_ils_base_product, _T("manufacturer")));
	CHECK_ZERO_ATTR(a_ils_base_product_provider,						m_data->GetAttrDefinition(e_ils_base_product, _T("provider")));
	CHECK_ZERO_ATTR(a_ils_base_product_systems,							m_data->GetAttrDefinition(e_ils_base_product, _T("systems")));
	CHECK_ZERO_ATTR(a_ils_base_product_zones,							m_data->GetAttrDefinition(e_ils_base_product, _T("zones")));
	CHECK_ZERO_ATTR(a_ils_base_product_logbook,							m_data->GetAttrDefinition(e_ils_base_product, _T("logbook")));
	CHECK_ZERO_ATTR(a_ils_base_product_mi,								m_data->GetAttrDefinition(e_ils_base_product, _T("mi")));
	CHECK_ZERO_ATTR(a_ils_base_product_guid,							m_data->GetAttrDefinition(e_ils_base_product, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_base_product_pdf,								m_data->GetAttrDefinition(e_ils_base_product, _T("pdf")));
	CHECK_ZERO_ATTR(a_ils_base_product_price,							m_data->GetAttrDefinition(e_ils_base_product, _T("price")));
	CHECK_ZERO_ATTR(a_ils_base_product_price_unit,						m_data->GetAttrDefinition(e_ils_base_product, _T("price_unit")));
	CHECK_ZERO_ATTR(a_ils_base_product_control_type,					m_data->GetAttrDefinition(e_ils_base_product, _T("control_type")));
	CHECK_ZERO_ATTR(a_ils_base_product_control_value,					m_data->GetAttrDefinition(e_ils_base_product, _T("control_value")));
	CHECK_ZERO_ATTR(a_ils_base_product_exploitation_method,				m_data->GetAttrDefinition(e_ils_base_product, _T("exploitation_method")));
	CHECK_ZERO_ATTR(a_ils_base_product_average_life_refusal,			m_data->GetAttrDefinition(e_ils_base_product, _T("average_life_refusal")));
	CHECK_ZERO_ATTR(a_ils_base_product_par_flow_refusal,				m_data->GetAttrDefinition(e_ils_base_product, _T("par_flow_refusal")));
	CHECK_ZERO_ATTR(a_ils_base_product_average_life_removal,			m_data->GetAttrDefinition(e_ils_base_product, _T("average_life_removal")));
	CHECK_ZERO_ATTR(a_ils_base_product_refusal_count,					m_data->GetAttrDefinition(e_ils_base_product, _T("refusal_count")));
	CHECK_ZERO_ATTR(a_ils_base_product_repairability,					m_data->GetAttrDefinition(e_ils_base_product, _T("repairability")));
	CHECK_ZERO_ATTR(a_ils_base_product_average_time_of_restoration,		m_data->GetAttrDefinition(e_ils_base_product, _T("average_time_of_restoration")));
	CHECK_ZERO_ATTR(a_ils_base_product_chance_refusalless,				m_data->GetAttrDefinition(e_ils_base_product, _T("chance_refusalless")));

	CHECK_ZERO_ATTR(e_ils_lsi,					m_data->GetEntityBN(_T("ils_lsi")));
	CHECK_ZERO_ATTR(a_ils_lsi_lcn,				m_data->GetAttrDefinition(e_ils_lsi, _T("lcn")));
	CHECK_ZERO_ATTR(a_ils_lsi_name,				m_data->GetAttrDefinition(e_ils_lsi, _T("name")));
	CHECK_ZERO_ATTR(a_ils_lsi_description,		m_data->GetAttrDefinition(e_ils_lsi, _T("description")));
	CHECK_ZERO_ATTR(a_ils_lsi_base_product,		m_data->GetAttrDefinition(e_ils_lsi, _T("product")));
	CHECK_ZERO_ATTR(a_ils_lsi_cfi,				m_data->GetAttrDefinition(e_ils_lsi, _T("cfi")));
	CHECK_ZERO_ATTR(a_ils_lsi_system,			m_data->GetAttrDefinition(e_ils_lsi, _T("system")));
	CHECK_ZERO_ATTR(a_ils_lsi_zone,				m_data->GetAttrDefinition(e_ils_lsi, _T("zone")));
	CHECK_ZERO_ATTR(a_ils_lsi_access_place,		m_data->GetAttrDefinition(e_ils_lsi, _T("access_place")));
	CHECK_ZERO_ATTR(a_ils_lsi_amount,			m_data->GetAttrDefinition(e_ils_lsi, _T("amount")));
	CHECK_ZERO_ATTR(a_ils_lsi_min_amount,		m_data->GetAttrDefinition(e_ils_lsi, _T("min_amount")));
	CHECK_ZERO_ATTR(a_ils_lsi_exploit_type,		m_data->GetAttrDefinition(e_ils_lsi, _T("exploit_type")));
	CHECK_ZERO_ATTR(a_ils_lsi_guid,				m_data->GetAttrDefinition(e_ils_lsi, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_lsi_parent,			m_data->GetAttrDefinition(e_ils_lsi, _T("parent")));
	CHECK_ZERO_ATTR(a_ils_lsi_res_by_product,	m_data->GetAttrDefinition(e_ils_lsi, _T("resource_by_product")));
	CHECK_ZERO_ATTR(a_ils_lsi_code,				m_data->GetAttrDefinition(e_ils_lsi, _T("code")));
	CHECK_ZERO_ATTR(a_ils_lsi_auto,				m_data->GetAttrDefinition(e_ils_lsi, _T("auto")));

	CHECK_ZERO_ATTR(e_ils_product_variant,				m_data->GetEntityBN(_T("ils_product_variant")));
	CHECK_ZERO_ATTR(a_ils_product_variant_place,		m_data->GetAttrDefinition(e_ils_product_variant, _T("place")));
	CHECK_ZERO_ATTR(a_ils_product_variant_ils_product,	m_data->GetAttrDefinition(e_ils_product_variant, _T("ils_product")));
	CHECK_ZERO_ATTR(a_ils_product_variant_priority,		m_data->GetAttrDefinition(e_ils_product_variant, _T("priority")));
	CHECK_ZERO_ATTR(a_ils_product_variant_sns,			m_data->GetAttrDefinition(e_ils_product_variant, _T("sns")));
	CHECK_ZERO_ATTR(a_ils_product_variant_comment,		m_data->GetAttrDefinition(e_ils_product_variant, _T("comments")));
	CHECK_ZERO_ATTR(a_ils_product_variant_guid,			m_data->GetAttrDefinition(e_ils_product_variant, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_product_variant_catalog,		m_data->GetAttrDefinition(e_ils_product_variant, _T("catalog")));
	CHECK_ZERO_ATTR(a_ils_product_variant_mi,			m_data->GetAttrDefinition(e_ils_product_variant, _T("mi")));

	/************************************************************************/
	/*                         e_ils_component                              */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_component,						m_data->GetEntityBN(_T("ils_component")));
	CHECK_ZERO_ATTR(a_ils_component_place,					m_data->GetAttrDefinition(e_ils_component, _T("place")));
	CHECK_ZERO_ATTR(a_ils_component_ils_product_instance,	m_data->GetAttrDefinition(e_ils_component, _T("product_instance")));
	CHECK_ZERO_ATTR(a_ils_component_date_install,			m_data->GetAttrDefinition(e_ils_component, _T("date_install")));
	CHECK_ZERO_ATTR(a_ils_component_date_remove,			m_data->GetAttrDefinition(e_ils_component, _T("date_remove")));
	CHECK_ZERO_ATTR(a_ils_component_description,			m_data->GetAttrDefinition(e_ils_component, _T("description")));
	CHECK_ZERO_ATTR(a_ils_component_folder_num,				m_data->GetAttrDefinition(e_ils_component, _T("folder_num")));
	CHECK_ZERO_ATTR(a_ils_component_passport_num,			m_data->GetAttrDefinition(e_ils_component, _T("passport_num")));
	CHECK_ZERO_ATTR(a_ils_component_guid,					m_data->GetAttrDefinition(e_ils_component, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_component_product_owner,			m_data->GetAttrDefinition(e_ils_component, _T("product_owner")));
	CHECK_ZERO_ATTR(a_ils_component_type,					m_data->GetAttrDefinition(e_ils_component, _T("type")));
	CHECK_ZERO_ATTR(a_ils_component_reg_num,				m_data->GetAttrDefinition(e_ils_component, _T("reg_num")));
	CHECK_ZERO_ATTR(a_ils_component_status,					m_data->GetAttrDefinition(e_ils_component, _T("status")));
	CHECK_ZERO_ATTR(a_ils_component_root,					m_data->GetAttrDefinition(e_ils_component, _T("root")));
	CHECK_ZERO_ATTR(a_ils_component_remove_reason,			m_data->GetAttrDefinition(e_ils_component, _T("remove_reason")));
	CHECK_ZERO_ATTR(a_ils_component_basis,					m_data->GetAttrDefinition(e_ils_component, _T("basis")));	

	/************************************************************************/
	/*                         e_ils_change_resource                        */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_change_resource,                     m_data->GetEntityBN(_T("ils_change_resource")));
	CHECK_ZERO_ATTR(a_ils_change_resource_product_instance,    m_data->GetAttrDefinition(e_ils_change_resource, _T("product_instance")));
	CHECK_ZERO_ATTR(a_ils_change_resource_resource_name,       m_data->GetAttrDefinition(e_ils_change_resource, _T("resource_name")));
	CHECK_ZERO_ATTR(a_ils_change_resource_set_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("set_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_set_resource_val,    m_data->GetAttrDefinition(e_ils_change_resource, _T("set_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_type,                m_data->GetAttrDefinition(e_ils_change_resource, _T("type")));
	CHECK_ZERO_ATTR(a_ils_change_resource_basis,               m_data->GetAttrDefinition(e_ils_change_resource, _T("basis")));
	CHECK_ZERO_ATTR(a_ils_change_resource_garantee_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("garantee_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_garantee_resource_val, m_data->GetAttrDefinition(e_ils_change_resource, _T("garantee_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_first_repair_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("first_repair_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_first_repair_resource_val, m_data->GetAttrDefinition(e_ils_change_resource, _T("first_repair_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_between_repair_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("between_repair_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_between_repair_resource_val, m_data->GetAttrDefinition(e_ils_change_resource, _T("between_repair_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_before_set_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("before_set_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_before_set_resource_val, m_data->GetAttrDefinition(e_ils_change_resource, _T("before_set_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_derived_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("derived_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_derived_resource_val, m_data->GetAttrDefinition(e_ils_change_resource, _T("derived_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_last_repair_resource_change, m_data->GetAttrDefinition(e_ils_change_resource, _T("last_repair_resource_change")));
	CHECK_ZERO_ATTR(a_ils_change_resource_last_repair_resource_val, m_data->GetAttrDefinition(e_ils_change_resource, _T("last_repair_resource_val")));
	CHECK_ZERO_ATTR(a_ils_change_resource_actual, m_data->GetAttrDefinition(e_ils_change_resource, _T("actual")));



	/************************************************************************/
	/*                                                                      */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_substitution,				m_data->GetEntityBN(_T("ils_substitution")));
	CHECK_ZERO_ATTR(a_ils_substitution_predsessor,	m_data->GetAttrDefinition(e_ils_substitution, _T("predcessor")));
	CHECK_ZERO_ATTR(a_ils_substitution_sucessor,	m_data->GetAttrDefinition(e_ils_substitution, _T("sucessor")));
	//	CHECK_ZERO_ATTR(a_ils_substitution_job,			m_data->GetAttrDefinition(e_ils_substitution, _T("")));
	CHECK_ZERO_ATTR(a_ils_substitution_reason,		m_data->GetAttrDefinition(e_ils_substitution, _T("reason")));
	CHECK_ZERO_ATTR(a_ils_substitution_description,	m_data->GetAttrDefinition(e_ils_substitution, _T("description")));
	CHECK_ZERO_ATTR(a_ils_substitution_guid,		m_data->GetAttrDefinition(e_ils_substitution, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_substitution_basis,		m_data->GetAttrDefinition(e_ils_substitution, _T("basis")));

	CHECK_ZERO_ATTR(e_ils_lsi_instance,						m_data->GetEntityBN(_T("ils_lsi_instance")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_of_ils_lsi,			m_data->GetAttrDefinition(e_ils_lsi_instance, _T("of_ils_lsi")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_of_product_instance,	m_data->GetAttrDefinition(e_ils_lsi_instance, _T("of_product_instance")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_parent,				m_data->GetAttrDefinition(e_ils_lsi_instance, _T("parent")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_cfi,					m_data->GetAttrDefinition(e_ils_lsi_instance, _T("cfi")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_id,					m_data->GetAttrDefinition(e_ils_lsi_instance, _T("id")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_auto,				m_data->GetAttrDefinition(e_ils_lsi_instance, _T("auto")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_topfull,				m_data->GetAttrDefinition(e_ils_lsi_instance, _T("topfull")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_installed,			m_data->GetAttrDefinition(e_ils_lsi_instance, _T("installed")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_amount,				m_data->GetAttrDefinition(e_ils_lsi_instance, _T("amount")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_has_composition,		m_data->GetAttrDefinition(e_ils_lsi_instance, _T("has_composition")));
	CHECK_ZERO_ATTR(a_ils_lsi_instance_date_remove,			m_data->GetAttrDefinition(e_ils_lsi_instance, _T("date_remove")));

	CHECK_ZERO_ATTR(e_ils_refusal,                              m_data->GetEntityBN(_T("ils_refusal")));
	CHECK_ZERO_ATTR(a_ils_refusal_planer,                       m_data->GetAttrDefinition(e_ils_refusal, _T("planer")));
	CHECK_ZERO_ATTR(a_ils_refusal_refused_instance,             m_data->GetAttrDefinition(e_ils_refusal, _T("refused_instance")));
	CHECK_ZERO_ATTR(a_ils_refusal_date_time,                    m_data->GetAttrDefinition(e_ils_refusal, _T("date_time")));
	CHECK_ZERO_ATTR(a_ils_refusal_description,                  m_data->GetAttrDefinition(e_ils_refusal, _T("description")));
	CHECK_ZERO_ATTR(a_ils_refusal_accepted_arrangements,        m_data->GetAttrDefinition(e_ils_refusal, _T("accepted_arrangements")));
	CHECK_ZERO_ATTR(a_ils_refusal_kun_number,                   m_data->GetAttrDefinition(e_ils_refusal, _T("kun_number")));
	CHECK_ZERO_ATTR(a_ils_refusal_kun_date,                     m_data->GetAttrDefinition(e_ils_refusal, _T("kun_date")));
	CHECK_ZERO_ATTR(a_ils_refusal_need_additional_info,         m_data->GetAttrDefinition(e_ils_refusal, _T("need_additional_info")));
	CHECK_ZERO_ATTR(a_ils_refusal_state,                        m_data->GetAttrDefinition(e_ils_refusal, _T("state")));
	CHECK_ZERO_ATTR(a_ils_refusal_conditions,                   m_data->GetAttrDefinition(e_ils_refusal, _T("conditions")));
	CHECK_ZERO_ATTR(a_ils_refusal_manifestation,                m_data->GetAttrDefinition(e_ils_refusal, _T("manifestation")));
	CHECK_ZERO_ATTR(a_ils_refusal_character,                    m_data->GetAttrDefinition(e_ils_refusal, _T("character")));
	CHECK_ZERO_ATTR(a_ils_refusal_faultreason,                  m_data->GetAttrDefinition(e_ils_refusal, _T("faultreason")));
	CHECK_ZERO_ATTR(a_ils_refusal_method,                       m_data->GetAttrDefinition(e_ils_refusal, _T("method")));
	CHECK_ZERO_ATTR(a_ils_refusal_consequences,                 m_data->GetAttrDefinition(e_ils_refusal, _T("consequences")));
	CHECK_ZERO_ATTR(a_ils_refusal_culprit,                      m_data->GetAttrDefinition(e_ils_refusal, _T("culprit")));
	CHECK_ZERO_ATTR(a_ils_refusal_refusal_type,                 m_data->GetAttrDefinition(e_ils_refusal, _T("refusal_type")));
	CHECK_ZERO_ATTR(a_ils_refusal_incident,                     m_data->GetAttrDefinition(e_ils_refusal, _T("incident")));
	CHECK_ZERO_ATTR(a_ils_refusal_premise,                      m_data->GetAttrDefinition(e_ils_refusal, _T("premise")));
	CHECK_ZERO_ATTR(a_ils_refusal_assembly_instance,            m_data->GetAttrDefinition(e_ils_refusal, _T("assembly_instance")));
	CHECK_ZERO_ATTR(a_ils_refusal_reason_of_delay,				m_data->GetAttrDefinition(e_ils_refusal, _T("reason_of_delay")));
	CHECK_ZERO_ATTR(a_ils_refusal_time_of_delay,				m_data->GetAttrDefinition(e_ils_refusal, _T("time_of_delay")));
	CHECK_ZERO_ATTR(a_ils_refusal_fed_to_developer,				m_data->GetAttrDefinition(e_ils_refusal, _T("fed_to_developer")));
	CHECK_ZERO_ATTR(a_ils_refusal_ignore_in_reliability,		m_data->GetAttrDefinition(e_ils_refusal, _T("ignore_in_reliability")));
	CHECK_ZERO_ATTR(a_ils_refusal_developer_comments,			m_data->GetAttrDefinition(e_ils_refusal, _T("developer_comments")));
	CHECK_ZERO_ATTR(a_ils_refusal_airbase,						m_data->GetAttrDefinition(e_ils_refusal, _T("airbase")));
	CHECK_ZERO_ATTR(a_ils_refusal_person,						m_data->GetAttrDefinition(e_ils_refusal, _T("person")));
	CHECK_ZERO_ATTR(a_ils_refusal_organization,					m_data->GetAttrDefinition(e_ils_refusal, _T("organization")));
	CHECK_ZERO_ATTR(a_ils_refusal_guid,							m_data->GetAttrDefinition(e_ils_refusal, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_refusal_not_check_composition,		m_data->GetAttrDefinition(e_ils_refusal, _T("not_check_composition")));
	CHECK_ZERO_ATTR(a_ils_refusal_date_removal,					m_data->GetAttrDefinition(e_ils_refusal, _T("date_removal")));
	CHECK_ZERO_ATTR(a_ils_refusal_document_str,					m_data->GetAttrDefinition(e_ils_refusal, _T("document_str")));
	CHECK_ZERO_ATTR(a_ils_refusal_document_date,				m_data->GetAttrDefinition(e_ils_refusal, _T("document_date")));
	CHECK_ZERO_ATTR(a_ils_refusal_form_removal,					m_data->GetAttrDefinition(e_ils_refusal, _T("form_removal")));
	CHECK_ZERO_ATTR(a_ils_refusal_search_job_duration,			m_data->GetAttrDefinition(e_ils_refusal, _T("search_job_duration")));
	CHECK_ZERO_ATTR(a_ils_refusal_search_job_idle,				m_data->GetAttrDefinition(e_ils_refusal, _T("search_job_idle")));
	CHECK_ZERO_ATTR(a_ils_refusal_search_job_labor,				m_data->GetAttrDefinition(e_ils_refusal, _T("search_job_labor")));
	CHECK_ZERO_ATTR(a_ils_refusal_search_job_cost,				m_data->GetAttrDefinition(e_ils_refusal, _T("search_job_cost")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_duration,			m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_duration")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_spare_parts_idle,	m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_spare_parts_idle")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_other_idle,		m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_other_idle")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_labor,			m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_labor")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_staff_cost,		m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_staff_cost")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_spare_parts_cost,	m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_spare_parts_cost")));
	CHECK_ZERO_ATTR(a_ils_refusal_removal_job_total_cost,		m_data->GetAttrDefinition(e_ils_refusal, _T("removal_job_total_cost")));
	CHECK_ZERO_ATTR(a_ils_refusal_system,						m_data->GetAttrDefinition(e_ils_refusal, _T("system")));
	CHECK_ZERO_ATTR(a_ils_refusal_zone,							m_data->GetAttrDefinition(e_ils_refusal, _T("zone")));
	CHECK_ZERO_ATTR(a_ils_refusal_access_place,					m_data->GetAttrDefinition(e_ils_refusal, _T("access_place")));
	CHECK_ZERO_ATTR(a_ils_refusal_cfi,							m_data->GetAttrDefinition(e_ils_refusal, _T("cfi")));
	CHECK_ZERO_ATTR(a_ils_refusal_id,							m_data->GetAttrDefinition(e_ils_refusal, _T("id")));

	/************************************************************************/
	/*                         e_ils_executed_job                           */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_executed_job,                     m_data->GetEntityBN(_T("ils_executed_job")));
	CHECK_ZERO_ATTR(a_ils_executed_job_id,					m_data->GetAttrDefinition(e_ils_executed_job, _T("id")));
	CHECK_ZERO_ATTR(a_ils_executed_job_name,				m_data->GetAttrDefinition(e_ils_executed_job, _T("name")));
	CHECK_ZERO_ATTR(a_ils_executed_job_descr,				m_data->GetAttrDefinition(e_ils_executed_job, _T("description")));
	CHECK_ZERO_ATTR(a_ils_executed_job_type,				m_data->GetAttrDefinition(e_ils_executed_job, _T("type")));
	CHECK_ZERO_ATTR(a_ils_executed_job_planer,				m_data->GetAttrDefinition(e_ils_executed_job, _T("planer")));
	CHECK_ZERO_ATTR(a_ils_executed_job_date_begin,			m_data->GetAttrDefinition(e_ils_executed_job, _T("date_begin")));
	CHECK_ZERO_ATTR(a_ils_executed_job_date_end,			m_data->GetAttrDefinition(e_ils_executed_job, _T("date_end")));
	CHECK_ZERO_ATTR(a_ils_executed_job_labor,				m_data->GetAttrDefinition(e_ils_executed_job, _T("labor")));
	CHECK_ZERO_ATTR(a_ils_executed_job_price,				m_data->GetAttrDefinition(e_ils_executed_job, _T("price")));
	CHECK_ZERO_ATTR(a_ils_executed_job_item,				m_data->GetAttrDefinition(e_ils_executed_job, _T("item")));
	CHECK_ZERO_ATTR(a_ils_executed_job_duration,			m_data->GetAttrDefinition(e_ils_executed_job, _T("duration")));
	CHECK_ZERO_ATTR(a_ils_executed_job_executer,			m_data->GetAttrDefinition(e_ils_executed_job, _T("executer")));
	CHECK_ZERO_ATTR(a_ils_executed_job_bulletin_executer,	m_data->GetAttrDefinition(e_ils_executed_job, _T("bulletin_executer")));

	/************************************************************************/
	/*					     			*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_executed_job_attachment,			m_data->GetEntityBN(_T("ils_executed_job_attachment")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_type,		m_data->GetAttrDefinition(e_ils_executed_job_attachment, _T("type")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_of_job,	m_data->GetAttrDefinition(e_ils_executed_job_attachment, _T("of_job")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_price,	m_data->GetAttrDefinition(e_ils_executed_job_attachment, _T("price")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_comment,	m_data->GetAttrDefinition(e_ils_executed_job_attachment, _T("comment")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_num,		m_data->GetAttrDefinition(e_ils_executed_job_attachment, _T("num")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_guid,		m_data->GetAttrDefinition(e_ils_executed_job_attachment, _T("guid")));

	/************************************************************************/
	/*					  							*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_executed_job_attachment_pos,				m_data->GetEntityBN(_T("ils_executed_job_attachment_pos")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_pos_task_id,		m_data->GetAttrDefinition(e_ils_executed_job_attachment_pos, _T("task_id")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_pos_task_name,	m_data->GetAttrDefinition(e_ils_executed_job_attachment_pos, _T("task_name")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_pos_task,			m_data->GetAttrDefinition(e_ils_executed_job_attachment_pos, _T("task")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_pos_labor,		m_data->GetAttrDefinition(e_ils_executed_job_attachment_pos, _T("labor")));

	/************************************************************************/
	/*								  							*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_executed_job_attachment_moves,			m_data->GetEntityBN(_T("ils_executed_job_attachment_moves")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_moves_remove,		m_data->GetAttrDefinition(e_ils_executed_job_attachment_moves, _T("remove")));
	CHECK_ZERO_ATTR(a_ils_executed_job_attachment_moves_install,	m_data->GetAttrDefinition(e_ils_executed_job_attachment_moves, _T("install")));

	/************************************************************************/
	/*								  								*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_software_version_item,					m_data->GetEntityBN(_T("ils_software_version_item")));
	CHECK_ZERO_ATTR(a_ils_software_version_item_of_ils_product,		m_data->GetAttrDefinition(e_ils_software_version_item, _T("of_ils_product")));
	CHECK_ZERO_ATTR(a_ils_software_version_item_value,				m_data->GetAttrDefinition(e_ils_software_version_item, _T("value")));

	/************************************************************************/
	/*								CFI 									*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_cfi,				m_data->GetEntityBN(_T("ils_cfi")));
	CHECK_ZERO_ATTR(a_ils_cfi_id,			m_data->GetAttrDefinition(e_ils_cfi, _T("id")));
	CHECK_ZERO_ATTR(a_ils_cfi_of_planer,	m_data->GetAttrDefinition(e_ils_cfi, _T("of_planer")));
	CHECK_ZERO_ATTR(a_ils_cfi_of_lsi,		m_data->GetAttrDefinition(e_ils_cfi, _T("of_lsi")));

	CHECK_ZERO_ATTR(e_ils_resource_correct,				m_data->GetEntityBN(_T("ils_resource_correct")));
	CHECK_ZERO_ATTR(a_ils_resource_correct_of_item,		m_data->GetAttrDefinition(e_ils_resource_correct, _T("of_item")));
	CHECK_ZERO_ATTR(a_ils_resource_correct_date_time,	m_data->GetAttrDefinition(e_ils_resource_correct, _T("date_time")));
	CHECK_ZERO_ATTR(a_ils_resource_correct_comments,	m_data->GetAttrDefinition(e_ils_resource_correct, _T("comments")));
	CHECK_ZERO_ATTR(a_ils_resource_correct_guid,		m_data->GetAttrDefinition(e_ils_resource_correct, _T("guid")));
	CHECK_ZERO_ATTR(a_ils_resource_correct_basis,		m_data->GetAttrDefinition(e_ils_resource_correct, _T("basis")));
	CHECK_ZERO_ATTR(a_ils_resource_correct_type,		m_data->GetAttrDefinition(e_ils_resource_correct, _T("type")));

	CHECK_ZERO_ATTR(e_ils_applicability_rule,			m_data->GetEntityBN(_T("ils_applicability_rule")));
	CHECK_ZERO_ATTR(a_ils_applicability_rule_id,		m_data->GetAttrDefinition(e_ils_applicability_rule, _T("id")));
	CHECK_ZERO_ATTR(a_ils_applicability_rule_name,		m_data->GetAttrDefinition(e_ils_applicability_rule, _T("name")));
	CHECK_ZERO_ATTR(a_ils_applicability_rule_item,		m_data->GetAttrDefinition(e_ils_applicability_rule, _T("item")));
	CHECK_ZERO_ATTR(a_ils_applicability_rule_invert,	m_data->GetAttrDefinition(e_ils_applicability_rule, _T("invert")));

	CHECK_ZERO_ATTR(e_ils_applicability_rule_object,		m_data->GetEntityBN(_T("ils_applicability_rule_object")));
	CHECK_ZERO_ATTR(a_ils_applicability_rule_object_object,	m_data->GetAttrDefinition(e_ils_applicability_rule_object, _T("object")));

	/************************************************************************/
	/*								                  */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_planer_state,						m_data->GetEntityBN(_T("ils_planer_state")));
	CHECK_ZERO_ATTR(a_ils_planer_state_planer,				m_data->GetAttrDefinition(e_ils_planer_state, _T("planer")));
	CHECK_ZERO_ATTR(a_ils_planer_state_date,				m_data->GetAttrDefinition(e_ils_planer_state, _T("date")));
	CHECK_ZERO_ATTR(a_ils_planer_state_date_end,			m_data->GetAttrDefinition(e_ils_planer_state, _T("date_end")));
	CHECK_ZERO_ATTR(a_ils_planer_state_date_planned,		m_data->GetAttrDefinition(e_ils_planer_state, _T("date_planned")));
	CHECK_ZERO_ATTR(a_ils_planer_state_description,			m_data->GetAttrDefinition(e_ils_planer_state, _T("description")));
	CHECK_ZERO_ATTR(a_ils_planer_state_state,				m_data->GetAttrDefinition(e_ils_planer_state, _T("state")));
	CHECK_ZERO_ATTR(a_ils_planer_state_res_hour,			m_data->GetAttrDefinition(e_ils_planer_state, _T("resource_hour")));
	CHECK_ZERO_ATTR(a_ils_planer_state_res_flight,			m_data->GetAttrDefinition(e_ils_planer_state, _T("resource_flight")));
	CHECK_ZERO_ATTR(a_ils_planer_state_res_hour_month,		m_data->GetAttrDefinition(e_ils_planer_state, _T("resource_hour_month")));
	CHECK_ZERO_ATTR(a_ils_planer_state_res_flight_month,	m_data->GetAttrDefinition(e_ils_planer_state, _T("resource_flight_month")));
	CHECK_ZERO_ATTR(a_ils_planer_state_maint_prog,			m_data->GetAttrDefinition(e_ils_planer_state, _T("maint_prog")));
	CHECK_ZERO_ATTR(a_ils_planer_state_maint_prog_set,		m_data->GetAttrDefinition(e_ils_planer_state, _T("maint_prog_set")));
	CHECK_ZERO_ATTR(a_ils_planer_state_problem_text,		m_data->GetAttrDefinition(e_ils_planer_state, _T("problem_text")));
	CHECK_ZERO_ATTR(a_ils_planer_state_active_work_time,	m_data->GetAttrDefinition(e_ils_planer_state, _T("active_work_time")));
	CHECK_ZERO_ATTR(a_ils_planer_state_spare_down_time,		m_data->GetAttrDefinition(e_ils_planer_state, _T("spare_down_time")));
	CHECK_ZERO_ATTR(a_ils_planer_state_other_down_time,		m_data->GetAttrDefinition(e_ils_planer_state, _T("other_down_time")));
	CHECK_ZERO_ATTR(a_ils_planer_state_responser,			m_data->GetAttrDefinition(e_ils_planer_state, _T("responser")));
	CHECK_ZERO_ATTR(a_ils_planer_state_ready,				m_data->GetAttrDefinition(e_ils_planer_state, _T("ready")));

	/************************************************************************/
	/*				C                 */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_state_refusal_link,					m_data->GetEntityBN(_T("ils_state_refusal_link")));
	CHECK_ZERO_ATTR(a_ils_state_refusal_link_state,				m_data->GetAttrDefinition(e_ils_state_refusal_link, _T("state")));
	CHECK_ZERO_ATTR(a_ils_state_refusal_link_refusal,			m_data->GetAttrDefinition(e_ils_state_refusal_link, _T("refusal")));


	/************************************************************************/
	/*				C             */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_state_component_link,					m_data->GetEntityBN(_T("ils_state_component_link")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_state,			m_data->GetAttrDefinition(e_ils_state_component_link, _T("state")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_component,		m_data->GetAttrDefinition(e_ils_state_component_link, _T("component")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_instance,		m_data->GetAttrDefinition(e_ils_state_component_link, _T("instance")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_type,			m_data->GetAttrDefinition(e_ils_state_component_link, _T("type")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_date_begin,		m_data->GetAttrDefinition(e_ils_state_component_link, _T("date_begin")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_date_planned,	m_data->GetAttrDefinition(e_ils_state_component_link, _T("date_planned")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_date_end,		m_data->GetAttrDefinition(e_ils_state_component_link, _T("date_end")));
	CHECK_ZERO_ATTR(a_ils_state_component_link_result,		m_data->GetAttrDefinition(e_ils_state_component_link, _T("result")));

	/************************************************************************/
	/*				   		                */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_planer_state_refusal,							m_data->GetEntityBN(_T("ils_planer_state_refusal")));
	CHECK_ZERO_ATTR(a_ils_planer_state_refusal_planer,					m_data->GetAttrDefinition(e_ils_planer_state_refusal, _T("planer")));
	CHECK_ZERO_ATTR(a_ils_planer_state_refusal_description,				m_data->GetAttrDefinition(e_ils_planer_state_refusal, _T("description")));
	CHECK_ZERO_ATTR(a_ils_planer_state_refusal_date,					m_data->GetAttrDefinition(e_ils_planer_state_refusal, _T("date")));
	CHECK_ZERO_ATTR(a_ils_planer_state_refusal_date_removal,			m_data->GetAttrDefinition(e_ils_planer_state_refusal, _T("date_removal")));
	CHECK_ZERO_ATTR(a_ils_planer_state_refusal_critical,				m_data->GetAttrDefinition(e_ils_planer_state_refusal, _T("critical")));
	CHECK_ZERO_ATTR(a_ils_planer_state_refusal_accepted_arragements,	m_data->GetAttrDefinition(e_ils_planer_state_refusal, _T("accepted_arragements")));
	/************************************************************************/
	/*                 LSS_EXECUTED_JOBS                                    */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_lss_executed_job,							m_data->GetEntityBN(_T("lss_executed_job")));
	CHECK_ZERO_ATTR(a_lss_executed_job_id,						m_data->GetAttrDefinition(e_lss_executed_job, _T("id")));
	CHECK_ZERO_ATTR(a_lss_executed_job_planer,					m_data->GetAttrDefinition(e_lss_executed_job, _T("planer")));
	CHECK_ZERO_ATTR(a_lss_executed_job_bulletin,				m_data->GetAttrDefinition(e_lss_executed_job, _T("bulletin")));
	CHECK_ZERO_ATTR(a_lss_executed_job_date_begin,				m_data->GetAttrDefinition(e_lss_executed_job, _T("date_begin")));
	CHECK_ZERO_ATTR(a_lss_executed_job_date_end,				m_data->GetAttrDefinition(e_lss_executed_job, _T("date_end")));
	CHECK_ZERO_ATTR(a_lss_executed_job_description,				m_data->GetAttrDefinition(e_lss_executed_job, _T("description")));
	CHECK_ZERO_ATTR(a_lss_executed_job_labor,					m_data->GetAttrDefinition(e_lss_executed_job, _T("labor")));
	CHECK_ZERO_ATTR(a_lss_executed_job_duration,				m_data->GetAttrDefinition(e_lss_executed_job, _T("duration")));
	CHECK_ZERO_ATTR(a_lss_executed_job_personnel_costs,			m_data->GetAttrDefinition(e_lss_executed_job, _T("personnel_costs")));
	CHECK_ZERO_ATTR(a_lss_executed_job_price,					m_data->GetAttrDefinition(e_lss_executed_job, _T("price")));
	CHECK_ZERO_ATTR(a_lss_executed_job_refusal_select,			m_data->GetAttrDefinition(e_lss_executed_job, _T("refusal_select")));
	CHECK_ZERO_ATTR(a_lss_executed_job_price_unit,				m_data->GetAttrDefinition(e_lss_executed_job, _T("price_unit")));
	CHECK_ZERO_ATTR(a_lss_executed_job_duration_unit,			m_data->GetAttrDefinition(e_lss_executed_job, _T("duration_unit")));
	CHECK_ZERO_ATTR(a_lss_executed_job_labor_unit,				m_data->GetAttrDefinition(e_lss_executed_job, _T("labor_unit")));
	CHECK_ZERO_ATTR(a_lss_executed_job_service_type,			m_data->GetAttrDefinition(e_lss_executed_job, _T("service_type")));
	CHECK_ZERO_ATTR(a_lss_executed_job_order_type,				m_data->GetAttrDefinition(e_lss_executed_job, _T("order_type")));
	CHECK_ZERO_ATTR(a_lss_executed_job_class,					m_data->GetAttrDefinition(e_lss_executed_job, _T("class")));
	CHECK_ZERO_ATTR(a_lss_executed_job_price_of_spare_parts,	m_data->GetAttrDefinition(e_lss_executed_job, _T("price_of_spare_parts")));
	CHECK_ZERO_ATTR(a_lss_executed_job_price_of_consumables,	m_data->GetAttrDefinition(e_lss_executed_job, _T("price_of_consumables")));
	CHECK_ZERO_ATTR(a_lss_executed_job_of_item,					m_data->GetAttrDefinition(e_lss_executed_job, _T("of_item")));
	CHECK_ZERO_ATTR(a_lss_executed_job_of_item_installed,		m_data->GetAttrDefinition(e_lss_executed_job, _T("of_item_installed")));
	CHECK_ZERO_ATTR(a_lss_executed_job_of_item_count,			m_data->GetAttrDefinition(e_lss_executed_job, _T("item_count")));
	CHECK_ZERO_ATTR(a_lss_executed_job_downtime_waiting_for_spares,	m_data->GetAttrDefinition(e_lss_executed_job, _T("downtime_waiting_for_spares")));
	CHECK_ZERO_ATTR(a_lss_executed_job_parent,					m_data->GetAttrDefinition(e_lss_executed_job, _T("parent")));
	CHECK_ZERO_ATTR(a_lss_executed_job_place_lvl,				m_data->GetAttrDefinition(e_lss_executed_job, _T("place")));
	CHECK_ZERO_ATTR(a_lss_executed_job_place_org,				m_data->GetAttrDefinition(e_lss_executed_job, _T("place_org")));
	CHECK_ZERO_ATTR(a_lss_executed_job_wait_reason_lvl,			m_data->GetAttrDefinition(e_lss_executed_job, _T("wait_reason")));
	CHECK_ZERO_ATTR(a_lss_executed_job_performer_lvl,			m_data->GetAttrDefinition(e_lss_executed_job, _T("performer")));
	CHECK_ZERO_ATTR(a_lss_executed_job_executor_org,			m_data->GetAttrDefinition(e_lss_executed_job, _T("executor_org")));
	CHECK_ZERO_ATTR(a_lss_executed_job_repair_type,				m_data->GetAttrDefinition(e_lss_executed_job, _T("repair_type")));	
	CHECK_ZERO_ATTR(a_lss_executed_job_scenario,				m_data->GetAttrDefinition(e_lss_executed_job, _T("scenario")));	
	CHECK_ZERO_ATTR(a_lss_executed_job_personnel_count,			m_data->GetAttrDefinition(e_lss_executed_job, _T("personnel_count")));	
	CHECK_ZERO_ATTR(a_lss_executed_job_wait_time_before_start,	m_data->GetAttrDefinition(e_lss_executed_job, _T("wait_time_before_start")));	
	CHECK_ZERO_ATTR(a_lss_executed_job_duration_search,			m_data->GetAttrDefinition(e_lss_executed_job, _T("duration_search")));
	CHECK_ZERO_ATTR(a_lss_executed_job_process_chart,			m_data->GetAttrDefinition(e_lss_executed_job, _T("process_chart")));

	CHECK_ZERO_ATTR(e_lss_executed_periodical_job,						m_data->GetEntityBN(_T("lss_executed_periodical_job")));
	CHECK_ZERO_ATTR(a_lss_executed_periodical_job_type,					m_data->GetAttrDefinition(e_lss_executed_periodical_job, _T("type")));
	CHECK_ZERO_ATTR(a_lss_executed_periodical_job_cost_of_spare_parts,	m_data->GetAttrDefinition(e_lss_executed_periodical_job, _T("lss_cost_of_spare_parts")));

	CHECK_ZERO_ATTR(e_lss_executed_replacement_job,							m_data->GetEntityBN(_T("lss_executed_replacement_job")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_type,					m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("type")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_item_type,				m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("item_type")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_system,					m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("system")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_item,					m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("item")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_name,					m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("name")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_of_job,					m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("of_job")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_cost_of_spare_parts,		m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("lss_cost_of_spare_parts")));
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_cost_of_consumables,		m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("lss_cost_of_consumables"))); 
	CHECK_ZERO_ATTR(a_lss_executed_replacement_job_cost_of_repair,			m_data->GetAttrDefinition(e_lss_executed_replacement_job, _T("lss_cost_of_repair")));

	CHECK_ZERO_ATTR(e_lss_executed_maintenance_job,							m_data->GetEntityBN(_T("lss_executed_maintenance_job")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_type,					m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("type")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_cause,					m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("cause")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_system,					m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("system")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_item,					m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("item")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_name,					m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("name")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_of_job,					m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("of_job")));
	CHECK_ZERO_ATTR(a_lss_executed_maintenance_job_cost_of_consumables,		m_data->GetAttrDefinition(e_lss_executed_maintenance_job, _T("lss_cost_of_consumables")));

	CHECK_ZERO_ATTR(e_lss_executed_operational_job,							m_data->GetEntityBN(_T("lss_executed_operational_job")));
	CHECK_ZERO_ATTR(a_lss_executed_operational_job_type,					m_data->GetAttrDefinition(e_lss_executed_operational_job, _T("type")));
	CHECK_ZERO_ATTR(a_lss_executed_operational_job_cost_of_consumables,		m_data->GetAttrDefinition(e_lss_executed_operational_job, _T("cost_of_consumables")));
	CHECK_ZERO_ATTR(a_lss_executed_operational_job_amount,					m_data->GetAttrDefinition(e_lss_executed_operational_job, _T("amount")));
	CHECK_ZERO_ATTR(a_lss_executed_operational_job_avg_labor,				m_data->GetAttrDefinition(e_lss_executed_operational_job, _T("avg_labor")));
	CHECK_ZERO_ATTR(a_lss_executed_operational_job_avg_durational,			m_data->GetAttrDefinition(e_lss_executed_operational_job, _T("avg_duration")));
	CHECK_ZERO_ATTR(a_lss_executed_operational_job_avg_cost,				m_data->GetAttrDefinition(e_lss_executed_operational_job, _T("avg_cost")));

	CHECK_ZERO_ATTR(e_lss_executed_refusal_search_job,						m_data->GetEntityBN(_T("lss_executed_refusal_search_job")));
	CHECK_ZERO_ATTR(a_lss_executed_refusal_search_job_type,					m_data->GetAttrDefinition(e_lss_executed_refusal_search_job, _T("type")));

	/************************************************************************/
	/*	                                                  */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_consumption,										m_data->GetEntityBN(_T("ils_consumption")));
	CHECK_ZERO_ATTR(a_ils_consumption_id,									m_data->GetAttrDefinition(e_ils_consumption, _T("id")));
	CHECK_ZERO_ATTR(a_ils_consumption_name,									m_data->GetAttrDefinition(e_ils_consumption, _T("name")));
	CHECK_ZERO_ATTR(a_ils_consumption_description,							m_data->GetAttrDefinition(e_ils_consumption, _T("description")));
	CHECK_ZERO_ATTR(a_ils_consumption_external_id,							m_data->GetAttrDefinition(e_ils_consumption, _T("external_id")));
	CHECK_ZERO_ATTR(a_ils_consumption_standard,								m_data->GetAttrDefinition(e_ils_consumption, _T("standard")));
	CHECK_ZERO_ATTR(a_ils_consumption_is_standart,							m_data->GetAttrDefinition(e_ils_consumption, _T("is_standart")));
	CHECK_ZERO_ATTR(a_ils_consumption_nsn,									m_data->GetAttrDefinition(e_ils_consumption, _T("nsn")));
	CHECK_ZERO_ATTR(a_ils_consumption_manufacturer,							m_data->GetAttrDefinition(e_ils_consumption, _T("manufacturer")));
	CHECK_ZERO_ATTR(a_ils_consumption_supplier,								m_data->GetAttrDefinition(e_ils_consumption, _T("supplier")));
	CHECK_ZERO_ATTR(a_ils_consumption_estimated_consumption_rate,			m_data->GetAttrDefinition(e_ils_consumption, _T("estimated_consumption_rate")));
	CHECK_ZERO_ATTR(a_ils_consumption_unit,									m_data->GetAttrDefinition(e_ils_consumption, _T("unit")));
	CHECK_ZERO_ATTR(a_ils_consumption_make_or_buy,							m_data->GetAttrDefinition(e_ils_consumption, _T("make_or_buy")));
	CHECK_ZERO_ATTR(a_ils_consumption_requires_cataloging,					m_data->GetAttrDefinition(e_ils_consumption, _T("requires_cataloging")));

	/************************************************************************/
	/*	                                            */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_equipment,										m_data->GetEntityBN(_T("ils_equipment")));
	CHECK_ZERO_ATTR(a_ils_equipment_id,										m_data->GetAttrDefinition(e_ils_equipment, _T("id")));
	CHECK_ZERO_ATTR(a_ils_equipment_name,									m_data->GetAttrDefinition(e_ils_equipment, _T("name")));
	CHECK_ZERO_ATTR(a_ils_equipment_description,							m_data->GetAttrDefinition(e_ils_equipment, _T("description")));
	CHECK_ZERO_ATTR(a_ils_equipment_external_id,							m_data->GetAttrDefinition(e_ils_equipment, _T("external_id")));
	CHECK_ZERO_ATTR(a_ils_equipment_is_standard,							m_data->GetAttrDefinition(e_ils_equipment, _T("is_standard")));
	CHECK_ZERO_ATTR(a_ils_equipment_nsn,									m_data->GetAttrDefinition(e_ils_equipment, _T("nsn")));
	CHECK_ZERO_ATTR(a_ils_equipment_manufacturer,							m_data->GetAttrDefinition(e_ils_equipment, _T("manufacturer")));
	CHECK_ZERO_ATTR(a_ils_equipment_supplier,								m_data->GetAttrDefinition(e_ils_equipment, _T("supplier")));
	CHECK_ZERO_ATTR(a_ils_equipment_type,									m_data->GetAttrDefinition(e_ils_equipment, _T("type")));
	CHECK_ZERO_ATTR(a_ils_equipment_make_or_buy,							m_data->GetAttrDefinition(e_ils_equipment, _T("make_or_buy")));
	CHECK_ZERO_ATTR(a_ils_equipment_standard,								m_data->GetAttrDefinition(e_ils_equipment, _T("standard")));
	CHECK_ZERO_ATTR(a_ils_equipment_requires_cataloging,					m_data->GetAttrDefinition(e_ils_equipment, _T("requires_cataloging")));

	/************************************************************************/
	/*	                                                */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_process_chart,									m_data->GetEntityBN(_T("ils_process_chart")));
	CHECK_ZERO_ATTR(a_ils_process_chart_id_mrbr,							m_data->GetAttrDefinition(e_ils_process_chart, _T("id_mrbr")));
	CHECK_ZERO_ATTR(a_ils_process_chart_id_mpd,								m_data->GetAttrDefinition(e_ils_process_chart, _T("id_mpd")));
	CHECK_ZERO_ATTR(a_ils_process_chart_name,								m_data->GetAttrDefinition(e_ils_process_chart, _T("name")));
	CHECK_ZERO_ATTR(a_ils_process_chart_name_eng,							m_data->GetAttrDefinition(e_ils_process_chart, _T("name_eng")));
	CHECK_ZERO_ATTR(a_ils_process_chart_ata,								m_data->GetAttrDefinition(e_ils_process_chart, _T("ata")));
	CHECK_ZERO_ATTR(a_ils_process_chart_type,								m_data->GetAttrDefinition(e_ils_process_chart, _T("type")));
	CHECK_ZERO_ATTR(a_ils_process_chart_labour_unit,						m_data->GetAttrDefinition(e_ils_process_chart, _T("labour_unit")));
	CHECK_ZERO_ATTR(a_ils_process_chart_labour_full,						m_data->GetAttrDefinition(e_ils_process_chart, _T("labour_full")));
	CHECK_ZERO_ATTR(a_ils_process_chart_labour_full_or_parts,				m_data->GetAttrDefinition(e_ils_process_chart, _T("labour_full_or_parts")));
	CHECK_ZERO_ATTR(a_ils_process_chart_labour_execution,					m_data->GetAttrDefinition(e_ils_process_chart, _T("labour_execution")));
	CHECK_ZERO_ATTR(a_ils_process_chart_labour_access,						m_data->GetAttrDefinition(e_ils_process_chart, _T("labour_access")));
	CHECK_ZERO_ATTR(a_ils_process_chart_actual_ls_obj_link,					m_data->GetAttrDefinition(e_ils_process_chart, _T("actual_ls_obj_link")));
	CHECK_ZERO_ATTR(a_ils_process_chart_dm_code,							m_data->GetAttrDefinition(e_ils_process_chart, _T("dm_code")));
	CHECK_ZERO_ATTR(a_ils_process_chart_dm_info_link,						m_data->GetAttrDefinition(e_ils_process_chart, _T("dm_info_code")));
	CHECK_ZERO_ATTR(a_ils_process_chart_mean_time_work,						m_data->GetAttrDefinition(e_ils_process_chart, _T("mean_time_work")));
	CHECK_ZERO_ATTR(a_ils_process_chart_executor_count,						m_data->GetAttrDefinition(e_ils_process_chart, _T("executor_count")));
	CHECK_ZERO_ATTR(a_ils_process_chart_ssi_analysis_type,					m_data->GetAttrDefinition(e_ils_process_chart, _T("ssi_analysis_type")));
	CHECK_ZERO_ATTR(a_ils_process_chart_zvi_analysis_type,					m_data->GetAttrDefinition(e_ils_process_chart, _T("zvi_analysis_type")));
	CHECK_ZERO_ATTR(a_ils_process_chart_msi_analysis_type,					m_data->GetAttrDefinition(e_ils_process_chart, _T("msi_analysis_type")));
	CHECK_ZERO_ATTR(a_ils_process_chart_task_interval_source,				m_data->GetAttrDefinition(e_ils_process_chart, _T("task_interval_source")));
	CHECK_ZERO_ATTR(a_ils_process_chart_requirement_source,					m_data->GetAttrDefinition(e_ils_process_chart, _T("requirement_source")));
	CHECK_ZERO_ATTR(a_ils_process_chart_consumables_price,					m_data->GetAttrDefinition(e_ils_process_chart, _T("consumables_price")));
	CHECK_ZERO_ATTR(a_ils_process_chart_price_currency,						m_data->GetAttrDefinition(e_ils_process_chart, _T("price_currency")));

	/************************************************************************/
	/*	                       */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_process_chart_applicability,						m_data->GetEntityBN(_T("ils_process_chart_applicability")));	
	CHECK_ZERO_ATTR(a_ils_process_chart_fi,									m_data->GetAttrDefinition(e_ils_process_chart_applicability, _T("fi")));		
	CHECK_ZERO_ATTR(a_ils_process_chart_config,								m_data->GetAttrDefinition(e_ils_process_chart_applicability, _T("config")));	
	CHECK_ZERO_ATTR(a_ils_process_chart_pc,									m_data->GetAttrDefinition(e_ils_process_chart_applicability, _T("pc")));		

	/************************************************************************/
	/*	                                                   */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_time_interval,									m_data->GetEntityBN(_T("ils_time_interval")));
	CHECK_ZERO_ATTR(a_ils_time_interval_type,								m_data->GetAttrDefinition(e_ils_time_interval, _T("type")));
	CHECK_ZERO_ATTR(a_ils_time_interval_value,								m_data->GetAttrDefinition(e_ils_time_interval, _T("value")));
	CHECK_ZERO_ATTR(a_ils_time_interval_plus,								m_data->GetAttrDefinition(e_ils_time_interval, _T("plus")));
	CHECK_ZERO_ATTR(a_ils_time_interval_minus,								m_data->GetAttrDefinition(e_ils_time_interval, _T("minus")));
	CHECK_ZERO_ATTR(a_ils_time_interval_unit,								m_data->GetAttrDefinition(e_ils_time_interval, _T("unit")));
	CHECK_ZERO_ATTR(a_ils_time_interval_object,								m_data->GetAttrDefinition(e_ils_time_interval, _T("object")));
	CHECK_ZERO_ATTR(a_ils_time_interval_delay,								m_data->GetAttrDefinition(e_ils_time_interval, _T("delay")));
	CHECK_ZERO_ATTR(a_ils_time_interval_info,								m_data->GetAttrDefinition(e_ils_time_interval, _T("info")));
	CHECK_ZERO_ATTR(a_ils_time_interval_first,								m_data->GetAttrDefinition(e_ils_time_interval, _T("first")));

	/************************************************************************/
	/*	                        */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_maint_prog_item_proc_chart_relation,				m_data->GetEntityBN(_T("ils_maint_prog_item_proc_chart_relation")));
	CHECK_ZERO_ATTR(a_ils_maint_prog_item_proc_chart_relation_maintenance_program_item,m_data->GetAttrDefinition(e_ils_maint_prog_item_proc_chart_relation, _T("maint_prog_item")));
	CHECK_ZERO_ATTR(a_ils_maint_prog_item_proc_chart_relation_process_chart,m_data->GetAttrDefinition(e_ils_maint_prog_item_proc_chart_relation, _T("process_chart")));
	CHECK_ZERO_ATTR(a_ils_maint_prog_item_proc_chart_relation_position,m_data->GetAttrDefinition(e_ils_maint_prog_item_proc_chart_relation, _T("position")));
	

	/************************************************************************/
	/*	                       MRBR											*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_mrbr,							m_data->GetEntityBN(_T("ils_mrbr_list")));
	CHECK_ZERO_ATTR(a_ils_mrbr_id,						m_data->GetAttrDefinition(e_ils_mrbr, _T("id")));
	CHECK_ZERO_ATTR(a_ils_mrbr_fi,						m_data->GetAttrDefinition(e_ils_mrbr, _T("fi")));
	CHECK_ZERO_ATTR(a_ils_mrbr_config,					m_data->GetAttrDefinition(e_ils_mrbr, _T("config")));
	CHECK_ZERO_ATTR(a_ils_mrbr_date,					m_data->GetAttrDefinition(e_ils_mrbr, _T("date")));

	/************************************************************************/
	/*	                        MRBR  						*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_mrbr_pc_link,					m_data->GetEntityBN(_T("mrbr_pc_link")));
	CHECK_ZERO_ATTR(a_ils_mrbr_pc_link_mrbr,			m_data->GetAttrDefinition(e_ils_mrbr_pc_link, _T("mrbr")));
	CHECK_ZERO_ATTR(a_ils_mrbr_pc_link_pc,				m_data->GetAttrDefinition(e_ils_mrbr_pc_link, _T("pc")));

	/************************************************************************/
	/*	                       MPD						                    */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_mpd,							m_data->GetEntityBN(_T("ils_mpd_list")));
	CHECK_ZERO_ATTR(a_ils_mpd_id,						m_data->GetAttrDefinition(e_ils_mpd, _T("id")));
	CHECK_ZERO_ATTR(a_ils_mpd_fi,						m_data->GetAttrDefinition(e_ils_mpd, _T("fi")));
	CHECK_ZERO_ATTR(a_ils_mpd_config,					m_data->GetAttrDefinition(e_ils_mpd, _T("config")));
	CHECK_ZERO_ATTR(a_ils_mpd_date,						m_data->GetAttrDefinition(e_ils_mpd, _T("date")));
	
	/************************************************************************/
	/*	                        MPD  	                    */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_mpd_pc_link,					m_data->GetEntityBN(_T("mpd_pc_link")));
	CHECK_ZERO_ATTR(a_ils_mpd_pc_link_mpd,				m_data->GetAttrDefinition(e_ils_mpd_pc_link, _T("mpd")));
	CHECK_ZERO_ATTR(a_ils_mpd_pc_link_pc,				m_data->GetAttrDefinition(e_ils_mpd_pc_link, _T("pc")));

	/************************************************************************/
	/*                         LSS REFUSAL_DEFECTIVE_ITEM                   */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_lss_refusal_defective_item,							m_data->GetEntityBN(_T("lss_refusal_defective_item")));
	CHECK_ZERO_ATTR(a_lss_refusal_defective_item_product,					m_data->GetAttrDefinition(e_lss_refusal_defective_item, _T("product")));
	CHECK_ZERO_ATTR(a_lss_refusal_defective_item_serial_number,				m_data->GetAttrDefinition(e_lss_refusal_defective_item, _T("serial_number")));
	CHECK_ZERO_ATTR(a_lss_refusal_defective_item_place,						m_data->GetAttrDefinition(e_lss_refusal_defective_item, _T("place")));
	CHECK_ZERO_ATTR(a_lss_refusal_defective_item_confirm,					m_data->GetAttrDefinition(e_lss_refusal_defective_item, _T("confirm")));
	CHECK_ZERO_ATTR(a_lss_refusal_defective_item_of_ils_product,			m_data->GetAttrDefinition(e_lss_refusal_defective_item, _T("of_ils_product")));

	/************************************************************************/
	/*                         e_ils_flight                                 */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_lss_flight,                              m_data->GetEntityBN(_T("lss_flight")));
	CHECK_ZERO_ATTR(a_lss_flight_base_product,                 m_data->GetAttrDefinition(e_lss_flight, _T("base_product")));
	CHECK_ZERO_ATTR(a_lss_flight_date_time,                    m_data->GetAttrDefinition(e_lss_flight, _T("date_time")));

	/************************************************************************/
	/*                     Engeneer Support                                 */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_forum_question, 					m_data->GetEntityBN(_T("apl_forum_question")));
	CHECK_ZERO_ATTR(a_forum_question_header,			m_data->GetAttrDefinition(e_forum_question, _T("header")));
	CHECK_ZERO_ATTR(a_forum_question_section,			m_data->GetAttrDefinition(e_forum_question, _T("section")));
	CHECK_ZERO_ATTR(a_forum_question_state,				m_data->GetAttrDefinition(e_forum_question, _T("state")));
	CHECK_ZERO_ATTR(a_forum_question_author,			m_data->GetAttrDefinition(e_forum_question, _T("author")));
	CHECK_ZERO_ATTR(a_forum_question_refusal,			m_data->GetAttrDefinition(e_forum_question, _T("refusal")));
	CHECK_ZERO_ATTR(a_forum_question_job,				m_data->GetAttrDefinition(e_forum_question, _T("job")));
	CHECK_ZERO_ATTR(a_forum_question_last_message,		m_data->GetAttrDefinition(e_forum_question, _T("last_message")));
	CHECK_ZERO_ATTR(a_forum_question_date,				m_data->GetAttrDefinition(e_forum_question, _T("creation_date")));
	CHECK_ZERO_ATTR(a_forum_question_attachments,		m_data->GetAttrDefinition(e_forum_question, _T("attachments")));
	CHECK_ZERO_ATTR(a_forum_question_creation_state,	m_data->GetAttrDefinition(e_forum_question, _T("creation_status")));
	CHECK_ZERO_ATTR(a_forum_question_planer,			m_data->GetAttrDefinition(e_forum_question, _T("planer")));
	CHECK_ZERO_ATTR(a_forum_question_planer_type,		m_data->GetAttrDefinition(e_forum_question, _T("planer_type")));
	CHECK_ZERO_ATTR(a_forum_question_system,			m_data->GetAttrDefinition(e_forum_question, _T("system")));
	CHECK_ZERO_ATTR(a_forum_question_item,				m_data->GetAttrDefinition(e_forum_question, _T("item")));
	CHECK_ZERO_ATTR(a_forum_question_item_type,			m_data->GetAttrDefinition(e_forum_question, _T("item_type")));
	CHECK_ZERO_ATTR(a_forum_question_system_id,			m_data->GetAttrDefinition(e_forum_question, _T("system_str")));
	CHECK_ZERO_ATTR(a_forum_question_assign,			m_data->GetAttrDefinition(e_forum_question, _T("assign")));

	CHECK_ZERO_ATTR(e_forum_section,					m_data->GetEntityBN(_T("apl_forum_section")));
	CHECK_ZERO_ATTR(a_forum_section_name,				m_data->GetAttrDefinition(e_forum_section, _T("name")));

	CHECK_ZERO_ATTR(e_forum_message,					m_data->GetEntityBN(_T("apl_forum_message")));
	CHECK_ZERO_ATTR(a_forum_message_text,				m_data->GetAttrDefinition(e_forum_message, _T("text")));
	CHECK_ZERO_ATTR(a_forum_message_author,				m_data->GetAttrDefinition(e_forum_message, _T("author")));
	CHECK_ZERO_ATTR(a_forum_message_creation_date,		m_data->GetAttrDefinition(e_forum_message, _T("creation_date")));
	CHECK_ZERO_ATTR(a_forum_message_question,			m_data->GetAttrDefinition(e_forum_message, _T("question")));
	CHECK_ZERO_ATTR(a_forum_message_attachments,		m_data->GetAttrDefinition(e_forum_message, _T("attachments")));
	CHECK_ZERO_ATTR(a_forum_message_prev,				m_data->GetAttrDefinition(e_forum_message, _T("prev")));
	CHECK_ZERO_ATTR(a_forum_message_status,				m_data->GetAttrDefinition(e_forum_message, _T("status")));

	/************************************************************************/
	/*                                              */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_launch_decision,              m_data->GetEntityBN(_T("ils_launch_decision")));
	CHECK_ZERO_ATTR(a_ils_launch_decision_bulletin,		m_data->GetAttrDefinition(e_ils_launch_decision, _T("bulletin")));
	CHECK_ZERO_ATTR(a_ils_launch_decision_id,			m_data->GetAttrDefinition(e_ils_launch_decision, _T("id")));
	CHECK_ZERO_ATTR(a_ils_launch_decision_date,			m_data->GetAttrDefinition(e_ils_launch_decision, _T("date")));

	/************************************************************************/
	/*                                             */
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_metal,						m_data->GetEntityBN(_T("ils_metal")));
	CHECK_ZERO_ATTR(a_ils_metal_item,					m_data->GetAttrDefinition(e_ils_metal, _T("item")));
	CHECK_ZERO_ATTR(a_ils_metal_au,						m_data->GetAttrDefinition(e_ils_metal, _T("au")));
	CHECK_ZERO_ATTR(a_ils_metal_ag,						m_data->GetAttrDefinition(e_ils_metal, _T("ag")));
	CHECK_ZERO_ATTR(a_ils_metal_ir,						m_data->GetAttrDefinition(e_ils_metal, _T("ir")));
	CHECK_ZERO_ATTR(a_ils_metal_pd,						m_data->GetAttrDefinition(e_ils_metal, _T("pd")));
	CHECK_ZERO_ATTR(a_ils_metal_pt,						m_data->GetAttrDefinition(e_ils_metal, _T("pt")));
	CHECK_ZERO_ATTR(a_ils_metal_rh,						m_data->GetAttrDefinition(e_ils_metal, _T("rh")));
	CHECK_ZERO_ATTR(a_ils_metal_heavy,					m_data->GetAttrDefinition(e_ils_metal, _T("heavy")));
	CHECK_ZERO_ATTR(a_ils_metal_al,						m_data->GetAttrDefinition(e_ils_metal, _T("al")));
	CHECK_ZERO_ATTR(a_ils_metal_cu,						m_data->GetAttrDefinition(e_ils_metal, _T("cu")));
	CHECK_ZERO_ATTR(a_ils_metal_ti,						m_data->GetAttrDefinition(e_ils_metal, _T("ti")));
	CHECK_ZERO_ATTR(a_ils_metal_ni,						m_data->GetAttrDefinition(e_ils_metal, _T("ni")));
	CHECK_ZERO_ATTR(a_ils_metal_lite,					m_data->GetAttrDefinition(e_ils_metal, _T("lite")));

	/************************************************************************/
	/*                     										*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_transaction,					m_data->GetEntityBN(_T("ils_transaction")));
	CHECK_ZERO_ATTR(a_ils_transaction_time_begin,		m_data->GetAttrDefinition(e_ils_transaction, _T("time_begin")));
	CHECK_ZERO_ATTR(a_ils_transaction_time_end,			m_data->GetAttrDefinition(e_ils_transaction, _T("time_end")));
	CHECK_ZERO_ATTR(a_ils_transaction_user,				m_data->GetAttrDefinition(e_ils_transaction, _T("user")));
	CHECK_ZERO_ATTR(a_ils_transaction_session,			m_data->GetAttrDefinition(e_ils_transaction, _T("session")));

	/************************************************************************/
	/*                       								*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_depot_balance,				m_data->GetEntityBN(_T("ils_depot_balance")));
	CHECK_ZERO_ATTR(a_ils_depot_balance_component,		m_data->GetAttrDefinition(e_ils_depot_balance, _T("component")));
	CHECK_ZERO_ATTR(a_ils_depot_balance_organization,	m_data->GetAttrDefinition(e_ils_depot_balance, _T("organization")));
	CHECK_ZERO_ATTR(a_ils_depot_balance_balance,		m_data->GetAttrDefinition(e_ils_depot_balance, _T("balance")));

	/************************************************************************/
	/*							  SSI							*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_ssi, m_data->GetEntityBN(_T("ils_ssi")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q1, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question1")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q2, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question2")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q3, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question3")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q4, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question4")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q5, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question5")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q6, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question6")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q7, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_question7")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q8, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q8")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q1_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q1_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q2_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q2_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q3_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q3_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q4_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q4_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q5_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q5_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q6_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q6_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q7_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q7_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_check_ssi_q8_descr, m_data->GetAttrDefinition(e_ils_ssi, _T("check_ssi_q8_descr")));
	CHECK_ZERO_ATTR(a_ils_ssi_is_damage, m_data->GetAttrDefinition(e_ils_ssi, _T("is_damage")));
	CHECK_ZERO_ATTR(a_ils_ssi_is_scheduled_views, m_data->GetAttrDefinition(e_ils_ssi, _T("is_scheduled_views")));
	CHECK_ZERO_ATTR(a_ils_ssi_is_fd_restrict, m_data->GetAttrDefinition(e_ils_ssi, _T("is_fd_restrict")));
	CHECK_ZERO_ATTR(a_ils_ssi_durability, m_data->GetAttrDefinition(e_ils_ssi, _T("durability")));
	CHECK_ZERO_ATTR(a_ils_ssi_break_grow_speed, m_data->GetAttrDefinition(e_ils_ssi, _T("break_grow_speed")));
	CHECK_ZERO_ATTR(a_ils_ssi_break_size, m_data->GetAttrDefinition(e_ils_ssi, _T("break_size")));
	CHECK_ZERO_ATTR(a_ils_ssi_break_critical_size, m_data->GetAttrDefinition(e_ils_ssi, _T("break_critical_size")));
	CHECK_ZERO_ATTR(a_ils_ssi_period, m_data->GetAttrDefinition(e_ils_ssi, _T("period")));
	CHECK_ZERO_ATTR(a_ils_ssi_is_metal, m_data->GetAttrDefinition(e_ils_ssi, _T("is_metal")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate, m_data->GetAttrDefinition(e_ils_ssi, _T("metal_rate")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate, m_data->GetAttrDefinition(e_ils_ssi, _T("composite_rate")));
	CHECK_ZERO_ATTR(a_ils_ssi_control_method, m_data->GetAttrDefinition(e_ils_ssi, _T("control_method")));

	//    SSI
	CHECK_ZERO_ATTR(e_ils_ssi_metal_rate, m_data->GetEntityBN(_T("ils_ssi_metal_rate")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_is_inner, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("is_inner")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_is_outer, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("is_outer")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_accidental_damage_probability, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_accidental_damage_probability")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_accidental_damage_probability, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_accidental_damage_probability")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_maintenance_visibility, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_maintenance_visibility")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_maintenance_visibility, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_maintenance_visibility")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_environment_influence, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_environment_influence")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_environment_influence, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_environment_influence")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_accidental_damage_sensitivity, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_accidental_damage_sensitivity")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_accidental_damage_sensitivity, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_accidental_damage_sensitivity")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_corrosion_sensitivity, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_corrosion_sensitivity")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_corrosion_sensitivity, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_corrosion_sensitivity")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_corrosion_sensitivity_stress, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_corrosion_sensitivity_stress")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_corrosion_sensitivity_stress, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_corrosion_sensitivity_stress")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_corrosion_sensitivity_ad, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_corrosion_sensitivity_ad")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_corrosion_sensitivity_ad, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_corrosion_sensitivity_ad")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_inner_environmental_protection, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("inner_environmental_protection")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_outer_environmental_protection, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("outer_environmental_protection")));
	CHECK_ZERO_ATTR(a_ils_ssi_metal_rate_is_cpcp, m_data->GetAttrDefinition(e_ils_ssi_metal_rate, _T("is_cpcp")));

	//    SSI
	CHECK_ZERO_ATTR(e_ils_ssi_composite_rate, m_data->GetEntityBN(_T("ils_ssi_composite_rate")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_is_inner, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("is_inner")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_is_outer, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("is_outer")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_ground_handling_equipment, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_ground_handling_equipment")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_ground_handling_equipment, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_ground_handling_equipment")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_cargo_handling_equipment, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_cargo_handling_equipment")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_cargo_handling_equipment, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_cargo_handling_equipment")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_human_errors, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_human_errors")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_human_errors, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_human_errors")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_passengers, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_passengers")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_passengers, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_passengers")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_atmospheric_effects, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_atmospheric_effects")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_atmospheric_effects, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_atmospheric_effects")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_objects_runway, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_objects_runway")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_objects_runway, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_objects_runway")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_liquid_leak, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_liquid_leak")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_liquid_leak, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_liquid_leak")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_hot_air, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_hot_air")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_hot_air, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_hot_air")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ad_other, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ad_other")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ad_other, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ad_other")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ed_ultraviolet, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ed_ultraviolet")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ed_ultraviolet, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ed_ultraviolet")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ed_humidity, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ed_humidity")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ed_humidity, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ed_humidity")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ed_liquid, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ed_liquid")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ed_liquid, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ed_liquid")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ed_high_temperature, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ed_high_temperature")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ed_high_temperature, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ed_high_temperature")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_inner_ed_other, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("inner_ed_other")));
	CHECK_ZERO_ATTR(a_ils_ssi_composite_rate_outer_ed_other, m_data->GetAttrDefinition(e_ils_ssi_composite_rate, _T("outer_ed_other")));

	//    (,   ..)/ /  
	CHECK_ZERO_ATTR(e_apl_lss3_component_organization_relation, m_data->GetEntityBN(_T("apl_lss3_comp_org_rel")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_component, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("component")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_organization, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("organization")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_type, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_linked_organization, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("linked_organization")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_date_active_begin, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("date_active_begin")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_date_active_end, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("date_active_end")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_price, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("price")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_price_unit, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("price_unit")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_supply_cycle, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("supply_cycle")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_supply_cycle_unit, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("supply_cycle_unit")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_repair_tat, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("repair_tat")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_repair_tat_unit, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("repair_tat_unit")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_delivery_time, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("delivery_time")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_delivery_time_unit, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("delivery_time_unit")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_repair_price_part, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("repair_price_part")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_min_reserve_level, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("min_reserve_level")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_aftersales_service_type, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("aftersales_service_type")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_delivery_distance, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("delivery_distance")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_ton_kilometer_cost, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("ton_kilometer_cost")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_cost_of_creation, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("cost_of_creation")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_annual_cost_of_ownership, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("annual_cost_of_ownership")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_aftersales_system_project, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("aftersales_system_project")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_aftersales_id, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("id")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_aftersales_transportation_method, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("transportation_method")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_annual_plan_labor, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("annual_plan_labor")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_storage_price_per_year, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("storage_price_per_year")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_default, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("default")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_aftersales_is_obj_of_supplier, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("aftersales_is_obj_of_supplier")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_aftersales_price_transportation_fi_to_km, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("aftersales_price_transportation_fi_to_km")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_supply_lower_levels, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("supply_lower_levels")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_supply_model, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("supply_model")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_min_count_in_zip, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("min_count_in_zip")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_box_height, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("box_height")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_box_width, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("box_width")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_box_depth, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("box_depth")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_weight_with_box, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("weight_with_box")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_min_count_in_box, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("min_count_in_box")));
	CHECK_ZERO_ATTR(a_apl_lss3comp_org_rel_min_count_demand, m_data->GetAttrDefinition(e_apl_lss3_component_organization_relation, _T("min_count_demand")));

	//  
	CHECK_ZERO_ATTR(e_apl_lss3_aftersales_system_project, m_data->GetEntityBN(_T("apl_lss3_aftersales_system_project")));
	CHECK_ZERO_ATTR(a_apl_lss3_aftersales_system_project_name, m_data->GetAttrDefinition(e_apl_lss3_aftersales_system_project, _T("name")));
	CHECK_ZERO_ATTR(a_apl_lss3_aftersales_system_project_ton_kilometer_cost, m_data->GetAttrDefinition(e_apl_lss3_aftersales_system_project, _T("ton_kilometer_cost")));
	CHECK_ZERO_ATTR(a_apl_lss3_aftersales_system_project_cost_unit, m_data->GetAttrDefinition(e_apl_lss3_aftersales_system_project, _T("cost_unit")));

	/************************************************************************/
	/*			  									*/
	/************************************************************************/
	CHECK_ZERO_ATTR(e_ils_connect,			m_data->GetEntityBN(_T("ils_connect")));
	CHECK_ZERO_ATTR(a_ils_connect_element,	m_data->GetAttrDefinition(e_ils_connect, _T("element")));
	CHECK_ZERO_ATTR(a_ils_connect_couple,	m_data->GetAttrDefinition(e_ils_connect, _T("couple")));

	return true;
}

void CaplPreExploitationMgr::Detach()
{
	e_apl_resource_change = NULL;
	a_apl_rc_type = NULL;
	a_apl_rc_charact = NULL;
	a_apl_rc_charact_type = NULL;
	a_apl_rc_delta = NULL;
	a_apl_rc_basis = NULL;
	a_apl_rc_recursive = NULL;
	a_apl_rc_item = NULL;

	e_apl_refusal = NULL;
	a_apl_refusal_planer = NULL;
	a_apl_refusal_item = NULL;
	a_apl_refusal_system = NULL;
	a_apl_refusal_part = NULL;
	a_apl_refusal_date_detection = NULL;
	a_apl_refusal_date_removal = NULL;
	a_apl_refusal_type =NULL;
	a_apl_refusal_conditions = NULL;
	a_apl_refusal_method = NULL;
	a_apl_refusal_reason_of_delay = NULL;
	a_apl_refusal_time_delay = NULL;
	a_apl_refusal_consequences = NULL;
	a_apl_refusal_culprit = NULL;
	a_apl_refusal_description = NULL;
	a_apl_refusal_accepted_arrangements_str = NULL;
	a_apl_refusal_accepted_arrangements_obj = NULL;
	a_apl_refusal_document_str = NULL;
	a_apl_refusal_document_obj = NULL;
	a_apl_refusal_certificate_of_compliance_str = NULL;
	a_apl_refusal_certificate_of_compliance_obj = NULL;
	a_apl_refusal_faultreason = NULL;
	a_apl_refusal_manifestation = NULL;
	a_apl_refusal_dof = NULL;
	a_apl_refusal_faultreg1 = NULL;
	a_apl_refusal_faultreg2 = NULL;
	a_apl_refusal_faultreg3 = NULL;
	a_apl_refusal_faultreg4 = NULL;
	a_apl_refusal_disclosuremethod = NULL;
	a_apl_refusal_stafferrorreasen = NULL;
	a_apl_refusal_incident = NULL;
	a_apl_refusal_document_date = NULL;
	a_apl_refusal_certificate_of_compliance_date = NULL;
	a_apl_refusal_is_not_confirm = NULL;
	a_apl_refusal_repair_job = NULL;
	a_apl_refusal_detect_job = NULL;
	a_apl_refusal_guid = NULL;
	a_apl_refusal_pre_condition = NULL;
	a_apl_refusal_state= NULL;	
	a_apl_refusal_stage= NULL;	
	a_apl_refusal_doc_type= NULL;	
	a_apl_refusal_doc_num = NULL;;	
	a_apl_refusal_doc_date= NULL;
	a_apl_refusal_org= NULL;	
	a_apl_refusal_sector= NULL;			
	a_apl_refusal_ext_view= NULL;			
	a_apl_refusal_research_first= NULL;	
	a_apl_refusal_research_second= NULL;	
	a_apl_refusal_research_result= NULL;	
	a_apl_refusal_test_deduction= NULL;	
	a_apl_refusal_culprit_deduction= NULL;
	a_apl_refusal_dispose_data= NULL;		
	a_apl_refusal_result_decision= NULL;	
	a_apl_refusal_research_act_obj= NULL;	
	a_apl_refusal_research_act_str= NULL;	
	a_apl_refusal_research_act_date= NULL;
	a_apl_refusal_arrangm_act_str= NULL;	
	a_apl_refusal_arrangm_act_date= NULL;	
	a_apl_refusal_arrangm_act_obj= NULL;	
	a_apl_refusal_research_lab= NULL;		
	a_apl_refusal_research_sector= NULL;	
	a_apl_refusal_manifestation_str= NULL;
	a_apl_refusal_resources_str= NULL;
	a_apl_refusal_part_lot= NULL;
	a_apl_refusal_item_lot= NULL;
	a_apl_refusal_parent= NULL;
	a_apl_refusal_necassary_arrangm= NULL;
	a_apl_refusal_files= NULL;
	a_apl_refusal_union_passport_num = NULL;
	a_apl_refusal_fed_to_developer = NULL;
	a_apl_refusal_ignore_in_reliability = NULL;
	a_apl_refusal_developer_comments = NULL;
	a_apl_refusal_spec = NULL;
	a_apl_refusal_det_method = NULL;
	a_apl_refusal_planer_garantee = NULL;
	a_apl_refusal_pki_garantee = NULL;
	a_apl_refusal_search_time = NULL;
	a_apl_refusal_search_labor = NULL;
	a_apl_refusal_removal_time = NULL;
	a_apl_refusal_removal_labor = NULL;

	e_lss3_aggr_iun_relation = NULL;
	a_lss3_aggr_iun_relation_aggr = NULL;
	a_lss3_aggr_iun_relation_iun = NULL;

	e_lss3_reset_usage_by_change = NULL;
	a_lss3_reset_usage_by_change_iun = NULL;
	a_lss3_reset_usage_by_change_res_name = NULL;
	a_lss3_reset_usage_by_change_change = NULL;
	a_lss3_reset_usage_by_change_value = NULL;
	a_lss3_reset_usage_by_change_date = NULL;

	a_apl_refusal_engine_id = NULL;
	a_apl_refusal_engine_sn = NULL;
	a_apl_refusal_engine_date_manuf = NULL;
	a_apl_refusal_engine_derived = NULL;
	a_apl_refusal_engine_last_repair_derived = NULL;
	a_apl_refusal_engine_date_last_repair = NULL;
	a_apl_refusal_engine_manufacturer = NULL;
	a_apl_refusal_engine_org_last_repair = NULL;

	e_apl_logbook = NULL;
	a_apl_logbook_items = NULL;
	a_apl_logbook_name = NULL;
	a_apl_logbook_descr = NULL;

	e_apl_export_logbook = NULL;
	a_apl_export_logbook_language = NULL;
	a_apl_export_logbook_oflogbook = NULL;

	e_apl_logbook_item = NULL;
	a_apl_logbook_item_id = NULL;
	a_apl_logbook_item_name = NULL;
	a_apl_logbook_item_template = NULL;
	a_apl_logbook_item_parent = NULL;
	a_apl_logbook_item_childs = NULL;
	a_apl_logbook_item_logbook = NULL;
	a_apl_logbook_item_language =NULL;
	a_apl_logbook_item_oflogbookitem = NULL;
	a_apl_logbook_item_descr = NULL;
	a_apl_logbook_item_edit_type = NULL;
	a_apl_logbook_item_pages = NULL;
	a_apl_logbook_item_print_fact_pages = NULL;

	e_apl_logbook_dsf_item = NULL;
	a_apl_logbook_dsf_item_defsource = NULL;

	e_apl_logbook_dll_item = NULL;
	a_apl_logbook_dll_item_function = NULL;
	a_apl_logbook_dll_item_dllname = NULL;

	e_apl_logbook_dsf = NULL;
	a_apl_logbook_dsf_dsfitem = NULL;
	a_apl_logbook_dsf_source = NULL;
	a_apl_logbook_dsf_item = NULL;

	e_apl_logbook_access			= NULL;
	a_apl_logbook_access_person		= NULL;
	a_apl_logbook_access_item		= NULL;
	a_apl_logbook_access_level		= NULL;
	a_apl_logbook_access_context	= NULL;

	e_apl_logbook_state_history = NULL;
	a_apl_logbook_state_history_new_state = NULL;
	a_apl_logbook_state_history_old_state = NULL;
	a_apl_logbook_state_history_date_time = NULL;
	a_apl_logbook_state_history_person = NULL;
	a_apl_logbook_state_history_item = NULL;
	a_apl_logbook_state_history_description = NULL;

	e_apl_logbook_job_journal_item = NULL;
	a_apl_logbook_job_journal_item_id = NULL;
	a_apl_logbook_job_journal_item_state = NULL;
	a_apl_logbook_job_journal_item_executer = NULL;
	a_apl_logbook_job_journal_item_date_plan = NULL;
	a_apl_logbook_job_journal_item_date_fact = NULL;
	a_apl_logbook_job_journal_item_remove = NULL;
	a_apl_logbook_job_journal_item_install = NULL;
	a_apl_logbook_job_journal_item_system = NULL;
	a_apl_logbook_job_journal_item_zone = NULL;
	a_apl_logbook_job_journal_item_position = NULL;
	a_apl_logbook_job_journal_item_planer = NULL;
	a_apl_logbook_job_journal_item_descr = NULL;
	a_apl_logbook_job_journal_item_type = NULL;
	a_apl_logbook_job_journal_item_org = NULL;

	e_apl_flier = NULL;
	a_apl_flier_flier_day = NULL;
	a_apl_flier_flier = NULL;
	a_apl_flier_item = NULL;
	a_apl_flier_parashut_number = NULL;
	a_apl_flier_fuel_type = NULL;
	a_apl_flier_fuel_plotnost = NULL;
	a_apl_flier_fuel_ostatok = NULL;
	a_apl_flier_fuel_dozaprav = NULL;
	a_apl_flier_fuel_P = NULL;
	a_apl_flier_fuel_T = NULL;
	a_apl_flier_fuel_num_rashod_vedom = NULL;
	a_apl_flier_maslo_left_eng = NULL;
	a_apl_flier_maslo_right_eng = NULL;
	a_apl_flier_maslo_rashod_left_eng = NULL;
	a_apl_flier_maslo_rashod_right_eng = NULL;
	a_apl_flier_maslo_amg10_1gs = NULL;
	a_apl_flier_maslo_amg10_2gs = NULL;
	a_apl_flier_azot_fonar = NULL;
	a_apl_flier_azot_avarijn_system = NULL;
	a_apl_flier_oxygen_base = NULL;
	a_apl_flier_oxygen_additional = NULL;
	a_apl_flier_anti_obled_zhidkost = NULL;
	a_apl_flier_generator_maslo_left = NULL;
	a_apl_flier_generator_maslo_right = NULL;
	a_apl_flier_units_of_fire = NULL;

	e_apl_fixing= NULL;
	a_apl_fixing_item= NULL;
	a_apl_fixing_person= NULL;
	a_apl_fixing_fix_basis= NULL;
	a_apl_fixing_ufix_basis= NULL;

	e_apl_transfer = NULL;
	a_apl_transfer_comment = NULL;
	a_apl_transfer_delivered_obj = NULL;
	a_apl_transfer_recieved_obj = NULL;
	a_apl_transfer_state = NULL;
	a_apl_transfer_date_time_delivered = NULL;
	a_apl_transfer_date_time_recieved = NULL;
	a_apl_transfer_basis_obj = NULL;
	a_apl_transfer_basis_str = NULL;
	a_apl_transfer_item = NULL;

	e_apl_item_place_group = NULL;
	a_apl_item_place_group_final_item = NULL;
	a_apl_item_place_group_id = NULL;

	e_apl_item_place = NULL;
	a_apl_item_place_group = NULL;
	a_apl_item_place_id = NULL;
	a_apl_item_place_parent_item = NULL;
	a_apl_item_place_zone = NULL;
	a_apl_item_place_item = NULL;
	a_apl_item_place_final_item = NULL;

	e_apl_incident = NULL;
	a_apl_incident_report_incident = NULL;
	a_apl_incident_report_operative_message = NULL;
	a_apl_incident_id = NULL;
	a_apl_incident_date = NULL;
	a_apl_incident_category = NULL;
	a_apl_incident_airport = NULL;
	a_apl_incident_planer = NULL;
	a_apl_incident_department = NULL;
	a_apl_incident_system = NULL;
	a_apl_incident_flight_crew = NULL;
	a_apl_incident_engine = NULL;
	a_apl_incident_conditions = NULL;
	a_apl_incident_reason = NULL;
	a_apl_incident_description = NULL;
	a_apl_incident_group = NULL;
	a_apl_incident_situation = NULL;
	a_apl_incident_revision_number = NULL;
	a_apl_incident_user = NULL;
	a_apl_incident_revision_date = NULL;
	a_apl_incident_refusals = NULL;
	a_apl_incident_next_version = NULL;
	a_apl_incident_name = NULL;
	a_apl_incident_date_gmt = NULL;
	a_apl_incident_state = NULL;
	a_apl_incident_location = NULL;
	a_apl_incident_flight_phase = NULL;
	a_apl_incident_ground = NULL;
	a_apl_incident_class = NULL;
	a_apl_incident_damage_aircraft = NULL;
	a_apl_incident_damage_aerodrome = NULL;
	a_apl_incident_damage_third_party = NULL;
	a_apl_incident_injury_level = NULL;
	a_apl_incident_flight = NULL;
	a_apl_incident_report_date = NULL;
	a_apl_incident_report_org = NULL;
	a_apl_incident_report_investigate = NULL;
	a_apl_incident_victims_number = NULL;
	a_apl_incident_meteo = NULL;

	e_apl_incident_info = NULL;
	a_apl_incident_info_incident = NULL;
	a_apl_incident_info_id = NULL;
	a_apl_incident_info_kind = NULL;
	a_apl_incident_info_date = NULL;
	a_apl_incident_info_org = NULL;
	a_apl_incident_info_description = NULL;
	a_apl_incident_info_parent = NULL;

	e_apl_incident_element = NULL;
	a_apl_incident_element_incident = NULL;
	a_apl_incident_element_parent = NULL;
	a_apl_incident_element_id = NULL;
	a_apl_incident_element_type = NULL;
	a_apl_incident_element_code = NULL;
	a_apl_incident_element_modifier = NULL;

	e_apl_crew  = NULL;;
	a_apl_crew_id = NULL;;
	a_apl_crew_role = NULL;
	a_apl_crew_certification = NULL;
	a_apl_crew_rating = NULL;
	a_apl_crew_qualification = NULL;
	a_apl_crew_time_total = NULL;
	a_apl_crew_time_fi = NULL;
	a_apl_crew_time_total_90days = NULL;
	a_apl_crew_time_fi_90days = NULL;
	a_apl_crew_incident = NULL;

	e_apl_bulletin = NULL;
	a_apl_bulletin_bp = NULL;
	a_apl_bulletin_status = NULL;
	a_apl_bulletin_reason = NULL;
	a_apl_bulletin_solution = NULL;
	a_apl_bulletin_jobs_begin_date = NULL;
	a_apl_bulletin_jobs_end_date = NULL;
	a_apl_bulletin_jobs_labor = NULL;
	a_apl_bulletin_jobs_finance = NULL;
	a_apl_bulletin_jobs_place = NULL;
	a_apl_bulletin_jobs_place_orgs = NULL;
	a_apl_bulletin_jobs_place_description = NULL;
	a_apl_bulletin_jobs_execute = NULL;
	a_apl_bulletin_jobs_execute_orgs = NULL;
	a_apl_bulletin_jobs_execute_description = NULL;

	e_apl_solution = NULL;
	a_apl_solution_id = NULL;
	a_apl_solution_date = NULL;
	a_apl_solution_bulletin = NULL;

	e_ils_bulletin = NULL;
	a_ils_bulletin_number = NULL;
	a_ils_bulletin_date = NULL;
	a_ils_bulletin_code = NULL;
	a_ils_bulletin_status = NULL;
	a_ils_bulletin_reason = NULL;
	a_ils_bulletin_jobs_begin_date = NULL;
	a_ils_bulletin_jobs_end_date = NULL;
	a_ils_bulletin_jobs_labor = NULL;
	a_ils_bulletin_jobs_finance = NULL;
	a_ils_bulletin_jobs_place = NULL;
	a_ils_bulletin_jobs_place_orgs = NULL;
	a_ils_bulletin_jobs_place_description = NULL;
	a_ils_bulletin_jobs_execute = NULL;
	a_ils_bulletin_jobs_execute_orgs = NULL;
	a_ils_bulletin_jobs_execute_description = NULL;
	a_ils_bulletin_guid = NULL;
	a_ils_bulletin_max_working_hours = NULL;
	a_ils_bulletin_max_exploitation_hours = NULL;
	a_ils_bulletin_solution_id = NULL;
	a_ils_bulletin_solution_date = NULL;
	a_ils_bulletin_id = NULL;
	a_ils_bulletin_name = NULL;
	a_ils_bulletin_conditions = NULL;
	a_ils_bulletin_developer = NULL;
	a_ils_by_contract = NULL;
	a_ils_by_receive = NULL;
	a_ils_bulletin_max_working_flights = NULL;
	a_ils_bulletin_kind = NULL;
	a_ils_bulletin_jobs_plan = NULL;
	a_ils_bulletin_urgent = NULL;
	a_ils_bulletin_apply_date= NULL;
	a_ils_bulletin_demand_doc_change= NULL;
	a_ils_bulletin_parent= NULL;
	a_ils_bulletin_part_of_doc = NULL;

	e_ils_bulletin_ref = NULL;
	a_ils_bulletin_ref_bulletin = NULL;
	a_ils_bulletin_ref_product = NULL;
	a_ils_bulletin_ref_guid = NULL;
	a_ils_bulletin_ref_date= NULL;
	a_ils_bulletin_ref_type = NULL;

	e_ils_base_product_instance = NULL;
	a_ils_base_product_instance_of_ils_base_product = NULL;
	a_ils_base_product_instance_serial_number = NULL;
	a_ils_base_product_instance_id = NULL;
	a_ils_base_product_instance_description = NULL;
	a_ils_base_product_instance_developer = NULL;
	a_ils_base_product_instance_manufacturer = NULL;
	a_ils_base_product_instance_provider = NULL;
	a_ils_base_product_instance_date_manufacture = NULL;
	a_ils_base_product_instance_state = NULL;
	a_ils_base_product_instance_guid = NULL;
	a_ils_base_product_instance_not_check_composition = NULL;
	a_ils_base_product_instance_date_change_check_composition = NULL;
	a_ils_base_product_instance_owner = NULL;
	a_ils_base_product_instance_operator = NULL;
	a_ils_base_product_instance_exploit_type = NULL;
	a_ils_base_product_instance_contract_number = NULL;
	a_ils_base_product_instance_contract_date = NULL;
	a_ils_base_product_instance_date_start_garantee = NULL;
	a_ils_base_product_instance_airport = NULL;
	a_ils_base_product_instance_person_change_check_composition = NULL;
	a_ils_base_product_instance_date_provide = NULL;
	a_ils_base_product_instance_individual_resource = NULL;
	a_ils_base_product_instance_auto = NULL;
	a_ils_base_product_instance_software_version = NULL;
	a_ils_base_product_instance_control_type = NULL;
	a_ils_base_product_instance_control_value = NULL;
	a_ils_base_product_instance_date_recalc = NULL;
	a_ils_base_product_instance_reg_num = NULL;
	a_ils_base_product_instance_date_registration = NULL;
	a_ils_base_product_instance_workability_date_begin = NULL;
	a_ils_base_product_instance_workability_date_end = NULL;
	a_ils_base_product_instance_workability_date_renewal = NULL;
	a_ils_base_product_instance_date_start_operate = NULL;
	a_ils_base_product_instance_repair_org = NULL;
	a_ils_base_product_instance_date_last_repair = NULL;
	a_ils_base_product_instance_amount_repairs = NULL;
	a_ils_base_product_instance_status = NULL;
	a_ils_base_product_instance_delivery_contract = NULL;
	a_ils_base_product_instance_current_status = NULL;
	a_ils_base_product_instance_topfull = NULL;
	a_ils_base_product_instance_of_product_revision = NULL;
	a_ils_base_product_instance_pss_instance = NULL;
	a_ils_base_product_instance_expl_doc_type = NULL;
	a_ils_base_product_instance_amount = NULL;
	a_ils_base_product_instance_short_description = NULL;
	a_ils_base_product_instance_has_composition = NULL;
	a_ils_base_product_instance_id_ext = NULL;

	e_apl_lss3_component =NULL ;
	a_apl_lss3comp_id =NULL ;
	a_apl_lss3comp_code = NULL;
	a_apl_lss3comp_id_eng = NULL;
	a_apl_lss3comp_name_rus =NULL ;
	a_apl_lss3comp_name_eng =NULL ;
	a_apl_lss3comp_short_name = NULL;
	a_apl_lss3comp_short_name_eng = NULL;
	a_apl_lss3comp_descr_rus =NULL ;
	a_apl_lss3comp_descr_eng =NULL ;
	a_apl_lss3comp_kafi =NULL ;
	a_apl_lss3comp_type =NULL ;
	a_apl_lss3comp_recommend_as_part =NULL ;
	a_apl_lss3comp_is_MSI =NULL ;
	a_apl_lss3comp_fnn =NULL ;
	a_apl_lss3comp_spec_maint =NULL ;
	a_apl_lss3comp_expl_doc_type =NULL ;
	a_apl_lss3comp_is_fi =NULL ;
	a_apl_lss3comp_class =NULL ;
	a_apl_lss3comp_expl_method =NULL ;
	a_apl_lss3comp_maint_measure_type =NULL ;
	a_apl_lss3comp_ref_intense_calc =NULL ;
	a_apl_lss3comp_ref_intense_fact =NULL ;
	a_apl_lss3comp_ref_intense_required =NULL ;
	a_apl_lss3comp_mtbf_calc =NULL ;
	a_apl_lss3comp_mtbf_fact =NULL ;
	a_apl_lss3comp_mtbf_required =NULL ;
	a_apl_lss3comp_mtbur_calc =NULL ;
	a_apl_lss3comp_mtbur_fact =NULL ;
	a_apl_lss3comp_mtbur_required =NULL ;
	a_apl_lss3comp_time_between_rep =NULL ;
	a_apl_lss3comp_unit_of_usage =NULL ;
	a_apl_lss3comp_repairability =NULL ;
	a_apl_lss3comp_kind = NULL;
	a_apl_lss3comp_category = NULL;
	a_apl_lss3comp_id_ext = NULL;
	a_apl_lss3comp_normative_document = NULL;
	a_apl_lss3comp_pdf = NULL;
	a_apl_lss3comp_height = NULL;
	a_apl_lss3comp_width = NULL;
	a_apl_lss3comp_depth = NULL;
	a_apl_lss3comp_shsc= NULL;
	a_apl_lss3comp_importance_category= NULL;
	a_apl_lss3comp_bolt_mark = NULL; 
	a_apl_lss3comp_is_pure_functional = NULL;
	a_apl_lss3comp_material = NULL;
	a_apl_lss3comp_material_type = NULL;
	a_apl_lss3comp_is_ssi = NULL;
	a_apl_lss3comp_ssi = NULL;
	a_apl_lss3comp_lcn_structure = NULL;
	a_apl_lss3comp_unserializable = NULL;
	a_apl_lss3comp_part_of_la_form = NULL;
	a_apl_lss3comp_requires_cataloging = NULL;
	a_apl_lss3comp_standard = NULL;
	a_apl_lss3comp_unit = NULL;
	a_apl_lss3comp_equipment_type = NULL;
	a_apl_lss3comp_fm_classifier_ref = NULL;
	a_apl_lss3comp_date_recalc = NULL;

	e_ils_comp_zip_relation = NULL;
	a_ils_comp_zip_relation_zip = NULL;
	a_ils_comp_zip_relation_component = NULL;

	e_apl_recovery_point = NULL;
	a_apl_recovery_point_id = NULL;
	a_apl_recovery_point_user_session_id = NULL;

	e_apl_lss3_logistic_element =NULL ;
	a_apl_lss3logel_lcn =NULL ;
	a_apl_lss3logel_expluatation_main_system = NULL;
	a_apl_lss3logel_reliability_system = NULL;
	a_apl_lss3logel_count_in_node =NULL ;
	a_apl_lss3logel_parent_element =NULL ;
	a_apl_lss3logel_parent_component =NULL ;
	a_apl_lss3logel_child_component =NULL ;
	a_apl_lss3logel_name_rus =NULL ;
	a_apl_lss3logel_name_eng =NULL ;
	a_apl_lss3logel_cfi = NULL;
	a_apl_lss3logel_element_type =NULL ;
	a_apl_lss3logel_descr_rus =NULL ;
	a_apl_lss3logel_descr_eng =NULL ;
	a_apl_lss3logel_logistic_type =NULL ;
	a_apl_lss3logel_usage_resname =NULL ;
	a_apl_lss3logel_guid =NULL ;
	a_apl_lss3logel_position = NULL;
	a_apl_lss3logel_sns = NULL;
	a_apl_lss3logel_scheme_id = NULL;
	a_apl_lss3logel_group = NULL;
	a_apl_lss3logel_is_MSI= NULL;
	a_apl_lss3logel_is_lhirf = NULL;
	a_apl_lss3logel_lhirf_analysis = NULL;
	a_apl_lss3logel_mtbf_required= NULL;
	a_apl_lss3logel_mtbf_calc= NULL;
	a_apl_lss3logel_ref_intense_required= NULL;
	a_apl_lss3logel_ref_intense_calc= NULL;
	a_apl_lss3logel_mtbur_required= NULL;
	a_apl_lss3logel_mtbur_calc= NULL;
	a_apl_lss3logel_shsc= NULL;
	a_apl_lss3logel_importance_category= NULL;
	a_apl_lss3logel_mtbf_source=NULL;
	a_apl_lss3logel_not_check_composition = NULL;
	a_apl_lss3logel_context = NULL;
	a_apl_lss3logel_exclude_from_composition = NULL;
	a_apl_lss3logel_expl_method = NULL;
	a_apl_lss3logel_amount = NULL;
	a_apl_lss3logel_amount_unit = NULL;

	e_ils_resource_name = NULL;
	a_ils_resource_name_id = NULL;
	a_ils_resource_name_name = NULL;
	a_ils_resource_name_name_eng = NULL;
	a_ils_resource_name_unit = NULL;
	a_ils_resource_name_elements = NULL;
	a_ils_resource_name_calculated = NULL;
	a_ils_resource_name_working_hours = NULL;
	a_ils_resource_name_shown_id = NULL;

	e_ils_resource_name_element = NULL;
	a_ils_resource_name_element_factor = NULL;
	a_ils_resource_name_element_element = NULL;

	e_ils_resource = NULL;
	a_ils_resource_item = NULL;
	a_ils_resource_name = NULL;
	a_ils_resource_guid = NULL;
	a_ils_resource_set = NULL;
	a_ils_resource_garantee = NULL;
	a_ils_resource_first_repair = NULL;
	a_ils_resource_between_repair = NULL;
	a_ils_resource_befor_set = NULL;// 
	a_ils_resource_derived = NULL;
	a_ils_resource_last_repair_derived = NULL;
	a_ils_resource_ultimate_life = NULL;// 
	a_ils_resource_individual = NULL;
	a_ils_resource_element = NULL;
	a_ils_resource_average = NULL;
	a_ils_resource_limit = NULL;
	a_ils_resource_calculated = NULL;
	a_ils_resource_set_as_parent = NULL;
	a_ils_resource_parent = NULL;

	e_ils_flight = NULL;
	a_ils_flight_base_product = NULL;
	a_ils_flight_date_time = NULL;
	a_ils_flight_date_time_end = NULL;
	a_ils_flight_start_fuel_mass = NULL;
	a_ils_flight_end_fuel_mass = NULL;
	a_ils_flight_payload_mass = NULL;
	a_ils_flight_takeoff_mass = NULL;
	a_ils_flight_passengers_count = NULL;
	a_ils_flight_max_flight_overload = NULL;
	a_ils_flight_max_landing_overload = NULL;
	a_ils_flight_additional_events = NULL;
	a_ils_flight_comments = NULL;
	a_ils_flight_pilot = NULL;
	a_ils_flight_airport_departure = NULL;
	a_ils_flight_airport_arrival = NULL;
	a_ils_flight_type = NULL;
	a_ils_flight_guid = NULL;

	e_ils_query = NULL;
	a_ils_query_parent = NULL;
	a_ils_query_id = NULL;
	a_ils_query_section = NULL;
	a_ils_query_name = NULL;
	a_ils_query_author = NULL;
	a_ils_query_date = NULL;
	a_ils_query_op = NULL;
	a_ils_query_read_only = NULL;
	a_ils_query_report = NULL;
	a_ils_query_description = NULL ;
	a_ils_query_copy_from = NULL;
	a_ils_query_is_filter= NULL;

	e_ils_query_par_type = NULL;
	a_ils_query_par_type_parent = NULL;
	a_ils_query_par_type_id = NULL;
	a_ils_query_par_type_name = NULL;
	a_ils_query_par_type_type = NULL;
	a_ils_query_par_type_attr = NULL;
	a_ils_query_par_type_entity = NULL;
	a_ils_query_par_type_query = NULL;
	a_ils_query_par_type_first_level = NULL;
	a_ils_query_par_type_version = NULL;

	e_ils_query_parameter = NULL;
	a_ils_query_parameter_query = NULL;
	a_ils_query_parameter_type = NULL;
	a_ils_query_parameter_op = NULL;
	a_ils_query_parameter_relation = NULL;
	a_ils_query_parameter_value = NULL;
	a_ils_query_parameter_number = NULL;
	a_ils_query_parameter_object = NULL;
	a_ils_query_parameter_flag = NULL;
	a_ils_query_parameter_of_type = NULL;

	e_ils_report = NULL;
	a_ils_report_name = NULL;
	a_ils_report_section = NULL;
	a_ils_report_description = NULL;
	a_ils_report_template = NULL;
	a_ils_report_module = NULL;
	a_ils_report_function = NULL;
	a_ils_report_user = NULL;
	a_ils_report_version = NULL;
	a_ils_report_type = NULL;
	a_ils_report_icon_large = NULL;
	a_ils_report_icon_small = NULL;
	a_ils_report_data_class = NULL;

	e_ils_base_product = NULL;
	a_ils_base_product_id = NULL;
	a_ils_base_product_name = NULL;
	a_ils_base_product_modify = NULL;
	a_ils_base_product_descr = NULL;
	a_ils_base_product_type = NULL;
	a_ils_base_product_developer = NULL;
	a_ils_base_product_manufacturer = NULL;
	a_ils_base_product_provider = NULL;
	a_ils_base_product_systems = NULL;
	a_ils_base_product_zones = NULL;
	a_ils_base_product_logbook = NULL;
	a_ils_base_product_mi = NULL;
	a_ils_base_product_guid = NULL;

	e_ils_lsi = NULL;
	a_ils_lsi_lcn = NULL;
	a_ils_lsi_base_product = NULL;
	a_ils_lsi_cfi = NULL;
	a_ils_lsi_system = NULL;
	a_ils_lsi_zone = NULL;
	a_ils_lsi_access_place = NULL;
	a_ils_lsi_amount = NULL;
	a_ils_lsi_min_amount = NULL;
	a_ils_lsi_exploit_type = NULL;
	a_ils_lsi_guid = NULL;
	a_ils_lsi_parent = NULL;
	a_ils_lsi_res_by_product = NULL;
	a_ils_lsi_code = NULL;
	a_ils_lsi_auto = NULL;

	e_ils_product_variant = NULL;
	a_ils_product_variant_place = NULL;
	a_ils_product_variant_ils_product = NULL;
	a_ils_product_variant_priority = NULL;
	a_ils_product_variant_sns = NULL;
	a_ils_product_variant_guid = NULL;
	a_ils_product_variant_catalog = NULL;
	a_ils_product_variant_mi = NULL;

	e_ils_component = NULL;
	a_ils_component_place = NULL;
	a_ils_component_ils_product_instance = NULL;
	a_ils_component_date_install = NULL;
	a_ils_component_date_remove = NULL;
	a_ils_component_description = NULL;
	a_ils_component_folder_num = NULL;
	a_ils_component_passport_num = NULL;
	a_ils_component_guid = NULL;
	a_ils_component_product_owner = NULL;
	a_ils_component_type = NULL;
	a_ils_component_reg_num = NULL;
	a_ils_component_status = NULL;
	a_ils_component_root = NULL;
	a_ils_component_remove_reason = NULL;
	a_ils_component_basis = NULL;

	e_apl_lss3_component_revision = NULL;
	a_apl_lss3_comprev_id = NULL;
	a_apl_lss3_comprev_of_product = NULL;
	a_apl_lss3_comprev_weight = NULL;
	a_apl_lss3_comprev_length = NULL;
	a_apl_lss3_comprev_width = NULL;
	a_apl_lss3_comprev_height = NULL;
	a_apl_lss3_comprev_mass_unit = NULL;
	a_apl_lss3_comprev_dim_unit = NULL;
	a_apl_lss3_comprev_sw_ver = NULL;
	a_apl_lss3_comprev_id_ext = NULL;

	e_ils_substitution = NULL;
	a_ils_substitution_predsessor = NULL;
	a_ils_substitution_sucessor = NULL;
	a_ils_substitution_reason = NULL;
	a_ils_substitution_description = NULL;
	a_ils_substitution_guid = NULL;
	a_ils_substitution_basis = NULL;

	e_ils_lsi_instance = NULL;
	a_ils_lsi_instance_of_ils_lsi = NULL;
	a_ils_lsi_instance_of_product_instance = NULL;
	a_ils_lsi_instance_parent = NULL;
	a_ils_lsi_instance_cfi = NULL;
	a_ils_lsi_instance_auto = NULL;
	a_ils_lsi_instance_topfull = NULL;
	a_ils_lsi_instance_installed = NULL;
	a_ils_lsi_instance_amount = NULL;
	a_ils_lsi_instance_has_composition = NULL;

	e_ils_change_resource = NULL;
	a_ils_change_resource_product_instance = NULL;   
	a_ils_change_resource_resource_name = NULL;    
	a_ils_change_resource_set_resource_change = NULL;
	a_ils_change_resource_set_resource_val = NULL; 
	a_ils_change_resource_type = NULL;    
	a_ils_change_resource_basis = NULL;              
	a_ils_change_resource_garantee_resource_change = NULL;
	a_ils_change_resource_garantee_resource_val = NULL;
	a_ils_change_resource_first_repair_resource_change = NULL;
	a_ils_change_resource_first_repair_resource_val = NULL;
	a_ils_change_resource_between_repair_resource_change = NULL;
	a_ils_change_resource_between_repair_resource_val = NULL;
	a_ils_change_resource_before_set_resource_change = NULL;
	a_ils_change_resource_before_set_resource_val = NULL;
	a_ils_change_resource_derived_resource_change = NULL;
	a_ils_change_resource_derived_resource_val = NULL;
	a_ils_change_resource_last_repair_resource_change = NULL;
	a_ils_change_resource_last_repair_resource_val = NULL;

	e_ils_refusal = NULL;
	a_ils_refusal_planer = NULL;
	a_ils_refusal_refused_instance = NULL;
	a_ils_refusal_date_time = NULL;
	a_ils_refusal_description = NULL;
	a_ils_refusal_accepted_arrangements = NULL;
	a_ils_refusal_kun_number = NULL;
	a_ils_refusal_kun_date = NULL;
	a_ils_refusal_need_additional_info = NULL;
	a_ils_refusal_state = NULL;
	a_ils_refusal_conditions = NULL;
	a_ils_refusal_manifestation = NULL;
	a_ils_refusal_character = NULL;
	a_ils_refusal_faultreason = NULL;
	a_ils_refusal_method = NULL;
	a_ils_refusal_consequences = NULL;
	a_ils_refusal_culprit = NULL;
	a_ils_refusal_refusal_type = NULL;
	a_ils_refusal_incident = NULL;
	a_ils_refusal_premise = NULL;
	a_ils_refusal_assembly_instance = NULL;
	a_ils_refusal_fed_to_developer = NULL;
	a_ils_refusal_ignore_in_reliability = NULL;
	a_ils_refusal_developer_comments = NULL;
	a_ils_refusal_airbase = NULL;
	a_ils_refusal_person = NULL;
	a_ils_refusal_organization = NULL;
	a_ils_refusal_guid = NULL;
	a_ils_refusal_not_check_composition = NULL;
	a_ils_refusal_date_removal = NULL;
	a_ils_refusal_document_str = NULL;
	a_ils_refusal_document_date = NULL;
	a_ils_refusal_form_removal = NULL;
	a_ils_refusal_search_job_duration = NULL;
	a_ils_refusal_search_job_idle = NULL;
	a_ils_refusal_search_job_labor = NULL;
	a_ils_refusal_search_job_cost = NULL;
	a_ils_refusal_removal_job_duration = NULL;
	a_ils_refusal_removal_job_spare_parts_idle = NULL;
	a_ils_refusal_removal_job_other_idle = NULL;
	a_ils_refusal_removal_job_labor = NULL;
	a_ils_refusal_removal_job_staff_cost = NULL;
	a_ils_refusal_removal_job_spare_parts_cost = NULL;
	a_ils_refusal_removal_job_total_cost = NULL;
	a_ils_refusal_system = NULL;
	a_ils_refusal_zone = NULL;
	a_ils_refusal_access_place = NULL;
	a_ils_refusal_cfi = NULL;
	a_ils_refusal_id = NULL;

	e_ils_executed_job = NULL;
	a_ils_executed_job_id = NULL;
	a_ils_executed_job_name = NULL;
	a_ils_executed_job_descr = NULL;
	a_ils_executed_job_type = NULL;
	a_ils_executed_job_planer = NULL;
	a_ils_executed_job_date_begin = NULL;
	a_ils_executed_job_date_end = NULL;
	a_ils_executed_job_labor = NULL;
	a_ils_executed_job_price = NULL;
	a_ils_executed_job_item = NULL;
	a_ils_executed_job_duration = NULL;
	a_ils_executed_job_executer = NULL;
	a_ils_executed_job_bulletin_executer = NULL;

	e_ils_executed_job_attachment = NULL;
	a_ils_executed_job_attachment_type = NULL;
	a_ils_executed_job_attachment_of_job = NULL;
	a_ils_executed_job_attachment_price = NULL;
	a_ils_executed_job_attachment_comment = NULL;
	a_ils_executed_job_attachment_num = NULL;
	a_ils_executed_job_attachment_guid = NULL;

	e_ils_executed_job_attachment_pos = NULL;
	a_ils_executed_job_attachment_pos_task_id = NULL;
	a_ils_executed_job_attachment_pos_task_name = NULL;
	a_ils_executed_job_attachment_pos_task = NULL;
	a_ils_executed_job_attachment_pos_labor = NULL;

	e_ils_executed_job_attachment_moves = NULL;
	a_ils_executed_job_attachment_moves_remove = NULL;
	a_ils_executed_job_attachment_moves_install = NULL;

	e_ils_software_version_item = NULL;
	a_ils_software_version_item_of_ils_product = NULL;
	a_ils_software_version_item_value = NULL;

	e_ils_cfi = NULL;
	a_ils_cfi_id = NULL;
	a_ils_cfi_of_planer = NULL;
	a_ils_cfi_of_lsi = NULL;

	e_ils_resource_correct = NULL;
	a_ils_resource_correct_of_item = NULL;
	a_ils_resource_correct_date_time = NULL;
	a_ils_resource_correct_comments = NULL;
	a_ils_resource_correct_guid = NULL;
	a_ils_resource_correct_basis = NULL;
	a_ils_resource_correct_type = NULL;

	e_apl_logbook = NULL;
	a_apl_logbook_items = NULL;
	a_apl_logbook_id = NULL;
	a_apl_logbook_name = NULL;
	a_apl_logbook_descr = NULL;
	e_apl_export_logbook = NULL;
	a_apl_export_logbook_oflogbook = NULL;
	a_apl_export_logbook_language = NULL;
	e_apl_logbook_item = NULL;
	a_apl_logbook_item_id = NULL;
	a_apl_logbook_item_name = NULL;
	a_apl_logbook_item_template = NULL;
	a_apl_logbook_item_use_to_export = NULL;
	a_apl_logbook_item_parent = NULL;
	a_apl_logbook_item_childs = NULL;
	a_apl_logbook_item_logbook = NULL;
	a_apl_logbook_item_language = NULL;
	a_apl_logbook_item_oflogbookitem = NULL;
	a_apl_logbook_item_descr = NULL;
	a_apl_logbook_item_edit_type = NULL;
	a_apl_logbook_item_pages = NULL;
	a_apl_logbook_item_print_fact_pages = NULL;
	e_apl_logbook_dsf_item = NULL;
	a_apl_logbook_dsf_item_defsource = NULL;
	e_apl_logbook_dll_item = NULL;
	a_apl_logbook_dll_item_function = NULL;
	a_apl_logbook_dll_item_dllname = NULL;
	e_apl_logbook_dsf = NULL;
	a_apl_logbook_dsf_dsfitem = NULL;
	a_apl_logbook_dsf_source = NULL;

	e_ils_planer_state = NULL;
	a_ils_planer_state_planer = NULL;
	a_ils_planer_state_description = NULL;
	a_ils_planer_state_date = NULL;
	a_ils_planer_state_state = NULL;
	a_ils_planer_state_res_hour = NULL;
	a_ils_planer_state_res_flight = NULL;
	a_ils_planer_state_res_hour_month = NULL;
	a_ils_planer_state_res_flight_month = NULL;

	e_ils_planer_state_refusal = NULL;
	a_ils_planer_state_refusal_planer = NULL;
	a_ils_planer_state_refusal_description = NULL;
	a_ils_planer_state_refusal_date = NULL;
	a_ils_planer_state_refusal_date_removal = NULL;
	a_ils_planer_state_refusal_critical = NULL;
	a_ils_planer_state_refusal_accepted_arragements = NULL;

	e_lss_executed_job = NULL;
	a_lss_executed_job_planer = NULL;
	a_lss_executed_job_bulletin = NULL;
	a_lss_executed_job_date_begin = NULL;
	a_lss_executed_job_date_end = NULL;
	a_lss_executed_job_description = NULL;
	a_lss_executed_job_labor = NULL;
	a_lss_executed_job_duration = NULL;
	a_lss_executed_job_personnel_costs = NULL;
	a_lss_executed_job_price = NULL;
	a_lss_executed_job_refusal_select = NULL;
	a_lss_executed_job_price_unit = NULL;
	a_lss_executed_job_duration_unit = NULL;
	a_lss_executed_job_labor_unit = NULL;
	a_lss_executed_job_service_type = NULL;
	a_lss_executed_job_order_type = NULL;
	a_lss_executed_job_class = NULL;
	a_lss_executed_job_price_of_spare_parts = NULL;
	a_lss_executed_job_price_of_consumables = NULL;
	a_lss_executed_job_of_item = NULL;
	a_lss_executed_job_of_item_installed = NULL;
	a_lss_executed_job_of_item_count = NULL;
	a_lss_executed_job_downtime_waiting_for_spares = NULL;
	a_lss_executed_job_parent = NULL;
	a_lss_executed_job_place_lvl = NULL;
	a_lss_executed_job_place_org = NULL;
	a_lss_executed_job_wait_reason_lvl = NULL;
	a_lss_executed_job_performer_lvl = NULL;
	a_lss_executed_job_executor_org = NULL;
	a_lss_executed_job_repair_type = NULL;
	a_lss_executed_job_scenario = NULL;
	a_lss_executed_job_personnel_count = NULL;
	a_lss_executed_job_wait_time_before_start = NULL;
	a_lss_executed_job_duration_search = NULL;
	a_lss_executed_job_process_chart = NULL;

	e_lss_executed_periodical_job = NULL;
	a_lss_executed_periodical_job_type = NULL;
	a_lss_executed_periodical_job_cost_of_spare_parts = NULL;

	e_lss_executed_replacement_job = NULL;
	a_lss_executed_replacement_job_type = NULL;
	a_lss_executed_replacement_job_item_type = NULL;
	a_lss_executed_replacement_job_system = NULL;
	a_lss_executed_replacement_job_item = NULL;
	a_lss_executed_replacement_job_name = NULL;
	a_lss_executed_replacement_job_of_job = NULL;
	a_lss_executed_replacement_job_cost_of_spare_parts = NULL;
	a_lss_executed_replacement_job_cost_of_repair = NULL;

	e_lss_executed_maintenance_job = NULL;
	a_lss_executed_maintenance_job_type = NULL;
	a_lss_executed_maintenance_job_cause = NULL;
	a_lss_executed_maintenance_job_system = NULL;
	a_lss_executed_maintenance_job_item = NULL;
	a_lss_executed_maintenance_job_name = NULL;
	a_lss_executed_maintenance_job_of_job = NULL;
	a_lss_executed_maintenance_job_cost_of_consumables = NULL;

	e_lss_executed_operational_job = NULL;
	a_lss_executed_operational_job_type = NULL;
	a_lss_executed_operational_job_cost_of_consumables = NULL;
	a_lss_executed_operational_job_amount = NULL;
	a_lss_executed_operational_job_avg_labor = NULL;
	a_lss_executed_operational_job_avg_durational = NULL;
	a_lss_executed_operational_job_avg_cost = NULL;

	e_lss_executed_refusal_search_job = NULL;
	a_lss_executed_refusal_search_job_type = NULL;

	e_ils_consumption = NULL;
	a_ils_consumption_id = NULL;
	a_ils_consumption_name = NULL;
	a_ils_consumption_description = NULL;
	a_ils_consumption_external_id = NULL;
	a_ils_consumption_standard = NULL;
	a_ils_consumption_is_standart = NULL;
	a_ils_consumption_nsn = NULL;
	a_ils_consumption_manufacturer = NULL;
	a_ils_consumption_supplier = NULL;
	a_ils_consumption_estimated_consumption_rate = NULL;
	a_ils_consumption_unit = NULL;
	a_ils_consumption_make_or_buy = NULL;
	a_ils_consumption_requires_cataloging = NULL;

	e_ils_equipment = NULL;
	a_ils_equipment_id = NULL;
	a_ils_equipment_name = NULL;
	a_ils_equipment_description = NULL;
	a_ils_equipment_external_id = NULL;
	a_ils_equipment_is_standard = NULL;
	a_ils_equipment_nsn = NULL;
	a_ils_equipment_manufacturer = NULL;
	a_ils_equipment_supplier = NULL;
	a_ils_equipment_type = NULL;
	a_ils_equipment_make_or_buy = NULL;
	a_ils_equipment_standard = NULL;
	a_ils_equipment_requires_cataloging = NULL;

	e_ils_process_chart = NULL;
	a_ils_process_chart_id_mrbr = NULL;
	a_ils_process_chart_id_mpd = NULL;
	a_ils_process_chart_name = NULL;
	a_ils_process_chart_name_eng = NULL;
	a_ils_process_chart_ata = NULL;
	a_ils_process_chart_type = NULL;
	a_ils_process_chart_labour_unit = NULL;
	a_ils_process_chart_labour_full = NULL;
	a_ils_process_chart_labour_full_or_parts = NULL;
	a_ils_process_chart_labour_execution = NULL;
	a_ils_process_chart_labour_access = NULL;
	a_ils_process_chart_actual_ls_obj_link = NULL;
	a_ils_process_chart_dm_code = NULL;
	a_ils_process_chart_dm_info_link = NULL;
	a_ils_process_chart_mean_time_work = NULL;
	a_ils_process_chart_executor_count = NULL;
	a_ils_process_chart_ssi_analysis_type = NULL;
	a_ils_process_chart_zvi_analysis_type = NULL;
	a_ils_process_chart_msi_analysis_type = NULL;
	a_ils_process_chart_task_interval_source = NULL;
	a_ils_process_chart_requirement_source = NULL;
	a_ils_process_chart_consumables_price = NULL;
	a_ils_process_chart_price_currency = NULL;

	e_lss_refusal = NULL;
	a_lss_refusal_planer = NULL;
	a_lss_refusal_system = NULL;
	a_lss_refusal_system_inst = NULL;
	a_lss_refusal_item = NULL;
	a_lss_refusal_date_detected = NULL;
	a_lss_refusal_date_removal = NULL;
	a_lss_refusal_kun_number = NULL;
	a_lss_refusal_kun_date = NULL;
	a_lss_refusal_type = NULL;
	a_lss_refusal_type_for_system = NULL;
	a_lss_refusal_manifestation = NULL;
	a_lss_refusal_manifestation_eng = NULL;
	a_lss_refusal_stage_detection = NULL;
	a_lss_refusal_consequence = NULL;
	a_lss_refusal_exception = NULL;
	a_lss_refusal_detection_form = NULL;
	a_lss_refusal_detection_confirm = NULL;
	a_lss_refusal_incident_type = NULL;
	a_lss_refusal_delay = NULL;
	a_lss_refusal_delay_reason = NULL;
	a_lss_refusal_form_removal = NULL;
	a_lss_refusal_search_job_duration = NULL;
	a_lss_refusal_search_job_idle = NULL;
	a_lss_refusal_search_job_labor = NULL;
	a_lss_refusal_search_job_cost = NULL;
	//a_lss_refusal_repair_job_labor = NULL;
	a_lss_refusal_removal_job_duration = NULL;
	a_lss_refusal_removal_job_spare_parts_idle = NULL;
	a_lss_refusal_removal_job_other_idle = NULL;
	a_lss_refusal_removal_job_labor = NULL;
	a_lss_refusal_removal_job_staff_cost = NULL;
	a_lss_refusal_removal_job_spare_parts_cost = NULL;
	a_lss_refusal_removal_job_total_cost = NULL;
	a_lss_refusal_item_manifestation = NULL;
	a_lss_refusal_item_reason = NULL;
	a_lss_refusal_accepted_arrangements = NULL;
	a_lss_refusal_method = NULL;
	a_lss_refusal_description = NULL;
	a_lss_refusal_temperature = NULL;
	a_lss_refusal_humidity = NULL;
	a_lss_refusal_pressure = NULL;
	a_lss_refusal_recovery_time = NULL;
	a_lss_refusal_element_block = NULL;
	a_lss_refusal_element_node = NULL;
	a_lss_refusal_element_subblock = NULL;
	a_lss_refusal_element_group = NULL;
	a_lss_refusal_element_scheme_number = NULL;
	a_lss_refusal_defective_items = NULL;
	a_lss_refusal_planer_serial_number = NULL;
	a_lss_refusal_planer_repair_count = NULL;
	a_lss_refusal_planer_last_repair_date = NULL;
	a_lss_refusal_planer_last_repair_executer = NULL;
	a_lss_refusal_item_serial_number = NULL;
	a_lss_refusal_item_manufacturer = NULL;
	a_lss_refusal_item_date_manufactured = NULL;
	a_lss_refusal_item_repair_count = NULL;
	a_lss_refusal_item_last_repair_date = NULL;
	a_lss_refusal_item_last_repair_executer = NULL;
	a_lss_refusal_item_last_install_date = NULL;
	a_lss_refusal_item_reason_determined = NULL;
	a_lss_refusal_item_type = NULL;
	a_lss_refusal_item_of_manufacturer = NULL;
	a_lss_refusal_mission_failure = NULL;
	a_lss_refusal_mission = NULL;
	a_lss_refusal_confirmed = NULL;
	a_lss_refusal_consider_in_analyse = NULL;
	a_lss_refusal_refused_instance = NULL;
	a_lss_refusal_reason_lvl = NULL;
	a_lss_refusal_reason_description= NULL;
	a_lss_refusal_reason_description_eng = NULL;
	a_lss_refusal_preliminary_cause_lvl = NULL;
	a_lss_refusal_preliminary_cause_description= NULL;
	a_lss_refusal_preliminary_cause_description_eng = NULL;
	a_lss_refusal_ext_manifistation_lvl = NULL;
	a_lss_refusal_conditions_lvl = NULL;
	a_lss_refusal_remedy_lvl = NULL;
	a_lss_refusal_remedy_description = NULL;
	a_lss_refusal_led_to_incident = NULL;
	a_lss_refusal_nature_lvl = NULL;
	a_lss_refusal_precipitation_lvl = NULL;
	a_lss_refusal_lifecycle_stage_lvl = NULL;
	a_lss_refusal_hash = 0;
	a_lss_refusal_comment = NULL;
	a_lss_refusal_comment_eng = NULL;
	a_lss_refusal_act_number = NULL;
	a_lss_refusal_reclamation_date = NULL;
	a_lss_refusal_satisfaction_date = NULL;
	a_lss_refusal_plan_satisfaction_date = NULL;
	a_lss_refusal_testing_date = NULL;
	a_lss_refusal_reclamation_id = NULL;
	a_lss_refusal_satisfaction_id = NULL;
	a_lss_refusal_testing_id = NULL;
	a_lss_refusal_incorrect_data = NULL;
	a_lss_refusal_speciality = NULL;
	a_lss_refusal_detection_type = NULL;
	a_lss_refusal_staff_reason = NULL;
	a_lss_refusal_essence = NULL;
	a_lss_refusal_essence_descr = NULL;
	a_lss_refusal_scenario = NULL;
	a_lss_refusal_item_derived = NULL;
	a_lss_refusal_notice_id = NULL;
	a_lss_refusal_replenish_id = NULL;
	a_lss_refusal_replenish_date = NULL;
	a_lss_refusal_reclamation_state = NULL;
	a_lss_refusal_mode = NULL;

	e_ils_classifier_reference = NULL;
	a_ils_clssf_ref_classifier = NULL;
	a_ils_clssf_ref_refusal = NULL;
	a_ils_clssf_ref_type = NULL;

	e_lss_refusal_defective_item = NULL;
	a_lss_refusal_defective_item_product = NULL;
	a_lss_refusal_defective_item_serial_number = NULL;
	a_lss_refusal_defective_item_place = NULL;
	a_lss_refusal_defective_item_confirm = NULL;
	a_lss_refusal_defective_item_of_ils_product = NULL;

	e_lss_flight = NULL;
	a_lss_flight_base_product = NULL;
	a_lss_flight_date_time = NULL;

	e_forum_question = NULL;
	a_forum_question_header = NULL;
	a_forum_question_section = NULL;
	a_forum_question_state = NULL;
	a_forum_question_creation_state = NULL;
	a_forum_question_author = NULL;
	a_forum_question_refusal = NULL;
	a_forum_question_job = NULL;
	a_forum_question_last_message = NULL;
	a_forum_question_date = NULL;
	a_forum_question_attachments = NULL;
	a_forum_question_planer = NULL;
	a_forum_question_planer_type = NULL;
	a_forum_question_system = NULL;
	a_forum_question_system_id = NULL;
	a_forum_question_item = NULL;
	a_forum_question_item_type = NULL;
	a_forum_question_assign = NULL;

	e_forum_section = NULL;
	a_forum_section_name = NULL;

	e_forum_message = NULL;
	a_forum_message_text = NULL;
	a_forum_message_author = NULL;
	a_forum_message_creation_date = NULL;
	a_forum_message_question = NULL;
	a_forum_message_attachments = NULL;
	a_forum_message_prev = NULL;
	a_forum_message_status = NULL;

	e_ils_launch_decision = NULL;
	a_ils_launch_decision_bulletin = NULL;
	a_ils_launch_decision_id = NULL;
	a_ils_launch_decision_date = NULL;

	e_apl_lss3_zone_access = NULL;
	a_apl_lss3_zone_code = NULL;
	a_apl_lss3_zone_name_rus = NULL;
	a_apl_lss3_zone_descr_rus = NULL;
	a_apl_lss3_zone_parent = NULL;
	a_apl_lss3_zone_type = NULL;
	a_apl_lss3_zone_parent_fi = NULL;
	a_apl_lss3_zone_fistr = NULL;
	a_apl_lss3_zone_analysis = NULL;
	a_apl_lss3_zone_is_need_rcm_analysis = NULL;

	e_ils_metal = NULL;
	a_ils_metal_item = NULL;
	a_ils_metal_au = NULL;
	a_ils_metal_ag = NULL;
	a_ils_metal_ir = NULL;
	a_ils_metal_pd = NULL;
	a_ils_metal_pt = NULL;
	a_ils_metal_rh = NULL;
	a_ils_metal_heavy = NULL;
	a_ils_metal_al = NULL;
	a_ils_metal_cu = NULL;
	a_ils_metal_ti = NULL;
	a_ils_metal_ni = NULL;
	a_ils_metal_lite = NULL;

	e_ils_transaction = NULL;
	a_ils_transaction_time_begin = NULL;
	a_ils_transaction_time_end = NULL;
	a_ils_transaction_user = NULL;
	a_ils_transaction_session = NULL;

	e_ils_depot_balance = NULL;
	a_ils_depot_balance_component = NULL;
	a_ils_depot_balance_organization = NULL;
	a_ils_depot_balance_balance = NULL;

	e_apl_lss3_component_organization_relation = NULL;
	a_apl_lss3comp_org_rel_component = NULL;
	a_apl_lss3comp_org_rel_organization = NULL;
	a_apl_lss3comp_org_rel_type = NULL;
	a_apl_lss3comp_org_rel_linked_organization = NULL;
	a_apl_lss3comp_org_rel_date_active_begin = NULL;
	a_apl_lss3comp_org_rel_date_active_end = NULL;
	a_apl_lss3comp_org_rel_price = NULL;
	a_apl_lss3comp_org_rel_price_unit = NULL;
	a_apl_lss3comp_org_rel_supply_cycle = NULL;
	a_apl_lss3comp_org_rel_supply_cycle_unit = NULL;
	a_apl_lss3comp_org_rel_repair_tat = NULL;
	a_apl_lss3comp_org_rel_repair_tat_unit = NULL;
	a_apl_lss3comp_org_rel_delivery_time = NULL;
	a_apl_lss3comp_org_rel_delivery_time_unit = NULL;
	a_apl_lss3comp_org_rel_repair_price_part = NULL;
	a_apl_lss3comp_org_rel_aftersales_service_type = NULL;
	a_apl_lss3comp_org_rel_delivery_distance = NULL;
	a_apl_lss3comp_org_rel_ton_kilometer_cost = NULL;
	a_apl_lss3comp_org_rel_cost_of_creation = NULL;
	a_apl_lss3comp_org_rel_annual_cost_of_ownership = NULL;
	a_apl_lss3comp_org_rel_aftersales_system_project = NULL;
	a_apl_lss3comp_org_rel_aftersales_id = NULL;
	a_apl_lss3comp_org_rel_aftersales_transportation_method = NULL;
	a_apl_lss3comp_org_rel_annual_plan_labor = NULL;
	a_apl_lss3comp_org_rel_storage_price_per_year = NULL;
	a_apl_lss3comp_org_rel_default = NULL;
	a_apl_lss3comp_org_rel_aftersales_is_obj_of_supplier = NULL;
	a_apl_lss3comp_org_rel_aftersales_price_transportation_fi_to_km = NULL;
	a_apl_lss3comp_org_rel_supply_lower_levels=NULL;
	a_apl_lss3comp_org_rel_supply_model= NULL;
	a_apl_lss3comp_org_rel_min_count_in_zip = NULL;
	a_apl_lss3comp_org_rel_box_height = NULL;
	a_apl_lss3comp_org_rel_box_width = NULL;
	a_apl_lss3comp_org_rel_box_depth = NULL;
	a_apl_lss3comp_org_rel_weight_with_box = NULL;
	a_apl_lss3comp_org_rel_min_count_in_box = NULL;
	a_apl_lss3comp_org_rel_min_count_demand = NULL;

	e_apl_lss3_aftersales_system_project = NULL;
	a_apl_lss3_aftersales_system_project_name = NULL;
	a_apl_lss3_aftersales_system_project_ton_kilometer_cost = NULL;
	a_apl_lss3_aftersales_system_project_cost_unit = NULL;

	e_ils_ssi = NULL;
	a_ils_ssi_check_ssi_q1 = NULL;
	a_ils_ssi_check_ssi_q2 = NULL;
	a_ils_ssi_check_ssi_q3 = NULL;
	a_ils_ssi_check_ssi_q4 = NULL;
	a_ils_ssi_check_ssi_q5 = NULL;
	a_ils_ssi_check_ssi_q6 = NULL;
	a_ils_ssi_check_ssi_q7 = NULL;
	a_ils_ssi_check_ssi_q8 = NULL;
	a_ils_ssi_check_ssi_q1_descr = NULL;
	a_ils_ssi_check_ssi_q2_descr = NULL;
	a_ils_ssi_check_ssi_q3_descr = NULL;
	a_ils_ssi_check_ssi_q4_descr = NULL;
	a_ils_ssi_check_ssi_q5_descr = NULL;
	a_ils_ssi_check_ssi_q6_descr = NULL;
	a_ils_ssi_check_ssi_q7_descr = NULL;
	a_ils_ssi_check_ssi_q8_descr = NULL;
	a_ils_ssi_is_damage = NULL;
	a_ils_ssi_is_scheduled_views = NULL;
	a_ils_ssi_is_fd_restrict = NULL;
	a_ils_ssi_durability = NULL;
	a_ils_ssi_break_grow_speed = NULL;
	a_ils_ssi_break_size = NULL;
	a_ils_ssi_break_critical_size = NULL;
	a_ils_ssi_period = NULL;
	a_ils_ssi_is_metal = NULL;
	a_ils_ssi_metal_rate = NULL;
	a_ils_ssi_composite_rate = NULL;
	a_ils_ssi_control_method = NULL;

	e_ils_ssi_metal_rate = NULL;
	a_ils_ssi_metal_rate_is_inner = NULL;
	a_ils_ssi_metal_rate_is_outer = NULL;
	a_ils_ssi_metal_rate_inner_accidental_damage_probability = NULL;
	a_ils_ssi_metal_rate_outer_accidental_damage_probability = NULL;
	a_ils_ssi_metal_rate_inner_maintenance_visibility = NULL;
	a_ils_ssi_metal_rate_outer_maintenance_visibility = NULL;
	a_ils_ssi_metal_rate_inner_environment_influence = NULL;
	a_ils_ssi_metal_rate_outer_environment_influence = NULL;
	a_ils_ssi_metal_rate_inner_accidental_damage_sensitivity = NULL;
	a_ils_ssi_metal_rate_outer_accidental_damage_sensitivity = NULL;
	a_ils_ssi_metal_rate_inner_corrosion_sensitivity = NULL;
	a_ils_ssi_metal_rate_outer_corrosion_sensitivity = NULL;
	a_ils_ssi_metal_rate_inner_corrosion_sensitivity_stress = NULL;
	a_ils_ssi_metal_rate_outer_corrosion_sensitivity_stress = NULL;
	a_ils_ssi_metal_rate_inner_corrosion_sensitivity_ad = NULL;
	a_ils_ssi_metal_rate_outer_corrosion_sensitivity_ad = NULL;
	a_ils_ssi_metal_rate_inner_environmental_protection = NULL;
	a_ils_ssi_metal_rate_outer_environmental_protection = NULL;
	a_ils_ssi_metal_rate_is_cpcp = NULL;

	e_ils_ssi_composite_rate = NULL;
	a_ils_ssi_composite_rate_is_inner = NULL;
	a_ils_ssi_composite_rate_is_outer = NULL;
	a_ils_ssi_composite_rate_inner_ad_ground_handling_equipment = NULL;
	a_ils_ssi_composite_rate_outer_ad_ground_handling_equipment = NULL;
	a_ils_ssi_composite_rate_inner_ad_cargo_handling_equipment = NULL;
	a_ils_ssi_composite_rate_outer_ad_cargo_handling_equipment = NULL;
	a_ils_ssi_composite_rate_inner_ad_human_errors = NULL;
	a_ils_ssi_composite_rate_outer_ad_human_errors = NULL;
	a_ils_ssi_composite_rate_inner_ad_passengers = NULL;
	a_ils_ssi_composite_rate_outer_ad_passengers = NULL;
	a_ils_ssi_composite_rate_inner_ad_atmospheric_effects = NULL;
	a_ils_ssi_composite_rate_outer_ad_atmospheric_effects = NULL;
	a_ils_ssi_composite_rate_inner_ad_objects_runway = NULL;
	a_ils_ssi_composite_rate_outer_ad_objects_runway = NULL;
	a_ils_ssi_composite_rate_inner_ad_liquid_leak = NULL;
	a_ils_ssi_composite_rate_outer_ad_liquid_leak = NULL;
	a_ils_ssi_composite_rate_inner_ad_hot_air = NULL;
	a_ils_ssi_composite_rate_outer_ad_hot_air = NULL;
	a_ils_ssi_composite_rate_inner_ad_other = NULL;
	a_ils_ssi_composite_rate_outer_ad_other = NULL;
	a_ils_ssi_composite_rate_inner_ed_ultraviolet = NULL;
	a_ils_ssi_composite_rate_outer_ed_ultraviolet = NULL;
	a_ils_ssi_composite_rate_inner_ed_humidity = NULL;
	a_ils_ssi_composite_rate_outer_ed_humidity = NULL;
	a_ils_ssi_composite_rate_inner_ed_liquid = NULL;
	a_ils_ssi_composite_rate_outer_ed_liquid = NULL;
	a_ils_ssi_composite_rate_inner_ed_high_temperature = NULL;
	a_ils_ssi_composite_rate_outer_ed_high_temperature = NULL;
	a_ils_ssi_composite_rate_inner_ed_other = NULL;
	a_ils_ssi_composite_rate_outer_ed_other = NULL;

	e_ils_connect = NULL;
	a_ils_connect_element = NULL;
	a_ils_connect_couple = NULL;

	e_ils_time_interval = NULL;
	a_ils_time_interval_type = NULL;
	a_ils_time_interval_value = NULL;
	a_ils_time_interval_plus = NULL;
	a_ils_time_interval_minus = NULL;
	a_ils_time_interval_unit = NULL;
	a_ils_time_interval_object = NULL;
	a_ils_time_interval_delay = NULL;
	a_ils_time_interval_info = NULL;
	a_ils_time_interval_first = NULL;
}

bool CaplPreExploitationMgr::FindAssociatedInstances( aplExtent& extIn/*in*/, aplExtent& extInstances/*out*/, bool bLoadAttrs/* = true*/)
{
	if(extIn.GetSize()==0)
	{
		return false;
	}
	//*      */
	CaplFinder finder(DEF_SOURCE);
	int instanceIndex = finder.CreateExt(e_ils_base_product_instance, NULL, NULL);
	int itemsIndex = finder.CreateExt(extIn, false);
	//   
	finder.AddAttr(instanceIndex, a_ils_base_product_instance_of_ils_base_product, itemsIndex, true) ;
	finder.AddToResult(instanceIndex) ;
	finder.Find(m_data, extInstances, true, false, false, bLoadAttrs) ;

	//   (     ,  )
	if (bLoadAttrs)
	{
		LoadExtentInfo(extInstances);
	}

	return (extInstances.GetSize()>0) ;
}

bool CaplPreExploitationMgr::FindAssociatedInstances( CaplInstance* pInst/*in*/, aplExtent& extInstances/*out*/)
{
	if (pInst==NULL || pInst->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}

	aplExtent extIn;
	extIn.Add(pInst);
	return FindAssociatedInstances(extIn, extInstances);

}

bool CaplPreExploitationMgr::FindAssociatedFailuresByInst(CaplInstance* pInst/*in*/,	aplExtent& extFailures/*out*/)
{
	if (pInst==NULL || pInst->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}

	aplExtent extIn;
	extIn.Add(pInst);
	return FindAssociatedFailuresByInst(extIn, extFailures);
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByInst(aplExtent& ext_insts/*in*/,	aplExtent& extFailures/*out*/, bool bLoadAttrs/* = true*/)
{
	if(ext_insts.GetSize()==0)
	{
		return false;
	}
	//*      */
	int j = 0;
	aplExtent ext_in;
	for (int i = 0; i < ext_insts.Size; i++)
	{
		ext_in.Add(ext_insts[i]);
		j++;
		if (j == 1000 || i == ext_insts.Size-1)
		{
			aplExtent ext_out;
			CaplFinder finder(DEF_SOURCE);
			int instanceIndex = finder.CreateExt(e_lss_refusal, NULL, NULL, CaplFinder::grpOR);
			int itemsIndex = finder.CreateExt(ext_in, true);
			//   
			finder.AddAttr(instanceIndex, a_lss_refusal_planer, itemsIndex, true);
			finder.AddAttr(instanceIndex, a_lss_refusal_refused_instance, itemsIndex, true);
			finder.AddAttr(instanceIndex, a_lss_refusal_system_inst, itemsIndex, true);
			finder.AddToResult(instanceIndex);
			finder.Find(m_data, ext_out, true, false, false, bLoadAttrs, true);

			extFailures.Append(ext_out);
			j = 0;
			ext_in.Clear();
		}
	}
	if(extFailures.GetSize()>0 && bLoadAttrs)//   
	{
		LoadExtentInfo(extFailures);
	}

	return (extFailures.GetSize()>0) ;
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByInst(aplExtent& ext_insts/*in*/,	CaplPreExploitationMgr::inst_to_failures_map& ResultMap/*out*/)
{
	aplExtent extFailures ;
	FindAssociatedFailuresByInst(ext_insts/*in*/,	extFailures/*out*/) ;

	for (int i = 0 ; i < extFailures.GetSize() ; i++ )
	{
		CaplInstance* pRefusal = extFailures[i] ;
		CaplInstance* pExtFi = NULL ;
		m_data->GetAttr( extFailures[i], a_lss_refusal_planer, pExtFi ) ;

		if (pExtFi)
		{
			itofm_iterator FoundIt = ResultMap.find(pExtFi) ;

			if (FoundIt == ResultMap.end())
			{
				std::pair<itofm_iterator, bool> ResultPair = ResultMap.insert(std::make_pair(pExtFi, std::set<CaplInstance*>())) ;
				FoundIt = ResultPair.first ;
			}

			FoundIt->second.insert(pRefusal) ;
		}
	}

	return false ;
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByComp(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/)
{
	if (pInst==NULL || pInst->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}

	aplExtent extIn;
	extIn.Add(pInst);
	return FindAssociatedFailuresByComp(extIn, extInstances);
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByComp(aplExtent& ext_insts/*in*/,	aplExtent& extFailures/*out*/, bool bLoadAttrs/* = true*/, bool bFromBase/* = true*/)
{
	if(ext_insts.GetSize()==0)
	{
		return false;
	}
	//*      */
	CaplFinder finder(DEF_SOURCE);
	int instanceIndex = finder.CreateExt(e_lss_refusal, NULL, NULL);
	int itemsIndex = finder.CreateExt(ext_insts, false);
	//   
	finder.AddAttr(instanceIndex, a_lss_refusal_item, itemsIndex, true) ;
	finder.AddToResult(instanceIndex) ;
	finder.Find(m_data, extFailures, bFromBase, !bFromBase, false, bLoadAttrs) ;

	return (extFailures.GetSize()>0) ;
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByMission(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/)
{
	if (pInst==NULL || pInst->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}

	aplExtent extIn;
	extIn.Add(pInst);
	return FindAssociatedFailuresByMission(extIn, extInstances);
}
bool CaplPreExploitationMgr::FindAssociatedFailuresByMission(aplExtent& ext_missions/*in*/,	aplExtent& extFailures/*out*/)
{
	if(ext_missions.GetSize()==0)
	{
		return false;
	}
	//*      */
	CaplFinder finder(DEF_SOURCE);
	int instanceIndex = finder.CreateExt(e_lss_refusal, NULL, NULL);
	int itemsIndex = finder.CreateExt(ext_missions, false);
	//   
	finder.AddAttr(instanceIndex, a_lss_refusal_mission, itemsIndex, true) ;
	finder.AddToResult(instanceIndex) ;
	finder.Find(m_data, extFailures, true, false, false, true) ;

	return (extFailures.GetSize()>0) ;
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByLogEl(CaplInstance* pInst/*in*/,	aplExtent& extInstances/*out*/)
{
	if (pInst==NULL || pInst->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}

	aplExtent extIn;
	extIn.Add(pInst);
	return FindAssociatedFailuresByLogEl(extIn, extInstances);
}
bool CaplPreExploitationMgr::FindAssociatedFailuresByLogEl(aplExtent& ext_items/*in*/,	aplExtent& extInstances/*out*/, bool bFromBase/* = true*/)
{
	if(ext_items.GetSize()==0)
	{
		return false;
	}
	//*      */
	CaplFinder finder(DEF_SOURCE);
	int instanceIndex = finder.CreateExt(e_lss_refusal, NULL, NULL);
	int itemsIndex = finder.CreateExt(ext_items, false);
	//   
	finder.AddAttr(instanceIndex, a_lss_refusal_system, itemsIndex, true) ;
	finder.AddToResult(instanceIndex) ;
	finder.Find(m_data, extInstances, bFromBase, !bFromBase, false, true) ;

	return (extInstances.GetSize()>0) ;
}

bool CaplPreExploitationMgr::FindAssociatedFailuresByInstAndComp(CaplInstance*  pInst/*in*/, CaplInstance*  pComp/*in*/, aplExtent& extFailures/*out*/)
{
	if (pInst==NULL || pInst->GetType()==NULL || pComp==NULL || pComp->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}

	//*      */
	CaplFinder finder(DEF_SOURCE);
	int instanceIndex = finder.CreateExt(e_lss_refusal, NULL, NULL);
	//   
	finder.AddAttr(instanceIndex, a_lss_refusal_planer, pInst, CaplFinder::cmpEqual) ;
	//   
	finder.AddAttr(instanceIndex, a_lss_refusal_item, pComp, CaplFinder::cmpEqual) ;
	finder.AddToResult(instanceIndex) ;
	finder.Find(m_data, extFailures, true, false, false, true) ;

	return !!extFailures.GetSize() ;
}

bool CaplPreExploitationMgr::FindAssociatedBulletins( CaplInstance* pInst/*in*/, inst_to_link_map& instRef_map/*out*/, bool bLoadFromDB/*=true*/)
{
	if (pInst==NULL || pInst->GetType()==NULL)
	{
		ASSERT(FALSE) ;
		return false ;
	}
	aplExtent ext_in;
	ext_in.Add(pInst);
	return FindAssociatedBulletins(ext_in, instRef_map, bLoadFromDB);
}

bool CaplPreExploitationMgr::FindAssociatedBulletins( aplExtent& ext_items/*in*/, inst_to_link_map& instRef_map/*out*/, bool bLoadFromDB/*=true*/)
{
	instRef_map.clear();
	if(ext_items.GetSize()==0) 
	{
		return false;
	}

	aplExtent Links ;
	aplExtent extBulletins ;

	if(bLoadFromDB==true)
	{
		CaplFinder finder(DEF_SOURCE);
		int iBulletinRef = finder.CreateExt(e_ils_bulletin_ref);
		int iExtItems =  finder.CreateExt(ext_items, false);
		// 
		int iAttrs = finder.CreateGroup(iBulletinRef,CaplFinder::grpOR);
		finder.AddAttr(iAttrs, a_ils_bulletin_ref_product, iExtItems, true);
		//  
		finder.AddToResult(iBulletinRef);
#ifdef _DEBUG
		//
		CString sBuf;
		finder.CreateQStr(sBuf,true);
#endif
		//   
		finder.Find(m_data, Links, true, false, false, true, true);
	}
	else
	{
		aplExtent extAllBulletinRefs;
		m_data->GetEntityExtent(e_ils_bulletin_ref, extAllBulletinRefs);
		for(int i=0; i< extAllBulletinRefs.GetSize();++i)
		{
			CaplInstance* pItem= NULL;
			m_data->GetAttr(extAllBulletinRefs[i], a_ils_bulletin_ref_product, pItem);
			for(int j=0; j<ext_items.GetSize(); ++j)
			{
				if(ext_items[j]== pItem)
				{
					Links.Add(extAllBulletinRefs[i]);
					break;
				}
			}
		}
	}
	//   
	for (int i = 0 ; i < Links.GetSize() ; i++)
	{
		CaplInstance* pInst ;
		m_data->GetAttr(Links[i], a_ils_bulletin_ref_bulletin, pInst) ;
		if (pInst)
		{
			extBulletins.Add(pInst);
			//   -
			instRef_map.insert(std::make_pair(pInst, Links[i]) ) ;
		}

	}
	if(extBulletins.GetSize()>0 && bLoadFromDB==true)
	{
		m_api->LoadExtentInfo(extBulletins);
	}

	return (instRef_map.size()>0) ;

}

bool CaplPreExploitationMgr::LoadExtentInfo(aplExtent &ext, aplExtent* pExtRes /*= NULL*/)
{
#ifdef _DEBUG
	//  !
	ASSERT(m_InlineDocUnionQueries.size()==0);
	ASSERT(m_InlineResourcesUnionQueries.size()==0);
	ASSERT(m_InlineMetalsUnionQueries.size()==0);
#endif
	m_InlineDocUnionQueries.clear();
	m_InlineResourcesUnionQueries.clear();
	m_InlineMetalsUnionQueries.clear();

	if(ext.Size==0) return true;

	if (m_api==NULL || !m_api->m_data.IsConnected())
		return false;

	aplExtent others;

	int cnt(0);
	int i;
	CaplLoadData ld(&m_api->m_data, DEF_SOURCE);
	int cnt_lsi_instance(0), num_lsi_instance(1);
	int cnt_components(0), num_components(2);
	int cnt_base_prd_inst(0), num_base_prd_inst(3);
	int cnt_flights(0), num_flights(4);
	int cnt_ch_res(0), num_ch_res(5);
	int cnt_incident(0), num_incident(6);
	int cnt_bulletin(0), num_bulletin(7);
	int cnt_lss_jobs(0), num_lss_jobs(8);
	int cnt_lss_refusals(0), num_lss_refusals(9);
	int cnt_forum_header(0), num_forum_header(10);
	int cnt_forum_sections(0), num_forum_sections(11);
	int cnt_classifier_item(0), num_classifier_item(12);
	int cnt_person(0), num_person(13);
	int cnt_po(0), num_po(14);
	int cnt_user(0), num_user(15);
	int cnt_res_corrects(0), num_res_corrects(16);
	int cnt_reports(0), num_reports(17);
	int cnt_lss3_comp(0), num_lss3_comp(18);
	int cnt_lss3_lsi(0), num_lss3_lsi(19);
	int cnt_lss3_comp_rev(0), num_lss3_comp_rev(20);
	int cnt_lss3_zone(0), num_lss3_zone(21);
	int cnt_consumption(0), num_consumption(22);
	int cnt_equipment(0), num_equipment(23);
	int cnt_process_chart(0), num_process_chart(24);
	int cnt_ssi(0), num_ssi(25);

	ld.SetStartedQueryIndex(27);

	int itc(GetTickCount());
	int j(0);

	int time_load(0);
	int time_atlas_load(0);

	for(j = 0, i = 0; i<ext.Size; ++i, ++j)
	{
		CaplInstance *inst(ext[i]);
		if(inst==NULL)
			continue;
		if (inst->GetAccessmode()> aplRO)
			continue;

		if(inst->GetType()!=NULL && inst->GetId()!=0)
		{
			if(m_api->m_data.IsKindOf(inst, e_ils_component))
			{
				ld.AddQuery(num_components, inst, true);
				++cnt_components;
			}
			else if(m_api->m_data.IsKindOf(inst, e_ils_lsi_instance))
			{
				ld.AddQuery(num_lsi_instance, inst, true);
				++cnt_lsi_instance;
			}
			else if(m_api->m_data.IsKindOf(inst, e_ils_base_product_instance))
			{
				ld.AddQuery(num_base_prd_inst, inst, true);
				++cnt_base_prd_inst;
			}
			else if(m_api->m_data.IsKindOf(inst, e_ils_flight))
			{
				ld.AddQuery(num_flights, inst, true);
				++cnt_flights;
			}
			else if(m_api->m_data.IsKindOf(inst, e_ils_change_resource))
			{
				ld.AddQuery(num_ch_res, inst, true);
				++cnt_ch_res;
			}
			else if(m_api->m_data.IsKindOf(inst, e_apl_incident))
			{
				ld.AddQuery(num_incident, inst, true);
				++cnt_incident;
			}
			else if(m_api->m_data.IsKindOf(inst,e_ils_bulletin))
			{
				ld.AddQuery(num_bulletin, inst, true);
				++cnt_bulletin;
			}
			else if(m_api->m_data.IsKindOf(inst, e_lss_executed_job))
			{
				ld.AddQuery(num_lss_jobs, inst, true);
				++cnt_lss_jobs;
			}
			else if(m_api->m_data.IsKindOf(inst, e_lss_refusal))
			{
				ld.AddQuery(num_lss_refusals, inst, true);
				++cnt_lss_refusals;
			}
			else if(m_api->m_data.IsKindOf(inst, e_forum_question))
			{
				ld.AddQuery(num_forum_header, inst, true);
				++cnt_forum_header;
			}
			else if(m_api->m_data.IsKindOf(inst, e_forum_section))
			{
				ld.AddQuery(num_forum_sections, inst, true);
				++cnt_forum_sections;
			}
			else if(m_api->m_data.IsKindOf(inst, m_api->m_classifier_mgr.e_apl_classifier_level))
			{
				ld.AddQuery(num_classifier_item, inst, true);
				++cnt_classifier_item;
			}
			else if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_person))
			{
				ld.AddQuery(num_person, inst, true);
				++cnt_person;
			}
			else if (m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_pers_org))
			{
				ld.AddQuery(num_po, inst, true);
				++cnt_po;
			}
			else if (m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_apl_user))
			{
				ld.AddQuery(num_user, inst, true);
				++cnt_user;
			}
			else if (m_api->m_data.IsKindOf(inst, e_ils_resource_correct))
			{
				ld.AddQuery(num_res_corrects, inst, true);
				++cnt_res_corrects;
			}
			else if (m_api->m_data.IsKindOf(inst, e_ils_report))
			{
				ld.AddQuery(num_reports, inst, true);
				++cnt_reports;
			}
			else if (m_api->m_data.IsKindOf(inst, e_apl_lss3_component))
			{
				ld.AddQuery(num_lss3_comp, inst, true);
				++cnt_lss3_comp;
			}
			else if (m_api->m_data.IsKindOf(inst, e_apl_lss3_logistic_element))
			{
				ld.AddQuery(num_lss3_lsi, inst, true);
				++cnt_lss3_lsi;
			}
			else if (m_api->m_data.IsKindOf(inst, e_apl_lss3_component_revision))
			{
				ld.AddQuery(num_lss3_comp_rev, inst, true);
				++cnt_lss3_comp_rev;
			}
			else if (m_api->m_data.IsKindOf(inst, e_apl_lss3_zone_access))
			{
				ld.AddQuery(num_lss3_zone, inst, true);
				++cnt_lss3_zone;
			}
			else if(m_api->m_data.IsKindOf(inst,e_ils_consumption))
			{
				ld.AddQuery(num_consumption, inst, true);
				++cnt_consumption;
			}
			else if(m_api->m_data.IsKindOf(inst,e_ils_equipment))
			{
				ld.AddQuery(num_equipment, inst, true);
				++cnt_equipment;
			}
			else if(m_api->m_data.IsKindOf(inst,e_ils_process_chart))
			{
				ld.AddQuery(num_process_chart, inst, true);
				++cnt_process_chart;
			}
			else if (m_api->m_data.IsKindOf(inst, e_ils_ssi))
			{
				ld.AddQuery(num_ssi, inst, true);
				++cnt_ssi;
			}
			else
			{
				others.Add(inst);
				--cnt;
			}
			++cnt;

			if(j>m_MaxItemsLoad || i>=ext.Size-1)
			{
				if(cnt_lsi_instance>0)
				{
					LDFillLSIInstance(&ld, num_lsi_instance);
					cnt_lsi_instance = 0;
				}
				if(cnt_components>0)
				{
					LDFillComponent(&ld, num_components);
					cnt_components = 0;
				}
				if(cnt_base_prd_inst>0)
				{
					LDFillBaseProductInstance(&ld, num_base_prd_inst);
					cnt_base_prd_inst = 0;
				}
				if(cnt_flights>0)
				{
					LDFillFlights(&ld, num_flights);
					cnt_flights = 0;
				}
				if(cnt_ch_res>0)
				{
					LDFillChRes(&ld, num_ch_res);
					cnt_ch_res=0;
				}
				if(cnt_incident>0)
				{
					LDFillIncidents(&ld, num_incident);
					cnt_incident = 0;
				}
				if(cnt_bulletin>0)
				{
					LDFillBulletins(&ld, num_bulletin);
					cnt_bulletin = 0;
				}
				if(cnt_lss_jobs>0)
				{
					LDFillExecutedLSSJobs(&ld, num_lss_jobs);
					cnt_lss_jobs = 0;
				}
				if(cnt_lss_refusals>0)
				{
					LDFillLSSRefusals(&ld, num_lss_refusals);
					cnt_lss_refusals = 0;
				}
				if (cnt_classifier_item>0)
				{
					LDFillClassifierItems(&ld, num_classifier_item);
					cnt_classifier_item = 0;
				}
				if (cnt_person>0)
				{
					LDFillPerson(&ld, num_person);
					cnt_person = 0;
				}
				if (cnt_po>0)
				{
					LDFillPO(&ld, num_po);
					cnt_po = 0;
				}
				if (cnt_user>0)
				{
					LDFillUser(&ld, num_user);
					cnt_user = 0;
				}
				if (cnt_res_corrects>0)
				{
					LDFillResCorrects(&ld, num_res_corrects);
					cnt_res_corrects = 0;
				}
				if (cnt_reports>0)
				{
					LDFillReports(&ld, num_reports);
					cnt_reports = 0;
				}
				if (cnt_lss3_comp>0)
				{
					LDFillLSS3Component(&ld, num_lss3_comp);
					cnt_lss3_comp = 0;
				}
				if (cnt_lss3_lsi>0)
				{
					LDFillLSS3LSI(&ld, num_lss3_lsi);
					cnt_lss3_lsi = 0;
				}
				if (cnt_lss3_comp_rev>0)
				{
					LDFillLSS3ComponentRevisions(&ld, num_lss3_comp_rev);
					cnt_lss3_comp_rev = 0;
				}
				if (cnt_lss3_zone>0)
				{
					LDFillLSS3Zone(&ld, num_lss3_zone);
					cnt_lss3_zone = 0;
				}
				if (cnt_consumption>0)
				{
					LDFillLSS3Consumption(&ld, num_consumption);
					cnt_consumption = 0;
				}
				if (cnt_equipment>0)
				{
					LDFillLSS3Equipment(&ld, num_equipment);
					cnt_equipment = 0;
				}
				if (cnt_process_chart>0)
				{
					LDFillLSS3ProcessChart(&ld, num_process_chart);
					cnt_process_chart = 0;
				}
				if (cnt_ssi > 0)
				{
					LDFillSSI(&ld, num_ssi);
					cnt_ssi = 0;
				}

				int tc1(GetTickCount());

				aplExtent res;

				if(cnt>0)
				{
					LDFillInlineLoad(&ld);

					ld.LoadEx(true, &res);
					ld.ClearQuery();

					if (pExtRes)
						pExtRes->Append(res);

					//  
					aplExtent ext2sload;
					for(int ii=0; ii<res.Size;++ii)
					{
						if(res[ii]->attrs==NULL)
						{
							if (ext.Find(res[ii])<0)	//   ,     ,  -  
								ext2sload.Add(res[ii]);
						}
						else if(m_api->m_data.IsKindOf(res[ii], m_api->m_classifier_mgr.e_apl_classifier_level)) 
						{
							CaplInstance *inst;
							m_api->m_data.GetAttr(res[ii], m_api->m_classifier_mgr.a_apl_classifier_level_parent, inst);
							if(inst==NULL) continue;
							if(inst->attrs==0)
								ext2sload.Add(res[ii]);
						}
					}
					if(ext2sload.Size>0)
						LoadExtentInfo(ext2sload);
				}
				j = 0;
			}
		}
	}

	return true;
}

void CaplPreExploitationMgr::LDFindAssociatedResources(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return;
	if(ld==NULL) return;

	m_InlineResourcesUnionQueries.insert(iInd);
}

void CaplPreExploitationMgr::LDFindAssociatedDocuments(CaplLoadData *ld, int iInd, UINT nFlags)
{
	m_InlineDocUnionQueries.insert(iInd);
}

void CaplPreExploitationMgr::LDFindAssociatedMetals(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	m_InlineMetalsUnionQueries.insert(iInd);
}

int CaplPreExploitationMgr::LDFillLSIInstance(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int ind1 = ld->AddQuery(_T('d'), iInd, 0, a_ils_lsi_instance_of_product_instance, true, true);
	int ind2 = ld->AddQuery(_T('d'), iInd, 0, a_ils_lsi_instance_installed, true, true);

	if((nFlags&LDF_DISABLE_FIND_PRODUCT_INSTANCE)==0)
	{
		LDFillBaseProductInstance(ld, ind1, nFlags | LDF_DISABLE_FINDCOMPONENTS);
	}

	if ((nFlags&LDF_DISABLE_FIND_INSTALLED) == 0)
	{
		LDFillBaseProductInstance(ld, ind2, nFlags | LDF_DISABLE_FINDCOMPONENTS);
	}

	int ind3 = ld->AddQuery(_T('d'), iInd, 0, a_ils_lsi_instance_of_ils_lsi, true, true);
	LDFillLSS3LSI(ld, ind3);

	if((nFlags&LDF_DISABLE_FINDCOMPONENTS)==0)
	{
		int ind4 = LDFindReferenceComponentsLSI(ld, iInd, nFlags|LDF_DISABLE_FIND_LSIINSTANCES);
		int ind5 = ld->AddQuery(_T('d'), ind4, 0, a_ils_component_ils_product_instance, true, true);
		LDFillBaseProductInstance(ld, ind5, nFlags|LDF_DISABLE_FINDCOMPONENTS);
	}

	return iInd;
}

int CaplPreExploitationMgr::LDFindReferenceComponentsLSI(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes =	ld->AddQuery(_T('r'), iInd, e_ils_component, a_ils_component_place, true, true);
	LDFillComponent(ld, iRes, nFlags|LDF_DISABLE_FIND_LSIINSTANCES);

	return iRes;
}

int CaplPreExploitationMgr::LDFillComponent(CaplLoadData *ld, int iInd, UINT nFlags)
{
	int ind_ed = ld->AddQuery(_T('d'), iInd, 0, a_ils_component_ils_product_instance, true, true);
	int ind_ing = ld->AddQuery(_T('d'), iInd, 0, a_ils_component_place, true, true);
	int ind_root = ld->AddQuery(_T('d'), iInd, 0, a_ils_component_root, true, true);

	if((nFlags&LDF_DISABLE_FIND_PRODUCT_INSTANCE)==0)
	{
		LDFillBaseProductInstance(ld, ind_ed, nFlags|LDF_DISABLE_FINDCOMPONENTS);
		LDFillBaseProductInstance(ld, ind_root, nFlags|LDF_DISABLE_FINDCOMPONENTS);
	}
	if((nFlags&LDF_DISABLE_FIND_LSIINSTANCES)==0)
		LDFillLSIInstance(ld, ind_ing, nFlags|LDF_DISABLE_FINDCOMPONENTS|LDF_DISABLE_FIND_INSTALLED);

	return iInd;
}

int CaplPreExploitationMgr::LDFillBaseProductInstance(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('d'), iInd, 0, a_ils_base_product_instance_of_ils_base_product, true, true);
	LDFillLSS3Component(ld, iRes);

	LDFindAssociatedResources(ld, iRes);
	LDFindAssociatedResources(ld, iInd);
	LDFindAssociatedDocuments(ld, iInd);
	LDFindAssociatedDocuments(ld, iRes);
	LDFindAssociatedMetals(ld, iRes);
	LDFindAssociatedMetals(ld, iInd);

	if((nFlags&LDF_DISABLE_FINDCOMPONENTS)==0)
		LDFindReferenceComponentsPI(ld, iInd);

	return iInd;
}

int CaplPreExploitationMgr::LDFindReferenceComponentsPI(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes =	ld->AddQuery(_T('r'), iInd, e_ils_component, a_ils_component_ils_product_instance, true, true);
	int ind1 =	ld->AddQuery(_T('d'), iRes, 0, a_ils_component_place, true, true);

	LDFillLSIInstance(ld, ind1, LDF_DISABLE_FIND_PRODUCT_INSTANCE|LDF_DISABLE_FIND_INSTALLED|LDF_DISABLE_FINDCOMPONENTS);

	return iRes;
}

int CaplPreExploitationMgr::LDFillFlights(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;
	int iRes = ld->AddQuery(_T('d'), iInd, 0, a_ils_flight_base_product, true, true);
	LDFillBaseProductInstance(ld,iRes);
	iRes = ld->AddQuery(_T('d'), iInd, 0, a_ils_flight_additional_events,true,true);
	iRes = ld->AddQuery(_T('r'), iInd, e_ils_change_resource, a_ils_change_resource_basis, true,true);
	if((nFlags&LDF_DISABLE_FIND_CHANGE_RESOURCES)==0)
		LDFillChRes(ld,iRes);
	return iRes;
}

int CaplPreExploitationMgr::LDFindAssociatedLSSJobs(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('r'), iInd, e_lss_executed_job, a_lss_executed_job_refusal_select, true, true);
	LDFillExecutedLSSJobs(ld, iRes);

	return iRes;
}

int CaplPreExploitationMgr::LDFillChRes(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('d'), iInd, 0,a_ils_change_resource_basis,true,true);

	iRes = ld->AddQuery(_T('d'),iInd,0,a_ils_change_resource_product_instance,true,true);
	if((nFlags&LDF_DISABLE_FIND_PRODUCT_INSTANCE)==0)
	{
		LDFillBaseProductInstance(ld, iRes);
	}

	return iRes;
}

int CaplPreExploitationMgr::LDFillIncidents(CaplLoadData *ld, int iInd, UINT nFlags)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('d'), iInd, 0, a_apl_incident_refusals,true,true);
	iRes = ld->AddQuery(_T('d'), iInd, 0, a_apl_incident_group,true,true);
	iRes = ld->AddQuery(_T('d'), iInd, 0, a_apl_incident_situation,true,true);
	LDFindAssociatedResources(ld, iInd);

	return iRes;
}

int CaplPreExploitationMgr::LDFillBulletins(CaplLoadData *ld, int iInd, UINT nFlags/* = 0*/)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	//   
	LDFindAssociatedResources(ld, iInd);
	//  
	LDFindAssociatedDocuments(ld, iInd);
	//    
	LDFindBulletinReferences(ld, iInd);

	int i1 = ld->AddQuery(_T('r'), iInd, e_ils_bulletin_ref, a_ils_bulletin_ref_bulletin, true, true);
	int i2 = ld->AddQuery(_T('d'), i1, 0, a_ils_bulletin_ref_product, true, true);
	ld->AddQuery(_T('d'), i1, 0, a_ils_bulletin_ref_guid, true, true);
	LDFillBaseProductInstance(ld, i2);

	// 
	if (!(nFlags&LDF_DISABLE_FIND_RESOURCE_CORRECT))
	{
		int i4 = ld->AddQuery(_T('r'), iInd, e_ils_resource_correct, a_ils_resource_correct_basis, true, true);
		LDFillResCorrects(ld, i4, nFlags|LDF_DISABLE_FIND_BULLETINS);
		LDFindAssociatedResources(ld, i4);
	}

	return iInd;
}

int CaplPreExploitationMgr::LDFindBulletinReferences(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('r'), iInd, e_ils_bulletin_ref, a_ils_bulletin_ref_bulletin, true, true);
	int i1 = ld->AddQuery(_T('d'), iRes, 0, a_ils_bulletin_ref_product, true, true);

	//    
	LDFillBaseProductInstance(ld, i1);

	return iRes;
}

int CaplPreExploitationMgr::LDFillExecutedLSSJobs(CaplLoadData *ld, int iInd, UINT nFlags)
{
	ld->AddQuery(_T('d'), iInd, 0, a_lss_executed_replacement_job_of_job, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_lss_executed_maintenance_job_of_job, true, true);
	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_lss_executed_replacement_job_item, true, true);
	LDFillLSS3Component(ld, i1);
	int i2 = ld->AddQuery(_T('d'), iInd, 0, a_lss_executed_maintenance_job_item, true, true);
	LDFillLSS3Component(ld, i2);

	//     
	int iRepl = ld->AddQuery(_T('r'),iInd,e_lss_executed_replacement_job,a_lss_executed_replacement_job_of_job,true,true);
	int iMain = ld->AddQuery(_T('r'),iInd,e_lss_executed_maintenance_job,a_lss_executed_maintenance_job_of_job,true,true);

	i1 = ld->AddQuery(_T('d'), iRepl, 0, a_lss_executed_replacement_job_item, true, true);
	LDFillLSS3Component(ld, i1);

	i1 = ld->AddQuery(_T('d'), iMain, 0, a_lss_executed_maintenance_job_item, true, true);
	LDFillLSS3Component(ld, i1);

	//   
	LDFindAssociatedLSSRefusals(ld, iInd, LDF_DISABLE_FIND_LSS_JOBS);

	return iInd;
}

int CaplPreExploitationMgr::LDFindAssociatedLSSRefusals(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('r'), iInd, e_lss_refusal, a_lss_refusal_form_removal, true, true);
	if((nFlags&LDF_DISABLE_FIND_LSS_JOBS)==0)
		LDFillLSSRefusals(ld, iRes);

	return iRes;
}

int CaplPreExploitationMgr::LDFillLSSRefusals(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iInd2 = ld->AddQuery(_T('d'), iInd, 0, a_lss_refusal_item, true, true);
	int iInd3 = ld->AddQuery(_T('d'), iInd, 0, a_lss_refusal_planer, true, true);
	int iInd4 = ld->AddQuery(_T('d'), iInd, 0, a_lss_refusal_defective_items, true, true);
	int iInd5 = ld->AddQuery(_T('d'), iInd, 0, a_lss_refusal_mission, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_lss_refusal_system, true, true);

	LDFillLSS3Component(ld, iInd2);

	if((nFlags&LDF_DISABLE_FIND_PRODUCT_INSTANCE)==0)
	{
		LDFillBaseProductInstance(ld, iInd3, LDF_DISABLE_FINDCOMPONENTS);
	}

	LDFillFlights(ld, iInd5);

	int iInd6 = ld->AddQuery(_T('d'), iInd4, 0, a_lss_refusal_defective_item_of_ils_product, true, true);
	LDFillLSS3Component(ld, iInd6);

	LDFindAssociatedResources(ld, iInd);
	LDFindAssociatedLSSJobs(ld, iInd);

	return iInd;
}

int CaplPreExploitationMgr::LDFillClassifierItems(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('d'), iInd, 0, m_api->m_classifier_mgr.a_apl_classifier_level_system, true, true);

	return iInd;
}

int CaplPreExploitationMgr::LDFillPerson(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('d'), iInd, 0, m_api->m_appr_mgr.a_pers_roles, true, true);

	return iInd;
}

int CaplPreExploitationMgr::LDFillPO(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iInd1 = ld->AddQuery(_T('d'), iInd, 0, m_api->m_appr_mgr.a_po_the_pers, true, true);
	int iInd2 = ld->AddQuery(_T('d'), iInd, 0, m_api->m_appr_mgr.a_po_the_org, true, true);

	LDFillPerson(ld, iInd1);

	return iInd;
}

int CaplPreExploitationMgr::LDFillUser(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iInd1 = ld->AddQuery(_T('d'), iInd, 0, m_api->m_appr_mgr.a_apl_user_po, true, true);
	LDFillPO(ld, iInd1);
	LDFillPerson(ld, iInd1);

	return iInd;
}

int CaplPreExploitationMgr::LDFillResCorrects(CaplLoadData *ld, int iInd, UINT nFlags /*= 0*/)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_ils_resource_correct_of_item, true, true);
	int iBas = ld->AddQuery(_T('d'), iInd, 0, a_ils_resource_correct_basis, true, true);
	if (!(nFlags&LDF_DISABLE_FIND_REFUSALS))
		LDFillLSSRefusals(ld, iBas, LDF_DISABLE_FIND_RESOURCE_CORRECT);
	if (!(nFlags&LDF_DISABLE_FIND_BULLETINS))
		LDFillBulletins(ld, iBas, LDF_DISABLE_FIND_RESOURCE_CORRECT);

	if (!(nFlags&LDF_DISABLE_FIND_PRODUCT_INSTANCE))
		LDFillBaseProductInstance(ld, i1);

	//   
	if((nFlags&LDF_DISABLE_FIND_CHANGE_RESOURCES)==0)
		LDFindAssociatedResourceChanges(ld, iInd);

	return iInd;
}

int CaplPreExploitationMgr::LDFindAssociatedResourceChanges(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int iRes = ld->AddQuery(_T('r'), iInd, e_ils_change_resource, a_ils_change_resource_basis, true, true);

	LDFillChRes(ld,iRes);

	return iRes;
}

int CaplPreExploitationMgr::LDFillReports(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	//  
	LDFindAssociatedDocuments(ld, iInd);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3Component(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3comp_type, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3comp_material, true, true);
	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3comp_actual_supply_option, true, true);
	ld->AddQuery(_T('d'), i1, 0, a_apl_lss3comp_org_rel_organization, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3comp_ssi, true, true);

	LDFindAssociatedResources(ld, iInd);
	LDFindAssociatedMetals(ld, iInd);

	//   
	LDFindAssociatedLSS3Analogs(ld, iInd, nFlags);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3ComponentRevisions(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3_comprev_of_product, true, true);
	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3_comprev_actual_supply_option, true, true);
	ld->AddQuery(_T('d'), i1, 0, a_apl_lss3comp_org_rel_organization, true, true);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3LSI(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3logel_parent_component, true, true);
	LDFillLSS3Component(ld, i1);

	int i2 = ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3logel_child_component, true, true);
	LDFillLSS3Component(ld, i1);

	return iInd;
}

void CaplPreExploitationMgr::LDFillInlineLoad(CaplLoadData *pLD)
{
	//  20-25%  

	TIntSet_it i_it;
	if(m_InlineDocUnionQueries.size()>0)
	{
		int iInd(-1);
		for(i_it = m_InlineDocUnionQueries.begin(); i_it!=m_InlineDocUnionQueries.end(); ++i_it)
		{
			if(iInd<0)
				iInd = pLD->AddQuery(_T('u'), (*i_it), (CaplEntity*)NULL, NULL, true, true);
			else
				pLD->AddQuery(iInd, _T('u'), (*i_it), (CaplEntity*)NULL, NULL, true, true);
		}

		int res = pLD->AddQuery(_T('r'), iInd, m_api->m_doc_mgr.e_apl_doc_ref, m_api->m_doc_mgr.a_apl_doc_ref_item, true, true);
		int res2 = pLD->AddQuery(_T('d'), res, 0, m_api->m_doc_mgr.a_apl_doc_ref_doc, true, true);

		LDFillDocuments(pLD, res2);
	}
	if(m_InlineResourcesUnionQueries.size()>0)
	{
		int iInd(-1);
		for(i_it = m_InlineResourcesUnionQueries.begin(); i_it!=m_InlineResourcesUnionQueries.end(); ++i_it)
		{
			if(iInd<0)
				iInd = pLD->AddQuery(_T('u'), (*i_it), (CaplEntity*)NULL, NULL, true, true);
			else
				pLD->AddQuery(iInd, _T('u'), (*i_it), (CaplEntity*)NULL, NULL, true, true);
		}
		pLD->AddQuery(_T('r'), iInd, e_ils_resource, a_ils_resource_item, true, true);;
	}
	if(m_InlineMetalsUnionQueries.size()>0)
	{
		int iInd(-1);
		for(i_it = m_InlineMetalsUnionQueries.begin(); i_it!=m_InlineMetalsUnionQueries.end(); ++i_it)
		{
			if(iInd<0)
				iInd = pLD->AddQuery(_T('u'), (*i_it), (CaplEntity*)NULL, NULL, true, true);
			else
				pLD->AddQuery(iInd, _T('u'), (*i_it), (CaplEntity*)NULL, NULL, true, true);
		}
		pLD->AddQuery(_T('r'), iInd, e_ils_metal, a_ils_metal_item, true, true);;
	}

	m_InlineDocUnionQueries.clear();
	m_InlineResourcesUnionQueries.clear();
	m_InlineMetalsUnionQueries.clear();
}

int CaplPreExploitationMgr::LDFillDocuments(CaplLoadData *ld, int iInd, UINT nFlags)
{
	ld->AddQuery(_T('d'), iInd, 0, m_api->m_doc_mgr.a_doc_kind, true, true);
	int ires1 = ld->AddQuery(_T('d'), iInd, 0, m_api->m_doc_mgr.a_apl_doc_active, true, true);
	ld->AddQuery(_T('d'), ires1, 0, m_api->m_doc_mgr.a_apl_doc_rev_access_form, true, true);

	return iInd;
}

void CaplPreExploitationMgr::LoadUnitsAndResourceNames()
{
	if (!m_api->m_data.IsConnected())
		return;

	m_api->LoadItemInfo(m_api->m_data.GetCurrUser());

	if(m_bFullInit)
	{
		m_api->m_classifier_mgr.LoadDictionary();
		m_api->m_charact_mgr.LoadDictionary();
		m_api->m_options_mgr.LoadDictionary();
		m_api->m_unit_exch_mgr.LoadUnits();
	}

	CaplLoadData ld(&m_api->m_data, DEF_SOURCE);
	if(m_bFullInit)
		ld.AddQuery(_T('e'), 0, m_api->m_appr_mgr.e_org, 0, true, true);
	CaplInstance *ciPerson = m_api->m_appr_mgr.GetCurrentPerson();
	if (ciPerson)
	{
		if (ciPerson->attrs==NULL)
			m_api->LoadItemInfo(ciPerson);
	}
	ld.AddQuery(_T('e'), 0, e_ils_resource_name_element, 0, true, true);
	ld.AddQuery(_T('e'), 0, e_ils_resource_name, 0, true, true);
	ld.AddQuery(_T('e'), 0, e_apl_logbook, 0, true, true);
	ld.AddQuery(_T('e'), 0, e_apl_export_logbook, 0, true, true);
	ld.AddQuery(_T('e'), 0, e_apl_logbook_item, 0, true, true);
	ld.AddQuery(_T('e'), 0, m_api->m_doc_mgr.e_dt, 0, true, true);
	ld.AddQuery(_T('e'), 0, e_forum_section, 0, true, true);
	ld.AddQuery(_T('e'), 0, m_api->m_prd_mgr.e_apl_language, 0, true, true);
	ld.AddQuery(_T('e'), 0, e_ils_report, 0, true, true);
	ld.LoadEx();
}

bool CaplPreExploitationMgr::LoadItemInfo(CaplInstance* item)
{
	if (item==NULL)
		return false;

	aplExtent ext;
	ext.Add(item);
	return LoadExtentInfo(ext);
}

int CaplPreExploitationMgr::LDFillLSS3Zone(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_apl_lss3_zone_parent_fi, true, true);
	LDFillLSS3Component(ld, i1);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3Analogs(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int i1 = ld->AddQuery(_T('d'), iInd, 0, a_alt_base_pdf, true, true);
	int i2 = ld->AddQuery(_T('d'), iInd, 0, a_alt_alt_pdf, true, true);
	if((nFlags&LDF_DISABLE_FIND_LSS3_COMPONENTS)==0)
	{
		LDFillLSS3Component(ld, i1);
		LDFillLSS3Component(ld, i2);
	}

	return iInd;
}

int CaplPreExploitationMgr::LDFindAssociatedLSS3Analogs(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	int i1 = ld->AddQuery(_T('r'), iInd, e_alt_bidir, a_alt_base_pdf, true, true);
	int i2 = ld->AddQuery(_T('r'), iInd, e_alt_bidir, a_alt_alt_pdf, true, true);
	LDFillLSS3Analogs(ld, i1, nFlags|LDF_DISABLE_FIND_LSS3_COMPONENTS);
	LDFillLSS3Analogs(ld, i2, nFlags|LDF_DISABLE_FIND_LSS3_COMPONENTS);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3Consumption(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('d'), iInd, 0, a_ils_consumption_manufacturer, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_ils_consumption_supplier, true, true);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3Equipment(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('d'), iInd, 0, a_ils_equipment_manufacturer, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_ils_equipment_supplier, true, true);

	return iInd;
}

int CaplPreExploitationMgr::LDFillLSS3ProcessChart(CaplLoadData *ld, int iInd, UINT nFlags /* = 0 */)
{
	if(iInd<0) return -1;
	if(ld==NULL) return -1;

	ld->AddQuery(_T('r'), iInd, e_ils_time_interval, a_ils_time_interval_object, true, true);

	return iInd;
}





//***************************************************************************************
//*****      PSS
//***************************************************************************************

bool CaplPreExploitationMgr::FindAssociatedRefusal(CaplInstance *item, aplExtent &ext_refusal,bool bLoadRefusionInfo)
{
	ext_refusal.Clear();
	if(0==item) return false;
	if(item->IsDeleted()) return false;

	CString qstr;
	if ((m_api->m_data.IsKindOf(item,m_api->m_prd_mgr.e_apl_pdf)) /*|| (m_api->m_data.IsKindOf(item,m_api->m_prd_mgr.e_prd))*/)
	{
		aplExtent ext_refusals;
		ext_refusals.Clear();
		qstr = _T("");
		//if (m_api->m_data.IsKindOf(item,m_api->m_prd_mgr.e_prd))
		//	item = m_api->m_prd_mgr.FindPdfById(item, _T(""));
		qstr.Format(_T("SELECT_load_all Ext_1 or Ext_2 or Ext_3 FROM Ext_1 {apl_refusal(.planer->apl_product_instance.formation = #%i)} \
					Ext_2 {apl_refusal(.item->apl_product_instance.formation = #%i)}    \
					Ext_3 {apl_refusal(.part->apl_product_instance.formation = #%i )} END_SELECT"), item->GetId(), item->GetId(), item->GetId());
	}
	//  
	else if (m_api->m_data.IsKindOf(item,m_api->m_prd_inst_mgr.e_prd_inst))
	{
		aplExtent ext_refusals;
		ext_refusals.Clear();
		qstr = _T("");

		qstr.Format(_T("SELECT_load_all Ext_1 or Ext_2 or Ext_3 FROM Ext_1 {apl_refusal(.planer->apl_product_instance.# = #%i)} \
					Ext_2 {apl_refusal(.item->apl_product_instance.# = #%i)}    \
					Ext_3 {apl_refusal(.part->apl_product_instance.# = #%i )} END_SELECT"), item->GetId(), item->GetId(), item->GetId());
	}
	else return false;
		

	if (m_api->m_data.NET_QueryEditParse(qstr, 0,0))
		m_api->m_data.NET_QueryExecute(ext_refusal,0);



	if(bLoadRefusionInfo && ext_refusal.GetSize()>0) LoadRefusalsInfo(ext_refusal);

	return true;
}

bool CaplPreExploitationMgr::LoadRefusalsInfo(aplExtent &ext)
{
	if(m_data==0)return false;

	if(!m_data->IsConnected()) return true;

	CaplLoadData ld(m_data,DEF_SOURCE);
	int i,iLoad=0;
	for(i=0;i<ext.Size;i++)
	{
		CaplInstance *inst=ext[i];
		if(inst==0) continue;
		if(inst->GetId()==0) continue;
		if(inst->GetType()==0) continue;
		if(inst->GetAccessmode()>aplRO) continue;

		ld.AddQuery(0,inst,true);
		iLoad++;
		if(iLoad==m_MaxItemsLoad || (i==(ext.Size-1) && iLoad>0))
		{ 
			iLoad=0;
			ld.AddQuery(_T('d'), 0, 0, a_apl_refusal_type, true, true);	
			ld.AddQuery(_T('d'), 0, 0, a_apl_refusal_stage, true, true);	
			if(!ld.LoadEx()){
				if(apidata.GetLastAplError()!=APL_SOCK_OPERATION_IN_PROGRESS){
					if(m_api->m_ModeInteractive)AfxMessageBox(S::ErrorLoadDataMgr(),MB_OK|MB_ICONSTOP);
				}
			}
		}
	}


	//   
	aplExtent ext_pdf, ext_pi,ext_class_lev;
	CaplInstance *inst1;
	for(i=0;i<ext.Size;i++)
	{
		CaplInstance *inst=ext[i];
		if(inst==0) continue;
		if(inst->GetId()==0) continue;
		if(inst->GetType()==0) continue;
		if(inst->GetAccessmode()>aplRO) continue;

		m_api->m_data.GetAttr(inst,a_apl_refusal_stage,inst1);
		if(0!=inst1) ext_class_lev.Add(inst1);

		m_api->m_data.GetAttr(inst,a_apl_refusal_planer,inst1);
		if(0!=inst1)
		{
			if(m_api->m_data.IsKindOf(inst1,m_api->m_prd_inst_mgr.e_prd_inst)) ext_pi.Add(inst1);
			else ext_pdf.Add(inst1);
		}

		m_api->m_data.GetAttr(inst,a_apl_refusal_item,inst1);
		if(0!=inst1)
		{
			if(m_api->m_data.IsKindOf(inst1,m_api->m_prd_inst_mgr.e_prd_inst)) ext_pdf.Add(inst1);
			else ext_pdf.Add(inst1);
		}
	}

	if(ext_class_lev.GetSize()>0) m_api->m_classifier_mgr.LoadClassifierInfo(ext_class_lev);
	if(ext_pi.GetSize()>0) m_api->m_prd_inst_mgr.LoadPrdInstInfo(ext_pi);
	if(ext_pdf.GetSize()>0) m_api->m_prd_mgr.LoadExtentInfo(ext_pdf);

	return true;
}


//  
// item -       ()
CaplInstance  *CaplPreExploitationMgr::CreateRefusal(CaplInstance *item)
{
	CString opt;
	m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("\\   "), opt, _T(""));
	if(opt!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,opt))
			{AfxMessageBox(APL_T("       !"),MB_OK|MB_ICONSTOP); return 0;}
	}

	CRefusalMiniDlg dlg;
	dlg.m_api=m_api;

	CaplSetResourceHandle setres(module_inst);

	if(dlg.DoModal()!=IDOK) return 0;

	CaplInstance *refusal=dlg.m_refusal;
	if(0==refusal) return 0;

	if(0!=item)
	{

	}

	return refusal;
}

//   
bool  CaplPreExploitationMgr::ShowRefusalProperies(CaplInstance *refusal)
{
	if(0==refusal) return false;
	if(refusal->IsDeleted()){AfxMessageBox(APL_T(" !"),MB_OK|MB_ICONSTOP); return false;};


	bool bNoView=false, nNoEdit=false;

	CString opt;
	m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("\\   "), opt, _T(""));
	if(opt!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,opt)) nNoEdit=true;
	}

	m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("\\   "), opt, _T(""));
	if(opt!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,opt)) bNoView=true;
	}	

	if(bNoView && nNoEdit)
	{
		AfxMessageBox(APL_T("      !"), MB_ICONSTOP|MB_OK);
		return false;
	}

	CRefusalMiniDlg dlg;
	if(nNoEdit) dlg.m_bReadOnly=true;

	dlg.m_api=m_api;
	dlg.m_refusal=refusal;

	CaplSetResourceHandle setres(module_inst);

	if(dlg.DoModal()!=IDOK) return false;

	return true;
}

bool  CaplPreExploitationMgr::DeleteRefusal(CaplInstance *refusal)
{
	if(0==refusal) return false;
	if(refusal->IsDeleted()){AfxMessageBox(APL_T(" !"),MB_OK|MB_ICONSTOP); return false;};
	if(refusal->GetAccessmode()>aplOWN){AfxMessageBox(APL_T("  !"),MB_OK|MB_ICONSTOP); return false;};

	CString opt;

	m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("\\   "), opt, _T(""));
	if(opt!=_T(""))
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,opt))
			{AfxMessageBox(APL_T("      !"),MB_OK|MB_ICONSTOP); return false;};
	}
	else
	{
		m_api->m_options_mgr.GetOptionValueBN(APL_NO_T("\\   "), opt, _T(""));
		if(opt!=_T(""))
		{
			if(!m_api->m_appr_mgr.CheckPersonRole(0,opt))
				{AfxMessageBox(APL_T("    !"),MB_OK|MB_ICONSTOP); return false;};
		}
	}

	m_api->m_data.DeleteInstance(refusal);
	m_api->SaveChanges();
	return true;
}




BOOL CaplPreExploitationMgr::FindPdf1(CaplInstance **Result, TFindPdfModes Mode, UINT Flags, LPCTSTR id, LPCTSTR name, bool bAutoExecute)
{
	if(m_api==NULL)return false;
	if(!m_api->m_data.IsDictLoad()) return false;
	if(Result==NULL) return false;

	/*if (Mode==aplFindPdfById)
	{
		CFindPDFByIDDlg dlg(m_api);
		BOOL bRes = dlg.DoModal();

		if(bRes==IDOK)
			*Result = dlg.m_SelectedInst;

		return bRes==IDOK;
	}*/

	CaplSetResourceHandle setres(module_inst);

	CFindPDFDlg dlg(m_api, Mode, Flags);
	dlg.m_sId = id;
	dlg.m_sName = name;

	dlg.m_bAutoExecute = bAutoExecute;
	BOOL bRes = dlg.DoModal();

	if(bRes==IDOK)
		*Result = dlg.m_SelectedInst;

	return bRes==IDOK;
}

/************************************************************************/
BOOL CaplPreExploitationMgr::FindPrdInst1(CaplInstance **Result, TFindPrdInstModes Mode, UINT Flags , LPCTSTR id , LPCTSTR name , LPCTSTR sn  )
{
	if(m_api == NULL) return FALSE;
	if(!m_api->m_data.IsDictLoad()) return FALSE;
	if(Result==NULL) { AfxMessageBox(APL_T("    ,    !"),MB_ICONSTOP); return FALSE;}
//	if(Mode==aplFindItemChilds && planer==NULL){ AfxMessageBox( APL_T("   !"),MB_ICONSTOP);  return FALSE;}
	if(Flags&APL_FD_AUTOCREATE && Flags&APL_FD_USE_SIMPLE_CREATE_DIALOG)
	{
		//SetError( APL_T("  !"), __FILE__, __LINE__);
		Flags &= ~APL_FD_AUTOCREATE;
	}
	if(Flags&APL_FD_AUTOCREATE || Flags&APL_FD_USE_SIMPLE_CREATE_DIALOG)
		Flags |= APL_FD_SHOW_CREATE_BTN;
		
	CaplSetResourceHandle setres(module_inst);

	CFindPrdInstDlgEx dlg(m_api, Mode, Flags);
	//dlg.m_iPlaner = planer;
	dlg.m_sId = id;
	dlg.m_sName = name;
	dlg.m_sSN = sn;
	//dlg.m_bAutoExecute = bAutoExecute;

	BOOL bRes = dlg.DoModal()==IDOK;
	if(bRes)
		*Result = dlg.m_SelectedItem;

	return bRes;
}

bool CaplPreExploitationMgr::SelectPlanerSystem1(CaplInstance **SelectedSystem, TSelectSystemMode Mode, CaplInstance *Planer, bool bSkipPlanerAptec)
{
	return false;
	/*aplEMErrorClear;
	if(m_api==NULL) return false;
	if(!m_api->m_data.IsDictLoad()) return false;

	HINSTANCE hInst = AfxGetResourceHandle();
	AfxSetResourceHandle(hDllInst);

	CSelectSystemDlg dlg(m_api);
	dlg.m_Mode = Mode;
	if (Planer)
		dlg.m_planers.Add(Planer);
	dlg.m_bSkipAptec = bSkipPlanerAptec;
	if(dlg.DoModal()==IDOK)
	{
		if(SelectedSystem)
			*SelectedSystem = dlg.m_SelectedItem;
		AfxSetResourceHandle(hInst);
		return true;
	}
	AfxSetResourceHandle(hInst);

	return false;*/
}


//*************************************************************************
//*************************************************************************
//*************************************************************************
//*****************************************************************************/*
bool FindIlsRes4Ext(CaplAPI *m_api, CaplMap &item_map, CaplInstance *resName)
{
	if(0==resName) return false;
	if(0==item_map.Size)  return true;

	int i,j,count=0;
	aplExtent ext;
	CaplInstance *inst;

	item_map.SortIn();
	for(i=0;i<item_map.Size;i++)	(item_map.Data[i]).out=0;

	aplExtent tmpExt;

	CString stql,temp1;
	stql.GetBuffer(1024*1024);
	stql.ReleaseBuffer(1024*1024);	

	stql=_T("SELECT Ext1 FROM Ext {");

	for(i=0;i<item_map.Size;i++, ++count)
	{
		if(item_map.Data[i].in==0)continue;
		inst=(CaplInstance*)item_map.Data[i].in;
		temp1.Format(_T("#%i"),inst->GetId());
		stql+=temp1;
		if(i<item_map.Size-1){
			if(item_map.Data[i+1].in!=0)stql+=_T(",");
		}

		if(count == 500 || i == item_map.Size - 1)
		{
			stql.TrimRight(_T(','));
			stql+=_T("}\n");
			temp1.Format(_T("#%i"),resName->GetId());
			stql+=_T("Ext1 {ils_resource(.name=")+temp1;

			stql+=_T(" AND .item IN #Ext)} END_SELECT");
			if(m_api->m_data.NET_QueryEditParse(stql, false, 0)){
				if(m_api->m_data.NET_QueryExecute(tmpExt, APL_T(", ...")))
				{
					m_api->LoadExtentInfo(tmpExt);
				}else continue;;
			}else continue;

			ext.Append(tmpExt);
			tmpExt.Clear();

			count = 0;
			stql=_T("SELECT Ext1 FROM Ext {");
		}
	}

	for(i=0;i<ext.Size;i++)
	{
		inst=ext[i];
		if(!inst) continue;
		if(!inst->GetType()) continue;
		if(inst->GetAccessmode()>aplRO) continue;

		CaplInstance *item, *cur_res_name;

		m_api->m_data.GetAttr(inst,m_api->m_expl_mgr->a_ils_resource_name,cur_res_name);
		if(resName!=cur_res_name) continue;


		m_api->m_data.GetAttr(inst,m_api->m_expl_mgr->a_ils_resource_item,item);
		j=item_map.QFindByIn((long)item);
		if(j>=0) (item_map.Data[j]).out=(long)inst;
	}

	return true;
}
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
CaplInstance *CaplPreExploitationMgr::CopyPdfToIls(bool bShowStructDlg)
{
	if(!m_api->m_data.IsConnected()){AfxMessageBox(APL_T("  !")); return 0;};
	if(!m_api->m_data.IsAdmin())
	{
		if(!m_api->m_appr_mgr.CheckPersonRole(0,APL_NO_T(" ILS")))
		{
			if(!m_api->m_appr_mgr.CheckPersonRoleByOption(0,APL_NO_T("ILS\\     PSS"),false))
			{
				AfxMessageBox(APL_T("      !")); 
				return 0;
			}
		}
	}

	CaplInstance *top_pdf=SelectInstance(APL_MODE_SELECT_PDF, APL_T("   "));
	if(0==top_pdf)  return 0;


	CaplAdminModeProvider adminmode(&(m_api->m_data),-1, -1,DEF_SOURCE);

	aplExtent ext_pdf, ext_nauo;
	if(bShowStructDlg)
	{
		CaplSetResourceHandle setres(module_inst);

		CImportStructPss2IlsDlg dlg;

		dlg.m_api=m_api;
		dlg.m_top_pdf=top_pdf;

		if(IDOK!=dlg.DoModal()) return 0;

		ext_pdf.Unique=false; ext_pdf.Append(dlg.m_ext_pdf);
		ext_nauo.Unique=false; ext_nauo.Append(dlg.m_ext_nauo);
	}
	else
	{
		ext_pdf.Add(top_pdf);
	}

	if(!ImportStructPss2Ils(ext_pdf, ext_nauo)) return 0;

	CaplInstance *lss_comp;
	m_api->m_data.GetAttr(top_pdf, m_api->m_prd_mgr.a_pdf_ils_component, lss_comp);
	return lss_comp;
}
//*************************************************************************
bool CaplPreExploitationMgr::ImportStructPss2Ils(aplExtent &ext_pdf, aplExtent &ext_nauo)
{
	if(0==ext_pdf.GetSize()) return false;

	//  
	CaplInstance *charact_gar_res, *ils_res_name_gar_res;
	charact_gar_res=m_api->m_charact_mgr.GetCharacteristicById(APL_T("    "));
	if(0==charact_gar_res)
	{
		AfxMessageBox(APL_T("     \"    \"!\n\n    !"),MB_ICONSTOP);
		return false;
	}
	else
	{
		aplExtent ext;
		CaplAttrValue tst_value[1];

		tst_value[0].value.Set(APL_T(" "));
		tst_value[0].attr=m_api->m_expl_mgr->a_ils_resource_name_name;
		m_api->m_data.NET_FindInstancesWithAttrValues2(m_api->m_expl_mgr->e_ils_resource_name,1,&tst_value[0],ext,false,false,NULL,aplSBMiddle,true,DEF_SOURCE);
		if(ext.Size>1) AfxMessageBox(APL_T(" .     \" \"!\n\n    !"),MB_ICONSTOP);
		else if(0==ext.Size) AfxMessageBox(APL_T(" .    \" \"!\n\n    !"),MB_ICONSTOP);
		else ils_res_name_gar_res=ext[0];
	}
	if(0==ils_res_name_gar_res) return false;

	CString buf,sLog;
	buf.Format(APL_T(" %i    %i "),ext_pdf.GetSize(), ext_nauo.GetSize());
	AfxMessageBox(buf);

	long wdlg=aplStartWaitDlg(APL_T(" "));

	//  ,   - .
	int i,j;
	CaplInstance *prd,*lss_comp,*pdf;
	CString sId,sVer,sName;

	//   
	aplSetTextWaitDlg(wdlg,APL_T("  "));
	{
		aplExtent ext_component_assembly;  
		//   
		for(i=0;i<ext_nauo.GetSize();i++)
		{
			m_api->m_data.GetAttr(ext_nauo[i],m_api->m_prd_mgr.a_pdr_r_ting,pdf);
			m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_ils_component, lss_comp);
			if(0!=lss_comp) ext_component_assembly.Add(lss_comp);
		}

		m_api->LoadExtentInfo(ext_component_assembly);

		//  
		CaplAttrValue tst_value[1];
		tst_value[0].attr= m_api->m_expl_mgr->a_apl_lss3logel_parent_component;

		for(i=0;i<ext_component_assembly.GetSize();i++)
		{
			m_api->m_data.GetAttr(ext_component_assembly[i], m_api->m_expl_mgr->a_apl_lss3comp_id, sId);

			aplExtent ext;
			tst_value[0].value.Set(ext_component_assembly[i]);
			m_api->m_data.NET_FindInstancesWithAttrValues2(m_api->m_expl_mgr->e_apl_lss3_logistic_element,1,&tst_value[0],ext,false,false,NULL,aplSBMiddle,true,DEF_SOURCE);


			if(0==ext.GetSize())
			{
				buf.Format(APL_T("\r\n   %s -    "),LPCTSTR(sId), ext.GetSize());
				sLog+=buf;

			}
			else
			{
				buf.Format(APL_T("\r\n   %s - %i  "),LPCTSTR(sId), ext.GetSize());
				sLog+=buf;

				for(j=0;j<ext.GetSize();j++) m_api->m_data.DeleteInstance(ext[j]);
			}
		}

		if(ext_component_assembly.GetSize()>0) sLog+=_T("\r\n");
	}

	aplSetTextWaitDlg(wdlg,APL_T("  "));

	//   
	CaplMap map_pdf_comp;
	aplExtent extComp4Load;
	for(i=0;i<ext_pdf.GetSize();i++)
	{
		CaplInstance* pdf=ext_pdf[i];
		m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
		m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_id, sVer);
		m_api->m_data.GetAttr(prd, m_api->m_prd_mgr.a_prd_id, sId);
		if(sVer!=_T("")){sId+=_T(" ");sId+=sVer;}
		m_api->m_data.GetAttr(prd, m_api->m_prd_mgr.a_prd_name, sName);

		m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_ils_component, lss_comp);
		if(0!=lss_comp) 
		{
			buf.Format(APL_T("\r\n %s \"%s\"      ILS.   PSS->ILS."),LPCTSTR(sId),LPCTSTR(sName));
			sLog+=buf;
			extComp4Load.Add(lss_comp);
		}
		else
		{
			buf.Format(APL_T("\r\n %s \"%s\"   ILS."),LPCTSTR(sId),LPCTSTR(sName));
			sLog+=buf;

			lss_comp=m_api->m_data.CreateInstance(m_api->m_expl_mgr->e_apl_lss3_component);
			m_api->m_data.PutAttr(pdf, m_api->m_prd_mgr.a_pdf_ils_component, lss_comp);
		}
		map_pdf_comp.Add((long)pdf,(long)lss_comp);

		//  
		CaplInstance *inst0;
		m_api->m_data.GetAttr(lss_comp, m_api->m_expl_mgr->a_apl_lss3comp_pdf, inst0);
		if(inst0!=pdf)	m_api->m_data.PutAttr(lss_comp, m_api->m_expl_mgr->a_apl_lss3comp_pdf, pdf);

		m_api->m_data.GetAttr(lss_comp, m_api->m_expl_mgr->a_apl_lss3comp_id, buf);
		if(buf!=sId) m_api->m_data.PutAttr(lss_comp, m_api->m_expl_mgr->a_apl_lss3comp_id, sId);

		m_api->m_data.GetAttr(lss_comp, m_api->m_expl_mgr->a_apl_lss3comp_name_rus, buf);
		if(buf!=sName) m_api->m_data.PutAttr(lss_comp, m_api->m_expl_mgr->a_apl_lss3comp_name_rus, sName);
	}

	m_api->LoadExtentInfo(extComp4Load);

	aplSetTextWaitDlg(wdlg,APL_T("  "));

	//   
	//if(0!=m_charact_gar_res && 0!=m_ils_res_name_gar_res)
	{
		CaplMap map_garant_res, map_ils_res; 
		for(i=0;i<map_pdf_comp.Size;i++) 
		{
			map_garant_res.Add((long)map_pdf_comp.Data[i].in,0);
			map_ils_res.Add((long)map_pdf_comp.Data[i].out,0);
		}

		m_api->m_charact_mgr.GetInstancesCharact(map_garant_res,charact_gar_res,0);
		FindIlsRes4Ext(m_api,map_ils_res,ils_res_name_gar_res);

		int i;
		for(i=0;i<map_garant_res.Size;i++)
		{
			CaplInstance *char_val=(CaplInstance *)map_garant_res.Data[i].out;
			if(0==char_val) continue;

			double count=0;
			m_api->m_data.GetAttr(char_val,m_api->m_charact_mgr.a_apl_charact_val_meas_val,count);
			if(0==count)continue;

			CaplInstance *pdf=(CaplInstance *)map_garant_res.Data[i].in;

			CaplInstance *ils_comp=(CaplInstance*)map_pdf_comp.QGetPointerByIn((long)pdf);
			if(0==ils_comp) continue;

			CaplInstance *ils_res=(CaplInstance*)map_ils_res.QGetPointerByIn((long)ils_comp);

			if(0==ils_res)
			{
				ils_res=m_api->m_data.CreateInstance(m_api->m_expl_mgr->e_ils_resource);
				m_api->m_data.PutAttr(ils_res,m_api->m_expl_mgr->a_ils_resource_item,ils_comp);
				m_api->m_data.PutAttr(ils_res,m_api->m_expl_mgr->a_ils_resource_name,ils_res_name_gar_res);
				m_api->m_data.PutAttr(ils_res,m_api->m_expl_mgr->a_ils_resource_calculated, true);
			}
			m_api->m_data.PutAttr(ils_res,m_api->m_expl_mgr->a_ils_resource_garantee, count);
		}
	}


	//  
	aplSetTextWaitDlg(wdlg,APL_T(" "));
	sLog+=_T("\r\n");
	CaplInstance *pdf0, *comp0;
	CString buf1, sId0, sId1;
	COleDateTime od_cur=COleDateTime::GetCurrentTime();
	CString sLkn, sLknAdd;
	aplDate2String(od_cur,sLknAdd);

	for(i=0;i<ext_nauo.GetSize();i++)
	{
		CaplInstance *pdr,*pdf1,*comp1;
		pdr=ext_nauo[i];
		m_api->m_data.GetAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ting, pdf0);
		comp0=(CaplInstance *)map_pdf_comp.QGetPointerByIn((long)pdf0);
		m_api->m_data.GetAttr(comp0, m_api->m_expl_mgr->a_apl_lss3comp_id, sLkn);

		m_api->m_data.GetAttr(pdr, m_api->m_prd_mgr.a_pdr_r_ted, pdf1);
		comp1=(CaplInstance *)map_pdf_comp.QGetPointerByIn((long)pdf1);

		if(0==comp0 || 0==comp1) continue;

		m_api->m_data.GetAttr(comp0, m_api->m_expl_mgr->a_apl_lss3comp_id, sId0);
		m_api->m_data.GetAttr(comp1, m_api->m_expl_mgr->a_apl_lss3comp_id, sId1);

		double dcount;
		m_api->m_data.GetAttr(pdr, m_api->m_prd_mgr.a_apl_qacu_value, dcount);
		int icount=(int)dcount;

		buf.Format(APL_T("\r\n %s   %s  - %i"),LPCTSTR(sId1),(sId0),icount);
		sLog+=buf;

		if((double)icount!=dcount)
		{
			buf.Format(APL_T("  !!!  -  %f"),dcount);
			sLog+=buf;
		}
		CaplInstance *comp_rel=m_api->m_data.CreateInstance(m_api->m_expl_mgr->e_apl_lss3_logistic_element);
		m_api->m_data.PutAttr(comp_rel, m_api->m_expl_mgr->a_apl_lss3logel_count_in_node, icount);
		m_api->m_data.PutAttr(comp_rel, m_api->m_expl_mgr->a_apl_lss3logel_parent_component, comp0);
		m_api->m_data.PutAttr(comp_rel, m_api->m_expl_mgr->a_apl_lss3logel_child_component, comp1);
		m_api->m_data.PutAttr(comp_rel, m_api->m_expl_mgr->a_apl_lss3logel_element_type, _T("link"));

		sLkn.Format(_T("%s-%i"),LPCTSTR(sLknAdd),i);
		m_api->m_data.GetAttr(pdr, m_api->m_prd_mgr.a_pdr_id, buf1);
		if(buf1!=_T("")) {sLkn+=_T("-"); sLkn+=buf1;}
		m_api->m_data.PutAttr(comp_rel, m_api->m_expl_mgr->a_apl_lss3logel_lcn, sLkn);
	}

	aplSetTextWaitDlg(wdlg,APL_T(" ..."));
	m_api->SaveChanges();

	aplSetTextWaitDlg(wdlg,APL_T(" ..."));

	CString access_template;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("ILS\\    ILS   PSS"),access_template);
	if(!access_template.IsEmpty())
	{
		aplExtent ext_access; ext_access.Unique=false;
		for(i=0;i<map_pdf_comp.GetSize();i++)  ext_access.Add((CaplInstance*)(map_pdf_comp.Data[i].out));
		
		aplExtent ext_users;
		m_api->m_data.LoadAllUsers(ext_users);
		m_api->m_data.NET_SetAccessFromPatternName(&ext_access,access_template);
	}
	aplEndWaitDlg(wdlg);

	aplShowBigMsg(sLog);
	return true;
}

int CaplPreExploitationMgr::LDFillSSI(CaplLoadData* ld, int iInd, UINT nFlags /* = 0 */)
{
	ld->AddQuery(_T('d'), iInd, 0, a_ils_ssi_control_method, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_ils_ssi_metal_rate, true, true);
	ld->AddQuery(_T('d'), iInd, 0, a_ils_ssi_composite_rate, true, true);

	return iInd;
}
