// CertOwnerCratorDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CertOwnerCratorDlg.h"


// CCertOwnerCratorDlg dialog

IMPLEMENT_DYNAMIC(CCertOwnerCratorDlg, CaplTranslateDialog)

CCertOwnerCratorDlg::CCertOwnerCratorDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CCertOwnerCratorDlg::IDD, pParent)
{
	m_pParent = (CaplCertificateDlg*)pParent;
}

CCertOwnerCratorDlg::~CCertOwnerCratorDlg()
{
}

void CCertOwnerCratorDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_OWNER, m_owner_list);
	DDX_Control(pDX, IDC_CREATOR, m_creator_list);
}


BEGIN_MESSAGE_MAP(CCertOwnerCratorDlg, CaplTranslateDialog)
END_MESSAGE_MAP()

BOOL CCertOwnerCratorDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitLists();
	FillGrpOwner();
	FillGrpCreator();
	
	return TRUE;
}

// CCertOwnerCratorDlg message handlers

bool CCertOwnerCratorDlg::FillGrpOwner()
{
	CStringArray saParams;
	CaplCryptographicManager::ParseCertificateParams(m_pParent->m_sSubject, saParams);

	for(int i=0; i<saParams.GetSize(); i+=2)
	{
		int nIndex = m_owner_list.InsertItem(i, saParams[i]);
		m_owner_list.SetItemText(nIndex, 1, saParams[i+1]);
	}

	return true;
}

bool CCertOwnerCratorDlg::FillGrpCreator()
{
	CStringArray saParams;
	CaplCryptographicManager::ParseCertificateParams(m_pParent->m_sIssuer, saParams);

	for(int i=0; i<saParams.GetSize(); i+=2)
	{
		int nIndex = m_creator_list.InsertItem(i, saParams[i]);
		m_creator_list.SetItemText(nIndex, 1, saParams[i+1]);
	}

	return true;
}

bool CCertOwnerCratorDlg::InitLists()
{
	CRect rect;
	m_owner_list.GetClientRect(rect);

	//  
	m_owner_list.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_owner_list.InsertColumn(0,  APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));
	m_owner_list.InsertColumn(1,  APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.6));

	//  
	m_creator_list.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_creator_list.InsertColumn(0,  APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));
	m_creator_list.InsertColumn(1,  APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.6));

	//   

	return true;
}

void CCertOwnerCratorDlg::OnOK()
{

}

void CCertOwnerCratorDlg::OnCancel()
{

}