// CertVerificationDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CertVerificationDlg.h"


// CCertVerificationDlg dialog

IMPLEMENT_DYNAMIC(CCertVerificationDlg, CaplTranslateDialog)

CCertVerificationDlg::CCertVerificationDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CCertVerificationDlg::IDD, pParent)
{
	m_pParent = (CaplCertificateDlg*)pParent;
}

CCertVerificationDlg::~CCertVerificationDlg()
{
}

void CCertVerificationDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_USAGE, m_usage_list);
	DDX_Control(pDX, IDC_TREE, m_tree);
}


BEGIN_MESSAGE_MAP(CCertVerificationDlg, CaplTranslateDialog)
END_MESSAGE_MAP()

BOOL CCertVerificationDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	//  " "
	FillGrpUsage();

	//  
	BuildVerificationTree();

	return TRUE;
}

bool CCertVerificationDlg::FillGrpUsage()
{
	CRect rect;
	CStringArray saUsage;

	m_usage_list.GetClientRect(rect);
	CaplCryptographicManager::GetKeyUsageFromCert(m_pParent->m_sFile, saUsage);

	m_usage_list.InsertColumn(0, _T(""), LVCFMT_LEFT, (int)(rect.Width()*0.9));

	for(int i=0; i<saUsage.GetSize(); i++)
		m_usage_list.InsertItem(i, saUsage[i]);

	return true;
}

bool CCertVerificationDlg::BuildVerificationTree()
{
	CBitmap bmp;
	bmp.LoadBitmap(IDB_CERTIFICATE);

	m_image.Create(24, 27, ILC_COLOR24|ILC_MASK, 2, 10);
	m_image.Add(&bmp, RGB(192, 192, 192));
	m_tree.SetImageList(&m_image, TVSIL_NORMAL);

	aplExtent aeCert;
	aplExtent aeResult;
	CString sSql, sIssuer;
	CaplAPI *api = m_pParent->m_api;
	CaplInstance *ciLastCert = 0;//m_pParent->m_ciCert;
	sIssuer=m_pParent->m_sIssuer;

	//   
	//aeResult.Add(m_pParent->m_ciCert);

	while(true)
	{
		if(0!=ciLastCert) api->m_data.GetAttr(ciLastCert, api->m_appr_mgr.a_apl_digital_sign_open_key_open_key_cert_issuer, sIssuer);

		sSql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_digital_sign_open_key.cert_subject = '%s' } END_SELECT"), sIssuer);
		api->m_data.NET_QueryEditParse(sSql);
		api->m_data.NET_QueryExecute(aeCert);

		if(aeCert.Size == 1)
		{
			if(aeCert[0] == ciLastCert) break;

			ciLastCert = aeCert[0];
			aeResult.Add(ciLastCert);
		}
		else if(aeCert.Size == 0)
		{
			break;
		}
		else if(aeCert.Size > 1)
		{
			MessageBox( APL_T("         \"\"!"),  APL_T(""), MB_ICONSTOP);
			return false;
		}
	}

	//   
	CString str;
	int image = 0;
	HTREEITEM hItem = m_tree.GetRootItem();
	CString sRevocationDate, sAfter, sBefore, sCurrent;

	for(int i=aeResult.Size-1; i>=0; i--)
	{
		//   
		m_pParent->m_api->m_data.GetAttr(aeResult[i], m_pParent->m_api->m_appr_mgr.a_apl_digital_sign_open_revocation_date, sRevocationDate);
		m_pParent->m_api->m_data.GetAttr(aeResult[i], m_pParent->m_api->m_appr_mgr.a_apl_digital_sign_open_not_after, sAfter);
		m_pParent->m_api->m_data.GetAttr(aeResult[i], m_pParent->m_api->m_appr_mgr.a_apl_digital_sign_open_not_before, sBefore);
		aplDate2String(COleDateTime::GetCurrentTime(), sCurrent);

		if(!sRevocationDate.IsEmpty())
			image = 1;
		else if(!(sBefore<=sCurrent && sAfter>=sCurrent))
			image = 1;

		HTREEITEM hItemTmp = hItem;

		api->m_data.GetAttr(aeResult[i], api->m_appr_mgr.a_apl_digital_sign_open_key_open_key_cert_subject, str);
		str=CaplCryptographicManager::GetParamFromSubject(str, "CN=");

		hItem = m_tree.InsertItem(str, image, image, hItem);
		m_tree.Expand(hItemTmp, TVE_EXPAND);
	}

	return true;
}

void CCertVerificationDlg::OnOK()
{

}

void CCertVerificationDlg::OnCancel()
{

}
// CCertVerificationDlg message handlers


