#if !defined(AFX_CHANGEASSEMBLYDLG_H__8AAB01CF_E7A9_4008_852E_F72C4DF70E9A__INCLUDED_)
#define AFX_CHANGEASSEMBLYDLG_H__8AAB01CF_E7A9_4008_852E_F72C4DF70E9A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ChangeAssemblyDlg.h : header file
//

#include "ResizableDialog.h"

#include "resource.h"
#include "apl_gui.h"
#include "CommonChangeClasses.h"
#include "apl_api.h"

class CChangeParamDlg;
/////////////////////////////////////////////////////////////////////////////
// CChangeAssemblyDlg dialog

class CChangeAssemblyDlg : public CResizableDialog
{
// Construction
public:
	CChangeAssemblyDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CChangeAssemblyDlg)
	enum { IDD = IDD_CHANGE_ASSEMBLY_DLG };
	CEdit			m_sn;				// - " "
	CDateTimeCtrl	m_dateCtrl;			//   
	CComboBox		m_contCtrl;			//  

	CaplButton		m_itemPropBtn;		//  "-"
	CaplButton		m_itemClearBtn;		//  ""
	CaplButton		m_itemDeleteBtn;	//  ""
	CaplButton		m_itemChngBtn;		//  ""
	CaplButton		m_itemAddBtn;		//  ""
	CaplButton		m_selectBtn;		//  ""
	CaplButton		m_refreshBtn;		//  ""
	CaplButton		m_cancelBtn;		// ""
	CaplButton		m_okBtn;			// ""
	CaplButton		m_setEffBtn;		// ""

	CSortListCtrl	m_whereUsedList;	//  
	CSortListCtrl	m_itemsList;		// 

	CString			m_sProductId;		// 
	CString			m_sProductName;		// 
	CString			m_sProductVer;		// 

	int				m_iCont;			// 
	BOOL			m_bSNSelected;		//      
	BOOL			m_bDateSelected;	//     
	COleDateTime	m_oleDate;			//    
	CString			m_sSN;				//   
	BOOL			m_bNotShow;
	//}}AFX_DATA


	/*	 
		0 -   
		1 -  
		2 -     
	*/
	long			m_mode;
	CaplAPI*		m_api;
	
	CaplInstance*	m_change;

	CaplInstance*	m_psc;		//  
	CPSCItemInfo	m_pscInfo;	//  

	aplExtent *m_items;			// ,     

	CArray<CPSCItemInfo, CPSCItemInfo> *m_newItems; // 
	CArray<CPSCItemInfo, CPSCItemInfo> m_newestItems; //:))  

	aplExtent*		m_delItems;		//  

	aplExtent		m_contexts;		//  

	CaplInstance*	m_assPdf;		// 
	
	//   
	aplExtent		m_extPdfs;		//    
	aplExtent		m_extRels;		// 
	aplRealArray	m_extCounts;	// -
	aplExtent		m_extUnits;		// ..

	CImageList m_imageList;
	CImageList m_chngImageList;
	CImageList m_btnImageList;
	
	CaplInstance*	m_curItem;	//      "   "
	int				m_index;	//   

	CaplInstance*	m_curPSC;
	CPSCItemInfo*	m_curPSCInfo;
	
	//     
	CString m_sEffType;		//   
	CString m_sStartCond;	//   
	CString m_sEndCond;		//   

	bool m_bReadOnly; //  " "

	CFont m_FontStrikeOut;		//   

	bool m_bFilteredByDate;		//   
	bool m_bFilteredBySN;		//    
	bool m_bFilteredByContext;	//   

	struct sWhereUsedListItem
	{
		CaplInstance*	m_iRel;		// 
		bool			m_bActive;	//      
	};

	CaplTAggr <sWhereUsedListItem*, sWhereUsedListItem*,
				APLAGGR_LIST | APLAGGR_AUTOKILLREF> m_WhereUsedItems;

	struct sAssemblyListItem
	{
		CaplInstance*	m_iRel;		// 
		COLORREF		m_Color;	// ,   
		bool			m_bActive;	//      
		
		sAssemblyListItem()
		{
			m_Color		= ::GetSysColor(COLOR_WINDOWTEXT);
			m_bActive	= true;
		}
	};

	CaplTAggr <sAssemblyListItem*, sAssemblyListItem*,
				APLAGGR_LIST | APLAGGR_AUTOKILLREF> m_AssemblyItems;
	

	void SetAnchors();

	/**        
		rel -  (NAUO)
		date -  
	*/
	bool IsPrdEffByDate(CaplInstance* rel, COleDateTime date);

	/**         
		rel -  (NAUO)
		date -  
	*/
	bool IsPrdEffByCurDate(CaplInstance* rel);
	
	/**         
		rel -  (NAUO)
		sn -   
	*/
	bool IsPrdEffBySN(CaplInstance* rel, const TCHAR* sn);

	/**       .
		   " "  
		    .
	*/
	void LoadSystemStrikeOutFont();


	void FillWhereUsedList();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChangeAssemblyDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	//   "   "
	bool FillAssemblyData();

	CString PrintEffectivityInString(CString type, CString start, CString end);

	void InsertText(int num, int iNexInd, CaplInstance* newPdf, double dCount, CaplInstance* unit, 
		CString sPos, CString sPosNum, CString sEffType, CString sStart, CString sEnd, CString sPrior= _T(""));
	
	bool FindItem(CChangeParamDlg *dlg, bool bDelete= false);

	// Generated message map functions
	//{{AFX_MSG(CChangeAssemblyDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnChg2AssSelect();
	afx_msg void OnChg2AssRefresh();
	afx_msg void OnItemchangedChangeItemsList(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnChg2Prop();
	afx_msg void OnChg2SetEff();
	afx_msg void OnChg2Clear();
	afx_msg void OnChg2ItemChange();
	afx_msg void OnChg2ItemDelete();
	afx_msg void OnChg2SnCheck();
	afx_msg void OnChg2DateCheck();
	afx_msg void OnCloseupChg2ContextCombo();
	afx_msg void OnDatetimechangeChg2DateCtrl(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChangeChg2SnCtrl();
	afx_msg void OnDblclkListWhereUsed(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclkChangeItemsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChg2ItemAdd();
	afx_msg void OnDestroy();
	//}}AFX_MSG

	afx_msg void OnCustomdrawAssemblyItemsList ( NMHDR* pNMHDR, LRESULT* pResult );
	afx_msg void OnCustomdrawAssemblyWhereUsedItemsList( NMHDR* pNMHDR, LRESULT* pResult );
	afx_msg void OnAssemblyListHeaderClicked(NMHDR* pNMHDR, LRESULT* pResult);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHANGEASSEMBLYDLG_H__8AAB01CF_E7A9_4008_852E_F72C4DF70E9A__INCLUDED_)
