// ChangeDocVerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ChangeDocVerDlg.h"
#include "apl_api.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CChangeDocVerDlg dialog

CChangeDocVerDlg::CChangeDocVerDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CChangeDocVerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChangeDocVerDlg)
	m_sDoc = _T("");
	m_sId = _T("");
	m_sOldVer = _T("");
	m_sNewVer = _T("");
	m_acceptDate = COleDateTime::GetCurrentTime();
	m_acceptTime = COleDateTime::GetCurrentTime();
	m_sUser = _T("");
	m_sDscr = _T("");
	m_sNewState=  APL_T("");
	//}}AFX_DATA_INIT
	
	m_newRev= NULL;
	m_oldRev= NULL;
	m_avc= NULL;
	m_api= NULL;
	m_doc_or_bp= NULL;
	m_person= NULL;
	m_user= NULL;

	m_change= NULL;
	m_newChng= NULL;

	m_bReadOnly= false;
	m_bCanSelect= true;

	m_viewMode= 0;
	m_num_edit_item = -1;


	m_bZerroDocRev=false;
}


void CChangeDocVerDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeDocVerDlg)
	DDX_Control(pDX, IDC_CD_ACTIVE_VER_STATIC, m_activeVerStatic);
	DDX_Control(pDX, IDC_CD_ITEM_NAME_STATIC, m_itemNameStatic);
	DDX_Control(pDX, IDC_CD_ITEM_TITLE_STATIC, m_itemTitleStatic);
	DDX_Control(pDX, IDC_CD_VIEW_REV_OLD, m_viewOldBtn);
	DDX_Control(pDX, IDC_CD_VIEW_REV_NEW, m_viewNewBtn);
	DDX_Control(pDX, IDC_CD_DESCRIPTION, m_dscr);
	DDX_Control(pDX, IDC_CD_ACCEPT_TIME, m_timeCtrl);
	DDX_Control(pDX, IDC_CD_ACCEPT_DATE, m_dateCtrl);
	DDX_Control(pDX, IDC_CD_FILE_LIST, m_fileList);
	DDX_Control(pDX, IDC_CD_SAVE_FILE, m_saveBtn);
	DDX_Control(pDX, IDC_CD_VIEW_FILE, m_viewBtn);
	DDX_Control(pDX, IDC_CD_DELETE_FILE, m_delBtn);
	DDX_Control(pDX, IDC_CD_ADD_FILE, m_addBtn);
	DDX_Control(pDX, IDC_CD_FILE_UP, m_upBtn);
	DDX_Control(pDX, IDC_CD_FILE_DOWN, m_downBtn);
	DDX_Control(pDX, IDC_CD_ID, m_id);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_CD_DCO_SELECT_BUTTON, m_selectBtn);
	DDX_Text(pDX, IDC_CD_DOC, m_sDoc);
	DDX_Text(pDX, IDC_CD_ID, m_sId);
	DDX_Text(pDX, IDC_CD_OLD_VERTION, m_sOldVer);
	DDX_Text(pDX, IDC_CD_NEW_VERTION, m_sNewVer);
	DDX_DateTimeCtrl(pDX, IDC_CD_ACCEPT_DATE, m_acceptDate);
	DDX_DateTimeCtrl(pDX, IDC_CD_ACCEPT_TIME, m_acceptTime);
	DDX_Text(pDX, IDC_CD_USER, m_sUser);
	DDX_Text(pDX, IDC_CD_DESCRIPTION, m_sDscr);
	DDX_Text(pDX, IDC_CD_NOTE, m_sNotes);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_ACCEPT_DATE_STATIC, m_dateStaticCtrl);
	DDX_Control(pDX, IDC_CD_NEW_STATE, m_stateCB);
	DDX_CBString(pDX, IDC_CD_NEW_STATE, m_sNewState);
	DDX_Control(pDX, IDC_STATE_STATIC, m_stateST);
	DDX_Control(pDX, IDC_DSCR_STATIC, m_dscrST);
	DDX_Control(pDX, IDC_CD_METHOD, m_combo_method);
	DDX_Control(pDX, IDC_EDIT_4_EDIT, m_Edit4Edit);
	DDX_Control(pDX, IDC_LIST_4_ASS, m_list_4_ass);
	DDX_Control(pDX, IDC_LIST_4_ASS2, m_list_4_del);
	DDX_Control(pDX, IDC_ADD_REL_ADD, m_add_ass_btn);
	DDX_Control(pDX, IDC_DEL_REL_ADD, m_del_ass_btn);
	DDX_Control(pDX, IDC_REMOVE_REL_ADD, m_add_remove_ass_btn);
	DDX_Control(pDX, IDC_REMOVE_REL_DEL, m_del_remove_ass_btn);
	DDX_Control(pDX, IDC_CD_NOTE, m_note_ctrl);
	DDX_Control(pDX, IDC_ST_NUMBER, m_st_number);
}


BEGIN_MESSAGE_MAP(CChangeDocVerDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CChangeDocVerDlg)
	ON_BN_CLICKED(IDC_CD_DCO_SELECT_BUTTON, OnCdDcoSelectButton)
	ON_BN_CLICKED(IDC_CD_ADD_FILE, OnCdAddFile)
	ON_BN_CLICKED(IDC_CD_DELETE_FILE, OnCdDeleteFile)
	ON_BN_CLICKED(IDC_CD_SAVE_FILE, OnCdSaveFile)
	ON_BN_CLICKED(IDC_CD_VIEW_FILE, OnCdViewFile)
	ON_BN_CLICKED(IDC_CD_VIEW_REV_NEW, OnCdViewRevNew)
	ON_BN_CLICKED(IDC_CD_VIEW_REV_OLD, OnCdViewRevOld)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_CD_FILE_UP, &CChangeDocVerDlg::OnCdFileUp)
	ON_BN_CLICKED(IDC_CD_FILE_DOWN, &CChangeDocVerDlg::OnCdFileDown)
	ON_NOTIFY(NM_DBLCLK, IDC_CD_FILE_LIST, OnDblclkFileList)
	ON_BN_CLICKED(IDC_ADD_REL_ADD, &CChangeDocVerDlg::OnBnClickedAddRelAdd)
	ON_BN_CLICKED(IDC_DEL_REL_ADD, &CChangeDocVerDlg::OnBnClickedDelRelAdd)
	ON_BN_CLICKED(IDC_REMOVE_REL_ADD, &CChangeDocVerDlg::OnBnClickedRemoveRelAdd)
	ON_BN_CLICKED(IDC_REMOVE_REL_DEL, &CChangeDocVerDlg::OnBnClickedRemoveRelDel)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeDocVerDlg message handlers

void CChangeDocVerDlg::MoveCtrls()
{
	CRect rect1, rect2;
	m_stateCB.GetWindowRect(&rect1);
	m_dscr.GetWindowRect(&rect2);
	rect2.top= rect1.top;
	ScreenToClient(&rect2);
	//m_dscr.MoveWindow(rect2);
	m_stateCB.ModifyStyle(WS_VISIBLE, 0, 0);

	m_stateST.GetWindowRect(&rect1);
	m_dscrST.GetWindowRect(&rect2);
	rect2.top= rect1.top;
 	ScreenToClient(&rect2);
	//m_dscrST.MoveWindow(rect2);
	m_stateST.ModifyStyle(WS_VISIBLE, 0, 0);

	m_combo_method.EnableWindow(FALSE);

	m_list_4_ass.EnableWindow(FALSE);
	m_list_4_del.EnableWindow(FALSE);
	m_add_ass_btn.EnableWindow(FALSE);
	m_del_ass_btn.EnableWindow(FALSE);
	m_add_remove_ass_btn.EnableWindow(FALSE);
	m_del_remove_ass_btn.EnableWindow(FALSE);
}

BOOL CChangeDocVerDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	
	m_delBtn.SetTooltipText( APL_T("   "));
	m_addBtn.SetTooltipText( APL_T("   "));
	m_saveBtn.SetTooltipText( APL_T("   "));
	m_viewBtn.SetTooltipText( APL_T(" "));
	m_viewOldBtn.SetTooltipText( APL_T(" "));
	m_viewNewBtn.SetTooltipText( APL_T(" "));
	m_selectBtn.SetTooltipText( APL_T(" "));
	m_upBtn.SetTooltipText( APL_T(" "));
	m_downBtn.SetTooltipText( APL_T(" "));

	m_delBtn.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	m_addBtn.SetIcon(GetAplTableIco(APL_TABLE_NEW));
	m_viewBtn.SetIcon(GetAplTableIco(APL_TABLE_VIEW));
	m_viewOldBtn.SetIcon(GetAplTableIco(APL_TABLE_VIEW));
	m_viewOldBtn.SetFlat(FALSE);
	m_viewNewBtn.SetIcon(GetAplTableIco(APL_TABLE_VIEW));
	m_viewNewBtn.SetFlat(FALSE);
	m_saveBtn.SetIcon(GetAplTableIco(APL_TABLE_SAVE));
	m_selectBtn.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_selectBtn.SetFlat(FALSE);

	m_upBtn.SetIcon(GetAplTableIco(APL_TABLE_TOP));
	m_downBtn.SetIcon(GetAplTableIco(APL_TABLE_BOTTOM));

	m_add_ass_btn.SetIcon(GetAplTableIco(APL_TABLE_NEW)); m_add_ass_btn.SetFlat(FALSE); m_add_ass_btn.SetWindowText(_T(""));
	m_del_ass_btn.SetIcon(GetAplTableIco(APL_TABLE_DEL)); m_del_ass_btn.SetFlat(FALSE); m_del_ass_btn.SetWindowText(_T(""));

	m_add_remove_ass_btn.SetIcon(GetAplTableIco(APL_TABLE_NEW)); m_add_remove_ass_btn.SetFlat(FALSE); m_add_remove_ass_btn.SetWindowText(_T(""));
	m_del_remove_ass_btn.SetIcon(GetAplTableIco(APL_TABLE_DEL)); m_del_remove_ass_btn.SetFlat(FALSE); m_del_remove_ass_btn.SetWindowText(_T(""));

	if(m_bZerroDocRev)
	{
		m_add_ass_btn.ShowWindow(SW_HIDE);
		m_del_ass_btn.ShowWindow(SW_HIDE);
		m_add_remove_ass_btn.ShowWindow(SW_HIDE);
		m_del_remove_ass_btn.ShowWindow(SW_HIDE);
		//m_viewBtn.ShowWindow(SW_HIDE);
		m_viewOldBtn.ShowWindow(SW_HIDE);
		m_viewNewBtn.ShowWindow(SW_HIDE);
		m_selectBtn.ShowWindow(SW_HIDE);
		m_stateCB.ShowWindow(SW_HIDE);
		m_list_4_ass.ShowWindow(SW_HIDE);
		m_list_4_del.ShowWindow(SW_HIDE);

		CWnd *wnd;
		wnd=GetDlgItem(IDC_CD_DOC);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_CD_NEW_VERTION);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_CD_OLD_VERTION);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_CD_ITEM_NAME_STATIC);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_ST_CD_NEW_VERTION);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_CD_ACTIVE_VER_STATIC);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_STATE_STATIC);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_STATIC_LIST_4_ASS);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
		wnd=GetDlgItem(IDC_STATIC_LIST_4_DEL);  if(wnd!=0) wnd->ShowWindow(SW_HIDE);
}

	CString buf;

	RECT rect_add_list;
	m_list_4_ass.GetClientRect(&rect_add_list);
	int cx=rect_add_list.right-20;
	m_list_4_ass.InsertColumn(0,_T(""),LVCFMT_LEFT,cx);
	m_list_4_del.InsertColumn(0,_T(""),LVCFMT_LEFT,cx);

	m_list_4_ass.SetImageList(aplGetInstImageList(), LVSIL_SMALL);
	m_list_4_del.SetImageList(aplGetInstImageList(), LVSIL_SMALL);
	
	m_dateCtrl.ModifyStyle(WS_VISIBLE, 0, 0);
	m_timeCtrl.ModifyStyle(WS_VISIBLE, 0, 0);
	m_dateStaticCtrl.ModifyStyle(WS_VISIBLE, 0, 0);

	CRect rect;
	m_fileList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_fileList.GetClientRect(rect);

	m_fileList.InsertColumn(0, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()/2)-1);
	m_fileList.InsertColumn(1, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()/2)-1);

	m_Edit4Edit.SetParent(&m_fileList);

//	m_okBtn.EnableWindow(FALSE);
	
	m_attachment.Clear();
	m_stateCB.InsertString(0, APL_T(" "));
	m_stateCB.InsertString(1, APL_T(""));
	m_stateCB.InsertString(2, APL_T(" "));

	if(m_api->m_options_mgr.CheckInstallCode(_T("grpz")))
	{
		m_st_number.SetWindowText(APL_T(" :"));
	}
	
	if (m_viewMode==1)
	{
		SetWindowText( APL_T("   -"));
		m_itemNameStatic.SetWindowText( APL_T(" -"));
		MoveCtrls();
	}
	else if (m_viewMode == 2)
	{
		SetWindowText( APL_T("   "));
		m_itemNameStatic.SetWindowText( APL_T(" "));		
		MoveCtrls();
	}

	m_combo_method.ResetContent();
	m_combo_method.InsertString(0,APL_T(" "));
	m_combo_method.InsertString(1,APL_T(" "));

	if(m_api && apidata.IsConnected())
	{
//		m_sUser=apidata.GetNameCurrUser();		
		CaplInstance *org=0,*person=0,*po=0;
		m_person= m_api->m_appr_mgr.GetCurrentPerson();

		if(m_avc)
		{
			CaplAggr aggr;
			CString sState;
			bool not_def=true;
			if(0==m_viewMode)
			{
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_avc_new_rev, m_newRev);
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_avc_old_rev, m_oldRev);
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_avc_method, buf);
				int i=m_combo_method.FindString(-1,buf);
				if(i<0) i=m_combo_method.AddString(buf);
				m_combo_method.SetCurSel(i);

				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_avc_items_for_add_relation, m_ext_items_for_add_relation);
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_avc_items_for_del_relation, m_ext_items_for_del_relation);

				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_replace_state, sState);
				m_sNewState= m_api->m_change_mgr.GetWFStateName(sState);

			}
			else if(1==m_viewMode)
			{
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_abpc_new_rev, m_newRev);
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_abpc_old_rev, m_oldRev);				
			}
			else if(2==m_viewMode)
			{
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_char_change_new_rev, m_newRev);
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_char_change_old_rev, m_oldRev);				
			}

			if(m_oldRev)// 
			{
				m_activeVerStatic.SetWindowText( APL_T("  :"));
				m_dateCtrl.ModifyStyle(0, WS_VISIBLE, 0);
				m_timeCtrl.ModifyStyle(0, WS_VISIBLE, 0);
				m_dateStaticCtrl.ModifyStyle(0, WS_VISIBLE, 0);
				
				apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_accept_date, buf);
				aplString2Date(buf,m_acceptDate);	
				m_acceptTime=m_acceptDate;
				m_bReadOnly= true;
			}
			
			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_id, m_sId);
			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_dscr, m_sDscr);
			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_notes, m_sNotes);
//			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_basis, m_sBasis);
			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_attachment, aggr);
			for(int i= 0; i<aggr.GetSize(); i++)
			{
				CaplInstance* inst= NULL;
				aggr.GetByIndex(i, inst);
				m_attachment.Add(inst);
			}
			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_user, m_sUser);
			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_autor, m_person);
//			apidata.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_stock, m_sStock);
		} 
		else if(m_newChng /*&& m_newChng->m_newVer*/)
		{
			m_newRev= m_newChng->m_newVer;
			m_sId= m_newChng->m_sId;
			m_sDscr= m_newChng->m_sDscr;
			m_sNotes= m_newChng->m_sNotes;
			m_sNewState= m_api->m_change_mgr.GetWFStateName(m_newChng->m_sNewState);

			m_ext_items_for_add_relation=m_newChng->m_ext4AddToItem;
			m_ext_items_for_del_relation=m_newChng->m_ext4DelFromItem;

			int i=m_combo_method.FindString(-1,m_newChng->m_sMethod);
			if(i<0) i=m_combo_method.AddString(m_newChng->m_sMethod);
			m_combo_method.SetCurSel(i);


//			m_sBasis= m_newChng->m_sBasis;
//			m_sStock= m_newChng->m_sStock;

			if(!m_newChng->m_sUser.IsEmpty())m_sUser= m_newChng->m_sUser;
			if(m_newChng->m_person)m_person= m_newChng->m_person;

			if(!m_newChng->m_sDate.IsEmpty())
			{
				aplString2Date(m_newChng->m_sDate, m_acceptDate);	
				m_acceptTime=m_acceptDate;
			}

			for(int i= 0; i<m_newChng->m_attachment.GetSize(); i++)
			{
				m_attachment.Add(m_newChng->m_attachment[i]);
			}
		}
		update_items_for_add_relation();
		update_items_for_del_relation();

		CString sVal, sValE;
		m_api->m_options_mgr.GetOptionValueBN(APL_NO_T(" \\      "), sVal, _T(""));
		if(!sVal.IsEmpty())
		{
			sValE= m_api->m_change_mgr.GetWFStateNameEng(sVal);
			if(sValE==_T("approved") || sValE==_T("not_change") || sValE==_T("canceled"))//     
			{
				m_sNewState= sVal;
				m_stateCB.EnableWindow(FALSE);
			}
		}

		//     
		//if(m_sNewState.IsEmpty() || m_sNewState== APL_NO_T(" ")) m_sNewState= APL_NO_T("");
		if(m_sNewState==_T("")  || m_sNewState== APL_NO_T(" ")) m_sNewState=APL_T(" ");
			

		if (m_newRev)
		{
			if (m_viewMode == 0)
				apidata.GetAttr(m_newRev, m_api->m_doc_mgr.a_apl_doc_rev_id, m_sNewVer);
			else if (m_viewMode == 1)
				m_api->m_data.GetAttr(m_newRev, m_api->m_bp_mgr.a_bp_ver_num, m_sNewVer);
			else if (m_viewMode == 2)
				m_api->m_data.GetAttr(m_newRev, m_api->m_charact_mgr.a_apl_charact_val_ver_version_num, m_sNewVer);

			CaplInstance* inst= NULL;
			if (m_viewMode == 0)
				apidata.GetAttr(m_newRev, m_api->m_doc_mgr.a_apl_doc_rev_doc, m_doc_or_bp);
			else if (m_viewMode == 1)
				apidata.GetAttr(m_newRev, m_api->m_bp_mgr.a_bp_ver_bp, m_doc_or_bp);
			else if (m_viewMode == 2)
				apidata.GetAttr(m_newRev, m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, m_doc_or_bp);
			
			if (!m_doc_or_bp)
			{
				aplExtent revs;
				revs.Add(m_newRev);
				
				if (m_viewMode == 0 || m_viewMode == 1)
				{
					m_api->m_doc_mgr.LoadDocInfo(revs);
					apidata.GetAttr(m_newRev, m_api->m_doc_mgr.a_apl_doc_rev_doc, m_doc_or_bp);
				}

				if (m_viewMode == 2)
				{
					m_api->m_charact_mgr.LoadCharacteristic(revs);
					apidata.GetAttr(m_newRev, m_api->m_charact_mgr.a_apl_charact_val_ver_char_value, m_doc_or_bp);
				}
			}
			
			if (m_doc_or_bp)
			{
				CString str;
				if (m_viewMode == 0)
				{
					apidata.GetAttr(m_doc_or_bp, m_api->m_doc_mgr.a_doc_id, m_sDoc);
					apidata.GetAttr(m_doc_or_bp, m_api->m_doc_mgr.a_doc_name, str);

					if (m_sDoc.IsEmpty()) 
						m_sDoc += _T("?");

					m_sDoc+=_T(":");

					if (str.IsEmpty())
						str= _T("?");

					m_sDoc += str;

					CaplInstance *docType;
					apidata.GetAttr(m_doc_or_bp, m_api->m_doc_mgr.a_doc_kind, docType);

					if (docType != 0)
					{
						apidata.GetAttr(docType, m_api->m_doc_mgr.a_dt_pdt, str);
						if (m_sDoc!=_T(""))
							m_sDoc += _T(":");

						m_sDoc += str;
					}
				}
				else if (m_viewMode == 1)
				{
					m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_bp_mgr.a_bp_id, m_sDoc);
					m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_bp_mgr.a_bp_name, str);
					if (m_sDoc.IsEmpty())
						m_sDoc = _T("?");

					m_sDoc+=_T(":");

					if (str.IsEmpty())
						str= _T("?");

					m_sDoc += str;
				}
				else if (m_viewMode == 2)
				{
					CaplInstance* charact = NULL;
					m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_charact_mgr.a_apl_charact_val_charact, charact);
					if (charact)
					{
						m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_name, m_sDoc);
					}
					
					CaplInstance* type = NULL;
					m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_charact_mgr.a_apl_charact_val_type, type);
					if (type)
					{
						//if (m_sDoc.IsEmpty())
						//	m_sDoc = _T("?");

						//m_sDoc += APL_T(" [ ");

						m_api->m_data.GetAttr(type, m_api->m_charact_mgr.a_apl_charact_type_name, str);
						m_sDoc += _T(" ");
						//if (str.IsEmpty())
						//	str= _T("?");
					}
					//else
					//{
						//str= APL_T(" [  ");
					//}

					m_sDoc += str;
					//m_sDoc += _T("]");

					m_sDoc +=  APL_T("  ");
					m_sDoc += GetCharactValAssocItemStr(m_doc_or_bp);
				}
			}
			
			if (!m_oldRev && m_doc_or_bp)
			{
				if (0 == m_viewMode)
				{
					apidata.GetAttr(m_doc_or_bp, m_api->m_doc_mgr.a_apl_doc_active, m_oldRev);
					m_api->m_doc_mgr.LoadDocInfo(m_oldRev);
				}
				else if (1 == m_viewMode)
				{
					m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_bp_mgr.a_bp_act, m_oldRev);
					m_api->m_bp_mgr.LoadBPInfo(m_oldRev);
				}
				else if (2 == m_viewMode)
				{
					m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_charact_mgr.a_apl_charact_val_act_ver, m_oldRev);
					m_api->m_charact_mgr.LoadCharacteristic(m_oldRev);
				}
			}

			if (m_oldRev)
			{
				if (0 == m_viewMode)
					apidata.GetAttr(m_oldRev, m_api->m_doc_mgr.a_apl_doc_rev_id, m_sOldVer);

				else if (1 == m_viewMode)
					m_api->m_data.GetAttr(m_oldRev, m_api->m_bp_mgr.a_bp_ver_num, m_sOldVer);

				else if (2 == m_viewMode)
					m_api->m_data.GetAttr(m_oldRev, m_api->m_charact_mgr.a_apl_charact_val_ver_version_num, m_sOldVer);
			}
		}
		for (int i = 0; i < m_attachment.GetSize(); i++)
		{
			SCDFileInfo* file_info = new SCDFileInfo();
			m_api->m_doc_mgr.GetFileName(m_attachment[i], file_info->FileName);
			file_info->inst = m_attachment[i];
			m_api->m_data.GetAttr(file_info->inst,m_api->m_doc_mgr.a_apl_stored_document_code,file_info->code);
			m_fileListData.Add(file_info);

			int pos=m_fileList.InsertItem(i, file_info->code);
			m_fileList.SetItemData(pos, (DWORD)file_info);		
			m_fileList.SetItemText(pos,1, file_info->FileName);
		}
		
		if (m_sUser.IsEmpty())
		{			
			CString buf, buf1;
			if (m_person)
			{
				CString buf, buf1;
				CaplAggr aggr0;
				apidata.GetAttrBN(m_person, _T("last_name"), m_sUser);	
				apidata.GetAttrBN(m_person, _T("first_name"), buf1);

				if (buf1.GetLength() > 0)
				{
					m_sUser += _T(" ");
					m_sUser += buf1[0];
					m_sUser += _T(".");
				}

				apidata.GetAttrBN(m_person, _T("middle_names"),aggr0);
				aggr0.GetByIndex(0, buf1);
				if (buf1.GetLength() > 0) 
				{
					m_sUser += _T(" ");
					m_sUser += buf1[0];
					m_sUser += _T(".");
				}
			}
			m_sUser += _T(" (");
			m_sUser += apidata.GetNameCurrUser();
			m_sUser += _T(")");
		}

		//  
		if(0!=m_avc)
		{
			CaplInstance *pChange=0;
			m_api->m_data.GetAttr(m_avc,m_api->m_change_mgr.a_chng_item_of_chng, pChange);
			if(0!=pChange)
			{
				CString sState;
				m_api->m_data.GetAttr(pChange, m_api->m_change_mgr.a_chng_state, sState);
				if( ! (  sState==_T("") || sState==_T("not_applied"))) m_bReadOnly=true;
			}
		}

		if (m_bReadOnly) 
		{
			//if (m_change && m_change->GetAccessmode() > aplRW)
			{
				m_id.SetReadOnly();
				m_dscr.SetReadOnly();
				m_note_ctrl.SetReadOnly();

	//			m_stock.SetReadOnly();
	//			m_basis.SetReadOnly();

				m_addBtn.EnableWindow(FALSE);
				m_delBtn.EnableWindow(FALSE);
				m_upBtn.EnableWindow(FALSE);
				m_downBtn.EnableWindow(FALSE);
				m_okBtn.EnableWindow(FALSE);
			}
			m_okBtn.EnableWindow(FALSE);
			m_selectBtn.EnableWindow(FALSE);
			m_dateCtrl.EnableWindow(FALSE);
			m_timeCtrl.EnableWindow(FALSE);

			m_add_ass_btn.EnableWindow(FALSE);
			m_del_ass_btn.EnableWindow(FALSE);
			m_add_remove_ass_btn.EnableWindow(FALSE);
			m_del_remove_ass_btn.EnableWindow(FALSE);

			m_dscr.SetReadOnly();
			m_note_ctrl.SetReadOnly();
			m_combo_method.EnableWindow(FALSE);
			m_stateCB.EnableWindow(FALSE);

		}

		if (!m_bCanSelect)
			m_selectBtn.EnableWindow(FALSE);

		UpdateData(FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChangeDocVerDlg::OnCdDcoSelectButton() 
{
	UpdateData();

	int n;
	CaplInstance* inst= NULL; 
	long selMode= APL_MODE_SELECT_DOC_REVISION;
	CString sTitle=  APL_T("  ");
	
	CaplAttr* aNewVer = m_api->m_change_mgr.a_avc_new_rev;
	CaplAttr* aVerObj = m_api->m_doc_mgr.a_apl_doc_rev_doc;
	CaplAttr* aObjActVer = m_api->m_doc_mgr.a_apl_doc_active;
	CaplAttr* aVerId = m_api->m_doc_mgr.a_apl_doc_rev_id;
	CaplAttr* aObjId = m_api->m_doc_mgr.a_doc_id;
	CaplAttr* aObjName = m_api->m_doc_mgr.a_doc_name;

	// -
	if (m_viewMode == 1)
	{
		selMode= APL_MODE_SELECT_BP_REVISION;
		sTitle=  APL_T("  -");
		
		aNewVer= m_api->m_change_mgr.a_abpc_new_rev;
		aVerObj= m_api->m_bp_mgr.a_bp_ver_bp;
		aObjActVer= m_api->m_bp_mgr.a_bp_act;
		aVerId= m_api->m_bp_mgr.a_bp_ver_num;
		aObjId= m_api->m_bp_mgr.a_bp_id;
		aObjName= m_api->m_bp_mgr.a_bp_name;
	}
	// -
	else if (m_viewMode == 2)
	{
		selMode= APL_MODE_SELECT_CHARACT_REVISION;
		sTitle=  APL_T("  ");
		
		aNewVer= m_api->m_change_mgr.a_char_change_new_rev;
		aVerObj= m_api->m_charact_mgr.a_apl_charact_val_ver_char_value;
		aObjActVer= m_api->m_charact_mgr.a_apl_charact_val_act_ver;
		aVerId= m_api->m_charact_mgr.a_apl_charact_val_ver_version_num;
		
		aObjId = NULL;
		aObjName = NULL;
	}
	
	inst= m_api->m_doc_mgr.SelectInstance(selMode, sTitle);
	if (inst)
	{
		CaplInstance* doc= NULL, *inst1= NULL, *rev= NULL;

		if(m_avc) apidata.GetAttr(m_avc, aNewVer, rev);
		else if(m_newChng) rev= m_newChng->m_newVer;
		
		if(rev)
		{
			apidata.GetAttr(m_newRev, aVerObj, doc);
			apidata.GetAttr(inst, aVerObj, inst1);
			if(doc!=inst1)
			{
				if(m_viewMode==0)
					MessageBox( APL_T("   ."),  APL_T(" "), MB_ICONERROR|MB_OK);
				else if(m_viewMode==1)
					MessageBox( APL_T("   -."),  APL_T(" "), MB_ICONERROR|MB_OK);
				else if(m_viewMode==2)
					MessageBox( APL_T("   ."),  APL_T(" "), MB_ICONERROR|MB_OK);
				return;
			}
		}
		else // - . 
		{
			// ,       
			CaplInstance *obj= NULL; 
			m_api->m_data.GetAttr(inst, aVerObj, obj);
			if(obj)
			{
				for(n= 0; n<m_delItems->GetSize(); n++)
				{
					CaplInstance *delVer= NULL, *delObj= NULL;

					if(m_api->m_data.IsKindOf(m_delItems->GetAt(n), m_api->m_change_mgr.e_avc))
						m_api->m_data.GetAttr(m_delItems->GetAt(n), m_api->m_change_mgr.a_avc_new_rev, delVer);
					else if(m_api->m_data.IsKindOf(m_delItems->GetAt(n), m_api->m_change_mgr.e_abpc))
						m_api->m_data.GetAttr(m_delItems->GetAt(n), m_api->m_change_mgr.a_abpc_new_rev, delVer);
					
					if(delVer)
					{
						m_api->m_data.GetAttr(delVer, aVerObj, delObj);
						if(delObj==obj)
						{
							m_avc= m_delItems->GetAt(n);
							m_newRev= delVer;
							m_doc_or_bp= delObj;
							m_delItems->Remove(n);
							break;
						}
					}
				}
				bool bExisted = false;

				for (n = 0; n < m_items->GetSize(); n++)
				{	
					if (bExisted)
						break;

					CaplInstance* ver= NULL, *crObj= NULL;
					if(m_api->m_data.IsKindOf(m_items->GetAt(n), m_api->m_change_mgr.e_avc))
						m_api->m_data.GetAttr(m_items->GetAt(n), m_api->m_change_mgr.a_avc_new_rev, ver);
					else if(m_api->m_data.IsKindOf(m_items->GetAt(n), m_api->m_change_mgr.e_abpc))
						m_api->m_data.GetAttr(m_items->GetAt(n), m_api->m_change_mgr.a_abpc_new_rev, ver);
					else if(m_api->m_data.IsKindOf(m_items->GetAt(n), m_api->m_change_mgr.e_char_change))
						m_api->m_data.GetAttr(m_items->GetAt(n), m_api->m_change_mgr.a_char_change_new_rev, ver);
					
					m_api->m_data.GetAttr(ver, aVerObj, crObj);
					if (obj == crObj)
						bExisted = true;
				}
				
				for(n= 0; n<m_newItems->GetSize(); n++)
				{
					if(bExisted) break;
					CaplInstance *crObj= NULL;
					
					m_api->m_data.GetAttr(m_newItems->GetAt(n).m_newVer, aVerObj, crObj);
					if(obj==crObj) bExisted= true;			
				}

				if(bExisted)
				{
					if(m_viewMode==0)
						MessageBox( APL_T("     ."),  APL_T(" "), MB_ICONERROR|MB_OK);
					else if(m_viewMode==1)
						MessageBox( APL_T("  -   ."),  APL_T(" "), MB_ICONERROR|MB_OK);
					else if(m_viewMode==2)
						MessageBox( APL_T("     ."),  APL_T(" "), MB_ICONERROR|MB_OK);
					return;
				}
			}
		}

		if (!doc) apidata.GetAttr(inst, aVerObj, doc);
		if (!doc) return; //-V581

		apidata.GetAttr(doc, aObjActVer, inst1);
		if (inst1 == inst)
		{
			CString msg;



			if (m_viewMode == 0)
				msg=APL_T("    .\n\n?");
			else if (m_viewMode==1)
				msg= APL_T("  -  .\n\n?");
			else if (m_viewMode==2)
				msg= APL_T("    .\n\n?");
			
			if(IDYES!=MessageBox( msg,  APL_T(" "), MB_ICONERROR|MB_YESNO)) return;
		}
		
		//,  ...
		m_newRev= inst;			
		m_doc_or_bp= doc;

		apidata.GetAttr(m_newRev, aVerId, m_sNewVer);
		
		CString str;		
		
		if (aObjId)
			apidata.GetAttr(m_doc_or_bp, aObjId, m_sDoc);

		if (aObjName)
			apidata.GetAttr(m_doc_or_bp, aObjName, str);

		if (!m_sDoc.IsEmpty())
			m_sDoc += _T(":");

		m_sDoc += str;
		
		if (m_viewMode == 0)
		{
			CaplInstance *docType;
			apidata.GetAttr(m_doc_or_bp, m_api->m_doc_mgr.a_doc_kind, docType);
			if (docType != 0 && docType->GetAccessmode()!=aplNO)
			{
				apidata.GetAttrBN(docType, _T("product_data_type"), str);
				if (!m_sDoc.IsEmpty())
					m_sDoc += _T(":");

				m_sDoc += str;
			}
			if (m_sDoc.IsEmpty())
				m_sDoc = _T("???");
		}
		else if (m_viewMode == 2)
		{
			CaplInstance* charact = NULL;
			m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_charact_mgr.a_apl_charact_val_charact, charact);
			if (charact)
			{
				m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_name, m_sDoc);				
			}
			CaplInstance* type = NULL;
			m_api->m_data.GetAttr(m_doc_or_bp, m_api->m_charact_mgr.a_apl_charact_val_type, type);
			if (type)
			{
				if (m_sDoc.IsEmpty())
					m_sDoc = _T("?");

				//m_sDoc += APL_T(" [ ");
				m_api->m_data.GetAttr(type, m_api->m_charact_mgr.a_apl_charact_type_name, str);
				m_sDoc += _T(" ");
				//if (str.IsEmpty())
				//	str = _T("?");
			}
			else
			{
				//if (m_sDoc.IsEmpty())
				//	str = APL_T("[  ");
				//else
				//	str = APL_T(" [  ");
			}

			m_sDoc += str;
			//m_sDoc += _T("]");

			m_sDoc +=  APL_T("  ");
			m_sDoc += GetCharactValAssocItemStr(m_doc_or_bp);
		}
		
		apidata.GetAttr(doc, aObjActVer, inst);
		apidata.GetAttr(inst, aVerId, m_sOldVer);
		
	}

	UpdateData(FALSE);
}

void CChangeDocVerDlg::OnOK()
{
	if(!UpdateData()) return;
	
	if(!m_newRev)
	{
		if (1 == m_viewMode)
			MessageBox( APL_T("-  ."),  APL_T(""), MB_OK | MB_ICONERROR);
		else if (0 == m_viewMode && !m_bZerroDocRev)
			MessageBox( APL_T("  ."),  APL_T(""), MB_OK | MB_ICONERROR);
		else if (2 == m_viewMode) 
			MessageBox( APL_T("  ."),  APL_T(""), MB_OK | MB_ICONERROR);	
		if(!m_bZerroDocRev) return;
	}

	COleDateTime odt, odt0, odt1, odt_old; 
	CString buf,s_dt;
	odt.SetDateTime(m_acceptDate.GetYear(),m_acceptDate.GetMonth(),m_acceptDate.GetDay(),
		m_acceptTime.GetHour(),m_acceptTime.GetMinute(),m_acceptTime.GetSecond());
	aplDate2String(odt, s_dt);
	
	bool bSave = false;
	int i;

	SCDFileInfo* file_info;
	aplExtent atta;
	i=m_fileList.GetNextItem(-1, LVNI_ALL);

	while(i>=0)
	{
		file_info = (SCDFileInfo*)m_fileList.GetItemData(i);
		if(file_info==0)continue;
		if(file_info->inst==0)
		{
			file_info->inst=m_api->m_doc_mgr.CreateFile(file_info->FileName, true);
			if (file_info->inst==0)
			{
				CString buf;
				buf.Format( APL_T("   \n\n\"%s\" "), LPCTSTR(file_info->FileName));
				AfxMessageBox(buf, MB_OK | MB_ICONSTOP);
			}
		}
		if(file_info->inst!=0)
		{
			atta.Add(file_info->inst);
			m_api->m_data.PutAttr(file_info->inst,m_api->m_doc_mgr.a_apl_stored_document_code,file_info->code);
		}

		i=m_fileList.GetNextItem(i, LVNI_ALL);
	}

	for (i = 0; i < m_fileListDeleted.GetSize(); i++)
	{
		file_info = m_fileListDeleted[i];
		if(file_info==0)continue;
		if(file_info->inst==0)continue;

		apidata.NET_DeleteBlob(file_info->inst, m_api->m_doc_mgr.a_apl_stored_document_source);
		apidata.DeleteInstance(file_info->inst);
		bSave= true;
	}

	if (m_avc)
	{
		CaplAttr* newRevAttr= NULL;
		CaplInstance* cTestInst;
		bool bModyfied;

		if (0 == m_viewMode)newRevAttr= m_api->m_change_mgr.a_avc_new_rev;
		else if (1 == m_viewMode)newRevAttr= m_api->m_change_mgr.a_abpc_new_rev;
		else if (2 == m_viewMode)newRevAttr= m_api->m_change_mgr.a_char_change_new_rev;

		apidata.GetAttr(m_avc, newRevAttr, cTestInst);
		bModyfied= (cTestInst!=m_newRev);
		apidata.PutAttr(m_avc, newRevAttr, m_newRev);
		
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_id, m_sId);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_dscr, m_sDscr);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_notes, m_sNotes);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_attachment, atta);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_accept_date, s_dt);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_user, m_sUser);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_autor, m_person);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_chng_item_replace_state, m_api->m_change_mgr.GetWFStateNameEng(m_sNewState));

		if (0 == m_viewMode)
		{
			m_combo_method.GetWindowText(buf);
			apidata.PutAttr(m_avc, m_api->m_change_mgr.a_avc_method, buf);
		}

		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_avc_items_for_add_relation, m_ext_items_for_add_relation);
		apidata.PutAttr(m_avc, m_api->m_change_mgr.a_avc_items_for_del_relation, m_ext_items_for_del_relation);
		
		bSave = true;
		
		if(bModyfied)
		{
			m_api->m_data.GetAttr(m_avc, m_api->m_change_mgr.a_chng_item_of_chng, cTestInst);
			if(cTestInst)
				m_api->m_data.PutAttr(cTestInst, m_api->m_change_mgr.a_chng_is_modify, bModyfied);
		}
	}
	else if (m_newChng)
	{
//		&m_newChng= m_newItems->ElementAt(i);
//		m_newChng->m_sStock= m_sStock;
		m_newChng->m_newVer= m_newRev;
		m_newChng->m_sId= m_sId;
		m_newChng->m_sDscr= m_sDscr;
		m_newChng->m_sNotes= m_sNotes;
//		m_newChng->m_sBasis= m_sBasis;
		m_newChng->SetAttachment(atta);
		m_newChng->m_sUser= m_sUser;
		m_newChng->m_person= m_person;
		m_newChng->m_sDate= s_dt;
		m_newChng->m_sNewState= m_api->m_change_mgr.GetWFStateNameEng(m_sNewState);
		m_newChng->m_ext4AddToItem=m_ext_items_for_add_relation;
		m_newChng->m_ext4DelFromItem=m_ext_items_for_del_relation;

		m_combo_method.GetWindowText(buf);
		m_newChng->m_sMethod=buf;
	}
	else //  
	{
		CDAVCItemInfo info;
//		info.m_sStock= m_sStock;
		info.m_newVer= m_newRev;
		info.m_sId= m_sId;
		info.m_sDscr= m_sDscr;
		info.m_sNotes= m_sNotes;
//		info.m_sBasis= m_sBasis;
		info.SetAttachment(atta);
		info.m_sUser= m_sUser;
		info.m_person= m_person;
		info.m_sDate= s_dt;
		info.m_sNewState= m_api->m_change_mgr.GetWFStateNameEng(m_sNewState);
		info.m_ext4AddToItem=m_ext_items_for_add_relation;
		info.m_ext4DelFromItem=m_ext_items_for_del_relation;

		m_combo_method.GetWindowText(buf);
		info.m_sMethod=buf;

		m_newItems->Add(info);
	}

	if (bSave) apidata.NET_SaveChanges();

	CaplTranslateDialog::OnOK();
}

void CChangeDocVerDlg::OnCancel() 
{
	CaplTranslateDialog::OnCancel();
}

void CChangeDocVerDlg::OnCdAddFile() 
{
	CFileDialog dlg(TRUE,0,0,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY,
		_T("All Files (*.*)|*.*||"));
	if(dlg.DoModal()==IDOK)
	{
		LVFINDINFO pFindInfo;
		SCDFileInfo* file_info;
//		pFindInfo.psz= dlg.GetPathName();
		CString buf= dlg.GetPathName();
		pFindInfo.psz= buf;
		pFindInfo.flags= LVFI_STRING;

		if(m_fileList.FindItem(&pFindInfo, -1)>=0)
			MessageBox( APL_T("   ."),  APL_T(" "),
				MB_OK|MB_ICONERROR);
		else
		{
			file_info = new SCDFileInfo();
			file_info->FileName = dlg.GetPathName();
			m_fileListData.Add(file_info);

			int i= m_fileList.GetItemCount();
			int pos=m_fileList.InsertItem(i, _T(""));
			m_fileList.SetItemData(pos, (DWORD)file_info);
			m_fileList.SetItemState(pos,LVNI_SELECTED,LVNI_SELECTED);
			m_fileList.SetItemText(pos,1,file_info->FileName);
		}
	}	
}

void CChangeDocVerDlg::OnCdDeleteFile() 
{
	int i=m_fileList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(i<0)	{MessageBox( APL_T(" ."),  APL_T(""), MB_OK|MB_ICONERROR);	return;	}
	if(IDNO==MessageBox( APL_T("    ?"),  APL_T(" "), MB_YESNO|MB_ICONQUESTION)) return;

	SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(i);
	if(file_info==0) return;
	
	m_fileListDeleted.Add(file_info);
	m_fileList.DeleteItem(i);	
}

void CChangeDocVerDlg::OnCdSaveFile() 
{
	int i=m_fileList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(i<0)	{MessageBox( APL_T(" ."),  APL_T(""), MB_OK|MB_ICONERROR);	return;	}
	
	SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(i);
	if(file_info==0) return;

	if(file_info->inst==0){ AfxMessageBox( APL_T("      "));	return;	}
	m_api->m_doc_mgr.LoadRevision(file_info->inst,0);
}

void CChangeDocVerDlg::OnCdViewFile() 
{
	int i=m_fileList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(i<0)	{MessageBox( APL_T(" ."),  APL_T(""), MB_OK|MB_ICONERROR);	return;	}
	
	SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(i);
	if(file_info==0) return;
	if(file_info->inst==0)
	{
		CString fpath= m_fileList.GetItemText(i, 0);
		HINSTANCE hRes=aplShellExecute(0,_T("open"),fpath);
		if((int)hRes<=32)  return ; //      aplShellExecute
	}
	else if(m_api) 
		m_api->m_doc_mgr.View(file_info->inst);
}

void CChangeDocVerDlg::OnCdViewRevNew() 
{
	if(!m_newRev)
	{
		if(m_viewMode==0)
			MessageBox( APL_T("  ."),  APL_T(" "), 
				MB_OK|MB_ICONINFORMATION);
		else if(m_viewMode==1)
			MessageBox( APL_T("  -."),  APL_T(" -"), 
				MB_OK|MB_ICONINFORMATION);			
		else if(m_viewMode==2)
			MessageBox( APL_T("  ."),  APL_T(" "), 
				MB_OK|MB_ICONINFORMATION);			
		return;
	}
	if(m_viewMode==0)
		m_api->m_doc_mgr.View(m_newRev);
	else if(m_viewMode==1)
		m_api->m_bp_mgr.ShowBPProperties(m_newRev);
	else if(m_viewMode==2)
		m_api->m_charact_mgr.ShowProperties(m_newRev);
}

void CChangeDocVerDlg::OnCdViewRevOld() 
{
	CaplAttr* aVerObj= m_api->m_doc_mgr.a_apl_doc_rev_doc;
	CaplAttr* aObjActive= m_api->m_doc_mgr.a_apl_doc_active;
	if(m_viewMode==1)
	{
		aVerObj= m_api->m_bp_mgr.a_bp_ver_bp;
		aObjActive= m_api->m_bp_mgr.a_bp_act;
	}
	else if(m_viewMode==2)
	{
		aVerObj= m_api->m_charact_mgr.a_apl_charact_val_ver_char_value;
		aObjActive= m_api->m_charact_mgr.a_apl_charact_val_act_ver;
	}

	if(!m_oldRev)
	{
		if(!m_doc_or_bp && m_newRev) apidata.GetAttr(m_newRev, aVerObj, m_doc_or_bp);
		if(m_doc_or_bp) apidata.GetAttr(m_doc_or_bp, aObjActive, m_oldRev);			
		if(!m_oldRev)
		{
			if(m_viewMode==0)
				MessageBox( APL_T("  ."),  APL_T(" "), 
					MB_OK|MB_ICONINFORMATION);
			else if(m_viewMode==1)
				MessageBox( APL_T("  -."),  APL_T(" -"), 
					MB_OK|MB_ICONINFORMATION);			
			else if(m_viewMode==2)
				MessageBox( APL_T("  ."),  APL_T(" "), 
					MB_OK|MB_ICONINFORMATION);			
			return;
		}
	}
	
	if(m_viewMode==0)
		m_api->m_doc_mgr.View(m_oldRev);
	else if(m_viewMode==1)
		m_api->m_bp_mgr.ShowBPProperties(m_oldRev);
	else if(m_viewMode==2)
		m_api->m_charact_mgr.ShowProperties(m_oldRev);
}

CString CChangeDocVerDlg::GetCharactValAssocItemStr(CaplInstance* iCharactVal)
{
	if (!iCharactVal)
		return _T("");

	CaplInstance* inst = NULL;
	CString buf, buf1, res;

	apidata.GetAttr(iCharactVal, m_api->m_charact_mgr.a_apl_charact_val_item, inst);

	// product
	if (apidata.IsKindOf(inst, m_api->m_prd_mgr.e_prd))
	{
		apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, buf);
		apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, buf1);

		res = buf + _T(" : ") + buf1;
	}

	// product_definition_formation
	if (apidata.IsKindOf(inst, m_api->m_prd_mgr.e_pdf))
	{
		CString buf2;
		CaplInstance* inst_prd = NULL;

		apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdf_prd, inst_prd);
		
		//  NULL,      .  ...
		if (!inst_prd)
		{
			m_api->m_prd_mgr.LoadPrdInfo(inst);
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdf_prd, inst_prd);
		}

		apidata.GetAttr(inst_prd, m_api->m_prd_mgr.a_prd_id, buf);
		apidata.GetAttr(inst_prd, m_api->m_prd_mgr.a_prd_name, buf1);

		apidata.GetAttr(inst, m_api->m_prd_mgr.a_pdf_id, buf2);

		if (buf2.IsEmpty())
			res = buf + _T(" : ") + buf1;
		else
			res = buf + _T(" - ") + buf2 + _T(" : ") + buf1;
	}

	return res;
}

void CChangeDocVerDlg::OnCdFileUp()
{
	int i=m_fileList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(i<=0)	return;
	SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(i);
	if(file_info==0)return;
	m_fileList.DeleteItem(i);
	int pos=m_fileList.InsertItem(i-1,file_info->code);
	m_fileList.SetItemText(pos,1,file_info->FileName);
	m_fileList.SetItemData(pos,(DWORD)file_info);
	m_fileList.SetItemState(pos,LVNI_SELECTED,LVNI_SELECTED);
}

void CChangeDocVerDlg::OnCdFileDown()
{
	int i=m_fileList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(i<0 || i> m_fileList.GetItemCount()-1)	return;
	SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(i);
	if(file_info==0)return;
	m_fileList.DeleteItem(i);
	int pos=m_fileList.InsertItem(i+1,file_info->code);
	m_fileList.SetItemText(pos,1,file_info->FileName);
	m_fileList.SetItemData(pos,(DWORD)file_info);
	m_fileList.SetItemState(pos,LVNI_SELECTED,LVNI_SELECTED);
}


void CChangeDocVerDlg::OnDblclkFileList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if(pNMLV->iItem == -1)
	{
		// ,  ,    OnCdAddFile() 
		return;
	}
	else if(pNMLV->iSubItem == 0)
	{
		BeginEditLabel();
	}
	else if(pNMLV->iSubItem == 1)
	{
		BeginEditLabel();
	}
}

void CChangeDocVerDlg::BeginEditLabel()
{
	BOOL res=true;
	CRect rect;

	m_num_edit_item = m_fileList.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if(m_num_edit_item==-1) return;
	SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(m_num_edit_item);
	if(file_info==0)return;
	
	//     
	m_Edit4Edit.SetWindowText(file_info->code);

	//   - 
	//    
	m_fileList.GetItemRect(m_num_edit_item,rect,LVIR_BOUNDS);

	//   
	//  edit.    edit
 	rect.left += 4; //2;
 	rect.right = m_fileList.GetColumnWidth(0) -1; //+1;
// 	rect.top += 1;
// 	rect.bottom -= 2;

	res=m_Edit4Edit.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),SWP_SHOWWINDOW|SWP_NOCOPYBITS);
	m_Edit4Edit.SetFocus();
	m_Edit4Edit.SetForegroundWindow();
}


BOOL CChangeDocVerDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
#ifdef _DEBUG
	// 	CString str;
	// 	str.Format(_T("%i \n"),pMsg->message);
	// 	OutputDebugString(str);
#endif

	if(pMsg!=0)
	{
		switch ( pMsg->message )
		{
		case WM_KEYDOWN:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONDBLCLK:
		case WM_MBUTTONDOWN:
		case WM_MBUTTONDBLCLK:
			if(TestEndEdit(pMsg) == TRUE)
				return TRUE;
			break;
		}
	}

	return CaplTranslateDialog::PreTranslateMessage(pMsg);
}


BOOL CChangeDocVerDlg::TestEndEdit(MSG* pMsg)
{
	BOOL retval = FALSE;
	bool is_end_combo = false;
	bool is_save = true;

	if(pMsg == 0) return FALSE;
	if(m_num_edit_item == -1) return FALSE;

	if(pMsg->hwnd != m_Edit4Edit.m_hWnd)
	{
		//        
		is_end_combo = true;
	}
	else if(pMsg->message == WM_KEYDOWN )
	{
		switch (pMsg->wParam)
		{
		case VK_ESCAPE:
			//  Escvape. ,   
			is_end_combo = true;
			is_save = false;
			retval = TRUE;
			break;
		case VK_RETURN:
			//  Enter. ,   
			//     -      ;)
			retval = TRUE;
			is_end_combo = true;
			break;
		case VK_TAB:
			//  Tab.    
			is_end_combo = true;
			break;
		}
	}
	if(is_end_combo)
	{
		m_Edit4Edit.ShowWindow(SW_HIDE);
		
		if(is_save)
		{
			SCDFileInfo* file_info = (SCDFileInfo*)m_fileList.GetItemData(m_num_edit_item);
			if(file_info==0) return retval;
			m_Edit4Edit.GetWindowText(file_info->code);
			m_fileList.SetItemText(m_num_edit_item,0,file_info->code);
		}
		m_num_edit_item = -1;
	}
	return retval;
}

void CChangeDocVerDlg::update_items_for_add_relation()
{
	m_list_4_ass.DeleteAllItems();
	int i,k;
	CString buf;
	m_api->LoadExtentInfo(m_ext_items_for_add_relation);
	for(i=0;i<m_ext_items_for_add_relation.GetSize();i++)
	{
		CaplInstance *inst=m_ext_items_for_add_relation[i];
		buf=m_api->GetItemName(inst);
		int ico=m_api->GetInstIco(inst);
		k=m_list_4_ass.InsertItem(m_list_4_ass.GetItemCount(),buf,ico);
		m_list_4_ass.SetItemData(k,(long)inst);
	}
}

void CChangeDocVerDlg::update_items_for_del_relation()
{
	m_list_4_del.DeleteAllItems();
	int i,k;
	CString buf;
	m_api->LoadExtentInfo(m_ext_items_for_del_relation);
	for(i=0;i<m_ext_items_for_del_relation.GetSize();i++)
	{
		CaplInstance *inst=m_ext_items_for_del_relation[i];
		buf=m_api->GetItemName(inst);
		int ico=m_api->GetInstIco(inst);
		k=m_list_4_del.InsertItem(m_list_4_ass.GetItemCount(),buf,ico);
		m_list_4_del.SetItemData(k,(long)inst);
	}
}


void CChangeDocVerDlg::OnBnClickedAddRelAdd()
{
	aplExtent ext;
	bool b=m_api->m_prd_mgr.SelectInstanceEx(APL_MODE_SELECT_PDF|APL_MODE_SELECT_DOC|APL_MODE_SELECT_BP|APL_MODE_SELECT_LOT|APL_MODE_SELECT_PRDINST|APL_MODE_SELECT_PROJECT|APL_MODE_SELECT_BPINST,
		ext,APL_T(" "));
	if(ext.GetSize()<=0) return;

	int i,j, i_found=0;
	for(i=0;i<m_ext_items_for_del_relation.GetSize();i++)
	{
		for(j=0;j<ext.GetSize();j++)
		{
			if(m_ext_items_for_del_relation[i]==ext[j])
			{
				i_found++;
				ext.Remove(j);
				j--;
			}
		}
	}

	if(i_found>0)
	{
		AfxMessageBox(_T("      .  ."),MB_OK|MB_ICONWARNING);
		return;
	}

	if(0==ext.GetSize()) return;


	m_ext_items_for_add_relation.Append(ext);
	update_items_for_add_relation();
}

void CChangeDocVerDlg::OnBnClickedDelRelAdd()
{
	int i,j,n=m_list_4_ass.GetSelectedCount();
	if(n<=0){AfxMessageBox(APL_T("  !"),MB_ICONINFORMATION|MB_OK); return;}
	CString buf;
	buf.Format(APL_T(" %i   ?"),n);
	if(IDYES!=AfxMessageBox(buf,MB_ICONSTOP|MB_YESNO)) return;

	int nItem=-1;
	aplExtent ext4Delete;
	for (i=0; i < n; i++)
	{
		nItem = m_list_4_ass.GetNextItem(nItem, LVNI_SELECTED);
		if(nItem<0) break;
		
		CaplInstance *inst=(CaplInstance *) m_list_4_ass.GetItemData(nItem);
		if(0!=inst) ext4Delete.Add(inst);
	}

	for(i=0;i<ext4Delete.GetSize();i++)
	{
		CaplInstance *inst4del=ext4Delete[i];
		for(j=0;j<m_ext_items_for_add_relation.GetSize();j++)
		{
			if(inst4del==m_ext_items_for_add_relation[j])
			{
				m_ext_items_for_add_relation.Remove(j);
				break;
			}
		}
	}
	update_items_for_add_relation();
}


void CChangeDocVerDlg::OnBnClickedRemoveRelAdd()
{
	aplExtent ext;
	bool b=m_api->m_prd_mgr.SelectInstanceEx(APL_MODE_SELECT_PDF|APL_MODE_SELECT_DOC|APL_MODE_SELECT_BP|APL_MODE_SELECT_LOT|APL_MODE_SELECT_PRDINST|APL_MODE_SELECT_PROJECT|APL_MODE_SELECT_BPINST,
		ext,APL_T(" "));
	if(ext.GetSize()<=0) return;

	int i,j, i_found=0;
	for(i=0;i<m_ext_items_for_add_relation.GetSize();i++)
	{
		for(j=0;j<ext.GetSize();j++)
		{
			if(m_ext_items_for_add_relation[i]==ext[j])
			{
				i_found++;
				ext.Remove(j);
				j--;
			}
		}
	}

	if(i_found>0)
	{
		AfxMessageBox(_T("      .  ."),MB_OK|MB_ICONWARNING);
		return;
	}

	if(0==ext.GetSize()) return;

	m_ext_items_for_del_relation.Append(ext);
	update_items_for_del_relation();	
}

void CChangeDocVerDlg::OnBnClickedRemoveRelDel()
{
	int i,j,n=m_list_4_del.GetSelectedCount();
	if(n<=0){AfxMessageBox(APL_T("  !"),MB_ICONINFORMATION|MB_OK); return;}
	CString buf;
	buf.Format(APL_T(" %i   ?"),n);
	if(IDYES!=AfxMessageBox(buf,MB_ICONSTOP|MB_YESNO)) return;

	int nItem=-1;
	aplExtent ext4Delete;
	for (i=0; i < n; i++)
	{
		nItem = m_list_4_del.GetNextItem(nItem, LVNI_SELECTED);
		if(nItem<0) break;

		CaplInstance *inst=(CaplInstance *) m_list_4_del.GetItemData(nItem);
		if(0!=inst) ext4Delete.Add(inst);
	}

	for(i=0;i<ext4Delete.GetSize();i++)
	{
		CaplInstance *inst4del=ext4Delete[i];
		for(j=0;j<m_ext_items_for_del_relation.GetSize();j++)
		{
			if(inst4del==m_ext_items_for_del_relation[j])
			{
				m_ext_items_for_del_relation.Remove(j);
				break;
			}
		}
	}
	update_items_for_del_relation();
}
