// ChangeParamDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ChangeParamDlg.h"
#include "apl_api.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangeParamDlg dialog


CChangeParamDlg::CChangeParamDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CChangeParamDlg::IDD, pParent)
	, m_sAssemblyInfo(_T(""))
	, m_sPdrName(_T(""))
	, m_sPdrDscr(_T(""))
{
	//{{AFX_DATA_INIT(CChangeParamDlg)
	m_dateEnd = COleDateTime::GetCurrentTime();
	m_dateStart = COleDateTime::GetCurrentTime();
	m_sId = _T("");
	m_sName = _T("");
	m_sRegNum = _T("");
	m_bDateEndSel = FALSE;
	m_effType = 0;
	m_sSNEnd = _T("");
	m_dSNEndSel = FALSE;
	m_sSNStart = _T("");
	m_timeEnd = COleDateTime::GetCurrentTime();
	m_timeStart = COleDateTime::GetCurrentTime();
	m_iUnits = -1;
	m_iValue = 1.0;
	m_sVer = _T("");
	m_sPosition = _T("");
	m_sPositionNum = _T("");
	m_iDerUnit = -1;
	m_iDerValue = 1.0;
	m_iPrior = 1;
	m_sCondition = _T("");
	m_sZagotov = _T("");
	m_iSortam = -1;
	//}}AFX_DATA_INIT
	
	m_sType= _T("add");
	m_sEffType= _T("none");

	m_api= NULL;
	m_mode= 0;

	m_psc= NULL;
	m_pscInfo= NULL;

	m_newPdf= NULL;
	m_upLevelPdf= NULL;
	m_unitInst= NULL;
	m_derUnitInst= NULL;
	m_assortment= NULL;
	m_change= NULL;
	m_parent_pdf= NULL;

	m_bContextsChanged= false;
	m_bReadOnly= false;
	
	m_timeStart.SetTime(0, 0, 0);
	m_timeEnd.SetTime(0, 0, 0);
}

void CChangeParamDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeParamDlg)
	DDX_Control(pDX, IDC_STATIC13, m_static13);
	DDX_Control(pDX, IDC_STATIC12, m_static12);
	DDX_Control(pDX, IDC_STATIC10, m_static10);
	DDX_Control(pDX, IDC_STATIC11, m_static11);
	DDX_Control(pDX, IDC_CHG2_STATIC9, m_static9);
	DDX_Control(pDX, IDC_CHG2_STATIC8, m_static8);
	DDX_Control(pDX, IDC_CHG2_STATIC7, m_static7);
	DDX_Control(pDX, IDC_CHG2_STATIC6, m_static6);
	DDX_Control(pDX, IDC_CHG2_STATIC5, m_static5);
	DDX_Control(pDX, IDC_CHG2_STATIC4, m_static4);
	DDX_Control(pDX, IDC_CHG2_STATIC3, m_static3);
	DDX_Control(pDX, IDC_CHG2_STATIC2, m_static2);
	DDX_Control(pDX, IDC_CHG2_STATIC1, m_static1);
	DDX_Control(pDX, IDC_PARAM_ZAGOT, m_zagotov);
	DDX_Control(pDX, IDC_PARAM_SORTAM, m_sortam);
	DDX_Control(pDX, IDC_PARAM_TEH_TREB, m_condition);
	DDX_Control(pDX, IDC_PARAM_PRIOR, m_prior);
	DDX_Control(pDX, IDC_PARAM_DER_VAL, m_derValueCtrl);
	DDX_Control(pDX, IDC_PARAM_DER_UNITS, m_derUnit);
	DDX_Control(pDX, IDC_PARAM_VER, m_ver);
	DDX_Control(pDX, IDC_PARAM_NAME, m_name);
	DDX_Control(pDX, IDC_PARAM_ID, m_id);
	DDX_Control(pDX, IDC_PARAM_REG_NUM, m_regNum);
	DDX_Control(pDX, IDC_PARAM_VAL, m_valueCtrl);
	DDX_Control(pDX, IDC_PARAM_POSITION, m_position);
	DDX_Control(pDX, IDC_PARAM_POSITION_NUM, m_positionNumCtrl);
	DDX_Control(pDX, IDC_PARAM_UNITS, m_units);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_PARAM_TIME_START, m_timeStartCtrl);
	DDX_Control(pDX, IDC_PARAM_TIME_END, m_timeEndCtrl);
	DDX_Control(pDX, IDC_PARAM_SN_START, m_snStart);
	DDX_Control(pDX, IDC_PARAM_SN_END, m_snEnd);
	DDX_Control(pDX, IDC_PARAM_SN_END_SELECT, m_snEndSel);
	DDX_Control(pDX, IDC_PARAM_SELECT, m_pdfSelBtn);
	DDX_Control(pDX, IDC_PARAM_DATE_END_SELECT, m_dateEndSel);
	DDX_Control(pDX, IDC_PARAM_EFF_NO, m_effNone);
	DDX_Control(pDX, IDC_PARAM_EFF_SN, m_effSN);
	DDX_Control(pDX, IDC_PARAM_EFF_DATE, m_effDate);
	DDX_Control(pDX, IDC_PARAM_DATE_START, m_dateStartCtrl);
	DDX_Control(pDX, IDC_PARAM_DATE_END, m_dateEndCtrl);
	DDX_DateTimeCtrl(pDX, IDC_PARAM_DATE_END, m_dateEnd);
	DDX_DateTimeCtrl(pDX, IDC_PARAM_DATE_START, m_dateStart);
	DDX_Text(pDX, IDC_PARAM_ID, m_sId);
	DDX_Text(pDX, IDC_PARAM_NAME, m_sName);
	DDX_Text(pDX, IDC_PARAM_REG_NUM, m_sRegNum);
	DDX_Text(pDX, IDC_PARAM_SN_END, m_sSNEnd);
	DDX_Text(pDX, IDC_PARAM_SN_START, m_sSNStart);
	DDX_Text(pDX, IDC_PARAM_VAL, m_iValue);
	DDX_Text(pDX, IDC_PARAM_VER, m_sVer);
	DDX_Text(pDX, IDC_PARAM_POSITION, m_sPosition);
	DDX_Text(pDX, IDC_PARAM_POSITION_NUM, m_sPositionNum);
	DDX_Text(pDX, IDC_PARAM_DER_VAL, m_iDerValue);
	DDX_Text(pDX, IDC_PARAM_PRIOR, m_iPrior);
	DDX_Text(pDX, IDC_PARAM_TEH_TREB, m_sCondition);
	DDX_Text(pDX, IDC_PARAM_ZAGOT, m_sZagotov);
	DDX_Check(pDX, IDC_PARAM_DATE_END_SELECT, m_bDateEndSel);
	DDX_Check(pDX, IDC_PARAM_SN_END_SELECT, m_dSNEndSel);
	DDX_Radio(pDX, IDC_PARAM_EFF_NO, m_effType);
	DDX_DateTimeCtrl(pDX, IDC_PARAM_TIME_END, m_timeEnd);
	DDX_DateTimeCtrl(pDX, IDC_PARAM_TIME_START, m_timeStart);
	DDX_CBIndex(pDX, IDC_PARAM_UNITS, m_iUnits);
	DDX_CBIndex(pDX, IDC_PARAM_DER_UNITS, m_iDerUnit);
	DDX_CBIndex(pDX, IDC_PARAM_SORTAM, m_iSortam);
	DDX_Control(pDX, IDC_STATIC14, m_static14);
	DDX_Text(pDX, IDC_ASSEMBLE_STATIC, m_sAssemblyInfo);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_STATIC15, m_static15);
	DDX_Control(pDX, IDC_STATIC16, m_static16);
	DDX_Control(pDX, IDC_PARAM_PDR_NAME, m_pdrNameEdit);
	DDX_Text(pDX, IDC_PARAM_PDR_NAME, m_sPdrName);
	DDX_Text(pDX, IDC_PARAM_RASC, m_sPrdRasc);
	DDX_Text(pDX, IDC_PARAM_SHOP, m_sPrdShop);
	DDX_Control(pDX, IDC_PARAM_PDR_DSCR, m_pdrDscrEdit);
	DDX_Text(pDX, IDC_PARAM_PDR_DSCR, m_sPdrDscr);
	DDX_Control(pDX, IDC_STATIC19, m_static19);
	DDX_Control(pDX, IDC_PARAM_PDR_NAME2, m_contextEdit);
	DDX_Control(pDX, IDC_SELECT_CONT_BUTTON, m_selectContextBtn);
	DDX_Control(pDX, IDC_STATIC17, m_static17);
	DDX_Control(pDX, IDC_STATIC18, m_static18);
	DDX_Control(pDX, IDC_PARAM_RASC, m_shopEdit);
	DDX_Control(pDX, IDC_PARAM_SHOP, m_customerEdit);
}


BEGIN_MESSAGE_MAP(CChangeParamDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CChangeParamDlg)
	ON_BN_CLICKED(IDC_PARAM_SELECT, OnParamSelect)
	ON_BN_CLICKED(IDC_PARAM_EFF_NO, OnParamEffNo)
	ON_BN_CLICKED(IDC_PARAM_EFF_DATE, OnParamEffDate)
	ON_BN_CLICKED(IDC_PARAM_EFF_SN, OnParamEffSN)
	ON_BN_CLICKED(IDC_PARAM_SN_END_SELECT, OnParamSnEndSelect)
	ON_BN_CLICKED(IDC_PARAM_DATE_END_SELECT, OnParamDateEndSelect)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_SELECT_CONT_BUTTON, &CChangeParamDlg::OnBnClickedSelectContButton)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeParamDlg message handlers

void CChangeParamDlg::ResetEdIzm()
{
	m_units.ResetContent();

	aplExtent ext;
	CString buf, buf1, scht;

	int option=0;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     "),option,1);
	if(1==option)
	{
		if(0!=m_newPdf)	m_api->m_charact_mgr.GetPossiblePdfUnits(m_newPdf,ext);
		else if(0!=m_psc)
		{
			CaplInstance *pdf=0;
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_changing_product, pdf);
			if(0!=pdf) m_api->m_charact_mgr.GetPossiblePdfUnits(pdf,ext);

		}
	}
	if(ext.GetSize()<=0) m_api->m_unit_exch_mgr.GetPrdUnits(ext);
	if(ext.GetSize()<=0)m_api->m_data.GetEntityExtent(m_api->m_charact_mgr.e_apl_step_unit, ext);

	CaplInstance *sht0=0,*sht1=0;
	int i;
	for(i=0; i<ext.Size; i++)
	{
		m_api->m_charact_mgr.GetUnitName(ext[i], buf);

		int k= m_units.AddString(buf);
		m_units.SetItemData(k, (UINT)ext[i]);

		buf1= buf;
		buf1.MakeLower();
		if( buf1== APL_T("")) { sht0=ext[i];}
		if(buf1.GetLength()>=2)	
		{
			if((buf1[0]==_T(''))&&(buf1[1]==_T(''))) sht1= 0;
		}
	}
	if(sht0!=0)
	{
		m_api->m_charact_mgr.GetUnitName(sht0, scht);
	}

	m_units.InsertString(0, _T(" "));
	m_units.SetItemData(0, 0);
	m_iUnits= m_units.SelectString(-1, scht);

	if(m_unitInst)
	{
		m_api->m_charact_mgr.GetUnitName(m_unitInst, scht);
		m_iUnits= m_units.SelectString(-1, scht);
	}
}



BOOL CChangeParamDlg::OnInitDialog() 
{
	int i;
	CaplTranslateDialog::OnInitDialog();

	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	m_pdfSelBtn.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_pdfSelBtn.SetFlat(FALSE);
	m_selectContextBtn.SetIcon(GetAplTableIco(APL_TABLE_FIND));
	m_selectContextBtn.SetFlat(FALSE);

	if(m_sType!=_T("add")) m_prior.SetReadOnly();

	if(m_api && apidata.IsConnected())
	{
		aplExtent ext;
		CString buf, buf1, scht;

		//  . .

		int option=0;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     "),option,1);
		if(1==option)
		{
			m_api->m_charact_mgr.GetPossiblePdfUnits(m_parent_pdf,ext);
		}

		if(ext.GetSize()<=0) m_api->m_unit_exch_mgr.GetPrdUnits(ext);
		if(ext.GetSize()<=0)m_api->m_data.GetEntityExtent(m_api->m_charact_mgr.e_apl_step_unit, ext);

		CaplInstance *sht0=0,*sht1=0;
		for(i=0; i<ext.Size; i++)
		{
			m_api->m_charact_mgr.GetUnitName(ext[i], buf);
			int k= m_derUnit.AddString(buf);
			m_derUnit.SetItemData(k, (UINT)ext[i]);
			
			buf1= buf;
			buf1.MakeLower();
			if( buf1== APL_T("")) { sht0=ext[i];}
			if(buf1.GetLength()>=2)	
			{
				if((buf1[0]==_T(''))&&(buf1[1]==_T(''))) sht1= 0;
			}
		}
		if(sht0!=0)
		{
			m_api->m_charact_mgr.GetUnitName(sht0, scht);
		}

		m_derUnit.InsertString(0, _T(" "));
		m_derUnit.SetItemData(0, 0);
		m_iDerUnit= m_units.SelectString(-1, scht);


		//  . .
		ResetEdIzm();

		apidata.GetEntityExtent(m_api->m_prd_mgr.e_assortment, ext);
		for(i= 0; i<ext.GetSize(); i++)
		{
			m_api->m_data.GetAttr(ext[i], m_api->m_prd_mgr.a_assortment_name, buf);
			int k= m_sortam.AddString(buf);
			m_sortam.SetItemData(k, (UINT)ext[i]);
		}
		
		m_sortam.InsertString(0, _T(" "));
		m_sortam.SetItemData(0, 0);
		m_iSortam= m_sortam.SelectString(-1, _T(" "));

		if(m_psc)
		{
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_id, m_sRegNum);
			m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_name, m_sPdrName);
			m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_dscr, m_sPdrDscr);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_changing_product, m_newPdf);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_changed_product, m_upLevelPdf);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_unit, m_unitInst);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_value, m_iValue);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_position, m_sPosition);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_position_num, m_sPositionNum);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_eff_type, m_sEffType);
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_frames_of_reference, m_contexts);

			m_sPrdRasc = GetRascValue(m_newPdf);
			m_sPrdShop = GetCustomerShop(m_sPrdRasc, m_newPdf);

			if(m_sEffType==_T("dated"))
			{
				apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_start_date, m_sStart);
				apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_end_date, m_sEnd);
			}
			else if(m_sEffType==_T("numbered"))
			{
				apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_start_num, m_sStart);
				apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_end_num, m_sEnd);
			}

			if(m_api->m_data.IsKindOf(m_psc, m_api->m_change_mgr.e_mat))
			{
				m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_mat_assort, m_assortment);
				m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_mat_der_unit, m_derUnitInst);
				m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_mat_der_value, m_iDerValue);
				m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_mat_renking, m_iPrior);
				m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_mat_requir, m_sCondition);
				m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_mat_size, m_sZagotov);
			}
		}
		else if(m_pscInfo)
		{
			m_sRegNum= m_pscInfo->m_sId;
			m_sPdrName= m_pscInfo->m_sName;
			m_sPdrDscr= m_pscInfo->m_sDscr;
			m_newPdf= m_pscInfo->m_pdf;
			m_upLevelPdf= m_pscInfo->m_pdr;
			m_unitInst= m_pscInfo->m_unit;
			m_iValue= m_pscInfo->m_value;
			m_sPosition= m_pscInfo->m_sPosition;
			m_sPositionNum= m_pscInfo->m_sPositionNum;
			m_sEffType= m_pscInfo->m_sEffType;
			m_sStart= m_pscInfo->m_sStartCond;
			m_sEnd= m_pscInfo->m_sEndCond;
			
			m_derUnitInst= m_pscInfo->m_der_unit;
			m_iDerValue= m_pscInfo->m_der_value;	
			m_assortment= m_pscInfo->m_sort;
			m_iPrior= m_pscInfo->m_prior;
			m_sZagotov= m_pscInfo->m_razmer;
			m_sCondition=m_pscInfo->m_tehTreb ;

			m_contexts.Append(m_pscInfo->m_contexts);
		}

		m_api->m_prd_mgr.PrintItemContextInString(m_contexts, buf);
		m_contextEdit.SetWindowText(buf);

		if(m_upLevelPdf)
		{
			CaplInstance* assembly, *part, *rel, *unit;
			double dVal;
			if(m_api->m_data.IsKindOf(m_upLevelPdf, m_api->m_prd_mgr.e_pdf))
			{
				assembly= m_upLevelPdf;
				rel= NULL;
				part= NULL;
				m_static4.SetWindowText( APL_T(""));
				if(m_psc||m_pscInfo)m_sType= _T("add");
			}
			else
			{
				m_api->m_data.GetAttr(m_upLevelPdf, m_api->m_prd_mgr.a_pdr_r_ting, assembly);
				m_api->m_data.GetAttr(m_upLevelPdf, m_api->m_prd_mgr.a_pdr_r_ted, part);
				rel= m_upLevelPdf;
				if(m_newPdf)
				{
					m_static4.SetWindowText( APL_T(""));
					if(m_psc||m_pscInfo)m_sType= _T("change");
				}
				else
					if(m_psc||m_pscInfo)m_sType= _T("delete");
			} 
			m_sAssemblyInfo=  APL_T("\t\t\t  :\n");
			if(assembly)
			{
				m_api->GetItemName(assembly, buf);
				m_sAssemblyInfo+=  APL_T(" : ")+buf+_T("\n");
			}
			if(part)
			{
				m_api->GetItemName(part, buf);
				m_sAssemblyInfo+=  APL_T("  : ");
				m_sAssemblyInfo+=buf+_T("\n");				
			}
			if(rel)
			{
				m_api->m_data.GetAttr(rel, m_api->m_prd_mgr.a_pdr_id, buf);
				m_sAssemblyInfo+=  APL_T("  : (")+buf+_T(")");
				m_api->m_data.GetAttr(rel, m_api->m_prd_mgr.a_acu_ref_des, buf);
				m_sAssemblyInfo+= _T(" {")+buf+_T("}");
				m_api->m_data.GetAttr(rel, m_api->m_prd_mgr.a_apl_qacu_value, dVal);
				buf.Format(_T(" %g"), dVal);
				m_sAssemblyInfo+=buf;
				m_api->m_data.GetAttr(rel, m_api->m_prd_mgr.a_apl_qacu_unit, unit);
				if(unit)
					m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, buf);
				m_sAssemblyInfo+= _T("[")+buf+_T("]");
			}
		}

		if(m_newPdf)
		{
			CaplInstance* inst;
			apidata.GetAttr(m_newPdf, m_api->m_prd_mgr.a_pdf_prd, inst);
			if(inst)
			{
				apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, m_sId);
				apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, m_sName);
			}
			apidata.GetAttr(m_newPdf, m_api->m_prd_mgr.a_pdf_id, m_sVer);
		}
		if(m_unitInst)
		{
			m_api->m_charact_mgr.GetUnitName(m_unitInst, scht);
			m_iUnits= m_units.SelectString(-1, scht);
		}
		if(m_derUnitInst)
		{
			m_api->m_charact_mgr.GetUnitName(m_derUnitInst, scht);
			m_iDerUnit= m_derUnit.SelectString(-1, scht);
		}
		if(m_assortment)
		{
			m_api->m_data.GetAttr(m_assortment, m_api->m_prd_mgr.a_assortment_name, buf);
			m_iSortam= m_sortam.SelectString(-1, buf);
		}
	}
	if(m_sType==_T("add"))
	{
		if(m_mode==0)
			SetWindowText( APL_T("    "));		
		else if(m_mode==1)
			SetWindowText( APL_T(" "));		
	}
	else if(m_sType==_T("change"))
	{		
		if(m_mode==0)
			SetWindowText( APL_T("    "));		
		else if(m_mode==1)
			SetWindowText( APL_T(" "));		
	}
	else if(m_sType==_T("eff_type"))
	{
		if(m_api && m_change)
		{
			apidata.GetAttr(m_change, m_api->m_change_mgr.a_chng_eff_type, m_sEffType);
			apidata.GetAttr(m_change, m_api->m_change_mgr.a_chng_start_num, m_sStart);
			apidata.GetAttr(m_change, m_api->m_change_mgr.a_chng_end_num, m_sEnd);		
		}
	}
	
	if(m_sEffType==_T("dated"))
	{
		m_effType= 1;			
		if(!m_sStart.IsEmpty())
		{
			aplString2Date(m_sStart, m_dateStart);
			aplString2Date(m_sStart, m_timeStart);
		}
		if(!m_sEnd.IsEmpty())
		{
			m_bDateEndSel= TRUE;
			aplString2Date(m_sEnd, m_dateEnd);
			aplString2Date(m_sEnd, m_timeEnd);
		}
		UpdateData(FALSE);
		OnParamEffDate();
	}
	else if(m_sEffType==_T("numbered"))
	{
		m_effType= 2;
		m_sSNStart= m_sStart;
		m_sSNEnd= m_sEnd;
		if(!m_sEnd.IsEmpty()) m_dSNEndSel= TRUE;
		
		UpdateData(FALSE);
		OnParamEffSN();
	}	

	MoveCtrls();

	//  
	if(0!=m_psc)
	{
		CaplInstance *pChange=0;
		m_api->m_data.GetAttr(m_psc,m_api->m_change_mgr.a_chng_item_of_chng, pChange);
		if(0!=pChange)
		{
			CString sState;
			m_api->m_data.GetAttr(pChange, m_api->m_change_mgr.a_chng_state, sState);
			if(!(sState==_T("") || sState==_T("not_applied")))
			{
				m_regNum.SetReadOnly();		
				m_pdrNameEdit.SetReadOnly();		
				m_pdrDscrEdit.SetReadOnly();		
				m_selectContextBtn.EnableWindow(FALSE);
				m_okBtn.EnableWindow(FALSE);
			}
		}
	}

	if(m_bReadOnly)
	{
		if(m_change && m_change->GetAccessmode()>aplRW)
		{
			m_regNum.SetReadOnly();			
			m_okBtn.EnableWindow(FALSE);
		}

		m_pdfSelBtn.EnableWindow(FALSE);
		m_position.SetReadOnly();
		m_positionNumCtrl.SetReadOnly();
		
		m_valueCtrl.SetReadOnly();
		m_units.EnableWindow(FALSE);
		
		m_dateStartCtrl.EnableWindow(FALSE);
		m_timeStartCtrl.EnableWindow(FALSE);
		m_dateEndCtrl.EnableWindow(FALSE);
		m_timeEndCtrl.EnableWindow(FALSE);
		m_dateEndSel.EnableWindow(FALSE);
		
		m_snStart.SetReadOnly();
		m_snEnd.SetReadOnly();
		m_snEndSel.EnableWindow(FALSE);
		
		m_effNone.EnableWindow(FALSE);
		m_effSN.EnableWindow(FALSE);
		m_effDate.EnableWindow(FALSE);	
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

CString CChangeParamDlg::GetCustomerShop(const CString &sRasc, CaplInstance *pPdf) const
{
	CString dllName = _T("CaplCeh.dll");

#ifdef _DEBUG
	dllName = _T("CaplCehD.dll");
#endif

	CString sValue;
	HINSTANCE hDllCharactWork = NULL;
	hDllCharactWork = AfxLoadLibrary(_T("CaplCehD.dll"));

	bool (*fnParseRasc) (CaplAPI*, LPCTSTR, const CStringArray&) = NULL;
	if(hDllCharactWork)
	{
		(FARPROC&)fnParseRasc = ::GetProcAddress(hDllCharactWork, "ParseRascGlobal");
		if(fnParseRasc)
		{
			CStringArray saDepots;
			fnParseRasc(m_api, sRasc, saDepots);

			if(saDepots.GetSize() > 0)
				sValue = saDepots[0];
		}

		//          -  
		if(pPdf)
		{
			CString sql;
			aplExtent result;
			sql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_basis_item(.pdf = #%d AND .old_customer != .new_customer AND .parent_basis->apl_changed_item.of_change->apl_change.state != 'applied')} END_SELECT"), pPdf->GetId());
			m_api->m_data.NET_QueryEditParse(sql);
			m_api->m_data.NET_QueryExecute(result);

			if(result.Size > 0)
			{
				m_api->LoadExtentInfo(result);
				m_api->m_data.GetAttr(result[0], m_api->m_change_mgr.a_basis_item_new_cust, sValue);		
			}
		}
	}

	return sValue;
}

CString CChangeParamDlg::GetRascValue(CaplInstance *pPdf) const
{
	CString sValue;

	if(pPdf)
	{
		//      
		aplExtent charactValues;
		CaplInstance *pTmpCharact = NULL;
		CaplInstance *pRascCharact = m_api->m_charact_mgr.GetCharacteristicBN(APL_T(""));

		if(pRascCharact)
		{
			m_api->m_charact_mgr.FindAssociatedCharacteristics(pPdf, charactValues);	
			for(int i=0; i<charactValues.GetSize(); i++)
			{
				m_api->m_data.GetAttr(charactValues[i], m_api->m_charact_mgr.a_apl_charact_val_charact, pTmpCharact);
				if(pTmpCharact != NULL)
				{
					if(pTmpCharact == pRascCharact)
					{
						m_api->m_data.GetAttr(charactValues[i], m_api->m_charact_mgr.a_apl_charact_val_descr_val, sValue);
						break;
					}
				}
			}
		}

		//          -  
		CString sql;
		aplExtent result;
		sql.Format(_T("SELECT Ext_1 FROM Ext_1 { apl_basis_item(.pdf = #%d AND .old_rasc != .new_rasc AND .parent_basis->apl_changed_item.of_change->apl_change.state != 'applied')} END_SELECT"), pPdf->GetId());
		m_api->m_data.NET_QueryEditParse(sql);
		m_api->m_data.NET_QueryExecute(result);

		if(result.Size > 0)
		{
			m_api->LoadExtentInfo(result);
			m_api->m_data.GetAttr(result[0], m_api->m_change_mgr.a_basis_item_new_rasc, sValue);		
		}
	}
	
	return sValue;
}

void CChangeParamDlg::MoveCtrls()
{
	int iOffset= 0;
	CRect rect, rect1, rect2;
	int a= 0, b= 0;		
	
	if(0==m_mode)// 
	{
		m_static9.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static10.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static11.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static12.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static13.ModifyStyle(WS_VISIBLE, 0, 0);
		m_zagotov.ModifyStyle(WS_VISIBLE, 0, 0);
		m_sortam.ModifyStyle(WS_VISIBLE, 0, 0);
		m_condition.ModifyStyle(WS_VISIBLE, 0, 0);
		m_prior.ModifyStyle(WS_VISIBLE, 0, 0);
		m_derValueCtrl.ModifyStyle(WS_VISIBLE, 0, 0);
		m_derUnit.ModifyStyle(WS_VISIBLE, 0, 0);		
		
		m_static9.GetWindowRect(&rect1);
		iOffset-=5;
	}
	else// 
	{
		m_static6.ModifyStyle(WS_VISIBLE, 0, 0);
		m_position.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static14.ModifyStyle(WS_VISIBLE, 0, 0);
		m_positionNumCtrl.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static15.ModifyStyle(WS_VISIBLE, 0, 0);
		m_pdrNameEdit.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static16.ModifyStyle(WS_VISIBLE, 0, 0);
		m_pdrDscrEdit.ModifyStyle(WS_VISIBLE, 0, 0);

		m_static19.ModifyStyle(WS_VISIBLE, 0, 0);
		m_contextEdit.ModifyStyle(WS_VISIBLE, 0, 0);
		m_selectContextBtn.ModifyStyle(WS_VISIBLE, 0, 0);

		m_static6.GetWindowRect(&rect1);
		m_static7.GetWindowRect(&rect2);
		a= rect2.top - rect1.top; 
		
		rect2.top-=a;
		rect2.bottom-=a;
		ScreenToClient(&rect2);	m_static7.MoveWindow(&rect2);
		m_static7.SetWindowText( APL_T(" -:"));

		m_static9.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_static9.MoveWindow(&rect);
		m_static10.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_static10.MoveWindow(&rect);
		m_static11.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_static11.MoveWindow(&rect);
		m_static12.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_static12.MoveWindow(&rect);
		m_static13.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_static13.MoveWindow(&rect);
		
		m_zagotov.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_zagotov.MoveWindow(&rect);
		m_sortam.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_sortam.MoveWindow(&rect);
		m_condition.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_condition.MoveWindow(&rect);
		m_prior.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_prior.MoveWindow(&rect);
		m_derValueCtrl.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_derValueCtrl.MoveWindow(&rect);
		m_derUnit.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_derUnit.MoveWindow(&rect);
		m_valueCtrl.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_valueCtrl.MoveWindow(&rect);
		m_units.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a; ScreenToClient(&rect);m_units.MoveWindow(&rect);
		
		m_okBtn.GetWindowRect(&rect1);
		iOffset= a;
	}

	if(m_sType==_T("delete") || m_sType==_T("eff_type"))// 
	{
		m_pdfSelBtn.ModifyStyle(WS_VISIBLE, 0, 0);
		m_position.ModifyStyle(WS_VISIBLE, 0, 0);
		m_positionNumCtrl.ModifyStyle(WS_VISIBLE, 0, 0);
		m_valueCtrl.ModifyStyle(WS_VISIBLE, 0, 0);
		m_units.ModifyStyle(WS_VISIBLE, 0, 0);
		
		m_id.ModifyStyle(WS_VISIBLE, 0, 0);
		m_name.ModifyStyle(WS_VISIBLE, 0, 0);
		m_ver.ModifyStyle(WS_VISIBLE, 0, 0); 

		m_static1.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static2.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static3.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static4.ModifyStyle(WS_VISIBLE, 0, 0);

		m_static17.ModifyStyle(WS_VISIBLE, 0, 0);
		m_shopEdit.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static18.ModifyStyle(WS_VISIBLE, 0, 0);
		m_customerEdit.ModifyStyle(WS_VISIBLE, 0, 0);
		m_static19.ModifyStyle(WS_VISIBLE, 0, 0);
		m_contextEdit.ModifyStyle(WS_VISIBLE, 0, 0);
		m_selectContextBtn.ModifyStyle(WS_VISIBLE, 0, 0);

		if(m_sType==_T("eff_type"))
		{
			m_static5.ModifyStyle(WS_VISIBLE, 0, 0);
			m_regNum.ModifyStyle(WS_VISIBLE, 0, 0);

			GetDlgItem(IDC_PARAM_RASC)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_PARAM_SHOP)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_STATIC17)->ShowWindow(SW_HIDE);
			GetDlgItem(IDC_STATIC18)->ShowWindow(SW_HIDE);			
		}
		
// 		if(m_sType==_T("delete") || m_sType==_T("eff_type"))// 
		{
			m_static6.ModifyStyle(WS_VISIBLE, 0, 0);
			m_static7.ModifyStyle(WS_VISIBLE, 0, 0);
			m_static14.ModifyStyle(WS_VISIBLE, 0, 0);
		}
		
		m_static4.GetWindowRect(&rect1);
		m_static8.GetWindowRect(&rect2);
		
		a= rect2.top - rect1.top; 
		
		rect2.top-=a;
		rect2.bottom-=a;
		ScreenToClient(&rect2);
		m_static8.MoveWindow(&rect2);
		
		m_effNone.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_effNone.MoveWindow(&rect);
		
		m_effSN.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_effSN.MoveWindow(&rect);
		
		m_effDate.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_effDate.MoveWindow(&rect);
		
		m_dateEndSel.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_dateEndSel.MoveWindow(&rect);

		m_snEndSel.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_snEndSel.MoveWindow(&rect);

		m_dateStartCtrl.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_dateStartCtrl.MoveWindow(&rect);

		m_dateEndCtrl.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_dateEndCtrl.MoveWindow(&rect);

		m_timeStartCtrl.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_timeStartCtrl.MoveWindow(&rect);

		m_timeEndCtrl.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_timeEndCtrl.MoveWindow(&rect);

		m_snStart.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_snStart.MoveWindow(&rect);

		m_snEnd.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
		ScreenToClient(&rect);
		m_snEnd.MoveWindow(&rect);

		if(m_sType==_T("delete"))
		{
			m_static5.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
			ScreenToClient(&rect);
			m_static5.MoveWindow(&rect);
			
			m_regNum.GetWindowRect(&rect);rect.top-=a;rect.bottom-=a;
			ScreenToClient(&rect);
			m_regNum.MoveWindow(&rect);
			
			m_static6.GetWindowRect(&rect1);
			SetWindowText( APL_T("    "));
		}
		else if(m_sType==_T("eff_type"))
		{
			m_static5.GetWindowRect(&rect1);
			SetWindowText( APL_T("   "));
		}
		iOffset= a;
	}
	
	m_okBtn.GetWindowRect(&rect);
	b= iOffset + rect.top - rect1.top; 
	rect.top-=b;rect.bottom-=b;
	ScreenToClient(&rect);
	m_okBtn.MoveWindow(&rect);
	
	m_cancelBtn.GetWindowRect(&rect);rect.top-=b;rect.bottom-=b;
	ScreenToClient(&rect);
	m_cancelBtn.MoveWindow(&rect);
	
	GetWindowRect(&rect);
	rect.bottom-=b;
	SetWindowPos(&wndTop, rect.left, rect.top, 
		rect.right-rect.left, rect.bottom-rect.top, NULL);
}

void CChangeParamDlg::OnParamSelect() 
{
	UpdateData();

	CaplInstance*  inst= m_api->m_change_mgr.SelectInstance(APL_MODE_SELECT_PDF, 
		 APL_T("  "));
	if(inst)
	{
		if(inst)
		{
			CString sState;
			m_api->m_data.GetAttr(inst, m_api->m_prd_mgr.a_apl_pdf_state, sState);	
			if(sState==_T("canceled"))
			{
				int iVal;
				m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\    "), iVal, 0);

				if(0==iVal)
				{
					AfxMessageBox(APL_T("    !"),MB_ICONSTOP|MB_OK);
					return; 
				}
				else
				{
					if(IDYES!=AfxMessageBox(APL_T("    ! ?"),MB_ICONSTOP|MB_YESNO)) return; 
				}
			}
		}

		if(!m_api->m_classifier_mgr.CheckItemInClassifierByOption(inst,APL_NO_T("\\     "),true))return; 

		m_newPdf= inst;
		apidata.GetAttr(m_newPdf, m_api->m_prd_mgr.a_pdf_prd, inst);
		if(inst)
		{
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_id, m_sId);
			apidata.GetAttr(inst, m_api->m_prd_mgr.a_prd_name, m_sName);
		}
		apidata.GetAttr(m_newPdf, m_api->m_prd_mgr.a_pdf_id, m_sVer);

		ResetEdIzm();
	}

	UpdateData(FALSE);	
}

void CChangeParamDlg::OnOK() 
{
	if(!UpdateData()) return;

	if(m_sType==_T("add"))
	{
		if(1==m_mode)
		{
			CaplAttrValue find_value[2];
			find_value[0].attr= m_api->m_prd_mgr.a_make_from_ranking;
			find_value[0].value.Set(m_iPrior);
			find_value[1].attr= m_api->m_prd_mgr.a_pdr_r_ting;
			find_value[1].value.Set(m_upLevelPdf);

			if(!m_api->m_data.NET_TestUniqueAttrValues(m_api->m_prd_mgr.e_make_from, 
				0, 2, &find_value[0], false))
			{
				MessageBox( APL_T("    ."),  APL_T(" "), MB_OK|MB_ICONERROR);
				return;
			}
		}
		if(!m_newPdf) 
		{		
			if(1==m_mode)
				MessageBox( APL_T("   "),  APL_T(" "), MB_OK|MB_ICONERROR);
			else if(0==m_mode)
				MessageBox( APL_T("  ,      ."),  
				APL_T(" "), MB_OK|MB_ICONERROR);
			return;
		}
		if(!m_iValue)
		{
			if(1==m_mode)
			{
				MessageBox( APL_T("    ."),  APL_T(" "), MB_OK|MB_ICONERROR);
				return;
			}
			else if(0==m_mode)
			{
				if(IDYES!=MessageBox( APL_T("       !\n\n  0 ?"),  APL_T(" "), MB_YESNO|MB_ICONERROR))return;
			}
		}
	}
	else if(m_sType==_T("change"))
	{
		if(!m_newPdf) 
		{

			MessageBox( APL_T("  ,      ."),  APL_T(" "), MB_OK|MB_ICONERROR);
			return;
		}
		if(!m_iValue)
		{			
			if(IDYES!=MessageBox( APL_T("       !\n\n  0 ?"),  APL_T(" "), MB_YESNO|MB_ICONERROR))return;
		}
	}
	
	COleDateTime odt;
	if(m_effType==0)
	{
		m_sEffType= _T("none"); m_sStart= _T(""); m_sEnd= _T("");
	}
	else if (m_effType==1)
	{
		m_sEffType= _T("dated");

		odt.SetDateTime(m_dateStart.GetYear(), m_dateStart.GetMonth(), m_dateStart.GetDay(),
			m_timeStart.GetHour(), m_timeStart.GetMinute(), m_timeStart.GetSecond());
		aplDate2String(odt, m_sStart);

		if(m_bDateEndSel)
		{
			odt.SetDateTime(m_dateEnd.GetYear(), m_dateEnd.GetMonth(), m_dateEnd.GetDay(),
				m_timeEnd.GetHour(), m_timeEnd.GetMinute(), m_timeEnd.GetSecond());
			aplDate2String(odt, m_sEnd);
		}
		else m_sEnd= _T("");
	}
	else if (m_effType==2)
	{
		m_sEffType= _T("numbered");
		m_sStart= m_sSNStart;
		if(m_dSNEndSel)	m_sEnd= m_sSNEnd;
		else m_sEnd= _T("");	
		if (m_api->m_prd_mgr.funcCompareSN != NULL)
		{
			if (m_api && m_api->m_prd_mgr.funcCompareSN(m_sStart, m_sEnd) == 1)
			{
				AfxMessageBox( APL_T("        !"), MB_OK | MB_ICONERROR);
				return;
			}
		}
	}
	
	if(-1!=m_iUnits)
		m_unitInst= (CaplInstance*)m_units.GetItemData(m_iUnits);
	else 
		m_unitInst= NULL;
	
	if(-1!=m_iDerUnit)
		m_derUnitInst= (CaplInstance*)m_derUnit.GetItemData(m_iDerUnit);
	else 
		m_derUnitInst= NULL;
	
	if(-1!=m_iSortam)
		m_assortment= (CaplInstance*)m_sortam.GetItemData(m_iSortam);
	else
		m_assortment= NULL;

	CString sBuf;
	CaplInstance* cTestInst;
	double dTestVal;
	bool bModyfied= false;
	if(m_psc)
	{
		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_id, sBuf);
		bModyfied|= (sBuf!=m_sRegNum);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_chng_item_id, m_sRegNum);
		
		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_name, sBuf);
		bModyfied|= (sBuf!=m_sPdrName);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_chng_item_name, m_sPdrName);

		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_dscr, sBuf);
		bModyfied|= (sBuf!=m_sPdrDscr);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_chng_item_dscr, m_sPdrDscr);

		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_changing_product, cTestInst);
		bModyfied|= (cTestInst!=m_newPdf);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_changing_product, m_newPdf);
		
		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_unit, cTestInst);
		bModyfied|= (cTestInst!=m_unitInst);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_unit, m_unitInst);

		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_value, dTestVal);
		bModyfied|= (dTestVal!=m_iValue);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_value, m_iValue);
		
		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_position, sBuf);
		bModyfied|= (sBuf!=m_sPosition);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_position, m_sPosition);

		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_position_num, sBuf);
		bModyfied|= (sBuf!=m_sPositionNum);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_position_num, m_sPositionNum);

		apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_eff_type, sBuf);
		bModyfied|= (sBuf!=m_sEffType);
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_eff_type, m_sEffType);

		bModyfied|=m_bContextsChanged;
		if(m_bContextsChanged)
		apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_frames_of_reference, m_contexts);

		if(m_sEffType==_T("dated"))
		{
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_start_date, sBuf);
			bModyfied|= (sBuf!=m_sStart);
			apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_start_date, m_sStart);

			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_end_date, sBuf);
			bModyfied|= (sBuf!=m_sEnd);
			apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_end_date, m_sEnd);
		}
		else if(m_sEffType==_T("numbered"))
		{
			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_start_num, sBuf);
			bModyfied|= (sBuf!=m_sStart);
			apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_start_num, m_sStart);

			apidata.GetAttr(m_psc, m_api->m_change_mgr.a_psc_end_num, sBuf);
			bModyfied|= (sBuf!=m_sEnd);
			apidata.PutAttr(m_psc, m_api->m_change_mgr.a_psc_end_num, m_sEnd);
		}

		if(m_api->m_data.IsKindOf(m_psc, m_api->m_change_mgr.e_mat))
		{
			m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_assort, m_assortment);
			m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_der_unit, m_derUnitInst);
			m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_der_value, m_iDerValue);
			m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_renking, m_iPrior);
			m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_requir, m_sCondition);
			m_api->m_data.PutAttr(m_psc, m_api->m_change_mgr.a_mat_size, m_sZagotov);
		}

		if(bModyfied)
		{
			m_api->m_data.GetAttr(m_psc, m_api->m_change_mgr.a_chng_item_of_chng, cTestInst);
			if(cTestInst)
				m_api->m_data.PutAttr(cTestInst, m_api->m_change_mgr.a_chng_is_modify, bModyfied);
		}
	}
	else if(m_pscInfo)
	{
		m_pscInfo->m_sId= m_sRegNum;
		m_pscInfo->m_sName= m_sPdrName;
		m_pscInfo->m_sDscr= m_sPdrDscr;
		m_pscInfo->m_pdf= m_newPdf;
		m_pscInfo->m_unit= m_unitInst;
		m_pscInfo->m_value= m_iValue;
		m_pscInfo->m_der_unit= m_derUnitInst;
		m_pscInfo->m_der_value= m_iDerValue;
		m_pscInfo->m_sPosition= m_sPosition;
		m_pscInfo->m_sPositionNum= m_sPositionNum;
		m_pscInfo->m_sEffType= m_sEffType;
		m_pscInfo->m_sStartCond= m_sStart;
		m_pscInfo->m_sEndCond= m_sEnd;
		m_pscInfo->m_sort= m_assortment;
		m_pscInfo->m_prior= m_iPrior;
		m_pscInfo->m_razmer= m_sZagotov;
		m_pscInfo->m_tehTreb= m_sCondition;
		
		m_pscInfo->m_contexts.Clear();
		m_pscInfo->m_contexts.Append(m_contexts);
	}

	if(m_sType==_T("eff_type") && m_change!=NULL)
	{
		bModyfied= false;
		apidata.GetAttr(m_change, m_api->m_change_mgr.a_chng_eff_type, sBuf);
		bModyfied|= (sBuf!=m_sEffType);
		apidata.PutAttr(m_change, m_api->m_change_mgr.a_chng_eff_type, m_sEffType);
		apidata.GetAttr(m_change, m_api->m_change_mgr.a_chng_start_num, sBuf);
		bModyfied|= (sBuf!=m_sStart);
		apidata.PutAttr(m_change, m_api->m_change_mgr.a_chng_start_num, m_sStart);
		apidata.GetAttr(m_change, m_api->m_change_mgr.a_chng_end_num, sBuf);
		bModyfied|= (sBuf!=m_sEnd);
		apidata.PutAttr(m_change, m_api->m_change_mgr.a_chng_end_num, m_sEnd);
		if(bModyfied)
			m_api->m_data.PutAttr(m_change, m_api->m_change_mgr.a_chng_is_modify, bModyfied);
	}
	
	if(bModyfied) m_api->SaveChanges();

	CaplTranslateDialog::OnOK();
}

void CChangeParamDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CaplTranslateDialog::OnCancel();
}

void CChangeParamDlg::OnParamEffNo() 
{
	UpdateData();
	m_timeEndCtrl.EnableWindow(FALSE);
	m_timeStartCtrl.EnableWindow(FALSE);
	m_dateEndSel.EnableWindow(FALSE);
	m_dateEndCtrl.EnableWindow(FALSE);
	m_dateStartCtrl.EnableWindow(FALSE);
	
	m_snEndSel.EnableWindow(FALSE);
	m_snEnd.EnableWindow(FALSE);
	m_snStart.EnableWindow(FALSE);	
}

void CChangeParamDlg::OnParamEffDate() 
{
	UpdateData();
	m_timeStartCtrl.EnableWindow();
	m_dateStartCtrl.EnableWindow();
	m_dateEndSel.EnableWindow();
	
	if(m_bDateEndSel)
	{
		m_timeEndCtrl.EnableWindow();
		m_dateEndCtrl.EnableWindow();
	}

	m_snEndSel.EnableWindow(FALSE);
	m_snEnd.EnableWindow(FALSE);
	m_snStart.EnableWindow(FALSE);
}

void CChangeParamDlg::OnParamEffSN() 
{
	UpdateData();
	
	m_timeEndCtrl.EnableWindow(FALSE);
	m_timeStartCtrl.EnableWindow(FALSE);
	m_dateEndSel.EnableWindow(FALSE);
	m_dateEndCtrl.EnableWindow(FALSE);
	m_dateStartCtrl.EnableWindow(FALSE);
	
	m_snStart.EnableWindow();
	m_snEndSel.EnableWindow();
	
	if(m_dSNEndSel)
		m_snEnd.EnableWindow();	
}

void CChangeParamDlg::OnParamSnEndSelect() 
{
	UpdateData();
	if(m_dSNEndSel)
		m_snEnd.EnableWindow();
	else
		m_snEnd.EnableWindow(FALSE);
}

void CChangeParamDlg::OnParamDateEndSelect() 
{
	UpdateData();
	if(m_bDateEndSel)
	{
		m_dateEndCtrl.EnableWindow();
		m_timeEndCtrl.EnableWindow();
	}
	else
	{
		m_dateEndCtrl.EnableWindow(FALSE);
		m_timeEndCtrl.EnableWindow(FALSE);
	}	
}

bool CChangeParamDlg::SetEffectivity(CString sType, CString sStart, CString sEnd)
{
	if(sType==_T("none"))
	{
		m_effType= 0;
		
		m_timeStartCtrl.EnableWindow(FALSE);
		m_dateStartCtrl.EnableWindow(FALSE);
		m_dateEndSel.EnableWindow(FALSE);
		m_timeEndCtrl.EnableWindow(FALSE);
		m_dateEndCtrl.EnableWindow(FALSE);
		
		m_snStart.EnableWindow(FALSE);
		m_snEndSel.EnableWindow(FALSE);
		m_snEnd.EnableWindow(FALSE);
	}
	else if(sType==_T("dated"))
	{
		m_effType= 1;
		aplString2Date(sStart, m_dateStart);
		aplString2Date(sStart, m_timeStart);
		
		m_timeStartCtrl.EnableWindow();
		m_dateStartCtrl.EnableWindow();
		m_dateEndSel.EnableWindow();
		
		if(!sEnd.IsEmpty())
		{
			m_bDateEndSel= TRUE;
			aplString2Date(sEnd, m_dateEnd);
			aplString2Date(sEnd, m_timeEnd);
			
			m_dateEndCtrl.EnableWindow();
			m_timeEndCtrl.EnableWindow();
		}
		else
		{
			m_bDateEndSel= FALSE;
			m_dateEnd= COleDateTime::GetCurrentTime();
			m_timeEnd.SetTime(0, 0, 0);										
			m_dateEndCtrl.EnableWindow(FALSE);
			m_timeEndCtrl.EnableWindow(FALSE);
		}
		
		m_snStart.EnableWindow(FALSE);
		m_snEndSel.EnableWindow(FALSE);
		m_snEnd.EnableWindow(FALSE);
	}
	else if(sType==_T("numbered"))
	{
		m_effType= 2;
		m_sSNStart= sStart;
		
		m_snStart.EnableWindow();
		m_snEndSel.EnableWindow();
		
		m_sSNEnd= sEnd;
		
		if(!sEnd.IsEmpty())
		{
			m_dSNEndSel= TRUE;										
			m_snEnd.EnableWindow();
		}
		else
		{
			m_dSNEndSel= FALSE;
			m_snEnd.EnableWindow(FALSE);
		}
		
		m_timeStartCtrl.EnableWindow(FALSE);
		m_dateStartCtrl.EnableWindow(FALSE);
		m_dateEndSel.EnableWindow(FALSE);
		m_timeEndCtrl.EnableWindow(FALSE);
		m_dateEndCtrl.EnableWindow(FALSE);
	}
	
	return true;
}

bool CChangeParamDlg::GetEffectivity(CString &sType, CString &sStart, CString &sEnd)
{
	return true;
}


void CChangeParamDlg::OnBnClickedSelectContButton()
{
	if(m_api->m_prd_mgr.ChangeItemContext(m_contexts))
	{
		CString buf;
		m_api->m_prd_mgr.PrintItemContextInString(m_contexts, buf);
		m_bContextsChanged= true;
		m_contextEdit.SetWindowText(buf);
	}
}
