// ChangedStructItem.cpp : implementation file
//

#include "stdafx.h"
//#include "aplstepmgr.h"
#include "ChangedStructItem.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangeStructItemDlg dialog


CChangeStructItemDlg::CChangeStructItemDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CChangeStructItemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChangeStructItemDlg)
	m_bIsEDProd = FALSE;
	m_bIsINGProd = FALSE;
	m_bSetDateEnd = FALSE;
	m_oleDateBegin = COleDateTime::GetCurrentTime();
	m_oleDateEnd = COleDateTime::GetCurrentTime();
	m_oleTimeBegin = COleDateTime::GetCurrentTime();
	m_oleTimeEnd = COleDateTime::GetCurrentTime();
	m_sIdBegin = _T("");
	m_sIdEnd = _T("");
	m_bSetIdEnd = FALSE;
	m_iEffType = 0;
	m_sId = _T("");
	m_sNewForm = _T("");
	m_sNewId = _T("");
	m_dNewValue = 1.0;
	m_sOldForm = _T("");
	m_sOldId = _T("");
	m_dOldValue = 1.0;
	m_iNewUnit = -1;
	m_iOldUnit = -1;
	m_sOldPosition = _T("");
	m_sNewContext =  APL_T(" ");
	m_sNewPosition = _T("");
	m_sOldContext = _T("");
	//}}AFX_DATA_INIT
	
	m_data= NULL;
	m_chngMgr= NULL;
	m_prdMgr= NULL;
	m_crcMgr= NULL;
	
	m_psc= NULL;

	m_pdrNew= NULL;
	m_pdrOld= NULL;
	m_oldPdf= NULL;
	m_newPdf= NULL;
	m_newStepUnit= NULL;
	
	m_items= NULL;
	m_newItems= NULL;
	m_delItems= NULL;

	m_bProcess= false;
	m_bReadOnly= false;
	m_index= -1;
	
	m_oleTimeBegin.SetTime(0, 0, 0);
	m_oleTimeEnd.SetTime(0, 0, 0);
}


void CChangeStructItemDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangeStructItemDlg)
	DDX_Control(pDX, IDC_CH_ALL_PROD_BUTTON, m_addAllBtn);
	DDX_Control(pDX, IDC_CONTEXT_BUTTON, m_contextBtn);
	DDX_Control(pDX, IDC_CH_NEW_POS, m_newPosition);
	DDX_Control(pDX, IDC_CH_OLD_UNIT_COMBO, m_oldUnit);
	DDX_Control(pDX, IDC_CH_NEW_UNIT_COMBO, m_newUnit);
	DDX_Control(pDX, IDC_CH_OLD_VALUE, m_oldValue);
	DDX_Control(pDX, IDC_CH_OLD_ID, m_oldId);
	DDX_Control(pDX, IDC_CH_OLD_FORM, m_oldForm);
	DDX_Control(pDX, IDC_CH_NEW_VALUE, m_newValue);
	DDX_Control(pDX, IDC_CH_NEW_ID, m_newId);
	DDX_Control(pDX, IDC_CH_NEW_FORM, m_newForm);
	DDX_Control(pDX, IDC_CH_LIST, m_list);
	DDX_Control(pDX, IDC_CH_ID, m_id);
	DDX_Control(pDX, IDC_CH_EFF_NONE_RADIO, m_effNone);
	DDX_Control(pDX, IDC_CH_EFF_ID_RADIO, m_effId);
	DDX_Control(pDX, IDC_CH_EFF_DATE_RADIO, m_effDate);
	DDX_Control(pDX, IDC_CH_EFF_ID_END_CHECK, m_setIdEnd);
	DDX_Control(pDX, IDC_CH_DATE_END_CHECK, m_setDateEnd);
	DDX_Control(pDX, IDC_CH_EFF_ID_END, m_idEnd);
	DDX_Control(pDX, IDC_CH_EFF_ID_BEGIN, m_idBegin);
	DDX_Control(pDX, IDC_CH_EFF_DATE_TIME_END, m_timeEnd);
	DDX_Control(pDX, IDC_CH_EFF_DATE_TIME_BEGIN, m_timeBegin);
	DDX_Control(pDX, IDC_CH_EFF_DATE_DATE_END, m_dateEnd);
	DDX_Control(pDX, IDC_CH_EFF_DATE_DATE_BEGIN, m_dateBegin);
	DDX_Control(pDX, IDC_CH_CHANGING_PROD_CHECK, m_ingProd);
	DDX_Control(pDX, IDC_CH_CHANGED_PROD_CHECK, m_edProd);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_CH_SELECT_PDR_BUTTON, m_selEDBtn);
	DDX_Control(pDX, IDC_CH_SELECT_PDF_BUTTON, m_selINGBtn);
	DDX_Control(pDX, IDC_CH_ADD_PROD_BUTTON, m_addBtn);
	DDX_Check(pDX, IDC_CH_CHANGED_PROD_CHECK, m_bIsEDProd);
	DDX_Check(pDX, IDC_CH_CHANGING_PROD_CHECK, m_bIsINGProd);
	DDX_Check(pDX, IDC_CH_DATE_END_CHECK, m_bSetDateEnd);
	DDX_DateTimeCtrl(pDX, IDC_CH_EFF_DATE_DATE_BEGIN, m_oleDateBegin);
	DDX_DateTimeCtrl(pDX, IDC_CH_EFF_DATE_DATE_END, m_oleDateEnd);
	DDX_DateTimeCtrl(pDX, IDC_CH_EFF_DATE_TIME_BEGIN, m_oleTimeBegin);
	DDX_DateTimeCtrl(pDX, IDC_CH_EFF_DATE_TIME_END, m_oleTimeEnd);
	DDX_Text(pDX, IDC_CH_EFF_ID_BEGIN, m_sIdBegin);
	DDX_Text(pDX, IDC_CH_EFF_ID_END, m_sIdEnd);
	DDX_Check(pDX, IDC_CH_EFF_ID_END_CHECK, m_bSetIdEnd);
	DDX_Radio(pDX, IDC_CH_EFF_NONE_RADIO, m_iEffType);
	DDX_Text(pDX, IDC_CH_ID, m_sId);
	DDX_Text(pDX, IDC_CH_NEW_FORM, m_sNewForm);
	DDX_Text(pDX, IDC_CH_NEW_ID, m_sNewId);
	DDX_Text(pDX, IDC_CH_NEW_VALUE, m_dNewValue);
	DDX_Text(pDX, IDC_CH_OLD_FORM, m_sOldForm);
	DDX_Text(pDX, IDC_CH_OLD_ID, m_sOldId);
	DDX_Text(pDX, IDC_CH_OLD_VALUE, m_dOldValue);
	DDX_CBIndex(pDX, IDC_CH_NEW_UNIT_COMBO, m_iNewUnit);
	DDX_CBIndex(pDX, IDC_CH_OLD_UNIT_COMBO, m_iOldUnit);
	DDX_Text(pDX, IDC_CH_OLD_POS, m_sOldPosition);
	DDX_Text(pDX, IDC_CH_NEW_CONT, m_sNewContext);
	DDX_Text(pDX, IDC_CH_NEW_POS, m_sNewPosition);
	DDX_Text(pDX, IDC_CH_OLD_CONT, m_sOldContext);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CChangeStructItemDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CChangeStructItemDlg)
	ON_NOTIFY(LVN_ITEMCHANGING, IDC_CH_LIST, OnItemchangingChList)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_CH_LIST, OnItemchangedChList)
	ON_BN_CLICKED(IDC_CH_DATE_END_CHECK, OnChDateEndCheck)
	ON_BN_CLICKED(IDC_CH_EFF_ID_END_CHECK, OnChEffIdEndCheck)
	ON_BN_CLICKED(IDC_CH_EFF_NONE_RADIO, OnChEffNoneRadio)
	ON_BN_CLICKED(IDC_CH_EFF_DATE_RADIO, OnChEffDateRadio)
	ON_BN_CLICKED(IDC_CH_EFF_ID_RADIO, OnChEffIdRadio)
	ON_BN_CLICKED(IDC_CH_CHANGED_PROD_CHECK, OnChChangedProdCheck)
	ON_BN_CLICKED(IDC_CH_CHANGING_PROD_CHECK, OnChChangingProdCheck)
	ON_BN_CLICKED(IDC_CH_SELECT_PDF_BUTTON, OnChSelectNewPdfButton)
	ON_BN_CLICKED(IDC_CH_SELECT_PDR_BUTTON, OnChSelectOldPdfButton)
	ON_EN_CHANGE(IDC_CH_ID, OnChangeChId)
	ON_BN_CLICKED(IDC_CH_ADD_PROD_BUTTON, OnChAddProdButton)
	ON_BN_CLICKED(IDC_CONTEXT_BUTTON, OnContextButton)
	ON_BN_CLICKED(IDC_CH_ALL_PROD_BUTTON, OnChAllProdButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangeStructItemDlg message handlers

void CChangeStructItemDlg::OnOK() 
{
	// TODO: Add extra validation here
	if(!UpdateData()) return;
	int i;

	//    
	if(-1!=m_index && m_list.GetCheck(m_index))
	{
		CaplInstance* inst= NULL;
		for( i= 0; i<m_items->GetSize(); i++)
		{
			inst= NULL;
			m_data->GetAttr(m_items->GetAt(i), m_chngMgr->a_psc_changed_product, inst);
			if(inst==m_pdrNew)
			{
				StorePscProperties(m_items->GetAt(i));
				m_data->NET_SaveChanges();
				break;
			}
		}
		if(i==m_items->GetSize())
		{
			for(i= 0; i<m_newItems->GetSize(); i++)
			{
				CPSCItemInfo &info= m_newItems->ElementAt(i);
				if(info.m_pdr==m_pdrNew)
				{
					StorePscProperties(info);
					break;
				}
			}
		}
	}

	CaplTranslateDialog::OnOK();
}

void CChangeStructItemDlg::OnCancel() 
{
	CaplTranslateDialog::OnCancel();
}

BOOL CChangeStructItemDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	m_list.SetImageList(&m_imageList, LVSIL_SMALL);
	
	m_list.SetExtendedStyle(m_list.GetExtendedStyle()|
		LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES|LVS_EX_CHECKBOXES);
	m_list.InsertColumn(0,  APL_T(" "), LVCFMT_LEFT, 600);
	
	m_defInfo.m_sEffType= _T("none");
	m_defInfo.m_sStartCond=_T("");
	m_defInfo.m_sEndCond=_T("");

	m_contextBtn.EnableWindow(FALSE);
#ifdef _DEBUG
	m_addAllBtn.EnableWindow();
#endif

	if(m_data && m_data->IsConnected())
	{
		// ..
		aplExtent ext;
		CString buf, buf1, scht;
		int i;
		m_data->GetEntityExtentBN(_T("step_unit"), ext);

		CaplInstance *sht0=0,*sht1=0;
		for(i=0; i<ext.Size; i++)
		{
			m_crcMgr->GetUnitName(ext[i], buf);
			int k=m_oldUnit.AddString(buf);
			m_newUnit.AddString(buf);
			m_oldUnit.SetItemData(k,(UINT)ext[i]);
			m_newUnit.SetItemData(k,(UINT)ext[i]);
			buf1= buf;
			buf1.MakeLower();
			if( buf1== APL_T("")) { sht0=ext[i]; break; }
			if(buf1.GetLength()>=2)	
			{
				if((buf1[0]==_T(''))&&(buf1[1]==_T(''))) sht1=0;
			}
		}
		if(sht0!=0)
		{
			m_crcMgr->GetUnitName(sht0, scht);
			m_defInfo.m_unit= sht0;
			m_defInfo.m_value= 1;

		}
		else if(sht1!=0)
		{
			m_crcMgr->GetUnitName(sht1, scht);
			m_defInfo.m_unit= sht1;
			m_defInfo.m_value= 1;
		}

		m_iOldUnit= m_oldUnit.SelectString(-1, scht);
		m_iNewUnit= m_newUnit.SelectString(-1, scht);
		
		CaplInstance* inst= NULL;
		if(m_psc)
		{
			RestorePscProperties(m_psc);
			m_data->GetAttr(m_psc, m_chngMgr->a_psc_changed_product, m_pdrNew);			
		}
		if(m_pscInfo.m_pdr)
		{
			RestorePscProperties(m_pscInfo);
			m_pdrNew= m_pscInfo.m_pdr;
		}
		
		CString name;
		UINT ico;
		CaplInstance* pdf= NULL;
		if(m_pdrNew)
		{
			m_edProd.EnableWindow(FALSE);
			m_selEDBtn.EnableWindow(FALSE);
			m_list.EnableWindow(FALSE);

			if(m_data->IsKindOf(m_pdrNew, m_prdMgr->e_pdr))
			{
				CaplLoadData ld(m_data,DEF_SOURCE);
				i=ld.AddQuery(-1,m_pdrNew);
				ld.AddQuery(_T('d'), i, 0, m_prdMgr->a_pdr_r_ted, true);
				ld.AddQuery(_T('d'), i, 0, m_prdMgr->a_pdr_r_ting, true);
				ld.AddQuery(_T('d'), i, 0, m_prdMgr->a_apl_qacu_unit, true);
				ld.AddQuery(_T('d'), i, 0, m_prdMgr->a_apl_qacu_value, true);
				ld.AddQuery(_T('d'), i, 0, m_prdMgr->a_pdr_frames_of_reference, true);
				ld.AddQuery(_T('d'), i, 0, m_prdMgr->a_pdr_id, true);
				ld.LoadEx();
				//-   
				m_data->GetAttr(m_pdrNew, m_prdMgr->a_apl_qacu_value, m_dOldValue);
				m_data->GetAttr(m_pdrNew, m_prdMgr->a_apl_qacu_unit, inst);
				if(inst)
				{
					for(int j= 0; j<m_oldUnit.GetCount(); j++)
					{
						if(inst==(CaplInstance*)m_oldUnit.GetItemData(j))
						{ 
							m_iOldUnit= j;
							break;
						}
					}							
				}
				aplExtent aggr;
				m_data->GetAttr(m_pdrNew, m_prdMgr->a_pdr_frames_of_reference, aggr);
				m_chngMgr->PrintItemContextInString(aggr, m_sOldContext);
				if(m_sOldContext.IsEmpty())
				{
					m_sOldContext=  APL_T(" ");
				}
				m_data->GetAttr(m_pdrNew, m_prdMgr->a_pdr_id, m_sOldPosition);
				
				inst= NULL;
				m_data->GetAttr(m_pdrNew, m_prdMgr->a_pdr_r_ted, inst);
				pdf= NULL;
				if(inst)
				{
					m_oldPdf=inst;
					if(m_oldPdf)
					{
						m_prdMgr->LoadPrdInfo(m_oldPdf);
						m_data->GetAttr(m_oldPdf, m_prdMgr->a_pdf_prd, inst);
						if(inst)
						{
							CString str;
							m_data->GetAttr(inst, m_prdMgr->a_prd_id, m_sOldId);
							m_data->GetAttr(inst, m_prdMgr->a_prd_name, str);
							if(!m_sOldId.IsEmpty())
								m_sOldId+=_T(":");
							m_sOldId+=str;
						}
						m_data->GetAttr(m_oldPdf, m_prdMgr->a_pdf_id, m_sOldForm);
					}
				}

				inst= NULL;
				m_data->GetAttr(m_pdrNew, m_prdMgr->a_pdr_r_ting, inst);
				pdf= NULL;
				if(inst) pdf=inst; 
				m_bIsEDProd= TRUE;
			}
			else if(m_data->IsKindOf(m_pdrNew, m_prdMgr->e_apl_pdf))
			{
				pdf= m_pdrNew;
			}
			
			if(pdf)
			{
				m_prdMgr->LoadPrdInfo(pdf);
				m_data->GetAttr(pdf, m_prdMgr->a_pdf_prd, inst);
				if(inst)
				{
					m_data->GetAttr(inst, m_prdMgr->a_prd_id, name);
					m_data->GetAttr(inst, m_prdMgr->a_prd_name, buf); name+=_T(":")+buf;
				}
				m_data->GetAttr(pdf, m_prdMgr->a_pdf_id, buf); name+=_T(":")+buf;

				ico= ICON_ASSEMBLY;
				m_data->GetAttr(pdf, m_prdMgr->a_apl_pdf_type, buf);
				if(buf==_T("part")) ico= ICON_PART;
				if(buf==_T("material")) ico= ICON_MATERIAL;
			}
		}
		m_bProcess= false;
		if(!name.IsEmpty())
		{
			int n= m_list.GetItemCount();
			m_index= m_list.InsertItem(n, name, ico);
			m_list.SetCheck(m_index);
			m_list.SetItemState(m_index, m_list.GetItemState(m_index,(UINT)-1)|LVIS_FOCUSED|LVIS_SELECTED, (UINT)-1);
			m_list.SetItemData(m_index, (DWORD)m_pdrNew);			
		}
		m_bProcess= true;
		
		if(m_bReadOnly)
		{
			m_id.SetReadOnly();
//			m_basis.SetReadOnly();
//			m_stock.SetReadOnly();
			m_newValue.SetReadOnly();
			m_newUnit.EnableWindow(FALSE);
			m_list.EnableWindow(FALSE);
			
			m_effNone.EnableWindow(FALSE);
			m_effId.EnableWindow(FALSE);
			m_effDate.EnableWindow(FALSE);
			m_setIdEnd.EnableWindow(FALSE);
			m_setDateEnd.EnableWindow(FALSE);
			m_idEnd.SetReadOnly();
			m_idBegin.SetReadOnly();
			m_timeEnd.EnableWindow(FALSE);
			m_timeBegin.EnableWindow(FALSE);
			m_dateEnd.EnableWindow(FALSE);
			m_dateBegin.EnableWindow(FALSE);
			m_ingProd.EnableWindow(FALSE);
			m_edProd.EnableWindow(FALSE);
			m_selEDBtn.EnableWindow(FALSE);
			m_selINGBtn.EnableWindow(FALSE);
			m_okBtn.EnableWindow(FALSE);
			m_addBtn.EnableWindow(FALSE);
			m_newPosition.SetReadOnly();
			m_contextBtn.EnableWindow(FALSE);
		}

		UpdateData(FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChangeStructItemDlg::OnChChangedProdCheck() 
{
	UpdateData();
		
	if(m_bIsEDProd)
	{
		m_selEDBtn.EnableWindow();
	}
	else
	{
		m_oldPdf= NULL;
		m_sOldId=_T("");
		m_sOldForm=_T("");
		m_dOldValue= 1;
		
		m_selEDBtn.EnableWindow(FALSE);
		// ...
		m_list.DeleteAllItems();
		if(m_newPdf)
			m_addBtn.EnableWindow();

		m_index= -1;//  , ???
	}
	UpdateData(FALSE);
}

void CChangeStructItemDlg::OnChChangingProdCheck() 
{
	UpdateData();
	if(m_bIsINGProd)
	{
		m_selINGBtn.EnableWindow();
	}
	else
	{
		m_newPdf= NULL;
		m_sNewId=_T("");
		m_sNewForm=_T("");
		m_dNewValue= 1;
		
		m_selINGBtn.EnableWindow(FALSE);
//		m_list.DeleteAllItems();
		m_addBtn.EnableWindow(FALSE);
		m_newValue.SetReadOnly();
		m_newUnit.EnableWindow(FALSE);		
	}
	UpdateData(FALSE);	
}

void CChangeStructItemDlg::OnChSelectNewPdfButton() 
{
	UpdateData();

	CaplInstance*  inst= m_chngMgr->SelectInstance(APL_MODE_SELECT_PDF, 
		 APL_T("  "));
	if(inst)
	{
		m_newPdf= inst;
		m_prdMgr->LoadPrdInfo(m_newPdf);
		m_data->GetAttr(m_newPdf, m_prdMgr->a_pdf_prd, inst);
		if(inst)
		{
			CString str;
			m_data->GetAttr(inst, m_prdMgr->a_prd_id, m_sNewId);
			m_data->GetAttr(inst, m_prdMgr->a_prd_name, str);
			if(!m_sNewId.IsEmpty())
				m_sNewId+=_T(":");
			m_sNewId+=str;
		}
		m_data->GetAttr(m_newPdf, m_prdMgr->a_pdf_id, m_sNewForm);

		if(!m_oldPdf && !m_list.GetItemCount())
		{
			m_addBtn.EnableWindow();
		}

		m_newValue.SetReadOnly(FALSE);
		m_newPosition.SetReadOnly(FALSE);
		m_newUnit.EnableWindow();
		m_contextBtn.EnableWindow();
	}

	UpdateData(FALSE);
}

void CChangeStructItemDlg::OnChSelectOldPdfButton() 
{
	UpdateData();

	int j;

	CaplInstance*  inst= m_chngMgr->SelectInstance(APL_MODE_SELECT_PDF, 
		 APL_T("  "));
	if(inst)
	{
		m_oldPdf= inst;
		m_index= -1;

		m_prdMgr->LoadPrdInfo(m_oldPdf);
		m_data->GetAttr(m_oldPdf, m_prdMgr->a_pdf_prd, inst);
		if(inst)
		{
			CString str;
			m_data->GetAttr(inst, m_prdMgr->a_prd_id, m_sOldId);
			m_data->GetAttr(inst, m_prdMgr->a_prd_name, str);
			if(!m_sOldId.IsEmpty())
				m_sOldId+=_T(":");
			m_sOldId+=str;
		}
		m_data->GetAttr(m_oldPdf, m_prdMgr->a_pdf_id, m_sOldForm);
		
		m_sOldPosition=_T("");
		m_sOldContext=_T("");
		m_dOldValue= 1;

		UpdateData(FALSE);

		m_addBtn.EnableWindow(FALSE);
		
		m_bProcess= false; //    

		m_prdMgr->WhereUsedProduct(m_oldPdf, m_wuRel, m_wuPdf);
		m_list.DeleteAllItems();
		
		for(int i= 0; i<m_wuPdf.GetSize(); i++)
		{
			CString name, buf;
			int ico= -1;
			
			m_prdMgr->LoadPrdInfo(m_wuPdf[i]);
			m_data->GetAttr(m_wuPdf[i], m_prdMgr->a_pdf_prd, inst);
			
			m_data->GetAttr(inst, m_prdMgr->a_prd_id, buf);
			name= buf;

			m_data->GetAttr(inst, m_prdMgr->a_prd_name, buf);
			if(!name.IsEmpty()) name+=_T(":");
			name+=buf;

			m_data->GetAttr(m_wuPdf[i], m_prdMgr->a_pdf_id, buf);
			if(!name.IsEmpty()) name+=_T(":");
			name+= buf;
			
			if(name.IsEmpty())name= _T("???");
			
			ico= ICON_ASSEMBLY;		
			m_data->GetAttr(m_wuPdf[i], m_prdMgr->a_apl_pdf_type, buf);
			if(buf==_T("part")) ico= ICON_PART;
			if(buf==_T("material")) ico= ICON_MATERIAL;

			if(!name.IsEmpty())
			{
				int n= m_list.GetItemCount();
				int m= m_list.InsertItem(n, name, ico);
				
				bool bFine= false;

				for(j= 0; j<m_newItems->GetSize(); j++)
				{
					CPSCItemInfo info= m_newItems->GetAt(j);
					if(info.m_pdr==m_wuRel[i]){bFine= true;break;}
				}
				if(!bFine)
				{
					for(j= 0; j<m_items->GetSize(); j++)
					{
						m_data->GetAttr(m_items->GetAt(j), m_chngMgr->a_psc_changed_product, inst);
						if(-1==m_delItems->Find(m_items->GetAt(j)) && 
							inst==m_wuRel[i])
						{
							bFine= true;;
							break;
						}
					}
				}
				
				if(bFine)
					m_list.SetCheck(m);

				m_list.SetItemData(m, (DWORD)m_wuRel[i]);
			}			
		}
		
		m_bProcess= true;
	}

	UpdateData(FALSE);
}

void CChangeStructItemDlg::OnChAddProdButton() 
{
	UpdateData();

	int j;
	CaplInstance*  pdf= m_chngMgr->SelectInstance(APL_MODE_SELECT_PDF, 
		 APL_T("  "));
	CString buf, name;
	CaplInstance* inst=NULL;
	UINT ico;
	if(pdf)
	{
		m_prdMgr->LoadPrdInfo(pdf);
		m_data->GetAttr(pdf, m_prdMgr->a_pdf_prd, inst);
		if(inst)
		{
			m_data->GetAttr(inst, m_prdMgr->a_prd_id, buf);
			m_data->GetAttr(inst, m_prdMgr->a_prd_name, name); buf+=_T(":")+name;
		}
		m_data->GetAttr(pdf, m_prdMgr->a_pdf_id, name); buf+=_T(":")+name;
		
		ico= ICON_ASSEMBLY;
		m_data->GetAttr(pdf, m_prdMgr->a_apl_pdf_type, name);
		if(name==_T("part")){ico= ICON_PART; return;}
		if(name==_T("material")){ico= ICON_MATERIAL; return;}

		if(buf)
		{
			int n= m_list.GetItemCount();
			m_bProcess= false;
			int m= m_list.InsertItem(n, buf, ico);
			m_bProcess= true;
			m_list.SetItemData(m, (DWORD)pdf);
			for(j= 0; j<m_newItems->GetSize(); j++)
			{
				CPSCItemInfo info= m_newItems->GetAt(j);
				if(info.m_pdr==pdf){m_list.SetCheck(m);break;}
			}
			for(j= 0; j<m_items->GetSize(); j++)
			{
				m_data->GetAttr(m_items->GetAt(j), m_chngMgr->a_psc_changed_product, inst);
				if(-1==m_delItems->Find(m_items->GetAt(j)) && 
					inst==pdf)
				{
					m_list.SetCheck(m);
					break;
				}
			}		
		}
		
		m_addBtn.EnableWindow(FALSE);

		UpdateData(FALSE);
	}
}

void CChangeStructItemDlg::OnItemchangingChList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CChangeStructItemDlg::OnItemchangedChList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	if(m_bProcess)
	{
		UpdateData();
		
		int n= m_list.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
		CaplInstance*inst1= NULL;
		
		if(-1!=n)
		{
			m_pdrNew= (CaplInstance*)m_list.GetItemData(pNMListView->iItem); // 
			if(-1!=m_index)//
				m_pdrOld= (CaplInstance*)m_list.GetItemData(m_index);
		}
		else
		{
			if(-1!=m_index)
			{
				m_pdrOld= (CaplInstance*)m_list.GetItemData(m_index);
			}
		}

		CString cond1, cond2, buf, buf1;
		COleDateTime odt;
		
		bool bChange= false, bNew= true;
//		double r;
		int iCase= -1; //  :
		/*
			1 - checked
			2 - unchecked
			3 - selected && focused
		*/
	
		if(pNMListView->uNewState==0x2000) //
		{
			bChange= true;
			iCase= 1;
		}
		else if(pNMListView->uNewState==0x1000) //
		{
			bChange= true;
			iCase= 2;
		}
		else if(pNMListView->uNewState==0x0003) //
		{
			bChange= true;
			iCase= 3;
		}
		
		if(bChange)
		{
			int i;
			CaplInstance* inst;
			CPSCItemInfo info;

			switch(iCase)
			{
				case 1:
					for(i= 0; i<m_delItems->GetSize(); i++)//  
					{
						inst= NULL;
						m_chngMgr->LoadItemInfo(m_delItems->GetAt(i));
						m_data->GetAttr(m_delItems->GetAt(i), m_chngMgr->a_psc_changed_product, inst);
						if(inst==m_pdrNew)
						{
							bNew= false;
							if(n==pNMListView->iItem)//  
							{
								RestorePscProperties(m_delItems->GetAt(i));
							}

							m_delItems->Remove(i);//   
							break;
						}
					}
					if(bNew)// 
					{				
						info.m_sId= m_defInfo.m_sId;
						info.m_sBasis= m_defInfo.m_sBasis;
						info.m_sStock= m_defInfo.m_sStock;

						info.m_pdr=(CaplInstance*)m_list.GetItemData(pNMListView->iItem);
						info.m_pdf= m_newPdf;
						info.m_sEffType= m_defInfo.m_sEffType;
						info.m_sStartCond= m_defInfo.m_sStartCond;
						info.m_sEndCond= m_defInfo.m_sEndCond;

						info.m_unit= NULL;
						info.m_value= 0;

						m_newItems->Add(info);
						if(n==pNMListView->iItem)//  
						{
							m_dNewValue= m_dOldValue;
							m_iNewUnit= m_iOldUnit;
						}
/*						m_list.SetItemState(pNMListView->iItem, 
							m_list.GetItemState(pNMListView->iItem,(UINT)-1)|
							LVIS_FOCUSED|LVIS_SELECTED, (UINT)-1);*/
					}
					break;
				case 2:
					if(IDYES==MessageBox( APL_T("     ?"), 
						 APL_T(" "), MB_ICONQUESTION|MB_YESNO))
					{
						for(i= 0; i<m_items->GetSize(); i++)
						{
							inst= NULL;
							m_chngMgr->LoadItemInfo(m_items->GetAt(i));
							m_data->GetAttr(m_items->GetAt(i), m_chngMgr->a_psc_changed_product, inst);
							if(m_pdrNew==inst)//    
							{
								m_delItems->Add(m_items->GetAt(i));
								break;
							}
						}
						if(i==m_items->GetSize())
						{
							for(i= 0; i<m_newItems->GetSize(); i++)
							{
								if(m_pdrNew==m_newItems->GetAt(i).m_pdr)
								{
									m_newItems->RemoveAt(i);
									break;
								}
							}
						}
					}
					else
					{
						m_bProcess= false;
						m_list.SetCheck(pNMListView->iItem);
						m_bProcess= true;
					}
					break;
				case 3:
					//apl_qacu
					if(m_data->IsKindOf(m_pdrNew, m_prdMgr->e_pdr))
					{
						//  
						m_data->GetAttr(m_pdrNew, m_prdMgr->a_pdr_id, m_sOldPosition);
						m_data->GetAttr(m_pdrNew, m_prdMgr->a_apl_qacu_value, m_dOldValue);
						m_data->GetAttr(m_pdrNew, m_prdMgr->a_apl_qacu_unit, inst);
						if(inst)
						{
							for(int j= 0; j<m_oldUnit.GetCount(); j++)
							{
								if(inst==(CaplInstance*)m_oldUnit.GetItemData(j))
								{ 
									m_iOldUnit= j;
									break;
								}
							}							
						}
						aplExtent aggr;
						m_data->GetAttr(m_pdrNew, m_prdMgr->a_pdr_frames_of_reference, aggr);
						m_chngMgr->PrintItemContextInString(aggr, m_sOldContext);
						if(m_sOldContext.IsEmpty())
						{
							m_sOldContext=  APL_T(" ");
						}
					}
					else if(m_data->IsKindOf(m_pdrNew, m_prdMgr->e_pdf))
					{
						//  
						m_sOldId= _T("");
						m_sOldForm= _T("");
						m_sOldPosition= _T("");
						m_sOldContext= _T("");
						m_bIsEDProd= FALSE;
						m_selEDBtn.EnableWindow(FALSE);
						m_oldUnit.EnableWindow(FALSE);
						m_oldValue.SetReadOnly();
					}

					// 
					if(-1!=m_index && m_list.GetCheck(m_index))
					{
						for(i= 0; i<m_items->GetSize(); i++)
						{
							inst= NULL;
							m_data->GetAttr(m_items->GetAt(i), m_chngMgr->a_psc_changed_product, inst);
							if(inst==m_pdrOld)
							{
								StorePscProperties(m_items->GetAt(i));
								break;
							}
						}
						if(i==m_items->GetSize())
						{
							for(i= 0; i<m_newItems->GetSize(); i++)
							{
								CPSCItemInfo &info= m_newItems->ElementAt(i);
								if(info.m_pdr==m_pdrOld)
								{									
									StorePscProperties(info);
									break;
								}
							}
						}
					}
					m_sNewPosition= _T("");//  
					// 
					if(-1!=n && m_list.GetCheck(n))
					{
						for(i= 0; i<m_items->GetSize(); i++)
						{
							inst= NULL;
							m_data->GetAttr(m_items->GetAt(i), m_chngMgr->a_psc_changed_product, inst);
							if(inst==m_pdrNew)
							{
								RestorePscProperties(m_items->GetAt(i));
								break;
							}
						}
						if(i==m_items->GetSize())
						{
							for(i= 0; i<m_newItems->GetSize(); i++)
							{
								CPSCItemInfo &info= m_newItems->ElementAt(i);
								if(info.m_pdr==m_pdrNew)
								{
									RestorePscProperties(info);
									break;
								}
							}
						}
					}
					
					m_index= n;
					break;
			}
		}
	}

	UpdateData(FALSE);
	*pResult = 0;
}

void CChangeStructItemDlg::OnChDateEndCheck() 
{
	UpdateData();
	if(m_bSetDateEnd)
	{
		m_dateEnd.EnableWindow();
		m_timeEnd.EnableWindow();
	}
	else
	{
		m_dateEnd.EnableWindow(FALSE);
		m_timeEnd.EnableWindow(FALSE);
	}
}

void CChangeStructItemDlg::OnChEffIdEndCheck() 
{
	UpdateData();	
	if(m_bSetIdEnd)
		m_idEnd.EnableWindow();
	else
		m_idEnd.EnableWindow(FALSE);
}

void CChangeStructItemDlg::OnChEffNoneRadio() 
{
	UpdateData();
	
	m_timeEnd.EnableWindow(FALSE);
	m_timeBegin.EnableWindow(FALSE);
	m_setDateEnd.EnableWindow(FALSE);
	m_dateEnd.EnableWindow(FALSE);
	m_dateBegin.EnableWindow(FALSE);
	
	m_setIdEnd.EnableWindow(FALSE);
	m_idEnd.EnableWindow(FALSE);
	m_idBegin.EnableWindow(FALSE);	
}

void CChangeStructItemDlg::OnChEffDateRadio() 
{
	UpdateData();
	m_timeBegin.EnableWindow();
	m_dateBegin.EnableWindow();
	m_setDateEnd.EnableWindow();
	
	if(m_bSetDateEnd)
	{
		m_timeEnd.EnableWindow();
		m_dateEnd.EnableWindow();
	}

	m_setIdEnd.EnableWindow(FALSE);
	m_idEnd.EnableWindow(FALSE);
	m_idBegin.EnableWindow(FALSE);
}

void CChangeStructItemDlg::OnChEffIdRadio() 
{
	UpdateData();

	m_timeEnd.EnableWindow(FALSE);
	m_timeBegin.EnableWindow(FALSE);
	m_setDateEnd.EnableWindow(FALSE);
	m_dateEnd.EnableWindow(FALSE);
	m_dateBegin.EnableWindow(FALSE);
	
	m_idBegin.EnableWindow();
	m_setIdEnd.EnableWindow();
	
	if(m_bSetIdEnd)
		m_idEnd.EnableWindow();	
}

void CChangeStructItemDlg::OnChangeChId() 
{
	m_id.GetWindowText(m_defInfo.m_sId);
}

bool CChangeStructItemDlg::StorePscProperties(CaplInstance *item)
{
	if(item==NULL) return false;
	if(item->GetId()==0) return false;
	if(item->GetType()==0) return false;
	if(!m_data || !m_data->IsConnected()) return false;
	
	CString buf, buf1, cond1, cond2;
	bool bSave= false;
	COleDateTime odt;
	double r;
	CaplInstance *inst= NULL;

	m_data->GetAttr(item, m_chngMgr->a_chng_item_id, buf);
	if(buf!=m_sId){m_data->PutAttr(item, m_chngMgr->a_chng_item_id, m_sId);bSave= true;}
//	m_data->GetAttr(item, m_chngMgr->a_chng_item_basis, buf);
//	if(buf!=m_sBasis){m_data->PutAttr(item, m_chngMgr->a_chng_item_basis, m_sBasis);bSave= true;}
//	m_data->GetAttr(item, m_chngMgr->a_chng_item_stock, buf);
//	if(buf!=m_sStock){m_data->PutAttr(item, m_chngMgr->a_chng_item_stock, m_sStock);bSave= true;}
	m_data->GetAttr(item, m_chngMgr->a_psc_eff_type, buf);
	if(m_iEffType==0)
	{ 
		buf1= _T("none");
		if(buf!=buf1){m_data->PutAttr(item, m_chngMgr->a_psc_eff_type, buf1);bSave= true;}
		cond1= _T("");
		cond2= _T("");
	}
	else if(m_iEffType==1)
	{
		buf1= _T("dated");
		if(buf!=buf1){m_data->PutAttr(item, m_chngMgr->a_psc_eff_type, buf1);bSave= true;}
		odt.SetDateTime(m_oleDateBegin.GetYear(), m_oleDateBegin.GetMonth(), m_oleDateBegin.GetDay(),
			m_oleTimeBegin.GetHour(), m_oleTimeBegin.GetMinute(), m_oleTimeBegin.GetSecond());
		aplDate2String(odt, cond1);
		if(m_bSetDateEnd)
		{
			odt.SetDateTime(m_oleDateEnd.GetYear(), m_oleDateEnd.GetMonth(), m_oleDateEnd.GetDay(),
				m_oleTimeEnd.GetHour(), m_oleTimeEnd.GetMinute(), m_oleTimeEnd.GetSecond());
			aplDate2String(odt, cond2);
		}
		else
			cond2= _T("");
	}
	else if(m_iEffType==2) 
	{
		buf1= _T("numbered");
		if(buf!=buf1){m_data->PutAttr(item, m_chngMgr->a_psc_eff_type, buf1);bSave= true;}
		cond1= m_sIdBegin;
		if(m_bSetIdEnd)
		{
			cond2= m_sIdEnd;
		}
		else
		{
			cond2= _T("");	
		}
	}
	if(buf1==_T("dated"))
	{
		m_data->GetAttr(item, m_chngMgr->a_psc_start_date, buf);
		if(buf!=cond1)
		{
			m_data->PutAttr(item, m_chngMgr->a_psc_start_date, cond1);
			m_data->PutAttr(item, m_chngMgr->a_psc_start_num, _T(""));
			bSave= true;
		}
		m_data->GetAttr(item, m_chngMgr->a_psc_end_date, buf);
		if(buf!=cond2)
		{
			m_data->PutAttr(item, m_chngMgr->a_psc_end_date, cond2);
			m_data->PutAttr(item, m_chngMgr->a_psc_end_num, _T(""));
			bSave= true;
		}
	}
	else if(buf1==_T("numbered"))
	{
		m_data->GetAttr(item, m_chngMgr->a_psc_start_num, buf);
		if(buf!=cond1)
		{
			m_data->PutAttr(item, m_chngMgr->a_psc_start_num, cond1);
			m_data->PutAttr(item, m_chngMgr->a_psc_start_date, _T(""));
			bSave= true;
		}
		m_data->GetAttr(item, m_chngMgr->a_psc_end_num, buf);
		if(buf!=cond2)
		{
			m_data->PutAttr(item, m_chngMgr->a_psc_end_num, cond2);
			m_data->PutAttr(item, m_chngMgr->a_psc_end_date, _T(""));
			bSave= true;
		}
	}
	m_data->GetAttr(item, m_chngMgr->a_psc_changing_product, inst);
	if(inst!=m_newPdf){m_data->PutAttr(item, m_chngMgr->a_psc_changing_product, m_newPdf);bSave= true;}
	m_data->GetAttr(item, m_chngMgr->a_psc_unit, inst);
	if(m_iNewUnit!=-1){m_newStepUnit= (CaplInstance*)m_newUnit.GetItemData(m_iNewUnit);}
	else{m_newStepUnit= NULL;}
	if(inst!=m_newStepUnit){m_data->PutAttr(item, m_chngMgr->a_psc_unit, m_newStepUnit);bSave= true;}
	m_data->GetAttr(item, m_chngMgr->a_psc_value, r);
	if(r!=m_dNewValue){m_data->PutAttr(item, m_chngMgr->a_psc_value, m_dNewValue);bSave= true;}
	m_data->GetAttr(item, m_chngMgr->a_psc_position, buf);
	if(buf!=m_sNewPosition){m_data->PutAttr(item, m_chngMgr->a_psc_position, m_sNewPosition);bSave= true;}
	m_data->PutAttr(item, m_chngMgr->a_psc_frames_of_reference, m_context);bSave= true;
	if(bSave)
		m_data->NET_SaveChanges();

	return true;
}

bool CChangeStructItemDlg::RestorePscProperties(CaplInstance *item)
{
	if(item==NULL) return false;
	if(item->GetId()==0) return false;
	if(item->GetType()==0) return false;
	if(!m_data || !m_data->IsConnected()) return false;
	
	CaplInstance* inst= NULL;
	CString buf;

	m_data->GetAttr(item, m_chngMgr->a_chng_item_id, m_sId);
//	m_data->GetAttr(item, m_chngMgr->a_chng_item_basis, m_sBasis);
//	m_data->GetAttr(item, m_chngMgr->a_chng_item_stock, m_sStock);
	m_data->GetAttr(item, m_chngMgr->a_psc_changing_product, m_newPdf);
	if(m_newPdf)
	{
		m_prdMgr->LoadPrdInfo(m_newPdf);
		m_data->GetAttr(m_newPdf, m_prdMgr->a_pdf_prd, inst);
		if(inst)
		{
			CString str;
			m_data->GetAttr(inst, m_prdMgr->a_prd_id, m_sNewId);
			m_data->GetAttr(inst, m_prdMgr->a_prd_name, str);
			if(!m_sNewId.IsEmpty())
				m_sNewId+=_T(":");
			m_sNewId+=str;
		}
		m_data->GetAttr(m_newPdf, m_prdMgr->a_pdf_id, m_sNewForm);
		
		m_bIsINGProd= TRUE;
		m_selINGBtn.EnableWindow();
		m_newUnit.EnableWindow();
		m_newValue.SetReadOnly(FALSE);
		m_newPosition.SetReadOnly(FALSE);
		m_contextBtn.EnableWindow();
	}
	else
	{
		m_sNewId= _T("");
		m_sNewForm= _T("");
		m_bIsINGProd= FALSE;
		m_selINGBtn.EnableWindow(FALSE);
		m_newUnit.EnableWindow(FALSE);
		m_newValue.SetReadOnly();
		m_newPosition.SetReadOnly();
		m_contextBtn.EnableWindow(FALSE);
	}

	m_data->GetAttr(item, m_chngMgr->a_psc_value, m_dNewValue);
	m_data->GetAttr(item, m_chngMgr->a_psc_unit, m_newStepUnit);
	
	for(int j= 0; j<m_newUnit.GetCount(); j++)
	{
		inst= (CaplInstance*)m_newUnit.GetItemData(j);
		if(inst==m_newStepUnit)
		{ 
			m_iNewUnit= j;
			break;
		}
	}
	
	CString start, end;
	
	m_data->GetAttr(item, m_chngMgr->a_psc_eff_type, buf);
	if(buf==_T("dated"))
	{
		m_data->GetAttr(item, m_chngMgr->a_psc_start_date, start);
		m_data->GetAttr(item, m_chngMgr->a_psc_end_date, end);
	}
	else if(buf==_T("numbered"))
	{
		m_data->GetAttr(item, m_chngMgr->a_psc_start_num, start);
		m_data->GetAttr(item, m_chngMgr->a_psc_end_num, end);
	}
	
	aplExtent aggr;

	m_data->GetAttr(item, m_chngMgr->a_psc_position, m_sNewPosition);
	m_data->GetAttr(item, m_chngMgr->a_psc_frames_of_reference, aggr);
	m_chngMgr->PrintItemContextInString(aggr, m_sNewContext);
	if(m_sNewContext.IsEmpty())
	{
		m_sNewContext=  APL_T(" ");
	}	
	m_context.Clear();
	m_context.Append(aggr);
	
	SetEffectivity(buf, start, end);
	
	return true;
}

bool CChangeStructItemDlg::StorePscProperties(CPSCItemInfo &item)
{
	COleDateTime odt;

	item.m_pdr= (CaplInstance*)m_list.GetItemData(m_index);
	item.m_sId= m_sId;
//	item.m_sBasis= m_sBasis;
//	item.m_sStock= m_sStock;
	item.m_pdf= m_newPdf;
	item.m_value= m_dNewValue;
	if(m_iNewUnit!=-1){m_newStepUnit= (CaplInstance*)m_newUnit.GetItemData(m_iNewUnit);}
	else{m_newStepUnit= NULL;}
	item.m_unit= m_newStepUnit;
	if(m_iEffType==0)
	{
		item.m_sEffType= _T("none");
		item.m_sStartCond= _T("");
		item.m_sEndCond= _T("");
	}
	else if (m_iEffType==1)
	{
		item.m_sEffType= _T("dated");

		odt.SetDateTime(m_oleDateBegin.GetYear(), m_oleDateBegin.GetMonth(), m_oleDateBegin.GetDay(),
			m_oleTimeBegin.GetHour(), m_oleTimeBegin.GetMinute(), m_oleTimeBegin.GetSecond());
		aplDate2String(odt, item.m_sStartCond);

		if(m_bSetDateEnd)
		{
			odt.SetDateTime(m_oleDateEnd.GetYear(), m_oleDateEnd.GetMonth(), m_oleDateEnd.GetDay(),
				m_oleTimeEnd.GetHour(), m_oleTimeEnd.GetMinute(), m_oleTimeEnd.GetSecond());
			aplDate2String(odt, item.m_sEndCond);
		}
		else
		{
			item.m_sEndCond= _T("");
		}
	}
	else if (m_iEffType==2)
	{
		item.m_sEffType= _T("numbered");
		item.m_sStartCond= m_sIdBegin;
		if(m_bSetIdEnd)
		{
			item.m_sEndCond= m_sIdEnd;
		}
		else
		{
			item.m_sEndCond= _T("");	
		}
	}
	
	item.m_sPosition= m_sNewPosition;
	aplExtent ext;
	for(int j= 0; j<m_context.GetSize(); j++)
	{
		ext.Add(m_context[j]);
	}
	item.SetContexts(ext);

	return true;
}

bool CChangeStructItemDlg::RestorePscProperties(CPSCItemInfo &item)
{
	m_sId= item.m_sId;
//	m_sBasis= item.m_sBasis;
//	m_sStock= item.m_sStock;
	m_newPdf= item.m_pdf;
	
	CaplInstance* inst= NULL;

	if(item.m_pdf)
	{
		m_prdMgr->LoadPrdInfo(item.m_pdf);
		m_data->GetAttr(item.m_pdf, m_prdMgr->a_pdf_prd, inst);
		if(inst)
		{
			CString str;
			m_data->GetAttr(inst, m_prdMgr->a_prd_id, m_sNewId);
			m_data->GetAttr(inst, m_prdMgr->a_prd_name, str);
			if(!m_sNewId.IsEmpty())
				m_sNewId+=_T(":");
			m_sNewId+=str;
		}
		m_data->GetAttr(item.m_pdf, m_prdMgr->a_pdf_id, m_sNewForm);									
		
		m_bIsINGProd= TRUE;
		m_selINGBtn.EnableWindow();
		m_newUnit.EnableWindow();
		m_newValue.SetReadOnly(FALSE);
		m_newPosition.SetReadOnly(FALSE);
		m_contextBtn.EnableWindow();
	}
	else
	{
		m_sNewId= _T("");
		m_sNewForm= _T("");
		m_bIsINGProd= FALSE;
		m_selINGBtn.EnableWindow(FALSE);
		m_newUnit.EnableWindow(FALSE);
		m_newValue.SetReadOnly();
		m_newPosition.SetReadOnly();
		m_contextBtn.EnableWindow(FALSE);
	}
	
	if(item.m_value!=0)
	{
		m_dNewValue= item.m_value;
	}
	else
	{
		m_dNewValue= m_dOldValue;
	}

	if(item.m_unit!=0)
	{
		for(int j= 0; j<m_newUnit.GetCount(); j++)
		{
			inst= (CaplInstance*)m_newUnit.GetItemData(j);
			if(inst==item.m_unit)
			{ 
				m_iNewUnit= j;
				break;
			}
		}
	}
	else
	{
		m_iNewUnit= m_iOldUnit;
	}

	m_sNewPosition= item.m_sPosition;
	m_sNewContext= _T("");
	
	m_context.Clear();
	for(int l= 0; l<item.m_contexts.GetSize(); l++)
	{
		m_context.Add(item.m_contexts[l]);
	}
	m_chngMgr->PrintItemContextInString(m_context, m_sNewContext);
	
	if(m_sNewContext.IsEmpty())
	{
		m_sNewContext=  APL_T(" ");
	}

	SetEffectivity(item.m_sEffType, item.m_sStartCond, item.m_sEndCond);

	return true;
}

bool CChangeStructItemDlg::SetEffectivity(CString sType, CString sStart, CString sEnd)
{
	if(sType==_T("none"))
	{
		m_iEffType= 0;
		
		m_timeBegin.EnableWindow(FALSE);
		m_dateBegin.EnableWindow(FALSE);
		m_setDateEnd.EnableWindow(FALSE);
		m_timeEnd.EnableWindow(FALSE);
		m_dateEnd.EnableWindow(FALSE);
		
		m_idBegin.EnableWindow(FALSE);
		m_setIdEnd.EnableWindow(FALSE);
		m_idEnd.EnableWindow(FALSE);
	}
	else if(sType==_T("dated"))
	{
		m_iEffType= 1;
		aplString2Date(sStart, m_oleDateBegin);
		aplString2Date(sStart, m_oleTimeBegin);
		
		m_timeBegin.EnableWindow();
		m_dateBegin.EnableWindow();
		m_setDateEnd.EnableWindow();
		
		if(!sEnd.IsEmpty())
		{
			m_bSetDateEnd= TRUE;
			aplString2Date(sEnd, m_oleDateEnd);
			aplString2Date(sEnd, m_oleTimeEnd);
			
			m_dateEnd.EnableWindow();
			m_timeEnd.EnableWindow();
		}
		else
		{
			m_bSetDateEnd= FALSE;
			m_oleDateEnd= COleDateTime::GetCurrentTime();
			m_oleTimeEnd.SetTime(0, 0, 0);										
			m_dateEnd.EnableWindow(FALSE);
			m_timeEnd.EnableWindow(FALSE);
		}
		
		m_idBegin.EnableWindow(FALSE);
		m_setIdEnd.EnableWindow(FALSE);
		m_idEnd.EnableWindow(FALSE);
	}
	else if(sType==_T("numbered"))
	{
		m_iEffType= 2;
		m_sIdBegin= sStart;
		
		m_idBegin.EnableWindow();
		m_setIdEnd.EnableWindow();
		
		m_sIdEnd= sEnd;
		
		if(!sEnd.IsEmpty())
		{
			m_bSetIdEnd= TRUE;										
			m_idEnd.EnableWindow();
		}
		else
		{
			m_bSetIdEnd= FALSE;
			m_idEnd.EnableWindow(FALSE);
		}
		
		m_timeBegin.EnableWindow(FALSE);
		m_dateBegin.EnableWindow(FALSE);
		m_setDateEnd.EnableWindow(FALSE);
		m_timeEnd.EnableWindow(FALSE);
		m_dateEnd.EnableWindow(FALSE);
	}
	
	return true;
}

bool CChangeStructItemDlg::GetEffectivity(CString &sType, CString &sStart, CString &sEnd)
{
	return true;
}

void CChangeStructItemDlg::OnContextButton() 
{
	UpdateData();

	if(m_chngMgr->ChangeItemContext(m_context))
	{
		m_chngMgr->PrintItemContextInString(m_context, m_sNewContext);
		if(m_sNewContext.IsEmpty())
		{
			m_sNewContext=  APL_T(" ");
		}
		m_defInfo.m_contexts.Clear();
		for(int l= 0; l<m_context.GetSize(); l++)
		{
			m_defInfo.m_contexts.Add(m_context[l]);
		}

		UpdateData(FALSE);
	}
}

void CChangeStructItemDlg::OnChAllProdButton() 
{
	int i, j;
	for(i= 0; i<m_list.GetItemCount(); i++)
	{
		CaplInstance* inst= (CaplInstance*)m_list.GetItemData(i), *inst1= NULL;
		if(!inst || !inst->GetType()) continue;
		
		bool bAdd= true;
		for(j= 0; j<m_newItems->GetSize(); j++)
		{
			CPSCItemInfo info= m_newItems->GetAt(j);
			if(info.m_pdr==inst){bAdd= false; break;}
		}
		if(bAdd)
		{
			for(j= 0; j<m_items->GetSize(); j++)
			{
				if(m_items->GetAt(j)==inst && 
					-1==m_delItems->Find(m_items->GetAt(j)))
				{
					bAdd= false;
					break;
				}
			}
		}
		if(bAdd)
			m_list.SetCheck(i);
	}
}
