#if !defined(AFX_CHARACTERISTICDLG_H__D703F4D7_70EA_42C1_9C9F_404ABAE85917__INCLUDED_)
#define AFX_CHARACTERISTICDLG_H__D703F4D7_70EA_42C1_9C9F_404ABAE85917__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CharacteristicDlg.h : header file
//
#include "resource.h"
#include <apl_gui.h>
#include "ResizableDialog.h" 

#include "aplCharactView.h"
#include "aplApprovalView.h"
#include "aplDocsView.h"
#include "aplAccessView.h"
/////////////////////////////////////////////////////////////////////////////
// CCharacteristicDlg dialog

class CaplInstance;
class CaplNetStepData;

class CCharacteristicDlg : public CResizableDialog
{
// Construction
public:
	CCharacteristicDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CCharacteristicDlg)
	enum { IDD = IDD_CHARACTERYSTIC };
	CButton	m_autoCheckinCtrl;
	CStatic	m_charact_ico;
	CaplButton	m_undo_check_out_ctrl;
	CaplButton	m_check_out_ctrl;
	CaplButton	m_check_in_ctrl;
	CButton	m_sec_charact_btn;
	CEdit	m_charact;
	CButton	m_SelInstBtn;
	CaplButton	m_save_to_file;
	CaplButton	m_top_btn;
	CaplButton	m_bottom_btn;
	CaplButton	m_cancel_btn;
	CSortListCtrl	m_aggr_val;
	CDateTimeCtrl	m_time_ctrl;
	CDateTimeCtrl	m_date_ctrl;
	CEdit	m_str_val_ctrl;
	CStatic	m_st_charact_name;
	CaplButton	m_ok_btn;
	CComboBox	m_type;
	CEdit	m_measure_count;
	CEdit	m_scope;
	CComboBox	m_enum_val_ctrl;
	CStatic	m_stat_min;
	CStatic	m_stat_max;
	CEdit	m_max_dev;
	CEdit	m_min_dev;
	CEdit	m_value_ctrl;
	CStatic	m_stat_value;
	CEdit	m_measure_unit_ctrl;
	CString	m_str_val;
	BOOL	m_auto_checkin;
	CaplTabCtrl	m_Tab;
	CaplButton	m_bPropsProps;
	CaplButton	m_bPropsDel;
	CaplButton	m_bPropsAdd;
	//}}AFX_DATA

	CString m_mode;
	bool m_ReadOnly;
	bool m_no_del_val_if_selchange;
	bool m_locked_type;

	CaplAPI *m_api;

	CaplInstance *m_item;
	CaplInstance *m_value;
	CaplInstance *m_unit;
	CaplInstance *m_new_type;

	CaplInstance *m_base_val;
	CaplInstance *m_cur_ref_val;
	CaplInstance *m_charactteristic;

	CStringArray m_sel_charact_names;

	CString			m_csAccessString;

	BOOL			SetAnchors(void);
	BOOL			InitViews(void);
	void			ChangeViewBtnsState(BOOL bDis,BOOL bHide);
	void			GetAccessString(void);


protected:
	CaplNetStepData *m_data;
	CaplCharacteristicManager *m_charact_mgr;

	CBitmap m_logo_bmp,m_name_bmp, m_ico_bmp;
	void PrintAggrInList(CaplInstance *val);
	bool CreateTableHeader(CaplInstance *unit);
	void PrintTableInList(CaplInstance *val);
	CaplMap m_ColumnListMap;
	CaplMap m_val_map;

	bool PointToVal(CPoint *point, int &i,int &j,CaplInstance **val, CaplInstance **unit,int &type);
	bool EditVal(int i,int j,CaplInstance **value, CaplInstance *unit);
	bool m_creation_mode;	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCharacteristicDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;


	bool CheckIn();
	bool m_changed_aggr;
	CaplInstance* m_old_value;//     
	void HideValue();
	void SetFromInst(CaplInstance *val);
	void SetCharacterystic(CaplInstance *new_charact);
	void DisableChangeCharact();
	void CreateTempVal();
	void SetReadOnlyItems();
	bool SaveChanges(bool bSaveChanges);
	// Generated message map functions
	//{{AFX_MSG(CCharacteristicDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnStCharactName();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnDblclkAggrVal(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTop();
	afx_msg void OnBottom();
	afx_msg void OnSaveToFile();
	afx_msg void OnSelectInstance();
	afx_msg void OnSelCharact();
	afx_msg void OnCheckOut();
	afx_msg void OnCheckIn();
	afx_msg void OnUndoCheckOut();
	afx_msg void OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnBPropsAdd();
	afx_msg void OnBPropsDel();
	afx_msg void OnBPropsProps();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHARACTERISTICDLG_H__D703F4D7_70EA_42C1_9C9F_404ABAE85917__INCLUDED_)
