// CheckInDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"

#include "CheckInDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCheckInDlg dialog


CCheckInDlg::CCheckInDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CCheckInDlg::IDD, pParent)
{
	m_title= APL_T("  ");
	m_checkin_question= APL_T("  ?");
	m_recursive=0;
	m_make_active=0;
	m_recursive_enabled=true;
	m_make_active_enabled=true;
	m_no_rigths_to_make_active=false;
	//{{AFX_DATA_INIT(CCheckInDlg)
	//}}AFX_DATA_INIT
}


void CCheckInDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCheckInDlg)
	DDX_Control(pDX, IDC_MAKE_ACTIVE, m_make_active_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_CHECKIN_QUESTION, m_question_ctrl);
	DDX_Control(pDX, IDC_RECURSIVE, m_recursive_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCheckInDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CCheckInDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckInDlg message handlers

void CCheckInDlg::OnOK() 
{
	if(!UpdateData()) return;

	m_recursive=m_recursive_ctrl.GetCheck();
	m_make_active=m_make_active_ctrl.GetCheck();
	CaplTranslateDialog::OnOK();
}

BOOL CCheckInDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	SetWindowText(m_title);
	m_question_ctrl.SetWindowText(m_checkin_question);
	m_recursive_ctrl.SetCheck(m_recursive);
	m_make_active_ctrl.SetCheck(m_make_active);
	if(!m_recursive_enabled) m_recursive_ctrl.EnableWindow(false);
	if(!m_make_active_enabled) m_make_active_ctrl.ShowWindow(SW_HIDE);
	if(m_no_rigths_to_make_active) 
	{
		m_make_active_ctrl.EnableWindow(FALSE);
		m_make_active_ctrl.SetWindowText( APL_T("   (  )"));
	}
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
