// ClassifierChildFrame.cpp : implementation file
//

#include "stdafx.h"
#include "ClassifierChildFrame.h"
#include "ClassifierTreeFrame.h"
#include "ClassifierTableFrame.h"
#include "ClassifierTreeView.h"
#include "ClassifierTableItemsView.h"
#include "PictureView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClassifierChildFrame

IMPLEMENT_DYNCREATE(CClassifierChildFrame, CMDIChildWnd)

CClassifierChildFrame::CClassifierChildFrame()
{
}

CClassifierChildFrame::~CClassifierChildFrame()
{
}


BEGIN_MESSAGE_MAP(CClassifierChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CClassifierChildFrame)
	ON_WM_CREATE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClassifierChildFrame message handlers

BOOL CClassifierChildFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	m_wndHSplitter.CreateStatic(this, 1, 2);
	m_wndVSplitter.CreateStatic(&m_wndHSplitter, 2, 1, WS_CHILD|WS_VISIBLE, m_wndHSplitter.IdFromRowCol(0,0));
	m_wndVSplitter.CreateView(0, 0, RUNTIME_CLASS(CClassifierTreeFrame), CSize(200,300), pContext);
	m_wndVSplitter.CreateView(1, 0, RUNTIME_CLASS(CPictureView), CSize(200,150), pContext);
	m_wndHSplitter.CreateView(0, 1, RUNTIME_CLASS(CClassifierTableFrame), CSize(200,200), pContext);
	
	return TRUE;
}

int CClassifierChildFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	CaplSetResourceHandle setres(module_inst);

	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
	{
		return -1;
	}

	SetWindowText( APL_T(""));
	
	return 0;
}

bool CClassifierChildFrame::Init(CaplAPI *api, CaplInstance* inst)
{
	((CClassifierTreeView*)((CFrameWnd*)(m_wndVSplitter.GetPane(0, 0)))->GetActiveView())->m_api = api;
	
	CClassifierTableItemsView *pTableView =0;

	if(m_wndHSplitter.GetColumnCount()>1)
	{
		pTableView = ((CClassifierTableItemsView*)((CFrameWnd*)(m_wndHSplitter.GetPane(0, 1)))->GetActiveView());
		if(pTableView)
		{
			pTableView->m_api = api;
			pTableView->m_Mode = APL_CLASSIFIER_EDITOR;
		}
	}
	((CClassifierTreeView*)((CFrameWnd*)(m_wndVSplitter.GetPane(0, 0)))->GetActiveView())->m_BaseSystems.Add(inst);
	((CClassifierTreeView*)((CFrameWnd*)(m_wndVSplitter.GetPane(0, 0)))->GetActiveView())->m_pTableView = pTableView;
	
	if(m_wndVSplitter.GetRowCount()>1)
	{
		((CClassifierTreeView*)((CFrameWnd*)(m_wndVSplitter.GetPane(0, 0)))->GetActiveView())->m_pPictureView = (CPictureView*)m_wndVSplitter.GetPane(1, 0);
	}
	
	((CClassifierTreeFrame*)(m_wndVSplitter.GetPane(0, 0)))->SetMode(APL_CLASSIFIER_EDITOR);

	if(m_wndHSplitter.GetColumnCount()>1)
	{
		((CClassifierTableFrame*)(m_wndHSplitter.GetPane(0, 1)))->SetMode(APL_CLASSIFIER_EDITOR);
	}

	((CFrameWnd*)(m_wndVSplitter.GetPane(0, 0)))->GetActiveView()->SendMessage(WM_INITIALUPDATE);

	if(m_wndVSplitter.GetRowCount()>1)
	{
		((CView*)(m_wndVSplitter.GetPane(1, 0)))->SendMessage(WM_INITIALUPDATE);
	}

	if(m_wndHSplitter.GetColumnCount()>1)
	{
		((CFrameWnd*)(m_wndHSplitter.GetPane(0, 1)))->GetActiveView()->SendMessage(WM_INITIALUPDATE);
	}

	int cx=0;
	int dy = 0;
	dy = 11;

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	cx=200;
	if(0!=app)	cx = app->GetProfileInt(_T("Classifiers Settings"), _T("HSplitterWidth"), 200);
	m_wndHSplitter.SetColumnInfo(0, cx, 0);
	m_wndHSplitter.RecalcLayout();

	cx=150;
	if(0!=app) cx = app->GetProfileInt(_T("Classifiers Settings"), _T("VSplitterHeigth"), 150);
	m_wndVSplitter.SetRowInfo(1, cx, 0);
	m_wndVSplitter.RecalcLayout();

	SetWindowText( APL_T(""));
	return true;
}

void CClassifierChildFrame::OnSize(UINT nType, int cx, int cy) 
{
	if(::IsWindow(m_wndHSplitter.m_hWnd) && ::IsWindow(m_wndVSplitter.m_hWnd) && IsWindowVisible() && !IsIconic() && !AfxGetMainWnd()->IsIconic())
	{
		int vpos, tmp;
		
		m_wndHSplitter.GetColumnInfo(0, vpos, tmp);
		m_wndVSplitter.GetRowInfo(1, vpos, tmp);
		
		CFrameWnd::OnSize(nType, cx, cy);
		
		int dy = 0;
		dy = 11;
		m_wndVSplitter.SetRowInfo(0, cy-vpos-dy<0 ? 0 : cy-vpos-dy, 0);
		m_wndVSplitter.SetRowInfo(1, vpos, 0);
		m_wndVSplitter.RecalcLayout();
	}
	else
		CMDIChildWnd::OnSize(nType, cx, cy);
}

BOOL CClassifierChildFrame::DestroyWindow() 
{
	int cx, tmp;

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		m_wndHSplitter.GetColumnInfo(0, cx, tmp);
		app->WriteProfileInt(_T("Classifiers Settings"), _T("HSplitterWidth"), cx);
		
		m_wndVSplitter.GetRowInfo(1, cx, tmp);
		app->WriteProfileInt(_T("Classifiers Settings"), _T("VSplitterHeigth"), cx);
	}
	
	return CMDIChildWnd::DestroyWindow();
}

void CClassifierChildFrame::OnUpdateFrameTitle(BOOL bAddToTitle)
{
	SetTitle( APL_T(" "));

	CMDIChildWnd::OnUpdateFrameTitle(bAddToTitle);
}
