// DelPdrDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DelPdrDlg.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDelPdrDlg dialog


CDelPdrDlg::CDelPdrDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDelPdrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDelPdrDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_api= NULL;
	m_change= NULL;
}


void CDelPdrDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDelPdrDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_CHANGE_DEL_PDR_LIST, m_pdrList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDelPdrDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDelPdrDlg)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_CHANGE_DEL_PDR_LIST, OnItemchangedChangeDelPdrList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDelPdrDlg message handlers
BOOL CDelPdrDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	m_pdrList.SetImageList(&m_imageList, LVSIL_SMALL);
	m_pdrList.SetExtendedStyle(m_pdrList.GetExtendedStyle()|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES|LVS_EX_CHECKBOXES);
	
	m_pdrList.InsertColumn(0,  APL_T(""), LVCFMT_LEFT, 600);

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	
	if(m_api && m_api->m_data.IsConnected())
	{
		for(int i= 0; i<m_pdrs.GetSize(); i++)
		{
			CString sName, sType, buf, sPos, sUnit, sCont;
			CaplInstance *prd= NULL, *pdf= NULL;
			m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_pdr_r_ted, pdf);
			if(pdf)
			{
				m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
				m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_apl_pdf_type, sType);
			}

			if(prd) m_api->GetItemName(prd, sName);
			if(pdf) m_api->GetItemName(pdf, sName);
		
			
			CaplInstance *unit= NULL;
			double count;
			if(m_api->m_data.IsKindOf(m_pdrs[i], m_api->m_prd_mgr.e_make_from))
			{
				int iRanking;
				m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_make_from_ranking, iRanking);
				sPos.Format(_T("(%i)"), iRanking);
				m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_make_from_value, count);
				m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_make_from_unit, unit);								
			}
			else
			{
				m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_pdr_id, buf);
				sPos.Format(_T("(%2s) "),LPCTSTR(buf));
				m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_apl_qacu_value, count);
				m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_apl_qacu_unit, unit);				
			}

			m_api->m_charact_mgr.GetUnitName(unit, buf);
			sUnit.Format(_T(" [%g %s]"),count, buf);			
			
			aplExtent contexts;
			m_api->m_data.GetAttr(m_pdrs[i], m_api->m_prd_mgr.a_pdr_frames_of_reference, contexts);
			m_api->m_prd_mgr.PrintItemContextInString(contexts, buf);
			if(buf.IsEmpty()) buf=  APL_T(" ");
			sCont.Format(_T(" {%s}"), buf);

			sName= sPos+sName+sUnit+sCont;
			
			int prdIcon= -1;
			if(!sType.IsEmpty())
			{
				if(sType==_T("assembly")) prdIcon= ICON_ASSEMBLY;
				else if(sType==_T("part")) prdIcon= ICON_PART;
				else if(sType==_T("material")) prdIcon= ICON_MATERIAL;
				else if(sType==_T("kit")) prdIcon= ICON_KIT;
				else if(sType==_T("komplex")) prdIcon= ICON_KOMPLEX;				
				else if(sType==_T("other")) prdIcon= ICON_OTHER;				
			}

			if(!sName.IsEmpty())
			{
				int n= m_pdrList.InsertItem(i, sName, prdIcon);
				m_pdrList.SetItemData(n, (DWORD)m_pdrs[i]);
				m_pdrList.SetCheck(i, TRUE);
			}
		}
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDelPdrDlg::OnItemchangedChangeDelPdrList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	*pResult = 0;

	BOOL bCheck;	

	if(pNMListView->uNewState==0x2000) //
		bCheck= TRUE;
	else if(pNMListView->uNewState==0x1000) //
		bCheck= FALSE;
	else return;

	bool bSel= false;
	
	POSITION pos = m_pdrList.GetFirstSelectedItemPosition();
	if (pos)
	{		
		while (pos)
		{
			int nItem = m_pdrList.GetNextSelectedItem(pos);
			if(!bSel)
			{
				if(nItem==pNMListView->iItem)
				{
					bSel= true;
					pos= m_pdrList.GetFirstSelectedItemPosition();
				}
			}
			else
			{
				m_pdrList.SetCheck(nItem, bCheck);
			}
		}
	}
}

void CDelPdrDlg::OnOK() 
{
	m_pdrs.Clear();
	for(int i= 0; i<m_pdrList.GetItemCount(); i++)
	{
		if(m_pdrList.GetCheck(i))
		{
			CaplInstance* pdr= (CaplInstance*)m_pdrList.GetItemData(i);
			if(pdr)
				m_pdrs.Add(pdr);
		}
	}

	CaplTranslateDialog::OnOK();
}

