// DocChanges.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "DocChanges.h"
//#include "DocumentChangeDlg.h"
#include "ChangeDocVerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDocChanges dialog


CDocChanges::CDocChanges(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CDocChanges::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDocChanges)
	m_doc_id = _T("");
	m_doc_name = _T("");
	//}}AFX_DATA_INIT

	m_api = 0;
	m_doc = 0;
	m_bp = 0;
	m_charact = 0;
	m_changes.SetUniqueName(_T("doc_changes_list"));
}


void CDocChanges::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDocChanges)
	DDX_Control(pDX, IDC_STATIC_DOC_CHANGE, m_static_doc_change);
	DDX_Control(pDX, IDC_SHOW_CHANGE, m_showChngBtn);
	DDX_Control(pDX, IDC_DESCR, m_descr_ctrl);
	DDX_Text(pDX, IDC_DOC_ID, m_doc_id);
	DDX_Text(pDX, IDC_DOC_NAME, m_doc_name);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDocChanges, CResizableDialog)
	//{{AFX_MSG_MAP(CDocChanges)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_CHANGES, OnItemchangedChanges)
	ON_NOTIFY(NM_DBLCLK, IDC_CHANGES, OnDblclkOnChange)
	ON_BN_CLICKED(IDC_SHOW_CHANGE, OnShowChange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDocChanges message handlers

BOOL CDocChanges::OnInitDialog() 
{
	RECT rect={5, 180, 600, 365};
	CWnd* wnd = GetDlgItem( IDC_CHANGES1 ) ;
	if (wnd != 0)
	{
		wnd->GetWindowRect(&rect);
		ScreenToClient(&rect);
	}
	m_changes.Create(WS_VISIBLE | WS_CHILD | WS_BORDER, rect, this, IDC_CHANGES);

	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_DOC_ID,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_DOC_NAME,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STATIC_DOC_CHANGE,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_DESCR,BOTTOM_LEFT,BOTTOM_RIGHT);//, TOP_RIGHT);
	AddAnchor(IDC_STATIC_DOC_CHANGE_DESCR,BOTTOM_LEFT);//, BOTTOM_RIGHT);
	AddAnchor(IDC_CHANGES,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_SHOW_CHANGE,BOTTOM_RIGHT);

	// TODO: Add extra initialization here
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_showChngBtn.EnableWindow(FALSE);

	m_changes.InsertColumn(0, APL_T(""), LVCFMT_LEFT, 100);
	//m_changes.InsertColumn(1,APL_T(""),LVCFMT_LEFT,70);
	m_changes.InsertColumn(1, APL_T(" "), LVCFMT_LEFT, 100);
	m_changes.InsertColumn(2, APL_T(" "), LVCFMT_LEFT, 100);
	m_changes.InsertColumn(3, APL_T(""), LVCFMT_LEFT, 120);
	m_changes.InsertColumn(4, APL_T(" "), LVCFMT_LEFT, 120);
	m_changes.InsertColumn(5, APL_T(" "), LVCFMT_LEFT, 120);
	m_changes.InsertColumn(6, APL_T(" "), LVCFMT_LEFT, 120);
//	m_changes.InsertColumn(6,APL_T(""),LVCFMT_LEFT,150);	

	m_changes.SetColumnDate(4);

	if (m_api == 0)
		return FALSE;
	
	if (m_doc == 0 && m_bp == 0 && m_charact == 0)
		return FALSE;

	if (m_doc)
	{
		apidata.GetAttr(m_doc,m_api->m_doc_mgr.a_doc_id,m_doc_id);
		apidata.GetAttr(m_doc,m_api->m_doc_mgr.a_doc_name,m_doc_name);
		SetWindowText( APL_T(" ")); 
		m_static_doc_change.SetWindowText( APL_T(""));
	}
	else if (m_bp)
	{
		apidata.GetAttr(m_bp,m_api->m_bp_mgr.a_bp_id,m_doc_id);
		apidata.GetAttr(m_bp,m_api->m_bp_mgr.a_bp_name,m_doc_name);
		SetWindowText( APL_T(" -"));
		m_static_doc_change.SetWindowText( APL_T("-"));
	}
	else
	{
		CaplInstance* inst = NULL;
		apidata.GetAttr(m_charact, m_api->m_charact_mgr.a_apl_charact_val_charact, inst);

		apidata.GetAttr(inst, m_api->m_charact_mgr.a_apl_charact_id, m_doc_id);
		apidata.GetAttr(inst, m_api->m_charact_mgr.a_apl_charact_name, m_doc_name);
		SetWindowText( APL_T(" "));
		m_static_doc_change.SetWindowText( APL_T(""));
	}
	
	UpdateData(FALSE);

	aplExtent ext0;
	CString buf, name;
	int i, j;
//	apidata.GetEntityExtent(m_api->m_doc_mgr.e_apl_doc_change,ext0);
	
	CaplInstance* c_inst = m_doc;
	if (m_bp)
		c_inst = m_bp;

	if (m_charact)
		c_inst = m_charact;

	m_api->m_change_mgr.GetAllChanges(c_inst, ext0);
	for (i = 0; i < ext0.Size;i++)
	{
		CaplInstance *change = ext0[i], *inst;
		if (m_doc)
			apidata.GetAttr(change, m_api->m_change_mgr.a_avc_old_rev, inst);
		else if (m_bp)
			apidata.GetAttr(change, m_api->m_change_mgr.a_abpc_old_rev, inst);
		else if (m_charact)
			apidata.GetAttr(change, m_api->m_change_mgr.a_char_change_old_rev, inst);

		if (!inst)
		{
			

// 			continue; // ,    ,   NULL
		}
		
		apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_id, name);
		CaplInstance* ofChg = NULL;
		apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_of_chng, ofChg);
		if (ofChg)
		{
			if(!ofChg->attrs)
				m_api->m_change_mgr.LoadChangeInfo(ofChg);
			apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_id, buf);
			if (!buf.IsEmpty())
				name += _T(" (") + buf + _T(")");
		}

		j = m_changes.InsertItem(0, name);
		m_changes.SetItemData(j, (long)change);
		
		//apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_basis, buf);
		//m_changes.SetItemText(j, 1, buf);
		//apidata.GettAttr(change,a_apl_doc_change_descr,buf);
		//m_changes.SetItemText(j,2,buf);

	
		if(inst)
		{
			if (m_doc) // 
				apidata.GetAttr(inst, m_api->m_doc_mgr.a_apl_doc_rev_id, buf);
			else if (m_bp) // -
				apidata.GetAttr(inst, m_api->m_bp_mgr.a_bp_ver_num, buf);
			else // -
				apidata.GetAttr(inst, m_api->m_charact_mgr.a_apl_charact_val_ver_version_num, buf);
			m_changes.SetItemText(j, 1, buf);
		}


		if (m_doc) // 
			apidata.GetAttr(change, m_api->m_change_mgr.a_avc_new_rev,inst);
		else if (m_bp) // -
			apidata.GetAttr(change, m_api->m_change_mgr.a_abpc_new_rev,inst);
		else // -
			apidata.GetAttr(change, m_api->m_change_mgr.a_char_change_new_rev, inst);

		if (inst)
		{
			if (m_doc) // 
				apidata.GetAttr(inst, m_api->m_doc_mgr.a_apl_doc_rev_id, buf);
			else if (m_bp) // -
				apidata.GetAttr(inst, m_api->m_bp_mgr.a_bp_ver_num, buf);
			else // -
				apidata.GetAttr(inst, m_api->m_charact_mgr.a_apl_charact_val_ver_version_num, buf);

			m_changes.SetItemText(j, 2, buf);
		}

		/**/
		if(ofChg) apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_create_date, buf);
		else apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_accept_date,buf);

		COleDateTime odt;
		if (aplString2Date(buf,odt))
			buf.Format(_T("%.2d.%.2d.%.4d"), odt.GetDay(), odt.GetMonth(), odt.GetYear());			
//			buf = odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
		else
			buf = _T("");
		m_changes.SetItemText(j, 3, buf);

		if(ofChg) apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_create_autor, inst);
		else apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_autor, inst);

		if (inst)
		{
			m_api->m_appr_mgr.GetPersonName(inst, buf);
		}
		else
		{
			if(ofChg) apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_create_user, buf);
			else apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_user, buf);
		}		
		m_changes.SetItemText(j, 4, buf);

		/**/
		if(ofChg) apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_apply_date, buf);
		else apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_accept_date,buf);

		if (aplString2Date(buf,odt))
		{
			buf.Format(_T("%.2d.%.2d.%.4d"), odt.GetDay(), odt.GetMonth(), odt.GetYear());			
// 			
// 			buf = odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
		}
		else
			buf = _T("");
		m_changes.SetItemText(j, 5, buf);
		
		if(ofChg) apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_autor, inst);
		else apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_autor, inst);

		if (inst)
		{
			m_api->m_appr_mgr.GetPersonName(inst, buf);
		}
		else
		{
			if(ofChg) apidata.GetAttr(ofChg, m_api->m_change_mgr.a_chng_user, buf);
			else apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_user, buf);
		}		
		m_changes.SetItemText(j, 6, buf);

/*		apidata.GetAttr(change, m_api->m_change_mgr.a_chng_item_autor, inst);
		if(inst!=0)
		{
			CString buf1;
			CaplAggr aggr0;
			apidata.GetAttrBN(inst,_T("last_name"),buf);	
			apidata.GetAttrBN(inst,_T("first_name"),buf1);
			if(buf1.GetLength()>0) {buf+=_T(" ");buf+=buf1[0];}
			apidata.GetAttrBN(inst,_T("middle_names"),aggr0);
			aggr0.GetByIndex(0,buf1);
			if(buf1.GetLength()>0) {buf+=_T(". ");buf+=buf1[0];}

			m_changes.SetItemText(j,6,buf);
		}*/
	}

    ListView_SetExtendedListViewStyle(m_changes.m_hWnd,
		ListView_GetExtendedListViewStyle(m_changes.m_hWnd)
                | LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_INFOTIP);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDocChanges::OnItemchangedChanges(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	m_showChngBtn.EnableWindow(FALSE);
	
	if (m_changes.IsSorting())
		m_descr_ctrl.SetWindowText(_T(""));
	else
	{
		POSITION pos;
		pos = m_changes.GetFirstSelectedItemPosition();
		int k = m_changes.GetNextSelectedItem(pos);
		if (k >= 0)
		{
			CString buf;
			CaplInstance *inst0 = (CaplInstance*)m_changes.GetItemData(k);
			apidata.GetAttr(inst0, m_api->m_change_mgr.a_chng_item_dscr, buf);
			
			CaplInstance* chng;
			apidata.GetAttr(inst0, m_api->m_change_mgr.a_chng_item_of_chng, chng);
			if (chng)
				m_showChngBtn.EnableWindow();
			
			m_descr_ctrl.SetWindowText(buf);
		}
		else
			m_descr_ctrl.SetWindowText(_T(""));
	}	
	*pResult = 0;
}

void CDocChanges::OnDblclkOnChange(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	*pResult = 0;

	if (lpnmitem == 0)
		return;
	
	int i = lpnmitem->iItem;
	if (i < 0)
		return;

	CaplInstance *inst0 = (CaplInstance*)m_changes.GetItemData(i);

	if (inst0 == 0)
		return;

	CChangeDocVerDlg dlg;
	dlg.m_api= m_api;
	dlg.m_avc = inst0;
	dlg.m_bReadOnly = true;
	if (m_bp)
		dlg.m_viewMode = 1;

	if (m_charact)
		dlg.m_viewMode = 2;

	dlg.DoModal();
}

void CDocChanges::OnShowChange() 
{
	int ind= m_changes.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
	if (ind != -1)
	{
		CaplInstance* inst0 = (CaplInstance*)m_changes.GetItemData(ind);
		CaplInstance* chng=0;
		if (inst0)
			apidata.GetAttr(inst0, m_api->m_change_mgr.a_chng_item_of_chng, chng);
		if (chng)
		{
			m_api->m_change_mgr.ShowChangeProperties(chng);
		}
	}
}
