// DocFormatListsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DocFormatListsDlg.h"


// CDocFormatListsDlg dialog

IMPLEMENT_DYNAMIC(CDocFormatListsDlg, CaplTranslateDialog)

CDocFormatListsDlg::CDocFormatListsDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDocFormatListsDlg::IDD, pParent)
{

}

CDocFormatListsDlg::~CDocFormatListsDlg()
{
}

void CDocFormatListsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_LIST_FORMATS, m_ListFormats);
	DDX_Control(pDX, IDC_EDIT_4_EDIT, m_Edit4Edit);
}


BEGIN_MESSAGE_MAP(CDocFormatListsDlg, CaplTranslateDialog)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_FORMATS, OnDblclkListFormats)
END_MESSAGE_MAP()


// CDocFormatListsDlg message handlers

BOOL CDocFormatListsDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	CString buf;
	CRect rect;
	int i,j;
	DWORD num,multipl;

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);


	m_ListFormats.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_ListFormats.GetClientRect(rect);

	m_ListFormats.InsertColumn(0, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*3/10)-1);
	m_ListFormats.InsertColumn(1, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*3/10)-1);
	m_ListFormats.InsertColumn(2, APL_T("- "), LVCFMT_LEFT, (int)(rect.Width()*4/10)-1);

	m_Edit4Edit.SetParent(&m_ListFormats);

	SMapListDescr* list_descr=0;

	//   - ,   bool CaplDocManager::CalcA4SheetsCount
	for(i=0;i<=5;i++)
	{
		buf.Format(_T("A%i"),i);
		m_ListFormats.InsertItem(i,buf);
		num = 0;
		multipl = 1;
		for(j=0;j<m_list_num_lists.Size;j++)
		{
			list_descr=m_list_num_lists[j];
			if(list_descr==0)continue;
			if(list_descr->format==i)
			{
				num = list_descr->count;
				multipl = list_descr->multipl;
				break;
			}
		}
		if(num < 0) num=0;
		buf.Format(_T("%i"),multipl);
		m_ListFormats.SetItemText(i,1,buf);
		buf.Format(_T("%i"),num);
		m_ListFormats.SetItemText(i,2,buf);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CDocFormatListsDlg::OnDblclkListFormats(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if(pNMLV->iItem == -1)
	{
		// ,  ,    OnCdAddFile() 
		return;
	}
	else
	{
		BeginEditLabel(pNMLV->iSubItem);
	}
}

void CDocFormatListsDlg::BeginEditLabel(int column)
{
	BOOL res=true;
	CRect rect,rectc;
	CString buf;
	int i,num_edit;
	SMapListDescr* list_descr=0;

	m_num_edit_item = m_ListFormats.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if(m_num_edit_item==-1) return;
	if(column==0)column=1;
	m_num_edit_column = column;

	//   - 
	m_ListFormats.GetItemRect(m_num_edit_item,rect,LVIR_BOUNDS);
	if(column==1)
	{
		rect.left = m_ListFormats.GetColumnWidth(0) + 2;
	}
	else
	{
		rect.left = m_ListFormats.GetColumnWidth(0) + m_ListFormats.GetColumnWidth(1) + 2;
	}
	rect.right = rect.left + m_ListFormats.GetColumnWidth(column) -3;

	//        -   
	m_ListFormats.GetClientRect(&rectc);
	if(rectc.right < rect.right)rect.right = rectc.right - 1;

	//     
	for(i=0;i<m_list_num_lists.Size;i++)
	{
		if(m_list_num_lists[i]==0)continue;
		if(m_list_num_lists[i]->format==m_num_edit_item)
		{
			list_descr = m_list_num_lists[i];
		}
	}
	if(list_descr !=0)
	{
		switch(m_num_edit_column)
		{
		case 1: num_edit = list_descr->multipl; break;
		case 2: num_edit = list_descr->count; break;
		default: return;
		}
	}
	else
	{
		switch(m_num_edit_column)
		{
		case 1: num_edit = 1; break;
		case 2: num_edit = 0; break;
		default: return;
		}
	}
	buf.Format(_T("%i"),num_edit);
	m_Edit4Edit.SetWindowText(buf);

	res=m_Edit4Edit.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),SWP_SHOWWINDOW|SWP_NOCOPYBITS);
	m_Edit4Edit.SetFocus();
	m_Edit4Edit.SetForegroundWindow();
}


BOOL CDocFormatListsDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
#ifdef _DEBUG
	// 	CString str;
	// 	str.Format(_T("%i \n"),pMsg->message);
	// 	OutputDebugString(str);
#endif

	if(pMsg!=0)
	{
		switch ( pMsg->message )
		{
		case WM_KEYDOWN:
		case WM_LBUTTONDOWN:
		case WM_LBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONDBLCLK:
		case WM_MBUTTONDOWN:
		case WM_MBUTTONDBLCLK:
			if(TestEndEdit(pMsg) == TRUE)
				return TRUE;
			break;
		}
	}

	return CaplTranslateDialog::PreTranslateMessage(pMsg);
}


BOOL CDocFormatListsDlg::TestEndEdit(MSG* pMsg)
{
	BOOL retval = FALSE;
	bool is_end_combo = false;
	bool is_save = true;
	SMapListDescr* list_descr=0;
	int i;

	if(pMsg == 0) return FALSE;
	if(m_num_edit_item == -1) return FALSE;
	if(m_num_edit_column < 1 || m_num_edit_column > 2) return FALSE;

	if(pMsg->hwnd != m_Edit4Edit.m_hWnd)
	{
		//        
		is_end_combo = true;
	}
	else if(pMsg->message == WM_KEYDOWN )
	{
		switch (pMsg->wParam)
		{
		case VK_ESCAPE:
			//  Escvape. ,   
			is_end_combo = true;
			is_save = false;
			retval = TRUE;
			break;
		case VK_RETURN:
			//  Enter. ,   
			//     -      ;)
			retval = TRUE;
			is_end_combo = true;
			break;
		case VK_TAB:
			//  Tab.    
			is_end_combo = true;
			break;
		}
	}
	if(is_end_combo)
	{
		m_Edit4Edit.ShowWindow(SW_HIDE);

		if(is_save)
		{
			CString buf;
			int num_edit;
			for(i=0;i<m_list_num_lists.Size;i++)
			{
				if(m_list_num_lists[i]==0)continue;
				if(m_list_num_lists[i]->format==m_num_edit_item)
					list_descr = m_list_num_lists[i];
			}
			if(list_descr == 0)
			{
				list_descr = new SMapListDescr();
				list_descr->format = m_num_edit_item;
				for(i=0;i<m_list_num_lists.Size;i++)
				{
					if(m_list_num_lists[i]==0)continue;
					if(m_list_num_lists[i]->format > m_num_edit_item)
					{
						m_list_num_lists.Insert(i,list_descr);
						break;
					}
				}
				if(i >= m_list_num_lists.Size)m_list_num_lists.Add(list_descr);
			}


			m_Edit4Edit.GetWindowText(buf);
			num_edit = _atoi(buf);
			switch(m_num_edit_column)
			{
			case 1: 
				if(num_edit < 0) num_edit = 1;
				list_descr->multipl = num_edit;
				break;
			case 2: 
				if(num_edit < 0) num_edit = 0;
				list_descr->count = num_edit;
				break;
			default: return FALSE;
			}
			buf.Format(_T("%i"),num_edit);
			m_ListFormats.SetItemText(m_num_edit_item,m_num_edit_column,buf);
		}
		m_num_edit_item = -1;
		m_num_edit_column = -1;
	}
	return retval;
}

