// ExportInstanceDialog.cpp : implementation file
//

#include "stdafx.h"
#include "ExportInstanceDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExportInstanceDialog dialog


CExportInstanceDialog::CExportInstanceDialog(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CExportInstanceDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExportInstanceDialog)
	m_exp_categ = TRUE;
	m_exp_classif = TRUE;
	m_exp_doc = TRUE;
	m_exp_prd_charact = TRUE;
	m_exp_req = TRUE;
	m_exp_prd_mater = TRUE;
	m_exp_prd_struct = TRUE;
	m_exp_appr = TRUE;
	m_exp_prj = TRUE;
	m_exp_prj_ver = FALSE;
	m_exp_folder = TRUE;
	m_file_name = _T("");
	m_exp_bp = TRUE;
	m_exp_bpres = TRUE;
	m_exp_prd_inst = TRUE;
	m_ignore_add_dict=TRUE;

	m_bAutoFormateETDPacket=0;
	m_bDeleteTempraryFiles=0;
	m_bSaveRequsiteFiles=0;

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		m_bAutoFormateETDPacket = app->GetProfileInt(_T("options"), _T("AutoFormateETDPacket"), 0);
		m_bDeleteTempraryFiles = app->GetProfileInt(_T("options"), _T("DeleteTempraryFiles"), 0);
		m_bSaveRequsiteFiles = app->GetProfileInt(_T("options"), _T("SaveRequsiteFiles"), 0);
	}
	//}}AFX_DATA_INIT
}


void CExportInstanceDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExportInstanceDialog)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_FILE_NAME, m_FileNameCtrl);
	DDX_Check(pDX, IDC_EXP_CATEG, m_exp_categ);
	DDX_Check(pDX, IDC_EXP_CLASSIF, m_exp_classif);
	DDX_Check(pDX, IDC_EXP_DOC, m_exp_doc);
	DDX_Check(pDX, IDC_EXP_PRD_CHARACT, m_exp_prd_charact);
	DDX_Check(pDX, IDC_EXP_REQ, m_exp_req);
	DDX_Check(pDX, IDC_EXP_PRD_MATER, m_exp_prd_mater);
	DDX_Check(pDX, IDC_EXP_PRD_STRUCT, m_exp_prd_struct);
	DDX_Check(pDX, IDC_EXP_APPR, m_exp_appr);
	DDX_Check(pDX, IDC_EXP_PROJECT, m_exp_prj);	
	DDX_Check(pDX, IDC_EXP_PROJECT_VER, m_exp_prj_ver);	
	DDX_Check(pDX, IDC_EXP_FOLDERS, m_exp_folder);
	DDX_Text(pDX, IDC_FILE_NAME, m_file_name);
	DDX_Check(pDX, IDC_EXP_BP, m_exp_bp);
	DDX_Check(pDX, IDC_EXP_BPRES, m_exp_bpres);
	DDX_Check(pDX, IDC_EXP_PRD_INST, m_exp_prd_inst);
	DDX_Check(pDX, IDC_AUTOFORMETD_PACKET, m_bAutoFormateETDPacket);
	DDX_Check(pDX, IDC_DELETE_TEMPRARY_FILES, m_bDeleteTempraryFiles);
	DDX_Check(pDX, IDC_SAVE_REQUSITE, m_bSaveRequsiteFiles);
	DDX_Check(pDX, IDC_IGNORE_ADD_DICT, m_ignore_add_dict);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CExportInstanceDialog, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CExportInstanceDialog)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_AUTOFORMETD_PACKET, OnAutoFormateTempraryFiles)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExportInstanceDialog message handlers

void CExportInstanceDialog::OnBrowse() 
{
	CString buf;
	m_FileNameCtrl.GetWindowText(buf);
	CFileDialog dlg(FALSE,_T(""),LPCTSTR(buf),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("APL Data Files (*.std)|*.std|JSON Files (*.json)|*.json|APL Text Data Files (*.txt)|*.txt|P21 Files (*.stp)|*.stp|All Files (*.*)|*.*||"));
	if(dlg.DoModal()==IDOK)	
		m_FileNameCtrl.SetWindowText(dlg.GetPathName( ));	
}

void CExportInstanceDialog::OnOK() 
{
	UpdateData(TRUE);
	if(m_file_name==_T("")){AfxMessageBox( APL_T("   !")); return;}

	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)
	{
		app->WriteProfileInt(_T("options"), _T("AutoFormateETDPacket"), (int)m_bAutoFormateETDPacket);
		app->WriteProfileInt(_T("options"), _T("DeleteTempraryFiles"), (int)m_bDeleteTempraryFiles);
		app->WriteProfileInt(_T("options"), _T("SaveRequsiteFiles"), (int)m_bSaveRequsiteFiles);
	}
	
	CString sPath = m_file_name.Left(m_file_name.ReverseFind(_T('\\')));
	if(sPath.IsEmpty()) {AfxMessageBox( APL_T("   !")); return;}

	CreateDirectory(sPath, NULL);

	CaplTranslateDialog::OnOK();
}

BOOL CExportInstanceDialog::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_ok_btn.SetFlat(FALSE);
	
	GetDlgItem(IDC_DELETE_TEMPRARY_FILES)->EnableWindow(m_bAutoFormateETDPacket);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CExportInstanceDialog::OnAutoFormateTempraryFiles() 
{
	UpdateData();
	GetDlgItem(IDC_DELETE_TEMPRARY_FILES)->EnableWindow(m_bAutoFormateETDPacket);
}
