// FindAdjustDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "FindAdjustCharactDlg.h"
#include "FindQueryDlg.h"
#include "aplguiex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CFindAdjustCharactDlg dialog


CFindAdjustCharactDlg::CFindAdjustCharactDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindAdjustCharactDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindAdjustCharactDlg)
	m_ChkType = FALSE;
	//}}AFX_DATA_INIT
	m_api=0;
	m_el=0;
	m_is_update=true;
	m_unit=0;
	m_cur_ref_val=0;
	m_characteristic=0;
	m_read_only=false;
}


void CFindAdjustCharactDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindAdjustCharactDlg)
	DDX_Control(pDX, IDC_CHECK_TYPE, m_ChkStType);
	DDX_Control(pDX, IDC_SELECT_INSTANCE, m_select_instance);
	DDX_Control(pDX, IDC_EXIST_CHAR, m_ExistChar);
	DDX_Control(pDX, IDC_VAL_TYPE, m_type);
	DDX_Control(pDX, IDC_STATIC_MIN, m_stat_min);
	DDX_Control(pDX, IDC_STATIC_MAX, m_stat_max);
	DDX_Control(pDX, IDC_LOG_OP_MIN, m_log_op_ctrl_min);
	DDX_Control(pDX, IDC_LOG_OP_MAX, m_log_op_ctrl_max);
	DDX_Control(pDX, IDC_CHECK_MIN_DEV, m_ChkMinDev);
	DDX_Control(pDX, IDC_CHECK_VAL, m_ChkVal);
	DDX_Control(pDX, IDC_CHECK_MAX_DEV, m_ChkMaxDev);
	DDX_Control(pDX, IDC_MIN_DEV, m_min_dev);
	DDX_Control(pDX, IDC_MAX_DEV, m_max_dev);
	DDX_Control(pDX, IDC_VALUE, m_value_ctrl);
	DDX_Control(pDX, IDC_STR_VAL, m_str_val_ctrl);
	DDX_Control(pDX, IDC_STATIC_VALUE, m_stat_value);
	DDX_Control(pDX, IDC_MEASURE_UNIT, m_measure_unit_ctrl);
	DDX_Control(pDX, IDC_LOG_OP, m_log_op_ctrl);
	DDX_Control(pDX, IDC_ENUM_VALUE, m_enum_val_ctrl);
	DDX_Control(pDX, IDC_DATE, m_date_ctrl);
	DDX_Control(pDX, IDC_TIME, m_time_ctrl);
	DDX_Check(pDX, IDC_CHECK_TYPE, m_ChkType);
	DDX_Control(pDX, IDC_CHARACTERYSTIC, m_charact);
	DDX_Control(pDX, IDC_SEL_CHARACT, m_sel_charact);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOk);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindAdjustCharactDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindAdjustCharactDlg)
//	ON_CBN_SELCHANGE(IDC_CHARACTERYSTIC, OnSelchangeCharacterystic)
	ON_BN_CLICKED(IDC_CHECK_TYPE, OnCheck)
	ON_CBN_SELCHANGE(IDC_LOG_OP, OnSelchangeLogOp)
	ON_CBN_SELCHANGE(IDC_EXIST_CHAR, OnSelchangeExistChar)
	ON_BN_CLICKED(IDC_SELECT_INSTANCE, OnSelectInstance)
	ON_BN_CLICKED(IDC_CHECK_VAL, OnCheck)
	ON_BN_CLICKED(IDC_CHECK_MAX_DEV, OnCheck)
	ON_BN_CLICKED(IDC_CHECK_MIN_DEV, OnCheck)
	ON_BN_CLICKED(IDC_SEL_CHARACT, OnSelCharact)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustCharactDlg message handlers
/*
void CFindAdjustCharactDlg::OnSelchangeCharacterystic() 
{
	// TODO: Add your control notification handler code here
	m_measure_unit_ctrl.SetWindowText(_T("???"));
	
	CaplInstance *inst=(CaplInstance*)m_characterystic_ctrl.GetItemData(m_characterystic_ctrl.GetCurSel());
	SetCharacterystic(inst);
}
*/
void CFindAdjustCharactDlg::HideValue()
{
//	m_stat_value.ShowWindow(SW_HIDE);
//	m_ChkVal.ShowWindow(SW_HIDE);
//	m_log_op_ctrl.ShowWindow(SW_HIDE);

	m_value_ctrl.ShowWindow(SW_HIDE);

	m_enum_val_ctrl.ShowWindow(SW_HIDE);
	m_str_val_ctrl.ShowWindow(SW_HIDE);
	m_date_ctrl.ShowWindow(SW_HIDE);
	m_time_ctrl.ShowWindow(SW_HIDE);
	m_select_instance.ShowWindow(SW_HIDE);

	
	ExtValShow(SW_HIDE);

	m_log_op_ctrl.ResetContent();
	m_log_op_ctrl_max.ResetContent();
	m_log_op_ctrl_min.ResetContent();

	m_value_ctrl.MoveWindow(&m_val_rect);
	m_value_ctrl.SetReadOnly(FALSE);

}

void CFindAdjustCharactDlg::ExtValShow(int state){
	m_stat_max.ShowWindow(state);
	m_stat_min.ShowWindow(state);

	m_min_dev.ShowWindow(state);
	m_max_dev.ShowWindow(state);

	m_ChkMaxDev.ShowWindow(state);
	m_ChkMinDev.ShowWindow(state);

	m_log_op_ctrl_max.ShowWindow(state);
	m_log_op_ctrl_min.ShowWindow(state);

}


BOOL CFindAdjustCharactDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ExistChar.ResetContent();
	m_ExistChar.InsertString(0,APL_T(""));
	m_ExistChar.InsertString(1,APL_T(""));
	
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);

	// TODO: Add extra initialization here
	RECT rect,rect1;
	m_value_ctrl.GetWindowRect(&m_val_rect);
	ScreenToClient(&m_val_rect);
	rect1=m_val_rect;
	rect=m_val_rect;
	int length=rect.right-rect.left;
	rect.right=rect.right-(length/3)-10;
	rect1.left=rect1.left+(2*length/3)-6;
	m_date_ctrl.MoveWindow(&rect);
	m_time_ctrl.MoveWindow(&rect1);

	m_min_dev.GetWindowRect(&rect1);
	ScreenToClient(&rect1);
	rect1.top=rect.top;
	rect1.left=rect.left;

	m_value_ctrl.GetWindowRect(&rect1);
	ScreenToClient(&rect1);
	m_enum_val_ctrl.MoveWindow(&rect1);
	m_str_val_ctrl.MoveWindow(&rect1);

	CTime time(2000,1,1,0,0,0);

	m_ExistChar.SetCurSel(0);
	// TODO: Add extra initialization here
	HideValue();
	CString buf;
	int i;
	
	aplExtent ext0;
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type,ext0);
	for(i=0;i<ext0.Size;i++)
	{
		apidata.GetAttr(ext0[i],m_api->m_charact_mgr.a_apl_charact_type_name,buf);
		int k=m_type.AddString(buf);
		m_type.SetItemData(k,(UINT)ext0[i]);
		if(m_el!=0){
			if(ext0[i]==m_el->type){
				m_type.SetCurSel(k);
				m_ChkType=TRUE;
			}
		}
	}

	if(m_el!=0){
		if(m_el->is_exist){
			m_ExistChar.SetCurSel(0);
		}else{
			m_ExistChar.SetCurSel(1);
		}
		if(m_el->apl_char!=0){
			apidata.GetAttr(m_el->apl_char,m_api->m_charact_mgr.a_apl_charact_unit,m_unit);
			SetCharacterystic(m_el->apl_char);

			m_log_op_ctrl.SelectString(-1,CaplQLQuery::LogOp2String(m_el->log_relation));
			if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_step_unit))
			{
				m_value_ctrl.SetWindowText(m_el->val);
				m_max_dev.SetWindowText( m_el->val_max);
				m_min_dev.SetWindowText( m_el->val_min);

				m_log_op_ctrl_max.SelectString(-1,CaplQLQuery::LogOp2String(m_el->log_relation_max));
				m_log_op_ctrl_min.SelectString(-1,CaplQLQuery::LogOp2String(m_el->log_relation_min));
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_descript_unit))
			{
				m_el->val.Remove(_T('\''));
				m_str_val_ctrl.SetWindowText(m_el->val);
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_monetary_unit))
			{
				m_value_ctrl.SetWindowText(m_el->val);
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_time_unit))
			{
				int nYear, nMonth, nDay;
				nDay=_atoi(m_el->val_min);
				nMonth=_atoi(m_el->val_max);
				nYear=_atoi(m_el->val);
//				CTime* timeDest=new CTime(nYear, nMonth, nDay,0,0,0);
				if(m_el->dtt!=0){
					m_date_ctrl.SetTime(*(m_el->dtt));
					m_time_ctrl.SetTime(*(m_el->dtt));
				}
//				delete timeDest;
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_reference_unit))
			{
				if(m_el->m_cur_ref_val!=0){
					m_cur_ref_val=m_el->m_cur_ref_val;
					m_api->m_charact_mgr.GetItemName(m_cur_ref_val,buf);
					m_value_ctrl.SetWindowText(buf);
				}
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_enum_unit))
			{
				m_el->val.Remove(_T('\''));
				m_enum_val_ctrl.SetCurSel(m_enum_val_ctrl.FindString(0,m_el->val));
			}
			if(m_el->b_val){m_ChkVal.SetCheck(1);}else{m_ChkVal.SetCheck(0);}
			if(m_el->b_max){m_ChkMaxDev.SetCheck(1);}else{m_ChkMaxDev.SetCheck(0);}
			if(m_el->b_min){m_ChkMinDev.SetCheck(1);}else{m_ChkMinDev.SetCheck(0);}

		}
	}
	m_is_update=false;
	OnSelchangeLogOp();
	if(m_read_only){
		m_sel_charact.EnableWindow(FALSE);
		m_ExistChar.EnableWindow(FALSE);
		m_type.EnableWindow(FALSE);
		m_log_op_ctrl_min.EnableWindow(FALSE);
		m_log_op_ctrl_max.EnableWindow(FALSE);
		m_ChkMinDev.EnableWindow(FALSE);
		m_ChkVal.EnableWindow(FALSE);
		m_ChkMaxDev.EnableWindow(FALSE);
		m_min_dev.EnableWindow(FALSE);
		m_max_dev.EnableWindow(FALSE);
		m_value_ctrl.EnableWindow(FALSE);
		m_str_val_ctrl.EnableWindow(FALSE);
		m_stat_value.EnableWindow(FALSE);
		m_measure_unit_ctrl.EnableWindow(FALSE);
		m_log_op_ctrl.EnableWindow(FALSE);
		m_enum_val_ctrl.EnableWindow(FALSE);
		m_date_ctrl.EnableWindow(FALSE);
		m_time_ctrl.EnableWindow(FALSE);
		m_charact.EnableWindow(FALSE);
		m_ChkStType.EnableWindow(FALSE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindAdjustCharactDlg::OnCheck() 
{
	// TODO: Add your control notification handler code here
	ValidateControlState();
		
}


void CFindAdjustCharactDlg::SetLogOpSet(CaplQLQuery::aplQLLogRelation log_relation)
{
	int num;

	num=m_log_op_ctrl.AddString(CaplQLQuery::LogOp2String(log_relation));
	m_log_op_ctrl.SetItemData(num,(DWORD)log_relation);
	if(log_relation!=CaplQLQuery::aplEXIST)
	{
		num=m_log_op_ctrl_max.AddString(CaplQLQuery::LogOp2String(log_relation));
		m_log_op_ctrl_max.SetItemData(num,(DWORD)log_relation);

		num=m_log_op_ctrl_min.AddString(CaplQLQuery::LogOp2String(log_relation));
		m_log_op_ctrl_min.SetItemData(num,(DWORD)log_relation);
	}
}

void CFindAdjustCharactDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	if(m_characteristic==0)
	{
		AfxMessageBox( APL_T("   !!!"));
		return;
	}

	CString min_dev,max_dev;
	CString sval,buf;
	/*
	if(apidata.IsKindOfBN(m_unit,_T("step_unit")))
	{
		if(!m_ChkVal.GetCheck()&&!m_ChkMinDev.GetCheck()&&!m_ChkMaxDev.GetCheck()){
			AfxMessageBox(APL_T("    !"));
			return;
		}
	}else{
		if(!m_ChkVal.GetCheck()){
			AfxMessageBox(APL_T("  !"));
			return;
		}
	}
	*/
	if(m_el==0){
		m_el=new ElValChar();
	}
	m_el->is_exist=m_ExistChar.GetCurSel()==0;
	
	if(m_ChkType){
		m_el->type=(CaplInstance*)m_type.GetItemData(m_type.GetCurSel());
		if(m_el->type==(CaplInstance*)-1){
			m_el->type=0;
			AfxMessageBox( APL_T("    !"));
			return;
		}
	}else{
		m_el->type=0;
	}
	m_el->apl_char=m_characteristic;
	
	m_el->log_relation=(CaplQLQuery::aplQLLogRelation)m_log_op_ctrl.GetItemData(m_log_op_ctrl.GetCurSel());
	m_el->log_relation_max=(CaplQLQuery::aplQLLogRelation)m_log_op_ctrl_max.GetItemData(m_log_op_ctrl_max.GetCurSel());
	m_el->log_relation_min=(CaplQLQuery::aplQLLogRelation)m_log_op_ctrl_min.GetItemData(m_log_op_ctrl_min.GetCurSel());
	if(m_el->log_relation==-1 && m_ChkVal.GetCheck()){
		AfxMessageBox( APL_T("   !"));
		return;
	};
	if(m_el->log_relation_max==-1 && m_ChkMaxDev.GetCheck()){
		AfxMessageBox( APL_T("   +!"));
		return;
	};
	if(m_el->log_relation_min==-1 && m_ChkMinDev.GetCheck()){
		AfxMessageBox( APL_T("   -!"));
		return;
	};
	//  
	if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_step_unit))
	{
		if(m_ChkVal.GetCheck()){
			m_value_ctrl.GetWindowText(sval);
			if(!IsReal(sval)){
				AfxMessageBox( APL_T("    !!!"));
				return;
			}
			m_el->val=sval;
			m_el->b_val=true;
		}else{
			m_el->b_val=false;
		}
		if(m_ChkMinDev.GetCheck()){
			m_min_dev.GetWindowText(min_dev);
			if(!IsReal(min_dev)){
				AfxMessageBox( APL_T("     !!!"));
				return;
			}
			m_el->val_min=min_dev;
			m_el->b_min=true;
		}else{
			m_el->b_min=false;
		}
		if(m_ChkMaxDev.GetCheck()){
			m_max_dev.GetWindowText(max_dev);
			if(!IsReal(max_dev)){
				AfxMessageBox( APL_T("     !!!"));
				return;
			}
			m_el->val_max=max_dev;
			m_el->b_max=true;
		}else{
			m_el->b_max=false;
		}
	}
	else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_descript_unit))
	{
		if(m_ChkVal.GetCheck()){
			m_str_val_ctrl.GetWindowText(sval);
			if(sval==_T("")){
				AfxMessageBox( APL_T("  "));
				return;
			}
			if(sval.Find(_T("'"))>=0){
				AfxMessageBox( APL_T("    (').\n      "));
				return;
			}
			m_el->val=_T("'")+sval+_T("'");
			m_el->b_val=true;
		}else{
			m_el->b_val=false;
		}
	}
	else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_enum_unit))
	{
		if(m_ChkVal.GetCheck()){
			m_enum_val_ctrl.GetWindowText(sval);
			if(sval==_T("")){
				AfxMessageBox( APL_T("  "));
				return;
			}
			if(sval.Find(_T("'"))>=0){
				AfxMessageBox( APL_T("    (').\n      "));
				return;
			}
			m_el->val=_T("'")+sval+_T("'");
			m_el->b_val=true;
		}else{
			m_el->b_val=false;
		}
	}
	else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_monetary_unit))
	{
		if(m_ChkVal.GetCheck()){
			m_value_ctrl.GetWindowText(sval);
			if(!IsReal(sval)){
					AfxMessageBox( APL_T("    !!!"));
					return;
			}
			m_el->val=sval;
			m_el->b_val=true;
		}else{
			m_el->b_val=false;
		}
	}
	else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_time_unit))
	{
		/*
		CTime timeDest;
		if(m_ChkVal.GetCheck()){
			m_date_ctrl.GetTime(timeDest);
			m_el->val_min.Format(_T("%i"),timeDest.GetDay());
			m_el->val_max.Format(_T("%i"),timeDest.GetMonth());
			m_el->val.Format(_T("%i"),timeDest.GetYear());
			m_el->b_val=true;
		}*/
		if(m_ChkVal.GetCheck()){
			COleDateTime d_time,t_time;
			m_date_ctrl.GetTime(d_time);
			m_time_ctrl.GetTime(t_time);
			if(m_el->dtt==0){m_el->dtt=new COleDateTime();}
			m_el->dtt->SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),t_time.GetHour(),t_time.GetMinute(),t_time.GetSecond());
			m_el->b_val=true;
		}else{
			m_el->b_val=false;
		}
	}
	else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_reference_unit))
	{
		if(m_ChkVal.GetCheck()){
			if(m_cur_ref_val==0){ 
				AfxMessageBox( APL_T("   !!!"));
				return; 
			}			
			m_el->b_val=true;
			m_el->m_cur_ref_val=m_cur_ref_val;
		}else{
			m_el->b_val=false;
			m_el->m_cur_ref_val=0;
		}
	}
	/*
	else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_aggr_unit))
	{
		if(m_changed_aggr){
			//    _value
			CreateCopyCharacteristicVal(m_value_edit,m_value);
			DeleteCharacteristicValue(m_value_edit);
		}else{
			//   
			DeleteCharacteristicValue(m_value_edit);
		}
	}
	*/	
	CaplTranslateDialog::OnOK();
}

void CFindAdjustCharactDlg::OnSelchangeLogOp() 
{
	// TODO: Add your control notification handler code here
	ValidateControlState();
}

void CFindAdjustCharactDlg::ValidateControlState() 
{
	if(m_is_update){
		UpdateData();
	}
	/*
	bool flag=(CaplQLQuery::aplQLLogRelation)m_log_op_ctrl.GetItemData(m_log_op_ctrl.GetCurSel())==
	CaplQLQuery::aplEXIST &&m_ChkVal.GetCheck();
	
	  if(flag){
	  m_ChkMinDev.SetCheck(0);
	  m_ChkMaxDev.SetCheck(0);
	  }
	*/
	m_is_update=true;
	m_log_op_ctrl.EnableWindow(m_ChkVal.GetCheck());
	m_log_op_ctrl_max.EnableWindow(m_ChkMaxDev.GetCheck());
	m_log_op_ctrl_min.EnableWindow(m_ChkMinDev.GetCheck());
	
	m_min_dev.EnableWindow(m_ChkMinDev.GetCheck());
	m_max_dev.EnableWindow(m_ChkMaxDev.GetCheck());
	
	m_value_ctrl.EnableWindow(m_ChkVal.GetCheck() /*&& !flag*/);
	m_select_instance.EnableWindow(m_ChkVal.GetCheck() /*&& !flag*/);
	m_str_val_ctrl.EnableWindow(m_ChkVal.GetCheck()/* && !flag*/);
	m_enum_val_ctrl.EnableWindow(m_ChkVal.GetCheck()/* && !flag*/);
	m_date_ctrl.EnableWindow(m_ChkVal.GetCheck()/* && !flag*/);
	m_time_ctrl.EnableWindow(m_ChkVal.GetCheck()/* && !flag*/);
	
	//	m_ChkMinDev.EnableWindow (!flag);
	//	m_ChkMaxDev.EnableWindow (!flag);
	
	m_type.EnableWindow(m_ChkType);
	
	UpdateData(FALSE);
	
}

void CFindAdjustCharactDlg::OnSelchangeExistChar() 
{
	// TODO: Add your control notification handler code here
	
}

void CFindAdjustCharactDlg::OnSelectInstance() 
{
	// TODO: Add your control notification handler code here
	CaplInstance *inst=m_api->m_charact_mgr.BrowseReferenceVal(m_unit);
	if(inst==0) return;
	
	m_cur_ref_val=inst;
	CString buf;
	m_api->m_charact_mgr.GetItemName(m_cur_ref_val,buf);
	m_value_ctrl.SetWindowText(buf);
	
}

void CFindAdjustCharactDlg::OnSelCharact() 
{
	// TODO: Add your control notification handler code here
	CaplInstance *newCharact=m_api->m_charact_mgr.SelectCharacteristic(m_characteristic);
	SetCharacterystic(newCharact);
	
}

void CFindAdjustCharactDlg::SetCharacterystic(CaplInstance *new_charact)
{
	if(new_charact==(CaplInstance *)-1)new_charact=0;
	if(new_charact!=0)
	{
		CString buf,buf1;
		HideValue();
		apidata.GetAttr(new_charact,m_api->m_charact_mgr.a_apl_charact_name,buf);
		m_charact.SetWindowText(buf);
		m_characteristic=new_charact;
		
		apidata.GetAttr(new_charact,m_api->m_charact_mgr.a_apl_charact_unit,m_unit);
		if(m_unit!=0)
		{
			m_ChkVal.ShowWindow(SW_SHOW);
			m_log_op_ctrl.ShowWindow(SW_SHOW);
			m_stat_value.ShowWindow(SW_SHOW);
			
			m_api->m_charact_mgr.GetUnitName(m_unit,buf);
			m_measure_unit_ctrl.SetWindowText(buf);

			if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_step_unit))
			{
				m_stat_value.ShowWindow(SW_SHOW);
				m_value_ctrl.ShowWindow(SW_SHOW);
				ExtValShow(SW_SHOW);

				SetLogOpSet(CaplQLQuery::aplSMALL);
				SetLogOpSet(CaplQLQuery::aplBIG);
				SetLogOpSet(CaplQLQuery::aplSMALLEQUAL);
				SetLogOpSet(CaplQLQuery::aplBIGEQUAL);
				SetLogOpSet(CaplQLQuery::aplEQUAL);
				SetLogOpSet(CaplQLQuery::aplNOTEQUAL);
				
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_descript_unit))
			{
				m_stat_value.ShowWindow(SW_SHOW);
				m_str_val_ctrl.ShowWindow(SW_SHOW);
				SetLogOpSet(CaplQLQuery::aplEQUAL);
				SetLogOpSet(CaplQLQuery::aplNOTEQUAL);
				SetLogOpSet(CaplQLQuery::aplLIKE);
				SetLogOpSet(CaplQLQuery::aplNOTLIKE);
				
				m_ChkMaxDev.SetCheck(0);
				m_ChkMinDev.SetCheck(0);
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_enum_unit))
			{
				m_enum_val_ctrl.ResetContent();
				CaplAggr aggr;
				CString buf;
				apidata.GetAttrBN(m_unit,_T("values"),aggr);//!!!     "values" apl_enum_unit
				for(int i=0;i<aggr.GetSize();i++)
				{
					if(aggr.GetByIndex(i,buf))
						m_enum_val_ctrl.AddString(buf);
				}
				m_stat_value.ShowWindow(SW_SHOW);
				m_enum_val_ctrl.ShowWindow(SW_SHOW);

				SetLogOpSet(CaplQLQuery::aplEQUAL);
				SetLogOpSet(CaplQLQuery::aplNOTEQUAL);
				
				m_ChkMaxDev.SetCheck(0);
				m_ChkMinDev.SetCheck(0);
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_monetary_unit))
			{
				m_value_ctrl.ShowWindow(SW_SHOW);
				m_stat_value.ShowWindow(SW_SHOW);

				SetLogOpSet(CaplQLQuery::aplSMALL);
				SetLogOpSet(CaplQLQuery::aplBIG);
				SetLogOpSet(CaplQLQuery::aplSMALLEQUAL);
				SetLogOpSet(CaplQLQuery::aplBIGEQUAL);
				SetLogOpSet(CaplQLQuery::aplEQUAL);
				SetLogOpSet(CaplQLQuery::aplNOTEQUAL);
				
				m_ChkMaxDev.SetCheck(0);
				m_ChkMinDev.SetCheck(0);
			}
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_time_unit))
			{
				m_date_ctrl.ShowWindow(SW_SHOW);
				m_time_ctrl.ShowWindow(SW_SHOW);
				m_stat_value.ShowWindow(SW_SHOW);
				
				SetLogOpSet(CaplQLQuery::aplSMALL);
				SetLogOpSet(CaplQLQuery::aplBIG);
				SetLogOpSet(CaplQLQuery::aplSMALLEQUAL);
				SetLogOpSet(CaplQLQuery::aplBIGEQUAL);
				SetLogOpSet(CaplQLQuery::aplEQUAL);
				SetLogOpSet(CaplQLQuery::aplNOTEQUAL);
				
				m_ChkMaxDev.SetCheck(0);
				m_ChkMinDev.SetCheck(0);
				
			}
			/*
			else if(apidata.IsKindOfBN(m_unit,_T("apl_aggregation_unit")))
			{
			m_value_ctrl.ShowWindow(SW_SHOW);
			m_stat_value.ShowWindow(SW_SHOW);
			}
			*/			
			else if(apidata.IsKindOf(m_unit,m_api->m_charact_mgr.e_apl_reference_unit))
			{
				SetLogOpSet(CaplQLQuery::aplEQUAL);
				SetLogOpSet(CaplQLQuery::aplNOTEQUAL);
				m_select_instance.ShowWindow(SW_SHOW);
				m_value_ctrl.ShowWindow(SW_SHOW);
				m_value_ctrl.SetReadOnly(TRUE);
				RECT rect=m_val_rect;
				rect.right=rect.right-33;
				m_value_ctrl.MoveWindow(&rect);
				rect=m_val_rect;
				rect.left=rect.right-24;
				m_select_instance.MoveWindow(&rect);

				m_ChkMaxDev.SetCheck(0);
				m_ChkMinDev.SetCheck(0);
			}
			else
			{
				// AfxMessageBox(APL_T("      "));
				//      ""-""
				m_ChkVal.SetCheck(0);
				m_ChkMaxDev.SetCheck(0);
				m_ChkMinDev.SetCheck(0);
				m_ChkVal.ShowWindow(SW_HIDE);
				m_log_op_ctrl.ShowWindow(SW_HIDE);
				m_stat_value.ShowWindow(SW_HIDE);
				
			}
		}
	}
}
