// FindAdjustDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "FindAdjustDocDlg.h"
#include "FindQueryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustDocDlg dialog

CFindAdjustDocDlg::CFindAdjustDocDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindAdjustDocDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindAdjustDocDlg)
	m_chk_id = FALSE;
	m_chk_name = FALSE;
	m_chk_type = FALSE;
	m_chk_eq_id = FALSE;
	m_chk_eq_name = FALSE;
	m_str_edit_id = _T("");
	m_str_edit_name = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_el=0;
	m_inst_type=0;
	m_read_only=false;
}


void CFindAdjustDocDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindAdjustDocDlg)
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDC_BTN_SELECT_TYPE, m_BtnSelectType);
	DDX_Control(pDX, IDC_TYPE, m_CtrlType);
	DDX_Control(pDX, IDC_CHECK_TYPE, m_ctrl_check_type);
	DDX_Control(pDX, IDC_CHECK_NAME, m_ctrl_check_name);
	DDX_Control(pDX, IDC_CHECK_ID, m_ctrl_check_id);
	DDX_Control(pDX, IDC_EXIST_DOC, m_ExistDoc);
	DDX_Control(pDX, IDC_EDIT_NAME, m_ctrl_edit_name);
	DDX_Control(pDX, IDC_EDIT_ID, m_ctrl_edit_id);
	DDX_Control(pDX, IDC_CHK_EQ_NAME, m_ctrl_eq_name);
	DDX_Control(pDX, IDC_CHK_EQ_ID, m_ctrl_eq_id);
	DDX_Check(pDX, IDC_CHECK_ID, m_chk_id);
	DDX_Check(pDX, IDC_CHECK_NAME, m_chk_name);
	DDX_Check(pDX, IDC_CHECK_TYPE, m_chk_type);
	DDX_Check(pDX, IDC_CHK_EQ_ID, m_chk_eq_id);
	DDX_Check(pDX, IDC_CHK_EQ_NAME, m_chk_eq_name);
	DDX_Text(pDX, IDC_EDIT_ID, m_str_edit_id);
	DDX_Text(pDX, IDC_EDIT_NAME, m_str_edit_name);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOk);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindAdjustDocDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindAdjustDocDlg)
	ON_BN_CLICKED(IDC_CHECK_ID, OnCheck)
	ON_CBN_SELCHANGE(IDC_EXIST_DOC, OnSelchangeExistDoc)
	ON_BN_CLICKED(IDC_CHECK_NAME, OnCheck)
	ON_BN_CLICKED(IDC_CHECK_TYPE, OnCheck)
	ON_BN_CLICKED(IDC_BTN_SELECT_TYPE, OnBtnSelectType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustDocDlg message handlers
BOOL CFindAdjustDocDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	aplExtent ext0;
	//int i;
	CString buf;

	m_ExistDoc.ResetContent();
	m_ExistDoc.InsertString(0,APL_T(""));
	m_ExistDoc.InsertString(1,APL_T(""));

	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	
	m_ExistDoc.SetCurSel(0);
	// TODO: Add extra initialization here
	if(m_api!=0){
		/*
		apidata.GetEntityExtentBN(_T("document_type"),ext0);

		for(i=0;i<ext0.Size;i++){
			apidata.GetAttrBN(ext0[i],_T("product_data_type"),buf);
			int k=m_ctrl_type.AddString(buf);
			m_ctrl_type.SetItemData(k,(UINT)ext0[i]);
		}
		*/
		if(m_el!=0){
			if(m_el->is_exist){
				m_ExistDoc.SetCurSel(0);
			}else{
				m_ExistDoc.SetCurSel(1);
			}
			
			m_str_edit_id=m_el->id;
			m_chk_eq_id=m_el->is_eq_id;
			if(m_str_edit_id!=_T(""))m_chk_id=true;
			m_str_edit_name=m_el->name;
			m_chk_eq_name=m_el->is_eq_name;
			if(m_str_edit_name!=_T(""))m_chk_name=true;

			/* 
			m_ctrl_type.SetCurSel(0);

			for(i=0;i<ext0.Size;i++){
				if(ext0[i]==m_el->GetType()){
					m_ctrl_type.SetCurSel(i);
					m_chk_type=true;
					break;
				}
			}
			*/

			if(m_el->type!=0){
				apidata.GetAttr(m_el->type,m_api->m_doc_mgr.a_dt_pdt,buf);
				m_CtrlType.SetWindowText(buf);
				m_chk_type=true;
				m_inst_type=m_el->type;
			}
		}
	}
	UpdateData(FALSE);
	OnCheck();	

	if(m_read_only){
		m_ExistDoc.EnableWindow(FALSE);
		m_ctrl_edit_name.EnableWindow(FALSE);
		m_ctrl_edit_id.EnableWindow(FALSE);
		m_CtrlType.EnableWindow(FALSE);
		m_BtnSelectType.EnableWindow(FALSE);
		m_ctrl_eq_name.EnableWindow(FALSE);
		m_ctrl_eq_id.EnableWindow(FALSE);
		m_ctrl_check_id.EnableWindow(FALSE);
		m_ctrl_check_name.EnableWindow(FALSE);
		m_ctrl_check_type.EnableWindow(FALSE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindAdjustDocDlg::OnCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_ctrl_edit_id.EnableWindow(m_chk_id);
	m_ctrl_eq_id.EnableWindow(m_chk_id);

	m_ctrl_edit_name.EnableWindow(m_chk_name);
	m_ctrl_eq_name.EnableWindow(m_chk_name);

	m_CtrlType.EnableWindow(m_chk_type);
	m_BtnSelectType.EnableWindow(m_chk_type);
	UpdateData(FALSE);
}

void CFindAdjustDocDlg::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData();
	if(m_api!=0){
		
		if(!m_chk_id && !m_chk_name && !m_chk_type){
			AfxMessageBox( APL_T("    "));
			return;
		}
		if(m_el==0){
			m_el=new ElValDoc();
		}
		m_el->is_exist=m_ExistDoc.GetCurSel()==0;
		if(m_chk_id){
			if(m_str_edit_id==_T("")){
				AfxMessageBox( APL_T("    \"\"  "));
				return;
			}
			m_el->id=m_str_edit_id;
			m_el->is_eq_id=m_chk_eq_id!=0;
		}else{
			m_el->id=_T("");
			m_el->is_eq_id=false;
		}
		if(m_chk_name){
			if(m_str_edit_name==_T("")){
				AfxMessageBox( APL_T("    \"\"  "));
				return;
			}
			m_el->name=m_str_edit_name;
			m_el->is_eq_name=m_chk_eq_name!=0;
		}else{
			m_el->name=_T("");
			m_el->is_eq_name=false;
		}
		if(m_chk_type){
			m_el->type=m_inst_type;
			/*
			m_el->GetType()=(CaplInstance*)m_ctrl_type.GetItemData(m_ctrl_type.GetCurSel());
			if(m_el->GetType()==(CaplInstance*)-1)m_el->GetType()=0;
			*/
			if(m_el->type==0){
				AfxMessageBox( APL_T("    !!!"));
				return;
			}
		}else{
			m_el->type=0;
		}
	}
	CaplTranslateDialog::OnOK();
}


void CFindAdjustDocDlg::OnSelchangeExistDoc() 
{
	// TODO: Add your control notification handler code here
	
}

void CFindAdjustDocDlg::OnBtnSelectType() 
{
	// TODO: Add your control notification handler code here
	CaplInstance* inst;
	CString buf;
	inst=m_api->m_doc_mgr.SelectDocType(m_inst_type);
	if(inst!=0){
		m_inst_type=inst;
		apidata.GetAttr(inst,m_api->m_doc_mgr.a_dt_pdt,buf);
		m_CtrlType.SetWindowText(buf);
	}
}
