// FindAdjustResourceDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "FindAdjustResourceDlg.h"
#include "FindQueryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustResourceDlg dialog


CFindAdjustResourceDlg::CFindAdjustResourceDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindAdjustResourceDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindAdjustDocDlg)
	m_chk_id_res = FALSE;
	m_chk_id_obj = FALSE;
	m_chk_name_res = FALSE;
	m_chk_name_obj = FALSE;
	m_chk_type_res = FALSE;
	m_chk_eq_id_res = FALSE;
	m_chk_eq_id_obj = FALSE;
	m_chk_eq_name_res = FALSE;
	m_chk_eq_name_obj = FALSE;
	m_str_edit_id_res = _T("");
	m_str_edit_id_obj = _T("");
	m_str_edit_name_res = _T("");
	m_str_edit_name_obj = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_el=0;
	m_inst_type=0;
	m_read_only=false;
}


void CFindAdjustResourceDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindAdjustResourceDlg)
	DDX_Control(pDX, IDC_TYPE_RES, m_ctrl_select_type_res);
	DDX_Control(pDX, IDC_TYPE_OBJ, m_ctrl_select_type_obj);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDC_CHECK_TYPE_RES, m_ctrl_check_type_res);
	DDX_Control(pDX, IDC_CHECK_NAME_RES, m_ctrl_check_name_res);
	DDX_Control(pDX, IDC_CHECK_NAME_OBJ, m_ctrl_check_name_obj);
	DDX_Control(pDX, IDC_CHECK_ID_RES, m_ctrl_check_id_res);
	DDX_Control(pDX, IDC_CHECK_ID_OBJ, m_ctrl_check_id_obj);
	DDX_Control(pDX, IDC_EXIST_RES, m_ctrl_exist_res);
	DDX_Control(pDX, IDC_EDIT_NAME_RES, m_ctrl_edit_name_res);
	DDX_Control(pDX, IDC_EDIT_NAME_OBJ, m_ctrl_edit_name_obj);
	DDX_Control(pDX, IDC_EDIT_ID_RES, m_ctrl_edit_id_res);
	DDX_Control(pDX, IDC_EDIT_ID_OBJ, m_ctrl_edit_id_obj);
	DDX_Control(pDX, IDC_CHK_EQ_NAME_RES, m_ctrl_eq_name_res);
	DDX_Control(pDX, IDC_CHK_EQ_NAME_OBJ, m_ctrl_eq_name_obj);
	DDX_Control(pDX, IDC_CHK_EQ_ID_RES, m_ctrl_eq_id_res);
	DDX_Control(pDX, IDC_CHK_EQ_ID_OBJ, m_ctrl_eq_id_obj);
	DDX_Check(pDX, IDC_CHECK_ID_RES, m_chk_id_res);
	DDX_Check(pDX, IDC_CHECK_ID_OBJ, m_chk_id_obj);
	DDX_Check(pDX, IDC_CHECK_NAME_RES, m_chk_name_res);
	DDX_Check(pDX, IDC_CHECK_NAME_OBJ, m_chk_name_obj);
	DDX_Check(pDX, IDC_CHECK_TYPE_RES, m_chk_type_res);
	DDX_Check(pDX, IDC_CHK_EQ_ID_RES, m_chk_eq_id_res);
	DDX_Check(pDX, IDC_CHK_EQ_ID_OBJ, m_chk_eq_id_obj);
	DDX_Check(pDX, IDC_CHK_EQ_NAME_RES, m_chk_eq_name_res);
	DDX_Check(pDX, IDC_CHK_EQ_NAME_OBJ, m_chk_eq_name_obj);
	DDX_Text(pDX, IDC_EDIT_ID_RES, m_str_edit_id_res);
	DDX_Text(pDX, IDC_EDIT_ID_OBJ, m_str_edit_id_obj);
	DDX_Text(pDX, IDC_EDIT_NAME_RES, m_str_edit_name_res);
	DDX_Text(pDX, IDC_EDIT_NAME_OBJ, m_str_edit_name_obj);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindAdjustResourceDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindAdjustResourceDlg)
	ON_BN_CLICKED(IDC_CHECK_ID_RES, OnCheck)
	ON_CBN_SELCHANGE(IDC_EXIST_RES, OnSelchangeExistRes)
	ON_BN_CLICKED(IDC_CHECK_NAME_RES, OnCheck)
	ON_BN_CLICKED(IDC_CHECK_TYPE_RES, OnCheck)
	ON_BN_CLICKED(IDC_CHECK_ID_OBJ, OnCheck)
	ON_BN_CLICKED(IDC_CHECK_NAME_OBJ, OnCheck)
	ON_CBN_SELCHANGE(IDC_TYPE_OBJ, OnSelchangeTypeObj)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindAdjustResourceDlg message handlers
BOOL CFindAdjustResourceDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	aplExtent ext0;
	int i,j;
	CString buf;

	m_ctrl_exist_res.ResetContent();
	m_ctrl_exist_res.InsertString(0,APL_T(""));
	m_ctrl_exist_res.InsertString(1,APL_T(""));

	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	
	m_ctrl_exist_res.SetCurSel(0);

	// TODO: Add extra initialization here
	if(m_api!=0){
		//  
		m_api->m_data.GetEntityExtent(m_api->m_bp_mgr.e_bp_res_type,ext0);
		for(i=0;i<ext0.Size;i++)
		{
			m_api->m_data.GetAttr(ext0[i],m_api->m_bp_mgr.a_bp_res_type_name,buf);
			j=m_ctrl_select_type_res.AddString(buf);
			m_ctrl_select_type_res.SetItemData(j,(int)ext0[i]);
			if(m_el!=0){
				if(m_el->type_res==ext0[i]){
					m_ctrl_select_type_res.SetCurSel(j);
				}
			}
		}
		m_ctrl_select_type_obj.DeleteString(0);
		j=m_ctrl_select_type_obj.AddString( APL_T(" "));
		m_ctrl_select_type_obj.SetCurSel(0);
		m_ctrl_select_type_obj.SetItemData(j,(int)ElValRes::TRONoType);
		j=m_ctrl_select_type_obj.AddString( APL_T(""));
		m_ctrl_select_type_obj.SetItemData(j,(int)ElValRes::TROProduct);
		j=m_ctrl_select_type_obj.AddString( APL_T(""));
		m_ctrl_select_type_obj.SetItemData(j,(int)ElValRes::TROPerson);
		j=m_ctrl_select_type_obj.AddString( APL_T(" "));
		m_ctrl_select_type_obj.SetItemData(j,(int)ElValRes::TROOrg);

		if(m_el!=0){
			if(m_el->is_exist){
				m_ctrl_exist_res.SetCurSel(0);
			}else{
				m_ctrl_exist_res.SetCurSel(1);
			}
			
			m_str_edit_id_res=m_el->id_res;
			m_str_edit_id_obj=m_el->id_obj;
			m_chk_eq_id_res=m_el->is_eq_id_res;
			m_chk_eq_id_obj=m_el->is_eq_id_obj;
			if(m_str_edit_id_res!=_T(""))m_chk_id_res=true;
			if(m_str_edit_id_obj!=_T(""))m_chk_id_obj=true;
			m_str_edit_name_res=m_el->name_res;
			m_str_edit_name_obj=m_el->name_obj;
			m_chk_eq_name_res=m_el->is_eq_name_res;
			m_chk_eq_name_obj=m_el->is_eq_name_obj;
			if(m_str_edit_name_res!=_T(""))m_chk_name_res=true;
			if(m_str_edit_name_obj!=_T(""))m_chk_name_obj=true;
			
			for(j=0;j<m_ctrl_select_type_obj.GetCount();j++){
				if(m_ctrl_select_type_obj.GetItemData(j)==(DWORD)(m_el->type_obj)){
					m_ctrl_select_type_obj.SetCurSel(j);break;
				}
			}

		}
	}
	UpdateData(FALSE);
	OnCheck();	

	if(m_read_only){
		m_ctrl_exist_res.EnableWindow(FALSE);
		m_ctrl_edit_name_res.EnableWindow(FALSE);
		m_ctrl_edit_name_obj.EnableWindow(FALSE);
		m_ctrl_edit_id_res.EnableWindow(FALSE);
		m_ctrl_edit_id_obj.EnableWindow(FALSE);
		m_ctrl_select_type_res.EnableWindow(FALSE);
		m_ctrl_select_type_obj.EnableWindow(FALSE);
		m_ctrl_eq_name_res.EnableWindow(FALSE);
		m_ctrl_eq_name_obj.EnableWindow(FALSE);
		m_ctrl_eq_id_res.EnableWindow(FALSE);
		m_ctrl_eq_id_obj.EnableWindow(FALSE);
		m_ctrl_check_id_res.EnableWindow(FALSE);
		m_ctrl_check_id_obj.EnableWindow(FALSE);
		m_ctrl_check_name_res.EnableWindow(FALSE);
		m_ctrl_check_name_obj.EnableWindow(FALSE);
		m_ctrl_check_type_res.EnableWindow(FALSE);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindAdjustResourceDlg::OnCheck() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_ctrl_edit_id_res.EnableWindow(m_chk_id_res);
	m_ctrl_eq_id_res.EnableWindow(m_chk_id_res);
	m_ctrl_edit_name_res.EnableWindow(m_chk_name_res);
	m_ctrl_eq_name_res.EnableWindow(m_chk_name_res);

	ElValRes::TypeResObj type_obj=
		(ElValRes::TypeResObj)m_ctrl_select_type_obj.GetItemData(m_ctrl_select_type_obj.GetCurSel());
	m_ctrl_check_id_obj.EnableWindow(type_obj!=ElValRes::TRONoType);
	m_ctrl_check_name_obj.EnableWindow(type_obj!=ElValRes::TRONoType);
		
	m_ctrl_edit_name_obj.EnableWindow(m_chk_name_obj && type_obj!=ElValRes::TRONoType);
	m_ctrl_edit_id_obj.EnableWindow(m_chk_id_obj && type_obj!=ElValRes::TRONoType);
	m_ctrl_eq_id_obj.EnableWindow(m_chk_id_obj && type_obj!=ElValRes::TRONoType);
	m_ctrl_eq_name_obj.EnableWindow(m_chk_name_obj && type_obj!=ElValRes::TRONoType);

	m_ctrl_select_type_res.EnableWindow(m_chk_type_res);
	UpdateData(FALSE);
}

void CFindAdjustResourceDlg::OnOK() 
{
	if(!UpdateData()) return;

	if(m_api!=0){

		ElValRes::TypeResObj type_obj=
			(ElValRes::TypeResObj)m_ctrl_select_type_res.GetItemData(m_ctrl_select_type_res.GetCurSel());
		
		if(	!m_chk_id_res && !m_chk_name_res && !m_chk_type_res && type_obj==ElValRes::TRONoType)
		{
			AfxMessageBox( APL_T("    "));
			return;
		}
		if(type_obj!=ElValRes::TRONoType && !m_chk_id_obj && !m_chk_name_obj ){
			AfxMessageBox( APL_T("       "));
			return;
		}
		if(m_el==0){
			m_el=new ElValRes();
		}
		m_el->is_exist=m_ctrl_exist_res.GetCurSel()==0;
		if(m_chk_id_res){
			if(m_str_edit_id_res==_T("")){
				AfxMessageBox( APL_T("    \"\"  "));
				return;
			}
			m_el->id_res=m_str_edit_id_res;
			m_el->is_eq_id_res=m_chk_eq_id_res!=0;
		}else{
			m_el->id_res=_T("");
			m_el->is_eq_id_res=false;
		}
		if(m_chk_name_res){
			if(m_str_edit_name_res==_T("")){
				AfxMessageBox( APL_T("    \"\"  "));
				return;
			}
			m_el->name_res=m_str_edit_name_res;
			m_el->is_eq_name_res=m_chk_eq_name_res!=0;
		}else{
			m_el->name_res=_T("");
			m_el->is_eq_name_res=false;
		}
		if(m_chk_type_res){
			//m_el->GetType()=m_inst_type;
			m_el->type_res=(CaplInstance*)m_ctrl_select_type_res.GetItemData(m_ctrl_select_type_res.GetCurSel());
			if(m_el->type_res==(CaplInstance*)-1)m_el->type_res=0;
			
			if(m_el->type_res==0){
				AfxMessageBox( APL_T("    !!!"));
				return;
			}
		}else{
			m_el->type_res=0;
		}
		if(m_chk_id_obj){
			if(m_str_edit_id_obj==_T("")){
				AfxMessageBox( APL_T("    \"\"  "));
				return;
			}
			m_el->id_obj=m_str_edit_id_obj;
			m_el->is_eq_id_obj=m_chk_eq_id_obj!=0;
		}else{
			m_el->id_obj=_T("");
			m_el->is_eq_id_obj=false;
		}
		if(m_chk_name_obj){
			if(m_str_edit_name_obj==_T("")){
				AfxMessageBox( APL_T("    \"\"  "));
				return;
			}
			m_el->name_obj=m_str_edit_name_obj;
			m_el->is_eq_name_obj=m_chk_eq_name_obj!=0;
		}else{
			m_el->name_obj=_T("");
			m_el->is_eq_name_obj=false;
		}
	}
	CaplTranslateDialog::OnOK();
}


void CFindAdjustResourceDlg::OnSelchangeExistRes() 
{
	// TODO: Add your control notification handler code here
	
}

/*
void CFindAdjustResourceDlg::OnBtnSelectType() 
{
	// TODO: Add your control notification handler code here
	CaplInstance* inst;
	CString buf;
	inst=m_api->m_doc_mgr.SelectDocType(m_inst_type);
	if(inst!=0){
		m_inst_type=inst;
		apidata.GetAttr(inst,m_api->m_doc_mgr.a_dt_pdt,buf);
		m_CtrlType.SetWindowText(buf);
	}
}
*/

void CFindAdjustResourceDlg::OnSelchangeTypeObj() 
{
	// TODO: Add your control notification handler code here
	ElValRes::TypeResObj type_obj=
		(ElValRes::TypeResObj)m_ctrl_select_type_res.GetItemData(m_ctrl_select_type_res.GetCurSel());

	switch(type_obj)
	{
	case ElValRes::TROPerson:
		m_ctrl_check_id_obj.SetWindowText( APL_T(""));
		m_ctrl_check_name_obj.SetWindowText( APL_T(""));
		break;
	case ElValRes::TROOrg:
		m_ctrl_check_id_obj.SetWindowText( APL_T(""));
		m_ctrl_check_name_obj.SetWindowText( APL_T(""));
		break;
	case ElValRes::TRONoType:
	case ElValRes::TROProduct:
	default:
		m_ctrl_check_id_obj.SetWindowText( APL_T(""));
		m_ctrl_check_name_obj.SetWindowText( APL_T(""));
		break;
	}



	OnCheck();
}
