// OrgDlgDlg.h : header file
//

#if !defined(AFX_ORGDLGDLG_H__CE0485A8_BD78_41FB_97AE_0FE8DA897750__INCLUDED_)
#define AFX_ORGDLGDLG_H__CE0485A8_BD78_41FB_97AE_0FE8DA897750__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "apl_api.h"
#include "resource.h"

class COrgStrTreeItem : public CaplTreeItemData
{
public:

	COrgStrTreeItem(CTreeCtrl* ptree) {m_tree=ptree;m_isExpand=false;m_dummy=NULL;};
	CaplInstance* inst;
	bool m_isExpand;
	HTREEITEM m_dummy;

	virtual bool InsetItem(LPCTSTR text, int ico, HTREEITEM parent_item)
	{
		if(m_tree==0) 
			return false;
		CaplTreeItemData::InsetItem(text,ico,parent_item);
		
		m_dummy=m_tree->InsertItem(_T(""),ico,ico,m_item);
		m_tree->SetItemData(m_dummy,NULL);

		if(parent_item!=TVI_ROOT)
		{
			COrgStrTreeItem* item_parent=(COrgStrTreeItem*)m_tree->GetItemData(parent_item);
			item_parent->m_isExpand=true;
			if(item_parent->m_dummy)
			{
				m_tree->DeleteItem(item_parent->m_dummy);
				item_parent->m_dummy=NULL;
			}
		}
		return true;
	};
};

/////////////////////////////////////////////////////////////////////////////
// COrgStrDlg dialog


class COrgStrDlg : public CaplTranslateDialog
{
// Construction
public:
	COrgStrDlg(CaplAPI*	api, CaplInstance* ciInst = NULL, CWnd* pParent = NULL);	// standard constructor
	void SetRootInst(aplExtent& ext) {m_ext_root.Clear();m_ext_root.Append(ext);};	

	CaplInstance* m_inst;
	CString	m_sTitle;
// Dialog Data
	//{{AFX_DATA(COrgStrDlg)
	enum { IDD = IDD_ORGDLG_DIALOG };
	CaplButton	m_ok_btn;
	CaplButton	m_cancel_btn;
	CaplButton 	m_find_btn;
	CTreeCtrl	m_tree;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COrgStrDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

	
// Implementation
protected:
	HICON m_hIcon;
	CaplAPI*	m_api;

	aplExtent m_ext_root;
	aplExtent m_ext_rel;
	aplExtent m_ext;

	// Generated message map functions
	//{{AFX_MSG(COrgStrDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnItemexpandingTree1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnBtnfind();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	
	void FindInstParent(CArray<CaplInstance*,CaplInstance*> &arr);
	void FindRootInst();
	void Expand(COrgStrTreeItem* ptr);
	CaplTAggr <COrgStrTreeItem*,COrgStrTreeItem*,APLAGGR_LIST|APLAGGR_AUTOKILLREF> m_listItems;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ORGDLGDLG_H__CE0485A8_BD78_41FB_97AE_0FE8DA897750__INCLUDED_)
