// OrganizationPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OrganizationPropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COrganizationPropDlg dialog


COrganizationPropDlg::COrganizationPropDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(COrganizationPropDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COrganizationPropDlg)
	m_sDescription = _T("");
	m_sID = _T("");
	m_sName = _T("");
	m_sSuccessor=_T("");
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api = NULL;
	inst = NULL;
	m_bCanEdit = false;
}


void COrganizationPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COrganizationPropDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_ORGANIZATION_DESCRIPTION, m_sDescription);
	DDX_Text(pDX, IDC_ORGANIZATION_INFO, m_sInfo);
	DDX_Text(pDX, IDC_ORGANIZATION_ID, m_sID);
	DDX_Text(pDX, IDC_ORGANIZATION_NAME, m_sName);
	DDX_Text(pDX, IDC_SUCCESSOR, m_sSuccessor);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COrganizationPropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(COrganizationPropDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COrganizationPropDlg message handlers

BOOL COrganizationPropDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	
	if(m_api==0) 
	{
		EndDialog(0);
		return FALSE;
	}
	if(!m_api->m_data.IsDictLoad())
	{
		EndDialog(0);
		return FALSE;
	}
	
	if(inst!=NULL)
	{
		if(!m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_org))
		{
			EndDialog(0);
			return FALSE;
		}
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_id, m_sID);
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_name, m_sName);
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_descr, m_sDescription);

		CaplInstance *successor;
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_successor, successor);
		if(0!=successor) m_api->GetItemName(successor,m_sSuccessor);




		m_sInfo=_T("");
		CString buf,buf1;

		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_phone, buf);
		if(buf!=_T("")) {buf1+=APL_T(": "); buf1+=buf; buf1+=_T(";");}
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_fax, buf);
		if(buf!=_T("")) {{if(buf1!=_T("")) buf1+=_T("   ");} buf1+=APL_T(": "); buf1+=buf; buf1+=_T(";");}
		m_sInfo+=buf1; if(buf1!=_T("")) m_sInfo+=_T("\r\n");

		buf1=_T("");
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_e_mail, buf);
		if(buf!=_T("")) {{if(buf1!=_T("")) buf1+=_T("   ");} buf1+=_T("e-mail: "); buf1+=buf; buf1+=_T(";");}
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_web, buf);
		if(buf!=_T("")) {{if(buf1!=_T("")) buf1+=_T("   ");} buf1+=_T("www: "); buf1+=buf; buf1+=_T(";");}
		m_sInfo+=buf1; if(buf1!=_T("")) m_sInfo+=_T("\r\n\r\n");

		buf1=_T("");
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_inn, buf);
		if(buf!=_T("")) {buf1+=APL_T(" "); buf1+=buf; buf1+=_T(";");}
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_kpp, buf);
		if(buf!=_T("")) {{if(buf1!=_T("")) buf1+=_T("  ");} buf1+=APL_T(" "); buf1+=buf; buf1+=_T(";");}
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_okpo, buf);
		if(buf!=_T("")) {{if(buf1!=_T("")) buf1+=_T("  ");} buf1+=APL_T("OKP "); buf1+=buf; buf1+=_T(";");}
		m_sInfo+=buf1; if(buf1!=_T("")) m_sInfo+=_T("\r\n\r\n");

		buf1=_T("");
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_default_account, buf);
		if(buf!=_T("")) {buf1+=APL_T("  "); buf1+=buf; buf1+=_T(";\r\n");}

		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_bik, buf);
		if(buf!=_T("")) {buf1+=APL_T(" "); buf1+=buf; buf1+=_T(";\r\n");}
		if(buf1!=_T("")) {m_sInfo+=buf1; m_sInfo+=_T("\r\n");}

		buf1=_T("");
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_legal_address, buf);
		if(buf!=_T("")) {buf1+=APL_T(" :"); buf1+=buf; buf1+=_T(";");}
		buf1+=_T("\r\n");
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_actual_address, buf);
		if(buf!=_T("")) {buf1+=APL_T(" :"); buf1+=buf; buf1+=_T(";");}
		buf1+=_T("\r\n");
		m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_postal_address, buf);
		if(buf!=_T("")) {buf1+=APL_T(" :"); buf1+=buf; buf1+=_T(";");}
		m_sInfo+=buf1; if(buf1!=_T("")) m_sInfo+=_T("\r\n\r\n");

		
		if(!m_bCanEdit)
		{
			CEdit *pEdit;
			pEdit = (CEdit*)GetDlgItem(IDC_ORGANIZATION_ID);
			pEdit->SetReadOnly(TRUE);
			pEdit = (CEdit*)GetDlgItem(IDC_ORGANIZATION_NAME);
			pEdit->SetReadOnly(TRUE);
			pEdit = (CEdit*)GetDlgItem(IDC_ORGANIZATION_DESCRIPTION);
			pEdit->SetReadOnly(TRUE);
			
			m_cancel_btn.SetWindowText( APL_T(""));
			m_ok_btn.ShowWindow(SW_HIDE);
		}
	}
	else
		m_bCanEdit = true;

	if(m_api->m_appr_mgr.m_bAllowCreateOrgInSelect) m_bCanEdit=true;

	if(m_bCanEdit)
	{
		CEdit *pEdit;
		pEdit = (CEdit*)GetDlgItem(IDC_ORGANIZATION_ID);
		pEdit->SetReadOnly(FALSE);
		pEdit = (CEdit*)GetDlgItem(IDC_ORGANIZATION_NAME);
		pEdit->SetReadOnly(FALSE);
		pEdit = (CEdit*)GetDlgItem(IDC_ORGANIZATION_DESCRIPTION);
		pEdit->SetReadOnly(FALSE);

		m_cancel_btn.SetWindowText( APL_T(""));
		m_ok_btn.ShowWindow(SW_SHOW);
	}
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COrganizationPropDlg::OnOK() 
{
	if(m_bCanEdit)
	{
		if(!UpdateData()) return;

		m_sID.TrimLeft();			m_sID.TrimRight();
		m_sName.TrimLeft();			m_sName.TrimRight();
		m_sDescription.TrimLeft();	m_sDescription.TrimRight();

		if(m_sID.IsEmpty())
		{
			MessageBox( APL_T("    !"),  APL_T(" "), MB_ICONINFORMATION|MB_OK);
			return;
		}
		
		//    
		CaplAttrValue tst_val;
		aplExtent ext;
		tst_val.attr = m_api->m_appr_mgr.a_org_id;
		tst_val.value.Set(m_sID);

		if(!m_api->m_data.NET_TestUniqueAttrValues(m_api->m_appr_mgr.e_org, inst, 1, &tst_val, false))
		{
			MessageBox( APL_T("  !"),  APL_T(" "), MB_ICONINFORMATION|MB_OK);
			return;
		}
		if(inst==NULL)
			inst = m_api->m_data.CreateInstance(m_api->m_appr_mgr.e_org);
		m_api->m_data.PutAttr(inst, m_api->m_appr_mgr.a_org_id, m_sID);
		m_api->m_data.PutAttr(inst, m_api->m_appr_mgr.a_org_name, m_sName);
		m_api->m_data.PutAttr(inst, m_api->m_appr_mgr.a_org_descr, m_sDescription);
		m_api->SaveChanges();
	}
	CaplTranslateDialog::OnOK();
}
