// PersOfficialDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PersOfficialDlg.h"
#include "ConfirmChangePersonDlg.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPersOfficialDlg dialog


CPersOfficialDlg::CPersOfficialDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CPersOfficialDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPersOfficialDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_list_obj.SetUniqueName(_T("CPersOfficialDlg"));
	
}


void CPersOfficialDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPersOfficialDlg)
	DDX_Control(pDX, IDCANCEL, m_btn_cancel);
	DDX_Control(pDX, IDOK, m_btn_ok);
	DDX_Control(pDX, IDC_LIST_STATIC, m_list_static);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPersOfficialDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CPersOfficialDlg)
	ON_BN_CLICKED(IDC_SET_ACT_PERSON, OnSetActPerson)
	ON_BN_CLICKED(IDC_SHOW_HIST, OnShowHist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPersOfficialDlg message handlers

BOOL CPersOfficialDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_btn_cancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_btn_cancel.SetFlat(FALSE);
	m_btn_ok.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_btn_ok.SetFlat(FALSE);

	e_official = m_auth_mgr->e_official;
	a_id = m_auth_mgr->a_official_id;
	a_owner = m_auth_mgr->a_official_owner;
	a_act_person = m_auth_mgr->a_official_act_person;
	a_possible_persons = m_auth_mgr->a_official_possible_persons;
	a_act_person_hist = m_auth_mgr->a_official_act_person_hist;

	RECT rect={5,5,10,10};
	
	m_list_obj.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SORTASCENDING|LVS_SHOWSELALWAYS |LVS_SINGLESEL,rect,this,IDC_OFFICIAL_HIST_LIST);
	m_list_static.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_list_obj.MoveWindow(&rect);	

	CString str;
	m_auth_mgr->GetPersonName(m_pInstance,str);
	SetWindowText( APL_T("  ")+ str);

	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	m_list_obj.SetImageList(&m_imageList, LVSIL_SMALL);

	m_list_obj.InsertColumn(0, APL_T(""),LVCFMT_LEFT,100);
	m_list_obj.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,200);
	m_list_obj.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	
	m_list_obj.CListCtrl::SetColumnWidth(0,250);

	m_list_obj.LoadColumnWidths();

	FillList();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPersOfficialDlg::FillList()
{
	aplExtent ext0;
	CaplInstance * pOwner, * pActPerson;
	int i,j;
	CString str;

	m_data->GetEntityExtent(e_official,ext0);

	for(i =0 ; i < ext0.GetSize(); i++)
	{
		m_data->GetAttr(ext0[i],a_owner,pOwner);
		m_data->GetAttr(ext0[i],a_act_person,pActPerson);

		if(m_pInstance == pOwner || m_pInstance == pActPerson)
		{
			m_data->GetAttr(ext0[i],a_id,str);
			j = m_list_obj.InsertItem(i, str, ICON_OFFICIAL);
			m_list_obj.SetItemData(j,(DWORD)ext0[i]);
			
			m_auth_mgr->GetPersonName(pActPerson,str);
			m_list_obj.SetItemText(j,1,str);

			m_auth_mgr->GetPersonName(pOwner,str);
			m_list_obj.SetItemText(j,2,str);
		}
	}

}

void CPersOfficialDlg::OnSetActPerson() 
{
//	int j;
	aplExtent ext0;
	CaplInstance *inst, *pPerson, *hist_item, *inst1;

	POSITION pos =  m_list_obj.GetFirstSelectedItemPosition();
	if(pos==NULL)
	return;

	int nItem = m_list_obj.GetNextSelectedItem(pos);

	inst =  (CaplInstance*) m_list_obj.GetItemData(nItem);


	m_data->GetAttr(inst, a_possible_persons, ext0);

	m_data->GetAttr(inst, a_act_person, pPerson);
	
	CaplInstance *new_po=m_auth_mgr->SelectPersonOrOrganization
		(APL_MODE_SELECT_PERSON,ext0, APL_T(" "), APL_T(" "));

	if(new_po)
	{		
		CString buf,buf1,buf2;
		m_auth_mgr->GetPersonName(pPerson,buf);
		m_auth_mgr->GetPersonName(new_po,buf1);

	//	buf2.Format(APL_T("  %s  %s ?"),buf,buf1);
		
		CConfirmChangePersonDlg dlg;
		dlg.dlg_type=1;
		dlg.m_from_person_name = buf;
		dlg.m_to_person_name = buf1;

		if(pPerson!= new_po)// && AfxMessageBox(buf2, MB_YESNO)==IDYES)
		{
			
			if(dlg.DoModal()!=IDOK)
				return;

			COleDateTime odt= COleDateTime::GetCurrentTime();
			aplDate2String(odt, buf); 	

			m_list_obj.SetItemText(nItem,1,buf1);

			ext0.Clear();
			m_data->GetAttr(inst,a_act_person_hist,ext0);
			
			hist_item = m_data->CreateInstanceBN(_T("apl_official_history"));
			m_data->PutAttrBN(hist_item,_T("person"),new_po);
			m_data->PutAttrBN(hist_item,_T("date"),buf);
			m_data->PutAttrBN(hist_item,_T("description"),dlg.m_comment);

			inst1 = m_data->GetCurrUser();
			if(inst1!=NULL)
			{
				
				m_auth_mgr->GetPersonName(inst1,buf);
				
			}
			else
			{
				
				buf = m_data->GetNameCurrUser();
				
			}

			m_data->PutAttrBN(hist_item,_T("user"),buf);

			ext0.Add(hist_item);
			m_data->PutAttr(inst,a_act_person_hist,ext0);
			m_data->PutAttr(inst,a_act_person, new_po);
			m_data->NET_SaveChanges();
		}
		else
		{
			AfxMessageBox( APL_T("   "));
		}
			
	}	
}

void CPersOfficialDlg::OnShowHist() 
{
	
	CaplInstance * inst;
	POSITION pos =  m_list_obj.GetFirstSelectedItemPosition();
	if(pos==NULL)
	return;

	int nItem = m_list_obj.GetNextSelectedItem(pos);

	inst =  (CaplInstance*) m_list_obj.GetItemData(nItem);

	m_auth_mgr->ShowOfficialHistory(inst,1);

	
}


