// PictureView.cpp : implementation file
//

#include "stdafx.h"
#include "PictureView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPictureView

IMPLEMENT_DYNCREATE(CPictureView, CScrollView)

CPictureView::CPictureView()
{
}

CPictureView::~CPictureView()
{
}


BEGIN_MESSAGE_MAP(CPictureView, CScrollView)
	//{{AFX_MSG_MAP(CPictureView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPictureView drawing

void CPictureView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

void CPictureView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here

	CRect rect;
	GetClientRect(&rect);
	m_Picture.Draw(rect, pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CPictureView diagnostics

#ifdef _DEBUG
void CPictureView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CPictureView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPictureView message handlers

bool CPictureView::UpdatePicture(CaplInstance *Inst, CaplAPI* api)
{
	m_Picture.Clear();
	if(api==NULL) return false;
	if(Inst==NULL) return false;

	if(api->m_data.IsKindOf(Inst, api->m_classifier_mgr.e_apl_classifier_level)
		|| api->m_data.IsKindOf(Inst, api->m_classifier_mgr.e_apl_classifier_system))
	{
		BeginWaitCursor();
		CString tmp_name;
		api->m_classifier_mgr.GetClassifierEsquisse(Inst, tmp_name);
		m_Picture.LoadImage(tmp_name);
		DeleteFile(tmp_name);
		Invalidate();
		EndWaitCursor();
	}

	return true;
}
