// PrdListView.h: interface for the CPrdListView class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PRDLISTVIEW_H__F60DE55F_3161_4576_BC8C_7B1C1FB9A3B5__INCLUDED_)
#define AFX_PRDLISTVIEW_H__F60DE55F_3161_4576_BC8C_7B1C1FB9A3B5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "apl_gui.h"
#include "resource.h"
#include "apl_api.h"

class CEffectivityView;
class EffItem;

#define APL_MODE_VISIBLE 0x00000
#define APL_MODE_ALL     0x00001

#define APL_EFF_DATE 0x00000
#define APL_EFF_SN   0x00001

class CPrdListView : public CMultiColumnSortListView  
{
protected:
	CPrdListView();
	DECLARE_DYNCREATE(CPrdListView)
	virtual ~CPrdListView();
	void RefreshSubPrdList();
	void UpdateEffMap();
	void OnSelChanged(bool b_update=false);
	void SetEffItem(EffItem &new_item,int nItem);
	void InsertEffItem(aplMap_element *map_item, int nItem,long mode);
	void InsertEffItems(int nItem,long mode);
	void InsertEffItemWithNoEff(int nItem,long mode);
public:
	void UpdateDiagramSource(long mode=APL_MODE_ALL);
	CaplInstance *m_pdf;
	CaplAPI *m_api;
	CaplEntity *m_rel;// ACU
	CEffectivityView *m_eff_view;
	CaplMap m_eff_map;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPrdListView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL
// Generated message map functions
protected:
	// Generated message map functions
	//{{AFX_MSG(CPrdListView)
	afx_msg int OnMouseActivate( CWnd* pDesktopWnd,UINT nHitTest,UINT message);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	afx_msg void OnHeaderClicked(NMHDR* pNMHDR, LRESULT* pResult) ;
	DECLARE_MESSAGE_MAP()
};

#endif // !defined(AFX_PRDLISTVIEW_H__F60DE55F_3161_4576_BC8C_7B1C1FB9A3B5__INCLUDED_)
