#if !defined(AFX_PRODUCTDLG_H__E8A50A11_A058_11D3_BF00_E4928F0AA116__INCLUDED_)
#define AFX_PRODUCTDLG_H__E8A50A11_A058_11D3_BF00_E4928F0AA116__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ProductDlg.h : header file
//
#include "apl_api.h"
#include "resource.h"

#include "aplCharactView.h"
#include "aplApprovalView.h"
#include "aplDocsView.h"
#include "aplAccessView.h"
#include "afxwin.h"

class CaplInstance;
class CaplStepData;
class CaplProductManager;
class CaplCharacteristicManager;
/////////////////////////////////////////////////////////////////////////////
// CProductDlg dialog


class CProductDlg : public CaplResizableDialog
{
// Construction
protected:
	BOOL m_PrdUnikByIdAndName;

	bool m_bDizableEditPrd;
	bool m_bDizableEditPdf;
	bool m_bDizableEditNAUO;

	bool m_changed_prd;
	bool m_changed_pdf;

	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

public:
	CProductDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CProductDlg)
	enum { IDD = IDD_PRODUCT };
	CButton	m_pdf_first_usage_btn;
	CStatic	m_pdf_first_usage_st;
	CEdit	m_pdf_first_usage_edt;
	CButton	m_prd_name_cng_btn;
	CStatic	m_ref_des_static_ctrl;
	CEdit	m_ref_des_ctrl;
	CStatic	m_st_pdf_code2;
	CStatic	m_st_pdf_code1;
	CEdit	m_pdf_code2_ctrl;
	CEdit	m_pdf_code1_ctrl;
	CButton	m_pdf_code2_cng_btn;
	CButton	m_pdf_code1_cng_btn;
	CButton	m_pdf_code_cng_btn;
	CButton	m_prd_code_cng_btn;
	CaplButton m_setup_unit_convertions_btn;
	CButton	m_prd_id_cng_btn;
	CButton	m_pdf_id_cng_btn;
	CComboBox	m_pdf_unit;
	CStatic	m_st_pdf_unit;
	CaplButton	m_rel_property_btn;
	CStatic	m_st_contexts;
	CEdit	m_context_names;
	CButton	m_context_sel;
	CEdit	m_nauo_count2_ctrl;
	CComboBox	m_nauo_unit2;
	//CComboBox	m_sortament;
	//CStatic	m_st_sort;
	CStatic	m_st_count2;
	CaplButton	m_btn_add;
	CEdit	m_pdf_code_ctrl;
	CEdit	m_prd_code_ctrl;
	CStatic	m_st_pdf_code;
	CStatic	m_st_rank_rat;
	CEdit	m_ranking_rationale_ctrl;
	CEdit	m_ranking_ctrl;
	CStatic	m_ranking_name_ctrl;
	CStatic	m_st_header;
	CaplButton	m_test_btn;
	CaplButton	m_btn_ok;
	CaplButton	m_btn_cancel;
	CButton	m_st_prd;
	CButton	m_pdf_std;
	CButton	m_s_pdf_v;
	CStatic	m_s_pdf_type;
	CStatic	m_s_pdf_src;
	CStatic	m_s_pdf_id;
	CStatic	m_s_pdf_descr;
	CEdit	m_nauo_count_ctrl;
	CComboBox	m_nauo_unit_ctrl;
	CStatic	m_st_name;
	CStatic	m_st_pos;
	CStatic	m_st_descr;
	CButton	m_st_asm;
	CStatic	m_st_count;
	CEdit	m_nauo_descr_ctrl;
	CEdit	m_nauo_name_ctrl;
	CEdit	m_nauo_id_ctrl;
	CComboBox	m_source_ctrl;
	CComboBox	m_type_ctrl;
	CComboBox m_relevance_ctrl;
	CEdit	m_prd_descr_ctrl;
	CEdit	m_prd_name_ctrl;
	CEdit	m_prd_id_ctrl;
	CEdit	m_pdf_descr_ctrl;
	CEdit	m_pdf_id_ctrl;
	CString	m_pdf_id;
	CString	m_pdf_descr;
	CString	m_prd_id;
	CString	m_prd_name;
	CString	m_prd_descr;
	CString	m_nauo_descr;
	CString	m_nauo_id;
	CString	m_nauo_name;
	double	m_nauo_count;
	int		m_ranking;
	CString	m_ranking_rationale;
	CString	m_prd_code;
	CString	m_pdf_code;
	CString	m_pdf_code1;
	CString	m_pdf_code2;
	double	m_nauo_count2;
	CString	m_ref_des;
	CaplTabCtrl	m_Tab;
	CaplButton	m_bPropsProps;
	CaplButton	m_bPropsDel;
	CaplButton	m_bPropsAdd;
	//}}AFX_DATA


public:
	void TestPdfType();
	CaplAPI			*m_api;

	CaplInstance *m_pdf;
	CaplInstance *m_prd;

	CaplInstance *m_base_pdf;
	CaplInstance *m_base_prd;
	CaplInstance *m_base_nauo;
	CaplInstance *m_parent_pdf;
	
	CaplInstance *m_old_clasif_level; //   ,    pdf
	CaplInstance *m_new_clasif_level; //   ,    pdf
	
	CaplInstance *m_pdf_first_usage;

	CaplInstance *m_nauo;
	CaplInstance *m_subst;

	CString	m_prev_prd_code;
	CString	m_prev_pdf_code;
	CString	m_prev_pdf_code1;
	CString	m_prev_pdf_code2;

	bool m_bOpenPrdCode;
	bool m_bOpenPdfCode;
	bool m_bOpenPdfCode1;
	bool m_bOpenPdfCode2;

	aplPrdDlgmode m_mode;

	aplExtent		m_aeCreatedInsts;

	bool m_add_mode, m_ok_end, m_context_changed;
	aplExtent m_nauo_contexts;

	CString			m_csAccessString;

	BOOL			SetAnchors(void);
	void			SetSize(int cy);
	BOOL			InitViews(void);
	void			ChangeViewBtnsState(BOOL bDis,BOOL bHide);
	void			GetAccessString(void);

	bool m_bIsCreatingCopy; //  " " 
	

protected:
	CToolTipCtrl m_tool_tips;
	CBitmap m_name_bmp;
	CImageList m_icons;

	bool SelectUnit(CComboBox &box, CaplInstance *inst);

	void SetSource(CString &src); //         moma 
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CProductDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CProductDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnTest();
	afx_msg void OnStName();
	afx_msg void OnAddProduct();
	afx_msg void OnContextSel();
	afx_msg void OnRelProperty();
	afx_msg void OnSelchangeType();
	afx_msg void OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnBPropsAdd();
	afx_msg void OnBPropsDel();
	afx_msg void OnBPropsProps();
	afx_msg void OnPrdIdCng();
	afx_msg void OnPrdCodeCng();
	afx_msg void OnPdfCode1Cng();
	afx_msg void OnPdfCode2Cng();
	afx_msg void OnPdfCodeCng();
	afx_msg void OnPdfIdCng();
	afx_msg void OnPrdNameCng();
	afx_msg void OnPdfFirstUsageBtn();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	
	void HideNAUO();
	void HidePDF();
	void HideMFU();
	void HideRefDes();
public:
	afx_msg void OnBnClickedSetupUnitConvertions();
	afx_msg void OnEnChangePrdAttrs();
	afx_msg void OnEnChangePdfAttrs();
	afx_msg void OnCbnSelchangePdfCombo();
	afx_msg void OnBnClickedPdfStandard();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PRODUCTDLG_H__E8A50A11_A058_11D3_BF00_E4928F0AA116__INCLUDED_)
