// ProgramModuleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ProgramModuleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProgramModuleDlg dialog


CProgramModuleDlg::CProgramModuleDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CProgramModuleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProgramModuleDlg)
	m_sDocId = _T("");
	m_sDocName = _T("");
	m_sLabel = _T("");
	m_bRemoved = FALSE;
	m_beginDate = COleDateTime::GetCurrentTime();
	m_endDate = COleDateTime::GetCurrentTime();
	m_sContexts = _T("");
	m_sRelDscr = _T("");
	m_sRelId = _T("");
	m_sRelName = _T("");
	m_sDocRevId = _T("");
	m_beginTime = COleDateTime::GetCurrentTime();
	m_endTime = COleDateTime::GetCurrentTime();
	//}}AFX_DATA_INIT

	m_api= NULL;
	m_rel= NULL;
	m_rev= NULL;
}


void CProgramModuleDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProgramModuleDlg)
	DDX_Control(pDX, IDC_DOC_INST_TIME_REM, m_endTimeCtrl);
	DDX_Control(pDX, IDC_DOC_INST_DATE_REM, m_endDateCtrl);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Text(pDX, IDC_DOC_INST_ID, m_sDocId);
	DDX_Text(pDX, IDC_DOC_INST_NAME, m_sDocName);
	DDX_Text(pDX, IDC_DOC_INST_LABEL, m_sLabel);
	DDX_Check(pDX, IDC_DOC_INST_HAS_REMOVED, m_bRemoved);
	DDX_DateTimeCtrl(pDX, IDC_DOC_INST_DATE_INST, m_beginDate);
	DDX_DateTimeCtrl(pDX, IDC_DOC_INST_DATE_REM, m_endDate);
	DDX_Text(pDX, IDC_DOC_INST_NAMES_CONTEXTS, m_sContexts);
	DDX_Text(pDX, IDC_DOC_INST_REL_DESCR, m_sRelDscr);
	DDX_Text(pDX, IDC_DOC_INST_REL_ID, m_sRelId);
	DDX_Text(pDX, IDC_DOC_INST_REL_NAME, m_sRelName);
	DDX_Text(pDX, IDC_DOC_INST_REV, m_sDocRevId);
	DDX_DateTimeCtrl(pDX, IDC_DOC_INST_TIME_INST, m_beginTime);
	DDX_DateTimeCtrl(pDX, IDC_DOC_INST_TIME_REM, m_endTime);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProgramModuleDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CProgramModuleDlg)
	ON_BN_CLICKED(IDC_DOC_INST_HAS_REMOVED, OnDocInstHasRemoved)
	ON_BN_CLICKED(IDC_DOC_INST_SEL_CONTEXT, OnDocInstSelContext)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProgramModuleDlg message handlers

BOOL CProgramModuleDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	
	m_endDateCtrl.EnableWindow(FALSE);
	m_endTimeCtrl.EnableWindow(FALSE);

	if(m_api && m_api->m_data.IsConnected())
	{
		if(m_rel)
		{
			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_related, m_rev);
			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_id, m_sRelId);
			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_name, m_sRelName);
			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_descr, m_sRelDscr);
			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference, m_contexts);
			m_api->m_doc_mgr.PrintItemContextInString(m_contexts, m_sContexts);

			CString sDate;
			COleDateTime odt;
			
			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_date_installed, sDate);
			aplString2Date(sDate, odt);

			m_beginDate= odt;
			m_beginTime= odt;

			m_api->m_data.GetAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed, sDate);
			if(!sDate.IsEmpty())
			{
				m_bRemoved= TRUE; 

				aplString2Date(sDate, odt);

				m_endDate= odt;
				m_endTime= odt;
			}
		}

		if(m_rev)
		{
			m_api->m_data.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_id, m_sDocRevId);
			m_api->m_data.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_label, m_sLabel);
			CaplInstance* doc= NULL;
			m_api->m_data.GetAttr(m_rev, m_api->m_doc_mgr.a_apl_doc_rev_doc, doc);
			if(doc)
			{
				m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_doc_name, m_sDocName);
				m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_doc_id, m_sDocId);				
			}
		}
		
		m_endDateCtrl.EnableWindow(m_bRemoved);
		m_endTimeCtrl.EnableWindow(m_bRemoved);
		
		UpdateData(FALSE);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CProgramModuleDlg::OnOK() 
{
	UpdateData();
	
	if(!m_rel)
		m_rel= m_api->m_data.CreateInstance(m_api->m_prd_inst_mgr.e_apl_component);

	if(m_rel)
	{

		CString sDateEnd, sDateBegin;
		COleDateTime odt;
		
		odt.SetDateTime(m_beginDate.GetYear(), m_beginDate.GetMonth(), m_beginDate.GetDay(),
			m_beginTime.GetHour(), m_beginTime.GetMinute(), m_beginTime.GetSecond());
		
		aplDate2String(odt, sDateBegin);		

		if(m_bRemoved)
		{
			odt.SetDateTime(m_endDate.GetYear(), m_endDate.GetMonth(), m_endDate.GetDay(),
				m_endTime.GetHour(), m_endTime.GetMinute(), m_endTime.GetSecond());
			
			aplDate2String(odt, sDateEnd);
			
			if(sDateEnd<sDateBegin)
			{
				AfxMessageBox( APL_T("     ."), MB_OK|MB_ICONERROR);
				return;
			}
		}

		m_api->m_data.PutAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_id, m_sRelId);
		m_api->m_data.PutAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_name, m_sRelName);
		m_api->m_data.PutAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_descr, m_sRelDscr);
		m_api->m_data.PutAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference, m_contexts);
		m_api->m_data.PutAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed, sDateEnd);
		m_api->m_data.PutAttr(m_rel, m_api->m_prd_inst_mgr.a_prd_inst_rel_date_installed, sDateBegin);
	}
	
	CaplTranslateDialog::OnOK();
}

void CProgramModuleDlg::OnCancel() 
{	
	CaplTranslateDialog::OnCancel();
}

void CProgramModuleDlg::OnDocInstHasRemoved() 
{
	UpdateData();

	m_endDateCtrl.EnableWindow(m_bRemoved);
	m_endTimeCtrl.EnableWindow(m_bRemoved);
}

void CProgramModuleDlg::OnDocInstSelContext() 
{
	if(m_api->m_doc_mgr.ChangeItemContext(m_contexts))
	{
		m_api->m_doc_mgr.PrintItemContextInString(m_contexts, m_sContexts);
		UpdateData(FALSE);
	}	
}
