#pragma once
#include <apl_gui.h>
#include "resource.h"

// CReportApprovalFiledsSetupDlg dialog

class CReportApprovalFiledsSetupDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CReportApprovalFiledsSetupDlg)

public:
	CReportApprovalFiledsSetupDlg(CaplAPI *api, CWnd* pParent = NULL);   // standard constructor
	virtual ~CReportApprovalFiledsSetupDlg();

// Dialog Data
	enum { IDD = IDD_REPORT_APPROVAL_FILEDS_SETUP };

	CSortListCtrl m_list;
	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;
	CaplButton m_clear;

	CaplAPI *m_api;
	CStringArray m_saRoles;
	CStringArray m_saStatuses;

	CWnd *m_pEditWnd;
	CaplCheckComboBox m_combo;

	CString m_sPrevVal;
	CString m_sEmptyString;
	CString m_sOptionName;

	int m_nCurrentItem;
	int m_nCurrentSubItem;
	bool m_bDoNotProccessed;

	CStringArray m_saAbbr;
	int m_nOpenWithoutApproval;
	int m_nOpenWithoutDates;
	int m_nOpenWithoutSign;

protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	CString GetAbbrvForField(CString field);

	bool FillComboWithRoles(CString str);
	bool FillComboWithStatuses(CString str);

	void CreateOption();
	void CreateEditBox();
	void HideEditBox(bool bCreateVal = true);

	bool InitList();
	bool InitAnchor();
	bool InitButtons();
	bool GetAllRoles();
	bool GetAllStatuses();
	bool ChangeListStringBySetupValue(CString sField, CString Role, CString sApproval);

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()

	afx_msg void OnSize(UINT nType, int cx, int cy);
public:
	afx_msg void OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMSetfocusList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedOk();
	afx_msg void OnBnClickedClear();
};
