#pragma once
#include <afxhtml.h>
#include "Resource.h"

// CRequirementPropertiesDlg dialog

class CRequirementPropertiesDlg : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CRequirementPropertiesDlg)

public:
	CRequirementPropertiesDlg(CaplAPI *api, CaplInstance *ciReq, CaplInstance *ciParent, 
		CWnd* pParent = NULL, UINT idd = CRequirementPropertiesDlg::IDD);   // standard constructor
	virtual ~CRequirementPropertiesDlg();

// Dialog Data
	enum { IDD = IDD_REQUIREMENT_PROP };

	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;

	CaplButton m_left_align;
	CaplButton m_center_align;
	CaplButton m_right_align;

	CaplButton m_cut;
	CaplButton m_copy;
	CaplButton m_paste;

	CaplButton m_italic;
	CaplButton m_bold;
	CaplButton m_underline;

	CaplButton m_picture;
	CaplButton m_color;
	CaplButton m_choose_exec;
	CaplButton m_clear_exec;

	CaplButton m_choose_source;
	CaplButton m_del_source;

	CComboBox m_MOS;
	CComboBox m_FontName;
	CComboBox m_FontSize;

	CaplAPI *m_api;
	CaplInstance *m_ciReq;
	CaplInstance *m_ciParent;

	CString m_sId;
	CString m_sState;
	CString m_sName;
	CString m_sHTML;
	CString m_sLastUpdated;
	CString m_sMOS;
	CString m_sSourceName;
	CString m_sEqvDate;
	CString m_sDeveloper;
	CString m_sVS;
	CString m_sNotes;

	CString m_sOldVS;
	CString m_sOldDeveloper;

	CSortListCtrl m_list;

	CEdit m_stateEdit;
	CEdit m_executorEdit;
	CDateTimeCtrl m_evDateCtrl;

	bool m_bNoNeed;
	bool m_bNewRequirement;
	bool m_bReadOnlyMode;

	CaplInstance *m_ciSource;
	CaplInstance *m_ciExecutor;

protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	CImageList m_Image;
	CHtmlEditCtrl *m_pHTML;
	CaplStrMap m_Blobs;
	

	bool FillFonts();
	bool FillMOS();
	bool SetInstAttrs();
	bool CreateHTMLedit();
	bool ChangeToWin1251( CString &html );
	bool ReplaceImagesSRC(CString &html);

	bool CreateImageList();
	bool InitToolBar();

	bool SetDefaultAlign();
	bool ResetAlign(CaplButton &Btn);

	CString GetCorrectedDocumentHTML();
	bool CreateTemproryFilesForPictures(CString &html);	

	bool DeleteTemproryFiles();
	void GetSystemFonts(CStringArray &saFontList);
	bool UpdateCheckBoxes();
	void OK();

	bool AddAnchors();
	bool SetNormalInterliage(CString &html);

	bool InitList();
	bool FillDocuments();
	int AddDocument(CaplInstance *ciDoc);
	bool SetFiledsReadOnly();

	BOOL isThisOurBrowser(HWND hMyWnd);
	HWND getParentWebBrowserWnd(HWND hMyWnd);

protected:
	static BOOL CALLBACK CBEnumFonts(LPLOGFONT lplf, LPTEXTMETRIC lptm, DWORD dwType, LPARAM lpData);

	virtual void VirtualDDX(CDataExchange* pDX);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void AddAnchorVirtual();
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()

	afx_msg void OnBnClickedAlignLeft();
	afx_msg void OnBnClickedAlignCenter();
	afx_msg void OnBnClickedAlignRight();
	afx_msg void OnBnClickedItalic();
	afx_msg void OnBnClickedBold();
	afx_msg void OnBnClickedUnderline();
	afx_msg void OnBnClickedImage();

	afx_msg void OnHTMLClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTimer(UINT nIDEvent);
		
public:
	afx_msg void OnCbnSelchangeFontName();
	afx_msg void OnBnClickedCut();
	afx_msg void OnBnClickedCopy();
	afx_msg void OnBnClickedPaste();
	afx_msg void OnCbnSelchangeFontSize();
	afx_msg void OnBnClickedFontColor();
	afx_msg void OnBnClickedClearExec();
	afx_msg void OnBnClickedChooseExec();	
	afx_msg void OnBnClickedChooseSource();
	afx_msg void OnBnClickedDelSource();
};
